/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DoubleAttribute;
import com.sun.xacml.attr.IntegerAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AddFunction
extends FunctionBase {
    public static final String NAME_INTEGER_ADD = "urn:oasis:names:tc:xacml:1.0:function:integer-add";
    public static final String NAME_DOUBLE_ADD = "urn:oasis:names:tc:xacml:1.0:function:double-add";
    private static final int ID_INTEGER_ADD = 0;
    private static final int ID_DOUBLE_ADD = 1;

    public AddFunction(String string) {
        super(string, AddFunction.getId(string), AddFunction.getArgumentType(string), false, -1, 2, AddFunction.getArgumentType(string), false);
    }

    private static int getId(String string) {
        if (string.equals(NAME_INTEGER_ADD)) {
            return 0;
        }
        if (string.equals(NAME_DOUBLE_ADD)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown add function " + string);
    }

    private static String getArgumentType(String string) {
        if (string.equals(NAME_INTEGER_ADD)) {
            return "http://www.w3.org/2001/XMLSchema#integer";
        }
        return "http://www.w3.org/2001/XMLSchema#double";
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(NAME_INTEGER_ADD);
        hashSet.add(NAME_DOUBLE_ADD);
        return hashSet;
    }

    public EvaluationResult evaluate(List list, EvaluationCtx evaluationCtx) {
        AttributeValue[] attributeValueArray = new AttributeValue[list.size()];
        EvaluationResult evaluationResult = this.evalArgs(list, evaluationCtx, attributeValueArray);
        if (evaluationResult != null) {
            return evaluationResult;
        }
        switch (this.getFunctionId()) {
            case 0: {
                long l = 0L;
                for (int i = 0; i < attributeValueArray.length; ++i) {
                    long l2 = ((IntegerAttribute)attributeValueArray[i]).getValue();
                    l += l2;
                }
                evaluationResult = new EvaluationResult(new IntegerAttribute(l));
                break;
            }
            case 1: {
                double d;
                double d2 = 0.0;
                for (int i = 0; i < attributeValueArray.length; ++i) {
                    double d3 = ((DoubleAttribute)attributeValueArray[i]).getValue();
                    d2 += d3;
                }
                double d4 = Math.floor(d2);
                if (d2 - d4 == (d = d4 + 1.0) - d2) {
                    d2 = d4 % 2.0 == 0.0 ? d4 : d;
                }
                evaluationResult = new EvaluationResult(new DoubleAttribute(d2));
            }
        }
        return evaluationResult;
    }
}

