/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.combine;

import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.combine.CombiningAlgFactory;
import com.sun.xacml.combine.CombiningAlgorithm;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class BaseCombiningAlgFactory
extends CombiningAlgFactory {
    private HashMap algMap = new HashMap();

    public BaseCombiningAlgFactory() {
    }

    public BaseCombiningAlgFactory(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                CombiningAlgorithm combiningAlgorithm = (CombiningAlgorithm)iterator.next();
                this.algMap.put(combiningAlgorithm.getIdentifier().toString(), combiningAlgorithm);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("an element of the set was not an instance of CombiningAlgorithm");
            }
        }
    }

    public void addAlgorithm(CombiningAlgorithm combiningAlgorithm) {
        String string = combiningAlgorithm.getIdentifier().toString();
        if (this.algMap.containsKey(string)) {
            throw new IllegalArgumentException("algorithm already registered: " + string);
        }
        this.algMap.put(string, combiningAlgorithm);
    }

    public Set getSupportedAlgorithms() {
        return Collections.unmodifiableSet(this.algMap.keySet());
    }

    public CombiningAlgorithm createAlgorithm(URI uRI) throws UnknownIdentifierException {
        String string = uRI.toString();
        if (this.algMap.containsKey(string)) {
            return (CombiningAlgorithm)this.algMap.get(uRI.toString());
        }
        throw new UnknownIdentifierException("unknown combining algId: " + string);
    }
}

