/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import java.math.BigInteger;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Node;

public class YearMonthDurationAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#yearMonthDuration";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private static final String patternString = "(\\-)?P((\\d+)?Y)?((\\d+)?M)?";
    private static final int GROUP_SIGN = 1;
    private static final int GROUP_YEARS = 3;
    private static final int GROUP_MONTHS = 5;
    private static BigInteger big12;
    private static BigInteger bigMaxLong;
    private static Pattern pattern;
    private boolean negative;
    private long years;
    private long months;
    private long totalMonths;
    private String encodedValue = null;

    public YearMonthDurationAttribute(boolean bl, long l, long l2) throws IllegalArgumentException {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.negative = bl;
        this.years = l;
        this.months = l2;
        if (l > Integer.MAX_VALUE || l2 > Integer.MAX_VALUE) {
            if (big12 == null) {
                big12 = BigInteger.valueOf(12L);
                bigMaxLong = BigInteger.valueOf(Long.MAX_VALUE);
            }
            BigInteger bigInteger = BigInteger.valueOf(l2);
            BigInteger bigInteger2 = BigInteger.valueOf(l);
            BigInteger bigInteger3 = bigInteger2.multiply(big12).add(bigInteger);
            if (bigInteger3.compareTo(bigMaxLong) == 1) {
                throw new IllegalArgumentException("total number of months exceeds Long.MAX_VALUE");
            }
            this.totalMonths = bigInteger3.longValue();
            if (bl) {
                this.totalMonths = -this.totalMonths;
            }
        } else {
            this.totalMonths = (l * 12L + l2) * (long)(bl ? -1 : 1);
        }
    }

    public static YearMonthDurationAttribute getInstance(Node node) throws ParsingException {
        return YearMonthDurationAttribute.getInstance(node.getFirstChild().getNodeValue());
    }

    private static long parseGroup(Matcher matcher, int n) throws NumberFormatException {
        long l = 0L;
        if (matcher.start(n) != -1) {
            String string = matcher.group(n);
            l = Long.parseLong(string);
        }
        return l;
    }

    public static YearMonthDurationAttribute getInstance(String string) throws ParsingException {
        Matcher matcher;
        boolean bl;
        boolean bl2 = false;
        long l = 0L;
        long l2 = 0L;
        if (pattern == null) {
            try {
                pattern = Pattern.compile(patternString);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new ParsingException("unexpected pattern syntax error");
            }
        }
        if (!(bl = (matcher = pattern.matcher(string)).matches())) {
            throw new ParsingException("Syntax error in yearMonthDuration");
        }
        if (matcher.start(1) != -1) {
            bl2 = true;
        }
        try {
            l = YearMonthDurationAttribute.parseGroup(matcher, 3);
            l2 = YearMonthDurationAttribute.parseGroup(matcher, 5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParsingException("Unable to handle number size");
        }
        return new YearMonthDurationAttribute(bl2, l, l2);
    }

    public boolean isNegative() {
        return this.negative;
    }

    public long getYears() {
        return this.years;
    }

    public long getMonths() {
        return this.months;
    }

    public boolean equals(Object object) {
        if (!(object instanceof YearMonthDurationAttribute)) {
            return false;
        }
        YearMonthDurationAttribute yearMonthDurationAttribute = (YearMonthDurationAttribute)object;
        return this.totalMonths == yearMonthDurationAttribute.totalMonths;
    }

    public int hashCode() {
        return (int)this.totalMonths ^ (int)(this.totalMonths >> 32);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("YearMonthDurationAttribute: [\n");
        stringBuffer.append("  Negative: " + this.negative);
        stringBuffer.append("  Years: " + this.years);
        stringBuffer.append("  Months: " + this.months);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String encode() {
        if (this.encodedValue != null) {
            return this.encodedValue;
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.negative) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (this.years != 0L || this.months == 0L) {
            stringBuffer.append(Long.toString(this.years));
            stringBuffer.append('Y');
        }
        if (this.months != 0L) {
            stringBuffer.append(Long.toString(this.months));
            stringBuffer.append('M');
        }
        this.encodedValue = stringBuffer.toString();
        return this.encodedValue;
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

