/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import javax.security.auth.x500.X500Principal;
import org.w3c.dom.Node;

public class X500NameAttribute
extends AttributeValue {
    public static final String identifier = "urn:oasis:names:tc:xacml:1.0:data-type:x500Name";
    private X500Principal value;
    private static URI identifierURI;
    private static RuntimeException earlyException;

    public X500NameAttribute(X500Principal x500Principal) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = x500Principal;
    }

    public static X500NameAttribute getInstance(Node node) throws IllegalArgumentException {
        return X500NameAttribute.getInstance(node.getFirstChild().getNodeValue());
    }

    public static X500NameAttribute getInstance(String string) throws IllegalArgumentException {
        return new X500NameAttribute(new X500Principal(string));
    }

    public X500Principal getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof X500NameAttribute)) {
            return false;
        }
        X500NameAttribute x500NameAttribute = (X500NameAttribute)object;
        return this.value.equals(x500NameAttribute.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String encode() {
        return this.value.getName();
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

