/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import org.w3c.dom.Node;

public class RFC822NameAttribute
extends AttributeValue {
    public static final String identifier = "urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private String value;

    public RFC822NameAttribute(String string) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        String[] stringArray = string.split("@");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("invalid RFC822Name: " + string);
        }
        this.value = stringArray[0] + "@" + stringArray[1].toLowerCase();
    }

    public static RFC822NameAttribute getInstance(Node node) {
        return RFC822NameAttribute.getInstance(node.getFirstChild().getNodeValue());
    }

    public static RFC822NameAttribute getInstance(String string) {
        return new RFC822NameAttribute(string);
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RFC822NameAttribute)) {
            return false;
        }
        RFC822NameAttribute rFC822NameAttribute = (RFC822NameAttribute)object;
        return this.value.equals(rFC822NameAttribute.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String encode() {
        return this.value;
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

