/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import java.util.Arrays;
import org.w3c.dom.Node;

public class HexBinaryAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#hexBinary";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private byte[] value;
    private String strValue;

    public HexBinaryAttribute(byte[] byArray) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = (byte[])byArray.clone();
    }

    public static HexBinaryAttribute getInstance(Node node) throws ParsingException {
        return HexBinaryAttribute.getInstance(node.getFirstChild().getNodeValue());
    }

    public static HexBinaryAttribute getInstance(String string) throws ParsingException {
        byte[] byArray = HexBinaryAttribute.hexToBin(string);
        if (byArray == null) {
            throw new ParsingException("Couldn't parse purported hex string: " + string);
        }
        return new HexBinaryAttribute(byArray);
    }

    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    public int hashCode() {
        int n = this.value[0];
        for (int i = 1; i < this.value.length; ++i) {
            n *= 31;
            n += this.value[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HexBinaryAttribute)) {
            return false;
        }
        HexBinaryAttribute hexBinaryAttribute = (HexBinaryAttribute)object;
        return Arrays.equals(this.value, hexBinaryAttribute.value);
    }

    private static int hexToBinNibble(char c) {
        int n = -1;
        if (c >= '0' && c <= '9') {
            n = c - 48;
        } else if (c >= 'a' && c <= 'f') {
            n = c - 97 + 10;
        } else if (c >= 'A' && c <= 'F') {
            n = c - 65 + 10;
        }
        return n;
    }

    private static byte[] hexToBin(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            return null;
        }
        int n2 = n / 2;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = HexBinaryAttribute.hexToBinNibble(string.charAt(n3++));
            int n5 = HexBinaryAttribute.hexToBinNibble(string.charAt(n3++));
            if (n4 < 0 || n5 < 0) {
                return null;
            }
            byArray[i] = (byte)(n4 * 16 + n5);
        }
        return byArray;
    }

    private static char binToHexNibble(int n) {
        char c = '\u0000';
        c = n < 10 ? (char)(n + 48) : (char)(n - 10 + 65);
        return c;
    }

    private static String binToHex(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            cArray[n2++] = HexBinaryAttribute.binToHexNibble(by >> 4 & 0xF);
            cArray[n2++] = HexBinaryAttribute.binToHexNibble(by & 0xF);
        }
        return new String(cArray);
    }

    public String toString() {
        if (this.strValue == null) {
            this.strValue = HexBinaryAttribute.binToHex(this.value);
        }
        return "HexBinaryAttribute: [\n" + this.strValue + "]\n";
    }

    public String encode() {
        if (this.strValue == null) {
            this.strValue = HexBinaryAttribute.binToHex(this.value);
        }
        return this.strValue;
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

