/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import org.w3c.dom.Node;

public class BooleanAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#boolean";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private static BooleanAttribute trueInstance;
    private static BooleanAttribute falseInstance;
    private boolean value;

    private BooleanAttribute(boolean bl) {
        super(identifierURI);
        this.value = bl;
    }

    public static BooleanAttribute getInstance(Node node) throws ParsingException {
        return BooleanAttribute.getInstance(node.getFirstChild().getNodeValue());
    }

    public static BooleanAttribute getInstance(String string) throws ParsingException {
        if (earlyException != null) {
            throw earlyException;
        }
        if (string.equals("true")) {
            return trueInstance;
        }
        if (string.equals("false")) {
            return falseInstance;
        }
        throw new ParsingException("Boolean string must be true or false");
    }

    public static BooleanAttribute getInstance(boolean bl) {
        if (earlyException != null) {
            throw earlyException;
        }
        if (bl) {
            return trueInstance;
        }
        return falseInstance;
    }

    public static BooleanAttribute getTrueInstance() {
        if (earlyException != null) {
            throw earlyException;
        }
        return trueInstance;
    }

    public static BooleanAttribute getFalseInstance() {
        if (earlyException != null) {
            throw earlyException;
        }
        return falseInstance;
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BooleanAttribute)) {
            return false;
        }
        BooleanAttribute booleanAttribute = (BooleanAttribute)object;
        return this.value == booleanAttribute.value;
    }

    public int hashCode() {
        return this.value ? 1231 : 1237;
    }

    public String encode() {
        return this.value ? "true" : "false";
    }

    static {
        try {
            identifierURI = new URI(identifier);
            trueInstance = new BooleanAttribute(true);
            falseInstance = new BooleanAttribute(false);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

