/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeProxy;
import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class BaseAttributeFactory
extends AttributeFactory {
    private HashMap attributeMap = new HashMap();

    public BaseAttributeFactory() {
    }

    public BaseAttributeFactory(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                String string = iterator.next().toString();
                AttributeProxy attributeProxy = (AttributeProxy)map.get(string);
                this.attributeMap.put(string, attributeProxy);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("an element of the map was not an instance of AttributeProxy");
            }
        }
    }

    public void addDatatype(String string, AttributeProxy attributeProxy) {
        if (this.attributeMap.containsKey(string)) {
            throw new IllegalArgumentException("datatype already exists");
        }
        this.attributeMap.put(string, attributeProxy);
    }

    public Set getSupportedDatatypes() {
        return Collections.unmodifiableSet(this.attributeMap.keySet());
    }

    public AttributeValue createValue(Node node) throws UnknownIdentifierException, ParsingException {
        Node node2 = node.getAttributes().getNamedItem("DataType");
        return this.createValue(node, node2.getNodeValue());
    }

    public AttributeValue createValue(Node node, URI uRI) throws UnknownIdentifierException, ParsingException {
        return this.createValue(node, uRI.toString());
    }

    public AttributeValue createValue(Node node, String string) throws UnknownIdentifierException, ParsingException {
        AttributeProxy attributeProxy = (AttributeProxy)this.attributeMap.get(string);
        if (attributeProxy != null) {
            try {
                return attributeProxy.getInstance(node);
            }
            catch (Exception exception) {
                throw new ParsingException("couldn't create " + string + " attribute based on DOM node");
            }
        }
        throw new UnknownIdentifierException("Attributes of type " + string + " aren't supported.");
    }

    public AttributeValue createValue(URI uRI, String string) throws UnknownIdentifierException, ParsingException {
        String string2 = uRI.toString();
        AttributeProxy attributeProxy = (AttributeProxy)this.attributeMap.get(string2);
        if (attributeProxy != null) {
            try {
                return attributeProxy.getInstance(string);
            }
            catch (Exception exception) {
                throw new ParsingException("couldn't create " + string2 + " attribute from input: " + string);
            }
        }
        throw new UnknownIdentifierException("Attributes of type " + string2 + " aren't supported.");
    }
}

