/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeDesignator
implements Evaluatable {
    public static final int SUBJECT_TARGET = 0;
    public static final int RESOURCE_TARGET = 1;
    public static final int ACTION_TARGET = 2;
    public static final int ENVIRONMENT_TARGET = 3;
    public static final String SUBJECT_CATEGORY_DEFAULT = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
    private static final String[] targetTypes = new String[]{"Subject", "Resource", "Action", "Environment"};
    private int target;
    private URI type;
    private URI id;
    private URI issuer;
    private boolean mustBePresent;
    private URI subjectCategory;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$attr$AttributeDesignator == null ? (class$com$sun$xacml$attr$AttributeDesignator = AttributeDesignator.class$("com.sun.xacml.attr.AttributeDesignator")) : class$com$sun$xacml$attr$AttributeDesignator).getName());
    static /* synthetic */ Class class$com$sun$xacml$attr$AttributeDesignator;

    public AttributeDesignator(int n, URI uRI, URI uRI2, boolean bl) {
        this(n, uRI, uRI2, bl, null);
    }

    public AttributeDesignator(int n, URI uRI, URI uRI2, boolean bl, URI uRI3) throws IllegalArgumentException {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Input target is not a validvalue");
        }
        this.target = n;
        this.type = uRI;
        this.id = uRI2;
        this.mustBePresent = bl;
        this.issuer = uRI3;
        this.subjectCategory = null;
    }

    public void setSubjectCategory(URI uRI) {
        if (this.target == 0) {
            this.subjectCategory = uRI;
        }
    }

    public static AttributeDesignator getInstance(Node node, int n) throws ParsingException {
        Object object;
        URI uRI = null;
        URI uRI2 = null;
        URI uRI3 = null;
        boolean bl = false;
        URI uRI4 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            uRI2 = new URI(namedNodeMap.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception exception) {
            throw new ParsingException("Required AttributeId missing in AttributeDesignator", exception);
        }
        try {
            uRI = new URI(namedNodeMap.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception exception) {
            throw new ParsingException("Required DataType missing in AttributeDesignator", exception);
        }
        try {
            object = namedNodeMap.getNamedItem("Issuer");
            if (object != null) {
                uRI3 = new URI(object.getNodeValue());
            }
            if (n == 0) {
                Node node2 = namedNodeMap.getNamedItem("SubjectCategory");
                uRI4 = node2 != null ? new URI(node2.getNodeValue()) : new URI(SUBJECT_CATEGORY_DEFAULT);
            }
            if ((object = namedNodeMap.getNamedItem("MustBePresent")) != null && object.getNodeValue().equals("true")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new ParsingException("Error parsing AttributeDesignator optional attributes", exception);
        }
        object = new AttributeDesignator(n, uRI, uRI2, bl, uRI3);
        ((AttributeDesignator)object).setSubjectCategory(uRI4);
        return object;
    }

    public int getDesignatorType() {
        return this.target;
    }

    public URI getType() {
        return this.type;
    }

    public URI getId() {
        return this.id;
    }

    public URI getCategory() {
        return this.subjectCategory;
    }

    public URI getIssuer() {
        return this.issuer;
    }

    public boolean mustBePresent() {
        return this.mustBePresent;
    }

    public boolean evaluatesToBag() {
        return true;
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public EvaluationResult evaluate(EvaluationCtx evaluationCtx) {
        EvaluationResult evaluationResult = null;
        switch (this.target) {
            case 0: {
                evaluationResult = evaluationCtx.getSubjectAttribute(this.type, this.id, this.issuer, this.subjectCategory);
                break;
            }
            case 1: {
                evaluationResult = evaluationCtx.getResourceAttribute(this.type, this.id, this.issuer);
                break;
            }
            case 2: {
                evaluationResult = evaluationCtx.getActionAttribute(this.type, this.id, this.issuer);
                break;
            }
            case 3: {
                evaluationResult = evaluationCtx.getEnvironmentAttribute(this.type, this.id, this.issuer);
            }
        }
        if (evaluationResult.indeterminate()) {
            return evaluationResult;
        }
        BagAttribute bagAttribute = (BagAttribute)evaluationResult.getAttributeValue();
        if (bagAttribute.isEmpty() && this.mustBePresent) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("AttributeDesignator failed to resolve a value for a required attribute: " + this.id.toString());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
            String string = "Couldn't find " + targetTypes[this.target] + "AttributeDesignator attribute";
            return new EvaluationResult(new Status(arrayList, string));
        }
        return evaluationResult;
    }

    public void encode(OutputStream outputStream) {
        this.encode(outputStream, new Indenter(0));
    }

    public void encode(OutputStream outputStream, Indenter indenter) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = indenter.makeString();
        String string2 = "<" + targetTypes[this.target] + "AttributeDesignator";
        if (this.target == 0 && this.subjectCategory != null) {
            string2 = string2 + " SubjectCategory=\"" + this.subjectCategory.toString() + "\"";
        }
        string2 = string2 + " AttributeId=\"" + this.id.toString() + "\"";
        string2 = string2 + " DataType=\"" + this.type.toString() + "\"";
        if (this.issuer != null) {
            string2 = string2 + " Issuer=\"" + this.issuer.toString() + "\"";
        }
        if (this.mustBePresent) {
            string2 = string2 + " MustBePresent=\"true\"";
        }
        string2 = string2 + "/>";
        printStream.println(string + string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

