/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.DateAttribute;
import com.sun.xacml.attr.DateTimeAttribute;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.attr.TimeAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.Subject;
import com.sun.xacml.finder.AttributeFinder;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class BasicEvaluationCtx
implements EvaluationCtx {
    private AttributeFinder finder;
    private Node requestRoot;
    private HashMap subjectMap;
    private HashMap resourceMap;
    private HashMap actionMap;
    private HashMap environmentMap;
    private AttributeValue resourceId;
    private int scope;
    private DateAttribute currentDate;
    private TimeAttribute currentTime;
    private DateTimeAttribute currentDateTime;
    private boolean useCachedEnvValues;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$BasicEvaluationCtx == null ? (class$com$sun$xacml$BasicEvaluationCtx = BasicEvaluationCtx.class$("com.sun.xacml.BasicEvaluationCtx")) : class$com$sun$xacml$BasicEvaluationCtx).getName());
    static /* synthetic */ Class class$com$sun$xacml$BasicEvaluationCtx;

    public BasicEvaluationCtx(RequestCtx requestCtx) throws ParsingException {
        this(requestCtx, null, true);
    }

    public BasicEvaluationCtx(RequestCtx requestCtx, boolean bl) throws ParsingException {
        this(requestCtx, null, bl);
    }

    public BasicEvaluationCtx(RequestCtx requestCtx, AttributeFinder attributeFinder) throws ParsingException {
        this(requestCtx, attributeFinder, true);
    }

    public BasicEvaluationCtx(RequestCtx requestCtx, AttributeFinder attributeFinder, boolean bl) throws ParsingException {
        this.finder = attributeFinder;
        this.requestRoot = requestCtx.getDocumentRoot();
        this.useCachedEnvValues = bl;
        this.currentDate = null;
        this.currentTime = null;
        this.currentDateTime = null;
        this.subjectMap = new HashMap();
        this.setupSubjects(requestCtx.getSubjects());
        this.resourceMap = new HashMap();
        this.setupResource(requestCtx.getResource());
        this.actionMap = new HashMap();
        this.mapAttributes(requestCtx.getAction(), this.actionMap);
        this.environmentMap = new HashMap();
        this.mapAttributes(requestCtx.getEnvironmentAttributes(), this.environmentMap);
    }

    private void setupSubjects(Set set) throws ParsingException {
        if (set.size() == 0) {
            throw new ParsingException("Request must a contain subject");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Subject subject = (Subject)iterator.next();
            URI uRI = subject.getCategory();
            Map map = null;
            if (this.subjectMap.containsKey(uRI)) {
                map = (Map)this.subjectMap.get(uRI);
            } else {
                map = new HashMap();
                this.subjectMap.put(uRI, map);
            }
            Iterator iterator2 = subject.getAttributes().iterator();
            while (iterator2.hasNext()) {
                Set<Attribute> set2;
                Attribute attribute = (Attribute)iterator2.next();
                String string = attribute.getId().toString();
                if (map.containsKey(string)) {
                    set2 = (Set)map.get(string);
                    set2.add(attribute);
                    continue;
                }
                set2 = new HashSet();
                ((HashSet)set2).add(attribute);
                map.put(string, set2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setupResource(Set set) throws ParsingException {
        this.mapAttributes(set, this.resourceMap);
        if (!this.resourceMap.containsKey("urn:oasis:names:tc:xacml:1.0:resource:resource-id")) {
            System.err.println("Resource must contain resource-id attr");
            throw new ParsingException("resource missing resource-id");
        }
        Set set2 = (Set)this.resourceMap.get("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
        if (set2.size() > 1) {
            System.err.println("Resource may contain only one resource-id Attribute");
            throw new ParsingException("too many resource-id attrs");
        }
        this.resourceId = ((Attribute)set2.iterator().next()).getValue();
        if (!this.resourceMap.containsKey("urn:oasis:names:tc:xacml:1.0:resource:scope")) {
            this.scope = 0;
            return;
        }
        set2 = (Set)this.resourceMap.get("urn:oasis:names:tc:xacml:1.0:resource:scope");
        if (set2.size() > 1) {
            System.err.println("Resource may contain only one resource-scope Attribute");
            throw new ParsingException("too many resource-scope attrs");
        }
        Attribute attribute = (Attribute)set2.iterator().next();
        AttributeValue attributeValue = attribute.getValue();
        if (!attributeValue.getType().toString().equals("http://www.w3.org/2001/XMLSchema#string")) {
            throw new ParsingException("scope attr must be a string");
        }
        String string = ((StringAttribute)attributeValue).getValue();
        if (string.equals("Immediate")) {
            this.scope = 0;
            return;
        }
        if (string.equals("Children")) {
            this.scope = 1;
            return;
        }
        if (string.equals("Descendants")) {
            this.scope = 2;
            return;
        }
        System.err.println("Unknown scope type: " + string);
        throw new ParsingException("invalid scope type: " + string);
    }

    private void mapAttributes(Set set, Map map) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Set<Attribute> set2;
            Attribute attribute = (Attribute)iterator.next();
            String string = attribute.getId().toString();
            if (map.containsKey(string)) {
                set2 = (Set)map.get(string);
                set2.add(attribute);
                continue;
            }
            set2 = new HashSet();
            set2.add(attribute);
            map.put(string, set2);
        }
    }

    public AttributeFinder getAttributeFinder() {
        return this.finder;
    }

    public Node getRequestRoot() {
        return this.requestRoot;
    }

    public AttributeValue getResourceId() {
        return this.resourceId;
    }

    public int getScope() {
        return this.scope;
    }

    public void setResourceId(AttributeValue attributeValue) {
        this.resourceId = attributeValue;
        Set set = (Set)this.resourceMap.get("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
        Attribute attribute = (Attribute)set.iterator().next();
        set.remove(attribute);
        set.add(new Attribute(attribute.getId(), attribute.getIssuer(), attribute.getIssueInstant(), attributeValue));
    }

    public TimeAttribute getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(TimeAttribute timeAttribute) {
        if (this.useCachedEnvValues) {
            this.currentTime = timeAttribute;
        }
    }

    public DateAttribute getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(DateAttribute dateAttribute) {
        if (this.useCachedEnvValues) {
            this.currentDate = dateAttribute;
        }
    }

    public DateTimeAttribute getCurrentDateTime() {
        return this.currentDateTime;
    }

    public void setCurrentDateTime(DateTimeAttribute dateTimeAttribute) {
        if (this.useCachedEnvValues) {
            this.currentDateTime = dateTimeAttribute;
        }
    }

    public EvaluationResult getSubjectAttribute(URI uRI, URI uRI2, URI uRI3) {
        return this.getSubjectAttribute(uRI, uRI2, null, uRI3);
    }

    public EvaluationResult getSubjectAttribute(URI uRI, URI uRI2, URI uRI3, URI uRI4) {
        Map map = (Map)this.subjectMap.get(uRI4);
        if (map == null) {
            return this.callHelper(uRI, uRI2, uRI3, uRI4, 0);
        }
        return this.getGenericAttributes(uRI, uRI2, uRI3, map, uRI4, 0);
    }

    public EvaluationResult getResourceAttribute(URI uRI, URI uRI2, URI uRI3) {
        return this.getGenericAttributes(uRI, uRI2, uRI3, this.resourceMap, null, 1);
    }

    public EvaluationResult getActionAttribute(URI uRI, URI uRI2, URI uRI3) {
        return this.getGenericAttributes(uRI, uRI2, uRI3, this.actionMap, null, 2);
    }

    public EvaluationResult getEnvironmentAttribute(URI uRI, URI uRI2, URI uRI3) {
        return this.getGenericAttributes(uRI, uRI2, uRI3, this.environmentMap, null, 3);
    }

    private EvaluationResult getGenericAttributes(URI uRI, URI uRI2, URI uRI3, Map map, URI uRI4, int n) {
        Set set = (Set)map.get(uRI2.toString());
        if (set == null) {
            return this.callHelper(uRI, uRI2, uRI3, uRI4, n);
        }
        ArrayList<AttributeValue> arrayList = new ArrayList<AttributeValue>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getType().equals(uRI) || uRI3 != null && (attribute.getIssuer() == null || !attribute.getIssuer().equals(uRI3.toString()))) continue;
            arrayList.add(attribute.getValue());
        }
        if (arrayList.size() == 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attribute not in request: " + uRI2.toString() + " ... querying AttributeFinder");
            }
            return this.callHelper(uRI, uRI2, uRI3, uRI4, n);
        }
        return new EvaluationResult(new BagAttribute(uRI, arrayList));
    }

    private EvaluationResult callHelper(URI uRI, URI uRI2, URI uRI3, URI uRI4, int n) {
        if (this.finder != null) {
            return this.finder.findAttribute(uRI, uRI2, uRI3, uRI4, this, n);
        }
        logger.warning("Context tried to invoke AttributeFinder but was not configured with one");
        return new EvaluationResult(BagAttribute.createEmptyBag(uRI));
    }

    public EvaluationResult getAttribute(String string, Node node, URI uRI, String string2) {
        if (this.finder != null) {
            return this.finder.findAttribute(string, node, uRI, this, string2);
        }
        logger.warning("Context tried to invoke AttributeFinder but was not configured with one");
        return new EvaluationResult(BagAttribute.createEmptyBag(uRI));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

