/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.MatchResult;
import com.sun.xacml.Obligation;
import com.sun.xacml.ParsingException;
import com.sun.xacml.PolicyTreeElement;
import com.sun.xacml.Target;
import com.sun.xacml.combine.CombiningAlgFactory;
import com.sun.xacml.combine.CombiningAlgorithm;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.combine.RuleCombiningAlgorithm;
import com.sun.xacml.ctx.Result;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractPolicy
implements PolicyTreeElement {
    public static final String XPATH_1_0_VERSION = "http://www.w3.org/TR/1999/Rec-xpath-19991116";
    private URI idAttr;
    private CombiningAlgorithm combiningAlg;
    private String description;
    private Target target;
    private String defaultVersion;
    private List children;
    private Set obligations;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$AbstractPolicy == null ? (class$com$sun$xacml$AbstractPolicy = AbstractPolicy.class$("com.sun.xacml.AbstractPolicy")) : class$com$sun$xacml$AbstractPolicy).getName());
    static /* synthetic */ Class class$com$sun$xacml$AbstractPolicy;

    protected AbstractPolicy() {
    }

    protected AbstractPolicy(URI uRI, CombiningAlgorithm combiningAlgorithm, String string, Target target) {
        this(uRI, combiningAlgorithm, string, target, null);
    }

    protected AbstractPolicy(URI uRI, CombiningAlgorithm combiningAlgorithm, String string, Target target, String string2) {
        this(uRI, combiningAlgorithm, string, target, string2, null);
    }

    protected AbstractPolicy(URI uRI, CombiningAlgorithm combiningAlgorithm, String string, Target target, String string2, Set set) {
        this.idAttr = uRI;
        this.combiningAlg = combiningAlgorithm;
        this.description = string;
        this.target = target;
        this.defaultVersion = string2;
        this.obligations = set == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(set));
    }

    protected AbstractPolicy(Node node, String string, String string2) throws ParsingException {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            this.idAttr = new URI(namedNodeMap.getNamedItem(string + "Id").getNodeValue());
        }
        catch (Exception exception) {
            throw new ParsingException("Error parsing required attribute " + string + "Id", exception);
        }
        try {
            object = new URI(namedNodeMap.getNamedItem(string2).getNodeValue());
            CombiningAlgFactory combiningAlgFactory = CombiningAlgFactory.getInstance();
            this.combiningAlg = combiningAlgFactory.createAlgorithm((URI)object);
        }
        catch (Exception exception) {
            throw new ParsingException("Error parsing combining algorithm in " + string, exception);
        }
        if (string.equals("Policy")) {
            if (!(this.combiningAlg instanceof RuleCombiningAlgorithm)) {
                throw new ParsingException("Policy must use a Rule Combining Algorithm");
            }
        } else if (!(this.combiningAlg instanceof PolicyCombiningAlgorithm)) {
            throw new ParsingException("PolicySet must use a Policy Combining Algorithm");
        }
        this.obligations = new HashSet();
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            String string3 = node2.getNodeName();
            if (string3.equals("Description")) {
                this.description = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string3.equals("Target")) {
                this.target = Target.getInstance(node2, this.defaultVersion);
                continue;
            }
            if (string3.equals("Obligations")) {
                this.parseObligations(node2);
                continue;
            }
            if (!string3.equals(string + "Defaults")) continue;
            this.handleDefaults(node2);
        }
        this.obligations = Collections.unmodifiableSet(this.obligations);
    }

    private void parseObligations(Node node) throws ParsingException {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("Obligation")) continue;
            this.obligations.add(Obligation.getInstance(node2));
        }
    }

    private void handleDefaults(Node node) throws ParsingException {
        this.defaultVersion = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("XPathVersion")) continue;
            this.defaultVersion = node2.getFirstChild().getNodeValue();
            if (this.defaultVersion.equals(XPATH_1_0_VERSION)) continue;
            throw new ParsingException("Unknown XPath version");
        }
    }

    public URI getId() {
        return this.idAttr;
    }

    public CombiningAlgorithm getCombiningAlg() {
        return this.combiningAlg;
    }

    public String getDescription() {
        return this.description;
    }

    public Target getTarget() {
        return this.target;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public List getChildren() {
        return this.children;
    }

    public Set getObligations() {
        return this.obligations;
    }

    public MatchResult match(EvaluationCtx evaluationCtx) {
        return this.target.match(evaluationCtx);
    }

    protected void setChildren(List list) {
        this.children = list == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(list);
    }

    public Result evaluate(EvaluationCtx evaluationCtx) {
        Result result = this.combiningAlg.combine(evaluationCtx, this.children);
        if (this.obligations.size() == 0) {
            return result;
        }
        int n = result.getDecision();
        if (n == 2 || n == 3) {
            return result;
        }
        Iterator iterator = this.obligations.iterator();
        while (iterator.hasNext()) {
            Obligation obligation = (Obligation)iterator.next();
            if (obligation.getFulfillOn() != n) continue;
            result.addObligation(obligation);
        }
        return result;
    }

    protected void encodeCommonElements(OutputStream outputStream, Indenter indenter) {
        this.target.encode(outputStream, indenter);
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            ((PolicyTreeElement)iterator.next()).encode(outputStream, indenter);
        }
        if (this.obligations.size() != 0) {
            PrintStream printStream = new PrintStream(outputStream);
            String string = indenter.makeString();
            printStream.println(string + "<Obligations>");
            indenter.in();
            iterator = this.obligations.iterator();
            while (iterator.hasNext()) {
                ((Obligation)iterator.next()).encode(outputStream, indenter);
            }
            printStream.println(string + "</Obligations>");
            indenter.out();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

