/*
 * Decompiled with CFR 0.152.
 */
package tom.engine.adt.tomsignature.types.tomentry;

import aterm.ATerm;
import aterm.ATermAppl;
import shared.HashFunctions;
import shared.SharedObject;
import tom.engine.adt.tomsignature.TomSignatureAbstractType;
import tom.engine.adt.tomsignature.types.TomEntry;
import tom.engine.adt.tomsignature.types.TomSymbol;
import tom.library.sl.Visitable;

public final class Entry
extends TomEntry
implements Visitable {
    private int hashCode;
    private static Entry proto = new Entry();
    private String _StrName;
    private TomSymbol _AstSymbol;

    private Entry() {
    }

    public static Entry make(String _StrName, TomSymbol _AstSymbol) {
        proto.initHashCode(_StrName, _AstSymbol);
        return (Entry)factory.build((SharedObject)proto);
    }

    private void init(String _StrName, TomSymbol _AstSymbol, int hashCode) {
        this._StrName = _StrName.intern();
        this._AstSymbol = _AstSymbol;
        this.hashCode = hashCode;
    }

    private void initHashCode(String _StrName, TomSymbol _AstSymbol) {
        this._StrName = _StrName.intern();
        this._AstSymbol = _AstSymbol;
        this.hashCode = this.hashFunction();
    }

    public String symbolName() {
        return "Entry";
    }

    private int getArity() {
        return 2;
    }

    public SharedObject duplicate() {
        Entry clone = new Entry();
        clone.init(this._StrName, this._AstSymbol, this.hashCode);
        return clone;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("Entry(");
        buffer.append('\"');
        block11: for (int i = 0; i < this._StrName.length(); ++i) {
            char c = this._StrName.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block11;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block11;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block11;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block11;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block11;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block11;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block11;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block11;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block11;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block11;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        this._AstSymbol.toStringBuffer(buffer);
        buffer.append(")");
    }

    public int compareToLPO(Object o) {
        TomSignatureAbstractType ao = (TomSignatureAbstractType)o;
        if (ao == this) {
            return 0;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        Entry tco = (Entry)ao;
        int _StrNameCmp = this._StrName.compareTo(tco._StrName);
        if (_StrNameCmp != 0) {
            return _StrNameCmp;
        }
        int _AstSymbolCmp = this._AstSymbol.compareToLPO(tco._AstSymbol);
        if (_AstSymbolCmp != 0) {
            return _AstSymbolCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public int compareTo(Object o) {
        TomSignatureAbstractType ao = (TomSignatureAbstractType)o;
        if (ao == this) {
            return 0;
        }
        if (this.hashCode != ao.hashCode()) {
            return this.hashCode < ao.hashCode() ? -1 : 1;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        Entry tco = (Entry)ao;
        int _StrNameCmp = this._StrName.compareTo(tco._StrName);
        if (_StrNameCmp != 0) {
            return _StrNameCmp;
        }
        int _AstSymbolCmp = this._AstSymbol.compareTo(tco._AstSymbol);
        if (_AstSymbolCmp != 0) {
            return _AstSymbolCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equivalent(SharedObject obj) {
        if (obj instanceof Entry) {
            Entry peer = (Entry)obj;
            return this._StrName == peer._StrName && this._AstSymbol == peer._AstSymbol;
        }
        return false;
    }

    public boolean isEntry() {
        return true;
    }

    public String getStrName() {
        return this._StrName;
    }

    public TomEntry setStrName(String set_arg) {
        return Entry.make(set_arg, this._AstSymbol);
    }

    public TomSymbol getAstSymbol() {
        return this._AstSymbol;
    }

    public TomEntry setAstSymbol(TomSymbol set_arg) {
        return Entry.make(this._StrName, set_arg);
    }

    public ATerm toATerm() {
        return atermFactory.makeAppl(atermFactory.makeAFun(this.symbolName(), this.getArity(), false), new ATerm[]{atermFactory.makeAppl(atermFactory.makeAFun(this.getStrName(), 0, true)), this.getAstSymbol().toATerm()});
    }

    public static TomEntry fromTerm(ATerm trm) {
        if (trm instanceof ATermAppl) {
            ATermAppl appl = (ATermAppl)trm;
            if (proto.symbolName().equals(appl.getName())) {
                return Entry.make(((ATermAppl)appl.getArgument(0)).getAFun().getName(), TomSymbol.fromTerm(appl.getArgument(1)));
            }
        }
        return null;
    }

    public int getChildCount() {
        return 1;
    }

    public Visitable getChildAt(int index) {
        switch (index) {
            case 0: {
                return this._AstSymbol;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildAt(int index, Visitable v) {
        switch (index) {
            case 0: {
                return Entry.make(this.getStrName(), (TomSymbol)v);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildren(Visitable[] childs) {
        if (childs.length == 1) {
            return Entry.make(this.getStrName(), (TomSymbol)childs[0]);
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable[] getChildren() {
        return new Visitable[]{this._AstSymbol};
    }

    protected int hashFunction() {
        int a = -1640531527;
        int b = -1473564672;
        int c = this.getArity();
        a += HashFunctions.stringHashFunction((String)this._StrName, (int)1) << 8;
        a += this._AstSymbol.hashCode();
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

