/*
 * Decompiled with CFR 0.152.
 */
package tom.engine.adt.tomsignature.types.targetlanguage;

import aterm.ATerm;
import aterm.ATermAppl;
import shared.HashFunctions;
import shared.SharedObject;
import tom.engine.adt.tomsignature.TomSignatureAbstractType;
import tom.engine.adt.tomsignature.types.Position;
import tom.engine.adt.tomsignature.types.TargetLanguage;
import tom.library.sl.Visitable;

public final class TL
extends TargetLanguage
implements Visitable {
    private int hashCode;
    private static TL proto = new TL();
    private String _Code;
    private Position _Start;
    private Position _End;

    private TL() {
    }

    public static TL make(String _Code, Position _Start, Position _End2) {
        proto.initHashCode(_Code, _Start, _End2);
        return (TL)factory.build((SharedObject)proto);
    }

    private void init(String _Code, Position _Start, Position _End2, int hashCode) {
        this._Code = _Code.intern();
        this._Start = _Start;
        this._End = _End2;
        this.hashCode = hashCode;
    }

    private void initHashCode(String _Code, Position _Start, Position _End2) {
        this._Code = _Code.intern();
        this._Start = _Start;
        this._End = _End2;
        this.hashCode = this.hashFunction();
    }

    public String symbolName() {
        return "TL";
    }

    private int getArity() {
        return 3;
    }

    public SharedObject duplicate() {
        TL clone = new TL();
        clone.init(this._Code, this._Start, this._End, this.hashCode);
        return clone;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("TL(");
        buffer.append('\"');
        block11: for (int i = 0; i < this._Code.length(); ++i) {
            char c = this._Code.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block11;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block11;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block11;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block11;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block11;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block11;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block11;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block11;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block11;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block11;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        this._Start.toStringBuffer(buffer);
        buffer.append(",");
        this._End.toStringBuffer(buffer);
        buffer.append(")");
    }

    public int compareToLPO(Object o) {
        TomSignatureAbstractType ao = (TomSignatureAbstractType)o;
        if (ao == this) {
            return 0;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        TL tco = (TL)ao;
        int _CodeCmp = this._Code.compareTo(tco._Code);
        if (_CodeCmp != 0) {
            return _CodeCmp;
        }
        int _StartCmp = this._Start.compareToLPO(tco._Start);
        if (_StartCmp != 0) {
            return _StartCmp;
        }
        int _EndCmp = this._End.compareToLPO(tco._End);
        if (_EndCmp != 0) {
            return _EndCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public int compareTo(Object o) {
        TomSignatureAbstractType ao = (TomSignatureAbstractType)o;
        if (ao == this) {
            return 0;
        }
        if (this.hashCode != ao.hashCode()) {
            return this.hashCode < ao.hashCode() ? -1 : 1;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        TL tco = (TL)ao;
        int _CodeCmp = this._Code.compareTo(tco._Code);
        if (_CodeCmp != 0) {
            return _CodeCmp;
        }
        int _StartCmp = this._Start.compareTo(tco._Start);
        if (_StartCmp != 0) {
            return _StartCmp;
        }
        int _EndCmp = this._End.compareTo(tco._End);
        if (_EndCmp != 0) {
            return _EndCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equivalent(SharedObject obj) {
        if (obj instanceof TL) {
            TL peer = (TL)obj;
            return this._Code == peer._Code && this._Start == peer._Start && this._End == peer._End;
        }
        return false;
    }

    public boolean isTL() {
        return true;
    }

    public String getCode() {
        return this._Code;
    }

    public TargetLanguage setCode(String set_arg) {
        return TL.make(set_arg, this._Start, this._End);
    }

    public Position getStart() {
        return this._Start;
    }

    public TargetLanguage setStart(Position set_arg) {
        return TL.make(this._Code, set_arg, this._End);
    }

    public Position getEnd() {
        return this._End;
    }

    public TargetLanguage setEnd(Position set_arg) {
        return TL.make(this._Code, this._Start, set_arg);
    }

    public ATerm toATerm() {
        return atermFactory.makeAppl(atermFactory.makeAFun(this.symbolName(), this.getArity(), false), new ATerm[]{atermFactory.makeAppl(atermFactory.makeAFun(this.getCode(), 0, true)), this.getStart().toATerm(), this.getEnd().toATerm()});
    }

    public static TargetLanguage fromTerm(ATerm trm) {
        if (trm instanceof ATermAppl) {
            ATermAppl appl = (ATermAppl)trm;
            if (proto.symbolName().equals(appl.getName())) {
                return TL.make(((ATermAppl)appl.getArgument(0)).getAFun().getName(), Position.fromTerm(appl.getArgument(1)), Position.fromTerm(appl.getArgument(2)));
            }
        }
        return null;
    }

    public int getChildCount() {
        return 2;
    }

    public Visitable getChildAt(int index) {
        switch (index) {
            case 0: {
                return this._Start;
            }
            case 1: {
                return this._End;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildAt(int index, Visitable v) {
        switch (index) {
            case 0: {
                return TL.make(this.getCode(), (Position)v, this._End);
            }
            case 1: {
                return TL.make(this.getCode(), this._Start, (Position)v);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildren(Visitable[] childs) {
        if (childs.length == 2) {
            return TL.make(this.getCode(), (Position)childs[0], (Position)childs[1]);
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable[] getChildren() {
        return new Visitable[]{this._Start, this._End};
    }

    protected int hashFunction() {
        int a = -1640531527;
        int b = -1434834176;
        int c = this.getArity();
        a += HashFunctions.stringHashFunction((String)this._Code, (int)2) << 16;
        a += this._Start.hashCode() << 8;
        a += this._End.hashCode();
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

