/*
 * Decompiled with CFR 0.152.
 */
package tom.engine.adt.tomsignature.types;

import aterm.ATerm;
import java.io.IOException;
import java.io.InputStream;
import tom.engine.adt.tomsignature.TomSignatureAbstractType;
import tom.engine.adt.tomsignature.TomSignatureVisitor;
import tom.engine.adt.tomsignature.types.TomSymbol;
import tom.engine.adt.tomsignature.types.keyentry.UsedSymbolConstructor;
import tom.engine.adt.tomsignature.types.keyentry.UsedSymbolDestructor;
import tom.engine.adt.tomsignature.types.keyentry.UsedTypeDefinition;
import tom.engine.adt.tomtype.types.TomTypeDefinition;
import tom.library.sl.VisitFailure;

public abstract class KeyEntry
extends TomSignatureAbstractType {
    public TomSignatureAbstractType accept(TomSignatureVisitor v) throws VisitFailure {
        return v.visit_KeyEntry(this);
    }

    public boolean isUsedSymbolConstructor() {
        return false;
    }

    public boolean isUsedSymbolDestructor() {
        return false;
    }

    public boolean isUsedTypeDefinition() {
        return false;
    }

    public TomTypeDefinition getTypedef() {
        throw new UnsupportedOperationException("This KeyEntry has no Typedef");
    }

    public KeyEntry setTypedef(TomTypeDefinition _arg) {
        throw new UnsupportedOperationException("This KeyEntry has no Typedef");
    }

    public TomSymbol getSymbol() {
        throw new UnsupportedOperationException("This KeyEntry has no Symbol");
    }

    public KeyEntry setSymbol(TomSymbol _arg) {
        throw new UnsupportedOperationException("This KeyEntry has no Symbol");
    }

    public static KeyEntry fromTerm(ATerm trm) {
        KeyEntry tmp = UsedSymbolConstructor.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = UsedSymbolDestructor.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = UsedTypeDefinition.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        throw new IllegalArgumentException("This is not a KeyEntry " + trm);
    }

    public static KeyEntry fromString(String s) {
        return KeyEntry.fromTerm(atermFactory.parse(s));
    }

    public static KeyEntry fromStream(InputStream stream) throws IOException {
        return KeyEntry.fromTerm(atermFactory.readFromFile(stream));
    }

    public int length() {
        throw new IllegalArgumentException("This " + this.getClass().getName() + " is not a list");
    }

    public KeyEntry reverse() {
        throw new IllegalArgumentException("This " + this.getClass().getName() + " is not a list");
    }
}

