/*
 * Decompiled with CFR 0.152.
 */
package tom.engine.adt.tomconstraint.types.constraint;

import aterm.ATerm;
import aterm.ATermAppl;
import tom.engine.adt.tomconstraint.types.Constraint;
import tom.engine.adt.tomconstraint.types.constraint.ConsAndConstraint;
import tom.engine.adt.tomconstraint.types.constraint.EmptyAndConstraint;

public abstract class AndConstraint
extends Constraint {
    public int length() {
        if (this instanceof ConsAndConstraint) {
            Constraint tl = ((ConsAndConstraint)this).getTailAndConstraint();
            if (tl instanceof AndConstraint) {
                return 1 + ((AndConstraint)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public Constraint[] toArray() {
        Constraint[] array;
        if (this instanceof ConsAndConstraint) {
            Constraint h = ((ConsAndConstraint)this).getHeadAndConstraint();
            Constraint tl = ((ConsAndConstraint)this).getTailAndConstraint();
            if (tl instanceof AndConstraint) {
                Constraint[] tailArray = ((AndConstraint)tl).toArray();
                array = new Constraint[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new Constraint[]{h};
            }
        } else {
            array = new Constraint[]{};
        }
        return array;
    }

    public static Constraint fromArray(Constraint[] array) {
        Constraint res = EmptyAndConstraint.make();
        int i = array.length;
        while (i > 0) {
            res = ConsAndConstraint.make(array[--i], res);
        }
        return res;
    }

    public Constraint reverse() {
        if (this instanceof ConsAndConstraint) {
            Constraint cur = this;
            Constraint rev = EmptyAndConstraint.make();
            while (cur instanceof ConsAndConstraint) {
                rev = ConsAndConstraint.make(((ConsAndConstraint)cur).getHeadAndConstraint(), rev);
                cur = ((ConsAndConstraint)cur).getTailAndConstraint();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("AndConstraint(");
        if (this instanceof ConsAndConstraint) {
            Constraint cur = this;
            while (cur instanceof ConsAndConstraint) {
                Constraint elem = ((ConsAndConstraint)cur).getHeadAndConstraint();
                cur = ((ConsAndConstraint)cur).getTailAndConstraint();
                elem.toStringBuffer(buffer);
                if (!(cur instanceof ConsAndConstraint)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyAndConstraint)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static Constraint fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "AndConstraint".equals((appl = (ATermAppl)trm).getName())) {
            Constraint res = EmptyAndConstraint.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                Constraint elem = Constraint.fromTerm(array[i]);
                res = ConsAndConstraint.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

