/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.antlr;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.LoaderUtils;
import org.apache.tools.ant.util.TeeOutputStream;

public class ANTLR3
extends Task {
    private CommandlineJava commandline = new CommandlineJava();
    private File target = null;
    private File outputDirectory = null;
    private File libDirectory = null;
    private File superGrammar;
    private boolean fork;
    private String messageFormatName;
    private boolean diagnostic;
    private boolean trace;
    private boolean traceParser;
    private boolean traceLexer;
    private File workingdir = null;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private boolean debug;
    private boolean report;
    private boolean print;
    private boolean profile;
    private boolean nfa;
    private boolean dfa;
    private boolean multiThreaded;
    private boolean grammarTree;
    private FileUtils fileUtils;

    public ANTLR3() {
        this.commandline.setVm(JavaEnvUtils.getJreExecutable((String)"java"));
        this.commandline.setClassname("org.antlr.Tool");
        this.fileUtils = FileUtils.getFileUtils();
    }

    public void setTarget(File file) {
        this.log("Setting target to: " + file.toString(), 3);
        this.target = file;
    }

    public void setOutputdirectory(File file) {
        this.log("Setting output directory to: " + file.toString(), 3);
        this.outputDirectory = file;
    }

    public void setLibdirectory(File file) {
        this.log("Setting lib directory to: " + file.toString(), 3);
        this.libDirectory = file;
    }

    public void setMessageformat(String string) {
        this.log("Setting message-format to: " + string, 3);
        this.messageFormatName = string;
    }

    public void setGlib(File file) {
        this.superGrammar = file;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setReport(boolean bl) {
        this.report = bl;
    }

    public void setPrint(boolean bl) {
        this.print = bl;
    }

    public void setProfile(boolean bl) {
        this.profile = bl;
    }

    public void setNfa(boolean bl) {
        this.nfa = bl;
    }

    public void setDfa(boolean bl) {
        this.dfa = bl;
    }

    public void setMultithreaded(boolean bl) {
        this.multiThreaded = bl;
    }

    public void setGrammartree(boolean bl) {
        this.grammarTree = bl;
    }

    public void setDiagnostic(boolean bl) {
        this.diagnostic = bl;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void setTraceParser(boolean bl) {
        this.traceParser = bl;
    }

    public void setTraceLexer(boolean bl) {
        this.traceLexer = bl;
    }

    public void setFork(boolean bl) {
        this.fork = bl;
    }

    public void setDir(File file) {
        this.workingdir = file;
    }

    public Path createClasspath() {
        return this.commandline.createClasspath(this.getProject()).createPath();
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    public void init() throws BuildException {
        this.addClasspathEntry("/antlr/ANTLRGrammarParseBehavior.class");
        this.addClasspathEntry("/org/antlr/tool/ANTLRParser.class");
        this.addClasspathEntry("/org/antlr/stringtemplate/StringTemplate.class");
    }

    protected void addClasspathEntry(String string) {
        string = string.startsWith("/") ? string.substring(1) : "org/apache/tools/ant/taskdefs/optional/" + string;
        File file = LoaderUtils.getResourceSource((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)string);
        if (file != null) {
            this.log("Found " + file.getAbsolutePath(), 3);
            this.createClasspath().setLocation(file);
        } else {
            this.log("Couldn't find " + string, 3);
        }
    }

    public void execute() throws BuildException {
        boolean bl;
        this.validateAttributes();
        File file = this.getGeneratedFile();
        boolean bl2 = !this.fileUtils.isUpToDate(this.target, file);
        boolean bl3 = bl = this.superGrammar != null && this.superGrammar.lastModified() > file.lastModified();
        if (bl2 || bl) {
            if (bl2) {
                this.log("Compiling " + this.target + " as it is newer than " + file, 3);
            } else if (bl) {
                this.log("Compiling " + this.target + " as " + this.superGrammar + " is newer than " + file, 3);
            }
            this.populateAttributes();
            this.commandline.createArgument().setValue(this.target.toString());
            this.log(this.commandline.describeCommand(), 3);
            int n = this.run(this.commandline.getCommandline());
            if (n != 0) {
                throw new BuildException("ANTLR3 returned: " + n, this.getLocation());
            }
            String string = this.bos.toString();
            if (string.indexOf("error:") > -1) {
                throw new BuildException("ANTLR3 signaled an error: " + string, this.getLocation());
            }
        } else {
            this.log("Skipped grammar file. Generated file " + file + " is newer.", 3);
        }
    }

    private void populateAttributes() {
        this.commandline.createArgument().setValue("-o");
        this.commandline.createArgument().setValue(this.outputDirectory.toString());
        this.commandline.createArgument().setValue("-lib");
        this.commandline.createArgument().setValue(this.libDirectory.toString());
        if (this.superGrammar != null) {
            this.commandline.createArgument().setValue("-glib");
            this.commandline.createArgument().setValue(this.superGrammar.toString());
        }
        if (this.diagnostic) {
            this.commandline.createArgument().setValue("-diagnostic");
        }
        if (this.trace) {
            this.commandline.createArgument().setValue("-trace");
        }
        if (this.traceParser) {
            this.commandline.createArgument().setValue("-traceParser");
        }
        if (this.traceLexer) {
            this.commandline.createArgument().setValue("-traceLexer");
        }
        if (this.debug) {
            this.commandline.createArgument().setValue("-debug");
        }
        if (this.report) {
            this.commandline.createArgument().setValue("-report");
        }
        if (this.print) {
            this.commandline.createArgument().setValue("-print");
        }
        if (this.profile) {
            this.commandline.createArgument().setValue("-profile");
        }
        if (this.messageFormatName != null) {
            this.commandline.createArgument().setValue("-message-format");
            this.commandline.createArgument().setValue(this.messageFormatName);
        }
        if (this.nfa) {
            this.commandline.createArgument().setValue("-nfa");
        }
        if (this.dfa) {
            this.commandline.createArgument().setValue("-dfa");
        }
        if (this.multiThreaded) {
            this.commandline.createArgument().setValue("-Xmultithreaded");
        }
        if (this.grammarTree) {
            this.commandline.createArgument().setValue("-Xgrtree");
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.target == null) {
            throw new BuildException("No target grammar, lexer grammar or tree parser specified!");
        }
        if (!this.target.isFile()) {
            throw new BuildException("Target: " + this.target + " is not a file!");
        }
        if (this.outputDirectory == null) {
            this.setOutputdirectory(new File(this.target.getParent()));
        }
        if (!this.outputDirectory.isDirectory()) {
            throw new BuildException("Invalid output directory: " + this.outputDirectory);
        }
        if (this.workingdir != null && !this.workingdir.isDirectory()) {
            throw new BuildException("Invalid working directory: " + this.workingdir);
        }
        if (this.libDirectory == null) {
            this.setLibdirectory(new File(this.target.getParent()));
        }
        if (!this.libDirectory.isDirectory()) {
            throw new BuildException("Invalid lib directory: " + this.libDirectory);
        }
    }

    private File getGeneratedFile() throws BuildException {
        String string = null;
        Pattern pattern = Pattern.compile("^\\p{javaWhitespace}*(grammar|lexer\\p{javaWhitespace}+grammar|tree\\p{javaWhitespace}+grammar)\\p{javaWhitespace}+\\w+\\p{javaWhitespace}*;.*$", 130);
        Matcher matcher = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.target));
        }
        catch (IOException iOException) {
            throw new BuildException("Could not open file:" + this.target + " for reading!");
        }
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                matcher = pattern.matcher(string2);
                this.log("Trying to match grammar in '" + string2 + "'", 3);
                if (!matcher.matches()) continue;
                String string3 = string2.trim();
                string3 = string3.startsWith("lexer") ? "Lexer" : (string3.startsWith("tree") ? "" : "Parser");
                this.log("Matched '" + string3 + " grammar' in '" + string2 + "'", 3);
                pattern = Pattern.compile("^\\p{javaWhitespace}*(grammar|lexer\\p{javaWhitespace}+grammar|tree\\p{javaWhitespace}+grammar)\\p{javaWhitespace}+", 130);
                matcher.usePattern(pattern);
                int n = -1;
                if (!matcher.lookingAt()) continue;
                n = matcher.end();
                this.log("Start index of grammar filename at position " + n, 3);
                int n2 = string2.indexOf(";");
                this.log("End index of grammar filename at position " + n2, 3);
                string = string2.substring(n, n2).trim() + string3;
                this.log("Grammar file name extracted: '" + string + "'", 3);
                break;
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to read from file: " + this.target, (Throwable)iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new BuildException("Could not close file: " + this.target + " after reading!", (Throwable)iOException);
            }
        }
        if (string == null) {
            throw new BuildException("Unable to determine generated class");
        }
        return new File(this.outputDirectory, string + ".java");
    }

    private int run(String[] stringArray) throws BuildException {
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)new LogOutputStream((Task)this, 2), (OutputStream)new TeeOutputStream((OutputStream)new LogOutputStream((Task)this, 1), (OutputStream)this.bos));
        Execute execute = new Execute((ExecuteStreamHandler)pumpStreamHandler, null);
        execute.setAntRun(this.getProject());
        if (this.workingdir != null) {
            execute.setWorkingDirectory(this.workingdir);
        }
        execute.setCommandline(stringArray);
        try {
            int n = execute.execute();
            return n;
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException, this.getLocation());
        }
        finally {
            try {
                this.bos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

