/*	$NetBSD: pfilter.c,v 1.2 2019/01/29 12:51:38 lukem Exp $	*/

#if defined(HAVE_TNFTPD_H)
#include "tnftpd.h"
#endif

#include <stdio.h>

#if USE_BLACKLIST
#include <blacklist.h>
#endif

#include "pfilter.h"

#if USE_BLACKLIST
static struct blacklist *blstate;
#endif

void
pfilter_open(void)
{
#if USE_BLACKLIST
	if (blstate == NULL)
		blstate = blacklist_open();
#endif
}

void
pfilter_notify(int what, const char *msg)
{
#if USE_BLACKLIST
	pfilter_open();

	if (blstate == NULL)
		return;

	blacklist_r(blstate, what, 0, msg);
#endif
}
