/*
 *  This file is part of timespan.
 *  
 *  Timespan is the legal property of its authors.  Refer to the file
 *  AUTHORS in the top-level directory of the source distribution for
 *  details.
 *  
 *  Timespan is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Timespan is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with timespan; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "timespan.hpp"
#include "constants.hpp" //ugly hack but it works

//should this be 0 or NULL? (jbailey, 09-20-2004 @ 02:43)
//I feel more comfortable having this as NULL (jbailey, 10-14-2004 @ 14:10)
const char *progname = NULL; //will hold return value of basename(argv[0])

int main(int argc, char *argv[])
{ //this is the entry point for executeable code.  it is designed to be purely
  //a driver function, calling other functions to do all the work.
	
	//make the arg parsing driver function private to main() because nothing else
	//should ever call it.  I'd like to make the char *[] fully const everywhere,
	//but I think I'm missing something because every time I try i get errors.
	void args_parse_driver(const int, char *[]);

	//set the name of the executable for messages printed on the screen
	progname = basename(argv[0]);
	
	//parse arguments
	args_parse_driver(argc, argv);
	
	return 0;
}

