#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup.
#
import unicodedata
import string
import re
import socket

class Validate(object):
	"""
	Validate this class is used to validate variables. 
	"""
	
	FILE = 1
	FOLDER = 2
	STRING = 3
	INT = 4
	IP_ADDR = 5
	HOSTNAME = 6
	REGEX = 7
	
	def __init__(self):
		"""
		Initialization function for Validate
		"""
		validFilenameChars = "-_.() %s%s" % (string.ascii_letters, string.digits)
		validFoldernameChars = "-_. %s%s" % (string.ascii_letters, string.digits)

	def check(self, check, value):
		"""
		Used to delegate what check is needed.
		
		@type check: predefined variables
		@param check:
		
		@type value: String
		@param value:
		
		@rtype: Boolean
		"""
		if check == self.HOSTNAME:
			return self._validate_hostname(value)
		elif check == self.IP_ADDR:
			return self._validate_ip_address(value)
		elif check == self.REGEX:
			return self._validate_regexp(value)
		elif check == self.STRING:
			return self._validate_string(value)
		elif check == self.INT:
			return self._validate_int(value)
		else:
			return True
	
	def _validate_hostname(self, host):
		"""
		Validate the hostname
		
		@type host: String
		@param host: a hostname
		
		@rtype: Boolean
		"""
		if not self._validate_string(host):
			return False
		try:
			socket.gethostbyname(host)
			return True
		except socket.gaierror,e:
			return False


	def _validate_ip_address(self, ip_str):
		"""
		validates the input for a valid ip addres using reg exp
		
		@type ip_str: String
		@param ip_str: ip addres
		
		@rtype: Boolean
		"""
		pattern = r"\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\b"
		if re.match(pattern, ip_str):
			return True
		else:
			return False
		
	def _validate_regexp(self, regex):
		"""
		checks if the reg exp can be compiled, in other way if it's valid
		
		@type regex: String
		@param regex:
		
		@rtype: Boolean
		"""
		try:
			re.compile(str(regex))
			return True
		except re.error:
			#print "This RE is invalid"
			return False
		
	def _validate_string(self, s):
		"""
		Validate value as string, for length, allowed characters, ....
		
		@type s: String
		@param s:		

		@rtype: Boolean
		"""
		if len(s) <= 0:
			return False
		
		return True

	def validate_filename(self, f):
		"""
		Validate value as filename
		"""
		if not self.validate_string(f):
			return False
		
		if contains_invalid_chars(d, self.FILE):
			return False
	
		return True
		
	def validate_foldername(self, f):
		"""
		Validate value, as foldername
		"""
		if not validate_string(f):
			return False
		
		if contains_invalid_chars(d, FOLDER):
			return False
	
		return True

	def _validate_int(self, i):
		"""
		Validate value, as int

		@type i int
		@param i:
				
		@rtype: Boolean
		"""
		return len(i) > 0 and i.isdigit()

	def contains_invalid_chars(self, s, t):
		""" 
		checks if a string for a given types doesn't has invalid chars
		"""
		if t == self.FILE:
			return not re.match("^[A-Za-z0-9_- ]*$", my_little_string)	
