#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup
# Requires Duplicity Version 0.6.02 released July 08, 2009
#
# Copyright 2009 Rob Oakes	<LyX-Devel@oak-tree>

from PyQt4 import QtCore
from PyQt4 import QtGui
from PyQt4 import uic
import timedrive.utils as utils
from timedrive.utils import gui_utils
from timedrive.background import testconnectionurl
from timedrive.backupsettings import excludeitem
from timedrive.utils import validate

class SettingsDialog(QtGui.QDialog, testconnectionurl.TestConnectionControl):
	"""
	Settings Dialog Class: global definition of a time-drive settings class
	"""
	
	def __init__(self, parent = None):
		"""
		Initialization function for SettingsDialog
		
		@type parent: QDialog Object
		@param parent:
		"""
		super(SettingsDialog, self).__init__(parent)
		uic.properties.Properties._string = gui_utils.translate
		self._Validate = validate.Validate()
		
	def getExcludeTreeItem(self, excludeItem):
		"""
		Returns excludeTreeItem
		
		@type excludeItem: ExcludeItem Object
		@param excludeItem:
		
		@rtype: QTreeWidgetItem
		"""
		excludeIcon = QtGui.QIcon(QtGui.QPixmap(":/PNG/Resources/Remove-Snapshot.png"))
		excludeTreeItem = QtGui.QTreeWidgetItem([QtCore.QString(excludeItem.Item)])
		excludeTreeItem.setIcon(0, excludeIcon)
		return excludeTreeItem
	
	def validateExcludeItem(self, excludePattern, excludeType):
		"""
		Validate and return a excludeItem, for each type it's checked if it's valid
		
		@type excludePattern: String
		@param excludePattern: the pattern to exclude
		
		@type excludeType: Int
		@param excludeType: type defined in the ExcludeItem class
		
		@rtype: ExcludeItem Object
		@return: if the exclude is valid return excludeitem else it returns None
		"""
		e = None
		if excludeType == excludeitem.ExcludeItem.REGEXP:
			try:
				excludePattern = utils.verify_ExcludePattern(excludePattern)
				if excludePattern == None:
					return e

				if not self._Validate.check(self.Validate.REGEX, excludePattern):
					QtGui.QMessageBox.warning(self, _("Invalid"), _("Invalid regular expressions"))
					
				e = excludeitem.ExcludeItem(excludePattern, excludeType)
			except:
				QtGui.QMessageBox.warning(self, _("Exception"), _("Error regular expressions"))	
				
		elif excludeType == excludeitem.ExcludeItem.FOLDER:
			e = excludeitem.ExcludeItem(excludePattern, excludeType)
		elif excludeType == excludeitem.ExcludeItem.FILE:
			e = excludeitem.ExcludeItem(excludePattern, excludeType)
			
		return e