#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup.
#
from timedrive.backupsettings import remotesettings
from timedrive.backupsettings import localsettings

class IncludeItem(remotesettings.RemoteSettings, localsettings.LocalSettings):
	""" IncludeItem class: definition of an include item"""
	
	#backup types
	GENERALSETTINGS = 1
	LOCAL = 2
	REMOTE = 3
	
	#location type
	LOCATION_REMOTE = 1
	LOCATION_LOCAL = 2

	def __init__(self, locationtype):
		"""
		Initialization function for IncludeItem
		"""
		remotesettings.RemoteSettings.__init__(self)
		localsettings.LocalSettings.__init__(self)
		self._locationType = locationtype
		self._FolderName = None
		self._BackupType = None
		self._EncryptionKeyEnabled = None
		self._EncryptionKey = None
		self._ExcludeList = list()
		
	def set_default_values(self):
		self._BackupType = self.GENERALSETTINGS
		remotesettings.RemoteSettings.set_default_values(self)
		localsettings.LocalSettings.set_default_values(self)
		self._EncryptionKeyEnabled = False
		self._EncryptionKey = ""
	
	def _get_locationType(self):
		"""
		location type
		
		@rtype: int
		"""
		return self._locationType

	def _set_locationType(self, value):
		"""
		location type
		
		@type value: int
		@param value:
		"""
		self._locationType = value

	def _get_backupType(self):
		"""
		backup type
		
		@rtype: int
		"""
		return self._BackupType

	def _set_backupType(self, value):
		"""
		backup type
		
		@type value: int
		@param value:
		"""
		self._BackupType = value

	def _is_encryptionKeyEnabled(self):
		"""
		encryption key status
		
		@rtype: Boolean
		"""
		return self._EncryptionKeyEnabled

	def _set_encryptionKeyEnabled(self, value):
		"""
		encryption key status
		
		@type value: Boolean
		@param value:
		"""
		self._EncryptionKeyEnabled = value

	def _get_encryptionKey(self):
		"""
		encryption key
		
		@rtype: String
		"""
		return self._EncryptionKey

	def _set_encryptionKey(self, value):
		"""
		encryption key
		
		@type value: String
		@param value:
		"""
		self._EncryptionKey = value

	def _get_excludeList(self):
		"""
		exclude list
		
		@rtype: List
		"""
		return self._ExcludeList

	def toList(self):
		return [self._LocalBackupDirectory, self._RemoteProtocolInt, self._RemoteProtocol, self._Username, self._Password, self._RemotePath, self._EncryptionKeyEnabled, self._EncryptionKey]

	LocationType = property(_get_locationType, _set_locationType)
	BackupType = property(_get_backupType, _set_backupType)
	EncryptionKeyEnabled = property(_is_encryptionKeyEnabled, _set_encryptionKeyEnabled)
	EncryptionKey = property(_get_encryptionKey, _set_encryptionKey)
	ExcludeList = property(_get_excludeList)
