<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"New Article" => "Ny Artikel",
"Articles Home" => "Startsida",
"Send Pages" => "Skicka Sidor",
"Create/Edit Blog" => "Redigera Blog",
"Admin Posts" => "Admin Inlägg",
"My Files" => "Mina Filer",
"Since your last visit.." => "Sedan ditt senaste besök..",
"Admin menu" => "Admin meny",
"Updated" => "Ändrad",
"MyTiki Home" => "Min Tikisida",
"list bullets" => "punitlista",
"list numbers" => "numrerad lista",
"Tiki is unable to connect to the database " => "Tiki kan inte ansluta till databasen ",
"Tiki was unable to retrieve login data from the database " => "Tiki kunde inte hämta logininformation från databasen ",
"PHP version" => "PHP version",
"Server" => "Server",
"choose a group .." => "välj en grupp ..",
"PHP error reporting level" => "Nivå för PHPs felrapportering",
"Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Lösenord lagras som ren text. Använd <strong>inte</strong> detta alternativ om du inte vet vad det innebär",
"<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer" => "<strong>Förhandsgranska</strong> eller <strong>Spara</strong> dokumentet för att starta om timern.",
"Switch to WYSIWYG editor" => "Byt till WYSIWYG-redigering",
"Switch to normal (wiki) editor" => "Byt till normal-redigering (wiki)",
"Note: Remember that this is only a preview, and has not yet been saved" => "OBS: Detta är bara en förhandsvisning. Kom ihåg att spara!",
"Enter your username or email" => "Ange användarnamn eller e-postadress",
"Enter your email" => "Ange din e-postadress",
"Rename page" => "Byt namn på sidan",
"Advanced search" => "Avancerad sökning",
"Date Search" => "Datumsökning",
"Can you read more languages" => "Lägg till fler språk",
"Select language.." => "Välj språk..",
"Save the page as a draft" => "Save sidan som ett utkast",
"Page saved (version %d)" => "Sidan sparad (version %d)",
"Last modifications to the Wiki" => "Senaste förändringarna i Wikin",
"Your comment will have to be approved by the moderator before it is displayed" => "Ditt inlägg måste godkännas av en administratör innan det kan visas",
"Senast ändrad: %0 av %1" => "Last Modification: %0 by %1",
"Reported Messages" => "Rapporterade Inlägg",
"Queued Messages" => "Köade Inlägg",
"The post has been reported and will be reviewed by a moderator" => "Inlägget har rapporterats och kommer att granskas av en administratör",
"Tiki email notification" => "E-post besked",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Nytt bloginlägg: {\$mail_title}, \"{\$mail_post_title}\", av {\$mail_user} den {\$mail_date|tiki_short_datetime}",
"Reg users can change theme" => "Registrerade användare kan ändra tema",
"Allow sites in this category" => "Tillåt sajter i denna kategori",
"Show number of sites in this category" => "Visa antalet sajter i denna kategori",
"Subcategories" => "Underkategorier",
"Admin related categories" => "Admin relaterade kategorier",
"in current category" => "i nuvarande kategori",
"Total categories" => "Totalt antal kategorier",
"Tiki Shoutbox" => "Megafon",
"Days online" => "Dagar i bruk",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "Copyright management" => "Copyright management",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Is your database up and running" => "Is your database up and running",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "This feature is for admins only" => "This feature is for admins only",
// "Uploaded" => "Uploaded",
// "Last editor" => "Last editor",
// "Locked by" => "Locked by",
// "Explorer" => "Explorer",
// "Default View" => "Default View",
// "Aland Islands" => "Aland Islands",
// "Aland_Islands" => "Aland_Islands",
// "American Samoa" => "American Samoa",
// "American_Samoa" => "American_Samoa",
// "Belarus" => "Belarus",
// "Bosnia_and_Herzegovina" => "Bosnia_and_Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "Bouvet_Island" => "Bouvet_Island",
// "British Virgin Islands" => "British Virgin Islands",
// "British_Indian_Ocean_Territory" => "British_Indian_Ocean_Territory",
// "British_Virgin_Islands" => "British_Virgin_Islands",
// "Burkina_Faso" => "Burkina_Faso",
// "Cape_Verde" => "Cape_Verde",
// "Catalan Countries" => "Catalan Countries",
// "Catalan_Countries" => "Catalan_Countries",
// "Cayman Islands" => "Cayman Islands",
// "Cayman_Islands" => "Cayman_Islands",
// "Central_African_Republic" => "Central_African_Republic",
// "Chad" => "Chad",
// "Christmas Island" => "Christmas Island",
// "Christmas_Island" => "Christmas_Island",
// "Cocos Islands" => "Cocos Islands",
// "Cocos_Islands" => "Cocos_Islands",
// "Comoros" => "Comoros",
// "Congo Democratic" => "Congo Democratic",
// "Congo_Democratic" => "Congo_Democratic",
// "Cook Islands" => "Cook Islands",
// "Cook_Islands" => "Cook_Islands",
// "Costa Rica" => "Costa Rica",
// "Costa_Rica" => "Costa_Rica",
// "Czech Republic" => "Czech Republic",
// "Czech_Republic" => "Czech_Republic",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Dominican Republic" => "Dominican Republic",
// "Dominican_Republic" => "Dominican_Republic",
// "Ecuador" => "Ecuador",
// "El_Salvador" => "El_Salvador",
// "Equatorial_Guinea" => "Equatorial_Guinea",
// "Falkland Islands" => "Falkland Islands",
// "Falkland_Islands" => "Falkland_Islands",
// "Faroe Islands" => "Faroe Islands",
// "Faroe_Islands" => "Faroe_Islands",
// "Federated States of Micronesia" => "Federated States of Micronesia",
// "Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
// "Fiji" => "Fiji",
// "French Guiana" => "French Guiana",
// "French Polynesia" => "French Polynesia",
// "French Southern Territories" => "French Southern Territories",
// "French_Guiana" => "French_Guiana",
// "French_Polynesia" => "French_Polynesia",
// "French_Southern_Territories" => "French_Southern_Territories",
// "Gabon" => "Gabon",
// "Georgia" => "Georgia",
// "Ghana" => "Ghana",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guam" => "Guam",
// "Guernsey" => "Guernsey",
// "Guinea Bissau" => "Guinea Bissau",
// "Guinea_Bissau" => "Guinea_Bissau",
// "Guyana" => "Guyana",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Heard_Island_and_McDonald_Islands" => "Heard_Island_and_McDonald_Islands",
// "Hong_Kong" => "Hong_Kong",
// "Hungary" => "Hungary",
// "Ivory Coast" => "Ivory Coast",
// "Ivory_Coast" => "Ivory_Coast",
// "Jamaica" => "Jamaica",
// "Jersey" => "Jersey",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kiribati" => "Kiribati",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Latvia" => "Latvia",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Lithuania" => "Lithuania",
// "Macao" => "Macao",
// "Marshall_Islands" => "Marshall_Islands",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mauritius" => "Mauritius",
// "Mayotte" => "Mayotte",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Myanmar" => "Myanmar",
// "Nauru" => "Nauru",
// "Netherlands Antilles" => "Netherlands Antilles",
// "Netherlands_Antilles" => "Netherlands_Antilles",
// "New Caledonia" => "New Caledonia",
// "New Zealand" => "New Zealand",
// "New_Caledonia" => "New_Caledonia",
// "New_Zealand" => "New_Zealand",
// "Nicaragua" => "Nicaragua",
// "Niger" => "Niger",
// "Niue" => "Niue",
// "Norfolk Island" => "Norfolk Island",
// "Norfolk_Island" => "Norfolk_Island",
// "North_Korea" => "North_Korea",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "Northern_Mariana_Islands" => "Northern_Mariana_Islands",
// "Oman" => "Oman",
// "Other" => "Other",
// "Palau" => "Palau",
// "Papua New Guinea" => "Papua New Guinea",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Paraguay" => "Paraguay",
// "Pitcairn" => "Pitcairn",
// "Puerto_Rico" => "Puerto_Rico",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Republic_of_Macedonia" => "Republic_of_Macedonia",
// "Reunion" => "Reunion",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Russian Federation" => "Russian Federation",
// "Russian_Federation" => "Russian_Federation",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "Saint_Helena" => "Saint_Helena",
// "Saint_Kitts_and_Nevis" => "Saint_Kitts_and_Nevis",
// "Saint_Lucia" => "Saint_Lucia",
// "Saint_Pierre_and_Miquelon" => "Saint_Pierre_and_Miquelon",
// "Samoa" => "Samoa",
// "San Marino" => "San Marino",
// "San_Marino" => "San_Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Sao_Tome_and_Principe" => "Sao_Tome_and_Principe",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "Sierra_Leone" => "Sierra_Leone",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon Islands" => "Solomon Islands",
// "Solomon_Islands" => "Solomon_Islands",
// "Somalia" => "Somalia",
// "South Africa" => "South Africa",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "South Korea" => "South Korea",
// "South_Africa" => "South_Africa",
// "South_Georgia_and_South_Sandwich_Islands" => "South_Georgia_and_South_Sandwich_Islands",
// "South_Korea" => "South_Korea",
// "Spain" => "Spain",
// "Sri Lanka" => "Sri Lanka",
// "Sri_Lanka" => "Sri_Lanka",
// "St Vincent Grenadines" => "St Vincent Grenadines",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Sudan" => "Sudan",
// "Surinam" => "Surinam",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Svalbard_and_Jan_Mayen" => "Svalbard_and_Jan_Mayen",
// "Swaziland" => "Swaziland",
// "Switzerland" => "Switzerland",
// "Tajikistan" => "Tajikistan",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tonga" => "Tonga",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Tunisia" => "Tunisia",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Turks_and_Caicos_Islands" => "Turks_and_Caicos_Islands",
// "Tuvalu" => "Tuvalu",
// "US Virgin Islands" => "US Virgin Islands",
// "US_Virgin_Islands" => "US_Virgin_Islands",
// "United Arab Emirates" => "United Arab Emirates",
// "United Kingdom" => "United Kingdom",
// "United Nations Organization" => "United Nations Organization",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "United States" => "United States",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_Kingdom_-_England_and_Wales" => "United_Kingdom_-_England_and_Wales",
// "United_Kingdom_-_Northern_Ireland" => "United_Kingdom_-_Northern_Ireland",
// "United_Kingdom_-_Scotland" => "United_Kingdom_-_Scotland",
// "United_Nations_Organization" => "United_Nations_Organization",
// "United_States" => "United_States",
// "United_States_Minor_Outlying_Islands" => "United_States_Minor_Outlying_Islands",
// "Uruguay" => "Uruguay",
// "Uzbekistan" => "Uzbekistan",
// "Vanuatu" => "Vanuatu",
// "Vatican" => "Vatican",
// "Venezuela" => "Venezuela",
// "Viet Nam" => "Viet Nam",
// "Viet_Nam" => "Viet_Nam",
// "Wales" => "Wales",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Wallis_and_Futuna" => "Wallis_and_Futuna",
// "Western Sahara" => "Western Sahara",
// "Western_Sahara" => "Western_Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "the former Yugoslav Republic of Macedonia" => "the former Yugoslav Republic of Macedonia",
// "the_former_Yugoslav_Republic_of_Macedonia" => "the_former_Yugoslav_Republic_of_Macedonia",
// "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter" => "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Slovene" => "Slovene",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "English British" => "English British",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "Galician" => "Galician",
// "Croatian" => "Croatian",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Pijin Solomon" => "Pijin Solomon",
// "Serbian Latin" => "Serbian Latin",
// "Tuvaluan" => "Tuvaluan",
// "Ukrainian" => "Ukrainian",
// "This instance of activity is already complete" => "This instance of activity is already complete",
// "is interactive but has no role assigned" => "is interactive but has no role assigned",
// "is non-interactive and non-autorouted but has no role assigned" => "is non-interactive and non-autorouted but has no role assigned",
// "is standalone but has transitions" => "is standalone but has transitions",
// "is not mapped" => "is not mapped",
// "newest" => "newest",
// "oldest" => "oldest",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
// "Business style" => "Business style",
// "Collaborative style" => "Collaborative style",
// "Page last modified on" => "Page last modified on",
// "no (disabled)" => "no (disabled)",
// "<return> for rows" => "<return> for rows",
// "Only with last version" => "Only with last version",
// "Any 2 versions" => "Any 2 versions",
// "Depends user language" => "Depends user language",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Never use transition css" => "Never use transition css",
// "Use @version:x.x specified in theme css or none if not specified" => "Use @version:x.x specified in theme css or none if not specified",
// "Use @version:x.x specified in theme css or 1.9 if not specified" => "Use @version:x.x specified in theme css or 1.9 if not specified",
// "Use @version:x.x specified in theme css or 2.0 if not specified" => "Use @version:x.x specified in theme css or 2.0 if not specified",
// "LastModif" => "LastModif",
// "Ascending" => "Ascending",
// "Descending" => "Descending",
// "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing" => "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing",
// "\$feature set to nothing" => "\$feature set to nothing",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "All Day" => "All Day",
// "New Image Uploaded by" => "New Image Uploaded by",
// "New Subscriptions" => "New Subscriptions",
// "New Item in Tracker" => "New Item in Tracker",
// "file gallery" => "file gallery",
// "image gallery" => "image gallery",
// "newsletter" => "newsletter",
// "survey" => "survey",
// "wiki page" => "wiki page",
// "(not registered)" => "(not registered)",
// "You have mistyped the anti-bot verification code; please try again" => "You have mistyped the anti-bot verification code; please try again",
// "Please wait %d secondes between posts" => "Please wait %d secondes between posts",
// "A contribution is mandatory" => "A contribution is mandatory",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval, the message will be posted after a moderator approves it" => "Your message has been queued for approval, the message will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "Line" => "Line",
// "Lines" => "Lines",
// "Newsletter subscription information at" => "Newsletter subscription information at",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to" => "Select a Wiki page to link to",
// "Cannot open this file" => "Cannot open this file",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "Contributions" => "Contributions",
// "Query point" => "Query point",
// "layer" => "layer",
// "Record" => "Record",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "User Map Generated in" => "User Map Generated in",
// "Image Map Generated in" => "Image Map Generated in",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "menu" => "menu",
// "File %s not found" => "File %s not found",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "section edit" => "section edit",
// "This poll is closed" => "This poll is closed",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "Forums last posts" => "Forums last posts",
// "The passwords do not match" => "The passwords do not match",
// "The registration mail can't be sent. Contact the administrator" => "The registration mail can't be sent. Contact the administrator",
// "Feed provided by %s. Click to visit" => "Feed provided by %s. Click to visit",
// "See other user's profile" => "See other user's profile",
// "Have your profile seen" => "Have your profile seen",
// "Make friends" => "Make friends",
// "Receive message" => "Receive message",
// "Read an article" => "Read an article",
// "Publish an article" => "Publish an article",
// "Have your article read" => "Have your article read",
// "Create new file gallery" => "Create new file gallery",
// "Upload new file to gallery" => "Upload new file to gallery",
// "Download other user's file" => "Download other user's file",
// "Have your file downloaded" => "Have your file downloaded",
// "Create a new image gallery" => "Create a new image gallery",
// "Upload new image to gallery" => "Upload new image to gallery",
// "See other user's gallery" => "See other user's gallery",
// "See other user's image" => "See other user's image",
// "Have your gallery seen by other user" => "Have your gallery seen by other user",
// "Have your image seen" => "Have your image seen",
// "Create new blog" => "Create new blog",
// "Post in a blog" => "Post in a blog",
// "Read other user's blog" => "Read other user's blog",
// "Have your blog read" => "Have your blog read",
// "Create a new wiki page" => "Create a new wiki page",
// "Edit an existing page" => "Edit an existing page",
// "Trackeritem" => "Trackeritem",
// "Wiki Comment" => "Wiki Comment",
// "Calendar item" => "Calendar item",
// "Tracker item" => "Tracker item",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "You need either JQuery or MooTools enabled for this feature" => "You need either JQuery or MooTools enabled for this feature",
// "Help page" => "Help page",
// "Edit Template" => "Edit Template",
// "The text is" => "The text is",
// "character(s) too long - please edit it" => "character(s) too long - please edit it",
// "Date Selector" => "Date Selector",
// "phplayers are not available on this site" => "phplayers are not available on this site",
// "Select All" => "Select All",
// "Invert Sort" => "Invert Sort",
// "sec" => "sec",
// "Text cut here" => "Text cut here",
// "Task" => "Task",
// "Start date" => "Start date",
// "End date" => "End date",
// "Gender" => "Gender",
// "User information - Click for more info" => "User information - Click for more info",
// "Friend" => "Friend",
// "km" => "km",
// "Last seen on" => "Last seen on",
// "(idle for %s seconds)" => "(idle for %s seconds)",
// "More info about \$other_user" => "More info about \$other_user",
// "(idle for \$idletime seconds)" => "(idle for \$idletime seconds)",
// "No pageviews yet" => "No pageviews yet",
// "n/a" => "n/a",
// "Use this tree to copy the structure" => "Use this tree to copy the structure",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "unknown error" => "unknown error",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "An error occured in a database query" => "An error occured in a database query",
// "Help link" => "Help link",
// "img-g" => "img-g",
// "file-g" => "file-g",
// "arts" => "arts",
// "You are not allowed to upload this type of file" => "You are not allowed to upload this type of file",
// "The file you are trying upload was only partially uploaded" => "The file you are trying upload was only partially uploaded",
// "You must select a file" => "You must select a file",
// "Flash player not available" => "Flash player not available",
// "Altering database table failed" => "Altering database table failed",
// "%d points" => "%d points",
// "Removed" => "Removed",
// "__WARNING__: Plugin disabled \$plugin" => "__WARNING__: Plugin disabled \$plugin",
// "__WARNING__: No such module \$plugin" => "__WARNING__: No such module \$plugin",
// "Create page" => "Create page",
// "Click here to confirm your action" => "Click here to confirm your action",
// "Sea Surfing (CSRF) detected. Operation blocked" => "Sea Surfing (CSRF) detected. Operation blocked",
// "Upload was not successful. Duplicate file content " => "Upload was not successful. Duplicate file content ",
// "Item Modification" => "Item Modification",
// "Item creation" => "Item creation",
// "View the tracker item at" => "View the tracker item at",
// "Field is not numeric" => "Field is not numeric",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "numeric field" => "numeric field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "drop down with other textfield" => "drop down with other textfield",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "radio buttons" => "radio buttons",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "ip selector" => "ip selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "country selector" => "country selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "jscalendar" => "jscalendar",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "header" => "header",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "static text" => "static text",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "item link" => "item link",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "items list" => "items list",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "dynamic items list" => "dynamic items list",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "multimedia" => "multimedia",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "auto-increment" => "auto-increment",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "user subscription" => "user subscription",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "Google Maps" => "Google Maps",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "system" => "system",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "computed field" => "computed field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "user preference" => "user preference",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "pending" => "pending",
// "No extra information for that attached file. " => "No extra information for that attached file. ",
// "The administrator has not yet validated your account. Please wait" => "The administrator has not yet validated your account. Please wait",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "Personal Phone" => "Personal Phone",
// "Personal Mobile" => "Personal Mobile",
// "Personal Fax" => "Personal Fax",
// "Work Phone" => "Work Phone",
// "Work Mobile" => "Work Mobile",
// "Work Fax" => "Work Fax",
// "Company" => "Company",
// "Organization" => "Organization",
// "Department" => "Department",
// "Division" => "Division",
// "Job Title" => "Job Title",
// "Street Address" => "Street Address",
// "City" => "City",
// "State" => "State",
// "Zip Code" => "Zip Code",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info" => "Info",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Displays browser client info" => "Displays browser client info",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor",
// "linktext" => "linktext",
// "Anchor Name" => "Anchor Name",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "The name of the anchor" => "The name of the anchor",
// "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor",
// "Image Annotation" => "Image Annotation",
// "Autogenerated content. Leave blank initially" => "Autogenerated content. Leave blank initially",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Width" => "Width",
// "Image width" => "Image width",
// "Height" => "Height",
// "Image height" => "Image height",
// "Alignment" => "Alignment",
// "Image alignment. Possible values: left, right, center" => "Image alignment. Possible values: left, right, center",
// "Save changes to annotations" => "Save changes to annotations",
// "Image annotations changed" => "Image annotations changed",
// "Creates an annotation block for an image" => "Creates an annotation block for an image",
// "Displays an image and allow the users to define zones to highlight information on the image" => "Displays an image and allow the users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "Field" => "Field",
// "The article field to display. Default field is Heading" => "The article field to display. Default field is Heading",
// "Article ID" => "Article ID",
// "The article to display. If no value is provided, most recent article will be used" => "The article to display. If no value is provided, most recent article will be used",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading" => "Id is optional. If not given, last article is used. Default field is heading",
// "Article List" => "Article List",
// "Includes a list of articles within the page" => "Includes a list of articles within the page",
// "Articles displayed" => "Articles displayed",
// "The amount of articles to display in the list" => "The amount of articles to display in the list",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "Category ID" => "Category ID",
// "The ID of the category to list from" => "The ID of the category to list from",
// "The article language to list" => "The article language to list",
// "Sort order" => "Sort order",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Quiet" => "Quiet",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Title only" => "Title only",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Attachment" => "Attachment",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Number" => "Number",
// "Show icon" => "Show icon",
// "No such attachment on this page" => "No such attachment on this page",
// "Displays an attachment or a list of them" => "Displays an attachment or a list of them",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description" => "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "The wiki page the avatar will link to" => "The wiki page the avatar will link to",
// "Float" => "Float",
// "left|right" => "left|right",
// "Back" => "Back",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "1|0" => "1|0",
// "No Header" => "No Header",
// "Banner" => "Banner",
// "Insert a banner" => "Insert a banner",
// "Target" => "Target",
// "missing parameter" => "missing parameter",
// "Blog List" => "Blog List",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Blog ID" => "Blog ID",
// "Numeric value" => "Numeric value",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Box" => "Box",
// "Box title" => "Box title",
// "Displayed above the content" => "Displayed above the content",
// "Background color" => "Background color",
// "As defined by CSS, name or Hex code" => "As defined by CSS, name or Hex code",
// "Box width" => "Box width",
// "In pixels or percentage. Default value is 100%" => "In pixels or percentage. Default value is 100%",
// "Text Alignment" => "Text Alignment",
// "Float Position" => "Float Position",
// "for box with width lesser than 100%, make text wrap around the box" => "for box with width lesser than 100%, make text wrap around the box",
// "CSS Class" => "CSS Class",
// "Apply custom CSS class to the box" => "Apply custom CSS class to the box",
// "Category IDs" => "Category IDs",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "Types" => "Types",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "Sort Order" => "Sort Order",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "And" => "And",
// "Category Orphans" => "Category Orphans",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Separator" => "Separator",
// "String used to separate the categories in the path. Default character is >" => "String used to separate the categories in the path. Default character is >",
// "Display top category" => "Display top category",
// "yes|no, default to no" => "yes|no, default to no",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Sheet ID" => "Sheet ID",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Chart Width" => "Chart Width",
// "Width in pixels" => "Width in pixels",
// "Chart Height" => "Chart Height",
// "Height in pixels" => "Height in pixels",
// "Value series" => "Value series",
// "Required for pie charts" => "Required for pie charts",
// "Independant series" => "Independant series",
// "Required for types other than pie chart" => "Required for types other than pie chart",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "List of colors to use" => "List of colors to use",
// "Styles" => "Styles",
// "List of styles to use" => "List of styles to use",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "Code" => "Code",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Colors" => "Colors",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "Line numbers" => "Line numbers",
// "0|1, may not be used with colors" => "0|1, may not be used with colors",
// "Wiki syntax" => "Wiki syntax",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "Right to left" => "Right to left",
// "0|1, switch the text display from left to right to right to left" => "0|1, switch the text display from left to right to right to left",
// "Content is HTML" => "Content is HTML",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "Dynamic Content" => "Dynamic Content",
// "Includes content from the dynamic content system" => "Includes content from the dynamic content system",
// "Content ID" => "Content ID",
// "Also known as Fortune cookies or Taglines" => "Also known as Fortune cookies or Taglines",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Countdown" => "Countdown",
// "Displays a countdown from now until the specified date" => "Displays a countdown from now until the specified date",
// "Text to append to the countdown" => "Text to append to the countdown",
// "Target date. Multiple formats accepted" => "Target date. Multiple formats accepted",
// "Locate Time" => "Locate Time",
// "on|off" => "on|off",
// "and" => "and",
// "DBReport" => "DBReport",
// "Run a database report" => "Run a database report",
// "report definition" => "report definition",
// "Full DSN" => "Full DSN",
// "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database",
// "Wiki DSN name" => "Wiki DSN name",
// "The name of a DSN connection defined by the Wiki administrator" => "The name of a DSN connection defined by the Wiki administrator",
// "0|1, parse wiki syntax within the report" => "0|1, parse wiki syntax within the report",
// "Debug" => "Debug",
// "0|1, display the parsed report definition" => "0|1, display the parsed report definition",
// "Missing db or dsn parameter" => "Missing db or dsn parameter",
// "You do not have permission to use this DSN" => "You do not have permission to use this DSN",
// "No DSN connection string found" => "No DSN connection string found",
// "Div" => "Div",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "left|right|center|justify" => "left|right|center|justify",
// "left|right, for box with width lesser than 100%, make text wrap around the box" => "left|right, for box with width lesser than 100%, make text wrap around the box",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Insert a division block on wiki page" => "Insert a division block on wiki page",
// "Definition List" => "Definition List",
// "One entry per line. Each line is in \"Term: Definition\" format" => "One entry per line. Each line is in \"Term: Definition\" format",
// "Draw" => "Draw",
// "Displays drawings in the wiki page" => "Displays drawings in the wiki page",
// "Name of the drawing to display" => "Name of the drawing to display",
// "Name parameter missing" => "Name parameter missing",
// "Equation" => "Equation",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "equation" => "equation",
// "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Events" => "Events",
// "Includes the list of events from a calendar in the page" => "Includes the list of events from a calendar in the page",
// "Calendar ID" => "Calendar ID",
// "Numeric" => "Numeric",
// "Maximum days" => "Maximum days",
// "Maximum Rows" => "Maximum Rows",
// "Datetime" => "Datetime",
// "0|1" => "0|1",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Wiki syntax containing the text to display" => "Wiki syntax containing the text to display",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Use div" => "Use div",
// "Use div instead of ol" => "Use div instead of ol",
// "Class" => "Class",
// "CSS class of the fancylist" => "CSS class of the fancylist",
// "Creates a fancy looking list" => "Creates a fancy looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "One row per line, cells separated by ~|~" => "One row per line, cells separated by ~|~",
// "Heading row" => "Heading row",
// "Heading row of the table, same format as the body section" => "Heading row of the table, same format as the body section",
// "Heading CSS Class" => "Heading CSS Class",
// "CSS Class to apply on the heading row" => "CSS Class to apply on the heading row",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "name_asc" => "name_asc",
// "Shows ID" => "Shows ID",
// "Shows Icon" => "Shows Icon",
// "Shows Name" => "Shows Name",
// "Shows Filename" => "Shows Filename",
// "Shows Size" => "Shows Size",
// "Shows Description" => "Shows Description",
// "Shows Creation Date" => "Shows Creation Date",
// "Shows Hits" => "Shows Hits",
// "Shows Locked by" => "Shows Locked by",
// "Shows Modification Date" => "Shows Modification Date",
// "Shows Author" => "Shows Author",
// "Shows Creator" => "Shows Creator",
// "Shows Parent Gallery Name" => "Shows Parent Gallery Name",
// "Shows Number of Files" => "Shows Number of Files",
// "Shows the slideshow of a gallery" => "Shows the slideshow of a gallery",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Displays a SWF on the wiki page" => "Displays a SWF on the wiki page",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include" => "Complete URL to the movie to include",
// "Default width: 425" => "Default width: 425",
// "Default height: 350" => "Default height: 350",
// "Quality" => "Quality",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Footnote" => "Footnote",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "The footnote" => "The footnote",
// "Sameas" => "Sameas",
// "Tag to existing footnote" => "Tag to existing footnote",
// "CheckDuplicate" => "CheckDuplicate",
// "check for duplcate footnotes" => "check for duplcate footnotes",
// "Footnotearea" => "Footnotearea",
// "Inserts a section for collected footnotes within the wiki page" => "Inserts a section for collected footnotes within the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "ftp" => "ftp",
// "file name" => "file name",
// "Ftp Server Name" => "Ftp Server Name",
// "Ftp User name" => "Ftp User name",
// "Ftp password" => "Ftp password",
// "Download button label" => "Download button label",
// "missing parameters" => "missing parameters",
// "Connection failed" => "Connection failed",
// "Incorrect param" => "Incorrect param",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "current value (REQUIRED)" => "current value (REQUIRED)",
// "Maximum Value" => "Maximum Value",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Color" => "Color",
// "Background Color" => "Background Color",
// "Bar width in pixels" => "Bar width in pixels",
// "Label Width" => "Label Width",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "Display Percentage" => "Display Percentage",
// "true|false, if true then a percentage of the maximum is displayed" => "true|false, if true then a percentage of the maximum is displayed",
// "Display Value" => "Display Value",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "Google Analytics" => "Google Analytics",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "Missing parameter" => "Missing parameter",
// "googledoc" => "googledoc",
// "Leave this empty" => "Leave this empty",
// "Type of Google document" => "Type of Google document",
// "key" => "key",
// "Google doc key - for example pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example pXsHENf1bGGY92X1iEeJJI",
// "Name of iframe" => "Name of iframe",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Pixels or %" => "Pixels or %",
// "Margin Height" => "Margin Height",
// "Pixels" => "Pixels",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Displays a Google document" => "Displays a Google document",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed Groups" => "Allowed Groups",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Denied Groups" => "Denied Groups",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "HTML" => "HTML",
// "Include literal HTML in a Wiki page" => "Include literal HTML in a Wiki page",
// "0|1, parse wiki syntax within the html code" => "0|1, parse wiki syntax within the html code",
// "Include literal HTML" => "Include literal HTML",
// "Iframe" => "Iframe",
// "Frame title" => "Frame title",
// "iframe" => "iframe",
// "Displays an iframe" => "Displays an iframe",
// " (experimental - possible successor to img in 4.0)" => " (experimental - possible successor to img in 4.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image Source" => "Image Source",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Link title" => "Link title",
// "Title text" => "Title text",
// "Image alt text" => "Image alt text",
// "Alternate text to display if impossible to load the image" => "Alternate text to display if impossible to load the image",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS Style" => "CSS Style",
// "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)" => "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration" => "Default configuration",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration" => "Mandatory configuration",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display an image" => "Display an image",
// "Displays an image" => "Displays an image",
// "Full URL to the image to display" => "Full URL to the image to display",
// "Alternate Text" => "Alternate Text",
// "Height of the image to display" => "Height of the image to display",
// "Width of the image to display" => "Width of the image to display",
// "Link Title" => "Link Title",
// "Image alignment in the page. (left, right, center) Uses HTML IMG tag" => "Image alignment in the page. (left, right, center) Uses HTML IMG tag",
// "Float Alignment" => "Float Alignment",
// "Image alignment in the flow of the document. (left, right, none) Uses CSS float property" => "Image alignment in the flow of the document. (left, right, none) Uses CSS float property",
// "Style to apply to the image" => "Style to apply to the image",
// "Include a page\\'s content" => "Include a page\\'s content",
// "Page Name" => "Page Name",
// "Wiki page name to include" => "Wiki page name to include",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "Stop" => "Stop",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Jabber" => "Jabber",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Default Color" => "Default Color",
// "255,255,255" => "255,255,255",
// "JQuery" => "JQuery",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Javascript" => "Javascript",
// "Insert a javascript file or/and some javascript code" => "Insert a javascript file or/and some javascript code",
// "javascript code" => "javascript code",
// "Javascript filename" => "Javascript filename",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Last Modification" => "Last Modification",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Amount of results displayed in the list" => "Amount of results displayed in the list",
// "Initial" => "Initial",
// "txt" => "txt",
// "Show Name Only" => "Show Name Only",
// "Structure Head" => "Structure Head",
// "Show Page Alias" => "Show Page Alias",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Orphan Language" => "Orphan Language",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Exact Match" => "Exact Match",
// "Related to Find" => "Related to Find",
// "Only Orphan Pages" => "Only Orphan Pages",
// "For List Pages" => "For List Pages",
// "List Directory" => "List Directory",
// "Lists files in a directory" => "Lists files in a directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "URL Prefix" => "URL Prefix",
// ".ext" => ".ext",
// "Limit" => "Limit",
// "Maximum amount of files to display" => "Maximum amount of files to display",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Displays a map" => "Displays a map",
// "Map File" => "Map File",
// "Extents" => "Extents",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Mediaplayer" => "Mediaplayer",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "One of" => "One of",
// "Mini Quiz" => "Mini Quiz",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "Flip" => "Flip",
// "Max" => "Max",
// "np" => "np",
// "notitle" => "notitle",
// "Displays a module inlined in page. More parameters can be added, not supported by UI" => "Displays a module inlined in page. More parameters can be added, not supported by UI",
// "Monospace" => "Monospace",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Mouse Over" => "Mouse Over",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when moused-over text is clicked. Use http:// for external links" => "Destination link when moused-over text is clicked. Use http:// for external links",
// "DEPRECATED" => "DEPRECATED",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouse over box width. Default: 400px" => "Mouse over box width. Default: 400px",
// "Mouse over box height. Default: 200px" => "Mouse over box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px" => "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Color of the inside popup" => "Color of the inside popup",
// "Default: #F5F5F5" => "Default: #F5F5F5",
// "Text popup color" => "Text popup color",
// "#FFFFFF" => "#FFFFFF",
// "Sticky" => "Sticky",
// "Padding" => "Padding",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "true|false" => "true|false",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace" => "MySpace",
// "MySpace Page" => "MySpace Page",
// "Displays a SWF myspace mp3 playlist on the wiki page" => "Displays a SWF myspace mp3 playlist on the wiki page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "Object Type" => "Object Type",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Picture" => "Picture",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Plugin Manager" => "Plugin Manager",
// "Information" => "Information",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "Poll" => "Poll",
// "Poll ID" => "Poll ID",
// "Displays the output of a poll, fields are indicated with numeric ids" => "Displays the output of a poll, fields are indicated with numeric ids",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Proposal" => "Proposal",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username",
// "Accept proposal" => "Accept proposal",
// "Still undecided" => "Still undecided",
// "Reject proposal" => "Reject proposal",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quote" => "Quote",
// "Quoted text" => "Quoted text",
// "Reply to" => "Reply to",
// "Name of the quoted person" => "Name of the quoted person",
// "wrote" => "wrote",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "Redirect" => "Redirect",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Wiki page name to redirect to" => "Wiki page name to redirect to",
// "Complete URL, internal or external" => "Complete URL, internal or external",
// "Redirects you to another wiki page" => "Redirects you to another wiki page",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text" => "Takes regex expressions and parses the content between the REGEX tags and replaces the text",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon ID" => "Icon ID",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Amount of results displayed" => "Amount of results displayed",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect" => "RSS Id incorrect",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "SourceForge" => "SourceForge",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "Pop-up" => "Pop-up",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Sheet" => "Sheet",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Sheet Heading" => "Sheet Heading",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "TikiSheet" => "TikiSheet",
// "Edit Sheet" => "Edit Sheet",
// "Show Pages" => "Show Pages",
// "Search criteria" => "Search criteria",
// "Maximum amount of results displayed" => "Maximum amount of results displayed",
// "name|desc" => "name|desc",
// "Last modified by" => "Last modified by",
// "Skype" => "Skype",
// "Clickable Skype link" => "Clickable Skype link",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace" => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace",
// "This data is put in a CODE caption" => "This data is put in a CODE caption",
// "Missing url parameter for SNARF plugin" => "Missing url parameter for SNARF plugin",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "asc|desc|shuffle" => "asc|desc|shuffle",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Fixed Size" => "Fixed Size",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Column Size" => "Column Size",
// "Editable" => "Editable",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "SQL" => "SQL",
// "DNS Name" => "DNS Name",
// "ADODB DNS" => "ADODB DNS",
// "Subscript" => "Subscript",
// "Displays text in subscript" => "Displays text in subscript",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Subscribe Group" => "Subscribe Group",
// "Group Name" => "Group Name",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe Text" => "Unsubscribe Text",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Colon separated list of groups" => "Colon separated list of groups",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Displays a survey" => "Displays a survey",
// "Tag" => "Tag",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent of the style attribute on the HTML tag" => "Equivalent of the style attribute on the HTML tag",
// "Displays text between an html tag" => "Displays text between an html tag",
// "Displays the thumbnail for an image" => "Displays the thumbnail for an image",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "URL to the image" => "URL to the image",
// "Maximum Size" => "Maximum Size",
// "Maximum width or height for the image" => "Maximum width or height for the image",
// "Floating" => "Floating",
// "Link target of the image" => "Link target of the image",
// "File is not an image" => "File is not an image",
// "Server does not support image manipulation" => "Server does not support image manipulation",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Exclude" => "Exclude",
// "Pipe separated list of page names to exclude from results" => "Pipe separated list of page names to exclude from results",
// "pages found for title search" => "pages found for title search",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Maximum Depth" => "Maximum Depth",
// "Maximum amount of levels to display. On very large structures, this should be limited" => "Maximum amount of levels to display. On very large structures, this should be limited",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "Show Description" => "Show Description",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "List top scoring users" => "List top scoring users",
// "Maximum result count" => "Maximum result count",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "string" => "string",
// "Translate a string" => "Translate a string",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Fields" => "Fields",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Title" => "Show Title",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "Url used for the field links" => "Url used for the field links",
// "Values" => "Values",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "View" => "View",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Incorrect fieldId" => "Incorrect fieldId",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Fields marked with a * are mandatory" => "Fields marked with a * are mandatory",
// "Display List" => "Display List",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Filters the items of a tracker, fields are indicated with numeric ids" => "Filters the items of a tracker, fields are indicated with numeric ids",
// "Wiki text" => "Wiki text",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "Field ID" => "Field ID",
// "Colon separated list of field IDs" => "Colon separated list of field IDs",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Test" => "Test",
// "Value to compare against" => "Value to compare against",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Tracker List" => "Tracker List",
// "Displays the output of a tracker content, fields are indicated with numeric ids" => "Displays the output of a tracker content, fields are indicated with numeric ids",
// "Notice" => "Notice",
// "Popup" => "Popup",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "Show Links" => "Show Links",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Status" => "Show Status",
// "Show Creation Date" => "Show Creation Date",
// "Show Last Modification" => "Show Last Modification",
// "Show Field Name" => "Show Field Name",
// "Status Filter" => "Status Filter",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Sort Mode" => "Sort Mode",
// "Filter Field" => "Filter Field",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "Filter Value" => "Filter Value",
// "Exact Value" => "Exact Value",
// "Checkbox" => "Checkbox",
// "goIfOne" => "goIfOne",
// "More" => "More",
// "More URL" => "More URL",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Left Deliminator" => "Left Deliminator",
// "Right Deliminator" => "Right Deliminator",
// "If y, value will be truncated" => "If y, value will be truncated",
// "Export Button" => "Export Button",
// "Compute" => "Compute",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "incorrect filterfield" => "incorrect filterfield",
// "Error in tracker ID" => "Error in tracker ID",
// "No field indicated" => "No field indicated",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Button label" => "Button label",
// "Field 1" => "Field 1",
// "Value 1" => "Value 1",
// "Content of the field" => "Content of the field",
// "Field 2" => "Field 2",
// "Value 2" => "Value 2",
// "Field 3" => "Field 3",
// "Value 3" => "Value 3",
// "Field 4" => "Field 4",
// "Value 4" => "Value 4",
// "Field 5" => "Field 5",
// "Value 5" => "Value 5",
// "Tracker Stats" => "Tracker Stats",
// "Show Percentage" => "Show Percentage",
// "Show Bar" => "Show Bar",
// "Show link to tiki-view_tracker" => "Show link to tiki-view_tracker",
// "Displays some stat of a tracker content, fields are indicated with numeric ids" => "Displays some stat of a tracker content, fields are indicated with numeric ids",
// "incorrect fieldId" => "incorrect fieldId",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Title Field" => "Title Field",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Summary Field" => "Summary Field",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Start Date" => "Start Date",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "End Date" => "End Date",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "hour, day, week, month or year (default to hour)" => "hour, day, week, month or year (default to hour)",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "hour, day, week, month, year or empty (default to empty)" => "hour, day, week, month, year or empty (default to empty)",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "Missing parameter: %0" => "Missing parameter: %0",
// "Start date after end date" => "Start date after end date",
// "Translated" => "Translated",
// "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)",
// "Two letter language code of the language, ex: fr" => "Two letter language code of the language, ex: fr",
// "Flag" => "Flag",
// "Country name, ex: France" => "Country name, ex: France",
// "User Count" => "User Count",
// "Displays the number of registered users" => "Displays the number of registered users",
// "Group name" => "Group name",
// "User List" => "User List",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Maximum" => "Maximum",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Default" => "Default",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Show Stats" => "Show Stats",
// "Show Stats After" => "Show Stats After",
// "Show Creator" => "Show Creator",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Table" => "Table",
// "Level" => "Level",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Switch-on debug output with details about the items" => "Switch-on debug output with details about the items",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output" => "End of debug output",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Service Name" => "Service Name",
// "Registered service name" => "Registered service name",
// "Template Name" => "Template Name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "Unknown Template" => "Unknown Template",
// "Unknown Service" => "Unknown Service",
// "Missing parameters" => "Missing parameters",
// "Youtube" => "Youtube",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "URL to the Youtube video" => "URL to the Youtube video",
// "width" => "width",
// "height" => "height",
// "quality" => "quality",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "Removed last version" => "Removed last version",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages" => "Sent box is full. Archive or delete some sent messages first if you want to send more messages",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Archive is full. Delete some messages from archive first" => "Archive is full. Delete some messages from archive first",
// "list topics with links to the articles" => "list topics with links to the articles",
// "Article Topics" => "Article Topics",
// "Categorize %s in %s" => "Categorize %s in %s",
// "Please provide an Id" => "Please provide an Id",
// "no object here yet" => "no object here yet",
// "List by month" => "List by month",
// "Please wait.." => "Please wait..",
// "new posts" => "new posts",
// "new articles" => "new articles",
// "new FAQs" => "new FAQs",
// "new blogs" => "new blogs",
// "new blog posts" => "new blog posts",
// "new image galleries" => "new image galleries",
// "new file galleries" => "new file galleries",
// "new polls" => "new polls",
// "new tracker items" => "new tracker items",
// "updated tracker items" => "updated tracker items",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can browse the calendar" => "Can browse the calendar",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Can admin categories" => "Can admin categories",
// "Can edit items in categories" => "Can edit items in categories",
// "Can view categories" => "Can view categories",
// "Can view categorized items" => "Can view categorized items",
// "Can search on objects of this category" => "Can search on objects of this category",
// "Can admin charts" => "Can admin charts",
// "Autovalidate suggestions" => "Autovalidate suggestions",
// "Can suggest items" => "Can suggest items",
// "Can view charts" => "Can view charts",
// "Can vote" => "Can vote",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Can use the chat system" => "Can use the chat system",
// "Can admin the cms" => "Can admin the cms",
// "Can approve submissions" => "Can approve submissions",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Can edit articles" => "Can edit articles",
// "Can edit submissions" => "Can edit submissions",
// "Can read articles" => "Can read articles",
// "Can remove articles" => "Can remove articles",
// "Can remove submissions" => "Can remove submissions",
// "Can submit articles" => "Can submit articles",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can admin contributions" => "Can admin contributions",
// "Can admin the directory" => "Can admin the directory",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Submited links are valid" => "Submited links are valid",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can validate submited links" => "Can validate submited links",
// "Can use the directory" => "Can use the directory",
// "Can admin drawings" => "Can admin drawings",
// "Can edit drawings" => "Can edit drawings",
// "Can admin faqs" => "Can admin faqs",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can view faqs" => "Can view faqs",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Can admin users" => "Can admin users",
// "Can access site when closed" => "Can access site when closed",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Can ban users or ips" => "Can ban users or ips",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin rss modules" => "Can admin rss modules",
// "Can clean cache" => "Can clean cache",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can admin cookies" => "Can admin cookies",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit site templates" => "Can edit site templates",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view referer stats" => "Can view referer stats",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can admin blogs" => "Can admin blogs",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can post to a blog" => "Can post to a blog",
// "Can create a blog" => "Can create a blog",
// "Can read blogs" => "Can read blogs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can create file galleries" => "Can create file galleries",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can upload files" => "Can upload files",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view file galleries" => "Can view file galleries",
// "Can admin forums" => "Can admin forums",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can post in forums" => "Can post in forums",
// "Can start threads in forums" => "Can start threads in forums",
// "Can read forums" => "Can read forums",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can create image galleries" => "Can create image galleries",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload images" => "Can upload images",
// "Can browse freetags" => "Can browse freetags",
// "Can view image galleries" => "Can view image galleries",
// "Can admin games" => "Can admin games",
// "Can play games" => "Can play games",
// "Can admin newsletters" => "Can admin newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can vote polls" => "Can vote polls",
// "Can view poll voters" => "Can view poll voters",
// "Can admin quicktags" => "Can admin quicktags",
// "Can admin quizzes" => "Can admin quizzes",
// "Can take quizzes" => "Can take quizzes",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view user quiz results" => "Can view user quiz results",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can view shoutbox" => "Can view shoutbox",
// "Can admin surveys" => "Can admin surveys",
// "Can take surveys" => "Can take surveys",
// "Can view survey stats" => "Can view survey stats",
// "Can admin trackers" => "Can admin trackers",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can list trackers" => "Can list trackers",
// "Can change tracker items" => "Can change tracker items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can admin the wiki" => "Can admin the wiki",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can edit pages" => "Can edit pages",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can create and edit structures" => "Can create and edit structures",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can lock pages" => "Can lock pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can remove" => "Can remove",
// "Can rename pages" => "Can rename pages",
// "Can rollback pages" => "Can rollback pages",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can view page/pages" => "Can view page/pages",
// "Can watch structure" => "Can watch structure",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin workflow processes" => "Can admin workflow processes",
// "Can abort a process instance" => "Can abort a process instance",
// "Can declare an instance as exception" => "Can declare an instance as exception",
// "Can send instances after completion" => "Can send instances after completion",
// "Can execute workflow activities" => "Can execute workflow activities",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can configure modules" => "Can configure modules",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the newsreader" => "Can use the newsreader",
// "Can use the notepad" => "Can use the notepad",
// "Can admin public tasks" => "Can admin public tasks",
// "Can use tasks" => "Can use tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can upload personal files" => "Can upload personal files",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can use the messaging system" => "Can use the messaging system",
// "Can admin comments" => "Can admin comments",
// "Can edit all comments" => "Can edit all comments",
// "Can post new comments" => "Can post new comments",
// "Can read comments" => "Can read comments",
// "Can delete comments" => "Can delete comments",
// "Can vote comments" => "Can vote comments",
// "Can admin content templates" => "Can admin content templates",
// "Can edit content templates" => "Can edit content templates",
// "Can use content templates" => "Can use content templates",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can view HTML pages" => "Can view HTML pages",
// "Can list registered users" => "Can list registered users",
// "Admin live support system" => "Admin live support system",
// "Can use live support system" => "Can use live support system",
// "Can create new mapfile" => "Can create new mapfile",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use webmail" => "Can use webmail",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wysiwyg toolbar" => "wysiwyg toolbar",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastmodif" => "fgal list lastmodif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "change password" => "change password",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki workflow" => "users prefs mytiki workflow",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "validateRegistration" => "validateRegistration",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature newsreader" => "feature newsreader",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "feature charts" => "feature charts",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth create user tiki" => "auth create user tiki",
// "auth create user auth" => "auth create user auth",
// "auth skip admin" => "auth skip admin",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "feature games" => "feature games",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature swfobj" => "feature swfobj",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "quicktags over textarea" => "quicktags over textarea",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "feature floating help" => "feature floating help",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty notice reporting" => "smarty notice reporting",
// "smarty security" => "smarty security",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature drawings" => "feature drawings",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature workflow" => "feature workflow",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session db" => "session db",
// "session lifetime" => "session lifetime",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "system os" => "system os",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "feature mootools" => "feature mootools",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "use minified scripts" => "use minified scripts",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature tikitests" => "feature tikitests",
// "feature magic" => "feature magic",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "transition style ver" => "transition style ver",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki workflow" => "mytiki workflow",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "on" => "on",
// "RSS feed" => "RSS feed",
// "Monitor this Blog" => "Monitor this Blog",
// "Stop Monitoring this Blog" => "Stop Monitoring this Blog",
// "Group Monitor" => "Group Monitor",
// "Watched by categories" => "Watched by categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "posts" => "posts",
// "Send eMail to User" => "Send eMail to User",
// "top of page" => "top of page",
// "Reject" => "Reject",
// "Report this post" => "Report this post",
// "Monitor this Topic" => "Monitor this Topic",
// "Stop Monitoring this Topic" => "Stop Monitoring this Topic",
// "Errors" => "Errors",
// "Move" => "Move",
// "Plain" => "Plain",
// "Threaded" => "Threaded",
// "Headers Only" => "Headers Only",
// "below your current threshold" => "below your current threshold",
// "Comments are locked" => "Comments are locked",
// "Note" => "Note",
// "New Reply" => "New Reply",
// "Editing reply" => "Editing reply",
// "Reply to the selected post" => "Reply to the selected post",
// "Comment on the selected post" => "Comment on the selected post",
// "Quicktags" => "Quicktags",
// "Maximum size" => "Maximum size",
// "Enter your name" => "Enter your name",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Reply to parent post" => "Reply to parent post",
// "Post new reply" => "Post new reply",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Type of contribution" => "Type of contribution",
// "Contributors" => "Contributors",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate perms" => "Duplicate perms",
// "View inserted gallery" => "View inserted gallery",
// "Display Properties" => "Display Properties",
// "required field for podcasts" => "required field for podcasts",
// "any file" => "any file",
// "podcast (audio)" => "podcast (audio)",
// "podcast (video)" => "podcast (video)",
// "This Gallery is Public" => "This Gallery is Public",
// "Users with perms and not only the owner of the gallery can upload in it" => "Users with perms and not only the owner of the gallery can upload in it",
// "The files can be locked at download" => "The files can be locked at download",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "unlimited" => "unlimited",
// "Parent gallery" => "Parent gallery",
// "Owner of the gallery" => "Owner of the gallery",
// "Group of users alerted when file gallery is modified" => "Group of users alerted when file gallery is modified",
// "Allows to select each user for small groups" => "Allows to select each user for small groups",
// "Default sort order" => "Default sort order",
// "descending" => "descending",
// "ascending" => "ascending",
// "Please login" => "Please login",
// "Perhaps you were looking for" => "Perhaps you were looking for",
// "There are no wiki pages similar to '{\$page}'" => "There are no wiki pages similar to '{\$page}'",
// "Go to Login Page" => "Go to Login Page",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Close Window" => "Close Window",
// "Go to" => "Go to",
// "Active Perms" => "Active Perms",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Download and lock" => "Download and lock",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Both" => "Both",
// "Show an icon in a column" => "Show an icon in a column",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "not in" => "not in",
// "any category" => "any category",
// "Go" => "Go",
// "Clear Filter" => "Clear Filter",
// "Show php error messages" => "Show php error messages",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together" => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "RSS Maps" => "RSS Maps",
// "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page" => "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page",
// "Loading" => "Loading",
// "\\074span class=\"shortcut\"\\076C\\074/span\\076lose" => "\\074span class=\"shortcut\"\\076C\\074/span\\076lose",
// "\\074span class=\"shortcut\"\\076N\\074/span\\076ext" => "\\074span class=\"shortcut\"\\076N\\074/span\\076ext",
// "\\074span class=\"shortcut\"\\076P\\074/span\\076revious" => "\\074span class=\"shortcut\"\\076P\\074/span\\076revious",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Move Selected Files" => "Move Selected Files",
// "Are you sure you want to delete the selected files" => "Are you sure you want to delete the selected files",
// "Download the zip" => "Download the zip",
// "Assign Permissions" => "Assign Permissions",
// "Assign" => "Assign",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "New topic" => "New topic",
// "Contribution" => "Contribution",
// "You sent a request with the subject" => "You sent a request with the subject",
// "Use the subject to indicate the operation to apply" => "Use the subject to indicate the operation to apply",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in instructions" => "Tiki mail-in instructions",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Page not found" => "Page not found",
// "New message arrived from %s" => "New message arrived from %s",
// "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now" => "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now",
// "To login with your username and password, please follow this link" => "To login with your username and password, please follow this link",
// "User Account Activated" => "User Account Activated",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "has requested an account on" => "has requested an account on",
// "To validate that account, please follow the link" => "To validate that account, please follow the link",
// "best regards" => "best regards",
// "your Tikiwiki" => "your Tikiwiki",
// "User Tracker" => "User Tracker",
// "User Registration Request" => "User Registration Request",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "You're invited to join my network of friends" => "You're invited to join my network of friends",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Email notification" => "Email notification",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above" => "Important: The old password remains active if you don't click the link above",
// "Your account information for %s" => "Your account information for %s",
// "New article submitted at %s" => "New article submitted at %s",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Tracker was modified at" => "Tracker was modified at",
// "Please visit this link before login again" => "Please visit this link before login again",
// "Last attempt" => "Last attempt",
// "IP" => "IP",
// "Confirm your account at %s" => "Confirm your account at %s",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "You or someone registered this email address at" => "You or someone registered this email address at",
// "Your registration confirmation" => "Your registration confirmation",
// "Your account request has been stored and will be activated by the admin as soon as possible" => "Your account request has been stored and will be activated by the admin as soon as possible",
// "You'll receive email notification once your account is activated" => "You'll receive email notification once your account is activated",
// "Please do not attempt to login until you receive the email notification" => "Please do not attempt to login until you receive the email notification",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "View the article at" => "View the article at",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}",
// "New blog post at %s" => "New blog post at %s",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "Removed by" => "Removed by",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Old" => "Old",
// "New" => "New",
// "updated" => "updated",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "An object was added to category" => "An object was added to category",
// "Added by" => "Added by",
// "Object type" => "Object type",
// "An object was removed from category" => "An object was removed from category",
// "A page has been added to your watched sub-structure" => "A page has been added to your watched sub-structure",
// "A page has been removed from your watched sub-structure" => "A page has been removed from your watched sub-structure",
// "A page has been promoted out your watched sub-structure" => "A page has been promoted out your watched sub-structure",
// "A page has been demoted to your watched structure" => "A page has been demoted to your watched structure",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "You can view the page by following this link" => "You can view the page by following this link",
// "You can view a diff back to the previous version by following this link" => "You can view a diff back to the previous version by following this link",
// "The changes in this version follow below, followed after by the current full page text" => "The changes in this version follow below, followed after by the current full page text",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "The old page content follows below" => "The old page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Thank you for your registration. You may log in now" => "Thank you for your registration. You may log in now",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Zoom out" => "Zoom out",
// "Pan" => "Pan",
// "Zoom in" => "Zoom in",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Layer" => "Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "from the mapfile" => "from the mapfile",
// "hits last 7 days" => "hits last 7 days",
// "Stop Monitoring this Map" => "Stop Monitoring this Map",
// "Reload" => "Reload",
// "Zoom out x2" => "Zoom out x2",
// "Zoom in x2" => "Zoom in x2",
// "Mapfile History" => "Mapfile History",
// "Compare" => "Compare",
// "Comparing version {\$old.version} with version {\$new.version}" => "Comparing version {\$old.version} with version {\$new.version}",
// "Current" => "Current",
// "v=view" => "v=view",
// "c=compare" => "c=compare",
// "d=diff" => "d=diff",
// "Full side-by-side diff" => "Full side-by-side diff",
// "Unified diff" => "Unified diff",
// "Side-by-side view" => "Side-by-side view",
// "Diff" => "Diff",
// "Older Version" => "Older Version",
// "back to" => "back to",
// "Message Archive" => "Message Archive",
// "messages" => "messages",
// "Archive is full" => "Archive is full",
// "Broadcast message" => "Broadcast message",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "ERROR" => "ERROR",
// "No messages to download" => "No messages to download",
// "Mailbox is full! Delete or archive some messages if you want to receive more messages" => "Mailbox is full! Delete or archive some messages if you want to receive more messages",
// "Find replied message" => "Find replied message",
// "Broadcast" => "Broadcast",
// "Auto-archive age for read messages" => "Auto-archive age for read messages",
// "Return to mailbox" => "Return to mailbox",
// "Unflag" => "Unflag",
// "Return to archive" => "Return to archive",
// "Return to outbox" => "Return to outbox",
// "Sent Messages" => "Sent Messages",
// "Replied" => "Replied",
// "Not replied" => "Not replied",
// "move to archive" => "move to archive",
// "receiver" => "receiver",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "opp side" => "opp side",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module" => "Are you sure you want to unassign this module",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "\$tpl_module_title" => "\$tpl_module_title",
// "Admin Drawings" => "Admin Drawings",
// "External Wikis" => "External Wikis",
// "Tiki Cache/Sys Admin" => "Tiki Cache/Sys Admin",
// "Syntax Highlighting" => "Syntax Highlighting",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number " => "You forgot your Google ad_client number ",
// "\$module_title" => "\$module_title",
// "More.." => "More..",
// "Tikiwiki Assistant" => "Tikiwiki Assistant",
// "Thank you for installing Tikiwiki" => "Thank you for installing Tikiwiki",
// "To configure your Tiki" => "To configure your Tiki",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as the Admin" => "as the Admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "Last `\$module_rows` blog comments" => "Last `\$module_rows` blog comments",
// "Last blog comments" => "Last blog comments",
// "on blogpost" => "on blogpost",
// "Add event" => "Add event",
// "\$modcattitle" => "\$modcattitle",
// "Last `\$module_rows` Sites" => "Last `\$module_rows` Sites",
// "Top \$module_rows Sites" => "Top \$module_rows Sites",
// "Current events" => "Current events",
// "Top `\$module_rows` topics" => "Top `\$module_rows` topics",
// "Last `\$module_rows` forum posts" => "Last `\$module_rows` forum posts",
// "Last forum posts" => "Last forum posts",
// "Last `\$module_rows` forum topics" => "Last `\$module_rows` forum topics",
// "Folksonomy" => "Folksonomy",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "List everything tagged" => "List everything tagged",
// "My prefered tags" => "My prefered tags",
// "Last `\$module_rows` actions" => "Last `\$module_rows` actions",
// "Last actions" => "Last actions",
// "Last `\$module_rows` articles" => "Last `\$module_rows` articles",
// "Last `\$module_rows` blog posts" => "Last `\$module_rows` blog posts",
// "\$type" => "\$type",
// "Last `\$module_rows` Created blogs" => "Last `\$module_rows` Created blogs",
// "Last `\$module_rows` Created FAQs" => "Last `\$module_rows` Created FAQs",
// "Last `\$module_rows` Created Quizzes" => "Last `\$module_rows` Created Quizzes",
// "Last `\$module_rows` modified file galleries" => "Last `\$module_rows` modified file galleries",
// "Last `\$module_rows` Files" => "Last `\$module_rows` Files",
// "Last `\$module_rows` galleries" => "Last `\$module_rows` galleries",
// "Last `\$module_rows` Images" => "Last `\$module_rows` Images",
// "Last Images" => "Last Images",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "Last `\$module_rows` modified events" => "Last `\$module_rows` modified events",
// "Last modifed events" => "Last modifed events",
// "Last `\$module_rows` changes" => "Last `\$module_rows` changes",
// "more" => "more",
// "Last `\$module_rows` Modified Items" => "Last `\$module_rows` Modified Items",
// "Last `\$module_rows` Modified blogs" => "Last `\$module_rows` Modified blogs",
// "Last `\$module_rows` submissions" => "Last `\$module_rows` submissions",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "Last `\$module_rows` Items" => "Last `\$module_rows` Items",
// "Last `\$module_rows` visitors" => "Last `\$module_rows` visitors",
// "Last Visitors" => "Last Visitors",
// "No avatar" => "No avatar",
// "You" => "You",
// "Logged in as" => "Logged in as",
// "Switch User" => "Switch User",
// "Switch" => "Switch",
// "Switch user" => "Switch user",
// "Login through CAS" => "Login through CAS",
// "Login as admin" => "Login as admin",
// "Login through Shibboleth" => "Login through Shibboleth",
// "Login as" => "Login as",
// "eMail" => "eMail",
// "CapsLock is on" => "CapsLock is on",
// "year" => "year",
// "Click here to register" => "Click here to register",
// "Click here if you've forgotten your password" => "Click here if you've forgotten your password",
// "Click here to login using the default security protocol" => "Click here to login using the default security protocol",
// "Standard" => "Standard",
// "Click here to login using a secure protocol" => "Click here to login using a secure protocol",
// "Secure" => "Secure",
// "Stay in ssl Mode" => "Stay in ssl Mode",
// "local account" => "local account",
// "OpenID Login" => "OpenID Login",
// "What is OpenID" => "What is OpenID",
// "New Messages" => "New Messages",
// "New Message" => "New Message",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "RSS Feeds" => "RSS Feeds",
// "Wiki RSS" => "Wiki RSS",
// "Blogs RSS" => "Blogs RSS",
// "Articles RSS" => "Articles RSS",
// "Image Galleries RSS" => "Image Galleries RSS",
// "File Galleries RSS" => "File Galleries RSS",
// "Forums RSS" => "Forums RSS",
// "Maps RSS" => "Maps RSS",
// "Calendars" => "Calendars",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Advanced Search Help" => "Advanced Search Help",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "New Images" => "New Images",
// "Wiki Pages Changed" => "Wiki Pages Changed",
// "New Files" => "New Files",
// "New Comments" => "New Comments",
// "New Tracker Items" => "New Tracker Items",
// "New Calendar Events" => "New Calendar Events",
// "New Users" => "New Users",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Site Language" => "Site Language",
// "Site default" => "Site default",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "Top `\$module_rows` articles" => "Top `\$module_rows` articles",
// "Top `\$module_rows` File Galleries" => "Top `\$module_rows` File Galleries",
// "Top `\$module_rows` files" => "Top `\$module_rows` files",
// "Top files" => "Top files",
// "Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
// "Top Forum Posters" => "Top Forum Posters",
// "Top `\$module_rows` games" => "Top `\$module_rows` games",
// "Top `\$module_rows` galleries" => "Top `\$module_rows` galleries",
// "Top `\$module_rows` Images" => "Top `\$module_rows` Images",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Top `\$module_rows` Pages" => "Top `\$module_rows` Pages",
// "Top `\$module_rows` Quizzes" => "Top `\$module_rows` Quizzes",
// "Most `\$module_rows` visited blogs" => "Most `\$module_rows` visited blogs",
// "Top `\$module_rows` Visited FAQs" => "Top `\$module_rows` Visited FAQs",
// "Page translation" => "Page translation",
// "There are no translations of this page" => "There are no translations of this page",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Set your preferred languages" => "Set your preferred languages",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "The Next Event" => "The Next Event",
// "No Upcoming Events" => "No Upcoming Events",
// "click to view" => "click to view",
// "Done" => "Done",
// "Del" => "Del",
// "Public tasks" => "Public tasks",
// "select" => "select",
// "User informations" => "User informations",
// "Group informations" => "Group informations",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "on host" => "on host",
// "Last `\$module_rows` wiki comments" => "Last `\$module_rows` wiki comments",
// "Last wiki comments" => "Last wiki comments",
// "on page" => "on page",
// "Videos on YouTube" => "Videos on YouTube",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "[-]" => "[-]",
// "Send Newsletter" => "Send Newsletter",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "Manage structures" => "Manage structures",
// "By" => "By",
// "Location : " => "Location : ",
// "Read more" => "Read more",
// "Click Here" => "Click Here",
// "Email This Post" => "Email This Post",
// "View Comments" => "View Comments",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Calendar View" => "Calendar View",
// "List View" => "List View",
// "Tiki Action Calendar" => "Tiki Action Calendar",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Look &amp; Feel" => "Look &amp; Feel",
// "i18n" => "i18n",
// "Editing and Plugins" => "Editing and Plugins",
// "Text area" => "Text area",
// "Meta Tags" => "Meta Tags",
// "Community" => "Community",
// "Freetags" => "Freetags",
// "Multimedia" => "Multimedia",
// "Wysiwyg editor" => "Wysiwyg editor",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "Semantic wiki links" => "Semantic wiki links",
// "Semantic links" => "Semantic links",
// "Sef URL" => "Sef URL",
// "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or",
// "Blogs Listing" => "Blogs Listing",
// "Create a blog" => "Create a blog",
// "Not Installed" => "Not Installed",
// "Spell checking" => "Spell checking",
// "Requires a separate download" => "Requires a separate download",
// "Custom blog headings" => "Custom blog headings",
// "Blog-level" => "Blog-level",
// "Post-level" => "Post-level",
// "Default number per page" => "Default number per page",
// "Default ordering" => "Default ordering",
// "Blogs Listings" => "Blogs Listings",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "Title length" => "Title length",
// "Creation date" => "Creation date",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "Change settings" => "Change settings",
// "General settings" => "General settings",
// "Default calendars to display" => "Default calendars to display",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "Create calendar" => "Create calendar",
// "Default view mode" => "Default view mode",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "First day of the week" => "First day of the week",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "Manual selection of time/date" => "Manual selection of time/date",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Group calendars" => "Group calendars",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Category path" => "Category path",
// "Exclude these categories" => "Exclude these categories",
// "Separate category IDs with a comma (,)" => "Separate category IDs with a comma (,)",
// "Show category objects" => "Show category objects",
// "Use PHPLayers for category browser" => "Use PHPLayers for category browser",
// "PHPLayers is disabled" => "PHPLayers is disabled",
// "Enable now" => "Enable now",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Ignore category viewing restrictions" => "Ignore category viewing restrictions",
// "Will improve performance, but may show forbidden results" => "Will improve performance, but may show forbidden results",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Articles Listing" => "Articles Listing",
// "Title of articles home page" => "Title of articles home page",
// "Maximum number of articles on articles home page" => "Maximum number of articles on articles home page",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "Specify notification emails when creating articles" => "Specify notification emails when creating articles",
// "Default article image width" => "Default article image width",
// "Default article image height" => "Default article image height",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Select which items to display when listing articles" => "Select which items to display when listing articles",
// "Publication date" => "Publication date",
// "Expiration date" => "Expiration date",
// "Users Listing" => "Users Listing",
// "Users can choose to show their gender" => "Users can choose to show their gender",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "Show user's information on mouseover" => "Show user's information on mouseover",
// "Requires user's information to be public" => "Requires user's information to be public",
// "Real name" => "Real name",
// "Number of friends" => "Number of friends",
// "Feature is disabled" => "Feature is disabled",
// "Default user preferences" => "Default user preferences",
// "Users Default Preferences" => "Users Default Preferences",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "Show user's info on mouseover" => "Show user's info on mouseover",
// "User messages" => "User messages",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "My workflow" => "My workflow",
// "Select which items to display when listing users" => "Select which items to display when listing users",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "License page" => "License page",
// "Submit notice" => "Submit notice",
// "Enable copyright management for" => "Enable copyright management for",
// "Feature" => "Feature",
// "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or",
// "enable cool sites" => "enable cool sites",
// "New Window" => "New Window",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site",
// "No tabs" => "No tabs",
// "Reset" => "Reset",
// "Main" => "Main",
// "Global Features" => "Global Features",
// "More Functionality" => "More Functionality",
// "UI Enhancements" => "UI Enhancements",
// "Experimental" => "Experimental",
// "Programmer" => "Programmer",
// "Main Features" => "Main Features",
// "Site Global Features" => "Site Global Features",
// "Internationalization" => "Internationalization",
// "Multilingual" => "Multilingual",
// "Additional Features" => "Additional Features",
// "Copyright System" => "Copyright System",
// "Copyright system" => "Copyright system",
// "Tell a Friend" => "Tell a Friend",
// "Minichat" => "Minichat",
// "Comments Moderation" => "Comments Moderation",
// "Comments Locking" => "Comments Locking",
// "User interface enhancement features" => "User interface enhancement features",
// "JsCalendar" => "JsCalendar",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "PHPLayers" => "PHPLayers",
// "PhpLayers Dynamic menus" => "PhpLayers Dynamic menus",
// "Fullscreen" => "Fullscreen",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "Mootools or JQuery" => "Mootools or JQuery",
// "Mootools" => "Mootools",
// "Floating help aka the Big Blue Help Icon" => "Floating help aka the Big Blue Help Icon",
// "Experimental Features" => "Experimental Features",
// "Seem ok" => "Seem ok",
// "Features that may change or might be re-worked in the future" => "Features that may change or might be re-worked in the future",
// "Ajax" => "Ajax",
// "HTML Purifier" => "HTML Purifier",
// "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)" => "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)",
// "JQuery: JavaScript UI effects" => "JQuery: JavaScript UI effects",
// "Mobile" => "Mobile",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Need polish" => "Need polish",
// "Features that need admin help and user patience to work well" => "Features that need admin help and user patience to work well",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "SEFURL" => "SEFURL",
// "Spreadsheet" => "Spreadsheet",
// "Tiki Sheet" => "Tiki Sheet",
// "Ajax auto-save" => "Ajax auto-save",
// "Malfunctioning" => "Malfunctioning",
// "These features have critical faults - not recommended" => "These features have critical faults - not recommended",
// "Magic Admin Panel" => "Magic Admin Panel",
// "Neglected" => "Neglected",
// "Old features no longer maintained" => "Old features no longer maintained",
// "Friendship" => "Friendship",
// "Friendship Network" => "Friendship Network",
// "SWFObject" => "SWFObject",
// "SwfObject" => "SwfObject",
// "Used to embed Flash content in wiki pages, banners etc" => "Used to embed Flash content in wiki pages, banners etc",
// "Action Calendar" => "Action Calendar",
// "Tiki action calendar" => "Tiki action calendar",
// "Redirect On Error" => "Redirect On Error",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "User Contacts" => "User Contacts",
// "Group Watches" => "Group Watches",
// "User Watches Translations" => "User Watches Translations",
// "User Levels" => "User Levels",
// "Group Alert" => "Group Alert",
// "Programmer Features" => "Programmer Features",
// "TikiTests" => "TikiTests",
// "requires PHP5 or more" => "requires PHP5 or more",
// "Use Minified Scripts" => "Use Minified Scripts",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory" => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Gallery Listing" => "Gallery Listing",
// "Search Indexing" => "Search Indexing",
// "Create a Gallery" => "Create a Gallery",
// "Store in database" => "Store in database",
// "Store in directory" => "Store in directory",
// "The server must be able to read/write the directory" => "The server must be able to read/write the directory",
// "The directory can be outside the web space" => "The directory can be outside the web space",
// "Podcast directory" => "Podcast directory",
// "Required for podcasts" => "Required for podcasts",
// "Default Ordering" => "Default Ordering",
// "Allow download limit per file" => "Allow download limit per file",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Score is disabled" => "Score is disabled",
// "Allow same file to be uploaded more than once" => "Allow same file to be uploaded more than once",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "Batch uploading" => "Batch uploading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory" => "The server must be able to read the directory",
// "Require file author's name for anonymous uploads" => "Require file author's name for anonymous uploads",
// "Upload Regex" => "Upload Regex",
// "Must match" => "Must match",
// "Cannot match" => "Cannot match",
// "Gallery Listings" => "Gallery Listings",
// "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries",
// "Select which items to display when listing galleries: " => "Select which items to display when listing galleries: ",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "MIME Type" => "MIME Type",
// "System Command" => "System Command",
// "Reindex all files for search" => "Reindex all files for search",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Forums Listing" => "Forums Listing",
// "Create a forum" => "Create a forum",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Will be a thread title" => "Will be a thread title",
// "Uploaded filenames must match regex" => "Uploaded filenames must match regex",
// "Threads" => "Threads",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Default style" => "Default style",
// "Default sort mode" => "Default sort mode",
// "Forum name search" => "Forum name search",
// "When listing forums" => "When listing forums",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Search is disabled" => "Search is disabled",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Use database (full-text) search" => "Use database (full-text) search",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Description length" => "Description length",
// "3D Tag Browser" => "3D Tag Browser",
// "Show tag cloud" => "Show tag cloud",
// "Maximum number of tags in cloud" => "Maximum number of tags in cloud",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Separate colors with a comma (,)" => "Separate colors with a comma (,)",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "Multilingual freetags" => "Multilingual freetags",
// "Multiligual disabled" => "Multiligual disabled",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Browser width" => "Browser width",
// "Browser height" => "Browser height",
// "Graph appearance" => "Graph appearance",
// "Navigation depth" => "Navigation depth",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Spring (connection) size" => "Spring (connection) size",
// "Node color" => "Node color",
// "Camera settinsg" => "Camera settinsg",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Camera distance" => "Camera distance",
// "Field of view" => "Field of view",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Physics engine" => "Physics engine",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "You can upload images of a size of " => "You can upload images of a size of ",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "Home Gallery" => "Home Gallery",
// "Uses Slideshow" => "Uses Slideshow",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below" => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below",
// "Directory Batch Loading" => "Directory Batch Loading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Enable directory batch loading" => "Enable directory batch loading",
// "Batch loading directory" => "Batch loading directory",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Pixels Default" => "Pixels Default",
// "Default scale size" => "Default scale size",
// "pixels" => "pixels",
// "Exterminator" => "Exterminator",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "System Gallery" => "System Gallery",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Change configuration" => "Change configuration",
// "Go to group homepage only if login from default homepage" => "Go to group homepage only if login from default homepage",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Smarty Security" => "Smarty Security",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "(standard)" => "(standard)",
// "(some Unix MTA)" => "(some Unix MTA)",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "Protect against CSRF with a ticket" => "Protect against CSRF with a ticket",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "Site Access" => "Site Access",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "Host" => "Host",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Performance" => "Performance",
// "Cache external pages" => "Cache external pages",
// "Cache external images" => "Cache external images",
// "GZip output" => "GZip output",
// "Output compression is active" => "Output compression is active",
// "Compression is handled by" => "Compression is handled by",
// "Session" => "Session",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Enabling this feature will immediately log you out when you save this preference" => "Enabling this feature will immediately log you out when you save this preference",
// "Session lifetime" => "Session lifetime",
// "The \"Contact Us\" feature is disabled" => "The \"Contact Us\" feature is disabled",
// "Allow anonymous visitors to use the \"Contact Us\"" => "Allow anonymous visitors to use the \"Contact Us\"",
// "Help URL" => "Help URL",
// "The default help system may not be complete" => "The default help system may not be complete",
// "You can help with the TikiWiki documentation" => "You can help with the TikiWiki documentation",
// "Show user's real name instead of login (when possible)" => "Show user's real name instead of login (when possible)",
// "Highlight group" => "Highlight group",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Separators" => "Separators",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Examples" => "Examples",
// "Choices" => "Choices",
// "Default timezone" => "Default timezone",
// "Use site default to show times" => "Use site default to show times",
// "Detect user timezone (if browser allows). Otherwise use site default" => "Detect user timezone (if browser allows). Otherwise use site default",
// "Sample" => "Sample",
// "Fields display order" => "Fields display order",
// "Change the <strong>Admin</strong> password" => "Change the <strong>Admin</strong> password",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at " => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at ",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Default language" => "Default language",
// "Detect browser language" => "Detect browser language",
// "Show pages in user's preferred language" => "Show pages in user's preferred language",
// "User preferences are disabled" => "User preferences are disabled",
// "Users can change site language" => "Users can change site language",
// "Restrict supported languages" => "Restrict supported languages",
// "Available languages" => "Available languages",
// "Use Ctrl+Click to select multiple languages" => "Use Ctrl+Click to select multiple languages",
// "Display available translations" => "Display available translations",
// "Changing page language will also change the site language" => "Changing page language will also change the site language",
// "Translation assistant" => "Translation assistant",
// "Urgent translation notifications" => "Urgent translation notifications",
// "Quantify change size" => "Quantify change size",
// "Multilingual structures" => "Multilingual structures",
// "Structures are disabled" => "Structures are disabled",
// "Multilingual One Page feature" => "Multilingual One Page feature",
// "Syntax error" => "Syntax error",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// "as master" => "as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "Text Area" => "Text Area",
// "Semantic" => "Semantic",
// "Webservices management" => "Webservices management",
// "Admin Groups" => "Admin Groups",
// "Admin Users" => "Admin Users",
// "PAM" => "PAM",
// "CAS" => "CAS",
// "Tiki" => "Tiki",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Registration" => "Registration",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "Cookie name" => "Cookie name",
// "Username pattern" => "Username pattern",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords </em>are stored<em> as plain text, the password will be emailed to the user" => "If passwords </em>are stored<em> as plain text, the password will be emailed to the user",
// "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user" => "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user",
// "Encryption method" => "Encryption method",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "You must change the Authentication Method to PEAR::Auth for these changes to take effect" => "You must change the Authentication Method to PEAR::Auth for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in Auth" => "Create user if not in Auth",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "LDAP" => "LDAP",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "LDAP Group" => "LDAP Group",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group OC" => "Group OC",
// "LDAP Member" => "LDAP Member",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "PAM service" => "PAM service",
// "Currently unused" => "Currently unused",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "Default group" => "Default group",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/" => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/",
// "CAS server version" => "CAS server version",
// "Version 1.0" => "Version 1.0",
// "Version 2.0" => "Version 2.0",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "General Layout" => "General Layout",
// "UI Effects" => "UI Effects",
// "The \"users can change theme\" feature will override the theme displayed" => "The \"users can change theme\" feature will override the theme displayed",
// "Theme not saved yet - click \"Apply\"" => "Theme not saved yet - click \"Apply\"",
// "Theme options" => "Theme options",
// "Users can change theme" => "Users can change theme",
// "Restrict available themes" => "Restrict available themes",
// "Available styles" => "Available styles",
// "Each group can have its theme" => "Each group can have its theme",
// "Use transition style sheet from version" => "Use transition style sheet from version",
// "Template Viewing" => "Template Viewing",
// "View Templates" => "View Templates",
// "Shadow layer" => "Shadow layer",
// "Enable additional general layout layers for shadows, rounded corners or other decorative styling" => "Enable additional general layout layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Custom Site Header" => "Custom Site Header",
// "Activate will only show content for admin. Check Publish to use content for all users" => "Activate will only show content for admin. Check Publish to use content for all users",
// "Site Logo and Title" => "Site Logo and Title",
// "Site logo source (image path)" => "Site logo source (image path)",
// "Site logo background color" => "Site logo background color",
// "Site logo background style" => "Site logo background style",
// "Site logo alignment" => "Site logo alignment",
// "Site logo title (on mouse over)" => "Site logo title (on mouse over)",
// "Alt. description (e.g. for text browsers)" => "Alt. description (e.g. for text browsers)",
// "Site title" => "Site title",
// "Site subtitle" => "Site subtitle",
// "Site Search Bar" => "Site Search Bar",
// "Site Login Bar" => "Site Login Bar",
// "Top Bar" => "Top Bar",
// "Site menu bar" => "Site menu bar",
// "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  " => "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  ",
// "Menu ID" => "Menu ID",
// "Current Version" => "Current Version",
// "Custom code" => "Custom code",
// "Users can Flip Columns" => "Users can Flip Columns",
// "always" => "always",
// "user decides" => "user decides",
// "Site Breadcrumbs" => "Site Breadcrumbs",
// "Site location bar" => "Site location bar",
// "at top of page" => "at top of page",
// "at top of center column" => "at top of center column",
// "Prefix breadcrumbs with 'Location : '" => "Prefix breadcrumbs with 'Location : '",
// "Larger font for" => "Larger font for",
// "entire location" => "entire location",
// "page name" => "page name",
// "Use page description" => "Use page description",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Left blank to use the default sender email" => "Left blank to use the default sender email",
// "Custom End of <body> Code" => "Custom End of <body> Code",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "Bottom bar (RSS)" => "Bottom bar (RSS)",
// "Power by" => "Power by",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item" => "Max. number of links around the current item",
// "Max. number of links after the first or before the last item" => "Max. number of links after the first or before the last item",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "Use Icons" => "Use Icons",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Requires jquery feature" => "Requires jquery feature",
// "JQuery Tooltips" => "JQuery Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "JQuery Superfish" => "JQuery Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "JQuery Reflection" => "JQuery Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "For future use" => "For future use",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules etc" => "Effect for modules etc",
// "Main JQuery effect" => "Main JQuery effect",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Effect speed" => "Effect speed",
// "Fast" => "Fast",
// "Slow" => "Slow",
// "Effect direction" => "Effect direction",
// "Vertical" => "Vertical",
// "Horizontal" => "Horizontal",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Effect speed for tabs" => "Effect speed for tabs",
// "Effect direction for tabs" => "Effect direction for tabs",
// "Other options" => "Other options",
// "Use Tabs" => "Use Tabs",
// "Favicon icon file name" => "Favicon icon file name",
// "Favicon icon MIME type" => "Favicon icon MIME type",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "List of CSS selectors to be fixed, each selector separated by comma" => "List of CSS selectors to be fixed, each selector separated by comma",
// "List of HTMLDomElements to be fixed, each element separated by comma" => "List of HTMLDomElements to be fixed, each element separated by comma",
// "Context Menus (only in file galleries so far)" => "Context Menus (only in file galleries so far)",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "Full path to ogr2ogr" => "Full path to ogr2ogr",
// "Map Zone" => "Map Zone",
// "Generate User Map" => "Generate User Map",
// "Maximum mailbox size (messages, 0=unlimited)" => "Maximum mailbox size (messages, 0=unlimited)",
// "Maximum mail archive size (messages, 0=unlimited)" => "Maximum mail archive size (messages, 0=unlimited)",
// "Maximum sent box size (messages, 0=unlimited)" => "Maximum sent box size (messages, 0=unlimited)",
// "Change Preferences" => "Change Preferences",
// "Meta tags" => "Meta tags",
// "Keywords" => "Keywords",
// "Include freetags" => "Include freetags",
// "Use thread title instead" => "Use thread title instead",
// "Use image title instead" => "Use image title instead",
// "Geo URL" => "Geo URL",
// "geo.position" => "geo.position",
// "geo.region" => "geo.region",
// "geo.placename" => "geo.placename",
// "Robots" => "Robots",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "Admin &gt; Modules" => "Admin &gt; Modules",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Show module controls" => "Show module controls",
// "Users can shade modules" => "Users can shade modules",
// "Module decides" => "Module decides",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Video Length" => "Video Length",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Show categories" => "Show categories",
// "Categories disabled" => "Categories disabled",
// "Show objects" => "Show objects",
// "Are you sure you want to install the profile" => "Are you sure you want to install the profile",
// "TikiWiki Profiles" => "TikiWiki Profiles",
// "Profile repository" => "Profile repository",
// "Filter the list of profiles" => "Filter the list of profiles",
// "Profile" => "Profile",
// "Repository" => "Repository",
// "installed" => "installed",
// "Repositories" => "Repositories",
// "Repository URLs" => "Repository URLs",
// "Enter multiple repository URLs, one per line" => "Enter multiple repository URLs, one per line",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "More information" => "More information",
// "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or" => "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or",
// "Feed for articles" => "Feed for articles",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Show Author" => "Show Author",
// "Homepage URL" => "Homepage URL",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Map files" => "Map files",
// "Feed for maps" => "Feed for maps",
// "Defaults" => "Defaults",
// "Image Path" => "Image Path",
// "Caching time" => "Caching time",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public" => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "Admin modules" => "Admin modules",
// "Expiration" => "Expiration",
// "can be seen on page" => "can be seen on page",
// "Search Results" => "Search Results",
// "Search type" => "Search type",
// "Database search" => "Database search",
// "This search uses the MySQL Full-Text feature" => "This search uses the MySQL Full-Text feature",
// "Tiki search" => "Tiki search",
// "This database-independent search is always enabled" => "This database-independent search is always enabled",
// "Specify the Tiki search settings" => "Specify the Tiki search settings",
// "Refresh mode" => "Refresh mode",
// "Use <strong>0</strong> for no refresh" => "Use <strong>0</strong> for no refresh",
// "Minimum length of search word" => "Minimum length of search word",
// "Max. number of words containing a syllable" => "Max. number of words containing a syllable",
// "Max. age in hours of syllable search cache" => "Max. age in hours of syllable search cache",
// "LRU list purging rate" => "LRU list purging rate",
// "LRU list length" => "LRU list length",
// "When the Database search is enabled, you must manually refresh the Tiki search indexes" => "When the Database search is enabled, you must manually refresh the Tiki search indexes",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "Referer Search Highlighting" => "Referer Search Highlighting",
// "Parse the results" => "Parse the results",
// "May impact performance" => "May impact performance",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Ignore individual object permissions" => "Ignore individual object permissions",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Object filter" => "Object filter",
// "Search box" => "Search box",
// "Select the information to display for each result" => "Select the information to display for each result",
// "Pertinence" => "Pertinence",
// "Last modified date" => "Last modified date",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Known Types" => "Known Types",
// "Token" => "Token",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "No occurences found" => "No occurences found",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Plugins" => "Plugins",
// "Plugin Aliases" => "Plugin Aliases",
// "Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonymous editors must enter anti-bot code (CAPTCHA)",
// "Protect email against spam" => "Protect email against spam",
// "External link icon" => "External link icon",
// "External links will be identified with" => "External links will be identified with",
// "Use File Galleries to store pictures " => "Use File Galleries to store pictures ",
// "Allow to post comments as Anonymous" => "Allow to post comments as Anonymous",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "&lt;return&gt; for rows" => "&lt;return&gt; for rows",
// "Show quicktags above textareas" => "Show quicktags above textareas",
// "If disabled, quicktags will be shown to the left of textareas" => "If disabled, quicktags will be shown to the left of textareas",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Plugin disabled" => "Plugin disabled",
// "Default size" => "Default size",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "(experimental - not comprehensively tested and requires new JQuery feature)" => "(experimental - not comprehensively tested and requires new JQuery feature)",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "General Information" => "General Information",
// "Plugin Name" => "Plugin Name",
// "Base Plugin" => "Base Plugin",
// "Body Label" => "Body Label",
// "Dependencies" => "Dependencies",
// "Validation" => "Validation",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Encoding" => "Encoding",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Default Value" => "Default Value",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Validate choice" => "Validate choice",
// "Tracker attachments" => "Tracker attachments",
// "Storage" => "Storage",
// "Change" => "Change",
// "No records" => "No records",
// "Change all to db" => "Change all to db",
// "Change all to file" => "Change all to file",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Create New" => "Create New",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Page Listings" => "Page Listings",
// "If the page does not exist, it will be created" => "If the page does not exist, it will be created",
// "Wiki link format" => "Wiki link format",
// "Latin" => "Latin",
// "Select the characters that can be used with Wiki link syntax: ((page name))" => "Select the characters that can be used with Wiki link syntax: ((page name))",
// "Page display" => "Page display",
// "Page ID" => "Page ID",
// "Page version" => "Page version",
// "Page name display stripper" => "Page name display stripper",
// "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>" => "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>",
// "Allow override per page" => "Allow override per page",
// "Display show/hide icon displayed before headings" => "Display show/hide icon displayed before headings",
// "Wiki action bar" => "Wiki action bar",
// "Buttons: Save, Preview, Cancel, .." => "Buttons: Save, Preview, Cancel, ..",
// "Page navigation bar location" => "Page navigation bar location",
// "When using the ...page... page break wiki syntax" => "When using the ...page... page break wiki syntax",
// "Wiki top line" => "Wiki top line",
// "Neither" => "Neither",
// "Page description, icons, backlinks, .." => "Page description, icons, backlinks, ..",
// "Wiki buttons" => "Wiki buttons",
// "Buttons: Edit, Source, Remove, .." => "Buttons: Edit, Source, Remove, ..",
// "Cache wiki pages (global)" => "Cache wiki pages (global)",
// "Warn on edit conflict" => "Warn on edit conflict",
// "Edit idle timeout" => "Edit idle timeout",
// "Save draft" => "Save draft",
// "Requires AJAX" => "Requires AJAX",
// "experimental" => "experimental",
// "Footnotes" => "Footnotes",
// "Permission" => "Permission",
// "Edit section" => "Edit section",
// "Edit section level" => "Edit section level",
// "Allow minor edits" => "Allow minor edits",
// "Minor edits do not flag new content for translation and do not send watch notifications" => "Minor edits do not flag new content for translation and do not send watch notifications",
// "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled",
// "Regex search and replace" => "Regex search and replace",
// "Log bytes changes (+/-) in action logs" => "Log bytes changes (+/-) in action logs",
// "Display by default" => "Display by default",
// "Manage attachments" => "Manage attachments",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Restore" => "Restore",
// "WikiWords" => "WikiWords",
// "Accept dashes and underscores in WikiWords" => "Accept dashes and underscores in WikiWords",
// "Maximum number of versions" => "Maximum number of versions",
// "Never delete versions younger than" => "Never delete versions younger than",
// "Display IP address" => "Display IP address",
// "Default diff style" => "Default diff style",
// "HTML diff" => "HTML diff",
// "Side-by-side diff" => "Side-by-side diff",
// "Side-by-side diff by characters" => "Side-by-side diff by characters",
// "Inline diff" => "Inline diff",
// "Inline diff by characters" => "Inline diff by characters",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "History includes only page data, description, and change comment" => "History includes only page data, description, and change comment",
// "Forums are disabled" => "Forums are disabled",
// "Forum for discussion" => "Forum for discussion",
// "View source" => "View source",
// "Polls are disabled" => "Polls are disabled",
// "like pages" => "like pages",
// "Open page as structure" => "Open page as structure",
// "Make structure from page" => "Make structure from page",
// "Categorize structure pages together" => "Categorize structure pages together",
// "Create webhelp from structure" => "Create webhelp from structure",
// "Import pages" => "Import pages",
// "Slideshows" => "Slideshows",
// "User's page" => "User's page",
// "UserPage prefix" => "UserPage prefix",
// "Users can lock pages" => "Users can lock pages",
// "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page" => "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page",
// "Wiki watch" => "Wiki watch",
// "Create watch for author on page creation" => "Create watch for author on page creation",
// "Enable watch events when I am the editor" => "Enable watch events when I am the editor",
// "Watch minor edits" => "Watch minor edits",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "Approved" => "Approved",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Out-of-sync" => "Out-of-sync",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Orphan page" => "Orphan page",
// "Configuration" => "Configuration",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Name length" => "Name length",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Categories path" => "Categories path",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Toolbar content" => "Toolbar content",
// "Database Version Problem" => "Database Version Problem",
// "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "The following list of changes has been applied" => "The following list of changes has been applied",
// "preference" => "preference",
// "preference name" => "preference name",
// "Other sections" => "Other sections",
// "Administration features" => "Administration features",
// "Security" => "Security",
// "TikiCache/System" => "TikiCache/System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Edit Languages" => "Edit Languages",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look &amp; feel" => "Look &amp; feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Report" => "Report",
// "Setting" => "Setting",
// "Please select some actions to view" => "Please select some actions to view",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "recorded" => "recorded",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Create Calendar" => "Create Calendar",
// "View Calendars" => "View Calendars",
// "Edit Calendar" => "Edit Calendar",
// "Loc" => "Loc",
// "Cat" => "Cat",
// "Lang" => "Lang",
// "Prio" => "Prio",
// "Subscription" => "Subscription",
// "Perso" => "Perso",
// "View Calendar" => "View Calendar",
// "Create/Edit Calendars" => "Create/Edit Calendars",
// "Custom Participants" => "Custom Participants",
// "Custom URL" => "Custom URL",
// "Custom Subscription List" => "Custom Subscription List",
// "Personal Calendar" => "Personal Calendar",
// "Start of day" => "Start of day",
// "End of day" => "End of day",
// "Standard Colors" => "Standard Colors",
// "Green" => "Green",
// "Blue" => "Blue",
// "Purple" => "Purple",
// "Red" => "Red",
// "Orange" => "Orange",
// "Yellow" => "Yellow",
// "Let me select my own colors" => "Let me select my own colors",
// "Custom foreground color" => "Custom foreground color",
// "Ex" => "Ex",
// "Custom background color" => "Custom background color",
// "Default event status" => "Default event status",
// "Show in calendar view" => "Show in calendar view",
// "Group of users alerted when calendar event is modified" => "Group of users alerted when calendar event is modified",
// "Delete events older than" => "Delete events older than",
// "Browse the category system" => "Browse the category system",
// "Current Category ID" => "Current Category ID",
// "Edit permissions for this category" => "Edit permissions for this category",
// "Perms inherited from closest parent if possible or from global perms" => "Perms inherited from closest parent if possible or from global perms",
// "Assign permissions automatically" => "Assign permissions automatically",
// "recommended for best performance" => "recommended for best performance",
// "Remove from this Category" => "Remove from this Category",
// "Edit Chart" => "Edit Chart",
// "Users can vote for only one item from this chart per period" => "Users can vote for only one item from this chart per period",
// "Prevent users from voting for the same item more than once" => "Prevent users from voting for the same item more than once",
// "Use in" => "Use in",
// "No features are configured to use templates" => "No features are configured to use templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Admin Contributions" => "Admin Contributions",
// "Edit the contribution" => "Edit the contribution",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}" => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link" => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link",
// "Use Admin DSN to define the database to be used by the SQL plugin" => "Use Admin DSN to define the database to be used by the SQL plugin",
// "Admin External Wikis" => "Admin External Wikis",
// "View template" => "View template",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "Edit template" => "Edit template",
// "ExtWiki" => "ExtWiki",
// "Enable Features" => "Enable Features",
// "View this forum" => "View this forum",
// "Send mails even when the post is generated by inbound mail" => "Send mails even when the post is generated by inbound mail",
// "Online" => "Online",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate" => "Duplicate",
// "Coms" => "Coms",
// "Age" => "Age",
// "PPD" => "PPD",
// ".." => "..",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Last Modif" => "Last Modif",
// "Admin dynamic zones" => "Admin dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "List Repositories" => "List Repositories",
// "New Repository" => "New Repository",
// "View Repository" => "View Repository",
// "Configure Repositories" => "Configure Repositories",
// "Configure this Repository" => "Configure this Repository",
// "View this Repository" => "View this Repository",
// "New Rule" => "New Rule",
// "Copy Rules" => "Copy Rules",
// "Regex modifiers" => "Regex modifiers",
// "Configure/Options" => "Configure/Options",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "Mail-in accounts" => "Mail-in accounts",
// "Account" => "Account",
// "Add new Mail-in account" => "Add new Mail-in account",
// "Edit Mail-in account" => "Edit Mail-in account",
// "article-put" => "article-put",
// "Allow anonymous acces" => "Allow anonymous acces",
// "Allow attachments" => "Allow attachments",
// "Discard to the end from" => "Discard to the end from",
// "Check Mail-in accounts" => "Check Mail-in accounts",
// "Check automatically" => "Check automatically",
// "mn" => "mn",
// "Show Quick Urls" => "Show Quick Urls",
// "Hide Quick Urls" => "Hide Quick Urls",
// "For wiki page, use ((PageName))" => "For wiki page, use ((PageName))",
// "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Use Ctrl+Click to select multiple groups" => "Use Ctrl+Click to select multiple groups",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "separator" => "separator",
// "Choose" => "Choose",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format" => "To use a menu in a tiki format",
// "To use menu in a css/suckerfish format" => "To use menu in a css/suckerfish format",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "Folder Icon" => "Folder Icon",
// "Path and filename of closed folder icon" => "Path and filename of closed folder icon",
// "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder",
// "In the same directory, include an icon for the opened folder" => "In the same directory, include an icon for the opened folder",
// "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>",
// "For example, the default icon is: pics/icons/folder.png" => "For example, the default icon is: pics/icons/folder.png",
// "The name of the \"open folder\" icon is: pics/icons/ofolder.png" => "The name of the \"open folder\" icon is: pics/icons/ofolder.png",
// "Options" => "Options",
// "Active Permissions" => "Active Permissions",
// "Clear Cache" => "Clear Cache",
// "Assign/Edit modules" => "Assign/Edit modules",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "Move to Right Column" => "Move to Right Column",
// "Unassign" => "Unassign",
// "Move to Left Column" => "Move to Left Column",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site" => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site",
// "Must be wiki parsed" => "Must be wiki parsed",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "Use Poll" => "Use Poll",
// "Use Gallery" => "Use Gallery",
// "Use Dynamic Content" => "Use Dynamic Content",
// "Use RSS Module" => "Use RSS Module",
// "Use Menu" => "Use Menu",
// "phpLayersMenus" => "phpLayersMenus",
// "Use phplayermenu" => "Use phplayermenu",
// "Use Banner Zone" => "Use Banner Zone",
// "Use Wiki Structure" => "Use Wiki Structure",
// "List Newsletters" => "List Newsletters",
// "Edit Newsletter" => "Edit Newsletter",
// "Admin Newsletters" => "Admin Newsletters",
// "You can add several email addresses by separating them with commas" => "You can add several email addresses by separating them with commas",
// "Add email" => "Add email",
// "Add user" => "Add user",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Subscribed" => "Subscribed",
// "Create Newsletter" => "Create Newsletter",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Editions" => "Editions",
// "Drafts" => "Drafts",
// "Last Sent" => "Last Sent",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications",
// "Alert" => "Alert",
// "A user edits an article" => "A user edits an article",
// "A user deletes an article" => "A user deletes an article",
// "Any wiki page is changed, even minor changes" => "Any wiki page is changed, even minor changes",
// "A comment in a wiki page is posted or edited" => "A comment in a wiki page is posted or edited",
// "PHP error" => "PHP error",
// "Preload Admin Account" => "Preload Admin Account",
// "Multiple" => "Multiple",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Add Option" => "Add Option",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "0 for no limit" => "0 for no limit",
// "Span" => "Span",
// "Add poll to pages" => "Add poll to pages",
// "Wiki pages" => "Wiki pages",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Lock the pages" => "Lock the pages",
// "Quicktags category filter" => "Quicktags category filter",
// "Admin RSS Modules" => "Admin RSS Modules",
// "Tips" => "Tips",
// "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed" => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed",
// "Edit this RSS Module" => "Edit this RSS Module",
// "Create new RSS Module" => "Create new RSS Module",
// "RSS channels" => "RSS channels",
// "Show Date" => "Show Date",
// "View feed" => "View feed",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>" => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>",
// "PHP settings" => "PHP settings",
// "PHP variable" => "PHP variable",
// "Risk Factor" => "Risk Factor",
// "Explanation" => "Explanation",
// "TikiWiki settings" => "TikiWiki settings",
// "Tiki variable" => "Tiki variable",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
// "Security checks" => "Security checks",
// "Check all tiki files" => "Check all tiki files",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini" => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini",
// "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database" => "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database",
// "File checks" => "File checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments" => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments",
// "See end of table for detailed explanations" => "See end of table for detailed explanations",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "Admin Shoutbox Words" => "Admin Shoutbox Words",
// "Add Banned Word" => "Add Banned Word",
// "Are you sure you want to delete this word" => "Are you sure you want to delete this word",
// "The structure" => "The structure",
// "has just been created" => "has just been created",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "Edit structure" => "Edit structure",
// "View structure" => "View structure",
// "Dump Tree" => "Dump Tree",
// "View WebHelp" => "View WebHelp",
// "Xml Zip" => "Xml Zip",
// "Tree" => "Tree",
// "Create New Structure" => "Create New Structure",
// "Edit survey questions" => "Edit survey questions",
// "Add a New Question" => "Add a New Question",
// "Survey Stats" => "Survey Stats",
// "This survey stats" => "This survey stats",
// "Edit this Survey" => "Edit this Survey",
// "Admin Surveys" => "Admin Surveys",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Wiki textarea" => "Wiki textarea",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "Min" => "Min",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Create New Survey" => "Create New Survey",
// "Open" => "Open",
// "Tiki Cache/System Admin" => "Tiki Cache/System Admin",
// "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)" => "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)",
// "Directory to exterminate" => "Directory to exterminate",
// "Clear all Tiki caches" => "Clear all Tiki caches",
// "Empty" => "Empty",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save" => "Directories to save",
// "Full Path to the Zip File" => "Full Path to the Zip File",
// "Generate a zip of those directories" => "Generate a zip of those directories",
// "A zip has been written to {\$zipPath}" => "A zip has been written to {\$zipPath}",
// "Directory is not writeable" => "Directory is not writeable",
// "Templates compiler" => "Templates compiler",
// "Compile" => "Compile",
// "Advanced feature" => "Advanced feature",
// "Fix UTF-8 Errors in Tables" => "Fix UTF-8 Errors in Tables",
// "Warning: Make a backup of your Database before using this function" => "Warning: Make a backup of your Database before using this function",
// "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini" => "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini",
// "This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "This function converts ISO-8859-1 encoded strings in your tables to UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "Investigate" => "Investigate",
// "Fix it" => "Fix it",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "Remove with articles" => "Remove with articles",
// "Admin Tracker" => "Admin Tracker",
// "Admin Trackers" => "Admin Trackers",
// "Edit This Tracker" => "Edit This Tracker",
// "View This Tracker's Items" => "View This Tracker's Items",
// "New tracker field" => "New tracker field",
// "Edit tracker field" => "Edit tracker field",
// "Select list items that will be displayed" => "Select list items that will be displayed",
// "Multilingual content" => "Multilingual content",
// "Column is searchable" => "Column is searchable",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "Field is hidden" => "Field is hidden",
// "not hidden" => "not hidden",
// "visible to admin only" => "visible to admin only",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by" => "Visible by",
// "Editable by" => "Editable by",
// "Field is mandatory" => "Field is mandatory",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Error message" => "Error message",
// "Searchable" => "Searchable",
// "Hidden" => "Hidden",
// "Mandatory" => "Mandatory",
// "Import/Export Trackers Fields" => "Import/Export Trackers Fields",
// "Export fieldId also" => "Export fieldId also",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "Edit Tracker" => "Edit Tracker",
// "Import/Export" => "Import/Export",
// "Create Tracker" => "Create Tracker",
// "Duplicate Tracker" => "Duplicate Tracker",
// "with" => "with",
// "Create/Edit Tracker" => "Create/Edit Tracker",
// "No individual permissions. Global permissions apply" => "No individual permissions. Global permissions apply",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Create a group for each item" => "Create a group for each item",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL",
// "Show status" => "Show status",
// "Default status displayed in list mode" => "Default status displayed in list mode",
// "Show status to tracker admin only" => "Show status to tracker admin only",
// "Send copies of all activity in this tracker to this e-mail address" => "Send copies of all activity in this tracker to this e-mail address",
// "Use simplified e-mail format" => "Use simplified e-mail format",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "New items are created with status" => "New items are created with status",
// "Authoritative status for modified items" => "Authoritative status for modified items",
// "No change" => "No change",
// "Item creator can modify his items" => "Item creator can modify his items",
// "The tracker needs a user field with the option 1" => "The tracker needs a user field with the option 1",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Member of the default group of creator can modify items" => "Member of the default group of creator can modify items",
// "The tracker needs a group field with the option 1" => "The tracker needs a group field with the option 1",
// "Format if not the default short one" => "Format if not the default short one",
// "Show creation date when viewing tracker item" => "Show creation date when viewing tracker item",
// "Show lastModif date when viewing tracker item" => "Show lastModif date when viewing tracker item",
// "What field is used for default sort" => "What field is used for default sort",
// "ItemId" => "ItemId",
// "What is default sort order in list" => "What is default sort order in list",
// "Tracker items allow ratings" => "Tracker items allow ratings",
// "with values" => "with values",
// "and display rating results in listing" => "and display rating results in listing",
// "and display comments in listing" => "and display comments in listing",
// "and display last comment user/date" => "and display last comment user/date",
// "and display attachments in listing" => "and display attachments in listing",
// "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)",
// "Filetype" => "Filetype",
// "LongDesc" => "LongDesc",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "After" => "After",
// "Before" => "Before",
// "Do not show empty fields in item view" => "Do not show empty fields in item view",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items",
// "Group of users alerted when tracker is modified" => "Group of users alerted when tracker is modified",
// "Import/export trackers" => "Import/export trackers",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Edit group" => "Edit group",
// "Members" => "Members",
// "Add a New Group" => "Add a New Group",
// "User Choice" => "User Choice",
// "Only directly included" => "Only directly included",
// "will have all the permissions of the included groups" => "will have all the permissions of the included groups",
// "Group Homepage" => "Group Homepage",
// "Use wiki page name or full URL" => "Use wiki page name or full URL",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker .." => "choose a group tracker ..",
// "choose a field .." => "choose a field ..",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker .." => "choose a users tracker ..",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Edit Item" => "Edit Item",
// "Group tracker item not found" => "Group tracker item not found",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Members List" => "Members List",
// "Remove from Group" => "Remove from Group",
// "users in group" => "users in group",
// "Add to group" => "Add to group",
// "Download CSV export" => "Download CSV export",
// "Assign users to group" => "Assign users to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "CSV File" => "CSV File",
// "Add a New User" => "Add a New User",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Updated users" => "Updated users",
// "Edit user" => "Edit user",
// "More Criteria" => "More Criteria",
// "Group (direct)" => "Group (direct)",
// "Edit Account Settings" => "Edit Account Settings",
// "ago" => "ago",
// "Need to validate email" => "Need to validate email",
// "Assign to group" => "Assign to group",
// "Edit Included Group" => "Edit Included Group",
// "Edit Group" => "Edit Group",
// "Change user preferences" => "Change user preferences",
// "Validate user" => "Validate user",
// "Remove Users and their Userpages" => "Remove Users and their Userpages",
// "Manage Group Assignments" => "Manage Group Assignments",
// "Set Default Groups" => "Set Default Groups",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "Assign selected to" => "Assign selected to",
// "Remove selected from" => "Remove selected from",
// "the following groups" => "the following groups",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "Template wiki page" => "Template wiki page",
// "Assign user to Groups" => "Assign user to Groups",
// "Use the email as username" => "Use the email as username",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth" => "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth",
// "Repeat Password" => "Repeat Password",
// "User must change password at first login" => "User must change password at first login",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "Last Login" => "Last Login",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "Don't overwrite" => "Don't overwrite",
// "Overwrite groups" => "Overwrite groups",
// "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
// "Loading.." => "Loading..",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Show Help" => "Show Help",
// "Article type" => "Article type",
// "Shows up in the drop down list of article types" => "Shows up in the drop down list of article types",
// "Allow ratings by the author" => "Allow ratings by the author",
// "non-admins can view before the publish date" => "non-admins can view before the publish date",
// "non-admins can view after the expire date" => "non-admins can view after the expire date",
// "No article body, heading only" => "No article body, heading only",
// "Allow comments for this type" => "Allow comments for this type",
// "Allow comments to include a rating value" => "Allow comments to include a rating value",
// "Show topic or own image" => "Show topic or own image",
// "Show author's avatar" => "Show author's avatar",
// "Show author name" => "Show author name",
// "Show the number of times the article was read" => "Show the number of times the article was read",
// "Show the size of the article" => "Show the size of the article",
// "Show topline" => "Show topline",
// "Show a small title over the title" => "Show a small title over the title",
// "Show subtitle" => "Show subtitle",
// "Show the subtitle" => "Show the subtitle",
// "Show source" => "Show source",
// "Show link to source after article body" => "Show link to source after article body",
// "Show Image Caption" => "Show Image Caption",
// "Show a legend under the image" => "Show a legend under the image",
// "Show Language" => "Show Language",
// "Show the language" => "Show the language",
// "The person who submits an article of this type can edit it" => "The person who submits an article of this type can edit it",
// "Actions on this article type" => "Actions on this article type",
// "Show lang" => "Show lang",
// "Classified" => "Classified",
// "Assign permissions to group" => "Assign permissions to group",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Level configuration" => "Level configuration",
// "Assign User {\$assign_user} to Groups" => "Assign User {\$assign_user} to Groups",
// "Assign Perms to this Group" => "Assign Perms to this Group",
// "Assign User to Group" => "Assign User to Group",
// "Directory batch upload" => "Directory batch upload",
// "Browse Gallery" => "Browse Gallery",
// "Upload From Disk" => "Upload From Disk",
// "available images" => "available images",
// "Remove File Extension from Image Name" => "Remove File Extension from Image Name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Select a Gallery" => "Select a Gallery",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "available files" => "available files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "Use Wysiwyg Editor" => "Use Wysiwyg Editor",
// "Use Normal Editor" => "Use Normal Editor",
// "View Blog" => "View Blog",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "Mark entry as private" => "Mark entry as private",
// "Save and Exit" => "Save and Exit",
// "Report to Webmaster" => "Report to Webmaster",
// "Powered by" => "Powered by",
// "Made with" => "Made with",
// "powered by" => "powered by",
// "The TikiWiki Community" => "The TikiWiki Community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "database queries used in " => "database queries used in ",
// "Last update from SVN" => "Last update from SVN",
// "Watch Only This Category" => "Watch Only This Category",
// "Watch This Category and Their Descendants" => "Watch This Category and Their Descendants",
// "Stop Watching Only This Category" => "Stop Watching Only This Category",
// "Stop Watching This Category and Their Descendants" => "Stop Watching This Category and Their Descendants",
// "Admin Category" => "Admin Category",
// "Admin the Category System" => "Admin the Category System",
// "Browse in" => "Browse in",
// "Trackers Items" => "Trackers Items",
// "Sheets" => "Sheets",
// "in the current category - and its subcategories: " => "in the current category - and its subcategories: ",
// "Hide subcategories objects" => "Hide subcategories objects",
// "Show subcategories objects" => "Show subcategories objects",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "Clear" => "Clear",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "\$feature_label" => "\$feature_label",
// "results found" => "results found",
// "Browsing Gallery" => "Browsing Gallery",
// "List Galleries" => "List Galleries",
// "Edit Gallery" => "Edit Gallery",
// "Rebuild Thumbnails" => "Rebuild Thumbnails",
// "Directory Batch" => "Directory Batch",
// "List Gallery" => "List Gallery",
// "All Images" => "All Images",
// "Monitor this Gallery" => "Monitor this Gallery",
// "Stop Monitoring this Gallery" => "Stop Monitoring this Gallery",
// "subgallery" => "subgallery",
// "Subgallery" => "Subgallery",
// "Hit" => "Hit",
// "Original Size" => "Original Size",
// "Details" => "Details",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "You can include the image in a tiki page using one of these lines" => "You can include the image in a tiki page using one of these lines",
// "Browsing Image" => "Browsing Image",
// "Return to Gallery" => "Return to Gallery",
// "First Image" => "First Image",
// "Prev Image" => "Prev Image",
// "Smaller" => "Smaller",
// "Bigger" => "Bigger",
// "Next Image" => "Next Image",
// "Slideshow Forward" => "Slideshow Forward",
// "Last Image" => "Last Image",
// "Cyclic" => "Cyclic",
// "Direction" => "Direction",
// "Click to zoom" => "Click to zoom",
// "Image Scale" => "Image Scale",
// "Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/decimal degrees)",
// "Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/decimal degrees)",
// "You can include the image in an HTML page using one of these lines" => "You can include the image in an HTML page using one of these lines",
// "Stop Monitoring this Page" => "Stop Monitoring this Page",
// "Monitor this Page" => "Monitor this Page",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Visible Calendars" => "Visible Calendars",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Export calendars" => "Export calendars",
// "advanced parameters" => "advanced parameters",
// "Edit event" => "Edit event",
// "Delete event" => "Delete event",
// "View event" => "View event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "Change Focus" => "Change Focus",
// "View this Day" => "View this Day",
// "o" => "o",
// "Calendar Item" => "Calendar Item",
// "New event" => "New event",
// "New Calendar Item" => "New Calendar Item",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Date and time of end" => "Date and time of end",
// "Events cannot end before they start" => "Events cannot end before they start",
// "or new" => "or new",
// "Choose users to alert" => "Choose users to alert",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "Update this event only" => "Update this event only",
// "Update every unchanged events of this recurrence rule" => "Update every unchanged events of this recurrence rule",
// "Update every events of this recurrence rule" => "Update every events of this recurrence rule",
// "Delete Recurrent events" => "Delete Recurrent events",
// "Calendar import" => "Calendar import",
// "Calendar has been updated" => "Calendar has been updated",
// "%m/%d" => "%m/%d",
// "Avanced parameters for iCal export" => "Avanced parameters for iCal export",
// "Calendars to be exported" => "Calendars to be exported",
// "Assign permissions to category" => "Assign permissions to category",
// "Categories checking is not done in the database search" => "Categories checking is not done in the database search",
// "Current permissions for this category" => "Current permissions for this category",
// "Remove from this Category Only" => "Remove from this Category Only",
// "Remove from this Category &amp; all its Children" => "Remove from this Category &amp; all its Children",
// "this category &amp; all its children" => "this category &amp; all its children",
// "this category only" => "this category only",
// "Assigning permissions for <b>all children</b> is recommended for best performance" => "Assigning permissions for <b>all children</b> is recommended for best performance",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Click here to send us an email" => "Click here to send us an email",
// "Send another message" => "Send another message",
// "Group View" => "Group View",
// "Publish this contact to groups" => "Publish this contact to groups",
// "You cannot add sites until Directory Categories are setup" => "You cannot add sites until Directory Categories are setup",
// "Please contact the Site Administrator" => "Please contact the Site Administrator",
// "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Related" => "Related",
// "Validate" => "Validate",
// "Parent directory category" => "Parent directory category",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Directory Subcategories" => "Directory Subcategories",
// "Admin related directory categories" => "Admin related directory categories",
// "Directory Category" => "Directory Category",
// "Use Ctrl+Click to select multiple categories" => "Use Ctrl+Click to select multiple categories",
// "Perform action with selected" => "Perform action with selected",
// "New Sites" => "New Sites",
// "Cool Sites" => "Cool Sites",
// "Add a Site" => "Add a Site",
// "Add a Directory Category" => "Add a Directory Category",
// "in current directory category" => "in current directory category",
// "Related directory categories" => "Related directory categories",
// "Total directory categories" => "Total directory categories",
// "View Articles" => "View Articles",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Topline" => "Topline",
// "Subtitle" => "Subtitle",
// "Image caption" => "Image caption",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Max clicks" => "Max clicks",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "Save the Banner" => "Save the Banner",
// "Create Blog" => "Create Blog",
// "A category is mandatory" => "A category is mandatory",
// "Show user avatar" => "Show user avatar",
// "The file will be saved in" => "The file will be saved in",
// "Try" => "Try",
// "Wiki Help" => "Wiki Help",
// "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor" => "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "Wiki Syntax" => "Wiki Syntax",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Bold text" => "Bold text",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Underlined text" => "Underlined text",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "Deleted text" => "Deleted text",
// "2 dashes" => "2 dashes",
// "Headings" => "Headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "Autonumbered Headings" => "Autonumbered Headings",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Horizontal rule" => "Horizontal rule",
// "Text box" => "Text box",
// "Centered text" => "Centered text",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "Square Brackets" => "Square Brackets",
// "Use [[foo] to show [foo]" => "Use [[foo] to show [foo]",
// "page|description" => "page|description",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus (useful in list to continue at the same level)" => "Creates an indentation for each plus (useful in list to continue at the same level)",
// "row" => "row",
// "col" => "col",
// "Monospace font" => "Monospace font",
// "Code sample" => "Code sample",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "to separate pages" => "to separate pages",
// "Prevents wiki parsing of the enclosed data" => "Prevents wiki parsing of the enclosed data",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Block Preformatting" => "Block Preformatting",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that" => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew" => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew",
// "Special characters" => "Special characters",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines" => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line" => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt",
// "New wms Metadata" => "New wms Metadata",
// "New Class" => "New Class",
// "New Projection" => "New Projection",
// "New Query" => "New Query",
// "New Scalebar" => "New Scalebar",
// "New Layer" => "New Layer",
// "New Label" => "New Label",
// "New Reference" => "New Reference",
// "New Legend" => "New Legend",
// "New Web" => "New Web",
// "New Outputformat" => "New Outputformat",
// "New Mapfile" => "New Mapfile",
// "Add image from File Gallery" => "Add image from File Gallery",
// "flash" => "flash",
// "{\$label}" => "{\$label}",
// "Upload from disk to change the image" => "Upload from disk to change the image",
// "Save and Go Next" => "Save and Go Next",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Program dynamic content for block" => "Program dynamic content for block",
// "Create New Block" => "Create New Block",
// "This Quiz Stats" => "This Quiz Stats",
// "Edit this Quiz" => "Edit this Quiz",
// "Admin Quizzes" => "Admin Quizzes",
// "Immediate feedback" => "Immediate feedback",
// "Show correct answers" => "Show correct answers",
// "Shuffle questions" => "Shuffle questions",
// "Shuffle answers" => "Shuffle answers",
// "Passing Percentage" => "Passing Percentage",
// "%" => "%",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character" => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character",
// "Input" => "Input",
// "Edit quiz results" => "Edit quiz results",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one" => "The page already exists. The page that has been added to the structure is the existing one",
// "The following pages added have automatically been categorized with the same categories as the structure" => "The following pages added have automatically been categorized with the same categories as the structure",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Promote" => "Promote",
// "Demote" => "Demote",
// "Current Node" => "Current Node",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Add pages to current node" => "Add pages to current node",
// "Create Page" => "Create Page",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "List Submissions" => "List Submissions",
// "<b>*</b>=optional" => "<b>*</b>=optional",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Save Only in the Theme" => "Save Only in the Theme",
// "Delete the copy in the theme" => "Delete the copy in the theme",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "View Page" => "View Page",
// "View Article" => "View Article",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "The object is already in the set of translations" => "The object is already in the set of translations",
// "Language of newly translated page" => "Language of newly translated page",
// "Unspecified" => "Unspecified",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "detach" => "detach",
// "Change language for this page" => "Change language for this page",
// "Select from available options.." => "Select from available options..",
// "Change Language" => "Change Language",
// "No language is assigned to this page" => "No language is assigned to this page",
// "Please select a language before performing translation" => "Please select a language before performing translation",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Your edit session will expire in" => "Your edit session will expire in",
// "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits" => "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits",
// "Update '{\$page}'" => "Update '{\$page}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Perhaps you are looking for" => "Perhaps you are looking for",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Admin Content Templates" => "Admin Content Templates",
// "Use rating" => "Use rating",
// "Disable" => "Disable",
// "There is no available poll template" => "There is no available poll template",
// "You should ask an admin to create them" => "You should ask an admin to create them",
// "or use" => "or use",
// "an existing poll" => "an existing poll",
// "AutoSave" => "AutoSave",
// "If you want the saved version instead of the autosaved one" => "If you want the saved version instead of the autosaved one",
// "Regex search " => "Regex search ",
// "Replace to" => "Replace to",
// "Case Insensitivity" => "Case Insensitivity",
// "Translation request" => "Translation request",
// "Send urgent translation request" => "Send urgent translation request",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Format" => "Format",
// "Autodetect" => "Autodetect",
// "Export Tracker Items" => "Export Tracker Items",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Dump All Tracker Items" => "Dump All Tracker Items",
// "Dump" => "Dump",
// "New Question" => "New Question",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "File Galleries tpl" => "File Galleries tpl",
// "Be careful to set the right permissions on the files you link to" => "Be careful to set the right permissions on the files you link to",
// "Create New File Gallery" => "Create New File Gallery",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Back to forum" => "Back to forum",
// "Save and Approve" => "Save and Approve",
// "New Topic" => "New Topic",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Pending requests" => "Pending requests",
// "Request Time" => "Request Time",
// "Refuse" => "Refuse",
// "Waiting requests" => "Waiting requests",
// "Cancel friendship request" => "Cancel friendship request",
// "Your friends" => "Your friends",
// "break friendship" => "break friendship",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Expiration Time" => "Expiration Time",
// "Years" => "Years",
// "Months" => "Months",
// "Minutes" => "Minutes",
// "Add Role" => "Add Role",
// "Add New" => "Add New",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
// "Edit Tpl" => "Edit Tpl",
// "Process Graph for" => "Process Graph for",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed" => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed",
// "Active Process" => "Active Process",
// "Invalid Process" => "Invalid Process",
// "Valid Process" => "Valid Process",
// "New Minor" => "New Minor",
// "New Major" => "New Major",
// "Aborted" => "Aborted",
// "Ended" => "Ended",
// "Not Defined" => "Not Defined",
// "Not Interactive" => "Not Interactive",
// "Not Ended" => "Not Ended",
// "Executed" => "Executed",
// "erase" => "erase",
// "Admin Processes" => "Admin Processes",
// "Admin Activities" => "Admin Activities",
// "Admin Roles" => "Admin Roles",
// "Edit this Process" => "Edit this Process",
// "Monitor Activities" => "Monitor Activities",
// "Proc" => "Proc",
// "Enter the name of this instance" => "Enter the name of this instance",
// "The name is not valid. Please, enter the name again" => "The name is not valid. Please, enter the name again",
// "Monitor Instances" => "Monitor Instances",
// "Not ended" => "Not ended",
// "Monitor Processes" => "Monitor Processes",
// "Exceptions" => "Exceptions",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "My activities" => "My activities",
// "Current Activity" => "Current Activity",
// "Assigned To" => "Assigned To",
// "Send Instance" => "Send Instance",
// "No activities found" => "No activities found",
// "My instances" => "My instances",
// "No instances found" => "No instances found",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "User Instances" => "User Instances",
// "Not defined" => "Not defined",
// "User Processes" => "User Processes",
// "Create New Gallery" => "Create New Gallery",
// "Geographic" => "Geographic",
// "Fields to show during browsing the gallery" => "Fields to show during browsing the gallery",
// "Creation Date" => "Creation Date",
// "XY-Size" => "XY-Size",
// "Gallery Image" => "Gallery Image",
// "Global default" => "Global default",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "Original image is default scale" => "Original image is default scale",
// "Add scaled images with bounding box of square size" => "Add scaled images with bounding box of square size",
// "Choose a filter" => "Choose a filter",
// "Make Map" => "Make Map",
// "Google Map Locator" => "Google Map Locator",
// "Save clicked point" => "Save clicked point",
// "Reset view to default" => "Reset view to default",
// "Save current view as default" => "Save current view as default",
// "Center map to saved point" => "Center map to saved point",
// "Reset view to site default" => "Reset view to site default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "body" => "body",
// "XML Zip" => "XML Zip",
// "Locked" => "Locked",
// "Tiki installer" => "Tiki installer",
// "Welcome" => "Welcome",
// "Welcome to the Tiki installation and upgrade script" => "Welcome to the Tiki installation and upgrade script",
// "Use this script to install a new Tiki database or upgrade your existing database to release" => "Use this script to install a new Tiki database or upgrade your existing database to release",
// "For the latest information about this release, please read the" => "For the latest information about this release, please read the",
// "Release Notes" => "Release Notes",
// "For complete documentation, please visit" => "For complete documentation, please visit",
// "For more information about Tiki, please visit" => "For more information about Tiki, please visit",
// "Select your language" => "Select your language",
// "Read the License" => "Read the License",
// "Tiki is software distributed under the LGPL license" => "Tiki is software distributed under the LGPL license",
// " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>",
// "Review the System Requirements" => "Review the System Requirements",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "This installer will perform some basic checks automatically" => "This installer will perform some basic checks automatically",
// "Memory" => "Memory",
// "Success" => "Success",
// "Tiki has not detected your PHP memory_limit" => "Tiki has not detected your PHP memory_limit",
// "This probably means you have no set limit (all is well)" => "This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution",
// "Allocating too little memory will cause Tiki to display blank pages" => "Allocating too little memory will cause Tiki to display blank pages",
// "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Mail" => "Mail",
// "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages",
// "To test your system configuration, Tiki will attempt to send a test message to you" => "To test your system configuration, Tiki will attempt to send a test message to you",
// "Test email" => "Test email",
// "Email address to send test to" => "Email address to send test to",
// "Copy test mail to " => "Copy test mail to ",
// "Send Test Message" => "Send Test Message",
// "Tiki was able to send a test message to" => "Tiki was able to send a test message to",
// "Tiki was not able to send a test message" => "Tiki was not able to send a test message",
// "Review your mail log for details" => "Review your mail log for details",
// "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)",
// "If your host requires SMTP authentication, additional configuration may be necessary" => "If your host requires SMTP authentication, additional configuration may be necessary",
// "Image Processing" => "Image Processing",
// "Tiki detected" => "Tiki detected",
// "Tiki was not able to detect the GD library" => "Tiki was not able to detect the GD library",
// "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support",
// "Set the Database Connection" => "Set the Database Connection",
// "Tiki requires an active database connection" => "Tiki requires an active database connection",
// "You must create the database and user <em>before</em> completing this page" => "You must create the database and user <em>before</em> completing this page",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "This is normal for a new installation" => "This is normal for a new installation",
// "Tiki found an existing database connection in your local.php file" => "Tiki found an existing database connection in your local.php file",
// "Use Existing Connection" => "Use Existing Connection",
// "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>",
// "Database information" => "Database information",
// "Enter your database connection information" => "Enter your database connection information",
// "Database type" => "Database type",
// "Select the type of database to use with Tiki" => "Select the type of database to use with Tiki",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension",
// "Host name" => "Host name",
// "Enter the host name or IP for your database" => "Enter the host name or IP for your database",
// "Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "For SQLite, enter the path and filename to your database file" => "For SQLite, enter the path and filename to your database file",
// "Database name" => "Database name",
// "Enter the name of the database that Tiki will use" => "Enter the name of the database that Tiki will use",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names",
// "For Oracle" => "For Oracle",
// "Enter your TNS Name here and leave Host empty" => "Enter your TNS Name here and leave Host empty",
// "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field" => "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field",
// "Database user" => "Database user",
// "Enter a database user with administrator permission for the Database" => "Enter a database user with administrator permission for the Database",
// "User name" => "User name",
// "Install &amp; Update Profile" => "Install &amp; Update Profile",
// "Install Profile" => "Install Profile",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database" => "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "Select the installation profile to use. This profile will populate the database" => "Select the installation profile to use. This profile will populate the database",
// "Profiles can be used to pre-configure your site with specific features and settings" => "Profiles can be used to pre-configure your site with specific features and settings",
// "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information" => "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information",
// "Install" => "Install",
// "Reinstall the database" => "Reinstall the database",
// "This will destroy your current database" => "This will destroy your current database",
// "Create a new database (clean install) with profile" => "Create a new database (clean install) with profile",
// "Bare-bones default install" => "Bare-bones default install",
// "Personal Blog and Profile" => "Personal Blog and Profile",
// "Small Organization Web Presence" => "Small Organization Web Presence",
// "Company Intranet" => "Company Intranet",
// "Collaborative community" => "Collaborative community",
// "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles" => "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles",
// "The installer could not connect to the Profiles repository" => "The installer could not connect to the Profiles repository",
// "The default installation profile will be used" => "The default installation profile will be used",
// "Upgrade" => "Upgrade",
// "Automatically upgrade your existing database to v" => "Automatically upgrade your existing database to v",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Pass" => "Pass",
// "Review the Upgrade" => "Review the Upgrade",
// "Review the Installation" => "Review the Installation",
// "Upgrade complete" => "Upgrade complete",
// "Installation complete" => "Installation complete",
// "Your database has been configured and Tiki is ready to run" => "Your database has been configured and Tiki is ready to run",
// "If this is your first install, your admin password is <strong>admin</strong>" => "If this is your first install, your admin password is <strong>admin</strong>",
// "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application",
// "Upgrade operations executed successfully" => "Upgrade operations executed successfully",
// "Installation operations executed successfully" => "Installation operations executed successfully",
// "SQL queries" => "SQL queries",
// "Database was left unchanged" => "Database was left unchanged",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages",
// ".htaccess File" => ".htaccess File",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "Configure General Settings" => "Configure General Settings",
// "Complete these fields to configure common, general settings for your site" => "Complete these fields to configure common, general settings for your site",
// "The information you enter here can be changed later" => "The information you enter here can be changed later",
// "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings",
// "This will appear in the browser title bar" => "This will appear in the browser title bar",
// "Email sent by your site will use this address" => "Email sent by your site will use this address",
// "Secure Login" => "Secure Login",
// "HTTPS login" => "HTTPS login",
// "Administrator" => "Administrator",
// "Admin email" => "Admin email",
// "This is the email address for your administrator account" => "This is the email address for your administrator account",
// "Enter Your Tiki" => "Enter Your Tiki",
// "The installation is complete" => "The installation is complete",
// "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Installation" => "Installation",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu",
// "Enter Tiki and Lock Installer" => "Enter Tiki and Lock Installer",
// "Recommended" => "Recommended",
// "Enter Tiki Without Locking Installer" => "Enter Tiki Without Locking Installer",
// "MultiTiki Setup" => "MultiTiki Setup",
// "Default Installation" => "Default Installation",
// "DB OK" => "DB OK",
// "No DB" => "No DB",
// "Adding a new host" => "Adding a new host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Are you upgrading an existing Tiki site" => "Are you upgrading an existing Tiki site",
// "Go directly to the <strong>Install/Upgrade</strong> step" => "Go directly to the <strong>Install/Upgrade</strong> step",
// "Install/Upgrade" => "Install/Upgrade",
// "Restart the installer" => "Restart the installer",
// "Database Connection" => "Database Connection",
// "Reset the Database Connection" => "Reset the Database Connection",
// "Configure the General Settings" => "Configure the General Settings",
// "Tiki Icon" => "Tiki Icon",
// "TikiWiki Project Web Site" => "TikiWiki Project Web Site",
// "Support Forums" => "Support Forums",
// "TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware Project",
// "Powered by TikiWiki" => "Powered by TikiWiki",
// "Edit Repository" => "Edit Repository",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "Search by Date" => "Search by Date",
// "v" => "v",
// "Rollback" => "Rollback",
// "View Submissions" => "View Submissions",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone" => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone",
// "Max Clicks" => "Max Clicks",
// "Create New Blog" => "Create New Blog",
// "The cache is used by" => "The cache is used by",
// "Approval" => "Approval",
// "Rejected" => "Rejected",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block" => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "Future vers" => "Future vers",
// "Create a File Gallery" => "Create a File Gallery",
// "SlideShow" => "SlideShow",
// "Keep gallery window open" => "Keep gallery window open",
// "Your comment" => "Your comment",
// "optional" => "optional",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "/" => "/",
// "Flash binary (.swf or .dcr)" => "Flash binary (.swf or .dcr)",
// "Edit New Submission" => "Edit New Submission",
// "Take Survey" => "Take Survey",
// "users registered" => "users registered",
// "Distance (km)" => "Distance (km)",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Page creator" => "Page creator",
// "Last ver" => "Last ver",
// "Status of the page" => "Status of the page",
// "Vers" => "Vers",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl" => "Backl",
// "Page size" => "Page size",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "offline" => "offline",
// "Set as Operator" => "Set as Operator",
// "Back to admin" => "Back to admin",
// "operator" => "operator",
// "For security purposes we must periodically validate your email address to allow continued access to this site" => "For security purposes we must periodically validate your email address to allow continued access to this site",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site" => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site",
// "Thank you" => "Thank you",
// "This is an experimental feature" => "This is an experimental feature",
// "Requires" => "Requires",
// "Not Enabled" => "Not Enabled",
// "Mail-in feature" => "Mail-in feature",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Add Topic" => "Add Topic",
// "Tikiwiki Mods" => "Tikiwiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
// "Republish all" => "Republish all",
// "Publish all" => "Publish all",
// "Unpublish all" => "Unpublish all",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>" => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Attention" => "Attention",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "all types" => "all types",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "licence" => "licence",
// "Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuration",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "Package Config" => "Package Config",
// "y" => "y",
// "User Articles" => "User Articles",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you participate" => "To display the objects you participate",
// "Contacts Preferences" => "Contacts Preferences",
// "My Watches" => "My Watches",
// "My Galleries" => "My Galleries",
// "My Tracker Items" => "My Tracker Items",
// "My Messages" => "My Messages",
// "My Tasks" => "My Tasks",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription failed" => "Subscription failed",
// "Subscribe to Newsletter" => "Subscribe to Newsletter",
// "Subscribe to this Newsletter" => "Subscribe to this Newsletter",
// "Available Newsletters" => "Available Newsletters",
// "News from" => "News from",
// "Read the news" => "Read the news",
// "Merge selected notes into" => "Merge selected notes into",
// "Wiki Create" => "Wiki Create",
// "Wiki Overwrite" => "Wiki Overwrite",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "View Permissions" => "View Permissions",
// "Edit Permissions" => "Edit Permissions",
// "These permissions override any global permissions or category permissions affecting this object" => "These permissions override any global permissions or category permissions affecting this object",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>",
// "No individual permissions, category permissions apply" => "No individual permissions, category permissions apply",
// "Current permissions for categories that this object belongs to" => "Current permissions for categories that this object belongs to",
// "These permissions do not apply. Special permissions apply" => "These permissions do not apply. Special permissions apply",
// "No category permissions; global permissions apply" => "No category permissions; global permissions apply",
// "No category permissions; special permissions apply" => "No category permissions; special permissions apply",
// "and also to all pages of the sub-structure" => "and also to all pages of the sub-structure",
// "Perms Help" => "Perms Help",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts" => "Your identity gives you access to multiple user accounts",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "Slides" => "Slides",
// "Discuss" => "Discuss",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "Rollback to this version" => "Rollback to this version",
// "Source of version" => "Source of version",
// "s=source" => "s=source",
// "b=rollback" => "b=rollback",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "no avatar" => "no avatar",
// "icons" => "icons",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "View Details" => "View Details",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Any" => "Any",
// "Items found" => "Items found",
// "atts" => "atts",
// "List Attachments" => "List Attachments",
// "Sum" => "Sum",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Plugin" => "Plugin",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "Selected Structures" => "Selected Structures",
// "Add Structure" => "Add Structure",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Add Page" => "Add Page",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected" => "No pages selected",
// "Edit quiz" => "Edit quiz",
// "General Options" => "General Options",
// "Publication Date" => "Publication Date",
// "at " => "at ",
// "Use " => "Use ",
// "randomly selected questions" => "randomly selected questions",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)" => "&nbsp question(s)",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz" => "Allow students to store partial results and return to quiz",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue" => "Prologue",
// "Epilogue" => "Epilogue",
// "Stats for quiz" => "Stats for quiz",
// "Clear Stats" => "Clear Stats",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "Passed" => "Passed",
// "Rank" => "Rank",
// "star" => "star",
// "half star" => "half star",
// "List all articles of this same topic" => "List all articles of this same topic",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist" => "The highlight pages already exist",
// "Please, change the name if you want the page to be uploaded" => "Please, change the name if you want the page to be uploaded",
// "Received Structures" => "Received Structures",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Use your email as login" => "Use your email as login",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "A valid email is mandatory to register" => "A valid email is mandatory to register",
// "Select your group" => "Select your group",
// "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter" => "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter",
// "You don't have permission to use this feature" => "You don't have permission to use this feature",
// "Please register" => "Please register",
// "Last Version" => "Last Version",
// "Back to page" => "Back to page",
// "Replicate" => "Replicate",
// "Slave" => "Slave",
// "Master" => "Master",
// "Operations" => "Operations",
// "Operations Log" => "Operations Log",
// "to version" => "to version",
// "Searched" => "Searched",
// "\$name" => "\$name",
// "Faqs" => "Faqs",
// "Blogs Post" => "Blogs Post",
// "Calendar Items" => "Calendar Items",
// "Please Confirm" => "Please Confirm",
// "octets" => "octets",
// "Apply content template" => "Apply content template",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "To add a file, click here" => "To add a file, click here",
// "Save as Draft" => "Save as Draft",
// "Send a structure" => "Send a structure",
// "Add Article" => "Add Article",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet" => "Edit this sheet",
// "Create New Sheet" => "Create New Sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "Header Rows" => "Header Rows",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Approve changes" => "Approve changes",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "TOC" => "TOC",
// "Child" => "Child",
// "page: %0/%1" => "page: %0/%1",
// "Last edited by" => "Last edited by",
// "based on work by" => "based on work by",
// "Contributors to this page" => "Contributors to this page",
// "Page last modified on %0 by %1" => "Page last modified on %0 by %1",
// "Last Modification: %0 by %1" => "Last Modification: %0 by %1",
// "santa" => "santa",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Clean" => "Clean",
// "Params" => "Params",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Date of first pageview" => "Date of first pageview",
// "Days since first pageview" => "Days since first pageview",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "FAQ Stats" => "FAQ Stats",
// "Daily Usage" => "Daily Usage",
// "Stats for survey" => "Stats for survey",
// "Tiki Logs" => "Tiki Logs",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Send Answers" => "Send Answers",
// "Thank you for your submission" => "Thank you for your submission",
// "The link was sent to the following addresses" => "The link was sent to the following addresses",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma" => "Separate multiple email addresses with a comma",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like" => "I found an interesting page that I thought you would like",
// "TikiTests Edit" => "TikiTests Edit",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request" => "Request",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Control by Objects" => "Control by Objects",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "Edit File" => "Edit File",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "Additional Info" => "Additional Info",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "File Title" => "File Title",
// "Unzip zip files" => "Unzip zip files",
// "Author if not the file creator" => "Author if not the file creator",
// "Maximum amount of downloads" => "Maximum amount of downloads",
// "Add File" => "Add File",
// "Maximum file size is limited to" => "Maximum file size is limited to",
// "No gallery available" => "No gallery available",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// "or use filename" => "or use filename",
// "or upload a local image from your disk" => "or upload a local image from your disk",
// "Batch Upload" => "Batch Upload",
// "The column is disabled" => "The column is disabled",
// "Remove Folder" => "Remove Folder",
// "Refresh Cache" => "Refresh Cache",
// "a folder" => "a folder",
// "a URL" => "a URL",
// "User Contacts Preferences" => "User Contacts Preferences",
// "Manage Fields" => "Manage Fields",
// "Default view" => "Default view",
// "Assign Group" => "Assign Group",
// "(non public)" => "(non public)",
// "Homepage" => "Homepage",
// "Users HomePage" => "Users HomePage",
// "System" => "System",
// "This user is your friend" => "This user is your friend",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Request friendship from this user" => "Request friendship from this user",
// "Forum comments" => "Forum comments",
// "Toggle options" => "Toggle options",
// "Toggle" => "Toggle",
// "Personal Information" => "Personal Information",
// "Male" => "Male",
// "Female" => "Female",
// "Use Google Map locator" => "Use Google Map locator",
// "Your personal tracker information" => "Your personal tracker information",
// "View extra information" => "View extra information",
// "Unavailable - please set your e-mail below" => "Unavailable - please set your e-mail below",
// "Displays users' info tooltip on mouseover for every user who allows his information to be public" => "Displays users' info tooltip on mouseover for every user who allows his information to be public",
// "My user items" => "My user items",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "Accepted by Task User and Creator" => "Accepted by Task User and Creator",
// "Accepted User and Creator" => "Accepted User and Creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "Not Accepted by One User" => "Not Accepted by One User",
// "Not Accepted User" => "Not Accepted User",
// "Task is rejected by one user" => "Task is rejected by one user",
// "Waiting for Me" => "Waiting for Me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "Waiting for Other User" => "Waiting for Other User",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "Admin Mode" => "Admin Mode",
// "Edit task" => "Edit task",
// "NOT accept" => "NOT accept",
// "Remove from Trash" => "Remove from Trash",
// "Move into Trash" => "Move into Trash",
// "Task saved" => "Task saved",
// "Edit Task" => "Edit Task",
// "View Task" => "View Task",
// "Open a new task" => "Open a new task",
// "taskId" => "taskId",
// "Task user" => "Task user",
// "Only the creator can delete this task" => "Only the creator can delete this task",
// "Use start date and time" => "Use start date and time",
// "Use end date and time" => "Use end date and time",
// "Open / In Process" => "Open / In Process",
// "Waiting / Not Started" => "Waiting / Not Started",
// "Waiting" => "Waiting",
// "Shared for Group" => "Shared for Group",
// "Accepted by User" => "Accepted by User",
// "No / Rejected" => "No / Rejected",
// "Accepted by Creator" => "Accepted by Creator",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Send message with changes" => "Send message with changes",
// "Modified by" => "Modified by",
// "Marked as deleted" => "Marked as deleted",
// "Inform task user by email" => "Inform task user by email",
// "You can only view this task" => "You can only view this task",
// "Undo Trash" => "Undo Trash",
// "Public for group" => "Public for group",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Use \"watches\" to monitor wiki pages or other objects" => "Use \"watches\" to monitor wiki pages or other objects",
// "Watch new items by clicking the {icon _id=eye} button on specific pages" => "Watch new items by clicking the {icon _id=eye} button on specific pages",
// "Add Watch" => "Add Watch",
// "Select event type" => "Select event type",
// "All watched events" => "All watched events",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user edited a wiki page" => "A user edited a wiki page",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "Used space" => "Used space",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Remove Row" => "Remove Row",
// "Remove Column" => "Remove Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "Edit Items" => "Edit Items",
// "List Charts" => "List Charts",
// "Last Chart" => "Last Chart",
// "Previous Chart" => "Previous Chart",
// "Next Chart" => "Next Chart",
// "Pre" => "Pre",
// "Avg" => "Avg",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Answers" => "Answers",
// "Add Suggestion" => "Add Suggestion",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "Announce" => "Announce",
// "Hot" => "Hot",
// "Forum Lock" => "Forum Lock",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Stop Monitor" => "Stop Monitor",
// "Insert New Item" => "Insert New Item",
// "Edit Fields" => "Edit Fields",
// "Pending" => "Pending",
// "View inserted item" => "View inserted item",
// "Tracker Item" => "Tracker Item",
// "Edit/Delete" => "Edit/Delete",
// "View Item" => "View Item",
// "Filter Tracker Items" => "Filter Tracker Items",
// "Add a Comment" => "Add a Comment",
// "Items list" => "Items list",
// "Special Operations" => "Special Operations",
// "close" => "close",
// "There was an error connecting to your e-mail account" => "There was an error connecting to your e-mail account",
// "Add a new" => "Add a new",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "Click to activate" => "Click to activate",
// "This is the active account" => "This is the active account",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Refresh now" => "Refresh now",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "Clip" => "Clip",
// "Back To Mailbox" => "Back To Mailbox",
// "Full Headers" => "Full Headers",
// "Normal Headers" => "Normal Headers",
// "Reply To All" => "Reply To All",
// "Forward" => "Forward",
// "Select from address book" => "Select from address book",
// "Add Contacts" => "Add Contacts",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Jump to Content" => "Jump to Content",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Show/Hide Left Menus" => "Show/Hide Left Menus",
// "Show/Hide Right Menus" => "Show/Hide Right Menus",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Remove Image" => "Remove Image",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Number of voices" => "Number of voices",
// "Your vote" => "Your vote",
// "Click to vote for this value" => "Click to vote for this value",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Use this thread to discuss the page" => "Use this thread to discuss the page",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Reinstall" => "Reinstall",
// "Undecided" => "Undecided",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "List authors" => "List authors",
// "Preview your changes" => "Preview your changes",
// "Save the page as a partial translation" => "Save the page as a partial translation",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation" => "Save the page as a completed translation",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated" => "Save the page, but do not send notifications and do not count it as new content to be translated",
// "Save the page" => "Save the page",
// "Cancel the edit, you will lose your changes" => "Cancel the edit, you will lose your changes",
// "Compose Message" => "Compose Message",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "Separate multiple usernames with a comma (&nbsp;,&nbsp;)" => "Separate multiple usernames with a comma (&nbsp;,&nbsp;)",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "%s set" => "%s set",
// "%s unset" => "%s unset",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Enable/disable Tiki features here, but configure them elsewhere" => "Enable/disable Tiki features here, but configure them elsewhere",
// "User registration, login and authentication" => "User registration, login and authentication",
// "Wiki Attachments" => "Wiki Attachments",
// "Article/CMS settings" => "Article/CMS settings",
// "Configuration options for all blogs on your site" => "Configuration options for all blogs on your site",
// "FAQ comments settings" => "FAQ comments settings",
// "Trackers settings" => "Trackers settings",
// "RSS settings" => "RSS settings",
// "Directory settings" => "Directory settings",
// "Maps configuration" => "Maps configuration",
// "Meta Tags settings" => "Meta Tags settings",
// "Search settings" => "Search settings",
// "Score settings" => "Score settings",
// "Community settings" => "Community settings",
// "Calendar settings" => "Calendar settings",
// "Intertiki settings" => "Intertiki settings",
// "Freetags settings" => "Freetags settings",
// "Look & Feel" => "Look & Feel",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Current version is up to date : <b>%s</b>" => "Current version is up to date : <b>%s</b>",
// "A new %s  major release branch is available" => "A new %s  major release branch is available",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Click here to delete the category" => "Click here to delete the category",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Detected, Version" => "Detected, Version",
// "Test Image" => "Test Image",
// "Not detected" => "Not detected",
// "You cannot have a blank password" => "You cannot have a blank password",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "If you use apache, you need a .htaccess file to have this feature working" => "If you use apache, you need a .htaccess file to have this feature working",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer" => "Frequency should be a positive integer",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "Unassign module" => "Unassign module",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "Invalid email" => "Invalid email",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "unsafe" => "unsafe",
// "register_globals should be off by default. See the php manual for details" => "register_globals should be off by default. See the php manual for details",
// "safe" => "safe",
// "session.use_trans_sid should be off by default. See the php manual for details" => "session.use_trans_sid should be off by default. See the php manual for details",
// "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config" => "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "risky" => "risky",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off" => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code" => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "File is not readable. Unable to check" => "File is not readable. Unable to check",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous" => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous",
// "This is a modified File. Cannot check version. Check if it is dangerous" => "This is a modified File. Cannot check version. Check if it is dangerous",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// "You have to provide a word" => "You have to provide a word",
// "No Errors detected" => "No Errors detected",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "User doesn't exist" => "User doesn't exist",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "Invalid or unknown email" => "Invalid or unknown email",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "User %s already exists" => "User %s already exists",
// "User login contains invalid characters" => "User login contains invalid characters",
// "New %s created with %s %s" => "New %s created with %s %s",
// "Impossible to create new %s with %s %s" => "Impossible to create new %s with %s %s",
// "%s %s successfully deleted" => "%s %s successfully deleted",
// "Deleted account %s" => "Deleted account %s",
// "%s %s removed from %s %s" => "%s %s removed from %s %s",
// "%s <b>%s</b> successfully deleted" => "%s <b>%s</b> successfully deleted",
// "%s <b>%s</b> assigned to %s <b>%s</b>" => "%s <b>%s</b> assigned to %s <b>%s</b>",
// "%s <b>%s</b> removed from %s <b>%s</b>" => "%s <b>%s</b> removed from %s <b>%s</b>",
// "group <b>%s</b> set as the default group of user <b>%s</b>" => "group <b>%s</b> set as the default group of user <b>%s</b>",
// "Login contains invalid characters" => "Login contains invalid characters",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "%s modified successfully" => "%s modified successfully",
// "%s modification failed" => "%s modification failed",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "rss feed disabled" => "rss feed disabled",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "Group doesn't exist" => "Group doesn't exist",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s" => "Could not read image %s",
// "Image %s upload failed" => "Image %s upload failed",
// "Image %s uploaded successfully" => "Image %s uploaded successfully",
// "Image %s removed from Batch directory" => "Image %s removed from Batch directory",
// "Impossible to remove image %s from Batch directory" => "Impossible to remove image %s from Batch directory",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images" => "Incorrect directory chosen for batch upload of images",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator" => "Please contact the website administrator",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "Tiki RSS feed for blog: " => "Tiki RSS feed for blog: ",
// "Last modifications to the blog" => "Last modifications to the blog",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs" => "Last posts to weblogs",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache" => "You must clear your browser cache",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "Access Denied" => "Access Denied",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "No category indicated" => "No category indicated",
// "Permission denied; you cannot assign permissions for this category" => "Permission denied; you cannot assign permissions for this category",
// "Invalid username or activation code. Maybe this code has already been used" => "Invalid username or activation code. Maybe this code has already been used",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "Account validated successfully" => "Account validated successfully",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "ERROR: you must include a subject or a message at least" => "ERROR: you must include a subject or a message at least",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "Last sites" => "Last sites",
// "No parent specified" => "No parent specified",
// "Last sites of directory \".\$rc[\"name\"].\" " => "Last sites of directory \".\$rc[\"name\"].\" ",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "You do not have permission to write the template" => "You do not have permission to write the template",
// "Translation in progress" => "Translation in progress",
// "No object indicated" => "No object indicated",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "No type indicated" => "No type indicated",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Page already exists. Go back and choose a different name" => "Page already exists. Go back and choose a different name",
// "The translation set already contains a page in this language" => "The translation set already contains a page in this language",
// "No questions group indicated" => "No questions group indicated",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Tiki RSS feed for file galleries" => "Tiki RSS feed for file galleries",
// "Last files uploaded to the file galleries" => "Last files uploaded to the file galleries",
// "Tiki RSS feed for the file gallery: " => "Tiki RSS feed for the file gallery: ",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "Last replied forum topics" => "Last replied forum topics",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums" => "Last topics in forums",
// "Not supported yet" => "Not supported yet",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship" => "I have broken our friendship",
// "You must be logged in to use this feature" => "You must be logged in to use this feature",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "I have accepted your friendship request" => "I have accepted your friendship request",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "Invalid source path" => "Invalid source path",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "You couldn't abort a instance" => "You couldn't abort a instance",
// "You couldn't exception a instance" => "You couldn't exception a instance",
// "No title indicated" => "No title indicated",
// "No comment indicated" => "No comment indicated",
// "No date indicated" => "No date indicated",
// "first uploaded image" => "first uploaded image",
// "last uploaded image" => "last uploaded image",
// "random image" => "random image",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required" => "No valid renderer found. GD or PDFLib required",
// "No sheet specified" => "No sheet specified",
// "You must select a renderer" => "You must select a renderer",
// "Invalid Series for current graphic" => "Invalid Series for current graphic",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries" => "Last images uploaded to the image galleries",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "updated from structured text import" => "updated from structured text import",
// "created from structured text import" => "created from structured text import",
// "Operations executed successfully" => "Operations executed successfully",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Approved Status" => "Approved Status",
// "Queued" => "Queued",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Could not find the file requested" => "Could not find the file requested",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read file" => "Cannot read file",
// "Cannot read the file" => "Cannot read the file",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "File update was successful" => "File update was successful",
// "This gallery does not exist" => "This gallery does not exist",
// "The game file must have .swf or .dcr extension" => "The game file must have .swf or .dcr extension",
// "Please supply both files" => "Please supply both files",
// "You have to enable cookies to be able to login to this site" => "You have to enable cookies to be able to login to this site",
// "Unable to contact remote server" => "Unable to contact remote server",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Invalid password" => "Invalid password",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Sorry, you can't use this feature" => "Sorry, you can't use this feature",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "Please create a directory named '.\$prefs['map_path'].' to hold your map files" => "Please create a directory named '.\$prefs['map_path'].' to hold your map files",
// "Maps feature is not correctly setup : Maps path is missing" => "Maps feature is not correctly setup : Maps path is missing",
// "I could not make a copy" => "I could not make a copy",
// "map edit" => "map edit",
// "You dont have permission to do that" => "You dont have permission to do that",
// "Tiki RSS feed for maps" => "Tiki RSS feed for maps",
// "List of maps available" => "List of maps available",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled" => "Your PHP installation does not have zlib enabled",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "Pageviews" => "Pageviews",
// "You don't have permission to edit quizzes" => "You don't have permission to edit quizzes",
// "You must choose a group" => "You must choose a group",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "mail adress" => "mail adress",
// "empty" => "empty",
// "Unable to send mail. User has not configured email" => "Unable to send mail. User has not configured email",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password" => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "A password and your IP address reminder email has been sent " => "A password and your IP address reminder email has been sent ",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email" => "to the email",
// "last version" => "last version",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Permission denied you cannot rename this page" => "Permission denied you cannot rename this page",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "changed '%s' from '%s' to '%s'" => "changed '%s' from '%s' to '%s'",
// "Error Message" => "Error Message",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "No newsletters available" => "No newsletters available",
// "invalid email" => "invalid email",
// "successfully sent" => "successfully sent",
// "not sent" => "not sent",
// "Error: " => "Error: ",
// "Notice: this variable may not be empty" => "Notice: this variable may not be empty",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Clean the sql logs" => "Clean the sql logs",
// "Report to the webmaster" => "Report to the webmaster",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
// "Usage" => "Usage",
// "Password has been changed" => "Password has been changed",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "Email is set to %s" => "Email is set to %s",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "open / in process" => "open / in process",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries" => "Task entries",
// "Changes" => "Changes",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Login and click the link below" => "Login and click the link below",
// "Please read the task and work on it" => "Please read the task and work on it",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "A new page is created in a language" => "A new page is created in a language",
// "Language watch" => "Language watch",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "A SheetId is required" => "A SheetId is required",
// "That tracker don't use extras" => "That tracker don't use extras",
// " The connection failed, so check the server names" => " The connection failed, so check the server names",
// "The connection was OK" => "The connection was OK",
// " But the login failed, so check the Username and Password" => " But the login failed, so check the Username and Password",
// "Tiki RSS feed for the wiki pages" => "Tiki RSS feed for the wiki pages",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"ID" => "ID",
"Slideshow" => "Slideshow",
"Andorra" => "Andorra",
"Angola" => "Angola",
"Anguilla" => "Anguilla",
"Antigua" => "Antigua",
"Argentina" => "Argentina",
"Aruba" => "Aruba",
"Bahamas" => "Bahamas",
"Bahrain" => "Bahrain",
"Bangladesh" => "Bangladesh",
"Barbados" => "Barbados",
"Belize" => "Belize",
"Benin" => "Benin",
"Bermuda" => "Bermuda",
"Bhutan" => "Bhutan",
"Bolivia" => "Bolivia",
"Brunei" => "Brunei",
"Burkina Faso" => "Burkina Faso",
"Burundi" => "Burundi",
"Chile" => "Chile",
"Colombia" => "Colombia",
"El Salvador" => "El Salvador",
"Eritrea" => "Eritrea",
"Estonia" => "Estonia",
"Finland" => "Finland",
"Gambia" => "Gambia",
"Gibraltar" => "Gibraltar",
"Guatemala" => "Guatemala",
"Guinea" => "Guinea",
"Haiti" => "Haiti",
"Honduras" => "Honduras",
"Hong Kong" => "Hong Kong",
"Iran" => "Iran",
"Isle of Man" => "Isle of Man",
"Israel" => "Israel",
"Japan" => "Japan",
"Kenya" => "Kenya",
"Kuwait" => "Kuwait",
"Malawi" => "Malawi",
"Malaysia" => "Malaysia",
"Mali" => "Mali",
"Malta" => "Malta",
"Namibia" => "Namibia",
"Nepal" => "Nepal",
"Nigeria" => "Nigeria",
"Pakistan" => "Pakistan",
"Panama" => "Panama",
"Peru" => "Peru",
"Portugal" => "Portugal",
"Puerto Rico" => "Puerto Rico",
"Quatar" => "Quatar",
"Senegal" => "Senegal",
"Taiwan" => "Taiwan",
"Tanzania" => "Tanzania",
"Thailand" => "Thailand",
"Trinidad Tobago" => "Trinidad Tobago",
"Uganda" => "Uganda",
"MySQL classic (mysql)" => "MySQL classic (mysql)",
"PostgeSQL 7.2+" => "PostgeSQL 7.2+",
"Oracle" => "Oracle",
"Sybase" => "Sybase",
"SQLLite" => "SQLLite",
"MSSQL" => "MSSQL",
"Dutch" => "Dutch",
"latin" => "latin",
"utf-8" => "utf-8",
"iso-8859-1" => "iso-8859-1",
"CRLF (standard)" => "CRLF (standard)",
"LF (some Unix MTA)" => "LF (some Unix MTA)",
"crypt-md5" => "crypt-md5",
"crypt-des" => "crypt-des",
"tikihash (old)" => "tikihash (old)",
"CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
"Shibboleth" => "Shibboleth",
"OpenID and Tiki" => "OpenID and Tiki",
"Wiki" => "Wiki",
"blog" => "blog",
"faq" => "faq",
"forum" => "forum",
"Foo" => "Foo",
"text" => "text",
"WikiDiff Okay: LCS = %s" => "WikiDiff Okay: LCS = %s",
"Blog" => "Blog",
"FAQ" => "FAQ",
"Forum" => "Forum",
"mins" => "mins",
"min" => "min",
"wiki" => "wiki",
"index" => "index",
"textarea" => "textarea",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
"Avatar" => "Avatar",
"Cookie" => "Cookie",
"Copyright" => "Copyright",
"definition" => "definition",
"URL" => "URL",
"Start" => "Start",
"Filter" => "Filter",
"Text" => "Text",
"data" => "data",
"Id" => "Id",
"Original" => "Original",
"Status" => "Status",
"Mode" => "Mode",
"id" => "id",
"Version" => "Version",
"debug" => "debug",
"Syntax" => "Syntax",
"RSS Wiki" => "RSS Wiki",
"RSS Blogs" => "RSS Blogs",
"Ip" => "Ip",
"Bytes maximum" => "Bytes maximum",
"OK" => "OK",
"Normal" => "Normal",
"CC" => "CC",
"BCC" => "BCC",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"Cc" => "Cc",
"Cache" => "Cache",
"Chat" => "Chat",
"Banners" => "Banners",
"Cookies" => "Cookies",
"phpinfo" => "phpinfo",
"Admin dsn" => "Admin dsn",
"April" => "April",
"September" => "September",
"November" => "November",
"December" => "December",
"URI" => "URI",
"RSS" => "RSS",
"avatar" => "avatar",
"Integrator" => "Integrator",
"XMLRPC API" => "XMLRPC API",
"Tiki version" => "Tiki version",
"Server OS" => "Server OS",
"Unix" => "Unix",
"Windows" => "Windows",
"Port" => "Port",
"port" => "port",
"Wysiwyg" => "Wysiwyg",
"PEAR::Auth" => "PEAR::Auth",
"HTTP port" => "HTTP port",
"HTTPS port" => "HTTPS port",
"Webmaster" => "Webmaster",
"Automonospaced text" => "Automonospaced text",
"dls" => "dls",
"information" => "information",
"DSN" => "DSN",
"bytes" => "bytes",
"x" => "x",
"h" => "h",
"CMS" => "CMS",
"cookie" => "cookie",
"Ver" => "Ver",
"POP3 server" => "POP3 server",
"Regex" => "Regex",
"Position" => "Position",
"POP server" => "POP server",
"SMTP server" => "SMTP server",
"wiki-get" => "wiki-get",
"wiki-put" => "wiki-put",
"wiki-append" => "wiki-append",
"Data" => "Data",
"PDF" => "PDF",
"Alias" => "Alias",
"isMain" => "isMain",
"Tbl vis" => "Tbl vis",
"bcc" => "bcc",
"Process" => "Process",
"popup" => "popup",
"+" => "+",
"URL:" => "URL:",
"cType" => "cType",
"status" => "status",
"Admin FAQ" => "Admin FAQ",
"normal" => "normal",
"neutral" => "neutral",
"Int" => "Int",
"Manual" => "Manual",
"#" => "#",
"inter" => "inter",
"Process:" => "Process:",
"ver:" => "ver:",
"Operation" => "Operation",
"If:SetNextact" => "If:SetNextact",
"auto" => "auto",
"int" => "int",
"process" => "process",
"Program" => "Program",
"server" => "server",
"Top 10" => "Top 10",
"Top 20" => "Top 20",
"Top 50" => "Top 50",
"Top 100" => "Top 100",
"tikiwiki.org" => "tikiwiki.org",
"lol" => "lol",
"razz" => "razz",
"Mb" => "Mb",
"%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
"Pos" => "Pos",
"pts" => "pts",
"3d browser" => "3d browser",
"Administration" => "Administration",
"%H:%M %Z" => "%H:%M %Z",
"tiki-mobile.php" => "tiki-mobile.php",
"unicode" => "unicode",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Denna funktion är avstängd",
"Permission denied you cannot view pages" => "Rättighet att visa sidor saknas",
"Cookies must be allowed to vote" => "Cookies krävs för omröstningen",
"Re:" => "Svar:",
"This forum is flat and doesn't allow replies to other replies" => "Det här forumet tillåter inte svar på andra svar.",
"This script cannot be called directly" => "Den här sidan kan inte anropas direkt",
"The copyright management feature is not enabled." => "Copyrighthanteringsfunktionen är inte aktiverad.",
"No page indicated" => "Ingen sida angiven",
"You must supply all the information, including title and year." => "Du måste tillhandahålla all information, inklusive titel och år.",
"You do not have permission to use this feature" => "Rättighet att att använda funktionen saknas",
"Type" => "Typ",
"Name" => "Namn",
"Description" => "Beskrivning",
"Size" => "Storlek",
"Created" => "Skapad",
"Last Modified" => "Senast ändrad",
"Creator" => "Skapad av",
"Author" => "Författare",
"Comment" => "Kommentar",
"Files" => "Filer",
"Hits" => "Träffar",
"Path" => "Sökväg",
"Afghanistan" => "Afganistan",
"Albania" => "Albanien",
"Algeria" => "Algeriet",
"Armenia" => "Armeniena",
"Australia" => "Australien",
"Austria" => "Österike",
"Azerbaijan" => "Azerbajdzjan",
"Belgium" => "Belgien",
"Bosnia and Herzegovina" => "Bosnien-Hercegovina",
"Brazil" => "Brazilien",
"British Indian Ocean Territory" => "Brittiska territoriet i Indiska oceanen",
"Bulgaria" => "Bulgarien",
"Cambodia" => "Kambodja",
"Cameroon" => "Kamerun",
"Canada" => "Kanada",
"Cape Verde" => "Kap Verde",
"Central African Republic" => "Centralafrikanska republiken",
"China" => "Kina",
"Congo" => "Kongo",
"Croatia" => "Kroatien",
"Cuba" => "Kuba",
"Cyprus" => "Cypern",
"Denmark" => "Danmark",
"Egypt" => "Egypten",
"Equatorial Guinea" => "EEkvatorialguinea",
"Ethiopia" => "Etiopien",
"Europe" => "Europa",
"France" => "Frankrike",
"Germany" => "Tyskland",
"Greece" => "Grekland",
"Greenland" => "Grönland",
"Iceland" => "Island",
"India" => "Indien",
"Indonesia" => "Indonesien",
"Iraq" => "Irak",
"Ireland" => "Irland",
"Italy" => "Italien",
"Lebanon" => "Libanon",
"Luxemburg" => "Luxenburg",
"Macedonia" => "Makedonien",
"Madagascar" => "Madagaskar",
"Maldives" => "Maldiverna",
"Marshall Islands" => "Marshallöarna",
"Mexico" => "Mexiko",
"Netherlands" => "Nederländerna",
"None" => "Ingen",
"North Korea" => "Nordkorea",
"Norway" => "Norge",
"Palestine" => "Palestina",
"Philippines" => "Filippinerna",
"Poland" => "Polen",
"Saudi Arabia" => "Saudi Arabien",
"Serbia" => "Serbien",
"Sweden" => "Sverige",
"Syria" => "Syrien",
"Turkey" => "Turkiet",
"Ukraine" => "Ukraina",
"MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Kräver MySQL 4.1+",
"Email address not valid, test mail not sent" => "E-post adressen är inte giltig, testmail skickas inte",
"Test mail from Tiki installer " => "Test brev från Tiki installeraren ",
"Congratulations!\n\nYour server can send emails.\n\n" => "Grattis!\n\nDin server kan skicka e-post.\n\n",
"Simplified Chinese" => "Förenklad Kinesiska",
"Chinese" => "Kinesiska",
"Czech" => "Tjeckiska",
"Danish" => "Danska",
"German" => "Tyska",
"English" => "Engelska",
"Spanish" => "Spanska",
"Greek" => "Grekiska",
"French" => "Franska",
"Hebrew" => "Hebreiska",
"Italian" => "Italienska",
"Japanese" => "Japanska",
"Norwegian" => "Norska",
"Polish" => "Polska",
"Russian" => "Rysska",
"Slovak" => "Svenska",
"Serbian" => "Serbiska",
"Swedish" => "Svenska",
"Traditional Chinese" => "Traditionell Kinesiska",
"Fatal error: cannot execute automatic activity \$activityId" => "Fatalt fel: kan inte utföra automatisk aktivitet \$activityId",
"Fatal error: setting next activity to an unexisting activity" => "Fatalt fel: nästa aktivitet är satt till en ickeexisterande aktivitet",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Fatalt fel: nästa aktivitet matchar inte någon kandidat i automatisk dirigering av aktivitetsväxling",
"Fatal error: non-deterministic decision for autorouting activity" => "Fatalt fel: icke deterministiskt val för automatisk dirigering av aktiviteter",
"Fatal error: trying to send an instance to an activity but no transition found" => "Fatalt fel: försöker att skicka en instans till en aktivitet men ingen trasition hittades",
"Cannot add transition only split activities can have more than one outbound transition" => "Kan ej lägga till transition. Endast delade aktiviteter kan ha mer än en utgående aktivitet",
"Circular reference found some activity has a transition leading to itself" => "Cirkulär referens hittad. Någon aktivitet har en transition som leder till sig själv",
"Process does not have a start activity" => "Processen har ingen startaktivitet",
"Process does not have exactly one end activity" => "Processen har inte exakt en slutaktivitet",
"End activity is not reachable from start activity" => "Slutaktiviteten kan ej nås från startaktiviteten",
"Activity" => "Aktivitet",
"Role" => "Roll",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Aktiviteten '.\$res['name'].' är ensamstående och använder \$instance objektet",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Aktiviteten '.\$res['name'].' är interaktive så den måste använda \$instance->complete() metoden",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Aktiviteten '.\$res['name'].' är ej interaktive så den får inte använda \$instance->complete() metoden",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Aktiviteten '.\$res['name'].' är en växel så den måste använda \$instance->setNextActivity(\$actname) metoden",
"Process %d has been activated" => "Process %d har blivit aktiverad",
"Process %d has been deactivated" => "Process %d har blivit deaktiverad",
"Process %s %s imported" => "Process %s %s importerad",
"Process %s removed" => "Process %s borttagen",
"Process %s has been updated" => "Process %s har uppdaterats",
"Process %s has been created" => "Process %s har skapats",
"points" => "poäng",
"on left side" => "på vänster sida",
"on center" => "centrerad",
"on right side" => "på höger sida",
"Disabled" => "Avstängd",
"Plain text" => "Vanlig text",
"Link to user information" => "Länk till användarinformation",
"User avatar" => "Användarens avatar",
"Creation date (desc)" => "Skapelsedatum (fallande)",
"Last modification date (desc)" => "Senast ändrat (fallande)",
"Blog title (asc)" => "Blog titel (stigande)",
"Number of posts (desc)" => "Antal inlägg (fallande)",
"Visits (desc)" => "Besök (fallande)",
"Activity (desc)" => "Aktivitet (fallande)",
"Top bar" => "Sidhuvud",
"Bottom bar" => "Sidfot",
"no cache" => "inget cache",
"minute" => "minut",
"minutes" => "minuter",
"hour" => "timme",
"hours" => "timmar",
"|| for rows" => "|| för rader",
"complete" => "komplett",
"english" => "engelsk",
"Day" => "Dag",
"Week" => "Vecka",
"Month" => "Månad",
"Quarter" => "Kvartal",
"Semester" => "Termin",
"Year" => "År",
"Saturday" => "Lördag",
"Sunday" => "Söndag",
"Monday" => "Måndag",
"No error reporting" => "Inga felmeddelanden",
"Report all PHP errors" => "Visa alla PHP fel",
"Report all errors except notices" => "Visa alla fel utom \"notices\"",
"Creation Date (desc)" => "Skapelsedatum (fallande)",
"Topics (desc)" => "Ämnen (fallande)",
"Threads (desc)" => "Trådar (fallande)",
"Last post (desc)" => "Senaste inlägg (fallande)",
"Name (desc)" => "Namn (fallande)",
"Name (asc)" => "Namn (stigande)",
"replace current window" => "ersätt nuvarande fönster",
"new window" => "nytt fönster",
"inline frame" => "infogad ram",
"Each day" => "Varje dag",
"Each week" => "Varje vecka",
"Each month" => "Varje månad",
"5 minutes" => "5 minuter",
"15 minutes" => "15 minuter",
"30 minutes" => "30 minuter",
"1 hour" => "1 timme",
"2 hours" => "2 timmar",
"10 hours" => "10 timmar",
"20 hours" => "20 timmar",
"1 day" => "1 dag",
"1 week" => "1 vecka",
"1 month" => "1 månad",
"1 year" => "1 år",
"Allow secure (https) login" => "Tillåt säkra (https) inloggningar",
"Encourage secure (https) login" => "Uppmuntra säker (https) inloggning",
"Consider we are always in HTTPS, but do not check" => "Antag att HTTPS alltid används, men kontrollera inte",
"Require secure (https) login" => "Kräv säkra (https) inloggningar",
"Just Tiki" => "Bara Tiki",
"Web Server" => "Webbserver",
"Tiki and PEAR::Auth" => "Tiki och PEAR::Auth",
"Tiki and PAM" => "Tiki och PAM",
"Registered" => "Registrerad",
"Anonymous" => "Anonym",
"Admins" => "Administratörer",
"Use database to store files" => "Använd databasen till att lagra filer",
"Use a directory to store files" => "Använd en katalog för att lagra filer",
"No forums" => "Inga forum",
"%s enabled" => "%s aktiverad",
"\$feature is turned on" => "\$feature är igång",
"%s disabled" => "%s inaktiverad",
"\$feature is turned off" => "\$feature är avstängd",
"Permission denied" => "Åtkomst nekad",
"The file is not a CSV file or has not a correct syntax" => "Filen är ingen CSV fil eller så har den en felaktig syntax",
"locked" => "låst",
"locked by" => "låst av",
"in" => "i",
"continued" => "fortsättning",
"tracker" => "ärendeföljare",
"by" => "av",
"Image Gallery" => "Bildgalleri",
"Articles" => "Artiklar",
"Blogs" => "Bloggar",
"Forums" => "Forum",
"Directory" => "Katalog",
"File Gallery" => "Filgalleri",
"FAQs" => "FAQ'er",
"Quizzes" => "Frågesporter",
"Trackers" => "Ärendeföljare",
"Survey" => "Undersökning",
"Newsletter" => "Nyhetsbrev",
"Charts" => "Diagram",
"article" => "artikel",
"directory" => "webbkatalog",
"poll" => "omröstning",
"quiz" => "frågesport",
"image" => "bild",
"calendar" => "kalender",
"Invalid filename (using filters for filenames)" => "Ogiltigt filnamn (filnamnfilter används)",
"Cannot upload this file maximum upload size exceeded" => "Kan ej ta emot denna fil eftersom den maximala filstorleken har överskridits",
"Cannot write to this file:" => "Kan ej skriva till denna fil:",
"Wrong password. Cannot post comment" => "Felaktigt lösenord. Kan ej lägga in kommentar",
"You have to enter a title and text" => "Du måste ange titel och text",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::apply: antalet rader stämmer ej %s != %s",
"WikiDiff::_check: failed" => "WikiDiff::_check: misslyckades",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_check: redigeringsekvensen är optimal",
"Find" => "Sök",
"find" => "sök",
"prev" => "föregående",
"Page" => "Sida",
"next" => "nästa",
"Link" => "Länk",
"Page name" => "Sidnamn",
"Wiki Home" => "Wikins startsida",
"Home" => "Start",
"previous page" => "föregående sida",
"next page" => "nästa sida",
"posted on" => "inlagd den",
"Continue" => "Fortsätt",
"By:" => "Av:",
"Read" => "Läs",
"List articles" => "Artikellista",
"Last post" => "Senaste inlägg",
"Invalid imagename (using filters for filenames)" => "Ogiltigt bildnamn (filnamnsfilter används)",
"Errors detected" => "Upptäckta fel",
"Upload was not successful" => "Sändningen misslyckades",
"No image yet, sorry." => "Tyvärr ingen bild ännu.",
"unknown" => "okänd",
"NONE" => "INGEN",
"Wiki top pages" => "Bästa wiki-sidor",
"Most relevant pages" => "Mest relevanta sidor",
"Relevance" => "Relevans",
"Wiki last pages" => "Senaste wiki-sidor",
"Modified" => "Modifierad",
"Forums last topics" => "Forumens senaste ämnen",
"Topic date" => "Ämnets datum",
"Forums most read topics" => "Forumets mest lästa ämne",
"Reads" => "Läsningar",
"Forums best topics" => "Forumets bästa ämne",
"Score" => "Poäng",
"Forums most visited forums" => "Forumets mest besökta forum",
"Visits" => "Besök",
"Forums with most posts" => "Forum med flest inlägg",
"Posts" => "Inlägg",
"Wiki top galleries" => "Bästa wiki-gallerier",
"Wiki top file galleries" => "Bästa wiki-filgallerier",
"Wiki top images" => "Bästa wiki-bilder",
"Wiki top files" => "Bästa wiki-filer",
"Downloads" => "Antal inläsningar (downloads)",
"Wiki last images" => "Senaste wiki-bilder",
"Upload date" => "Inskickad den",
"Wiki last files" => "Senaste wiki-filer",
"Wiki top articles" => "Bästa wiki-artiklar",
"Most visited blogs" => "Mest besökta bloggar",
"Most active blogs" => "Mest aktiva bloggar",
"Blogs last posts" => "Senaste bloginlägg",
"Post date" => "Inlagd den",
"Wiki top authors" => "Bästa wiki-författare",
"Pages" => "Sidor",
"Top article authors" => "Bästa artikelförfattare",
"User already exists" => "Användaren existerar redan",
"Wrong registration code" => "Felaktig registreringskod",
"Invalid username" => "Felaktigt användarnamn",
"Username is too long" => "Användarnamnet är för långt",
"Username cannot contain whitespace" => "Användarnamn får ej innehålla blanktecken",
"Wrong passcode you need to know the passcode to register in this site" => "Felaktig passerkod. Du måste känna till passerkoden för att registrerar på denna sajt",
"Invalid email address. You must enter a valid email address" => "Felaktig e-e-postadress. Du måste ange en giltig e-e-postadress",
"Login" => "Logga in",
"Send message" => "Skicka meddelande",
"Attach file" => "Bifoga fil",
"Tracker" => "Ärendeföljare",
"Unknown" => "Okänd",
"Image" => "Bild",
"Article" => "Artikel",
"Directory category" => "Webbkatalogkategori",
"Gallery" => "Galleri",
"Blog post" => "Bloginlägg",
"Prev" => "Föregående",
"Next" => "Nästa",
"Admin Feature" => "Administrera",
"Hide" => "Göm",
"help" => "hjälp",
"All" => "Alla",
"days" => "dagar",
"day" => "dag",
"secs" => "sek.",
"done" => "klar",
"from" => "från",
"for" => "till",
"Priority" => "Prioritet",
"Yes" => "Ja",
"No" => "Nej",
"pvs" => "s.v.",
"created from structure" => "skapad från struktur",
"Table of contents" => "Innehållsförteckning",
"You are not logged in" => "Du är inte inloggad",
"Page cannot be found" => "Sidan kan ej hittas",
"Permission denied you cannot view this section" => "Åtkomst nekad! du har inte tillgång till denna avdelning",
"Help" => "Hjälp",
"You are banned from" => "Du är bannlyst från",
"faqs" => "faq'er",
"quizzes" => "frågesporter",
"blogs" => "bloggar",
"forums" => "forum",
"games" => "spel",
"Edit Plugin" => "Redigera Plugin",
"Click to edit dynamic variable" => "Klicka för att redigera dynamisk variabel",
"Update variables" => "Uppdatera variabler",
"Edit Section" => "Redigera Sektion",
"Show" => "Visa",
"at" => "vid",
"new" => "nytt",
"Unknown language" => "Okänt språk",
"Rating" => "Betyg",
"Item" => "Post",
"Subject" => "Ämne",
"Tracker was modified at " => "Ärendeföljaren modifierades på ",
"text field" => "text fält",
"size" => "storlek",
"checkbox" => "kryssruta",
"drop down" => "nerfallande",
"user selector" => "användarval",
"group selector" => "gruppval",
"date and time" => "datum och tid",
"action" => "åtgärd",
"category" => "kategori",
"email" => "e-post",
"attachment" => "bilaga",
"open" => "öppen",
"closed" => "stängd",
"Message" => "Meddelande",
"child categories" => "underkategorier",
"objects in category" => "objekt i kategorin",
"Password should be at least" => "Lösenord måste vara minst",
"characters long" => "tecken långa",
"Password must contain both letters and numbers" => "Lösenord måste innehålla både bokstäver och siffror",
"Country" => "Land",
"Location" => "Plats",
"Language" => "Språk",
"File" => "Fil",
"Show description" => "Visa beskrivning",
"Displays the user Avatar" => "Visar användarens Avatar",
"username" => "användarnamn",
"Backlinks" => "Refererande sidor",
"List all pages which link to specific pages" => "Lista alla sidor som länkar till specifika sidor",
"No pages links to" => "Inga sidor länkar till",
"One page links to" => "En sida länkar till",
"pages link to" => "sidor länkar till",
"Zone" => "Zoner",
"Items" => "Poster",
"Insert theme styled box on wiki page" => "Stoppa in temastyrd box på wiki-sida",
"Category" => "Kategori",
"Insert list of items for the current/given category into wiki page" => "Stoppa in en lista på poster för nuvarande/vald kategori på wiki-sidan",
"Categories are disabled" => "Kategorier ar deaktiverade",
"Display Tiki objects that have not been categorized" => "Visa objekt som inte har blivit kategoriserade",
"Objects" => "Objekt",
"Insert the full category path for each category that this wiki page belongs to" => "Stoppa in den fullständiga kategorisökvägen för varje kategori som den här wiki-sidan tillhör",
"Center" => "Centrera",
"Centers the plugin content in the wiki page" => "Centrera insticksmodulens innehåll i wiki-sidan",
"Chart" => "Diagram",
"title" => "titel",
"Displays a snippet of code" => "Visar en kodsnutt",
"code" => "kod",
"Insert copyright notices" => "Stoppa in copyright meddelande",
"Example" => "Exempel",
"seconds" => "sekunder",
"Creates a definition list" => "Skapar en definitionslista",
"term" => "uttryck",
"one definition per line" => "En definition per rad",
"drawing not found" => "ritning ej hittad",
"Desc" => "Beskrivning",
"Upcoming events" => "Kommande händelser",
"Label" => "Etikett",
"Displays the data using the Tikiwiki odd/even table style" => "Visar data med udda/jämn tabellstil",
"cells" => "celler",
"heads and cells separated by ~|~" => "huvuden och celler separeras av ~|~",
"Title" => "Titel",
"sort" => "sortera",
"failed" => "misslyckades",
"description" => "beskrivning",
"Value" => "Värde",
"Displays a graphical GAUGE" => "Visar en grafisk mätare",
"type" => "typ",
"Group" => "Grupp",
"HTML code" => "HTML kod",
"name" => "namn",
"Image ID" => "Bild ID",
"Image size" => "Bildstorlek",
"Img" => "Bild",
"Include" => "Infoga",
"Include a page" => "Infoga en sida",
"Displays the text only if the language matchs" => "Visa texten enbart om språket matchar",
"List Pages" => "Lista Sidor",
"Sort" => "Sortera",
"or" => "eller",
"Map" => "Mapp",
"Feature disabled" => "Funktionen avstängd",
"Style" => "Stil",
"Module Name" => "Modulnamn",
"Please choose a module" => "Vänligen välj en modul",
"to be used as argument" => "att användas som argument",
"Displays a module inlined in page" => "Visar en modul infogad i en sida",
"Sorry no such module" => "Tyvärr, ingen sådan modul",
"Font" => "Typsnitt",
"Displays the data using a monospace font" => "Visar texten med ett monospace typsnitt",
"Object" => "Objekt",
"Days" => "Dagar",
"picture not found" => "bild ej hittad",
"Provides a list of plugins on this wiki." => "Tillhandahåller en lista med insticksmoduler till denna wiki.",
"No version indicated" => "Ingen version angiven",
"No arguments indicated" => "Inga argument angivna",
"one data per line" => "en post per rad",
"Search" => "Sök",
"Icon" => "Ikon",
"Date" => "Datum",
"Automatically creates a link to the appropriate SourceForge object" => "Skapar automatiskt en länk till motsvarande SourceForge objekt",
"List wiki pages" => "Visa wikisidor",
"Display" => "Visa",
"Action" => "Handling",
"Sorts the plugin content in the wiki page" => "Sorterar insticksmodulens innehåll i wiki-sidan",
"Order" => "Ordning",
"Split a page into rows and columns" => "Dela upp en sida i rader och kolumner",
"First" => "Först",
"Edit" => "Redigera",
"row1col1" => "rad1kol1",
"row1col2" => "rad1kol2",
"row2col1" => "rad2kol1",
"row2col2" => "rsw2kol2",
"Run a sql query" => "Kör a sql fråga",
"sql query" => "sql fråga",
"Missing db param" => "Saknad db parameter",
"Subscribe" => "Prenumerera",
"Groups" => "Grupper",
"Tag Name" => "Bokmärkesnamn",
"Thumbnail" => "Indexbild",
"Search the titles of all pages in this wiki" => "Sök i titlarna på alla sidor i denna wiki",
"No pages found for title search" => "Inga sidor funna i titelsökningen",
"One page found for title search" => "En sida funnen i titelsökningen",
"Structure ID" => "Struktur ID",
"Public" => "Offentlig",
"Translate" => "Översätt",
"Preview" => "Förhandsgranska",
"preview" => "förhandsgranska",
"Error" => "Fel",
"Filters" => "Filter",
"Template" => "Mall",
"Links to a translated content" => "Länkar till översatt innehåll",
"users" => "användare",
"Preferences" => "Inställningar",
"User Information" => "Användarinformation",
"Versions" => "Version",
"Vote" => "Rösta",
"External Wiki" => "Extern Wiki",
"valid" => "giltig",
"Top" => "Upp",
"ERROR: Either the subject or body must be non-empty" => "FEL: Antingen rubriken eller brödtexten måste ha något innehåll",
"ERROR: No valid users to send the message" => "FEL: Inga giltiga användare att skicka meddelandet till",
"Invalid user" => "Ogiltig användare",
"Message sent to" => "Meddelande skickat till",
"Message will be sent to: " => "Meddelandet kommer att skickas till: ",
"No more messages" => "Inga fler meddelanden",
"Tiki Calendar" => "Tiki Kalender",
"Calendar" => "Kalender",
"Create/Edit" => "Skapa/Ändra",
"Quick Edit a Wiki Page" => "Snabbredigera Wikisida",
"Post" => "Skicka",
"Changes since" => "Ändringar sedan",
"new comments" => "nya kommentarer",
"wiki pages changed" => "ändrade wiki-sidor",
"new images" => "nya bilder",
"new files" => "nya filer",
"new users" => "nya användare",
"Invalid username or password" => "Ogiltigt användarnamn eller lösenord",
"country" => "land",
"Anti-Bot verification code" => "Kod för att förhindra automatiserad registrering",
"Random Image" => "Slumpmässig bild",
"Enter the code you see above" => "Skriv koden som visas ovan",
"List of attached files" => "List på filbilagor",
"desc" => "beskrivning",
"uploaded" => "inlagd",
"Download" => "Hämta",
"Delete" => "Radera",
"Remove" => "Radera",
"Upload file" => "Skicka fil",
"Attach" => "Bifoga",
"Attach a file to this item" => "Billägg en fil till denna post",
"Attachments" => "Bilagor",
"more info" => "mer info",
"No attachments for this item" => "Inga bilagor till denna post",
"Fatal error" => "Fatalt fel",
"Created by" => "Skapad av",
"Edit blog" => "Redigera blog",
"Activity=" => "Aktivitet=",
"Actions" => "Åtgärder",
"Properties" => "Egenskaper",
"No records found" => "Kan inte hitta informationen i arkivet",
"Categorize" => "Kategorisera",
"Select Categories" => "Välj Kategorier",
"Admin Categories" => "Admin Kategories",
"No categories defined" => "Inga kategorier definierade",
"Browse Category" => "Visa Kategori",
"stars" => "stjärnor",
"User Level" => "Användarnivå",
"private message" => "privata meddelanden",
"user online" => "användaren ansluten",
"user offline" => "användaren oansluten",
"Reply" => "Svara",
"Approve" => "Godkänn",
"Save to notepad" => "Spara till anteckningsblock",
"Moderator actions" => "moderatorns åtgärder",
"reported:" => "rapporterat:",
"queued:" => "köad:",
"Move to topic:" => "Flytta till ämne:",
"Delete Selected" => "Radera valda",
"Comments Locked" => "Kommentarer låsta",
"Unlock" => "Lås upp",
"Lock" => "Lås",
"Messages" => "Meddelanden",
"Newest first" => "Nyast först",
"Oldest first" => "Äldst först",
"Title (desc)" => "Titel (fallande)",
"Title (asc)" => "Titel (stigande)",
"Threshold" => "Tröskelvärde",
"Set" => "Sätt",
"Replies" => "Svar",
"Post new message" => "Skriv nytt inlägg",
"Editing comment" => "Redigera kommentar",
"Post new comment" => "Skicka en ny kommentar",
"required" => "krävs",
"Smileys" => "Gladisar",
"Post as Anonymous" => "Skicka anonymt",
"Cancel" => "Avbryt",
"Posting replies" => "Skriva svar",
"Posting comments" => "Skicka kommentarer",
"Use" => "Använd",
"for links" => "till länkar",
"HTML tags are not allowed inside posts" => "HTML kod tillåts inte i inlägg",
"Add Comment" => "Kommentera",
"1 comment" => "1 kommentar",
"Comments" => "Kommentarer",
"Go back" => "Tillbaka",
"Return to home page" => "återvänd till startsidan",
"Copyrights" => "Copyright",
"Authors" => "Författare",
"Add" => "Skapa",
"Page generation debugging log" => "Sidogenererings debuglog",
"Features state" => "Funktionstillstånd",
"Total" => "Totalt",
"features matched" => "matchade funktioner",
"Watchlist" => "Bevakningslista",
"duplicate" => "dubblett",
"There are individual permissions set for this file gallery" => "Detta filgalleri har individuella rättigheter",
"Save" => "Spara",
"Gallery is visible to non-admin users?" => "Galleriet är synligt för icke-administratörer?",
"none" => "ingen",
"Max description display size" => "Max storlek på beskrivning",
"Max Rows per page" => "Max. antal rader per sida",
"Listing configuration" => "Listar konfiguration",
"Create this page" => "Skapa denna sida",
"Private Gallery" => "Privat Galleri",
"Perms" => "Rättigheter",
"Replace" => "Ersätt",
"List" => "Lista",
"Browse" => "Bläddra",
"Name-filename" => "Namn-filnamn",
"Filename only" => "Endast filnamn",
"Close" => "Stäng",
"Number of displayed rows" => "Antal visade rader",
"in:" => "i:",
"RSS Articles" => "RSS Artiklar",
"RSS Image Galleries" => "RSS Bildgallerier",
"RSS File Galleries" => "RSS Filgallerier",
"RSS Forums" => "RSS Forum",
"RSS Directories" => "RSS Kataloger",
"RSS Calendars" => "RSS Kalendrar",
"Move to" => "Flytta till",
"Filename" => "Filnamn",
"Hi {\$mail_user} has sent you this link:" => "Hej, {\$mail_user} har skickat dig denna länk:",
"Blog post:" => "Bloginlägg:",
"at:" => "vid:",
"Somebody or you tried to subscribe this email address at our site:" => "Du (eller någon annan) har anmält den här e-postadressen på vår sida:",
"To the newsletter:" => "Till nyhetsbrev:",
"Description:" => "Beskrivning:",
"In order to confirm your subscription you must access the following URL:" => "För att bekräfta din prenumeration måste du besöka följande URL:",
"A new message was posted to forum" => "Ett nytt meddelande skickades till detta forum",
"Hi," => "Hej,",
"A new message was posted to you at {\$mail_machine}" => "Ett meddelande skickades till dig från {\$mail_machine}",
"From" => "Frän",
"Hi" => "Hej",
"Enjoy the site!" => "Njut av denna sajt!",
"The user" => "Användaren",
"registered at your site" => "registrerad på din sajt",
"New user registration" => "Registrering av ny användare",
"Bye bye!" => "Hej då!",
"This email address has been removed to the list of subscriptors of:" => "Denna e-postadress har blivit borttagen som prenumerant av:",
"Newsletter:" => "Nyhetsbrev:",
"You can unsubscribe from this newsletter following this link" => "Du kan avbryta din prenumeration på detta nyhetsbrev genom att följa följande länk",
"Welcome to our newsletter!" => "Välkomment till vårt nyhetsbrev!",
"This email address has been added to the list of subscriptors of:" => "Denna e-mejadress har blivit inlagd som prenumerant av:",
"You can always cancel your subscription using:" => "Du kan alltid avsluta din prenumeration genom att använda:",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "En ny artikel har skickats in av {\$mail_user} till  den {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "Du kan redigera bidraget genom att följa denna länk:",
"Title:" => "Titel:",
"Heading:" => "Rubrik:",
"Body:" => "Brödtext:",
"User:" => "Användare:",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Om du vill vara en registrerad användare på denna sajt skall du följa följande länk när du loggar in för första gången:",
"You will receive an email with information to login for the first time into this site" => "Du kommer att få e-post med information om hur du loggar in första gången.",
"If you don't want to receive these notifications follow this link:" => "Om du inte vill mottaga dessa meddelanden, följ denna länk:",
"View the blog at:" => "Bloginlägget visas på:",
"changed" => "ändrad",
"created" => "skapad",
"Updated by" => "Ändrad av",
"File Description" => "Filbeskrivning",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Kartan {\$mail_page} ändrades av {\$mail_user} den {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "Du kan se på den uppdaterade kartan genom att följa denna länk:",
"You can edit the map following this link:" => "Du kan redigera kartan genom att följa denna länk:",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Sidan {\$mail_page} ändrades av {\$mail_user} den {\$mail_date|tiki_short_datetime}",
"Comment:" => "Kommentar:",
"The new page content follows below." => "Det nya sidinehållet följer nedan.",
"New name" => "Nytt namn",
"click on the map to zoom or pan, do not drag" => "klicka på kartan för att zooma eller panorera, dra inte",
"Scale" => "Skala",
"Query" => "Fråga",
"Redraw" => "Rita om",
"select zoom/pan/query and image size" => "välj zooma/panorera/fråga och bildstorlek",
"Click on the map or click redraw" => "Klicka på kartan för att rita om",
"Last modification date" => "Senaste ändringsdatum",
"Overview" => "Översikt",
"Legend" => "Teckenförklaring",
"Layer Manager" => "Lagerhanterare",
"On" => "På",
"Download Layer" => "Hämta lager",
"you have requested to download the layer:" => "du har begärt att följande lager skall hämtas:",
"Here are the files to download, do not forget to rename them:" => "Detta är filerna som kommer att hämtas, glöm inte att döpa om dem:",
"Mapfiles" => "Kartfiler",
"Mapfile" => "Kartfil",
"Available mapfiles" => "Tillgängliga kartfiler",
"monitor this map" => "övervaka denna karta",
"Create a new mapfile" => "Skapa en ny kartfil",
"Create" => "Skapa",
"Mapfile listing" => "Kartfilslista",
"History" => "Versioner",
"You can view this map in your browser using" => "Du kan visa denna karta i din webbläsare med",
"of" => "från",
"Versions are identical" => "Versionerna är identiska",
"User" => "Användare",
"Directories" => "Webbkataloger",
"Upload From Disk:" => "Skicka från disk:",
"Upload Files" => "Skicka filer",
"Create Directory:" => "Skapa webbkatalog:",
"index file (.shp):" => "index fil (.shp):",
"files to index (regexp):" => "filer att indexera (regexp):",
"Unread" => "Olästa",
"Flagged" => "Flaggad",
"Unflagged" => "Oflaggad",
"Containing" => "Innehåller",
"Sender" => "Avsändare",
"No messages to display" => "Inga medelanden finns att visa",
"All users" => "Alla användare",
"Lowest" => "Lägst",
"Low" => "Låg",
"High" => "Hög",
"Very High" => "Högst",
"Send" => "Skicka",
"Compose message" => "Komponera meddelande",
"Invalid" => "Ogiltig",
"To" => "Till",
"is reply to" => "är svar till",
"Archive" => "Arkiv",
"Mark as read" => "Markera som läst",
"Mark as unread" => "Markera som oläst",
"Mark as flagged" => "Märk som flaggad",
"Mark as unflagged" => "Avmarkera Flaggning",
"Mark" => "Markera",
"Mailbox" => "Brevlåda",
"Compose" => "Komponera",
"Sent" => "Skickat",
"Read message" => "Läs meddelande",
"replyall" => "svara alla",
"Flag this message" => "Flagga detta meddelande",
"Move module up" => "Flytta upp modulen",
"Up" => "Upp",
"Move module down" => "Flytta ner modulen",
"Down" => "Ner",
"Move module to opposite side" => "Flytta modulen till andra sidan",
"Admin Menu" => "Admin meny",
"Live Support" => "Direktsupport",
"Banning" => "Bannlysning",
"Users" => "Användare",
"Modules" => "Moduler",
"Links" => "Länkar",
"Hotwords" => "Nyckelord",
"RSS Modules" => "RSS Moduler",
"Menus" => "Menyer",
"Polls" => "Omröstningar",
"Mail Notifications" => "E-postbesked",
"Search Stats" => "Sökstatistik",
"QuickTags" => "Snabbflikar",
"Categories" => "Kategorier",
"Edit Templates" => "Redigera mallar",
"Mail-in" => "Mejl-in",
"Content Templates" => "Innehålsmallar",
"HTML Pages" => "HTMLsidor",
"Shoutbox" => "Megafon",
"Shoutbox Words" => "MegafonOrd",
"Referer Stats" => "Hänvisningsstatistik",
"Import PHPWiki Dump" => "Importera PHPWiki Dump",
"Security Admin" => "Säkerhets Admin",
"Select" => "Välj",
"Admin Home" => "Admin Huvudsida",
"Admin" => "Administrera",
"Admin Modules" => "Admin moduler",
"Admin Menus" => "Admin menyer",
"login" => "logga in",
"Recently visited pages" => "Nyligen besökta sidor",
"January" => "Januari",
"February" => "Februari",
"March" => "Mars",
"May" => "Maj",
"June" => "Juni",
"July" => "Juli",
"August" => "Augusti",
"October" => "Oktober",
"Tuesday" => "Tisdag",
"Wednesday" => "Onsdag",
"Thursday" => "Torsdag",
"Friday" => "Fredag",
"Today" => "Idag",
"Received objects" => "Mottagna objekt",
"Pages:" => "Sidor:",
"Last Sites" => "Senaste Sajter",
"Directory Stats" => "Webbkatalog statistik",
"Sites" => "Sajter",
"Sites to validate" => "Sajter att validera",
"Searches" => "Sökningar",
"Visited links" => "Besökta länkar",
"Top Sites" => "Top Sajter",
"Featured links" => "Utvalda länkar",
"Top topics" => "Populäraste ämnen",
"Last forum topics" => "Senaste ämnen i forum",
"Most commented forums" => "Forum med flest kommentarer",
"Most read topics" => "Mest lästa ämnen",
"Most visited forums" => "Mest besökta forumet",
"More Like This" => "Fler liknande",
"Most popular tags" => "Vanligaste nyckelorden",
"Google Search" => "Google sökning",
"Last articles" => "Senaste artiklar",
"Last blog posts" => "Senaste bloginlägg",
"Last" => "Senaste",
"Last Created blogs" => "Senast skapade bloggar",
"Last Created FAQs" => "Senast skapade FAQ'er",
"Last Created Quizzes" => "Senast skapade frågesporter",
"Last modified file galleries" => "Senast ändrade filgallerier",
"Last Files" => "Senaste filer",
"Last galleries" => "Senaste gallerier",
"Last changes" => "Senaste ändringar",
"Last Modified Items" => "Senast Modifierade Poster",
"Last Modified blogs" => "Senast ändrade bloggar",
"Last submissions" => "Senaste bidrag",
"Last Items" => "Senaste Poster",
"Register" => "Registrera",
"Live support" => "Direktsupport",
"Open operator console" => "Öppna operatörskonsol",
"Online users" => "Anslutna användare",
"We have" => "Vi har",
"online users" => "anslutna användare",
"Logout" => "Logga ut",
"Email" => "E-post",
"Password" => "Lösenord",
"Remember me" => "Kom ihåg mig",
"week" => "vecka",
"month" => "månad",
"I forgot my password" => "Jag har glömt mitt lösenord",
"Tiki Logo" => "Logotyp",
"Menu" => "Meny",
"You have" => "Du har",
"You have 0 new messages" => "Du har inga nya meddelanden",
"Waiting Submissions" => "Väntande bidrag",
"submissions waiting to be examined" => "bidrag som väntar på att bli behandlade",
"Old articles" => "Gamla artiklar",
"Send a message to" => "Skicka meddelanden till",
"Random Pages" => "Slumpmässiga sidor",
"Register as a new user" => "Registrera dig som en ny användare",
"Your email could not be validated; make sure you email is correct and click register below." => "Din e-postadress kunde inte verifieras; säkerställ att din e-postadress stämmer och klicka på registrera nedan.",
"Your registration code:" => "Din registreringskod:",
"Username" => "Användarnamn",
"Passcode to register (not your user password)" => "Anmälningskod (inte ditt lösenord)",
"Registration code" => "Registreringskod",
"Repeat password" => "Upprepa lösenordet",
"Generate a password" => "Generera ett lösenord",
"Image Galleries" => "Bildgallerier",
"File Galleries" => "Filgallerier",
"Maps" => "Mappar",
"Entire Site" => "Hela Sajten",
"Wiki Pages" => "Wiki-sidor",
"Image Gals" => "Bildgallerier",
"Images" => "Bilder",
"Blog Posts" => "Blog-inlägg",
"Search Wiki PageName" => "Sök wikisidnamn",
"Read More" => "Läs mer",
"Since your last visit" => "Sedan ditt senaste besök",
"Since your last visit on" => "Sedan ditt senaste besök den",
"click to edit" => "klicka för att redigera",
"Nothing has changed" => "Ingenting har hänt",
"Theme" => "Tema",
"Most Active blogs" => "Mest aktiva bloggar",
"Top articles" => "Populäraste artiklar",
"Top File Galleries" => "Mest populära filgallerier",
"Top games" => "Populäraste spel",
"Top galleries" => "Populäraste gallerier",
"Top Images" => "Populäraste bilderna",
"Top Pages" => "Populäraste sidorna",
"Top Quizzes" => "Populäraste frågesporter",
"Top Visited FAQs" => "Mest besökta FAQ'er",
"view" => "visa",
"My blogs" => "Mina bloggar",
"Bookmarks" => "Bokmärken",
"My galleries" => "Mina gallerier",
"My Pages" => "Mina sidor",
"User tasks" => "Användarens uppgifter",
"Top users" => "Aktivast",
"Whats related" => "Vad är relaterat",
"online user" => "anslutna användare",
"Real Name" => "Riktigt namn",
"vote" => "rösta",
"Structures:" => "Strukturer:",
"show structures" => "visa strukturer",
"hide structures" => "göm strukturer",
"Find:" => "Sök:",
"pages" => "sidor",
"To edit the copyright notices" => "För att redigera copyright meddelande",
"The content on this page is licensed under the terms of the" => "Innehållet på denna sida är licensierat under villkor av",
"Print" => "Skriv ut",
"Permalink" => "Permanent länk",
"comment" => "kommentar",
"comments" => "kommentarer",
"First page" => "Första sidan",
"Previous page" => "Förra sidan",
"page" => "sida",
"Next page" => "Nästa sidan",
"Last page" => "Sista sidan",
"referenced by" => "refererad av",
"references" => "referenser",
"Trackback pings" => "Bakspårnings pling (Trackback pings)",
"Blog name" => "Blog namn",
"Enlarge area height" => "Förstora textfältet",
"Reduce area height" => "Förminsla textfältet",
"Tools Calendars" => "Verktygskalendrar",
"Check / Uncheck All" => "Markera / Avmarkera Alla",
"Refresh" => "Uppdatera",
"Tip" => "Tips",
"Cancel Edit" => "Avbryt redigering",
"Change preferences" => "Ändra inställningar",
"Site Ads and Banners" => "Annonser och Banners",
"Content" => "Innehåll",
"Activate" => "Aktivera",
"Publish" => "Publicera",
"General" => "Generell",
"Features" => "Funktioner",
"Profiles" => "Profiler",
"Module" => "Modul",
"User files" => "Användarfiler",
"Webmail" => "Webbmail",
"Webservices" => "Webbtjänster",
"General Settings" => "Allmänna inställningar",
"Home Blog (main blog)" => "Startblog (huvudblog)",
"Rankings" => "Rangordning",
"Points" => "Poäng",
"Last modified" => "Senast ändrad",
"Permissions" => "Rättigheter",
"Admin topics" => "Admin ämnen",
"Admin types" => "Admin typer",
"Topic" => "Ämne",
"Submissions" => "Bidrag",
"Import CSV file" => "Importera CSV fil",
"Batch upload (CSV file)" => "Skicka i en klump (CSV fil)",
"Import" => "Importera",
"Visible" => "Synlig",
"E-mail" => "E-post",
"Last login" => "Senaste inloggning",
"Distance" => "Avstånd",
"Character set for mail" => "Teckenuppsättning för E-post",
"default" => "standardval",
"Number of visited pages to remember" => "Antal besökta sidor att minnas",
"Displayed time zone" => "Visad tidszon",
"User information" => "Användarinformation",
"Private" => "Privat",
"public" => "allmän",
"Use double-click to edit pages" => "Dubbelklicka för att redigera sidor",
"Tasks per page" => "Uppgifter per sida",
"Messages per page" => "Meddelanden per sida",
"Allow messages from other users" => "Tillåt meddelanden från andra användare",
"Send me an email for messages with priority equal or greater than" => "Skicka mig e-post för meddelanden som har prioritet högre än eller lika med ",
"Auto-archive read messages after x days" => "Auto-arkivera lästa meddelanden efter x dagar",
"never" => "aldrig",
"My Tiki" => "Min Tiki",
"My pages" => "Mina sidor",
"My messages" => "Mina meddelanden",
"My tasks" => "Mina uppgifter",
"My forum topics" => "Mina forumdiskussioner",
"My forum replies" => "Mina forumsvar",
"My items" => "Mina saker",
"Number of columns per page when listing categories" => "Antal kolumner per sida vid kategorivisning",
"Links per page" => "Länkar per sida",
"Validate URLs" => "Validera URL'er",
"Show Country Flag" => "Visa landsflagga",
"Method to open directory links" => "Metod för att öppna kataloglänkar",
"Default number of comments per page" => "Förvalt antal kommentarer per sida",
"Comments default ordering" => "Förvald sorteringsordning av kommentarer",
"Apply" => "Verkställ",
"Newsletters" => "Nyhetsbrev",
"Action Log" => "Händelselog",
"Action log setting" => "Inställningar för händelseloggen",
"Surveys" => "Undersökning",
"Featured Help" => "Utvald hjälp",
"Live support system" => "Direktsupportsystem",
"HTML pages" => "HTML sidor",
"Contact Us" => "Kontakta oss",
"Search engine friendly url" => "Sökmotoroptimerade url:er",
"Drawings" => "Teckningar",
"Games" => "Spel",
"Administration Features" => "Administrationsfunktioner",
"Banning System" => "Bannlysningssystem",
"Banning system" => "Bannlysningssystem",
"Stats" => "Statistik",
"Communications (send/receive objects)" => "Kommunikation (skicka/ta emot objekt)",
"Custom Home" => "Egen startsida",
"User Features" => "Användarfunktioner",
"Mini Calendar" => "Minikalender",
"User Preferences Screen" => "Mina Inställningar",
"User Notepad" => "Mina Anteckningar",
"User Bookmarks" => "Mina Bokmärken",
"User Watches" => "Mina Bevakningar",
"User Menu" => "Mina Genvägar",
"User Tasks" => "Mina Uppgifter",
"User Messages" => "Mina Meddelanden",
"User Files" => "Användarfiler",
"Newsreader" => "Nyhetsläsare",
"Debugger Console" => "Debuggerkonsoll",
"Workflow" => "Process",
"Workflow engine" => "Processmotor",
"Home Gallery (main gallery)" => "Startgalleri (huvudgalleri)",
"Never" => "Aldrig",
"Home Forum (main forum)" => "Startforum (huvudforum)",
"Accept wiki syntax" => "Tillåt wiki syntax",
"Topics" => "Ämnen",
"Posts per day" => "Inlägg per dag",
"Galleries features" => "Gallerifunktioner",
"Use database to store images" => "Använd databasen för att lagra bilder",
"Use a directory to store images" => "Använd en katalog för att lagra bilder",
"Directory path" => "Katalogens sökväg",
"Library to use for processing images" => "Bibliotek att använda för bildbehandling",
"Uploaded image names must match regex" => "Namn på bilder som skall läggas in måste stämma med reguljärt uttryck",
"Uploaded image names cannot match regex" => "Namn på bilder som skall läggas in får inte stämma med reguljärt uttryck",
"Images per row" => "Bilder per rad",
"Thumbnails size X" => "Indexbildstorlek X",
"Thumbnails size Y" => "Indexbildstorlek Y",
"Set features" => "Sätt funktioner",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Ta bort bilder från systemgalleriet som ej används av Wikin, artiklar eller bloginlägg",
"All galleries" => "Alla gallerier",
"Gallery listing configuration" => "Lista gallerikonfiguration",
"Parent" => "Förälder",
"Image galleries comments settings" => "Kommentarinställningar i bildgallerier",
"General Preferences" => "Allmänna alternativ",
"Date and Time Formats" => "Datum och tidformat",
"Admin Password" => "Admins Lösenord",
"Release Check" => "Leta uppdateringar",
"Reset or upgrade your database" => "Nollställ eller uppgradera din databas",
"Check for updates automatically" => "Leta efter uppdateringar automatiskt",
"Check frequency" => "Intervall",
"TikiWiki will check for updates when you access the main Administration page" => "TikiWiki letar efter uppdateringar när du går in på Adminsidan",
"Check for updates now" => "Leta uppdateringar nu",
"Site Identity" => "Sidans Identitet",
"Browser title" => "Webbläsarens titel",
"Sender email" => "Avsändaradress för e-post",
"Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences" => "Gå till <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Utseende</strong></a> konfigurationen för fler inställningar",
"Home Page" => "Startsida",
"Use group homepages" => "Använd grupphemsidor",
"Custom home" => "Egen startsida",
"Use different URL as home page" => "Ange en egen URL för startsidan",
"Miscellaneous" => "Övriga inställningar",
"Unknown/Other" => "Okänd/Annat",
"Default charset for sending mail" => "Standard teckenuppsättning för att skicka e-post",
"Mail end of line" => "Mail radavslut",
"Logging and Reporting" => "Logging och Rapportering",
"Visible to Admin only" => "Visa bara för Admin",
"Include Smarty notices" => "Inkludera Smarty information",
"Log mail in Tiki logs" => "Logga e-post i Tiki loggar",
"Log SQL" => "Logga SQL",
"Log queries using more than" => "Logga frågor som använder mer än",
"This may impact performance" => "Detta kan påverka prestandan",
"Add HTML comment at start and end of each Smarty template (TPL)" => "Lägg till HTML-kommentar vid början och slutet av varje Smarty template (TPL)",
"CSRF Security" => "CSRF Säkerhet",
"Use these options to protect against cross-site request forgeries (CSRF)" => "Alternativ för skydd mot CSRF-attacker (cross-site request forgeries)",
"Use proxy" => "Använd proxy",
"Tikiwiki.org help" => "Tikiwiki.org hjälp",
"Store session data in database" => "Lagra sessionens data in databasen",
"Contact" => "Kontakt",
"Contact user" => "Kontakta användare",
"Count admin pageviews" => "Räkna administratörens sidvisningar",
"Temporary directory" => "Tillfällig katalog",
"Help System" => "Hjälpsystem",
"Long date format" => "Långt datumformat",
"Short date format" => "Kort datumformat",
"Long time format" => "Långt tidsformat",
"Short time format" => "Kort tidsformat",
"Date and Time Format Help" => "Datum och tidformathjälp",
"Change admin password" => "Ändra administratörens lösenord",
"New password" => "Nytt lösenord",
"Change password" => "Ändra lösenord",
"Use database for translation" => "Använd databasen för översättning",
"Edit or ex/import Languages" => "Redigera eller ex/importera språk",
"Record untranslated" => "Spara oöversatt",
"Enable/disable Tiki features in " => "Aktivera/Inaktivera Tiki-funktioner under ",
", but configure them elsewhere" => ", men konfigurera på funktionens adminsida",
"Look and Feel" => "Utseende",
"Authentication method" => "Autentiseringsmetod",
"Tiki and HTTP Auth" => "Tiki och HTTP Auth",
"Users can register" => "Användare kan registrera sig",
"Use challenge/response authentication" => "Använd challenge/response autentisering",
"User's choice" => "Valfritt",
"Always" => "Alltid",
"Duration" => "Varaktighet",
"Use email as username" => "Använd e-post som användarnamn",
"Minimum length" => "Minsta längd",
"Maximum length" => "Maximal längd",
"Force lowercase" => "Endast små bokstäver",
"Store password as plain text" => "Lagra lösenordet som ren text",
"Admin password" => "Admins lösenord",
"Slideshows theme" => "Bildspelstema",
"Edit CSS" => "Redigera CSS",
"Theme Control" => "Temastyrning",
"Tiki Template Viewing" => "Tiki mallvisning",
"General Layout options" => "Generella layout-inställningar",
"logged as" => "Inloggad som",
"Left column" => "Vänsterkolumn",
"Right column" => "Högerkolumn",
"Email this page" => "Skicka som e-post",
"Custom Site Footer" => "Anpassad sidfot",
"Maximum number of records in listings" => "Maximalt antal rader i listor",
"Use direct pagination links" => "Använd sidbrytningslänkar",
"Warning" => "Varning",
"Left" => "Vänster",
"Right" => "Höger",
"Display menus as folders" => "Visa menyer som mappar",
"Layout per section" => "Layout per sektion",
"Admin layout per section" => "Admin layout per sektion",
"full path to mapfiles" => "fullständig sökväg till kartfiler",
"default mapfile" => "förvald kartfil",
"Wiki Page for Help" => "Wiki-sida för hjälp",
"Wiki Page for Comments" => "Wiki-sida för kommentarer",
"Full path to gdaltindex" => "Fullständig sökväg till gdaltindex",
"Users can opt-out internal messages" => "Användare kan välja bort interna meddelanden",
"Users accept internal messages by default" => "Användare accepterar interna meddelanden som standardval",
"Users can configure modules" => "Användare kan konfigurera moduler",
"Display modules to all groups always" => "Visa alltid alla gruppers moduler",
"Hide anonymous-only modules from registered users" => "Göm moduler som är endast till för anonyma användare från registerade användare",
"Last update" => "Senaste uppdatering",
"Image galleries" => "Bildgallerier",
"Feed for forums" => "Matning till forum",
"Default RDF version" => "Förvald RDF version",
"Specification" => "Specifikation",
"Documentation" => "Dokumentation",
"Editor" => "Redaktör",
"Search stats" => "Sökstatistik",
"in Admin menu" => "i Admin menyn",
"random" => "slumpmässig",
"Refresh rate" => "Uppdateringsfrekvens",
"hits" => "träffar",
"Open external links in new window" => "Öppna externa länkar i ett nytt fönster",
"Dynamic Content System" => "Dynamiskt innehållshantering (CMS)",
"Tables syntax" => "Tabell syntax",
"AutoLinks" => "Autolänkar",
"rows" => "rader",
"Required" => "Nödvändig",
"Parameters" => "Parametrar",
"Quota (Mb)" => "Kvot (Mb)",
"Use database to store userfiles" => "Använd databas för att lagra användarfiler",
"Use a directory to store userfiles" => "Använd en katalog för att lagra användarfiler",
"Allow viewing HTML mails?" => "Tillåt HTML i e-post?",
"Maximum size for each attachment" => "Maximal storlek för varje bilaga",
"Unlimited" => "Obegränsad",
"Home page" => "Startsida",
"Complete" => "Färdigställ",
"Individual cache" => "Individuell cachning",
"Content templates" => "Innehållsmallar",
"Undo" => "Ångra",
"Allow HTML" => "Tillåt HTML",
"Sandbox" => "Sandlåda",
"Dumps" => "Avbilder",
"Remove a tag" => "Radera ett bokmärke",
"Generate dump" => "Generera en avbild",
"Download last dump" => "Läs in senaste avbild",
"Pictures" => "Bilder",
"Remove unused pictures" => "Ta bort oanvända bilder",
"Export" => "Exportera",
"Export Wiki Pages" => "Exportera wiki-sidor",
"Link plural WikiWords to their singular forms" => "Länka wiki-ord 'WikiWords' i plural till deras form i singular",
"Discuss pages on forums" => "Diskutera sidan på forumet",
"Similar" => "Liknande",
"Structures" => "Strukturer",
"Import HTML" => "Importera HTML",
"Page creators are admin of their pages" => "Den som skapar sidor är administratör av dessa",
"MultiPrint" => "Flersidsutskrift",
"Enable watches on comments" => "Aktivera bevakning för kommentarer",
"List pages" => "Sidöversikt",
"Wiki attachments" => "Wikins bilagor",
"Restore defaults" => "Återskapa förval",
"disabled" => "inaktiverad",
"enabled" => "aktiverad",
"Crosslinks to other features and settings" => "Länkar till andra funktioner och inställningar",
"Contact us" => "Kontakta oss",
"Statistics" => "Statistik",
"Weeks" => "Veckor",
"viewed" => "läst",
"Add or edit a rule" => "Skapa eller redigera en regel",
"Rule title" => "Regelns titel",
"Username regex matching" => "Användarnamn regex matchning",
"IP regex matching" => "IP regex matchning",
"Banned from sections" => "Bannlyst från sektioner",
"Rule activated by dates" => "Regler aktiverade av datum",
"Rule active from" => "Regler aktiva från",
"Rule active until" => "Regler aktiva till",
"Custom message to the user" => "Skräddarsytt meddelande till användaren",
"Rules" => "Regler",
"User/IP" => "Användare/IP",
"Sections" => "Kapitel",
"Configure" => "Konfigurera",
"Admin Calendars" => "Admin kalendrar",
"List of Calendars" => "Kalenderlista",
"Participants" => "Deltagare",
"Url" => "URL",
"Add Event" => "Lägg till",
"Custom Locations" => "Skräddarsydda platser",
"Custom Categories" => "Skräddarsydda kategorier",
"Custom Languages" => "Skräddarsydda språk",
"Custom Priorities" => "Skräddarsydda prioriteter",
"Current category" => "Aktuell kategori",
"Child categories" => "Underkategorier",
"Edit this category:" => "Redigera denna kategori:",
"Add new category" => "Skapa ny kategori",
"Objects in category" => "Objekt i kategorin",
"Add objects to category" => "Skapa objekt i kategorin",
"image gal" => "bildgalleri",
"file gal" => "filgalleri",
"Admin chart items" => "Admin diagramposter",
"Add or edit an item" => "Skapa eller redigera ett föremål",
"Update" => "Uppdatera",
"Chart items" => "Diagramposter",
"No items defined yet" => "Inga poster definierade",
"Admin charts" => "Admin diagram",
"Add or edit a chart" => "Skapa eller redigera ett diagram",
"Active" => "Aktiv",
"Users can suggest new items" => "Användare kan föreslå nya poster",
"Auto validate user suggestions" => "Validera användarnas förslag automatiskt",
"Ranking shows" => "Betyg av visningar",
"All items" => "Alla poster",
"Top 10 items" => "Top 10",
"Top 20 items" => "Top 20",
"Top 40 items" => "Top 40",
"Top 50 items" => "Top 50",
"Top 100 items" => "Top 100",
"Top 250 items" => "Top 250",
"Voting system" => "Röstningssystem",
"Vote items" => "Röstposter",
"Rank 1..5" => "Betyg 1..5",
"Rank 1..10" => "Betyg 1..10",
"Ranking frequency" => "Betygsfrekvens",
"Realtime" => "Realtid",
"Each 5 minutes" => "Var 5:e minut",
"Daily" => "Daglig",
"Weekly" => "Veckovis",
"Monthly" => "Månadsvis",
"Show Average" => "Visa medelvärde",
"Show Votes" => "Visa röster",
"Use Cookies for unregistered users" => "Använd cookies (kakor) för oregistrerade användare",
"Users can vote again after" => "Användare kan rösta igen efter",
"Anytime" => "ingen tid",
"Ranks" => "Betyg",
"No charts defined yet" => "Inga diagram har definierats",
"Admin templates" => "Admin mallar",
"Edit this template:" => "Redigera denna mall:",
"Create new template" => "Skapa en ny mall",
"Use wysiwyg editor" => "Använd wysiwyg editor",
"Use normal editor" => "Använd normal editor",
"Templates" => "Mallar",
"Settings" => "Inställningar",
"Admin cookies" => "Admin visdomsord",
"Create/edit cookies" => "Skapa/redigera visdomsord",
"Upload Cookies from textfile" => "Skicka visdomsord från textfil",
"Upload from disk:" => "Skicka från disk:",
"Upload" => "Lägg in",
"Remove all cookies" => "Ta bort alla kakor",
"Admin drawings" => "Admin teckningar",
"Available drawings" => "Tillgängliga teckningar",
"Create/edit dsn" => "Skapa/redigera dsn",
"Admin external wikis" => "Admin externa wiki's",
"Create/Edit External Wiki" => "Skapa/Redigera extern Wiki",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (använd \$page för att ersatta URL exemplet: http://www.example.com/tiki-index.php?page=\$page)",
"Admin Forums" => "Admin Forum",
"Create new forum" => "Skapa nytt forum",
"Duplicate forum" => "Kopiera forum",
"Import forums" => "Importera forum",
"List forums" => "Lista forum",
"Edit this Forum:" => "Redigera detta forum:",
"Create New Forum" => "Skapa nytt forum",
"There are individual permissions set for this forum" => "Det finns individuella rättigheter satta för detta forum",
"Prevent flooding" => "Förhindra massinlägg",
"Minimum time between posts" => "Minimal tid mellan inlägg",
"Section" => "Sektion",
"Create new" => "Skapa ny",
"Moderator user" => "Moderatoranvändare",
"Moderator group" => "Moderatorgrupp",
"Password protected" => "Lösenordskyddad",
"Topics only" => "Enbart ämnen",
"All posts" => "Alla inlägg",
"Forum password" => "Forumets lösenord",
"Only allow replies to the first message (flat forum)" => "Tillåt bara svar till det första meddelandet (platt forum)",
"Send this forums posts to this email" => "Skicka inlägg i detta forum till denna e-postadress",
"Prune unreplied messages after" => "Radera obesvarade meddelanden efter",
"Prune old messages after" => "Radera gamla meddelanden efter",
"Topic list configuration" => "Konfiguration av ämneslista",
"Posts can be rated" => "Inlägg kan betygsättas",
"Display last post titles" => "Visa titlar för de senaste inläggen",
"no display" => "ingen visning",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Vidarebefodra inlägg i detta forum till denna e-postadress, i ett format som kan användas för att skicka tillbaka till detta forums e-postadress",
"Append a reply link to outbound mails" => "Inkludera en svarslänk i utgående e-post",
"Originating e-mail address for mails from this forum" => "Avsändardress för e-post från detta forum",
"Add messages from this email to the forum" => "Vidarebefordra e-post från denna adress till detta forum",
"Use topic smileys" => "Använd smileys för ämnen",
"Show topic summary" => "Visa sammanfattningar",
"User information display" => "Visning av användarinformation",
"Approval type" => "Tillståndstyp",
"All posted" => "Alla inlägg",
"Queue anonymous posts" => "Köa anonyma inlägg",
"Queue all posts" => "Köa alla inlägg",
"No attachments" => "Inga bilagor",
"Everybody can attach" => "Alla kan bifoga bilagor",
"Only users with attach permission" => "Bara användare särskilda rättigheter",
"Moderators and admin can attach" => "Moderatorer och administratörer kan bifoga bilagor",
"Store attachments in:" => "Lagra bilagor i:",
"Database" => "Databas",
"Max attachment size (bytes)" => "Maximal bilagestorlek (bytes)",
"Set topics preferences" => "Inställningar för ämnen(rubriker)",
"Show topics preferences" => "Visa inställningar",
"hide topics preferences" => "Göm inställningar",
"Default ordering for topics" => "Förvald sortering av ämnen",
"Date (desc)" => "Datum (fallande)",
"Date (asc)" => "Datum (stigande)",
"Score (desc)" => "Poäng (fallande)",
"Replies (desc)" => "Svar (fallande)",
"Reads (desc)" => "Lästa (fallande)",
"Topics per page" => "Ämnen per sida",
"Default ordering for threads" => "Förvald sortering av trådar",
"Duplicate Forum" => "Kopiera Forum",
"List Forums" => "Visa Forum",
"Admin Hotwords" => "Admin nyckelord",
"Add Hotword" => "Skapa nyckelord",
"Word" => "Ord",
"Admin HTML pages" => "Admin HTML sidor",
"Edit this page" => "Redigera denna sida",
"View page" => "Visa sida",
"Edit zone" => "Redigera zon",
"Dynamic zones" => "Dynamiska zoner",
"zone" => "zon",
"content" => "innehåll",
"Mass update" => "Massuppdatering",
"Create new HTML page" => "Skapa ny HTML sida",
"Edit this HTML page:" => "Redigera denna HTML sida:",
"Apply template" => "Använd mall",
"Dynamic" => "Dynamisk",
"Static" => "Statisk",
"Edit Repository:" => "Redigera förråd:",
"Create New Repository" => "Skapa nytt förråd",
"Human readable repository name" => "Förrådsnamn läsbart av människor",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Sökväg till förråd (lokalt filsystem: relativ/absolut webb-root, extern: använd 'http://' som prefix)",
"File name of start page" => "Startsidans filnamn",
"Start page" => "Startsida",
"CSS file to load when browse this repository" => "CSS fil att använda när man tittar i detta förråd",
"CSS file" => "CSS fil",
"Is repository visible to users" => "Är förrådet synligt för användare",
"Can files from repository be cached" => "Kan filer från förrådet cachas",
"Cacheable" => "Cachnigsbar",
"Are files from repository can be cached" => "Kan filer från förrådet cachas",
"Clear all cached pages of this repository" => "Töm alla cachade sidor i detta förråd",
"Clear cache" => "Töm cache",
"Seconds count 'till cached page will be expired" => "Antal sekunder tills cachningen av sidan kommer att upphöra",
"Cache expiration" => "Cache upphörande",
"Human readable text description of repository" => "Förrådsbeskrivning (läsbart av människor)",
"Available Repositories" => "Tillgängliga förråd",
"CSS File" => "CSS Fil",
"Edit rules" => "Redigera regler",
"Edit Rules for Repository:" => "Redigera regler för förråd:",
"view/hide copy rules dialog" => "visa/göm kopieringsregler dialog",
"Source repository" => "Källkodsförråd",
"Copy" => "Kopiera",
"According this order rules will be applied ('0' or empty = auto)" => "Enligt denna ordning kommer regler tillämpas ('0' eller tom = auto)",
"Rule order" => "Regelordning",
"Text to search for" => "Text att söka efter",
"Text to replace" => "Text att ersätta",
"Is this regular expression or simple search/replacer" => "Är detta ett regulärt uttryck eller en enkel sök/ersättare",
"Is case sensitive (for simple replacer)" => "Är skiftlägeskänslig (för enkel ersättare)",
"Case sensitive" => "Skiftlägeskänslig",
"subset of chars: imsxeADSXUu, which is regex modifiers" => "delmängd av tecknen: imsxeADSXUu, som är regex modifierare",
"Human readable text description of rule" => "Människoläsbar textuell beskrivning av regeln",
"Check to enable this rule" => "Kryssa i för att aktivera denna regel",
"Enabled" => "Aktiverad",
"Preview options" => "Förhandsgransknings valmöjligheter",
"Apply all rules or just this to generate preview" => "Tillämpa alla regler eller bara denna för att skapa förhandsgranskningen",
"Apply all rules" => "Tillämpa alla regler",
"View source code after rules applied" => "Visa källkoden efter att reglerna har tillämpats",
"Code preview" => "Förhandsgranskning av kod",
"Generate HTML preview" => "Generera förhandsgranskning av HTML",
"HTML preview" => "HTML förhandsgranskning",
"Test file from repository to generate preview for (empty = configured start page)" => "Test fil från lagret för att generera förhandsgranskning för (tom = konfigurerad startsida)",
"Preview Results" => "Förhandsgranskningsresultat",
"Rules List" => "Regellista",
"Case" => "Skiftläge",
"Admin layout" => "Redigera layout",
"Theme control" => "Temastyrning",
"layout options" => "layoutinställningar",
"Generate positions by hits" => "Generera rangordningen utifrån antal besökare",
"List of featured links" => "Lista utvalda länkar",
"Add Featured Link" => "Skapa utvald länk",
"Edit this Featured Link:" => "Redigera denna utvalda länk:",
"Create new Featured Link" => "Skapa ny utvald länk",
"disables the link" => "deaktiverar länken",
"Link type" => "Länk typ",
"replace current page" => "ersätt nuvarande sida",
"framed" => "inramad",
"open new window" => "öppna nytt fönster",
"Account name" => "Kontonamn",
"SMTP requires authentication" => "SMTP kräver autentisering",
"Article Topic" => "Artikelns Rubrik",
"Admin Topics" => "Admin ämnen",
"Article Type" => "Typ av artikel",
"Admin Types" => "Admin Typer",
"Frequency" => "Frekvens",
"List menus" => "Menyöversikt",
"Edit this menu" => "Redigera denna meny",
"Edit menu options" => "Redigera menyn's valmöjligheter",
"Some useful URLs" => "Användbara URL'er",
"option" => "valmöjlighet",
"Home Blog" => "Startblog",
"Home Image Gal" => "Startbildgalleri",
"Home Image Gallery" => "Startbildgalleri",
"Home File Gal" => "Startfilgalleri",
"Home File Gallery" => "Startfilgalleri",
"User preferences" => "Användarinställningar",
"User prefs" => "Användarinställningar",
"List galleries" => "Gallerilista",
"List image galleries" => "Bildgallerilista",
"Upload image" => "Skicka bild",
"Gallery Rankings" => "Galleribetyg",
"Browse a gallery" => "Bläddra i ett galleri",
"Articles home" => "Artikelstartsida",
"All articles" => "Alla artiklar",
"Submit" => "Skicka in",
"List Blogs" => "Bloglista",
"Create blog" => "Skapa blog",
"File galleries" => "Filgallerier",
"View a forum" => "Visa ett forum",
"View a thread" => "Visa en tråd",
"View a FAQ" => "Visa en FAQ",
"Take a quiz" => "Delta i frågesport",
"Quiz stats" => "Frågesportstatistik",
"Stats for a Quiz" => "Statistik for en frågesport",
"Preview menu" => "Förhandsgranska meny",
"Menu options" => "Menyval",
"Edit this Menu:" => "Redigera denna meny:",
"Create new Menu" => "Skapa ny meny",
"dynamic collapsed" => "dynamiskt minimerad",
"dynamic extended" => "dynamisk utvecklad",
"fixed" => "fast",
"User Modules" => "Användarmoduler",
"Assigned Modules" => "Tilldela Moduler",
"Left Modules" => "Vänstermoduler",
"Rows" => "Rader",
"Right Modules" => "Högermoduler",
"Assign new module" => "Tilldela ny modul",
"Edit this assigned module:" => "Redigera denna tilldelade modul:",
"Cache Time" => "Cachens Tidsstämpel",
"Visibility" => "Synlighet",
"Displayed now for all eligible users even with personal assigned modules" => "Visad nu för alla berättigade användare även om de har personliga moduler tilldelade",
"Displayed for the eligible users with no personal assigned modules" => "Visad för berättigade användare med inga personliga moduler tilldelade",
"Displayed now, can't be unassigned" => "Visad nu, tilldelning kan ej tas bort",
"Not displayed until a user chooses it" => "Ej visad innan en användare väljer den",
"Create new user module" => "Skapa ny användarmodul",
"Edit this user module:" => "Redigera denna användarmodul:",
"Objects that can be included" => "Objekt som kan infogas",
"Available polls" => "Tillgängliga omröstningar",
"Random image from" => "Slumpmässig bild från",
"Dynamic content blocks" => "Dynamiska innehållsblock",
"Banner zones" => "Bannerzoner",
"Admin newsletter subscriptions" => "Admin prenumeration av nyhetsbrev",
"Send Newsletters" => "Skicka Nyhetsbrev",
"Add a subscription newsletters" => "Skapa prenumeration på nyhetsbrev",
"Subscriptions" => "Prenumerationer",
"Valid" => "Giltig",
"Admin newsletters" => "Admin nyhetsbrev",
"There are individual permissions set for this newsletter" => "Det finns individuella rättigheter för detta nyhetsbrev",
"Users can subscribe/unsubscribe to this list" => "Användare kan anmäla/avanmäla prenumeration av detta nyhetsbrev",
"Users can subscribe any email address" => "Användare kan prenumerera med vilken e-postadress som helst",
"Add unsubscribe instructions to each newsletter" => "Lägg till instruktioner för att avboka prenumerationen till varje nyhetsbrev",
"Validate email addresses" => "Validera mejadresser",
"Mail notifications" => "Besked via e-post",
"Add notification" => "Lägg till händelse",
"Event" => "Händelse",
"A user registers" => "En användare registrerar sig",
"A user submits an article" => "En användare bidrar med en artikel",
"Any wiki page is changed" => "Någon wiki-sida har ändrats",
"Email:" => "E-post:",
"User / Group" => "Användare / Grupp",
"List polls" => "omröstningslistor",
"Edit this poll" => "Redigera omröstningar",
"Preview poll" => "Visa omröstningar",
"Option" => "Val",
"Poll options" => "Val för omröstningar",
"Votes" => "Röster",
"Admin Polls" => "Admin omröstningar",
"Set last poll as current" => "Sätt senaste omröstning som nuvarande",
"Close all polls but last" => "Avsluta alla omröstningar utom den sista",
"Activate all polls" => "Aktivera alla omröstningar",
"active" => "aktiv",
"current" => "aktuell",
"template" => "mall",
"object" => "objekt",
"PublishDate" => "PubliceringsDatum",
"Results" => "Resultat",
"Admin Quicktags" => "Admin Snabbflikar",
"Create/Edit QuickTags" => "Skapa/Redigera Snabbflikar",
"Insert (use 'text' for figuring the selection)" => "Infoga (använd 'text' för att numrera valet)",
"Path to the tag icon" => "Sökväg till flikens ikon",
"Content for the feed" => "Innehåll för matningen",
"show feed title" => "Visa matningens titel",
"show publish date" => "visa publiceringsdatum",
"user" => "användare",
"group" => "grupp",
"sticky" => "klistrig",
"Destroy the structure leaving the wiki pages" => "Förstör strukturen men spara wiki sidorna",
"Destroy the structure and remove the pages" => "Förstör strukturen och ta bort wiki sidor",
"Export Pages" => "Exportera Sidor",
"Create WebHelp" => "Skapa WebbHjälp",
"Create new structure" => "Skapa en ny struktur",
"Use single spaces to indent structure levels" => "Använd enkla mellanslag för att dra in strukturnivåer",
"List surveys" => "Undersökningslista",
"Question" => "Fråga",
"One choice" => "Envalsfråga",
"Multiple choices" => "Flervalsfråga",
"Short text" => "Kort text",
"Rate (1..5)" => "Betyg (1..5)",
"Rate (1..10)" => "Betyg (1..10)",
"Rate" => "Betyg",
"Options (if apply)" => "Valmöjligheter (om möjligt)",
"Questions" => "Frågor",
"Admin surveys" => "Admin undersökningar",
"List Surveys" => "Undersökningslista",
"Edit this Survey:" => "Redigera denna undersökning:",
"There are individual permissions set for this survey" => "Det finns individuella rättigheter för denna undersökning",
"Exterminator of cached content" => "Rensa cachat innehåll",
"Create a new topic" => "Skapa ett nytt ämne",
"Topic Name" => "Ämnets namn",
"Upload Image" => "Skicka bild",
"List of topics" => "Ämneslista",
"Articles (subs)" => "Artiklar (ämnen)",
"topic image" => "ämnesbild",
"Deactivate" => "Deaktivera",
"List Trackers" => "Ärendeföljarlista",
"Is column visible when listing tracker items?" => "Är kolumnen synlig när man listar ärendeföljarposter",
"Column links to edit/view item?" => "Kolumnlänkar till redigera/visa post?",
"Tracker fields" => "Ärendeföljarfält",
"Found" => "Hittade",
"trackers" => "ärendeföljare",
"There are individual permissions set for this tracker" => "Det finns individuella rättigheter för denna ärendeföljare",
"Show creation date when listing tracker items?" => "Visa skapelsedatum vid listning av ärendeföljarposter?",
"Show lastModif date when listing tracker items?" => "Visa senast ändrade datum vid listning av ärendeföljarposter?",
"Tracker items allow comments?" => "Ärendeföljarposter tillåter kommentarter?",
"Tracker items allow attachments?" => "Ärendeföljarposter tillåter bilagor?",
"Filesize" => "Filstorlek",
"Admin groups" => "Admin grupper",
"Admin users" => "Admin användare",
"Add new group" => "Skapa ny grupp",
"List of existing groups" => "Lista över existerande grupper",
"Includes" => "Infogas",
"Rejected users" => "Avvisade användare",
"Reason" => "Anledning",
"to groups" => "till grupper",
"Overwrite" => "Skriv över",
"Source" => "Visa kod",
"Admin Article Types" => "Admin Artikeltyper",
"List of types" => "List på typer",
"Show before publish date" => "Visa före publiceringsdatum",
"Show after expire date" => "Visa efter upphörandedatum",
"Heading only" => "Endast rubrik",
"Comment Can Rate Article" => "Kommentarer kan betygsätta artiklar",
"Show image" => "Visa bild",
"Show avatar" => "Visa avatar",
"Show author" => "Visa författare",
"Show publish date" => "Visa publiceringsdatum",
"Show expire date" => "Visa upphörandedatum",
"Show reads" => "Visa läsningar",
"Show size" => "Visa storlek",
"Creator can edit" => "Skapare kan redigera",
"Review" => "Granska",
"Create a new type" => "Skapa en ny typ",
"Group Information" => "Gruppinformation",
"level" => "nivå",
"Create level" => "Skapa nivå",
"all permissions in level" => "alla rättigheter på nivå",
"Default Group" => "Förvald grupp",
"backlinks to" => "referenser från",
"No backlinks to this page" => "Inga referenser till denna sida",
"Edit Post" => "Redigera inlägg",
"Use ...page... to separate pages in a multi-page post" => "Använd ...page... som separator för inlägg med flera sidor",
"Upload image for this post" => "Skicka in bilden för detta inlägg",
"Trash" => "Släng",
"Spellcheck" => "Stavningskontroll",
"Execution time" => "Exekveringstid",
"Memory usage" => "Minnesanvändning",
"Server load" => "Serverlast",
"Upper level" => "Övre nivå",
"Sort Images by" => "Sorter bilder efter",
"rotate right" => "vrid till höger",
"rotate" => "rotera",
"Edit Image" => "Redigera bild",
"Popup window" => "Popup fönster",
"Image Name" => "Bildnamn",
"Move image" => "Flyta bilden",
"You can view this image in your browser using" => "Du kan se denna bild i din webbläsare med",
"Group Calendars" => "Gruppera kalendrar",
"Organized by" => "Organiserad per",
"Tentative" => "Preliminär",
"Confirmed" => "Konfirmerad",
"Cancelled" => "Inställt",
"Edit Calendar Item" => "Redigera kalederpost",
"times" => "gånger",
"End" => "Slut",
"Roles" => "Roller",
"import" => "importera",
"Previous" => "Föregående",
"Perform action with checked" => "Utför med markerade",
"Assign permissions" => "Tilldela rättigheter",
"to group" => "till grupp",
"Change password enforced" => "Lösenordsändring krävs",
"Change your password" => "ändra lösenordet",
"Old password" => "Gammalt lösenord",
"Send a message to us" => "Skicka oss ett meddelande",
"Contact us by email" => "Kontakta oss via e-post",
"Contacts" => "Kontakter",
"Create/edit contacts" => "Skapa/redigera kontakt",
"First Name" => "Förnamn",
"Last Name" => "Efternamn",
"Nickname" => "Smeknamn",
"You can browse the generated WebHelp here" => "Du kan bläddra i den genererade WebbHjälpen här",
"Structure" => "Struktur",
"Top page" => "Huvudsida",
"Tiki Debugger Console" => "Tiki Debuggerkonsol",
"Current URL" => "Nuvarande URL",
"Command" => "Kommando",
"exec" => "exekvera",
"Type <code>help</code> to get list of available commands" => "Skriv <code>help</code> för att få en lista med tillgängliga kommandon",
"Add a new site" => "Skapa en ny sajt",
"Site added" => "Sajt inlagd",
"Directory Administration" => "Webbkatatlog Administration",
"There are" => "Det finns",
"invalid sites" => "ogiltiga sajter",
"valid sites" => "giltiga sajter",
"Users have visited" => "Användare har besökt",
"sites from the directory" => "sajter från webbkatalogen",
"Users have searched" => "Användare har sökt",
"times from the directory" => "gånger från webbkatalogen",
"Admin directory categories" => "Admin webbkatalogkategorier",
"Add a directory category" => "Skapa en webbkatalogkategori",
"Edit this directory category" => "Redigera denna webbkatalogkategori",
"Children type" => "Barntyp",
"Most visited sub-categories" => "Mest besökta underkategorier",
"Category description" => "Kategoribeskrivning",
"Random sub-categories" => "Slumpmässiga underkategorier",
"Maximum number of children to show" => "Maximalt antal barn att visa",
"Editor group" => "Redigera grupp",
"allow" => "tillåt",
"count" => "st",
"editor" => "redaktör",
"relate" => "relatera",
"Parent category" => "Faderkategori",
"Add a related category" => "Skapa en besläktad kategori",
"Mutual" => "Ömsesidig",
"Related categories" => "Relaterade kategorier",
"Admin sites" => "Admin sajter",
"Is valid" => "Är giltig",
"any" => "valfri",
"in entire directory" => "i hela katalogen",
"Sort by" => "Sortera efter",
"name (desc)" => "namn",
"name (asc)" => "name (omvänd)",
"hits (desc)" => "träffar",
"hits (asc)" => "träffar (omvänd)",
"creation date (desc)" => "skapelsedatum",
"creation date (asc)" => "skapelsedatum (omvänd)",
"last updated (desc)" => "senast ändrad",
"last updated (asc)" => "senast ändrad (omvänd)",
"Added" => "Tillagd",
"Last updated" => "Senast uppdaterad",
"Total links" => "Totalt antal länkar",
"Links to validate" => "Länkar att validera",
"Searches performed" => "Genomförda sökningar",
"Total links visited" => "Totalt besökta länkar",
"Directory ranking" => "Webbkatalogrankning",
"Search results" => "Sökresultat",
"Validate sites" => "Validera sajter",
"Edit article" => "Redigera artikel",
"List Articles" => "Artikellista",
"Author Name" => "Förafattarens Namn",
"Own Image" => "Egen bild",
"Article image" => "Artikelbild image",
"Use own image" => "Använd egen bild",
"Float text around image" => "Låt text flyta runt bilden",
"Own image size x" => "X-storlek på egen bild",
"Own image size y" => "Y-storlek på egen bild",
"Heading" => "Rubrik",
"Body" => "Brödtext",
"Publish Date" => "Publiceringsdatum",
"Expiration Date" => "Förfallodatum",
"From:" => "Från:",
"Edit or create banners" => "Redigera eller skapa banners",
"List banners" => "Lista banners",
"URL to link the banner" => "URL som länkar till bannern",
"Client" => "Kunder",
"Max impressions" => "Max visningar av bannern",
"Show the banner only between these dates" => "Visa endast bannern mellan dessa datum",
"From date" => "Från datum",
"To date" => "Till datum",
"Use dates" => "Använd datum",
"Show the banner only in this hours" => "Visa endast bannern vid dessa tidpunkter",
"to" => "till",
"Show the banner only on" => "Visa bannern endast på",
"Mon" => "Mån",
"Tue" => "Tis",
"Wed" => "Ons",
"Thu" => "Tor",
"Fri" => "Fre",
"Sat" => "Lör",
"Sun" => "Sön",
"Select ONE method for the banner" => "Välj EN metod för bannern",
"Use HTML" => "Använd HTML",
"Use image" => "Använd bild",
"Image:" => "Bild:",
"Current Image" => "Nuvarande bild",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Använd bild från en URL (bilden kommer att hämtas från URL'en för varje visning)",
"Use text" => "Använd text",
"Remove Zones (you lose entered info for the banner)" => "Ta bort zoner (du mister inmatad information om bannern)",
"Current heading" => "Nuvarande rubrik",
"There are individual permissions set for this blog" => "Det finns individuella rättigheter för denna blog",
"Number of posts to show" => "Antal inlägg som skall visas",
"Allow other user to post in this blog" => "Tillåt andra användare att göra inlägg i denna blog",
"Use titles in blog posts" => "Visa titlar i bloginlägg",
"Allow search" => "Tillåt sökning",
"Allow comments" => "Tillåt kommentarer",
"Blog heading" => "Blogrubrik",
"Edit Style Sheet" => "Redigera stilmall",
"Style Sheet" => "Stilmall",
"choose a stylesheet" => "välj en stilmall",
"Colored text" => "Färgad text",
"Box content" => "Lådans innehåll",
"Dynamic variables" => "Dynamiska variabler",
"Inserts an editable variable" => "Infoga en redigerbar variabel",
"External links" => "Externa länkar",
"Wiki References" => "Wikins Referenser",
"JoinCapitalizedWords or use" => "SammanSattaOrdMedVersaler eller använd",
"for wiki references" => "som wiki-referenser",
"SomeName" => "NågotNamn",
"prevents referencing" => "förhindrar refererande",
"Lists" => "Listor",
"for bullet lists" => "ger onumrerad lista",
"for numbered lists" => "ger numrerad lista",
"for definiton lists" => "ger definitionsbeskrivning",
"Tables" => "Tabeller",
"Title bar" => "Titelhuvud",
"creates the editable drawing foo" => "skapar den redigerbara teckningen foo",
"Multi-page pages" => "Sidor med sidbrytningar",
"Non parsed sections" => "Icke tolkade sektioner",
"Preformated sections" => "Förformatterade sektioner",
"No description available" => "Beskrivning otillgänglig",
"text, bold" => "Fetstil",
"text, italic" => "kursiv",
"text, underline" => "understruken",
"table" => "tabell",
"table new" => "skapa tabell",
"external link" => "externa länkar",
"wiki link'" => "wikilänk'",
"heading1" => "överskrift1",
"title bar" => "titelhuvud",
"box" => "låda",
"rss feed" => "rss matning",
"dynamic content" => "dynamiskt innehåll",
"tagline" => "citat",
"horizontal rule" => "horisontell linje",
"center text" => "centrera text",
"colored text" => "färgad text",
"dynamic variable" => "dynamisk variabel",
"quote" => "citat",
"Add Image from File Gallery" => "Lägg till bild från galleriet",
"special chars" => "specialtecken",
"special characters" => "specialtecken",
"Leave Fullscreen Edit" => "Återställ Textredigeraren",
"Fullscreen Edit" => "Maximera Textredigeraren",
"Browse Images" => "Visa Bilder",
"Edit successful!" => "Redigeringen lyckades!",
"The following image was successfully edited" => "Redigering av följandebild lyckades",
"Image Description" => "Bildbeskrivning",
"Edit and create Languages" => "Redigera och skapa Språk",
"Edit and create languages" => "Redigera och skapa språk",
"Create Language" => "Skapa Språk",
"Shortname" => "Kortnamn",
"like" => "som",
"Longname" => "Fullständigt namn",
"Select the language to edit" => "Välj språk för redigering",
"Add a translation" => "Skapa en översättning",
"Edit translations" => "Redigera översättningar",
"Translate recorded" => "Översättning sparad",
"Translation" => "Översättning",
"reset table" => "töm tabell",
"Return to block listing" => "Återvänd till blocklistning",
"Block description: " => "Blockbeskrivning: ",
"You are editing block:" => "Du redigerar block:",
"Publishing date" => "Publiceringsdatum",
"Publishing Date" => "Publiceringsdatum",
"Edit question options" => "Redigera frågors valmöjligheter",
"List Quizzes" => "Frågesportslista",
"Quiz Stats" => "Frågesports statistik",
"Create/edit options for question" => "Skapa/redigera val för frågor",
"Create/edit quizzes" => "Skapa/redigera frågesporter",
"There are individual permissions set for this quiz" => "Det finns individuella åtkomsträttigheter för denna frågesport",
"Quiz can be repeated" => "Frågesport kan göras igen",
"Store quiz results" => "Spara resultat för frågesporten",
"Questions per page" => "Frågor per sida",
"Quiz is time limited" => "Frågesporten är tidsbegränsad",
"Maximum time" => "Maximal tid",
"Quiz" => "Frågesport",
"canRepeat" => "kanGörasOm",
"timeLimit" => "tidsGräns",
"Edit quiz questions" => "Redigera frågesportsfrågor",
"Create/edit questions for quiz" => "Skapa/redigera frågor för en frågesport",
"maxScore" => "maxPoäng",
"From Points" => "Från poäng",
"To Points" => "Till Poäng",
"Answer" => "Svar",
"Modify Structure" => "Modifiera struktur",
"You will remove" => "Du kommer ta bort",
"and its subpages from the structure, now you have two options:" => "och dess ägda sidor från strukturen, har du två val:",
"Remove only from structure" => "Ta endast bort från strukturen",
"Remove from structure and remove page too" => "Ta både bort från strukturen och sidan",
"Structure Layout" => "Strukturlayout",
"Page alias" => "Sidalias",
"After page" => "Efter sida",
"Use pre-existing page" => "Använd en redan existerade sida",
"Submit article" => "Skicka artikel",
"Edit templates" => "Redigera mallar",
"Template listing" => "Malllista",
"Available templates" => "Tillgängligga mallar",
"Edit a topic" => "Redigera ett ämne",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Sandlådan är en sida där du kan öva din skicklighet i att redigera, använd förhandsgranskning för att se sidans slutresultat, inga versioner av denna sida sparas.",
"This edit session will expire in {\$edittimeout} minutes" => "Den här redigeringssidan kan användas i {\$edittimeout} minuter",
"votes" => "röster",
"My Footnotes" => "Fotnoter",
"Edit Comment" => "Kommentar",
"Monitor this page" => "Meddela mig om sidan uppdateras",
"Year:" => "År:",
"Authors:" => "Författare:",
"Try to convert HTML to wiki" => "försök att konvertera HTML till wiki",
"Import page" => "Importera sida",
"export all versions" => "exportera alla versioner",
"Upload picture" => "Lägg in bild",
"Add another image" => "Lägg till en till bild",
"License" => "Licens",
"Important" => "Viktigt",
"Lock this page" => "Lås sidan",
"lastModif" => "senastÄndrad",
"List FAQs" => "FAQ Listning",
"View FAQ" => "Visa FAQ",
"Edit this FAQ" => "Redigera denna FAQ",
"Use a question from another FAQ" => "Använd en fråga från en annan FAQ",
"FAQ questions" => "FAQ frågor",
"Suggested questions" => "Föreslagna frågor",
"No suggested questions" => "Inga föreslagna frågor",
"Upload File" => "Skicka Fil",
"View tpl" => "Visa tpl",
"You can access the file gallery using the following URL" => "Du kan få tillgång till detta filgalleri med följande URL",
"Admin forums" => "Admin forum",
"Edit queued message" => "Redigera köat meddelande",
"make this a thread of" => "gör detta en tråd till",
"None, this is a thread message" => "Inget, detta är ett trådat meddelande",
"summary" => "sammanfattning",
"announce" => "kungörelse",
"hot" => "het",
"no feeling" => "utan känslor",
"frown" => "ogilla",
"exclaim" => "utrop",
"idea" => "idé",
"mad" => "arg",
"question" => "fråga",
"sad" => "ledsen",
"happy" => "glad",
"wink" => "blink",
"convert to topic" => "omvandla till ämne",
"List of messages" => "Lista av meddelande",
"no summary" => "ingen sammanfattning",
"No messages queued yet" => "Inga meddelande i kö ännu",
"Last Post" => "Senaste inlägget",
"Configure Forum" => "Konfigurera Forumen",
"Reported messages for forum" => "Rapporterade inlägg från forumet",
"Reported by" => "Rapporterat av",
"No records to display" => "Det finns ingenting att visa",
"Accept" => "Accepterad",
"Activity completed" => "Aktivitet avslutad",
"Admin process activities" => "Admin process aktiviteter",
"Add or edit an activity" => "Skapa eller redigera en aktivitet",
"activity" => "aktivitet",
"split" => "dela",
"join" => "sammanfoga",
"standalone" => "ensamstående",
"interactive" => "interaktiv",
"auto routed" => "auto dirigerad",
"Hours" => "Timmar",
"Add transitions" => "SKapa transitioner",
"Add transition from:" => "Skapa transition från:",
"Add transition to:" => "Skapa transition till:",
"No roles associated to this activity" => "Inga roller associerade med denna aktivitet",
"Process activities" => "Process aktiviteter",
"Routing" => "Dirigering",
"Interactive" => "Interaktiv",
"Automatic" => "Automatisk",
"Auto routed" => "Auto dirigerad",
"route" => "rutt",
"(no roles)" => "(inga roller)",
"No activities defined yet" => "Inga aktiviteter definierade",
"Process Transitions" => "Process Transitioner",
"List of transitions" => "Lista av transitioner",
"Origin" => "Källa",
"No transitions defined yet" => "Inga transitioner definierade",
"Add a transition" => "Skapa en transition",
"This process is invalid" => "Denna process är felaktig",
"List of processes" => "Processlista",
"Inactive" => "Inaktiv",
"act" => "aktivitet",
"val" => "giltig",
"Activities" => "Aktiviteter",
"No processes defined yet" => "Inga processer ännu definierade",
"Admin instance" => "Admin instans",
"Instance" => "Instans",
"Workitems" => "Arbetsmoment",
"exception" => "undantag",
"completed" => "färdig",
"Owner" => "Ägare",
"Send all to" => "Skicka till alla",
"Don't move" => "Flytta ej",
"Started" => "Startade",
"Act status" => "Aktivitetsstatus",
"Property" => "Egenskap",
"Add property" => "Skapa egenskap",
"run instance" => "utför instans",
"Admin processes" => "Admin processer",
"Galaxia Admin Processes" => "Galaxia admin. processer",
"Galaxia Admin Processes tpl" => "Galaxia admin. processer tpl",
"Add or edit a process" => "Skapa eller redigera process",
"Process Name" => "Processnamn",
"is active?" => "är aktiv?",
"Or upload a process using this form" => "Eller infoga en process med detta formulär",
"Admin process roles" => "Admin processroller",
"Add or edit a role" => "Skapa eller redigera en roll",
"Process roles" => "Processa roller",
"No roles defined yet" => "Inga roller ännu definierade",
"Map users to roles" => "Bind användare till roller",
"map" => "bind",
"Map groups to roles" => "Bind grupper till roller",
"No roles are defined yet so no roles can be mapped" => "Inga roller har ännu definierats, så inga roller kan bindas",
"List of mappings" => "Lista på bindningar",
"No mappings defined yet" => "Inga bindningar ännu definierade",
"Admin process sources" => "Admin processkällkod",
"select source" => "välj källkod",
"Shared code" => "Delad kod",
"Set next user" => "Tilldela nästa användare",
"Get property" => "Hämta geneskap",
"Set property" => "Tilldela egenskap",
"Process form" => "Processformulär",
"Set Next act" => "Aktivera nästa",
"Switch construct" => "Växelkonstruktion",
"Map process roles" => "Bind processroller",
"Galaxia Monitor Activities" => "Galaxia aktivitetsbevakning",
"Galaxia Monitor Activities tpl" => "Galaxia aktivitetsbevakning tpl",
"List of activities" => "Aktivitetslista",
"routing" => "dirigering",
"Instances" => "Instanser",
"run" => "utför",
"run activity" => "utför aktivitet",
"Monitor" => "Bevaka",
"monitor processes" => "övervaka processer",
"monitor activities" => "övervaka aktiviteter",
"monitor instances" => "övervaka instanser",
"monitor workitems" => "övervaka arbetsmoment",
"Galaxia Monitor Instances" => "Galaxia instansbevakning",
"Galaxia Monitor Instances tpl" => "Galaxia instansbevakning tpl",
"List of instances" => "Instanslista",
"No instances created yet" => "Inga instanser ännu skapade",
"Galaxia Monitor Processes" => "Galaxia processbevakning",
"Galaxia Monitor Processes tpl" => "Galaxia processbevakning tpl",
"processes" => "processer",
"being run" => "utförs",
"Completed" => "Färdig",
"Monitor workitems" => "Övervaka arbetsmoment",
"List of workitems" => "Arbetsmomentslista",
"instance" => "instans",
"exception instance" => "undantagsinstans",
"exceptions instance" => "undantagsinstans",
"abort instance" => "avbryt instans",
"grab instance" => "fånga instans",
"release instance" => "släpp instans",
"User Activities" => "Användaraktiviteter",
"Galaxia User Activities" => "Galaxia användaraktiviteter",
"Galaxia User Activities tpl" => "Galaxia User användaraktiviteter tpl",
"user processes" => "användarprocesser",
"user activities" => "användaraktiviteter",
"user instances" => "användarinstanser",
"Galaxia User Instances" => "Galaxia användarinstanser",
"Galaxia User Instances tpl" => "Galaxia användarinstanser tpl",
"Inst Status" => "Instansstatus",
"No instances defined yet" => "Instans ännu ej definierad",
"Galaxia User Processes" => "Galaxia användarprocesser",
"Galaxia User Processes tpl" => "Galaxia användarprocesser tpl",
"Browsing Workitem" => "Visar arbetsmoment",
"Workitem information" => "arbetsmomentsinformation",
"Galleries" => "Gallerier",
"Create a gallery" => "Skapa ett galleri",
"Edit this gallery:" => "Redigera detta galleri:",
"There are individual permissions set for this gallery" => "Detta galleri har individuella rättigheter",
"Available scales" => "Tillgängliga skalor",
"No scales available" => "Inga skalor tillgängliga",
"Other users can upload images to this gallery" => "Andra användare kan lägga till bilder i detta galleri",
"You can access the gallery using the following URL" => "Du kan få tillgång till galleriet med följande URL",
"Available Galleries" => "Tillgängliga gallerier",
"Imgs" => "Bilder",
"Im- Export languages" => "Im/Exportera språk",
"Select the language to Import" => "Välj ett språk att importera",
"Select the language to Export" => "Välj ett språk att  exportera",
"Overwrite existing pages if the name is the same" => "Skriv över existerande sidor om namnet är det samma",
"Previously remove existing page versions" => "Ta bort existerande versioner av sidan",
"excerpt" => "utdrag",
"Result" => "Resultat",
"Clear cached version and refresh cache" => "Radera den cachede version och uppdatera cachen",
"configure rules" => "konfigureringsregler",
"Last Changes" => "Senaste ändringar",
"Last 2 days" => "Senaste 2 dagarna",
"Last 3 days" => "Senaste 3 dagarna",
"Last 5 days" => "Senaste 5 dagarna",
"Last week" => "Senaste veckan",
"Last 2 weeks" => "Senaste två veckorna",
"Last month" => "Senaste månaden",
"LastChanges" => "SenasteÄndringar",
"Pages like" => "Liknande sidor",
"No pages found" => "Inga hittade sidor",
"Edit New Article" => "Skapa ny artikel",
"ExpireDate" => "Slutdatum",
"AuthorName" => "FörfattarNamn",
"Create banner" => "Skapa banner",
"Method" => "Metod",
"Use Dates?" => "Använd datum?",
"Max Impressions" => "Max antal visningar",
"Impressions" => "Visningar",
"Clicks" => "Klick",
"Use cache for external pages" => "Använd cache till externa sidor",
"Dynamic content system" => "Dynamisk innehållshantering (CMS)",
"Available content blocks" => "Tillgängliga innehållsblock",
"Current ver" => "Aktuell version",
"Next ver" => "Nästa version",
"Edit this FAQ:" => "Redigera denna FAQ:",
"Create new FAQ" => "Skapa ny FAQ",
"Create New FAQ:" => "Skapa ny FAQ:",
"Users can suggest questions" => "Användare kan föreslå frågor",
"Available FAQs" => "Tillgängliga FAQ'er",
"Gallery Images" => "Galleribilder",
"All games are from" => "Alla spel är från",
"visit the site for more games and fun" => "besök sajten för att få tillgång till fler spel och mer underhållning",
"Upload a game" => "Lägg in ett spel",
"Upload a new game" => "Lägg in ett nytt spel",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Indexbild (om spelet heter fil.swf måste bilden heta fil.swf.gif eller fil.swf.png eller fil.swf.jpg)",
"Edit game" => "Redigera spel",
"Played" => "Spelat",
"If you can't see the game then you need a flash plugin for your browser" => "Om du inte kan se spelet, saknar du en flash-insticksmodul till din webbläsare",
"Edit Blog" => "Redigera blog",
"Blog Title" => "Blogtitel",
"Survey stats" => "Undersökningsstatistik",
"List Movies" => "Filmlista",
"Choose a movie" => "Välj en film",
"Last mod" => "Senaste ändringar",
"Last modification" => "Senast ändrad",
"Last author" => "Senaste författare",
"Last version" => "Senaste version",
"unlocked" => "olåst",
"Open client window" => "Öppna klientfönster",
"Generate HTML" => "Generera HTML",
"Transcripts" => "Avskrifter",
"Online operators" => "Tillgängliga operatörer",
"Operator" => "Operatör",
"Accepted requests" => "Accepterade önskemål",
"since" => "sedan",
"transcripts" => "avskrifter",
"Offline operators" => "Otillgängliga operatörer",
"Add an operator to the system" => "Skapa en operatör i systemet",
"Operators must be tiki users" => "Operatörer måste vara tiki-användare",
"Chat started" => "Chat startad",
"Operator:" => "Operatör:",
"Live support:User window" => "Direktsupport:Användarfönster",
"Request live support" => "Begär direktsupport",
"Request support" => "Begär support",
"Open a support ticket instead" => "Öppna en supportbiljett istället",
"Your request is being processed" => "Din begäran är under behandling",
"cancel request and exit" => "avbryt begäran och avsluta",
"cancel request and leave a message" => "avbryt begäran och lämna ett meddelande",
"Live support:Console" => "Direktsupport:Konsol",
"be online" => "var tillgänglig",
"be offline" => "var otillgänglig",
"Support requests" => "Support förfrågningar",
"Requested" => "Begärd",
"Join" => "Sammanfoga",
"Support chat transcripts" => "Stöd chatavskrifter",
"started" => "startade",
"reason" => "anledning",
"msgs" => "meddelande",
"Transcript" => "Avskrift",
"Prefs" => "Inställningar",
"Remove old events" => "Avlägsna gamla händelser",
"duration" => "varaktighet",
"Mini Calendar: Preferences" => "Minikalender: Inställningar",
"Calendar Interval in daily view" => "Kalenderintervall i daglig vy",
"Start hour for days" => "Timme då dagen startar",
"End hour for days" => "Timme då dagen slutar",
"Reminders" => "Påminnelser",
"no reminders" => "Inga påminnelser",
"Or enter path or URL" => "Eller mata in sökväg eller URL",
"User Pages" => "Användarsidor",
"User Galleries" => "Användarnas gallerier",
"My Articles" => "Mina artiklar",
"Unread Messages" => "Olästa meddelanden",
"Tasks" => "Uppgifter",
"User Blogs" => "Användarbloggar",
"MyTiki" => "Min Tiki",
"My Infos" => "Min Information",
"Notepad" => "Anteckningsblock",
"MyFiles" => "Mina Filer",
"My Contacts" => "Mina Kontakter",
"My Wiki Pages" => "Mina Wikisidor",
"Assigned items" => "Tilldelade saker",
"Sent editions" => "Skicka utgåva",
"The newsletter was sent to {\$sent} email addresses" => "Nyhetsbrevet skickades till {\$sent} e-postadresser",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Tack för din prenumeration. du kommer att få ett bekräftelsebrev till din e-postadress. Inget nyhetsbrev kommer att skickas till dig innan du har bekräftat prenumerationen.",
"Your email address was removed from the list of subscriptors." => "Din e-postadress har tagits bort från listan med prenumeranter.",
"Subscription confirmed!" => "Prenumerationen bekräftad!",
"Select news group" => "Välj en nyhetsgrupp",
"Back to servers" => "Åter till servrar",
"Msgs" => "Medelanden",
"Back to groups" => "Åter till grupper",
"Save position" => "Spara position",
"Reading article from" => "Läser artikel från",
"Back to list of articles" => "Åter till artikellista",
"Newsgroup" => "Nyhetsgrupp",
"Configure news servers" => "Konfigurera nyhetsservrar",
"Configure Newsreader" => "Konfigurera nyhetsläsaren",
"configure newsreader server tpl" => "konfigurera nyhetsläsarservern tpl",
"Select a news server to browse" => "Välj en nyhetsserver att bläddra",
"Add a news server" => "Lägg till news server",
"Edit news server" => "Redigera news server",
"News server" => "Nyhetsserver",
"Notes" => "Anteckningar",
"Write a note" => "Skriv en anteckning",
"quota" => "kvot",
"No notes yet" => "Inga noteringar ännu",
"Reading note:" => "Läser anteckning:",
"List notes" => "Lista anteckningar",
"Write note" => "Skriv anteckningar",
"Assign permissions to " => "Tilldela rättigheter till ",
"Current permissions for this object" => "Nuvarande åtkomsträttigheter för detta objekt",
"Assign permissions to this object" => "Tilldela åtkomsträttigheter till detta objekt",
"Published" => "Publicerad",
"Orphan Pages" => "Orefererade sidor",
"Browser not supported" => "Webbläsaren stöds ej",
"Rename" => "Döp om",
"Attach File" => "Bifoga fil",
"1 File Attached" => "1 Fil har bifogats",
"{\$atts|@count} files attached" => "{\$atts|@count} filer bifogade",
"Pick your avatar" => "Välj din Avatar",
"User Preferences" => "Användarinställningar",
"Your current avatar" => "Din nuvarande Avatar",
"reset" => "nollställ",
"Pick avatar from the library" => "Välj en avatar från biblioteket",
"Pick user Avatar" => "Välj användarens Avatar",
"Hide all" => "Göm allt",
"Show all" => "Visa allt",
"Avatar Image" => "Avatarbild",
"Upload your own avatar" => "Lägg in din egen Avatar",
"Insert" => "Infoga",
"Average" => "Genomsnitt",
"View Results" => "Visa resultat",
"Vote poll" => "Omröstning",
"Other Polls" => "Andra omröstningar",
"on:" => "den:",
"Topic image" => "Ämnesbild",
"Viewing blog post" => "Visa bloginlägg",
"Return to blog" => "Återvänd till bloggen",
"The original document is available at" => "Orginaldokumentet finns tillgängligt på",
"Print multiple pages" => "Skriv ut flera sidor",
"Name:" => "Namn:",
"Quiz result stats" => "Statistik på frågesportsresultat",
"Time" => "Tid",
"User answers" => "Användarsvar",
"Stats for quizzes" => "Frågesportsstatistik",
"taken" => "besvarad",
"Av score" => "Medelpoäng",
"Av time" => "Medeltid",
"Stats for this quiz Questions " => "Statistik för frågor i denna frågesport ",
"Send a link" => "Skicka en länk",
"Received articles" => "Mottagna artiklar",
"Edit received article" => "Redigera mottagen artikel",
"Use Image" => "Använd bild",
"Image x size" => "Bildens x storlek",
"Image y size" => "Bildens y storlek",
"Image name" => "Bildnamn",
"Accept Article" => "Godkänn artikel",
"Site" => "Sajt",
"Received Pages" => "Mottagna sidor",
"Referer stats" => "Hänvisningsstatistik",
"Tiki site registered" => "Tiki sajt registrerad",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Följande sajt har lagts till och validering av administratör kan behövas innan den dyker upp på listorna",
"Register this site at tikiwiki.org" => "Registrera denna sajt på tikiwiki.org",
"Read this first!" => "Läs detta först!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "På denna sida kan du göra din tiki sajt känt på tikiwiki.org. Den kommer att visas där i en lista med kända tiki sajter.",
"Registering is voluntary." => "Registreringen är frivillig.",
"Registering does not give you any benefits except one more link to your site." => "Registreringen ger dig inga fördelar förutom ytterligare en länk som pekar till din sajt.",
"You don't get any emails, we don't sell the data about your site." => "Du kommer inte få någon e-post, we säljer inge data om din sajt.",
"Registering is just for us to get an overview of Tiki's usage." => "Registrering är endast till för att ge en överblick av användandet av Tiki.",
"If your site is private or inside your intranet, you should not register!" => "Om din sajt är privat eller ligger innanför ditt intranät (innanför brandväggen), så skall du inte registrera dig!",
"Information about your site" => "Information om din sajt",
"Send me my Password" => "Skicka mitt lösenord",
"Request Password Reset" => "Begär nytt lösenord",
"Remove page" => "Ta bort sidor",
"You are about to remove the page" => "Du håller på att ta bort sidan",
"permanently" => "permanent",
"Remove all versions of this page" => "Ta bort alla versioner av denna sida",
"Rollback page" => "Ursprunglig sida",
"Search in" => "Sök i",
"Simple search" => "Enkel sökning",
"No pages matched the search criteria" => "Ingen sidor stämde med sökkriteriet",
"All dates" => "Alla datum",
"Send blog post" => "Skicka blog inlägg",
"A link to this post was sent to the following addresses:" => "En länk till detta inlägg skickades till dessa adresser:",
"Send post to this addresses" => "Skicka inlägget till denna adress",
"List of email addresses separated by commas" => "Lista med e-postadresser separerade med komma",
"This newsletter will be sent to {\$subscribers} email addresses." => "Detta nyhetsbrev kommer att skickas till {\$subscribers} e-postadresser.",
"Prepare a newsletter to be sent" => "Förbered ett nyhetsbrev för att skickas",
"Attached Files" => "Bifogade Filer",
"remove" => "radera",
"Send objects" => "Skicka objekt",
"Transmission results" => "Transmissionsresultat",
"Send Wiki Pages" => "Skicka Wikisidor",
"Send Articles" => "Skicka artiklar",
"Send objects to this site" => "Skicka objekt till denna sajt",
"Change shoutbox general settings" => "Ändra megafonens generella inställningar",
"auto-link urls" => "auto-länka URL'er",
"Post or edit a message" => "Skicka eller redigera ett meddelande",
"Parent page" => "Reffererande sida",
"Created by %0" => "Skapad av %0",
"big grin" => "stort grin",
"confused" => "förvirrad",
"cool" => "tuff",
"cry" => "gråt",
"eek" => "suck",
"evil" => "elak",
"mr green" => "herr grön",
"redface" => "rodnad",
"rolleyes" => "rullöga",
"smile" => "leende",
"surprised" => "förvånad",
"twisted" => "vriden",
"arrow" => "pil",
"Site Stats" => "Sajtstatistik",
"Total pageviews" => "Totalt visade sidor",
"Average pageviews per day" => "Genomsnittligt antal sidvisningar per dag",
"Best day" => "Bästa dag",
"Worst day" => "Sämsta dag",
"Wiki Stats" => "Wikins Statistik",
"Size of Wiki Pages" => "Storlek på Wikins Sidor",
"Average page length" => "Genomsnittlig sidlängd",
"Average versions per page" => "Genomsnittligt antal versioner per sida",
"Visits to wiki pages" => "Besök på wikisidor",
"Orphan pages" => "Orefererade sidor",
"Average links per page" => "Genomsnittligt antal länkar per sida",
"Image galleries Stats" => "Bildgalleristatistik",
"Average images per gallery" => "Genomsnittligt antal bilder per galleri",
"Total size of images" => "Bildernas totala storlek",
"Average image size" => "Genomsnittlig bildstorlek",
"Visits to image galleries" => "Antal besök i bildgallerier",
"File galleries Stats" => "Filgalleristatistik",
"Average files per gallery" => "Genomsnittligt antal filer per galleri",
"Total size of files" => "Filernas totala storlek",
"Average file size" => "Genomsnittlig filstorlek",
"Visits to file galleries" => "Antal besök i filgallerier",
"CMS Stats" => "CMS statistik",
"Total reads" => "Totalt antal lästa artiklar",
"Average reads per article" => "Genomsnittligt antal läsningar per artikel",
"Total articles size" => "Total artikelstorlek",
"Average article size" => "Genomsnittlig artikelstorlek",
"Forum Stats" => "Forumstatistik",
"Total topics" => "Totalt antal ämnen",
"Average topics per forums" => "Genomsnittligt antal ämnen per forum",
"Visits to forums" => "Antal besök i forumet",
"Blog Stats" => "Blogstatistik",
"Weblogs" => "Webbloggar",
"Total posts" => "Totalt antal inlägg",
"Average posts per weblog" => "Genomsnittligt antal inlägg per webblog",
"Total size of blog posts" => "Total storlek på bloginläggen",
"Average posts size" => "Genomsnittligt storlek på bloginläggen",
"Visits to weblogs" => "Antal besök i webbloggar",
"Poll Stats" => "Omröstningsstatistik",
"Total votes" => "Totalt antal röster",
"Average votes per poll" => "Genomsnittligt antal röster per omröstning",
"Total questions" => "Totalt antal frågor",
"Average questions per FAQ" => "Genomsnittligt antal frågor per FAQ",
"User Stats" => "Användarstatistik",
"User bookmarks" => "Användarbokmärken",
"Average bookmarks per user" => "Genomsnittligt antal bokmärken per användare",
"Average questions per quiz" => "Genomsnittligt antal frågor per frågesport",
"Quizzes taken" => "Genomförda frågesporter",
"Average quiz score" => "Genomsnittligt frågesportsresultat",
"Average time per quiz" => "Genomsnittlig tid per frågesport",
"Usage chart" => "Nyttjandegraf",
"Usage chart image" => "Diagram på användning ",
"Stats for surveys" => "Statistik för underökningar",
"Last taken" => "Senast tagen",
"Time Left" => "Resterande tid",
"Send a link to a friend" => "Skicka en länk till en vän",
"Your email was sent" => "Ditt meddelande skickades",
"Theme is selected as follows" => "Tema väljs som följer",
"If a theme is assigned to the individual object that theme is used." => "Om ett tema är tilldelat till det individuella objektet så används det temat.",
"If not then if a theme is assigned to the object's category that theme is used" => "Annars används ett tema som är tilldelat till det objektets kategori",
"If not then a theme for the section is used" => "Annars används ett tema för sektionen",
"If none of the above was selected the user theme is used" => "Valdes inget ovan används användarens tema",
"Finally if the user didn't select a theme the default theme is used" => "Slutligen, om användaren inte har valt ett tema används förvalet",
"Control by Sections" => "Kontrollera via sektioner",
"Assign themes to categories" => "Tilldela teman till kategorier",
"Assigned categories" => "Tilldelade kategorier",
"Theme Control Center: Objects" => "Temaväljaren: Objekt",
"Control by Categories" => "Kontrollera via Kategorier",
"Assign themes to objects" => "Tilldela teman till objekt",
"Assigned objects" => "Tilldelade objekts",
"Assign themes to sections" => "Tilldela teman till sektioner",
"Assigned sections" => "Tilldela sektioner",
"The following file was successfully uploaded" => "Följande fil skickades in framgångsrikt",
"You can download this file using" => "Du kan hämta denna fil med",
"You locked the file" => "Du har låst filen",
"The file is locked by {\$fileInfo.lockedby}" => "Filen är låst av {\$fileInfo.lockedby}",
"You have to create a gallery first!" => "Du måste skapa ett galleri först!",
"Batch Upload Results" => "Skicka resultat i en klump",
"Upload successful!" => "Inskickning lyckades!",
"The following image was successfully uploaded" => "Följande fil skickades in framgångsrikt",
"Image ID thumb" => "Bildminiatyr ID",
"You can include the image in an Wiki page using" => "Du kan infoga bilden i en wiki-sida genom att använda",
"Now enter the image URL" => "Skriv in bildens URL",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Indexbild (valfri, har företrädesrätt framför automatiskt genererade indexbilder",
"Note: Maximum image size is limited to" => "OBS: Maximal bildstorlek är begränsad till",
"User assigned modules" => "Användartilldelade moduler",
"Assign module" => "Tilldela modul",
"Column" => "Kolumn",
"top" => "upp",
"Current folder" => "Nuvarande mapp",
"Folders" => "Mappar",
"Folder in" => "Mapp i",
"Admin folders and bookmarks" => "Admin mappar och bokmärken",
"Send me a message" => "Skicka mig ett meddelande",
"Personal Wiki Page" => "Personlig wiki-sida",
"Your personal Wiki Page" => "Din personliga Wiki",
"Is email public? (uses scrambling to prevent spam)" => "Låt andra se din e-postadress? (använder förvrängning för att förhindra spam)",
"Does your mail reader need a special charset" => "Kräver din e-postklient någon speciell teckenuppsättning",
"Your preferred language" => "Välj huvudspråk",
"Other languages you can read (select on the left to add to the list on the right)" => "Fler språk, klicka för att lägga till dom i listan",
"Note author when reading his mail" => "Meddela avsändaren när meddelandet har lästs",
"My level" => "Min nivå",
"Account Information" => "Kontoinformation",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Lämna \"Nytt lösenord\" och \"Bekräfta nytt lösenord\" tomma för att behålla ditt nyvarande lösenord",
"Email address" => "E-post adress",
"Confirm new password" => "Bekräfta nytt lösenord",
"Current password (required)" => "Nuvarande lösenord(måste anges)",
"Change administrative info" => "Ändra kontoinformationen",
"New task" => "Ny uppgift",
"Task list" => "Lista uppgifter",
"Admin mode off" => "Adminläge av",
"Admin mode on" => "Adminläge på",
"Task help" => "Hjälp",
"Empty Trash" => "Töm Sopkorgen",
"Received task" => "Mottagen uppgift",
"Send task" => "Skicka uppgift",
"Percentage completed" => "Procent färdig",
"No tasks entered" => "Inga uppgifter angivna",
"Select One" => "Välj En",
"Received" => "Mottagna",
"Submitted" => "Skickade",
"Shared" => "Delade",
"All Shared Tasks" => "Alla delade uppgifter",
"completed (100%)" => "färdiga (100%)",
"Watches" => "Bevakningar",
"May need to refresh twice to see changes" => "Kan behövas uppdateras två gånger för att ändringarna skall synas",
"Add top level bookmarks to menu" => "Skapa översta nivåns bokmärke till menyn",
"replace window" => "ersätt fönster",
"User_versions_for" => "Användarversioner för",
"This page is being edited by" => "Denna sida redigeras av",
"Proceed at your own peril" => "Fortsätt på eget bevåg (målsman ansvarar för sina barn)",
"expires:" => "upphör:",
"Banner stats" => "Banner statistik",
"Create new banner" => "Skapa en ny bannerannons",
"Banner Information" => "Banner information",
"Click ratio" => "Klickfrekvens",
"Weekdays" => "Veckodagar",
"mon" => "mån",
"tue" => "tis",
"wed" => "ons",
"thu" => "tor",
"fri" => "fre",
"sat" => "lör",
"sun" => "sön",
"Banner raw data" => "Rådata till banners",
"Cached" => "Cachad",
"This is a cached version of the page." => "Detta är en cachad version av sidan.",
"Click here to view the Google cache of the page instead." => "Klicka här för att se Google's cachade sida istället.",
"Chart created" => "Diagram skapat",
"Permanency" => "Varaktighet",
"chg" => "ändring",
"info/vote" => "info/rösta",
"Next chart will be generated on" => "Nästa diagram kommer genereras på",
"View or vote items not listed in the chart" => "Visa eller rösta på poster som inte listas i detta diagram",
"Select something to vote on" => "Välj något att rösta på",
"Item information" => "Postinformation",
"Dif" => "Skillnad",
"Best Position" => "Bästa placering",
"Vote this item" => "Rösta på denna post",
"Highest" => "Högst",
"Q" => "F",
"A" => "S",
"Forum List" => "Forumlista",
"Edit Forum" => "Redigera Forum",
"Summary" => "Sammanfattning",
"Moderator Actions" => "Admin alternativ",
"Move Selected Topics" => "Flytta markerade ämnen",
"Unlock Selected Topics" => "Lås upp markerade ämnen",
"Lock Selected Topics" => "Lås markerade ämnen",
"Delete Selected Topics" => "Radera merkerade ämnen",
"Merge" => "Sammanfoga",
"Merge Selected Topics" => "Sammanfoga markerade ämnen",
"Merge into topic" => "Infoga i ett ämne",
"Emot" => "Smiley",
"No topics yet" => "Inga ämnen inlagda",
"Filter Posts" => "Filtrera Inlägg",
"Jump to forum" => "Hoppa till forum",
"Last hour" => "Senaste timmen",
"Last 24 hours" => "Senaste 24 timmarna",
"Last 48 hours" => "Senaste 48 timmarna",
"Archived" => "Arkiverad",
"Topic List" => "Ämneslista",
"prev topic" => "föregående ämne",
"next topic" => "nästa ämne",
"Print this page only" => "Skriv ut den här sidan",
"Print all pages" => "Skriv ut alla sidor",
"Show posts" => "Visa inlägg",
"Tracker Items" => "Ärendeföljarposter",
"Insert new item" => "Lägg in ny post",
"Show All" => "Visa allt",
"Use HTML mail" => "Använd HTML i post",
"The following addresses are not in your address book" => "Följande adresser finns inte i din adressbok",
"Attachment 1" => "Bilaga 1",
"Attachment 2" => "Bilaga 2",
"Attachment 3" => "Bilaga 3",
"Address book" => "Adressbok",
"page id" => "sid id",
"Categories:" => "Kategorier:",
"Save Minor Edit" => "Spara Mindre Redigering",
"Save Draft" => "Spara Utkast",
"General preferences and settings" => "Allmänna alternativ och inställningar",
"Wiki settings" => "Wikins inställningar",
"Poll comments settings" => "Kommentarinställningar för omröstningar",
"Forums settings" => "Foruminställningar",
"RSS feeds" => "RSS matning",
"Configure Site Ads and Banners" => "Konfigurera Annonser och Banners",
"No chart indicated" => "Ingen graf angiven",
"Upload failed" => "Uppladdningen misslyckades",
"Your admin password has been changed" => "Ditt administratörslösenord har ändrats",
"All Fields except gdaltindex must be filled" => "Alla fält utom gdaltindex måste fyllas i",
"Tag already exists" => "Etiketten existerar redan",
"Tag not found" => "Etiketten ej funnen",
"Repository name can't be an empty" => "Lagrets namn kan ej vara tomt",
"Requested action is not supported on repository" => "Efterfrågad handling stöds ej av lagret",
"No repository" => "Inget förråd",
"Search is mandatory field" => "Sök är ett obligatoriskt fält",
"File not found " => "Filen ej funnen ",
"Requested action in not supported on repository" => "Efterfrågad handling på lagret stöds ej",
"Non-existent link" => "Länken existerar ej",
"No menu indicated" => "Ingen meny angiven",
"No newsletter indicated" => "Inget nyhetsbrev angivet",
"No poll indicated" => "Ingen omröstning angiven",
"Permission denied you cannot view this page" => "rättigheter att visa denna sida saknas",
"Permission denied you cannot edit this page" => "Rättighet att redigera denna sida saknas",
"You must specify a page name, it will be created if it doesn't exist." => "Du måste ange ett sidnamn. Det kommer att skapas om det inte existerar.",
"page not added (Exists)" => "sidan ej inlagd (finns redan)",
"No survey indicated" => "Inge undersökning angiven",
"No tracker indicated" => "Ingen ärendeföljare angiven",
"Group already exists" => "Gruppen existerar redan",
"No records were found. Check the file please!" => "Inga poster hittades. Vänligen kontrollera filen!",
"User login is required" => "Användarinloggning krävs",
"Password is required" => "Lösenord är obligatorisk",
"Email is required" => "E-post är obligatorisk",
"User is duplicated" => "Användaren är en dubblett",
"password" => "lösenord",
"Unknown group" => "Okänd grupp",
"Permission denied you cannot view backlinks for this page" => "Rättighet att visa bakåtlänkar för denna sida saknas",
"The page cannot be found" => "Sidan kan ej hittas",
"Invalid directory name" => "Felaktigt webbkatalognamn",
"You can't post in any blog maybe you have to create a blog first" => "Du har inte rättigheter att skicka inlägg i någon blog, kanske du måste skapa en blog först",
"Permission denied you cannot post" => "Rättigheter att skicka inlägg saknas",
"Permission denied you cannot edit this post" => "Rättighet att redigera detta inlägg saknas",
"Top visited blogs" => "Mest besökta bloggar",
"Last posts" => "Senaste inlägg",
"Top active blogs" => "Mest aktiva bloggar",
"No blogId specified" => "Inget blogId specificerat",
"TOP" => "UPP",
"Permission denied you cannot access this gallery" => "Rättigheter att komma åt detta galleri saknas",
"No gallery indicated" => "Inget galleri angivet",
"Permission denied you can not view this section" => "Rättigheter för att vida denna avdelning saknas",
"Permission denied you cannot remove images from this gallery" => "Rättigheter att ta bort bilder ur detta galleri saknas",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Rättigheter att bygga om indexbilder i detta galleri saknas",
"Permission denied you cannot rotate images in this gallery" => "Rättighetter att rotera bilder i detta galleri saknas",
"No image indicated" => "Inge bild angiven",
"Permission denied you cannot move images from this gallery" => "Rättigheter att flytta bilder från detta galleri saknas",
"Permission denied you cannot view the calendar" => "Rättigheter att visa denna kalender saknas",
"event without name" => "händelse utan namn",
"You can not use the same password again" => "Du kan inte använda samma lösenord igen",
"Top authors" => "Bästa författare",
"This feature has been disabled" => "Denna funktion är avstängd",
"Must enter a name to add a site. " => "Ett namn måste anges för att lägga till en sajt. ",
"Must enter a url to add a site. " => "En URL måste anges för att lägga till en sajt. ",
"URL already added to the directory. Duplicate site? " => "URL'en redan inlagd i mappen. Duplicera sajten? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "Det saknas åtkomst till denna URL, antingen är URL'en felaktig eller är sajten ej tillgänglig och kan därför inte läggas till i mappen. ",
"Must select a category. " => "Måste välja en kategori. ",
"Must enter a name to add a site" => "Ett namn måste tillhandahållas för att lägga till en sajt",
"Must enter a url to add a site" => "En URL måste tillhandahållas för att lägga till en sajt",
"URL already added to the directory. Duplicate site?" => "URL'en redan inlagd i webbkatalogen. Duplicera sajten?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "Det saknas  åtkomst till denna URL: Antingen är URL'en felaktig eller så är sajten ej tillgänglig och kan därför inte läggs till i webbkatalogen",
"Must select a category" => "Måste välja en kategori",
"No site indicated" => "Ingen sajt angiven",
"Article not found" => "Artikel ej funnen",
"Permission denied you cannot edit this article" => "Rättigheter saknas att redigera denna artikel",
"You do not have permissions to edit banners" => "Rättigheter att redigera banners saknas",
"Banner not found" => "Banner ej hittad",
"You do not have permission to edit this banner" => "Rättighet att redigera denna banner saknas",
"Permission denied you cannot create or edit blogs" => "Rättigheter att skapa eller redigera bloggar saknas",
"Permission denied you cannot edit this blog" => "Rättigheter att redigera denna blog saknas",
"You do not have permission to write the style sheet" => "Rättighet att skriva till mallen saknas",
"Invalid request to edit an image" => "Felaktig begäran att redigera en bild",
"Permission denied you cannot edit images" => "Rättigheter att redigera bilder saknas",
"Permission denied you can edit images but not in this gallery" => "Rättigheter att redigera bilder finns, men inte i detta galleri",
"Failed to edit the image" => "Misslyckades med att redigera bilden",
"Permission denied to use this feature" => "Rättigheter att använda denna funktion saknas",
"Shortname must be 2 Characters" => "Kortnamn måste vara 2 tecken",
"You must provide a longname" => "Du måste tillhandahålla ett långnamn",
"Language created" => "Språk skapat",
"No content id indicated" => "Ingen innehålls-id angiven",
"No question indicated" => "Ingen fråga angiven",
"No quiz indicated" => "Inge frågesport angiven",
"No structure indicated" => "Ingen struktur angiven",
"Invalid structure_id or page_ref_id" => "Felaktig structure_id eller page_ref_id",
"Permission denied you cannot send submissions" => "Rättighet att skicka bidrag saknas",
"Permission denied you cannot edit submissions" => "Rättighet att redigera bidrag saknas",
"You have to create a topic first" => "Du måste skapa ett ämne först",
"You do not have permission to do that" => "Rättigheter för att göra detta saknas",
"You do not have permission to read the template" => "Rättigheter för att läsa mallen saknas",
"No topic id specified" => "Inget ämnes-id specificerat",
"Invalid topic id specified" => "Felaktigt ämnes-id specificerat",
"page imported" => "sidan importerad",
"created from import" => "skapa från import",
"Can't import remote HTML page" => "Kan ej importera extern HTML sida",
"The SandBox is disabled" => "Sandlådan är avstängd",
"Cannot edit page because it is locked" => "Du kan ej redigera denna sida eftersom den är låst",
"Permission denied you cannot edit this file" => "Rättighet att editera denna fil saknas",
"Permission denied you cannot remove files from this gallery" => "Rättighet att ta bort filer från detta galleri saknas",
"Top visited file galleries" => "Mest besökta filgallerier",
"Most downloaded files" => "Mest nerladdade filer",
"Last files" => "Senaste filer",
"No galleryId specified" => "Inget galleryId specificerat",
"No forum indicated" => "Inget forum angivet",
"Forum posts" => "Foruminlägg",
"No forumId specified" => "Inget forumId specificerat",
"No process indicated" => "Ingen process angiven",
"Activity name already exists" => "Aktivitetsnamn existerar redan",
"indicates if the process is active. Invalid processes cant be active" => "anger om processen är aktiv. Felaktiga processer kan inte vara aktiva",
"No instance indicated" => "Inge instans angiven",
"No activity indicated" => "Ingen aktivitet angiven",
"The process name already exists" => "Processnamnet existerar redan",
"Process already exists" => "Processen existerar redan",
"You cant execute this activity" => "Du kan inte utföra denna aktivitet",
"No user indicated" => "Ingen användare angiven",
"No item indicated" => "Ingen post angiven",
"first image" => "första bilden",
"last image" => "sista bilden",
"Permission denied you cannot create galleries and so you cant edit them" => "Rättigheter att skapa gallerier saknas vilket gör att du inte kan redigera dom",
"Permission denied you cannot edit this gallery" => "Rättighet att redigera detta galleri saknas",
"Permission denied you cannot remove this gallery" => "Rättighet att ta bort detta galleri saknas",
"Top images" => "Bästa bilderna",
"Last images" => "Senaste bilderna",
"overwriting old page" => "skriver över gammal sida",
"page created" => "sidan skapad",
"No name indicated for wiki page" => "Namn saknas för wikisidan",
"No repository given" => "Inget förråd angivet",
"Permission denied you cannot view pages like this page" => "Rättighet att visa sidor som denna saknas",
"Permission denied you cannot remove articles" => "Rättighet att ta bort artiklar saknas",
"Permission denied you cannot remove banners" => "Rättighet att ta bort banners saknas",
"Permission denied you cannot remove this blog" => "Rättighet att ta bort denna blog saknas",
"Delete comments" => "Radera kommentarer",
"Non-existent gallery" => "Galleriet existerar ej",
"Permission denied you can upload files but not to this file gallery" => "Rättigheter att skicka in filer finns men saknas för just detta filgalleri",
"Could not upload the file" => "Kunde inte skicka in filen",
"Permission denied you can't upload files so you can't edit them" => "Rättighet att skicka filer till detta galleri saknas, så du får inte redigera dem heller",
"The thumbnail name must be" => "Indexbildens namn måste vara",
"You cannot admin blogs" => "Du kan inte administrera bloggar",
"Permission denied you cannot remove submissions" => "Rättighet att ta bort bloggar saknas",
"Permission denied you cannot approve submissions" => "Rättighet att godkänna bidrag saknas",
"edit" => "redigera",
"You do not have permissions to view the maps" => "Rättigheter att titta på kartor saknas",
"mapfile name incorrect" => "felaktigt kartfilsnamn",
"This mapfile already exists" => "Denna kartfil existerar redan",
"You do not have permission to write to the mapfile" => "Rättighet att skriva till kartfilen saknas",
"You do not have permission to delete the mapfile" => "Rättigheter att radera karfilen saknas",
"You do not have permission to read the mapfile" => "Du saknar rättighet att läsa kartfilen",
"You do not have permissions to view the layers" => "Rättigheter för att visa nivåer saknas",
"You do not have permissions to delete a file" => "Rättigheter att radera filen saknas",
"File not found" => "Filen ej funnen",
"You do not have permissions to create a directory" => "Du saknas rättigheter att skapa en webbkatalog",
"The Directory is not empty" => "Webbkatalogen är ej tom",
"You do not have permissions to delete a directory" => "Rättigheter att radera en webbkatalog saknas",
"You do not have permissions to create an index file" => "Rättigheter att skapa en indexfil saknas",
"Invalid file name" => "Felaktigt filnamn",
"Invalid files to index" => "Felaktiga filer att indexera",
"I do not know where is gdaltindex. Set correctly the Map feature" => "Jag vet inte var filen gdaltindex finns. Konfigurera kartfunktionen korrekt",
"I could not create the index file" => "Indexfilen kunde inte skapas",
"Must be logged to use this feature" => "Du måste vara inloggad för att använda denna funktion",
"Welcome at Hawiki" => "Välkommen till Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Denna sajt är förberedd för access från många olika mobila enheter t.ex. WAP-telefoner, PDA's, i-mode enheter med mera.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "Du kan besöka denna sajt med en mobil enhet genom att rikta din webbläsare till följande URL på denna sajt:",
"About" => "Om",
"You must log in to use this feature" => "Du måste logga in för att använda denna funktion",
"You do not have permission to view other users data" => "Du har inte rättigheter att läsa andra användares data",
"You must be logged in to subscribe to newsletters" => "Du måste vara inloggad för att kunna prenumererar på nyhetsbrev",
"No server indicated" => "Ingen server angiven",
"Cannot connect to" => "Kan ej ansluta till",
"Missing information to read news (server,port,username,password,group) required" => "Information saknas för att kunna läsa 'news' (server, port, användarnamn, lösenord, grupp) krävs",
"Cannot get messages" => "Kan inte hämta meddelanden",
"No note indicated" => "Ingen anteckning angiven",
"merged note:" => "sammanslagen anteckning:",
"File is too big" => "Filen är för stor",
"created from notepad" => "skapad från anteckningsblocket",
"Page already exists" => "Sidan existerar redan",
"Not enough information to display this page" => "Information saknas för att kunna visa denna sida",
"Permission denied you cannot browse this page history" => "Rättigheter för att visa denna sidas historia saknas",
"No article indicated" => "Ingen artikel angiven",
"Article is not published yet" => "Artikeln är inte publicerad än",
"No post indicated" => "Inget inlägg angivet",
"Blog not found" => "Blogen ej funnen",
"No pages indicated" => "Inga sidor angivna",
"No result indicated" => "Inga resultat angivna",
"The passwords don't match" => "Lösenorden är ej lika",
"Invalid or unknown username" => "Ogiltigt eller okänt användarnamn",
"to the registered email address for" => "till den registrerade e-postadressen för",
"Permission denied you cannot remove versions from this page" => "Rättigheter för att ta bort versioner på denna sida saknas",
"Cannot rename page maybe new page already exists" => "Kan ej döpa om sidan, kanske det nya namnet redan existerar",
"Non-existent version" => "Versionen existerar ej",
"Permission denied you cannot rollback this page" => "Rättighet att rulla tillbaka till tidigare versioner av denna sida saknas",
"Post recommendation at" => "Inläggsrekomendation på",
"Page must be defined inside a structure to use this feature" => "Sidan måste vare definierad inne i en struktur för att denna funktions skall kunna användas",
"You cannot take this quiz twice" => "Du får inte göra denna frågesport två gånger",
"Quiz time limit exceeded quiz cannot be computed" => "Frågesportens tidsgräns har överskridits. Resultatet kan ej beräknas",
"You cannot take this survey twice" => "Du kan inte deltaga i denna undersökning två gånger",
"Please create a category first" => "Vänligen skapa en kategori först",
"No permission to upload zipped file packages" => "Rättigheter att skicka in zippade filpaket saknas",
"Error processing zipped image package" => "Fel uppstod vid uppackning av zippat bildpaket",
"No permission to upload zipped image packages" => "Rättigheter saknas för att skicka in zippade bildpaket",
"Permission denied you cannot upload images" => "Rättigheter för att skicka in bilder saknas",
"Permission denied you can upload images but not to this gallery" => "Rättigheter för att skicka in bilder finns men saknas för just detta galleri",
"Cannot get image from URL" => "Kan ej hämta bilden från URL'en",
"No url indicated" => "Ingen URL angiven",
"Unknown user" => "Okänd användare",
"You are not logged in and no user indicated" => "Du är inte inloggad och ingen användare är angiven",
"The user has chosen to make his information private" => "Användare har valt att göra sin information otillgänglig",
"The passwords did not match" => "Lösenorden är ej lika",
"no" => "nej",
"Cannot upload this file not enough quota" => "Kan ej ta emot denna fil eftersom det saknas tilldelat utrymme",
"Non-existent user" => "Användaren finns inte",
"No banner indicated" => "Ingen banner angiven",
"No blog indicated" => "Ingen blog angiven",
"Permission denied you cannot remove the post" => "Rättigheter att ta bort inlägget saknas",
"No cache information available" => "Inge cacheinformation tillgänglig",
"No faq indicated" => "Ingen FAQ angiven",
"You are not permitted to remove someone else\\'s post!" => "Du får inte ta bort någon annans inlägg!",
"No thread indicated" => "Ingen tråd angiven",
"Incorrect thread" => "Felaktig tråd",
"No subject" => "Inget ämne",
"Top pages" => "Bästa sidor",
"Last pages" => "Senaste sidor",
"###end###"=>"###end###");
?>
