<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"+1d" => "+1n",
"+1m" => "+1p",
"+7d" => "+7n",
"Add all your site users to this newsletter (broadcast)" => "Összes felhasználó hozzáadása a hírlevél előfizetéshez (broadcast)",
"Add or edit a task" => "Feladat hozzáadása/szerkesztése",
"Add scaled images size X x Y" => "X x Y méretű, méretarányos képek hozzáadása",
"All tasks" => "Minden feladat",
"assgn" => "csatol",
"ExtWikis" => "Külső Wikik",
"File gals" => "Fájlgalériák",
"forum topic" => "fórum téma",
"Image gals" => "Képgalériák",
"Import pages from a PHPWiki Dump" => "Lapok importálása a PHPWiki Dump-ból",
"mark as done" => "elvégzettként megjelöl",
"open tasks" => "feladatok megnyitása",
"Packages" => "Csomagok",
"Ranking" => "Rangsor",
"To create a new translation of a page that has never been translated before, create an initial version of the translation, select the translation language above, enter the page name of the original page below, and hit \"go\"." => "Ha egy új oldalt fordítok le, akkor először létrehozom a lefordított oldalt az eredeti alapján, beállítom a fordítás nyelvét az új oldalon, majd itt ezen az oldalon egymáshoz illesztem az az eredetit és az úja(ka)t egy fordítási halmazba",
"today" => "ma",
"v=view, b=rollback, c=compare with current, d=diff to current, s=source" => "v=megtekintés, b=visszatérés korábbihoz, c=összehasonlítás jelenlegivel, d=különbség a jelenlegihez képest, s=forrás",
"Wiki page" => "Wiki lap",
"You do not have permission to use this feature." => "Nincs elegendő jogosultság a funkció használatához",
"no description" => "Nincs leírás",
"Updated" => "Frissítve",
"Tip: hold down CTRL to select multiple categories" => "Javaslat: a CTRL gomb megnyomásával egyszerre több kategória is kiválasztható",
"Click the :: option on the menu for more options." => "Kattints a menüpontok bal oldalán található szimbólumra, hogy lásd a további opciókat!",
"Please also see" => "Továbbá ajánljuk tekintsd meg a ",
"Admin->Modules" => "Admin->Modulok menüpontban",
"Jukebox" => "Zeneláda",
"Blog settings" => "Blog beállítások",
"FAQs settings" => "Gyakori kérdések beállításai",
"FAQ comments" => "Gyakori kérdések kommentjei",
"Remind passwords by email" => "Jelszóemlékeztető küldése E-mailben",
"Poll settings" => "Szavazás beállítások",
"Like pages" => "Hasonló oldalak",
"Added users" => "Hozzáadott felhasználók",
"search category" => "Kategória keresése",
"deep" => "mélyen",
"For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "Bővebb leírásért lásd: <a href=\"{\$helpurl}WikiSyntax\">Wiki formázás</a>",
"Emphasis" => "Hangsúly",
"italics" => "dőlt",
"both" => "mindkettő",
"use ...page... to separate pages" => "egy oldalon belül különböző oldalak elválasztáshoz használjuk ezt:  ...page...",
"underlines text" => "aláhúzott szöveg",
"Wiki quick help" => "formázási tanácsok",
"Quicklinks" => "Gyorslinkek",
"Comparing versions" => "Verziók összehasonlítása",
"Actual_version" => "Jelenlegi verzió",
"Diff to version" => "Különbségek ehhez a verzióhoz képest",
"The passwords dont match" => "A megadott jelszavak nem egyeznek",
"You do not have permission to write the template" => "A sablon szerkesztéséhez több jogosultságra van szükség",
"Error: This page is being edited by another user." => "Hiba: az oldalt épp most szerkeszti egy másik felhasználó",
"Tiki RSS Feed Error Message" => "Tiki RSS feed hibaüzenet",
"Edit information" => "Információ szerkesztése",
"uploaded by" => "Feltöltötte:",
"not specified" => "nincs meghatározva",
"delete" => "törlöm",
"post" => "elküldöm",
"posts" => "üzenetek",
"visits" => "látogatások",
"show categories" => "kategóriák megjelenítése",
"author" => "szerző",
"user level" => "felhasználói szint",
"send email to user" => "E-mail küldése felhasználónak",
"score" => "pontszám",
"delete selected" => "kijelöltek törlése",
"move" => "mozgatás",
"Posted messages" => "Elküldött üzenetek",
"set" => "beállítás",
"replies" => "válasz",
"cancel" => "visszavonás",
"up" => "fel",
"down" => "le",
"add" => "hozzáadás",
"create" => "létrehozás",
"save" => "mentés",
"send" => "küldés",
"register" => "regisztráció",
"secure" => "biztonságos",
"stay in ssl mode" => "maradjon az SSL mód",
"new messages" => "új üzenetek",
"new message" => "új üzenet",
"go" => "indítás",
"cache" => "gyorsítótár",
"refresh" => "frissítés",
"print" => "nyomtatás",
"create pdf" => "pdf készítés",
"monitor this page" => "oldal figyelése",
"stop monitoring this page" => "oldal figyelésének felfüggesztése",
"backlinks" => "hivatkozások",
"click here" => "klikk ide",
"rename" => "átnevezés",
"unlock" => "feloldás",
"lock" => "zárolás",
"perms" => "jogok",
"history" => "előzmények",
"similar" => "hasonló",
"undo" => "visszaállítás (undo)",
"slides" => "bemutató",
"export" => "exportálás",
"discuss" => "megbeszélés",
"add comment" => "komment hozzáfűzése",
"attach file" => "fájl csatolása",
"translation" => "fordítás",
"last modification" => "utolsó módosítás",
"attachments" => "mellékletek",
"stats" => "statisztika",
"last changes" => "legutóbbi változások",
"list pages" => "lapok listázása",
"cancel edit" => "szerkesztés visszavonása",
"view blog" => "blog megtekintése",
"list blogs" => "blogok listázása",
"save and exit" => "Mentés és kilépés",
"reads" => "olvasás",
"wiki help" => "wiki súgó",
"General preferences" => "általános beállításaim",
"Other preferences" => "További preferenciák",
"HomePage" => "Kezdőlap",
"images" => "képek",
"Server name (for absolute URIs)" => "Szerver név (Az abszolút URI-hoz)",
"Wiki_Tiki_Title" => "Wiki_Tiki_Név",
"path" => "útvonal",
"groups" => "csoportok",
"Require HTTP Basic authentication" => "Alapvető HTTP azonosítás igénylése",
"HTTP server name" => "HTTP szerver neve",
"HTTP URL prefix" => "HTTP URL előtag",
"HTTPS server name" => "HTTPS szerver neve",
"HTTPS URL prefix" => "HTTPS URL előtag",
"Only for users" => "Csak felhasználóknak",
"Users and admins" => "Felhasználók és adminisztrátorok",
"Full Text Search" => "Teljes szövegkeresés",
"change" => "változtatás",
"Enable Feature" => "Funkció bekapcsolása",
"admin banning tpl" => "kitiltás sablon adminisztrálása",
"loc" => "hely",
"cat" => "kat",
"lang" => "nyelv",
"prio" => "font",
"permissions" => "jogosultságok",
"create new" => "új létrehozása",
"edit chart" => "slágerlista szerkesztése",
"update" => "frissítés",
"use in cms" => "használat cms-ben",
"use in wiki" => "használat wiki-ben",
"use in newsletters" => "használat újságokban",
"use in HTML pages" => "használat HTML oldalakon",
"last modif" => "utolsó módosítás",
"sections" => "szekciók",
"upload" => "feltöltés",
"topics" => "témák",
"age" => "kor",
"last post" => "utolsó hozzászólás",
"position" => "helye",
"admin Webmail" => "Webmail adminisztrálása",
"section" => "szakasz",
"options" => "opciók",
"assign module" => "modul hozzárendelése",
"left modules" => "bal modulok",
"right modules" => "jobb modulok",
"edit/create" => "szerkesztés/létrehozás",
"clear cache" => "gyorsítótár törlése",
"assign" => "hozzárendelés",
"left" => "bal",
"right" => "jobb",
"order" => "sorrend",
"create/edit" => "létrehozás/szerkesztés",
"use poll" => "szavazás használata",
"use gallery" => "galéria használata",
"use dynamic  content" => "dinamikus tartalom használata",
"use rss module" => "rss modul használata",
"use menu" => "menü használata",
"use banner zone" => "banner zónák használata",
"list newsletters" => "hírlevelek listázása",
"admin newsletters" => "hírlevelek adminisztrálása",
"send newsletters" => "hírlevelek küldése",
"editions" => "kiadások",
"last sent" => "utoljára elküldve",
"admin Email Notifications" => "E-mailes értesítések adminisztrálása",
"use admin email" => "adminisztrátori E-mail használata",
"event" => "esemény",
"admin polls" => "szavazások adminisztrálása",
"admin polls template" => "szavazások sablonjának adminisztrálása",
"export pages" => "oldalak exportálása",
"dump tree" => "oldalak fastruktúrájának lementése",
"create webhelp" => "webes súgó létrehozása",
"view webhelp" => "webes súgó megtekintése",
"tree" => "fa",
"create new structure" => "új struktúra létrehozása",
"survey stats" => "kérdőív statisztika",
"edit this survey" => "kérdőív szerkesztése",
"admin surveys" => "kérdőív adminisztrálása",
"list surveys" => "kérdőívek listázása",
"questions" => "kérdések",
"files" => "fájl",
"items" => "elem",
"Assign user" => "Felhasználó csatolása",
"Warning!" => "Figyelem!",
"Create new backup" => "Új biztonsági mentés készítése",
"Upload a backup" => "Egy biztonsági mentés feltöltése",
"Upload backup" => "Biztonsági mentés feltöltése",
"admin category" => "kategória adminisztrálása",
"edit gallery" => "galéria szerkesztése",
"rebuild thumbnails" => "előnézeti képek újraépítése",
"upload image" => "kép feltöltése",
"list gallery" => "galéria listázása",
"original size" => "eredeti méret",
"return to gallery" => "vissza a galériához",
"edit image" => "kép szerkesztése",
"smaller" => "kisebb",
"bigger" => "nagyobb",
"prev image" => "előző kép",
"popup window" => "előugró ablak",
"next image" => "következő kép",
"permission" => "jogosultság",
"remove page" => "oldal eltávolítása",
"browse" => "tallóz",
"related" => "kapcsolódó",
"add a site" => "weblap hozzáadása",
"edit template" => "sablon szerkesztése",
"list articles" => "cikkek listázása",
"view articles" => "cikkek megtekintése",
"edit blog tpl" => "blog sablon szerkesztése",
"admin quicktags" => "gyors elérések beállítása",
"results" => "eredmények",
"create page" => "oldal létrehozása",
"list submissions" => "beküldött cikkek listázása",
"edit translations" => "fordítások szerkesztése",
"edit translations template" => "nyelvi fordítások sablonjának szerkesztése",
"add to the set" => "hozzáadás a fordítások halmazához",
"topic" => "téma",
"new topic" => "új téma",
"accept" => "elfogadás",
"refuse" => "visszautasítás",
"create new gallery" => "új galéria létrehozása",
"result" => "eredmény",
"source" => "forrás",
"edit new article" => "új cikk szerkesztése",
"create new blog" => "új blog létrehozása",
"upload file" => "fájl feltöltése",
"delete selected files" => "kijelölt fájlok törlése",
"browse gallery" => "galéria böngészése",
"edit blog" => "blog szerkesztése",
"add topic" => "téma hozzáadása",
"wiki create" => "wiki készítése",
"wiki overwrite" => "wiki felülírása",
"back" => "vissza",
"Assign permissions to page" => "Jogosultságok kiosztása az oldalhoz",
"Current permissions for this page" => "Meglévő jogosultságok ezen oldalhoz",
"clear stats" => "statisztika törlése",
"last" => "utolsó",
"send me my password" => "küldd el a jelszavam",
"galleries" => "galériák",
"blog posts" => "blog posztok",
"articles" => "cikkek",
"add article" => "cikk hozzáadása",
"remove folder" => "mappa eltávolítása",
"refresh cache" => "cache frissítése",
"no comments" => "nincs komment",
"delete selected topics" => "Kiválasztott témák törlése",
"stop monitoring this topic" => "téma figyelésének felfüggesztése",
"Comments below your current threshold" => "Küszöbérték alatti kommentek",
"DATE-of" => "DATE-",
"You cannot edit this page because it is a user personal page" => "Ez egy felhasználó személyes oldala, csak ő szerkesztheti",
"You do not have permission to edit messages" => "Nincs elegendő jogosultság üzenetek szerkesztéséhez",
"new image uploaded by" => "Az új képet feltöltötte:",
"message" => "üzenet",
"select all" => "összes kijelölése",
"filter" => "szűrés",
"attach" => "csatolás",
"hide categories" => "Kategóriák elrejtése",
"Admin categories" => "Kategóriák adminisztrálása",
"browse category" => "Kategóriák böngészése",
"reply" => "válasz",
"monitor this topic" => "téma figyelése",
"with checked" => "a kijelöltek",
"move selected files" => "a kijelölt fájlok mozgatása",
"compare" => "összehasonlítás",
"diff" => "eltérés",
"for more setup details." => "részt mert segítséget nyújt az oldal beállításához.",
"You can remove this module in" => "Ez a modult eltávolítható itt",
"del" => "törlés",
"Create pdf" => "Pdf készítés",
"categories" => "kategóriák",
"at tracker" => "űrlapon",
"check / uncheck all" => "megjelöli / nem jelöli mindet",
"Tiki sections and features" => "Tikiwiki szekciók és funkciók",
"please read" => "kérem olvassa",
"yes" => "igen",
"Local" => "Helyi",
"private" => "privát",
"<b>enable/disable</b>" => "<b>bekapcsolás/kikapcsolás</b>",
"<b>Max number of items</b>" => "<b>Tételek maximális száma</b>",
"PDF generation" => "PDF készítés",
"Use in CMS" => "Használat cms-ben",
"Use in Wiki" => "Használat wiki-ben",
"Use in newsletters" => "Használat hírlevelekben",
"Use in HTML pages" => "Használat HTML oldalakon",
"Refresh rate (if dynamic) [secs]" => "Frissítési ráta (ha dinamikus) [másodperc]",
"Create/edit newsletters" => "Hírlevelek létrehozása/szerkesztése",
"subscriptions" => "előfizetések",
"Use Admin Email" => "Adminisztrátori E-mail használata",
"Edit or add poll options" => "Szavazási opciók hozzáadása/szerkesztése",
"Create/edit Polls" => "Szavazás létrehozása/szerkesztése",
"Rss channels" => "RSS csatornák",
"fields" => "mezők",
"Create/edit trackers" => "Űrlap létrehozása/módosítása",
"Add a new user" => "Új felhasználó hozzáadása",
"Popup Window" => "Előugró ablak",
"No individual permissions global permissions apply" => "Nincsenek egyéni jogosultságok beállítva így a globális jogosultságok érvényesek",
"Welcome to the Tiki Chat Rooms" => "Üdv a Tiki Chat szobákban",
"Please select a chat channel" => "Chat szoba kiválasztása",
"enter chat room" => "chatszoba megadása",
"Chatroom" => "Chatszoba",
"Active Channels" => "Aktív szobák",
"Users in this channel" => "Felhasználók ebben a szobában",
"Create PDF" => "PDF készítése",
"Remove Page" => "Oldal eltávolítása",
"Add or edit a site" => "Weblap hozzáadása/szerkesztése",
"sites" => "weblapok",
"answer" => "válasz",
"Edit Translation:" => "Fordítás szerkesztése:",
"Use this section to set the language of the version you are currently working on." => "Itt is beállítható az oldal jelenleg szerkesztett változatának nyelve",
"Set of Translations" => "Fordítások halmazai",
"Add to the Set" => "Hozzáadás a fordítások halmazához",
"Available File Galleries" => "Rendelkezésre álló fájlgalériák",
"rollback" => "visszagörgetés",
"Last ver" => "összes változat",
"Com" => "Komment",
"Vers" => "Verzió",
"Add or edit a news server" => "Hírszerver hozzáadása/szerkesztése",
"add page" => "oldal hozzáadása",
"Total threads" => "Fórumtémák száma",
"Average threads per topic" => "Fórumtémák átlagos száma témánként",
"Now enter the file URL" => "Fájl URL-jének megadása",
" or upload a local file from your disk" => " vagy egy lokális fájl feltöltése merevlemezről",
"Add or edit folder" => "Mappa hozzáadása/szerkesztése",
"Add or edit a URL" => "URL hozzáadása/szerkesztése",
"priority" => "fontosság",
"post new comment" => "Új komment hozzáfűzése",
"Post New Comment" => "Új komment hozzáfűzése",
"HTML tags are not allowed inside comments" => "HTML tag-ek használata nem megengedett a kommentekben",
"moderator actions" => "moderátori akciók",
"move selected topics" => "kiválasztott témák mozgatása",
"unlock selected topics" => "kiválasztott témák feloldása",
"lock selected topics" => "kiválasztott témák zárolása",
"merge selected topics" => "kiválasztott témák egyesitése",
"queued messages:" => "sorbanálló üzenetek:",
"account" => "fiók",
"Group doesnt exist" => "A csoport nem létezik",
"User doesnt exist" => "A felhasználó nem létezik",
"Permision denied" => "Hozzáférés megtagadva...",
"subject" => "tárgy",
"date" => "dátum",
"mark" => "jelöl",
"posted by" => "szerző",
"Use page description" => "Oldalak leírásának felhasználása",
"Show page title" => "Oldalcímeket megjelenítem",
"Users can lock pages (if perm)" => "Felhasználók zárolhatják a lapokat (engedéllyel)",
"Use WikiWords" => "WikiWords használata",
"Maximum number of versions for history" => "A történelemben max nyilvántortott verziók száma",
"Never delete versions younger than days" => "Soha ne törölj olyan verziót ami fiatalabb ennyi napnál",
"Old vers" => "Régi verzió",
"Add or edit event" => "Esemény hozzáadása/szerkesztése",
"merge selected notes into" => "kiválasztott jegyzetek egyesítése ebbe:",
"Missing title or body when trying to post a comment" => "Hiányzó cím vagy szöveg komment küldése közben",
"PortuguÁªs" => "portugál",
"Show Categories" => "Kategóriák megjelenítése",
"Hide Categories" => "Kategóriák elrejtése",
"categorize this object" => "az objektum kategorizálása",
"Medium" => "Közepes",
"Critical" => "Kritikus",
"Planning" => "Tervezés",
"Conducted" => "Megtartva",
"Ongoing" => "Folyamatban",
"Scheduled" => "Ütemezve",
"Planning in progress" => "Tervezés alatt",
"Admin DSN" => "DSN adatbáziskapcsolatok beállítása",
"tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
"Mini calendar" => "Mini naptár",
"Send pages" => "Oldalak küldése",
"Received pages" => "Oldalak fogadása",
"Create/Edit blog" => "Blog létrehozása/szerkesztése",
"Browse directory" => "Könyvtár böngészése",
"List quizzes" => "Kvízek listázása",
"List trackers" => "Űrlapok listázása",
"Ephemerides Admin" => "Napi idézetek adminisztrálása",
"Charts Admin" => "Slágerek adminisztrálása",
"I forgot my pass" => "Elfelejtettem a jelszót",
"pass" => "jelszó",
"Page generated in" => "A lap elkészült",
"Homework" => "Házifeladat",
"Assignments" => "Feladatok",
"Favorites" => "Kedvencek",
"Minor" => "Kisebb",
"This is" => "Ez a",
"by the" => "fejleszti a",
"Tiki community" => "Tiki közösség",
"Blog level comments" => "Blog szint kommentek",
"Post level comments" => "Poszt szint megjegyzések",
"Spellchecking" => "Helyesírás ellenőrzése",
"Default ordering for blog listing" => "Bloglista alapértelmezett sorrendje",
"Blog listing configuration (when listing available blogs)" => "Rendelkezésre álló blogok listázásának beállítása",
"Blog comments settings" => "Blogok kommentjeinek beállítása",
"CMS features" => "CMS tulajdonságok",
"Use templates" => "Sablon használata",
"Maximum number of articles in home" => "A cikkek maximális száma a főoldalon",
"Article comments settings" => "Cikkek kommentjeinek beállítása",
"Copyright Management" => "Szerzői jogok kezelése",
"License Page" => "Licensz lap",
"Submit Notice" => "Megjegyzés küldése",
"Content Features" => "Tartalomszerkesztési funkciók",
"Uploaded filenames must match regex" => "A feltöltött fájl nevének egyeznie kell a kifejezéssel",
"Uploaded filenames cannot match regex" => "A feltöltött fájl neve nem egyezhet a kifejezéssel",
"File galleries comments settings" => "Fájlgalériák kommentjeinek beállítása",
"Forum quick jumps" => "Fórum gyors ugrások",
"Ordering for forums in the forum listing" => "Fórumok listázásának beállítása",
"Forum listing configuration" => "Fórumok listázásának tulajdonságai",
"Use URI as Home Page" => "URI használata kezdőlapként",
"Use cache for external images" => "Cache használata a külső képekhez",
"Use gzipped output" => "Gzippelt kimenet használata",
"Sender Email" => "Küldési E-mail cím",
"contact feature disabled" => "kapcsolattartás kikapcsolva",
"User registration and login" => "Felhasználói bejelentkezés és regisztráció",
"Use WebServer authentication for Tiki" => "Webszerver azonosítás használata a Tiki-hez",
"Request passcode to register" => "Ezen kód kérése regisztrációnál",
"Prevent automatic/robot registration" => "Automata/robot regisztráció megelőzése",
"Validate users by email" => "Felhasználók validálása E-mailben",
"Store plaintext passwords" => "Jelszó tárolása sima szövegként",
"Reg users can change language" => "Regisztrált felhasználók megváltoztathatják a nyelvet",
"Available languages:" => "Jelenlegi nyelvek:",
"Force to use chars and nums in passwords" => "Betűk és számok is kötelezőek a jelszóban",
"Minimum password length" => "Jelszó minimális hossza",
"Password invalid after days" => "Jelszó elévülési ideje",
"Remember me feature" => "Emlékezz rám szolgáltatás",
"Duration:" => "Időtartam:",
"Create user if not in Tiki?" => "Felhasználó létrehozása, ha nincs Tikiben?",
"Create user if not in Auth?" => "Felhasználó létrehozása ha nincs az Auth-ban?",
"Just use Tiki auth for admin?" => "Csak Tiki azonosítást használjunk az adminisztrátornak?",
"restore" => "visszaállítás",
"Wiki Features" => "Wiki szolgáltatások",
"Admin banning tpl" => "Kitiltások ",
"Create/edit Calendars" => "Naptárak létrehozása/szerkesztése",
"charts" => "slágerlisták",
"Chat Administration" => "Csevegés adminisztrálása",
"Create/edit channel" => "Csatorna létrehozása/szerkesztése",
"second" => "másodperc",
"Chat channels" => "Chat csatornák",
"Admin Webmail" => "Webmail adminisztrálása",
"Assign Module" => "Modul hozzárendelése",
"subscribed" => "előfizetve",
"EMail notifications" => "E-mailes értesítések",
"Admin Polls Template" => "Szavazás sablon szerkesztése",
"Admin RSS modules" => "RSS modulok adminisztrálása",
"Edit this RSS module:" => "Ezen RSS modul szerkesztése:",
"Create new RSS module" => "Új RSS modul készítése",
"Score System" => "Pontozási rendszer",
"Edit survey questions" => "Kérdőív kérdések szerkesztése",
"this survey stats" => "ennek a kérdőívnek a statisztikáa",
"Create/edit questions for survey" => "Kérdőív kérdések létrehozása/szerkesztése",
"system admin" => "rendszer adminisztrátor",
"Active?" => "Aktív?",
"Create/Edit Trackers" => "Űrlapok létrehozása/szerkesztése",
"Again" => "Mégegyszer",
"Assign permissions to group" => "Jogosultságok megadása csoportnak",
"Browse gallery" => "Galéria böngészése",
"Upload from disk" => "Feltöltés lemezről",
"Browsing Gallery" => "Galériák böngészése",
"Browsing Image" => "Képek böngészése",
"Again please" => "Mégegyszer",
"Edit Article" => "Cikk szerkesztése",
"Edit Blog Tpl" => "Blog sablon szerkesztése",
"bold" => "félkövér",
"Edit Translations" => "Fordítások szerkesztése",
"Edit Translations Template" => "Fordítási sablon szerkesztése",
"back to forum" => "vissza a fórumba",
"hist" => "előzmények",
"Subscribe to This Newsletter" => "Előfizet",
"Received Articles" => "Fogadott cikkek",
"Return to HomePage" => "Vissza a főoldara",
"Rename page" => "Oldal átnevezése",
"theme" => "stílus",
" or upload a local image from your disk" => " vagy egy helyi kép feltöltése a merevlemezről",
"Add new mail account" => "Új postaláda hozzáadása",
"User accounts" => "Felhasználói fiókok",
"Minor Edit" => "Kisebb módosítás",
"You can not download files" => "Magasabb szintű jogosultágra van szükség fájlok letöltéséhez",
" successfully sent" => " sikeresen elküldve",
" not sent" => " nem lett elküldve",
"Please wait 2 minutes between posts" => "Posztok feladása között legalább 2 percnek el kell telnie!",
"I18n setup" => "i18n beállításai",
"Default Language" => "Alapértelmezett nyelv",
"Available languages (Ctrl+Click to select multiple languages):" => "Rendelkezésre álló nyelvek (CTRL lenyomva tartásával több nyelv is kiválasztható)",
"Show Babelfish Translation URLs" => "Babelfish fordítás URL megjelenítése",
"Show Babelfish Translation Logo" => "Babelfish fordítás logó megjelenítése",
"More Links" => "További linkek",
"Stats &amp;amp; banners" => "Statisztikák &amp; bannerek",
"Im- Export Languages" => "Nyelvek exportálása/importálása",
"To learn more, visit: &lt;a href=\"http://www.tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\"&gt;http://www.tikiwiki.org&lt;/a&gt;" => "Minden a TikiWikirol itt: http://www.tikiwiki.org",
"%a %d sorrendje %b, %Y %H:%M %Z" => "%a %d %b, %Y %H:%M %Z ",
"%a %d sorrendje %b, %Y" => "%a %d %b, %Y",
"Hold down CTRL to select multiple categories" => "CTRL lenyomva tartásával több kategória is kiválasztható",
"Show Plugins Help" => "Plugin súgó megjelenítése",
"PortuguÃªs" => "portugál",
"%a %d %b, %Y %H:%M %Z" => "%a %d %b, %Y %H:%M %Z ",
"%a %d %b, %Y" => "%a %d %b, %Y",
"Portugus" => "portugál",
"Wiki Comments Settings" => "Wiki komment beállítása",
"Default number of comments per page:" => "Kommentek alapértelmezett száma oldalanként:",
"List displayed by default" => "Lista megjelenítésre kerül alapértelmezés szerint",
"Use database to store files:" => "Fájlok tárolása adatbázisban:",
"Use a directory to store files:" => "Fájlok tárolása könytárban:",
"Wiki Administration" => "Wiki adminisztráció",
"No articles." => "Nincsenek cikkek",
"(like en)" => "(pld: hu)",
"(like English)" => "(pld: Magyar)",
"Edit Summary" => "Összefoglaló szerkesztése",
"Sandbox:" => "Homokozó:",
"Anonymous editors must input anti-bot code:" => "Anonim szerkesztőknek anti-bot kódot kell megadniuk:",
"Last changes:" => "Legutóbbi változások:",
"Export:" => "Exportálás:",
"Rating:" => "Értékelés:",
"History:" => "Előzmények:",
"View source:" => "Forrás megtekintése:",
"List pages:" => "Oldalak listázása:",
"Backlinks:" => "Ide mutató linkek:",
"Similar:" => "Hasonló:",
"Rankings:" => "Rangsor:",
"Save Draft:" => "Piszkozat mentése:",
"Comments:" => "Kommentek:",
"Wiki Home Page" => "Wiki kezdőlap",
"Allow HTML:" => "HTML engedélyezése:",
"Edit section:" => "Szekció szerkesztése:",
"Print Page:" => "Oldal nyomtatása:",
"Wiki History" => "Wiki története:",
"Wiki attachments:" => "Wiki mellékletek:",
"Pictures:" => "Képek:",
"Footnotes:" => "Lábjegyzet:",
"Users can lock pages (if perm):" => "Felhasználók zárolhatják az oldalakat (megfelelő jogosultsággal)",
"Individual cache:" => "Egyedi cache:",
"Comment length:" => "Komment hossza:",
"Send link to" => "Link küldése",
"User list" => "Felhasználók listáa",
"Workspaces" => "Munkaterületek",
"Admin Workspaces" => "Munkaterületek adminisztrálása",
"Workspace Types" => "Munkaterület típusok",
"Multiple Print" => "Tömeges nyomtatás",
"New article" => "Új cikk",
"Confirm new password:" => "Új jelszó megerősítése:",
"Current password (required):" => "Jelenlegi jelszó (kötelező):",
"Email address:" => "E-mail cím:",
"Shortname must be 2 characters" => "A rövid név 2 karakter hosszÚ legyen (pld \"hu\")",
"like en" => "pld: hu",
"like English" => "pld: Magyar",
"(optional)" => "(opcionális)",
"Exact&amp;nbsp;match" => "Pontosan egyezzen",
"Undo:" => "Visszaállítás (undo):",
"Tag name:" => "Címke neve:",
"Restore the Wiki" => "Wiki visszaállítása",
"Remove a Tag" => "Címke eltávolítása",
"Create a Tag for the Current Wiki" => "Címke létrehozása a jelenlegi Wiki számára",
"Spellchecking:" => "Helyesírás ellenőrzése:",
"Use templates:" => "Sablonok használata:",
"Warn on edit conflict:" => "Figyelmeztetés szekesztési ütközés esetén:",
"Show page title:" => "Oldal nevének megjelenítése:",
"Show page ID:" => "Oldal azonosítójának megjelenítése:",
"Use WikiWords:" => "WikiWord használata:",
"Import HTML:" => "HTML importálása:",
"Accept dashes and underscores in WikiWords:" => "Kötőjel és alulvonás elfogadása WikiWord-ben:",
"Link plural WikiWords to their singular forms:" => "WikiWord többesszámú formátumának az egyesszámúhoz kötése:",
"Use Wiki paragraph formatting:" => "Wiki bekezdésformázás használata:",
"To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "Wiki oldalok gyors szerkesztéséhez használjuk a quick_edit modult mely elérhető a \"Modulok\" menüpont alatt az alkalmazás fő menüjében, vagy",
"But still create line breaks within paragraphs:" => "De hozzon létre sortörést bekezdéseken belül:",
"Automonospaced text:" => "Automonospace szöveg:",
"Tables syntax:" => "Tábla szintaxis:",
"\\n for rows" => "\\n sorokhoz",
"Uses Slideshow:" => "Bemutató használata:",
"Open page as structure:" => "Oldal megnyitása struktúraként:",
"Make structure from page:" => "Struktúra készítése oldalból:",
"Categorize structure pages together:" => "Struktúra oldalainak összekategorizálása:",
"Show page version:" => "Oldal verziójának megjelenítése:",
"Maximum number of versions for history:" => "Verziók maximális száma az előzményeknél:",
"Never delete versions younger than days:" => "Ennyi napnál frissebb oldalak törlése nem lehetséges:",
"IP address displayed in history:" => "IP cím megjelenítése az előzményekben:",
"Diff style:" => "Eltérés stílusa:",
"History only for data, description, comment change" => "Csak adat, leírás és komment változásainak története",
"Wiki Watch" => "Wiki figyelése",
"Create watch for author on page creation:" => "Oldal létrehozója automatikusan figyeli az oldalt:",
"Enable watch events when I am the editor:" => "Események figyelése ha én vagyok a szerkesztő:",
"Enable watches on comments:" => "Kommentek figyelése:",
"Wiki Page List Configuration" => "Wiki oldalak listázásának beállítása",
"Import Page:" => "Oldal importálása:",
"Page creators are admin of their pages:" => "Oldalak létrehozói saját oldalaik adminisztrátorai:",
"Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./fixperms fix\" for example)." => "Az Apache-nak írási joga van a fájlstruktúrához mely lehetővé teszi a csomagok telepítését, eltávolítását és frissítését. Ha befejeztük a műveleteket akkor tegyük ismét biztonságossá ezeket a jogosultságokat (pld a \"./fixperms fix\" használatával).",
"To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that permission (using \"./fixperms fix\")." => "Csomagok telepítéséhez, eltávolításához vagy frissítéséhez az Apache számára írási jogosultságot kell adni a webes fájlstrultúrához (használhatjuk a \"./fixperms.sh open\" szkriptet). Telepítés után el kell távolítani a jogosultságot (használjuk a \"./fixperms fix\" szkriptet).",
"my tiki tpl" => "my tiki tpl",
"Admin mods" => "Mods adminisztráció",
"will have all the permissions of the included groups." => "a tartalmazott csoportok összes jogosultságát meg fogja kapni",
"the included groups" => "a tartalmazott csoportok összes jogosultságát meg fogja kapni",
"Group Theme:" => "Csoport stílusa",
"Enable now." => "Bekapcsolás most",
"User must change his password at first login" => "A felhasználónak meg kell változtatnia a jelszavát az első bejelentkezéskor",
"Browse..." => "Tallózás...",
"Browse.." => "Tallózás..",
"Browse." => "Tallózás.",
"Browse ..." => "Tallózás...",
" Browse ..." => "Tallózás...",
"More criteria" => "További kritériumok",
"SysLog" => "Rendszerlog",
"Directories to save:" => "Mentendő könyvtárak",
"(Hide)" => "(Elrejtés)",
"security admin" => "biztonsági beállítások",
"security admin tpl" => "security admin tpl",
"Tikiwiki settings" => "Tikiwiki beállítások",
"Theme Control Center: categories" => "Stílusvezérlés: kategóriák",
"ThemeControl" => "Stílusvezérlés",
"ThemeControl tpl" => "ThemeControl tpl",
"To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "Stílustémákról bővebben itt: <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">Stílusok</a>.",
"ThemeControl Objects" => "Stílusvezérlés objektumokon",
"theme control objects tpl" => "theme control objects tpl",
"Theme Control Center: sections" => "Stílusvezérlés: szekciók",
"theme control sections tpl" => "theme control sections tpl",
"html page" => "html oldal",
"mytiki" => "myOiT",
"tiki admin quicktags template" => "tiki admin quicktags template",
"Show Text Formatting Rules" => "Szövegformázási szabályok megjelenítése",
"italic" => "dőlt",
"underline" => "aláhúzás",
"heading2" => "címsor 2",
"heading3" => "címsor 3",
"hr" => "táblasor",
"list numbers" => "számozott lista",
"list bullets" => "felsorolásos lista",
"Email Address" => "E-mail cím",
"Label:" => "Címke:",
"Icon:" => "Ikon",
"newsletters" => "hírlevelek",
"maps" => "térképek",
"Admin RSSmodules Template" => "RSS modul sablon adminisztrálása",
"Exact match" => "Pontos egyezés",
"Exact match " => "Pontos egyezés",
"Allow Smileys" => "Smiley-k engedélyezése",
"Show quicktags over textareas (instead on left side)" => "Quicktag-ek megjelenítése szöveges területek felett (és nem a bal oldalon)",
"Default number of rows (wiki)" => "Sorok alapértelmezett száma (wiki)",
"Default number of rows (comments)" => "Sorok alapértelmezett száma (kommentek)",
"Default number of rows (forum)" => "Sorok alapértelmezett száma (fórum)",
"Default number of rows (forum replies)" => "Sorok alapértelmezett száma (fórum válaszok)",
"Use File Galleries for images inclusion" => "Fájlgaléria használata képek felhasználásakor",
"Hotwords in New Windows" => "Hotword új ablakban",
"Help on Text area Config" => "Szöveges terület súgó",
"Right &amp; left boxes" => "Modulok a jobb &amp; bal oldalon megjelenő különféle dobozok",
"Administer modules" => "Modulok adminisztrálása",
"Show Module Controls" => "Modul kontrollok megjelenítése",
"Users can Configure Modules" => "Felhasználók konfigurálhatják a modulokat",
"Users can Shade Modules" => "Felhasználók elrejthetik a modul tartalmát",
"module decides" => "modul dönt",
"Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS modules</strong> menu option, or" => "Ezen az oldalon lehet a Tiki által generált RSS feed-eket beállítani. RSS feed-ek szindikálására más weblapokról használjuk az <strong>Adminisztráció</strong> &gt; <strong>RSS modulok</strong> menüpontot, vagy",
"Help on RSS feeds Config" => "Súgó az RSS feed-ek beállításához",
"seconds (0 = cache inactive)" => "másodperc (0 = cache inaktív)",
"Parse the result (can be slow)" => "Eredmény elemzése (lassú lehet)",
"Database Search using MySQL 'Full-Text' Feature" => "Adatbázis keresése a MySQL 'Full-Text' funkció használatával",
"Activate MySQL Full-Text feature" => "MySQL Full-Text funkció aktiválása",
"Activate MySQL 'Full-Text' feature" => "MySQL 'Full-Text' funkció aktiválása",
"Performance issues" => "Teljesítmény tényezők",
"Database Independent Full Text Search or Tiki Search" => "Adatbázisfüggetlen teljes szöveg keresés vagy másnéven Tiki keresés",
"This is activated by default if MySQL 'Full-Text' feature is not activated above" => "Ez automatikusan aktiválásra kerül ha a MySQL 'Full-Text' funkció nincs aktiválva",
"Search features" => "Keresési funkciók",
"SearchStats" => "Keresési statisztika",
"Settings for searching content" => "Tartalom keresésének beállításai",
"Search refresh mode" => "Keresés frissítésének módja",
"Search refresh rate" => "Keresés frissítésének gyakorisága",
"0 for no refresh" => "0 a frissítés mellőzéséhez",
"User identity features" => "Funkciók felhasználó azonosításához",
"Users sort order" => "Felhasználók rendezésének sorrendje",
"Meta Keywords" => "Meta kulcsszavak",
"Insert freetags in keyword list" => "Freetag-ek (címkék) beszúrása kulcsszólistába",
"Use the thread title in Forum pages instead" => "A fórumtéma címének használata a fórumoldalakon",
"Use the image title in Image gallery pages instead" => "Kép címének használata a képgaléria oldalakon",
"Meta Description" => "Meta leírás",
"Meta Author" => "Meta szerzője",
"Geourl" => "Geourl",
"meta robots" => "meta robotok",
"revisit after" => "újralátogatás ennyi után",
"... but need admin validation" => "... de adminisztrátori validálás szükséges",
"You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "Be kell állítani a <a href=\"tiki-admin.php?page=general\">Küldési E-mail cím</a>et",
"Create a group for each user <br />(with the same name as the user)" => "Csoport létrehozása minden egyes felhasználóhoz <br />(a felhasználói névvel megegyező néven)",
"Use tracker for more user information" => "Űrlap használata további felhasználói információk gyűjtéséhez",
"Use tracker for more group information" => "Űrlap használata további csoportinformációk gyűjtéséhez",
" - Php GD library required" => " - Php GD könyvtár szükséges",
"Use login as email" => "Bejelentkezési név használata E-mailként",
"Validate user email server" => "Felhasználói E-mail szerver validálása",
"Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Jelszóemlékeztető E-mailben (ha a \"sima szöveges jelszó\" aktiválásra került) - egyébként E-mailen keresztüli jelszóváltoztatás",
"Crypt passwords method" => "Jelszótitkosítás módszere",
"Reg users can change password" => "Regisztrált felhasználók megváltoztathatják a jelszavukat",
"Restrict available languages" => "Rendelkezésre álló nyelvek korlátozása",
"Minimum username length" => "Felhasználói név minimális hossza",
"Maximum username length" => "Felhasználói név maximális hossza",
"Force lowercase username" => "Kisbetűs felhasználói nevek erőltetése",
"-1 for never" => "ha soha akkor: -1 ",
"Re-validate user by email after days" => "Felhasználó újravalidálása E-mailen ennyi nap után",
"Re-validate user by email after unsuccessful logins" => "Felhasználó újravalidálása E-mailen ennyi sikertelen bejelentkezés után",
"Generate a password option" => "Jelszógenerálás lehetősége",
"Consider we are in always in HTTPS, but do not check" => "Vegye úgy hogy mindig https-ben vagyunk de ne ellenőrizze",
"Remember me name" => "Emlékezz rám Név",
"Remember me domain" => "Emlékezz rám Domain",
"Remember me path" => "Emlékezz rám Útvonal",
"Protect against CSRF with a confirmation step" => "CSRF elleni védekezés megerősítési lépéssel",
"Highlight Group" => "Csoport kiemelése",
"User can choose beyond these groups at registration time" => "A felhasználó ezen csoportok közül választhat regisztrációkor",
"Specify the fields that will be asked in admin->groups" => "Meg kell határozni azon mezőket amelyek szükségesek az admin->csoportoknál",
"Displays user's contribution in the user information page" => "Felhasználó hozzájárulásainak megjelenítése a felhasználó információs oldalán",
"Displays UserTracker information in user information page. Format: trackerId, fieldId1, fieldId2, …" => "Felhasználói űrlap információk megjelenítése a felhasználói oldalon. Formátum: trackerId, fieldId1, fieldId2, …",
"Deactivate login autocomplete (do not remember login and password)" => "Bejelentkezés automatikus kiegészítésének deaktiválása (ne emlékezzen bejelentkezési névre és jelszóra)",
"On permission denied, display login box for anonymous:" => "Elegendő jogosultság hiánya esetén bejelentkezési ablak megjelenítése az anonim látogatóknak:",
"On permission denied, send to this url:" => "Elegendő jogosultság hiánya esetén elküldés erre az URL-re:",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(ha beállítjuk akkor felülbírálja az alábbi Host-ot és Port-ot)",
"LDAP Host" => "LDAP Host",
"LDAP Port" => "LDAP Port",
"LDAP Scope" => "LDAP Scope",
"LDAP Base DN" => "LDAP Base DN",
"LDAP User DN" => "LDAP User DN",
"LDAP User Attribute" => "LDAP User Attribute",
"LDAP User OC" => "LDAP User OC",
"LDAP Group DN" => "LDAP Group DN",
"LDAP Group Attribute" => "LDAP Group Attribute",
"LDAP Group OC" => "LDAP Group OC",
"LDAP Member Attribute" => "LDAP Member Attribute",
"LDAP Member Is DN" => "LDAP Member Is DN",
"LDAP Admin User" => "LDAP Admin felhasználó",
"LDAP Admin Pwd" => "LDAP Admin jelszó",
"LDAP Version" => "LDAP verzió",
"LDAP Realname Attribute" => "LDAP Realname Attribute",
"CAS server hostname" => "CAS szerver hostname",
"CAS server port" => "CAS szerver port",
"CAS server path" => "CAS szerver útvonal",
"Change CAS preferences" => "CAS preferenciák megváltoztatása",
"Valid Affiliations (separated by commas)" => "Valid belépések (vesszokkel elválasztva)",
"Create with default group?" => "Létrehozás alapértelmezett csoporttal?",
"Default group: " => "Alapértelmezett csoport: ",
"Change Shibboleth preferences" => "Shibboleth preferenciák megváltoztatása",
"Users Defaults" => "Felhasználói alapértelmezések",
"Detect user timezőne if browser allows, otherwise site default" => "Felhasználói időzóna felismerése ha a böngésző megengedi, egyébként a weblap alapértelmezettje",
"Change users defaults" => "Felhasználói alapértelmezések megváltoztatása",
"Technology" => "Technológia",
"Extra Stuff &amp; Fun" => "Extra cucc &amp; móka",
"Content Related" => "Tartalomhoz kapcsolódó",
"Feature documentation links" => "Funkció dokumentáció link",
"Help System (Feature documentation links)" => "Súgó rendszer (Funkció dokumentáció linkek)",
"Technical Features" => "Technikai funkciók",
"Swffix" => "Swffix",
"Contact Us (Anonymous)" => "Kapcsolatfelvétel (anonim)",
"Tikiwiki version" => "Tikiwiki verzió",
"OS" => "OS",
"Log Mail in Tiki Logs:" => "Levél loggolása Tikiben:",
"Log SQL:" => "SQL loggolása:",
"Default charset for sending mail:" => "Levélküldés alapértelmezett karakterkészlete:",
"Mail end of line:" => "Levél Mail end of line:",
"Disallow access to the site (except for those with permission)" => "Weblaphoz történő hozzáférés letiltása (kivéve a jogosultsággal rendelkezőket)",
"Message to display when site is closed" => "Mikor a weblap le van zárva ez az üzenet jelenik meg",
"Disallow access when load is above the threshold (except for those with permission)" => "Weblap elérésének letiltása ha a szerver terheltsége a küszöbétrék felett van (kivéve a jogosultsággal rendelkezőket)",
"Max average server load threshold in the last minute" => "Maximum átlagos szerverterheltségi küszöb az elmúlt percben",
"Message to display when server is too busy" => "Szerver túlterhelése esetén megjelenítendő üzenet",
"output compression is active." => "a kimeneti tömörítés aktív",
"compression is handled by" => "a tömörítés kezelője",
"Allow anonymous users to \"Contact Us\"" => "Anonim felhasználók számára engedélyezett a \"kapcsolatfelvétel\"",
"Session lifetime in minutes" => "Munkamenet élettartama percekben",
"Proxy Host" => "Proxy Host",
"Proxy port" => "Proxy Port",
"Please expect not found help-pages with the default-URL." => "A nem talált súgó oldalak az alapértelmezett URL-re mutatnak",
"Any help with the documentation is welcome." => "Minden dokumentációs segítségnek örülünk :)",
"Release check" => "Release ellenőrzése",
"Release checks are made when you browse admin main page only" => "Release ellenőrzése csak a fő adminisztrációs oldal böngészésekor történik",
"Force immediate check" => "Azonnali ellenőrzés erőltetése",
"When possible, show the real user name instead of login:" => "Amikor csak lehetséges mutassuk az igazi nevet a felhasználói név helyett:",
"Locations separator" => "Lokációk szeparátora",
"Choices separator" => "Választási lehetőségek szeparátora",
"Preference syntax" => "Preferencia szintakszis",
"Login as..." => "Bejelentkezés mint...",
"Home Forum" => "Kezdőfórum",
"Forums features" => "Fórum funkciók",
"Enable topics archiving" => "Téma arhíválás aktiválása",
"Allow first posts of a thread to have an empty body (will be a thread title)" => "Fórumtéma első hozzászólása lehet üres (így ez lesz a fórumtéma neve)",
"Reply posts are empty" => "Válasz hozzászólások üresek",
"Search some forums by name (on \"forum list\")" => "Fórumok keresése név alapján (a \"fórum listán\")",
"Search some forums by content on \"forum list\" (needs feature_search activated)" => "Fórumok keresése tartalom alapján a \"fórum listán\" (szükséges a feature_search aktiválása)",
"Search in topics content on forum page (needs feature_search activated)" => "Keresés témák tartalmában a fórum oldalon (szükséges a feature_search aktiválása)",
"Search method when searching in content: Tiki search local to a forum" => "Keresési módszer tartalom keresésekor: Tiki keresés lokálisan fórumhoz",
"Search method when searching in content: Non-Tiki search local to a forum" => "Keresési módszer tartalom keresésekor: Nem-Tiki keresés lokálisan fórumhoz",
"Threads default preferences" => "Fórumtémák alapértelmezett beállítása",
"Allow to manage thread defaults in each forum configuration" => "Fórumtémák alapértelmezésének kezelése fórumonként",
"Display thread configuration bar to override defaults" => "Fórumtéma konfigurációs sor megjelenítése az alaéprtelmezések felülírásához",
"Configuration bar settings are kept for all forums during the user session:" => "A konfigurációs sor beállításai megmaradnak az összes fórumnál a felhasználó munkamenete alatt:",
"Default thread style" => "Alapértelmezett fórumtéma stílus",
"Default thread sort mode" => "Alapértelmezett fórumtéma rendezési mód",
"only queries using more than seconds" => "csak az ennyi másodpercnél hosszabb lekérdezések esetén",
"Editing:" => "Szerkesztés:",
"Get Forum List" => "Fórumlista importálása",
"Editing posts:" => "Posztok szerkesztése",
"%s - Version %d of this page has been saved by %s." => "%s - Oldal verzió: %d - Mentette: %s",
"Edit/Create" => "Létrehozás/szerkesztés",
"Use categories to regroup various Tiki objects" => "Kategóriák segítségével lehet a különböző Tiki objektumokat csoportosítani",
"Link to" => "Link:",
"Show Category Path" => "Kategória útvonalának megjelenítése",
"Exclude These Category IDs from Path (comma delimited)" => "Ezeb kategória azonosítók kizárása az útvonalból (vesszővel elválasztva)",
"Show Category Objects" => "Kategória objektumainak megjelenítése",
"Search may show forbidden results. Much better performance though." => "A keresés tiltott eredményeket is megmutathat (viszont sokkal pontosabb)",
"Categories browse uses PhpLayers" => "Kategóriák tallózásához PhpLayers használata",
"The feature must be activated" => "A funkciót aktiválni kell",
"Use the Administration page of each enabled feature to allow the use of content templates" => "A bekapcsolt funkciók saját adminisztrációs oldalán lehet engedélyezni a sablonok használatát",
"Use the Administration page of each enabled feature to allow the use of content templates." => "A bekapcsolt funkciók saját adminisztrációs oldalán lehet engedélyezni a sablonok használatát",
"Admin Content Templates Template" => "Tartalomsablonok sablonjának adminisztrálása",
"Image Gallery tpl" => "Képgaléria sablon (Image Gallery tpl)",
"Batch upload" => "Tömeges (kötegelt) feltöltés",
"Vew inserted gallery" => "Beillesztett galéria megtekintése",
"Create a file gallery" => "Fájlgaléria létrehozása",
"To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "Fájlgalériák hozzáadásához /eltávolításához lásd a \"Fájlgalériák\" menüpontot az alkalmazás fő menüjében, vagy",
"File author" => "Fájl szerzője",
"For not registered author" => "Nem regisztrált szerző",
"PodCast directory (must be web accessible):" => "PodCast könyvtár (weben keresztül elérhetőnek kell lennie):",
"File galleries search indexing" => "Fájlgalériák keresési indexelése",
"Leave command blank to delete handler" => "Hagyjuk a parancsot üresen a kezelő törléséhez",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Használjuk a %1 formulát ott ahol belső fájlnevet kell kicserélni (például: \"strings %1\" megadásával konvertálhatjuk a dokumentum szövegét a unix-os 'strings' parancs segítségével)",
"Enable auto indexing on file upload or change" => "Automatikus indexálás bekapcsolása fájlfeltöltés vagy változtatás esetén",
"System command" => "Rendszer parancs",
"Freetag Browsing" => "Címkék böngészése",
"Uncheck the above checkbox to uncategorize this page/object" => "Az objektum kategóriá(k)ból történő eltávolításához vegyük ki a pipát a fenti jelölőnégyzetből",
"Removed version" => "Verzió eltávolítva",
"(Only .gif images, and aproximately 45px x 45px)" => "(csak .gif képek, kb 45px x 45px méretben)",
"page last modified on" => "Oldal legutóbbi módosítása:",
"User Watches tpl" => "Felhasználó figyelései tpl",
"watched events" => "figyelemmel követett esemény",
"Watch language wiki page creations" => "Adott nyelvű wiki oldalak létrehozásának figyelése",
"Add watch" => "Figyelés hozzáadása",
"Admin Directory tpl" => "Könyvtár admin (admin directory) tpl",
"Admin category relationships" => "Kategória kapcsolatok adminisztrálása",
"Validate links" => "Linkek validálása",
"Admin Directory Categories tpl" => "Admin Directory Categories tpl",
"Admin Directory Related " => "Kapcsolódó könyvtár adminisztrálása",
"directory admin related tpl" => "directory admin related tpl",
"Admin Directory Sites" => "Könyvtári weblapok adminisztrálása",
"Admin Directory Sites tpl" => "Admin Directory Sites tpl",
"Validate Sites" => "Weblapok validálása",
"directory validate sites tpl" => "directory validate sites tpl",
" on " => " Dátum: ",
"Global post-level comments is disabled" => "Globális poszt szintű kommentelés jelenleg nincs aktiválva",
"Global post-level comments is disabled." => "Globális poszt szintű kommentelés jelenleg nincs aktiválva",
"Watch minor" => "Kisebb változások figyelése",
"Enable Feature for Wiki" => "Funkció aktiválása wikihez",
"Enable Feature for Articles" => "Funkció aktiválása cikkekhez",
"Enable Feature for Blogues" => "Funkció aktiválása blogokhoz",
"Enable Feature for Bloges" => "Funkció aktiválása blogokhoz",
"Enable Feature for Faqs" => "Funkció aktiválása GYIK-ekhez",
"Jan" => "Jan.",
"Feb" => "Febr.",
"Mar" => "Márc.",
"Apr" => "Ápr.",
"Jun" => "Jún",
"Jul" => "Júl.",
"Aug" => "Aug.",
"Sep" => "Szept.",
"Oct" => "Okt.",
"Nov" => "Nov.",
"Dec" => "Dec.",
"Enable Smarty Security (e.g. do not allow php code in smarty templates):" => "Smarty biztonság bekapcsolása (pld nem enged php kódot smarty sablonban):",
"Enable Smarty Security (e.g. do not allow php code in smarty templates)" => "Smarty biztonság bekapcsolása (pld nem enged php kódot smarty sablonban)",
"Use @version:x.x specified in theme css or 1.8 if not specified" => "Használja a téma css-ben megadott @verzió:x.x-t vagy az 1.8-at ha nincs semmi megadva",
"Required for all the following features" => "Az összes alábbi funkcióhoz szükséges",
"Site Logo" => "Weblap logója",
"Note: This feature also requires PHPLayers to be turned on in " => "Megjegyzés: a funkció használatához be kell kapcsolni a PHPlayers funkciót",
"Prefix breadcrumbs with 'Location : ' " => "Útmutató kenyérmorzsák elé tegye oda hogy 'Lokáció: '",
"Use context menus for actions (icons) (only in file galleries yet)" => "Kontextusmenük használata akciókhoz (ikon) (egyelőre még csak fájlgalériáknál)",
"Use context menus for actions (text) (only in file galleries yet)" => "Kontextusmenük használata akciókhoz (szöveg) (egyelőre még csak fájlgalériáknál)",
"Required for many of the general layout features" => "Szükséges a legtöbb általános stílus funkcióhoz",
"Faq Stats" => "Gyik statisztika",
"Print article" => "Cikk nyomtatása",
"Can specify notification emails when creating an article" => "Értesítési E-mail cím megadásának lehetősége cikk létrehozásakor",
"Settings for page articles home" => "Cikkek kezdőlapjának beállításai",
"Fields to display on page" => "Megjelenítendő mezők ezen az oldalon:",
"Expire Date" => "Lejárat dátuma",
"Title length:" => "Cím hossza",
"Article Types tpl" => "Article Types tpl",
"show help" => "Súgó megjelenítése",
"Delete this type" => "Ezen típus törlése",
"Will display using the indicated HTML color or color name" => "A megadott HTML színkódnak vagy színnévnek megfelelő színben jeleníti meg a szöveget",
"~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc)}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>témanév, topicId=>témaid, type=>típus, categId=>kategória,  lang=>en, sort=>oszlopnév_növekvő|oszlopnév_csökkenő)}{ARTICLES}~/np~",
"Formula" => "Képlet",
"No formula specified." => "Nincs képlet megadva",
"Impossible to render the graphic." => "Lehetetlen renderelni a grafikát",
"View graphic" => "Grafika megtekintése",
"blogId is mandatory" => "A blogId kötelező",
"Includes blog posts listing into a wiki page" => "Blogposztokat listáz a wiki oldalon",
"~np~{POSTS(max=>5, blogId=>id)}{POSTS}~/np~" => "~np~{POSTS(max=>5, blogId=>id)}{POSTS}~/np~",
" wrote:" => " írta:",
" pages found for title search" => " oldal felelt meg a címkeresési feltételnek",
"pagename is optional; if it is not present, links into the current file." => "Az oldalnév opcionális; ha nincs akkor a jelenlegi fájlra mutat",
"Create Trackers" => "Űrlap létrehozása",
"tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "Űrlap nevánek egyedinek kell lennie, a mezőneveknek egyedinek kell lenniük\negy adott űrlap kapcsán és validnak kell lenniük SQL-ben",
"Tracker Items for" => "Űrlaptételek: ",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Szöveg opciók: '1,size,prepend,append,max (karakter)' ahol 'size' a méretet mutatja karakterek számában kifejezve, 'prepend' hatására a szöveg a mező előtt lesz megjelenítve, 'append' hatására utána, 'max' a menthető karkterek maximális számát korlátozza, '1' hatására a következő mező vagy jelölőnégyzet ugyanabban a sorban fog szerepelni. Ha csak '1'-et adunk meg akkor az azt jelenti hogy a következő mező ugyanabban a sorban fog szerepelni.",
"Textarea options: quicktags,width,height,max,listmax,wordmax - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax is the maximum number of characters that are displayed in list mode, wordmax>0 alert if word count exceeded, wordmax<0 display word count." => "Szöveges terület opciók: 'quicktags,width,height,max,listmax,wordmax' ahol 'quicktags' jelöli hogy használjunk-e quicktag-eket a területnél, értéke lehet 1 vagy 0, 'width' a szélességet jelöli karakterek számában kifejezve, 'height' a magasságot sorok számában kifejezve, 'max' a menthető karakterek maximális száma, 'listmax' a listázási módban megjelenített karakterek maximális számát korlátozza, 'wordmax>0' figyelmeztet ha a szavak száma meghaladja a határt, 'wordmax<0' megjeleníti a szavak számát.",
"Checkbox options: put 1 if you need that next field is on the same row." => "Jelölőnégyzet opciók: tegyünk egy 1-est ha szeretnénk hogy a következő mező is ugyanabban a sorban szerepeljen",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numerikus opciók: '1,size,prepend,append, ahol 'size' a méretet adja meg karakterek számában kifejezve, 'prepend' hatására a jelőlőnégyzet a mező előtt, 'append' hatására a mező után lesz megjelenítve, valamint ha az elején megadjuk az '1'-et akkor a következő szöveges mező vagy jelölőnégyzet ugyanabban a sorban szerepel majd. Ha csak az '1'-et adjuk meg akkor a következő mező is ugyanabban a sorban lesz",
"Dropdown options: list of items separated with commas." => "legördülő opciók: tételek listája vesszővel elválasztva.",
"Default value is specified by having the value indicated twice consecutively" => " Alapértelmezett értéket úgy lehet megadni hogy az értéket egymásután kétszer adjuk meg",
"Radio buttons options: list of items separated with commas." => "Választókapcsoló opciók: tételek listája vesszővel elválasztva.",
"User Selector options: automatic field feeding,email - feeding=1 for author login or feeding=2 for modificator login - email=1 to send an email to the user if the tracker is modified" => "Felhasználóválasztás opciói: 'automatic field feeding,email', ahol ha 'feeding=1' akkor a szerző bejelentkezési neve lesz automatikusan kitöltve, ha 'feeding=2' akkor a módosító bejelentkezési neve, 'email=1' hatására E-mail kerül kiküldésre a felhasználónak ha az űrlapot módosították",
"Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Csoportválasztás opciói: automatikus mezőkitöltéshez használjuk '1'-et a létrehozó csoportjának, '2'-őt a módosító csoportjának megjelenítéséhez. Meg kell adni az alapértelmezett csoportot vagy a felhasználóhoz kapcsolódó első sorbaeső csoport lesz kiválasztva vagy az alapértelmezett 'Registered' csoport",
"IP selector" => "IP kiválasztása",
"IP Selector: use options for automatic field feeding : you can use 1 for author IP or 2 for modificator IP." => "IP kiválasztás opciói: automatikus mezőkitöltéshez használjuk '1'-est a szerző IP-jének,'2'-est a változtató felhasználó IP-jének megjelenítésére",
"Country Selector options: name/flag, sortorder - name/flag is 0,1 or 2 where 1 shows only country name, 2 shows only country flag, 0 shows both (default). sortorder is 0 or 1 where 0 sorts according to translated text (default) and 1 sorts according to english country names even if country names are translated" => "Országválasztás opciói: 'name/flag, sortorder', ahol 'name/flag' értéke lehet 0,1 vagy 2 ('1' csak az országnevet mutatja, '2' csak a zászlót mutatja, '0' mindkettőt - ez utóbbi az alapértelmezett beállítás), 'sortorder' értéke lehet '0' vagy '1' ('0' hatására a lefordított szövegnek megfelelően rendez - ez az alapértelemett beállítás -, '1' hatására az angol országneveknek  megfelelően rendez még ha az országnevek le is vannak fordítva",
"Date Time options: date_time,year0,year1 where date_time=d|dt(default), d displays only date, year0 is the first year, year1 the last" => "Dátum és idő opciók: 'date_time,year0,year1', ahol 'date_time=d|dt(alapértelmezett)' - 'd' csak dátumot jelenít meg, 'dt' dátumot és időt, 'year0' az első év, 'year1' az utolsó",
"Jscalendar options: date_time where date_time=d|dt(default), d displays only date" => "Jscalendar opciók: 'date_time',  ahol  'date_time=d|dt(alapértelmezett)' - 'd' csak dátumot jelenít meg, 'dt' dátumot és időt",
"Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Kép opciók: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale pixelekben kifejezve",
"Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Akció opciók: 'Label,post,tiki-index.php,page:fieldname,highlight=test'",
"Static text options: Wikisyntax,listmax - Use Wikisyntax is 1 or 0, listmax is the maximum number of characters that are displayed in list mode." => "Statikus szöveg opciók: 'Wikisyntax,listmax' ahol 'Wikisyntax' értéke lehet 1 vagy 0, 'listmax' a listázási módban megjelenített karakterek maximális számát jelenti",
"Category options: parentId,d|m|radio|checkbox(default),1|0(default) to have a select all button, d for dropdown, m for multiple drop down" => "Kategória opciók: 'parentId,d|m|radio|checkbox(alapértelmezett érték),1|0(alapértelmezett érték)' összes gomb kiválasztásához, 'd' legördülő menühöz, 'm' többszörös legördülőhöz",
"Item Link options: trackerId,fieldId,linkToItem,displayedfieldslist links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing.  Display displayedfieldslist(separate with |) instead of the target item" => "Tétel link opciók: 'trackerId,fieldId,linkToItem,displayedfieldslist' linkel a 'trackerId'-ből (űrlapazonosítóból) a 'fieldId' (mezőazonosító) mely egyezik azon mező tartalmával. 'linkToItem 1|0' opcióval linket hozunk létre az űrlaptételhez sima vagy listanézet megjelenítésben. A 'displayedfieldslist' segítségével mezőket lehet listázni (|-al elválasztva) a teljes céltétel helyett",
"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Tétel listázási opciók: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems megjeleníti a displayFieldIdThere mezők trackerId űrlap alatti tételekben szereplő listáját ahol fieldIdThere egyezik fieldIdHere értékével. linkToItems 1|0 opcióval linket lehet létrehozni megjelenítési és listázási módban",
"dynamic items list options: trackerId, filterFieldIdThere, filterFieldIdHere, listFieldIdThere, statusThere insert the list of listFieldIdThere from item in tracker trackerId where filterFieldIdThere matches filterFieldIdHere where status is statusThere." => "dinamikus tételek listázási opciói: trackerId, filterFieldIdThere, filterFieldIdHere, listFieldIdThere, statusThere beilleszti a listFieldIdThere listáját a trackerId űrlap tételéből ahol filterFieldIdThere egyezik a filterFieldIdHere értékével és ahol a státusz statusThere.",
"Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "E-mail cím opciók: 0|1|2 ahol 0 esetén a címet egyszerű szövegként, 1 esetén hex kódolt mailto link formájában (megnehezítve így hogy spammerek kiszedjék az oldalból) és végül 2 esetén a normál href mailto formájában kerül megjelenítésre.",
" 0|1|2|3|4|5 0,xsize,ysize. First record :0 for URL in file gal of MP3 only, 1 for URL of FLV in file gal video only , 2 for URL of MP3 or Video in file gal, 3 donwload MP3 only, 4 donwload FLV video only, 5 download FLV or MP3 (default is 0). Second record : X size of flash applet(default is 200) , Y size of flash applet (default is 100) " => "Multimédia opciók: '0|1|2|3|4|5 0,xsize,ysize' Első rekord:0 csak fájlgalériában szereplő mp3-akra mutató URL-hez, '1' csak fájlgalériában szereplő FLV-kre (flash videó) mutató URL-hez, '2' az előző kettő vagy-vagy kapcsolata, '3' csak MP3 letöltés, '4' csak FLV videó letöltése, '5' előző vagy-vagy kapcsolata (az alapértelmezett érték 0). Második rész: 'xsize' a flash applet X mérete (az alapértelmezett érték 200) , 'ysize' a flash applet Y mérete (az alapértelmezett érték 100)",
"Sequential auto-increment number:initial_value,prepend,append,itemId: initial_value default is 1, prepend will be displayed before the field, append will be displayed just after, itemId will use the item Id" => "Szekvenicális automatikus sorszámozás opciók: 'initial_value,prepend,append,itemId' ahol 'initial_value' alapértelmezett értéke 1, 'prepend' hatására a mező előtt kerül megjelenítésre, 'append' hatására utána, 'itemId' a tétel azonosítóját fogja használni",
"Allow registered user to subscribe to an item. They can add a number of friends." => "Regisztrált felhasználók előfizethetnek egy tételre. Hozzáadhatnak barátokat is.",
"Use Google Maps." => "Google térképek használata",
"Formula for computation, using # for indicating fields and +,*,/,- and parenthesis for operations." => "Formula számításokhoz, a '#' mezőket jelez, a '+,*,/,-' jeleket műveletekhez használhatjuk",
"listview=nst, n to see name/t to see type/s to see type/u to see user in list mode" => "listanézet=nst, 'n' a név megtekintéséhez, 't' a típus megtekintéséhez, 's' típus megtekintéséhez, 'u' felhasználó megtekintéséhez listázási nézetben",
"Import/Export Trackers" => "Űrlapok importálása/exportálása",
"List FAQs Tpl" => "GYIK tpl listázása",
"Admin Tracker" => "Űrlap adminisztrálása",
"password|email" => "jelszó|E-mail",
"If you want to use images please save the post first and you will be able to edit/post images. Use the <img> snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor." => "Ha képeket is szeretnénk a poszthoz fűzni akkor először mentsük a posztot. Mentés után lesz lehetőség képek hozzáadására / szerkesztésére. Használjuk az <img> tag-et feltöltött képek szövegterületben való megjelenítéséhez. Másik lehetőség a WYSIWYG szerkesztő kép URL lehetőségének alkalmazása.",
"If you want to use images please save the post first and you will be able to edit/post images. Use the <img> snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor" => "Ha képeket is szeretnénk a poszthoz fűzni akkor először mentsük a posztot. Mentés után lesz lehetőség képek hozzáadására / szerkesztésére. Használjuk az <img> tag-et feltöltött képek szövegterületben való megjelenítéséhez. Másik lehetőség a WYSIWYG szerkesztő kép URL lehetőségének alkalmazása",
"Mark entry as private" => "Privát bejegyzés",
"To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "Blogok hozzáadásához/eltávolításához lásd a \"Blog létrehozása/szerkesztése\" menüpontot a \"Blogok\" menü alatt az alkalmazás fő menüjében, vagy",
"Blog features" => "Blog funkciók",
"Trackbacks Pings" => "Visszakövetési pingek (trackbacks pings)",
"Post level trackback pings" => "Poszt szintű trackback pings",
"Blogs have a custom heading" => "Blogok saját fejléccel rendelkeznek",
"Last modification time" => "Utolsó módosítás",
"Admin Html Pages" => "HTML oldalak adminisztrálása",
"Admin Html Pages Template" => "HTML oldalah sablonjának adminisztrálása",
"Admin quizzes" => "Kvízek adminisztrálása",
"Admin Quizzes tpl" => "Kvíz sablon adminisztrálása",
"Stats for quiz" => "Kvíz statisztika",
"An error as occured with the mapfile: " => "Hiba lépett fel a mapfile kapcsán: ",
"Layer management" => "Rétegek kezelése",
"File Title" => "Fájl neve",
"Unzip all zip files" => "Összes ZIP fájl kicsomagolása",
"Note: Maximum file size is limited to" => "Megjegyzés: a fájlméret maximuma",
"Note: Maximum file size is limited to:" => "Megjegyzés: a fájlméret maximuma:",
"Edit User Contacts Preferences" => "Felhasználói kontaktok beállításának szerkesztése",
"User Tasks tpl" => "Felhasználói feladatok tpl",
"Flash Lenght" => "Flash hossza",
"Video Lenght" => "Video hossza",
"To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "Könyvtár beállításához lásd a \"Könyvtár adminisztrálása\" menüpontot a \"Könyvtár\" menü alatt az alkalmazás menüjében, vagy",
"Freetags rock!" => "Freetags rock!",
"Show Tag Cloud" => "Címkefelhő mutatása",
"Random tag cloud colors (separated by comma)" => "Véletlenszerű címkefelhő színek (vesszővel elválasztva)",
"Preload freetag random search when arriving on <a href=\"tiki-browse_freetags.php\">freetag search grid</a>" => "Címke véletlenszerű előtöltése a <a href=\"tiki-browse_freetags.php\">címkekeresőre</a> történő megérkezéskor",
"Number of Tags to show in Cloud" => "Felhőben megjelenítendő címkék száma",
"Only accept alphanumeric ASCII freetags (no accents or special chars)" => "Csak alfanumerikus ASCII címkék elfogadása (idézőjelek és más speciális karakterek kizárása)",
"Accept all" => "Összes elfogadása",
"Only accept lowercase freetags" => "Csak kisbetűs címkék elfogadása",
"Handle multilingual freetags" => "Többnyelvű címkék kezelése",
"cleanup" => "Eltávolítás",
"More Like This/Get Similar Module" => "Több hasonló/Hasonlók beszerzése modul",
"More Like This algorithm" => "Több hasonló algoritmus",
"Basic algorithm - Minimum amount of tags in common" => "Alapalgoritmus - közös címkék minimális száma",
"Group calendar sticky popup" => "Csoportnaptár ragadós felugró ablak",
"Group calendar item view tab" => "Csoportnaptár tétel nézet fül",
"Calendar manual selection of time/date" => "Naptár manuális idő/dátum választás",
"First year in the dropdown, either year number, or relative to current year (+/- N)" => "Első év a legördülő menüben, vagy évszám vagy relatív az idei évhez (+/- N)",
"if no jscalendar" => "ha nincs jscalendar",
"Last year in the dropdown, either year number, or relative to current year (+/- N)" => "Utolsó év a legördülő menüben, vagy évszám vagy relatív az idei évhez (+/- N)",
"Allow Anonymous Poll Voting" => "Anonim szavazás engedélyezése",
"Trackers attachments preferences" => "Űrlapmellékletek beállításai",
"Trackers attachments" => "Űrlapmellékletek",
"Wiki Discussion" => "Wiki megbeszélése",
"Wiki Link Format" => "Wiki link formátum",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Wiki linkek felismerésének ellenőrzése a kettős kerek zárójel wiki link szintakszis használatával <i>((oldalnév))</i>.",
"Page name display stripper: choose a character that will be used as a delimiter to strip a final part of the page name (only concerns display)" => "Oldalnév lerövidítése a kiválasztott határoló karakter által (csak a megjelenítést érinti)",
"Wiki Page Staging and Approval" => "Wiki oldal jóváhagyás",
"Use wiki page staging and approval:" => "Wiki oldal jóváhagyás használata:",
"Hide page name prefix:" => "Oldalelőtag elrejtése:",
"Category for staging pages:" => "Jóváhagyás alatt lévő oldalak kategóriája:",
"Category for approved pages:" => "Jóváhagyott oldalak kategóriája:",
"Category for pages out of sync:" => "Szinkronból kicsúszott oldalak kategóriája:",
"Force bounce of editing of approved pages to staging:" => "Jóváhagyott oldalak szerkesztésének jóváhagyásra küldése:",
"Categorize approved pages with categories of staging copy on approval:" => "Jóváhagyott oldalak kategorizálása a jóváhagyási változat kategóriáira jóváhagyáskor:",
"Replace freetags with that of staging pages on approval:" => "Címkék kicserélése a jóváhagyási oldalváltozatokéra jóváhagyáskor:",
"Add new freetags of approved copy (into tags field) when editing staging pages:" => "Új címkék hozzáadása a jóváhagyott változathoz (a címkemezőbe) a jóváhagyás alatti oldalak szerkesztésekor:",
"Delete staging pages at approval:" => "Jóváhagyás alatti oldalváltozat törlése jóváhagyáskor:",
"Use external link icons:" => "Külső link ikonok használata:",
"User's Page:" => "Felhasználói oldal:",
"Wiki authors style by page settings:" => "Wiki szerzők stílusa oldalankénti beállítása",
"Protect email against spam:" => "E-mail cím védése spamek ellen:",
"When viewing a page, if it doesn't exist and has one like page, automatic redirection to this like page:" => "Automatikus átirányítás a hasonló oldalra oldal megtekintésekor ha létezik hasonló oldal:",
"Show/hide heading icon displayed before the heading:" => "Megjelenítés/elrejtés ikon megjelenítése a címsor előtt:",
"Page navigation bar position (displayed when page break '...page...' are used):" => "Oldalnavigációs sor pozíciója ('...page...' oldaltörés használata esetén kerül megjelenítésre):",
"Wiki actions bar position (e.g. Save, Preview, Cancel, ...):" => "Wiki akció sor pozíciója (pld Mentés, Előnézet, Mégse, ...):",
"Regex search and replace:" => "Regex keresés és kicserélés:",
"Log bytes changes (+/-) in Action Logs (slows each page modifications)" => "Byteméret változásának (+/-) loggolása az akció logban (lassítja az oldalak módosítását)",
"Support tickets" => "Támogatási jegyek",
"back to admin" => "vissza adminisztrátornak",
"Renamed" => "Átnevezés",
"Viewed" => "Megtekintés",
"Posted" => "Elküldés",
"Downloaded" => "Letöltés",
"sheet" => "ív",
"Created wiki page" => "Létrehozott wiki oldal",
"Total number of users:" => "Felhasználók teljes száma",
"Total number of objects:" => "Objektumok teljes száma",
"file_galleries" => "fájlgalériák",
"html_pages" => "HTML oldalak",
"newsreader" => "hírolvasó",
"contacts" => "kontaktok",
"Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme'). Separator between params:'&'. E.g. maxlen=15&nonums=y." => "Paraméterek: specifikus paraméterek a modulhoz és/vagy általános paramétek a következők: ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme'). Paraméterek közi szeparátor:'&'. Pld: maxlen=15&nonums=y.",
"Path to the folder icon for close sections" => "Útvonal a zárt szekciók mappaikonjához",
"Provide also a folder icon for open sections with the same name with the letter 'o' before in the same directory (ex: folder.png and ofolder.png)" => "Adjunk meg mappaikont a nyitott szekciókhoz ugyanazzal a névvel 'o' előtaggal ugyanazon könyvtárban (pld: folder.png és ofolder.png)",
"Invalid password.  Your current password is required to change administrative information" => "Érvénytelen jelszó. Meg kell adni a jelenlegi jelszót az adminisztratív információk megváltoztatásához.",
"Reset view to site-wide default" => "Nézet visszaállítás a weblap alapértelmezésére",
"Regex search" => "Regex keresés",
"new submissions" => "beküldött új cikkek",
"new sites" => "új oldal",
"new calendar events" => "új naptári esemény",
"filesize" => "fájlméret",
"Select list items that will be displayed" => "Megjelenítésre kerülő listatételek kiválasztása",
"fields marked with a * are mandatory" => "a *-gal jelölt mezők kötelezőek",
"{\$atts_cnt} files attached" => "{\$atts_cnt} csatolt fájl",
"Antarctica" => "Antarktisz",
"Document repository" => "Dokumentumtár",
"News" => "Hírek",
"Knowledge base" => "Tudásbázis",
"successfully deleted" => "sikeresen törölve",
"successfully deleted." => "sikeresen törölve",
"Contributors to this page:" => "Hozzájárulók az oldal szerkesztéséhez",
"Config Calendars" => "Naptárak konfigurálása",
"Duplicate to" => "Duplikálás ide",
"No description" => "Nincs leírás",
"... continued ..." => "... bővebben ...",
"Wiki page %s changed" => "A következő Wiki oldal megváltozott: %s",
"Upload big files (e.g. PodCast files) here:" => "Nagy méretű fájlokat ide töltsünk fel (pld FTP-n keresztül)",
"disable" => "kikapcsolás",
"Full Path to the Zip File" => "Zip fájl teljes útvonala",
"Add file" => "Fájl hozzáadása",
"Folder" => "Mappa",
"Advanced parameters for iCal export" => "iCal exportálás további paraméterei",
"Note: To be managed with tiki , your flash banner link should be" => "Megjegyzés: ahhoz hogy a tiki jól kezelje, a flash banner linkje ilyen legyen",
"Note: To be managed with tiki, your flash banner link should be:" => "Megjegyzés: ahhoz hogy a tiki jól kezelje, a flash banner linkje ilyen legyen:",
"About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "WikiPluginok és biztonság: Csak a  \"tiki_p_plugin_approve\" jogosultságot adjuk meg azoknak a szerkesztőknek akikben megbízunk",
"You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "Kockázatos pluginokat itt deaktiválhatjuk: (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
"Allow anonymous access" => "Anonymus hozzáférés engedélyezése",
"To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "Saját ikonok használatához menükben adjuk meg az útvonalat az <strong>összezárt</strong> mappa ikonjához",
"In the same directory, include an icon for the opened folder" => "Ugyanabban a könyvtárban adjunk meg egy ikont a kinyitott mappához",
"The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "A \"kinyitott mappa\" ikon nevének meg kell egyeznie az \"összezárt\" ikon nevével, előtte az <strong>o</strong> előtaggal",
"For wiki page, use ((PageName))" => "Wiki oldalhoz használjuk az ((OldalNév)) szintakszist",
"Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Több szekció esetén: a szekciókat vesszővel ( , ) válasszuk el AND (ÉS) jellegű logikai kapcsolathoz, OR (VAGY) jellegű logikai kapcsolathoz pedig használjunk függőleges elválasztót ( | )",
"Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Több jogosultság esetén: a jogosultságokat vesszővel ( , ) válasszuk el AND (ÉS) jellegű logikai kapcsolathoz, OR (VAGY) jellegű logikai kapcsolathoz pedig használjunk függőleges elválasztót ( | )",
"Choose ..." => "Kiválasztás...",
"Groups monitor" => "Csoport figyelés",
"Ex" => "Pld",
"Send another message." => "Másik üzenet küldése",
"Send Pages" => "Oldalak küldése",
"Prefix the checked" => "Kijelöltek kiegészítése ezen előtaggal",
"Postfix the checked" => "Kijelöltek kiegészítése ezen utótaggal",
"MyTiki Home" => "MyTiki kezdőlap",
"My Files" => "Fájljaim",
"Add a new mail account" => "Új postafiók hozzáadása",
"No newsletters available" => "Nincs elérhető hírlevél",
"Admin Directory" => "Könyvtár adminisztrálása",
"Admin Posts" => "Posztok adminisztrálása",
"New Article" => "Új cikk",
"Switch to WYSIWYG editor" => "Átváltás WYSIWYG szerkesztőre",
"Switch to normal (wiki) editor" => "Átváltás normál (wiki) szerkesztőre",
"Paste" => "Beillesztés",
"Monitor this page:" => "Oldal figyelése",
"Edit Comment:" => "Szerkesztési komment",
"Page saved (version %d)" => "Oldal elmentve (verzió %d)",
"Buttons: Save, Preview, Cancel, .." => "Gombok: Mentés, Előnézet, Visszavonás, ..",
"Page description, icons, backlinks, .." => "Oldal leírása, ikonok, backlinkek, ..",
"Buttons: Edit, Source, Remove, .." => "Gombok: Szerkesztés, Forrás, Eltávolítás, stb ..",
"Edit idle timeout" => "Nem tevékeny szerkesztés időkorlátja",
"Edit section level" => "Szekció szint szerkesztése",
"Minor edits do not flag new content for translation and do not send watch notifications" => "Kisebb szerkesztések nem számítanak lefordítandó tartalomváltozásnak és a figyelési funkció értesítései sem kerülnek kiküldésre ",
"Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Csak a tiki_p_minor jogosultsággal rendelkező csoportok és az adminisztrátorok végezhetnek kisebb mentéseket a funkció bekapcsolásakor",
"Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits" => "A szerkesztési munkamenet 1 perc múlva lejár. Az ELŐNÉZET vagy a MENTÉS gomb lenyomásával megelőzhető a változtatások elvesztése",
"Create a Forum" => "Fórum létrehozása",
"When viewing a page, if it doesn't exist automatically redirect to a similarly named page" => "Oldal megtekintésekor ha az oldal nem létezik akkor automatikusan átirányít egy hasonló nevű oldalra",
"Maximum number of versions" => "Verziók maximális száma",
"Create webhelp from structure" => "Websúgó készítése struktúrából",
"Insert Smileys" => "Smiley beszúrása",
"No occurences found" => "Nem található előfordulás",
"Manage semantic tokens used throughout the wiki" => "Szemantikus tokenek kezelése a teljes wikiben",
"Webservice Registration" => "Webes szolgáltatás (webservice) regisztrálása",
"Discover and register web services to allow direct use in wiki pages" => "Közvetlenül wiki oldalakon használható webes szolgáltatások felderítése és regisztrálása.",
"Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "JSON-t vagy YAML-t visszaadó webes szolgáltatás URL-jét kell megadni. Paramétereket százalékjel közé zárva lehet megadni, de például: %name%. %service% és %template% foglalt kulcsszavak és nem szabad használni őket",
"Create shortcut syntaxes to plugins" => "Gyorshivatkozási szintakszisok létrehozása pluginokhoz",
"all" => "összes",
"arguments" => "argumentumok",
"Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Kattintsunk a <a href=\"tiki-list_banners.php\" title=\"Banners\">Adminisztráció &gt; Bannerek</a> menüpontra banner zónák létrehozásához és szerkesztéséhez",
"<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Aktiválás</strong> bejelölésével a tartalom csak az adminisztrátorok számára jelenik meg. A <strong>Publikálás</strong> bejelölésével lesz elérhető az összes felhasználó számára",
"Include a flag by each e-mail to quickly flag/un-flag them" => "Minden E-mail megjelőlése gyors be/kijelölés céljából",
"The following list of changes has been applied" => "Az alábbi változások kerültek beállításra",
"preference name" => "preferencia neve",
"Use Tiki (database-independent) search" => "Tiki (adatbázis független) keresés használata",
"Use database (full-text) search" => "Adatbázis (full-text) keresés",
"The \"users can change theme\" feature will override the theme displayed" => "A \"Felhasználók változtathatják a stílust\" funkció felülírja a megjelenített stílust",
"Activate will only show content for admin. Check Publish to use content for all users" => "Aktiválás gombbal a tartalom csak az adminisztrátorok számára lesz látható. Publikálás bejelölésével az összes felhasználó láthatja.",
"Edit Comments length" => "Kommentek hosszának szerkesztése",
"Detect user timezone (if browser allows). Otherwise use site default" => "Felhasználó időzónájának felismerése (ha a böngésző megengedi). Ellenkező esetben weblap alapértelmezésének használata.",
"Output compression is active" => "Kimeneti tömörítés aktív",
"The \"Contact Us\" feature is disabled" => "A \"Kapcsolatfelvétel\" funkció ki van kapcsolva",
"Help page" => "Súgó oldal",
"You must select a file" => "Ki kell választani egy fájlt",
"Flash player not available" => "Flash lejátszó nem elérhető",
"(unchanged)" => "(változatlan)",
"Remaining" => "Maradék",
"Maximum size" => "Maximális méret",
"Add email" => "E-mail hozzáadása",
"Add user" => "Felhasználó hozzáadása",
"Loading.." => "Betöltés..",
"The cache is used by" => "A cache-t használja:",
"Object Watches" => "Objektum figyelések",
"Watching Groups" => "Figyelő csoportok",
"Prologue" => "Prológus",
"Epilogue" => "Epilógus",
"The highlight pages already exist" => "A kiemelt oldalak már léteznek",
"Please register" => "Regisztráció szükséges",
"Enter your email" => "E-mail cím megadása",
"Date Search" => "Dátum keresés",
"Displays an miniquiz" => "Megjelenít egy minikvízt",
"Clear all Categories" => "Kijelölések eltávolítása",
"Wiki Page" => "Wiki oldal",
"Plugin aliases" => "Plugin álnevek",
"Description text is tiki-parsed:" => "Leírás szövege tiki által elemzett:",
"For more information, please see <a href=\"{\$prefs.helpurl}Wiki Page Editor\">Wiki Page Editor</a>" => "További információkért lásd: <a href=\"{\$prefs.helpurl}Wiki oldal szerkesztése\">Wiki oldal szerkesztése</a>",
"Pass" => "Jelszó",
"HTTPS login" => "HTTPS bejelentkezés",
"Faq" => "GYIK",
"Includes an article's content within the page" => "Egy cikk tartalmát jeleníti meg egy oldalon belül",
"Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "A weblap adatbázisa frissítésre szorul hogy megfeleljen a TikiWiki jelenlegi verziójának. Használjuk a <a href=\"tiki-install.php\">az installáló szkriptet</a>. Figyelem: a TikiWiki használata inkorrekt adatbázissal hibákat eredményezhet",
"Module name as known in Tikiwiki" => "Modul Tikiwikiben ismert neve",
"Name of the quoted person" => "Az idézett személy neve",
"wrote" => "írta",
"Create Directory" => "Könyvtár létrehozása",
"Archive is full" => "Az archívum megtelt",
"Mailbox is full! Delete or archive some messages if you want to receive more messages" => "A postafiók megtelt! Törölni vagy archiválni kéne hogy legyen hely új üzeneteknek",
"No avatar" => "Nincs avatár",
"A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "Elérhető a Tikiwiki verziója (<b>{\$tiki_release}</b>). A weblap jelenleg a következő verzión fut: <b>{\$tiki_version}</b>. Látogassunk el ide a legújabb verzióért: <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
"Edit successful" => "Sikeres szerkesztés",
"Welcome to the Tiki installation and upgrade script" => "Üdvözlet a Tiki telepítő és frissítő szkriptjében",
"Select your language" => "Nyelv kiválasztása",
"Tiki is software distributed under the LGPL license" => "A Tiki szoftver LGPL licensz alatt fut",
"Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "A Tiki telepítése előtt <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">olvassuk el a dokumentációt</a> és győződjünk meg róla hogy rendelkezésre állnak a minimális rendszerkövetelmények",
"This installer will perform some basic checks automatically" => "A telepítő automatikusan végrehajtott pár ellenőrzést melyek eredménye alább található",
"Tiki has not detected your PHP memory_limit" => "A Tiki nem tudta megállapítani a PHP memory_limit értékét",
"This probably means you have no set limit (all is well)" => "Ez valószínűleg azt jelenti hogy nincs határ beállítva (vagyis minden rendben)",
"Tiki has detected your PHP memory limit at" => "A Tiki a következő PHP memory_limit értéket találta",
"Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "A Tikinek <strong>legalább</strong> 32MB PHP memoriára van szüksége a szkriptek végrehajtásához",
"Allocating too little memory will cause Tiki to display blank pages" => "Túl kevés memória allokálása esetén a Tiki üres oldalak fog megjeleníteni",
"To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "A memória limit értékének megváltoztatásához használjuk a <strong>memory_limit</strong> kulcsot a <strong>php.ini </strong> fájlban (például: memory_limit = 32M) majd indítsuk újra a webszervert",
"Tiki has detected your PHP memory_limit at" => "A Tiki a következő PHP memory_limit értéket találta",
"Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "A Tiki a PHP <strong>mail</strong> funkciót használja E-mail értesítések és üzenetek kiküldésére",
"To test your system configuration, Tiki will attempt to send a test message to you" => "A rendszerbeállítások tesztelésére a Tiki megpróbál tesztüzenetet küldeni",
"Test email" => "Teszt E-mail",
"Email address to send test to" => "E-mail üzenet címzettje",
"Tiki was not able to send a test message" => "A Tiki nem tudta kiküldeni a tesztüzenetet",
"Review your mail log for details" => "Nézzük meg a levelezési log-ot további részletekért",
"Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Tekintsük át a <strong>php.ini</strong> fájlban található mail beállításokat (például nézzük meg hogy a <strong>sendmail_path</strong> helyesen van-e beállítva)",
"If your host requires SMTP authentication, additional configuration may be necessary" => "Ha a hoszt SMTP azonosítást igényel akkor további konfiguráció is szükséges lehet",
"Tiki detected" => "A Tiki felismerte a következőt",
"Tiki was not able to detect the GD library" => "A Tiki nem tudta felismerni a GD könyvtárat",
"Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "A Tiki a GD könyvtárat használja képek feldolgozásához és a CAPTCHA támogatáshoz",
"Tiki requires an active database connection" => "A Tiki aktív adatbázis kapcsolatot igényel",
"You must create the database and user <em>before</em> completing this page" => "Létre kell hozni az adatbázist és az adatbázishoz tartozó felhasználó nevet az alábbi adatok megadása <em>előtt</em>",
"Tiki cannot find a database connection" => "A Tiki nem talált adatbázis kapcsolatot",
"This is normal for a new installation" => "Ez így van rendjén új telepítés esetén",
"Tiki found an existing database connection in your local.php file" => "A Tiki talált egy létező adatbázis kapcsolatot a local.php fájlban",
"Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Használjuk ezt az oldalt új kapcsolat létrehozására, vagy használjuk a <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manuális telepítés\">manuális telepítés folyamatot</a>",
"Enter your database connection information" => "Adatbázis kapcsolat megadása",
"Database type" => "Adatbázis típusa",
"Select the type of database to use with Tiki" => "Tikihez használandó adatbázis kiválasztása",
"Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Csak a PHP telepítés által támogatott adatbázisok láthatóak itt. Ha a kívánt adatbázis nem szerepel a listában akkor telepíteni kell a szükséges PHP kiterjesztést",
"Host name" => "Hoszt neve",
"Enter the host name or IP for your database" => "Adatbázis hoszt nevének vagy IP címének megadása",
"Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Használjuk a <strong>localhost</strong> kifejezést ha az adatbázis ugyanazon a gépen fut ahol a Tiki",
"For SQLite, enter the path and filename to your database file" => "SQLite-hoz adjuk meg az útvonalat és a fájlnevet az adatbázis fájlhoz",
"Database name" => "Adatbázis neve",
"Enter the name of the database that Tiki will use" => "A Tiki által használandó adatbázis nevének megadása",
"The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "Az adatbázisnak már léteznie kell. Létrehozhatjuk az adatbázist mysqladmin, PHPMyAdmin, cPanel vagy a hoszting szolgáltatónk segítségével. Általában a Tiki tábla nevei nem ütköznek más termékek táblaneveivel",
"For Oracle" => "Oracle-hez",
"Enter your TNS Name here and leave Host empty" => "Adjuk meg itt a TNS nevet és hagyjuk a hoszt mezőt üresen",
"Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field" => "Tnsnames.ora felülbírálása és az SID megadása, majd a hostname:port információ rögzítése a 'Hoszt' mezőben",
"Enter a database user with administrator permission for the Database" => "Az adatbázishoz adminisztrátori jogokkal rendelkező adatbázis felhasználó nevének megadása",
"User name" => "Felhasználói név",
"Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database" => "Válasszuk ki a használandó telepítési (vagy frissítési) profilt. A kiválasztott profil alapján kerül feltöltésre (vagy frissítésre) az adatbázis",
"Select the installation profile to use. This profile will populate the database" => "Válasszuk ki a használandó telepítési profilt. A kiválasztott profil alapján kerül feltöltésre az adatbázis",
"Profiles can be used to pre-configure your site with specific features and settings" => "Profilok segítségével előkonfigurálhatjuk a weblapot bizonyos funkciókkal és beállításokkal",
"Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information" => "További információkért lásd <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a>",
"This will destroy your current database" => "Ez megsemmisíti a jelenlegi adatbázist",
"Create a new database (clean install) with profile" => "Új adatbázis létrehozása profil segítségével",
"See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles" => "További információkért lásd a <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"profil dokumentáció\">profil dokumentációt",
"The installer could not connect to the Profiles repository" => "A telepítő nem tudta elérni a profilokat",
"The default installation profile will be used" => "Az alapértelmezett telepíŧési profil kerül felhasználásra",
"This site has an admin account configured" => "Ez a weblap már rendelkezik egy adminisztrátori fiókkal",
"Please login with your admin password to continue" => "A folytatáshoz be kell jelentkezni az adminisztrátori jelszóval",
"Your database has been configured and Tiki is ready to run" => "Az adatbázis konfigurálásra került és használatra kész",
"If this is your first install, your admin password is <strong>admin</strong>" => "Ha ez az első telepítés volt akkor az adminisztrátori jelszó <strong>admin</strong>",
"You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "Be lehet jelentkezni a Tikibe <strong>admin</strong> felhasználó névvel és el lehet kezdeni az alkalmazás konfigurálását",
"Upgrade operations executed successfully" => "A frissítési műveletek sikeresen lefutottak",
"Installation operations executed successfully" => "A telepítési műveletek sikeresen lefutottak",
"SQL queries" => "SQL lekérdezés",
"Database was left unchanged" => "Az adatbázis nem változott",
"Operations failed" => "Sikertelen műveletek",
"Display details" => "Részletek megjelenítése",
"During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "Frissítés során normális ha <strong>Table already exists</strong> SQL hibaüzeneteket kapunk ",
"Complete these fields to configure common, general settings for your site" => "Ezen mezők kitöltésével az oldalra vonatkozó általános beállítások adhatóak meg",
"The information you enter here can be changed later" => "Az itt megadott adatok később megváltoztathatóak",
"Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Bővebb információ a beállításokról <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">itt</a>",
"This will appear in the browser title bar" => "Ez jelenik majd meg a böngésző címsorában",
"Email sent by your site will use this address" => "A weblap által küldött E-mailek ezen címet fogják használni",
"Admin email" => "Adminisztrátor E-mail",
"This is the email address for your administrator account" => "Ez az adminisztrátori fiók E-mail címe",
"The installation is complete" => "A telepítés véget ért",
"Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>" => "A Tiki egy opensource (nyílt forráskódú) projekt, <em>bárki</em> <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>csatlakozhat a közösséghez</a> és segíthet <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>a Tiki továbbfejlesztésében</a>",
"If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "Ha ez egy első telepítés akkor konfiguráljuk a Tiki-t a <strong>tiki-admin.php</strong> oldal segítségével bejelentkezés után",
"If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "Ha egy meglévő telepítést frissítettünk akkor vagy manuálisan ürítsük ki a cache-t (a <strong>templates_c</strong> könyvtárat) vagy használjuk a <strong>Cache/rendszer</strong> menüpontot az Adminszitráció menüben",
"Adding a new host" => "Új hoszt hozzáadása",
"Are you upgrading an existing Tiki site" => "Már létező Tiki weblap frissítéséről van szó",
"Go directly to the <strong>Install/Upgrade</strong> step" => "Ebben az esetben ugorjunk a <strong>Telepítés/Frissítés</strong> lépésre",
"Restart the installer" => "Telepítő újraindítása",
"Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Hiányzó előfeltétel, szerezzük be a <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> fájlt és töltsük fel a files/ könyvtárba",
"Subscription failed" => "Feliratkozás nem sikerült",
"Your identity gives you access to multiple user accounts" => "Az azonosító hozzáférést biztosít több felhasználói fiókhoz",
"No plugin pending approval" => "Nincs jóváhagyásra váró plugin",
"Advanced search" => "Részletes keresés",
"Edit this sheet" => "Ezen ív szerkesztése",
"Approve changes" => "Változások jóváhagyása",
"Request" => "Kérés",
"Use the &quot;Quick Edit&quot; module to easily create or edit wiki pages. Select" => "Használjuk a &quot;Wiki oldal szerkesztése&quot; modult wiki oldalak gyors létrehozásához/szerkesztéséhez. Válasszuk",
"weeks" => "hét",
"Support" => "Támogatás",
"__WARNING__: Plugin disabled \$plugin" => "__FIGYELEM__: Plugin ki van kapcsolva: \$plugin",
"__WARNING__: No such module \$plugin" => "__FIGYELEM__: Nincs ilyen modul: \$plugin",
"Sea Surfing (CSRF) detected. Operation blocked" => "CSRF tevékenység, a művelet átmenetileg bokkolva",
"The name of the anchor" => "A horgony neve",
"Autogenerated content. Leave blank initially" => "Automatikusan generált tartalom. Először hagyjuk üresen",
"Image alignment. Possible values: left, right, center" => "Kép igazítás. Lehetséges értékek: left, right, center",
"The article field to display. Default field is Heading" => "A megjelenítendő cikk mező. Alapértelmezett mező a cikk fejléce",
"The article to display. If no value is provided, most recent article will be used" => "A megjelenítendő cikk azonosítója. Ha nincs érték megadva akkor a legutóbbi cikkek kerülnek listázásra",
"The amount of articles to display in the list" => "A listában megjelenítendő cikkek száma",
"The ID of the category to list from" => "Ezen kategória azonosítóhoz (ID-hoz) tartozó cikkek kerülnek megjelenítésre",
"The article language to list" => "Listázandó cikkek nyelve",
"The column and order of the sort in columnName_asc or columnName_desc format" => "Az oszlop és a rendezés módja columnName_asc vagy columnName_desc formátumban",
"Whether to not report when there are no articles" => "Jelentse-e ha nincs cikk",
"Whether to only show the title of the articles" => "Csak a cikkek címét jeleníti meg",
"The wiki page the avatar will link to" => "A wiki oldal melyre az avatár mutat",
"As defined by CSS, name or Hex code" => "CSS, név vagy Hex kód által definiálva",
"In pixels or percentage. Default value is 100%" => "Pixelszámban vagy százalékban kifejezve. Az alapértelmezett érték 100%",
"for box with width lesser than 100%, make text wrap around the box" => "100%-nál kisebb szélességű dobozoknál a szöveg a doboz köré kerül rendezésre",
"Apply custom CSS class to the box" => "Saját CSS osztály alkalmazása a dobozhoz",
"List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "Kategótia ID-k listája + jellel elválasztva. Pld: 1+2+3. Alapértelmezés az adott oldal kategóriája",
"String used to separate the categories in the path. Default character is >" => "Kategóriák elválasztásához használt sztring az útvonalban. Alapértelmezett karakter: >",
"Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Megjelenít egy Tikiíven alapuló ábrát. A plugint a Tikiív ábrageneráló eszköze generálja",
"Chart caption" => "Ábra felirata",
"List of colors to use" => "Használandó színek listája",
"List of styles to use" => "Használandó stílusok listája",
"Labels for the series or values in the legend" => "Jelmagyarázat feliratai sorozatokhoz vagy értékekhez",
"Code snippet label" => "Kódrészlet felirata",
"0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Szövegtörés bekapcsolásával elkerülhető a kinézet szétesése",
"Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Használandó szintakszis kiemelés. Nem használjuk 'Sorok száma' használata esetén. Lehetőségek: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
"0|1, may not be used with colors" => "0|1, ne használjuk 'Színek' használata esetén",
"0|1, parse wiki syntax within the code snippet" => "0|1, kódrészlet elemzése wiki szintakszissal",
"Includes content from the dynamic content system" => "Dinamikus tartalomkezelő tartalmát jeleníti",
"Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Minta a szerzői jog megjelenítéséhez. Lehetőségek: ~title~, ~year~ és ~authors~",
"Displays a countdown from now until the specified date" => "Jelen pillanattól egy adott dátumig tartó visszaszámlálást jelenít meg",
"Text to append to the countdown" => "Visszaszámláláshoz tartozó szöveg",
"Target date. Multiple formats accepted" => "Cél dátum. Többféle fomrátum is elfogadott",
"The name of a DSN connection defined by the Wiki administrator" => "A Wiki adminisztrátora által definiált DSN kapcsolat",
"0|1, parse wiki syntax within the report" => "0|1, riport wiki szintakszis általi elemzése",
"0|1, display the parsed report definition" => "0|1, megjeleníti az elemzett riport definíciót",
"No DSN connection string found" => "Nem található DSN kapcsolat sztring",
"left|right, for box with width lesser than 100%, make text wrap around the box" => "left|right, 100%-nál kisebb szélességű dobozoknál a szöveg a doboz köré kerül rendezésre",
"One entry per line. Each line is in \"Term: Definition\" format" => "Egy bejegyzés soronként. Minden sor ebben a formátumban legyen: \"Term: Definition\"",
"Name of the drawing to display" => "Megjelenítendő rajz neve",
"Renders an equation written in LaTeX syntax as an image" => "LaTeX szintakszisban írt egyenletet renderel képpé",
"Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Normál méretről való növelés százalékban kifejezve. 100 adja meg az alapértelmezett méretet. 200 duplájára növeli a képet",
"Includes the list of events from a calendar in the page" => "Egy naptár eseményeit listázza az oldalon",
"Displays a label. On click, the block of content will fade in and fade out" => "Megjelenít egy feliratot. A feliratra történő kattintásra megjelenik a felirathoz tartozó tartalom. Újabb kattintásra eltűnik a tartalom és ismét csak a felirat látszik",
"Wiki syntax containing the text to display" => "Wiki szintakszisban írt szöveg",
"One item per line starting with anything followed by \")\"" => "Egy tétel soronként, kezdődhet bármivel \")\" után",
"One row per line, cells separated by ~|~" => "Egy sor soronként, cellákat ezzel válasszuk el: ~|~ ",
"Heading row of the table, same format as the body section" => "Tábla fejléc sora, ugyanolyan formátumú mint a törzs",
"CSS Class to apply on the heading row" => "Fejléc soron alkalmazandó CSS osztály",
"Displays a file attachment or a list of them" => "Csatolt fájlt vagy csatolt fájlok listáját jeleníti meg",
"Displays a list of files" => "Fájlok listáját mutatja",
"Complete URL to the movie to include" => "Teljes URL a mozihoz",
"Bar width in pixels" => "Sor szélessége pixelben",
"true|false, if true then a percentage of the maximum is displayed" => "true|false, ha true ('igaz') akkor a maximum százaléka kerül megjelenítésre",
"Add the tracking code for Google Analytics" => "Google Analytics nyomonkövetési kódjának hozzáadása",
"The account number for the site" => "Az oldal számla (fiók) száma",
"Leave this empty" => "Hagyjuk üresen",
"Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Keret mérete, használjuk width (szélesség) és height (magasság) helyett. Segíŧségéel a Google anyagok mérete pontosa illeszkedni fog. Lehetőségek: small|medium|large",
"Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "A feltételek esetén megjelenítendő wiki szöveg. A szövegtörzs tartalmazhat {ELSE}-t. A marker utáni szöveg csak azon felhasználóknak kerül megjeleníŧésre akik nem felelnek meg a feltételnek",
"0|1, parse wiki syntax within the html code" => "0|1, wiki szintakszis elemzése a HTML kódon belül",
"Alias: lnk. Location the image should point to" => "Alias: lnk. Lokáció melyre a kép mutat",
"\"rel\" attribute to add to the link" => "Linkehz hozzáadandó \"rel\" attribútum",
"Title text" => "Cím szöveg",
"Alternate text to display if impossible to load the image" => "Ha a kép betöltése vlamiért nem lehetséges akkor ez az alternatív felirat jelenik meg",
"Image description to display on the page" => "Oldalon megjelenítendő kép leírása",
"Name of the image map to use for the image" => "A kép térkép neve mely a képhez használva lesz",
"Display an image" => "Egy kép megjelenítése",
"Displays an image" => "Egy kép megjelenítése",
"Full URL to the image to display" => "A megjelenítendő kép teljes URL-je",
"Height of the image to display" => "A megjelenítendő kép magassága",
"Width of the image to display" => "A megjelenítendő kép szélessége",
"Image alignment in the page. (left, right, center) Uses HTML IMG tag" => "Kép igazítása az oldalon. (left, right, center) HTML IMG tag-et használja",
"Image alignment in the flow of the document. (left, right, none) Uses CSS float property" => "Kép igazítása a dokumentumban. (left, right, none) CSS float property-t használja",
"Style to apply to the image" => "A képen alkalmazandó stílus",
"Include a page's content" => "Egy másik oldal tartalmát jeleníti meg",
"Wiki page name to include" => "A wikioldal neve amely megjelenítésre kerül",
"When only a portion of the page should be included, specify the marker from which inclusion should start" => "Ha az oldalnak csak egy részét szeretnénk megjeleníteni akkor meg kell adni a kezdés helyét",
"When only a portion of the page should be included, specify the marker at which inclusion should end" => "Ha az oldalnak csak egy részét szeretnénk megjeleníteni akkor meg kell adni a befejezés helyét",
"Javascript filename" => "Javascript fájlnév",
"List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "Nyelvek listája melyeken a blokk megjelenik. Kétbetűs nyelvkódot használjunk (pld: hu, en, fr, es, ...). Több nyelvet plusz jellel elválasztva lehet megadni",
"List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "Nyelvek listája melyeken a blokk nem jelenik meg. Kétbetűs nyelvkódot használjunk (pld: hu, en, fr, es, ...). Több nyelvet plusz jellel elválasztva lehet megadni",
"Amount of results displayed in the list" => "A listában megjelenítendő eredmények száma",
"Displays a module inlined in page. More parameters can be added, not supported by UI" => "Modult jelenít meg az oldalba illesztve. Több paramétert is meg lehet adni (nem minden paraméter jelenik meg a felületen)",
"Font name as known in browsers" => "Betű böngészők által ismert neve",
"Text displayed on the mouseover. The body contains the text of the page" => "Egér szöveg felé mozgatásakot megjelenítendő felirat. A törzs az oldal szövegét tartalmazza",
"Wiki page name to redirect to" => "Átirányítás erre a wiki oldalra",
"Complete URL, internal or external" => "Teljes URL, internal vagy external",
"Label displayed above the remark" => "Megjegyzés felett megjelenő címke",
"Icon ID" => "Ikon ID",
"Inserts an RSS feed output" => "RSS feed kimenetet illeszt be",
"Amount of results displayed" => "Megjelenítendő eredmények száma",
"share" => "megosztás",
"Displays the content of a spreadsheet in the page" => "Egy ív (tiki táblázat) tartalmának megjelenítése egy oldalon",
"Internal ID of the TikiSheet" => "Tikiív belső ID-ja",
"Incomplete call to plugin: No target sheet" => "Nem elegendő információ: nincs cél ív",
"Maximum amount of results displayed" => "Megjelenítendő eredmények maximális száma",
"Data to sort, one entry per line" => "Rendezendő adatok, egy tétel soronként",
"Subscribe text, containing %s as the placeholder for the group name" => "Feliratkozás szövege (%s a csoport nevének használatához)",
"Unsubscribe text, containing %s as the placeholder for the group name" => "Leiratkozás szövege (%s a csoport nevének használatához)",
"Subscribe button label, containing %s as the placeholder for the group name" => "Feliratkozási gomb felirata (%s a csoport nevének használatához)",
"Unsubscribe button label, containing %s as the placeholder for the group name" => "Leiratkozási gomb felirata (%s a csoport nevének használatához)",
"Colon separated list of groups" => "Csoportok listája kettősponttal elválasztva",
"Displays text in superscript (exponent)" => "Felső indexben jelenít meg szöveget",
"Any valid HTML tag, span by default" => "Bármilyen valid HTML tag, alapértelemezé: span",
"Equivalent of the style attribute on the HTML tag" => "Megegyezik a HTML tag stílus attribútumával",
"File ID from the file gallery" => "Fájl ID a fájlgalériából",
"Image ID from the image gallery" => "Kép ID a képgalériából",
"URL to the image" => "Képre mutató URL",
"Maximum width or height for the image" => "Kép maximális szélessége és magassága",
"Link target of the image" => "A képhez tartozó link célja",
"File is not an image" => "A fájl nem kép",
"Server does not support image manipulation" => "Szerver nem támogatja a képek manipulálását",
"No image specified" => "Nincs kép megadva",
"Search wiki page titles" => "Wiki oldalak nevei között keres",
"Portion of a page name" => "Oldanév egy része",
"Pipe separated list of page names to exclude from results" => "Az eredményekbők kizárandó oldalak listája függőleges vonallal elválasztva",
"Displays the table of contents for the current structure's subtree as part of the page content" => "Megjeleníti a jelenlegi struktúrához tartozó tartalomjegyzéket az oldalon",
"Maximum amount of levels to display. On very large structures, this should be limited" => "A megjelenítendő struktúra maximális mélysége. Kirejedt struktúráknál hasznos lehet",
"By default, structure for the current page will be displayed. Alternate structure may be provided" => "Alapértelmezéskénz az adott oldalhoz tartozó struktúra kerül megjelenítésre de meg lehet adni más struktúrát is",
"Colon-separated list of values" => "Értékek kettősponttal elválasztott listája",
"Name of the template used to display the tracker items" => "Űralptételek megjelenítésekor használandó sablon neve",
"Name of the wiki page containing the template to display the tracker items" => "Az űrlaptételek megjelenítésére használandó sablont tartalmazó oldal neve",
"Default status applied to newly created items" => "Újonnan létrehozott tételek alapértelmezett státusza",
"Specify the width in pixels or percentage of the first column in the tracker form" => "Az űrlap első oszlopának pixelben vagy százalékban kifejeztt szélessége",
"Wiki text containing an {ELSE} marker" => "{ELSE} markert tartalmazó wiki szöveg",
"Colon separated list of field IDs" => "Mező ID-k listája kettősponttal elválasztva",
"Value to compare against" => "Ezzel az értékkel kell összehasonlítani",
"Which item status to list. o = open, p = pending, c = closed" => "Milyen státuszú tételek kerüljenek listázásra. o = open (nyitva lévő), p = pending (függő), c = closed (lezárt)",
"Colon separated list of fields to allow filtering on" => "Szűrőként használható mezők listája kettősponttal elválasztva",
"Item ID separated with " => "Tétel ID ezzel elválasztva",
"Sum or average all the values of a field  and displays it at the bottom of the table" => "Egy mező összes értékének összege vagy átlaga a tábla alján megjelenítve",
"Button label" => "Gomb felirat",
"Content of the field" => "Mező tartalma",
"Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Űrlap időinformációinak megtekintésére szolgál. Megjelenítheti események idejét vagy akár GANTT ábrákat is",
"Tracker Field ID containing the item title" => "Azon űrlap mező ID mely a tétel nevét tartalmazza",
"Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Azon űrlap mező ID-ja melyben a tétel leírása található. Ez a leíró mező jelenik meg mikor a tételre fókuszálunk",
"Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Azon űrlap mező ID-ja mely az elem kezdési dátumát tartalmazza. A mezőnek datetime/jscalendar mezőnek kell lennie",
"Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Azon űrlap mező ID-ja mely az elem befejezési dátumát tartalmazza. A mezőnek datetime/jscalendar mezőnek kell lennie",
"Tracker Field ID containing the element's group. Elements of a same group are displayed on the same row" => "Azon űrlap mező ID-ja mely az elem csoportját tartalmazza. Egy csoportba tartozó elemek ugyanabban a sorban jelennek meg",
"Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "A dátum melytől kezdve az elemek megjelenítésre kerülnek. A dátumot a következő formátumban kell megadni: YYYY-MM-DD HH:mm:ss",
"Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "A dátum ameddig az elemek megjelenítésre kerülnek. A dátumot a következő formátumban kell megadni: YYYY-MM-DD HH:mm:ss",
"Tracker Field ID containing the page name for item details" => "Azon űrlap mező ID-ja mely a tétel részleteit leíró oldal nevét tartalmazza",
"Start date after end date" => "Kezdési dátuma a befejezési dátum után van",
"String to use between elements of the list" => "A lista elemei között használandó sztring",
"Result limit" => "Eredmény limit",
"Registered service name" => "Solgáltatás regisztrált neve",
"Required for podcasts" => "Podcastokhoz szükséges",
"Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "A megadott HTML színkódnak vagy színnévnek megfelelő színben jeleníti meg a szöveget. Szín neve két színt is tartalmazhat vesszővel elválasztva. Ebben az esetben az első szín adja meg a karakter színét, a második a háttérszínt",
"Note: Remember that this is only a preview, and has not yet been saved" => "Figyelem: Ez csak előnézet, még nem történt mentés",
"left/right" => "bal/jobb",
"home" => "főoldal",
"chat" => "csevegés",
"contact us" => "kapcsolat teremtés",
"MyMenu" => "Saját menü",
"MyTiki home" => "MyOiT főoldal",
"My files" => "Fájljaim",
"User menu" => "Menüim",
"My watches" => "Figyelések",
"Monitor processes" => "Folyamatok figyelése",
"Monitor activities" => "Tevékenységek figyelése",
"Monitor instances" => "Példányok figyelése",
"User processes" => "Felhasználói folyamatok",
"User activities" => "Felhasználói tevékenységek",
"User instances" => "Felhasználói példányok",
"rankings" => "rangok",
"orphan pages" => "árva lapok",
"sandbox" => "homokozó",
"received pages" => "érkezett lapok",
"structures" => "struktúrák",
"System gallery" => "Rendszergaléria",
"Articles Home" => "Cikkek kezdőlapja",
"View submissions" => "Beküldött hírek megtekintése",
"Send articles" => "Cikkek küldése",
"List blogs" => "Blogok listázása",
"Create/Edit Blog" => "Blog létrehozása/szerkesztése",
"Admin posts" => "Posztok adminisztrálása",
"Submit a new link" => "Új link beküldése",
"Browse Directory" => "Könyvtár böngészése",
"Admin directory" => "Könyvtár adminisztrálása",
"Admin FAQs" => "Gyakori kérdések adminisztrálása",
"Admin quiz" => "Kvízek adminisztrálása",
"Admin trackers" => "Űrlapok adminisztrálása",
"Send newsletters" => "Hírlevél kiküldése",
"Ephemerides" => "Napi idézetek",
"Admin home" => "Adminisztrációs főoldal",
"RSS modules" => "RSS modulok",
"Backups" => "Adatmentések",
"Dynamic content" => "Dinamikus tartalom",
"Edit languages" => "Nyelvek szerkesztése",
"External wikis" => "Külső wikik",
"System Admin" => "Cache/rendszer adminisztrálása",
"Click here to manage your personal menu" => "Innen szerkeszthetem a saját menüm",
"Quick edit a Wiki page" => "Wiki oldal szerkesztése",
"Language: " => "Nyelv: ",
"read more" => "Bővebben",
"Edit plugin icon" => "Plugin szerkesztés ikon",
"underscores" => "aláhúzás",
"colons" => "kettőspont",
"some text" => "tetszőleges szöveg",
"equals" => "egyenlőségjel",
"One carat" => "Egy háztető",
"Creates a box with the data" => "Dobozt hoz létre az adatok köré",
"creates a title bar" => "Címlécet hoz létre",
"make headings" => "címsorokat hoz létre",
"make autonumbered headings" => "automatikusan számozott címsorokat hoz létre",
"creates a table" => "táblát hoz létre",
"makes a horizontal rule" => "vízszintes vonalat húz",
"page|desc" => "oldalnév|megjelenő leírás",
"displays an image" => "megjelenít egy képet",
"imalign, height, width, desc, link, rel, title, usemap, class and align are optional" => "imalign, height, width, desc, link, rel, title, usemap, class és align paraméterek opcinálisak",
"Non cacheable images" => "Nem cache-elhető képek",
"height width desc link and align are optional" => "a height width desc link és align paraméterek opcionálisak",
"Wiki File Attachments" => "Wiki fájlmellékletek",
"Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Linket hoz létre a megnevezett fájlhoz. Ha az oldal nincs megadva akkor a fájlt csatolni kell a jelenlegi oldalhoz. Ha nincs megadva leírás akkor a fájl neve kerül felhasználásra link szövegeként, hacsak a showdesc beállítás nincs használva, ebben az esetben ugyanis a fájl leírása kerül felhasználásra a link szövegeként. Ha image=1 megadásra került akkor a melléklet képként lesz kezelve és közvetlenül az oldalon jelenik meg, link nem kerül generálásra.",
"displays rss feed with id=n maximum=m items" => "rss feed-eket jelenít meg a következő paraméterekkel: id=n maximum=m tétel",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Az id=n dinamikus tartalom blokk aktuális értékével lesz kitöltve",
"\"~pp~ data ~/pp~\" Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  \"~pre~ data ~/pre~\" also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text." => "\"~pp~ data ~/pp~\" Megjeleníti az előformázott szöveget/kódot; a szekción belül nincs Wiki feldolgozás (úgy mint np-nél), az elválasztás rögzített (nincs szótörés).  \"~pre~ data ~/pre~\" megjelenít előformázott szöveget rögzített elválasztással de wiki feldolgozás is történik a szövegen.",
"\"~tc~ Tiki Comment ~/tc~\" makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  \"~hc~ HTML Comment ~/hc~\" makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar." => "\"~tc~ Tiki komment ~/tc~\" tiki kommentet csinál. Nem kerül megjelenítésre de eltárolódik a fájlban.  \"~hc~ HTML komment ~/hc~\" HTML kommentet csinál. Kommentként kerül beillesztésre a HTML fájlba; ezek általában nem jelenítődnek meg a böngészőkben de láthatóak pld a forráskód megtekintésekor.",
"\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" - tartalomjegyzéket hoz létre az oldal struktúrájából (toc) vagy !címsorokból (maketoc)",
"Misc" => "Különleges",
"Plugin Help" => "Plugin súgó",
"Activate/deactivate plugins" => "Pluginok be/kikapcsolása",
"Must Change Password" => "Jelszót kell változtatni",
"Watch" => "Figyelés",
"Click to Navigate" => "Kattintás navigáláshoz",
"Focus:" => "Fókusz:",
"Tiki email notification" => "Tiki E-mail értesítés",
"Reg users can change theme" => "Regisztrált felhasználók megváltoztathatják a stílust",
"If the page does not exist, Tiki will create it" => "Ha az oldal még nem létezik akkor létre lesz hozva",
"Create/Edit Newsletters" => "Hírlevelek létrehozása/szerkesztése",
"Creates an indentation for each plus(useful in list to continue at the same level)" => "Minden + jellel eggyel beljebb húzza (hasznos listázások ugyanazon szinten történő folytatására)",
"Last seen in wiki page <a href=\"%0\">%1</a>" => "Legutóbb észlelve ebben a wiki oldalban: <a href=\"%0\">%1</a>",
"Tiki Shoutbox" => "Tiki üzenőfal",
"Allow sites in this category" => "Weblapok enegedélyezése ebben a kategóriában",
"Show number of sites in this category" => "A kategóriában található weblapok számának megjelenítése",
"Subcategories" => "Alkategóriák",
"Admin related categories" => "Kapcsolódó kategóriák adminisztrálása",
"Add a Category" => "Kategória hozzáadása",
"in current category" => "jelen kategóriában",
"Total categories" => "Összes kategória",
"Days online" => "Működési napok száma",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "Cookies must be allowed to vote" => "Cookies must be allowed to vote",
// "Re" => "Re",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "This script cannot be called directly" => "This script cannot be called directly",
// "Tiki is unable to connect to the database " => "Tiki is unable to connect to the database ",
// "Tiki was unable to retrieve login data from the database " => "Tiki was unable to retrieve login data from the database ",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Is your database up and running" => "Is your database up and running",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "This feature is for admins only" => "This feature is for admins only",
// "ID" => "ID",
// "Explorer" => "Explorer",
// "Slideshow" => "Slideshow",
// "Aland_Islands" => "Aland_Islands",
// "American_Samoa" => "American_Samoa",
// "Bosnia_and_Herzegovina" => "Bosnia_and_Herzegovina",
// "Bouvet_Island" => "Bouvet_Island",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "British_Indian_Ocean_Territory" => "British_Indian_Ocean_Territory",
// "British_Virgin_Islands" => "British_Virgin_Islands",
// "Burkina_Faso" => "Burkina_Faso",
// "Cape_Verde" => "Cape_Verde",
// "Catalan Countries" => "Catalan Countries",
// "Catalan_Countries" => "Catalan_Countries",
// "Cayman_Islands" => "Cayman_Islands",
// "Central African Republic" => "Central African Republic",
// "Central_African_Republic" => "Central_African_Republic",
// "Christmas_Island" => "Christmas_Island",
// "Cocos Islands" => "Cocos Islands",
// "Cocos_Islands" => "Cocos_Islands",
// "Comoros" => "Comoros",
// "Congo Democratic" => "Congo Democratic",
// "Congo_Democratic" => "Congo_Democratic",
// "Cook Islands" => "Cook Islands",
// "Cook_Islands" => "Cook_Islands",
// "Costa_Rica" => "Costa_Rica",
// "Czech_Republic" => "Czech_Republic",
// "Djibouti" => "Djibouti",
// "Dominican_Republic" => "Dominican_Republic",
// "El_Salvador" => "El_Salvador",
// "Equatorial_Guinea" => "Equatorial_Guinea",
// "Falkland_Islands" => "Falkland_Islands",
// "Faroe_Islands" => "Faroe_Islands",
// "Federated States of Micronesia" => "Federated States of Micronesia",
// "Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
// "French Southern Territories" => "French Southern Territories",
// "French_Guiana" => "French_Guiana",
// "French_Polynesia" => "French_Polynesia",
// "French_Southern_Territories" => "French_Southern_Territories",
// "Georgia" => "Georgia",
// "Guadeloupe" => "Guadeloupe",
// "Guam" => "Guam",
// "Guernsey" => "Guernsey",
// "Guinea Bissau" => "Guinea Bissau",
// "Guinea_Bissau" => "Guinea_Bissau",
// "Guyana" => "Guyana",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Heard_Island_and_McDonald_Islands" => "Heard_Island_and_McDonald_Islands",
// "Hong_Kong" => "Hong_Kong",
// "Isle of Man" => "Isle of Man",
// "Ivory Coast" => "Ivory Coast",
// "Ivory_Coast" => "Ivory_Coast",
// "Jersey" => "Jersey",
// "Lesotho" => "Lesotho",
// "Marshall Islands" => "Marshall Islands",
// "Marshall_Islands" => "Marshall_Islands",
// "Martinique" => "Martinique",
// "Mauritius" => "Mauritius",
// "Mayotte" => "Mayotte",
// "Montserrat" => "Montserrat",
// "Netherlands_Antilles" => "Netherlands_Antilles",
// "New_Caledonia" => "New_Caledonia",
// "New_Zealand" => "New_Zealand",
// "Norfolk_Island" => "Norfolk_Island",
// "North_Korea" => "North_Korea",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "Northern_Mariana_Islands" => "Northern_Mariana_Islands",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto Rico" => "Puerto Rico",
// "Puerto_Rico" => "Puerto_Rico",
// "Quatar" => "Quatar",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Republic_of_Macedonia" => "Republic_of_Macedonia",
// "Reunion" => "Reunion",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Russian Federation" => "Russian Federation",
// "Russian_Federation" => "Russian_Federation",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "Saint_Helena" => "Saint_Helena",
// "Saint_Kitts_and_Nevis" => "Saint_Kitts_and_Nevis",
// "Saint_Lucia" => "Saint_Lucia",
// "Saint_Pierre_and_Miquelon" => "Saint_Pierre_and_Miquelon",
// "Samoa" => "Samoa",
// "San Marino" => "San Marino",
// "San_Marino" => "San_Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Sao_Tome_and_Principe" => "Sao_Tome_and_Principe",
// "Saudi Arabia" => "Saudi Arabia",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "Sierra_Leone" => "Sierra_Leone",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon Islands" => "Solomon Islands",
// "Solomon_Islands" => "Solomon_Islands",
// "Somalia" => "Somalia",
// "South Africa" => "South Africa",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "South Korea" => "South Korea",
// "South_Africa" => "South_Africa",
// "South_Georgia_and_South_Sandwich_Islands" => "South_Georgia_and_South_Sandwich_Islands",
// "South_Korea" => "South_Korea",
// "Spain" => "Spain",
// "Sri Lanka" => "Sri Lanka",
// "Sri_Lanka" => "Sri_Lanka",
// "St Vincent Grenadines" => "St Vincent Grenadines",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Sudan" => "Sudan",
// "Surinam" => "Surinam",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Svalbard_and_Jan_Mayen" => "Svalbard_and_Jan_Mayen",
// "Swaziland" => "Swaziland",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Syria" => "Syria",
// "Taiwan" => "Taiwan",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Thailand" => "Thailand",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tonga" => "Tonga",
// "Trinidad Tobago" => "Trinidad Tobago",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Tunisia" => "Tunisia",
// "Turkey" => "Turkey",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Turks_and_Caicos_Islands" => "Turks_and_Caicos_Islands",
// "Tuvalu" => "Tuvalu",
// "US Virgin Islands" => "US Virgin Islands",
// "US_Virgin_Islands" => "US_Virgin_Islands",
// "Uganda" => "Uganda",
// "Ukraine" => "Ukraine",
// "United Arab Emirates" => "United Arab Emirates",
// "United Kingdom" => "United Kingdom",
// "United Nations Organization" => "United Nations Organization",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "United States" => "United States",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_Kingdom_-_England_and_Wales" => "United_Kingdom_-_England_and_Wales",
// "United_Kingdom_-_Northern_Ireland" => "United_Kingdom_-_Northern_Ireland",
// "United_Kingdom_-_Scotland" => "United_Kingdom_-_Scotland",
// "United_Nations_Organization" => "United_Nations_Organization",
// "United_States" => "United_States",
// "United_States_Minor_Outlying_Islands" => "United_States_Minor_Outlying_Islands",
// "Uruguay" => "Uruguay",
// "Uzbekistan" => "Uzbekistan",
// "Vanuatu" => "Vanuatu",
// "Vatican" => "Vatican",
// "Venezuela" => "Venezuela",
// "Viet Nam" => "Viet Nam",
// "Viet_Nam" => "Viet_Nam",
// "Wales" => "Wales",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Wallis_and_Futuna" => "Wallis_and_Futuna",
// "Western Sahara" => "Western Sahara",
// "Western_Sahara" => "Western_Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "the former Yugoslav Republic of Macedonia" => "the former Yugoslav Republic of Macedonia",
// "the_former_Yugoslav_Republic_of_Macedonia" => "the_former_Yugoslav_Republic_of_Macedonia",
// "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter" => "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter",
// "MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Requires MySQL 4.1+",
// "MySQL classic (mysql)" => "MySQL classic (mysql)",
// "PostgeSQL 7.2+" => "PostgeSQL 7.2+",
// "Oracle" => "Oracle",
// "Sybase" => "Sybase",
// "SQLLite" => "SQLLite",
// "MSSQL" => "MSSQL",
// "Email address not valid, test mail not sent" => "Email address not valid, test mail not sent",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Test mail from Tiki installer " => "Test mail from Tiki installer ",
// "Tiki version" => "Tiki version",
// "PHP version" => "PHP version",
// "Server" => "Server",
// "Congratulations!\n\nYour server can send emails.\n\n" => "Congratulations!\n\nYour server can send emails.\n\n",
// "Slovene" => "Slovene",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "English British" => "English British",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "Galician" => "Galician",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Pijin Solomon" => "Pijin Solomon",
// "Serbian Latin" => "Serbian Latin",
// "Tuvaluan" => "Tuvaluan",
// "This instance of activity is already complete" => "This instance of activity is already complete",
// "Fatal error: cannot execute automatic activity \$activityId" => "Fatal error: cannot execute automatic activity \$activityId",
// "Fatal error: setting next activity to an unexisting activity" => "Fatal error: setting next activity to an unexisting activity",
// "Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Fatal error: nextActivity does not match any candidate in autorouting switch activity",
// "Fatal error: non-deterministic decision for autorouting activity" => "Fatal error: non-deterministic decision for autorouting activity",
// "Fatal error: trying to send an instance to an activity but no transition found" => "Fatal error: trying to send an instance to an activity but no transition found",
// "Cannot add transition only split activities can have more than one outbound transition" => "Cannot add transition only split activities can have more than one outbound transition",
// "Circular reference found some activity has a transition leading to itself" => "Circular reference found some activity has a transition leading to itself",
// "Process does not have a start activity" => "Process does not have a start activity",
// "Process does not have exactly one end activity" => "Process does not have exactly one end activity",
// "End activity is not reachable from start activity" => "End activity is not reachable from start activity",
// "is interactive but has no role assigned" => "is interactive but has no role assigned",
// "is non-interactive and non-autorouted but has no role assigned" => "is non-interactive and non-autorouted but has no role assigned",
// "is standalone but has transitions" => "is standalone but has transitions",
// "Role" => "Role",
// "is not mapped" => "is not mapped",
// "Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Activity '.\$res['name'].' is standalone and is using the \$instance object",
// "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method",
// "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method",
// "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method",
// "Process %d has been activated" => "Process %d has been activated",
// "Process %d has been deactivated" => "Process %d has been deactivated",
// "Process %s %s imported" => "Process %s %s imported",
// "Process %s removed" => "Process %s removed",
// "Process %s has been updated" => "Process %s has been updated",
// "Process %s has been created" => "Process %s has been created",
// "newest" => "newest",
// "oldest" => "oldest",
// "<return> for rows" => "<return> for rows",
// "Only with last version" => "Only with last version",
// "Any 2 versions" => "Any 2 versions",
// "utf-8" => "utf-8",
// "iso-8859-1" => "iso-8859-1",
// "CRLF (standard)" => "CRLF (standard)",
// "LF (some Unix MTA)" => "LF (some Unix MTA)",
// "1 hour" => "1 hour",
// "2 hours" => "2 hours",
// "10 hours" => "10 hours",
// "20 hours" => "20 hours",
// "1 year" => "1 year",
// "Consider we are always in HTTPS, but do not check" => "Consider we are always in HTTPS, but do not check",
// "crypt-md5" => "crypt-md5",
// "crypt-des" => "crypt-des",
// "Registered" => "Registered",
// "Anonymous" => "Anonymous",
// "Admins" => "Admins",
// "Use @version:x.x specified in theme css or 2.0 if not specified" => "Use @version:x.x specified in theme css or 2.0 if not specified",
// "\$feature is turned on" => "\$feature is turned on",
// "\$feature is turned off" => "\$feature is turned off",
// "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing" => "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing",
// "\$feature set to nothing" => "\$feature set to nothing",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "All Day" => "All Day",
// "New Subscriptions" => "New Subscriptions",
// "New Item in Tracker" => "New Item in Tracker",
// "Wiki" => "Wiki",
// "newsletter" => "newsletter",
// "Invalid filename (using filters for filenames)" => "Invalid filename (using filters for filenames)",
// "(not registered)" => "(not registered)",
// "You have mistyped the anti-bot verification code; please try again" => "You have mistyped the anti-bot verification code; please try again",
// "Please wait %d secondes between posts" => "Please wait %d secondes between posts",
// "A contribution is mandatory" => "A contribution is mandatory",
// "You have to enter a title and text" => "You have to enter a title and text",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval, the message will be posted after a moderator approves it" => "Your message has been queued for approval, the message will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "Foo" => "Foo",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::apply: line count mismatch: %s != %s",
// "WikiDiff::_check: failed" => "WikiDiff::_check: failed",
// "WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_check: edit sequence is non-optimal",
// "WikiDiff Okay: LCS = %s" => "WikiDiff Okay: LCS = %s",
// "Line" => "Line",
// "Lines" => "Lines",
// "Newsletter subscription information at" => "Newsletter subscription information at",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to" => "Select a Wiki page to link to",
// "Link" => "Link",
// "Cannot open this file" => "Cannot open this file",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "Invalid imagename (using filters for filenames)" => "Invalid imagename (using filters for filenames)",
// "Upload was not successful" => "Upload was not successful",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "Contributions" => "Contributions",
// "Query point" => "Query point",
// "layer" => "layer",
// "Record" => "Record",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "User Map Generated in" => "User Map Generated in",
// "Image Map Generated in" => "Image Map Generated in",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "menu" => "menu",
// "NONE" => "NONE",
// "File %s not found" => "File %s not found",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "section edit" => "section edit",
// "This poll is closed" => "This poll is closed",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "Forums last posts" => "Forums last posts",
// "Wiki last files" => "Wiki last files",
// "Wiki top articles" => "Wiki top articles",
// "Most active blogs" => "Most active blogs",
// "Blogs last posts" => "Blogs last posts",
// "Top article authors" => "Top article authors",
// "The passwords do not match" => "The passwords do not match",
// "Wrong registration code" => "Wrong registration code",
// "Invalid username" => "Invalid username",
// "Username is too long" => "Username is too long",
// "Username cannot contain whitespace" => "Username cannot contain whitespace",
// "Wrong passcode you need to know the passcode to register in this site" => "Wrong passcode you need to know the passcode to register in this site",
// "Invalid email address. You must enter a valid email address" => "Invalid email address. You must enter a valid email address",
// "The registration mail can't be sent. Contact the administrator" => "The registration mail can't be sent. Contact the administrator",
// "Feed provided by %s. Click to visit" => "Feed provided by %s. Click to visit",
// "Directory category" => "Directory category",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "You need either JQuery or MooTools enabled for this feature" => "You need either JQuery or MooTools enabled for this feature",
// "The text is" => "The text is",
// "character(s) too long - please edit it" => "character(s) too long - please edit it",
// "phplayers are not available on this site" => "phplayers are not available on this site",
// "Invert Sort" => "Invert Sort",
// "Text cut here" => "Text cut here",
// "(idle for %s seconds)" => "(idle for %s seconds)",
// "More info about \$other_user" => "More info about \$other_user",
// "(idle for \$idletime seconds)" => "(idle for \$idletime seconds)",
// "No pageviews yet" => "No pageviews yet",
// "n/a" => "n/a",
// "Use this tree to copy the structure" => "Use this tree to copy the structure",
// "created from structure" => "created from structure",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "img-g" => "img-g",
// "file-g" => "file-g",
// "arts" => "arts",
// "Click to edit dynamic variable" => "Click to edit dynamic variable",
// "You are not allowed to upload this type of file" => "You are not allowed to upload this type of file",
// "The file you are trying upload was only partially uploaded" => "The file you are trying upload was only partially uploaded",
// "%d points" => "%d points",
// "Upload was not successful. Duplicate file content " => "Upload was not successful. Duplicate file content ",
// "Tracker was modified at " => "Tracker was modified at ",
// "View the tracker item at" => "View the tracker item at",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "ip selector" => "ip selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "No extra information for that attached file. " => "No extra information for that attached file. ",
// "(AT)" => "(AT)",
// "(DOT)" => "(DOT)",
// "The administrator has not yet validated your account. Please wait" => "The administrator has not yet validated your account. Please wait",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info" => "Info",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "linktext" => "linktext",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Image annotations changed" => "Image annotations changed",
// "Displays an image and allow the users to define zones to highlight information on the image" => "Displays an image and allow the users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "Insert a banner" => "Insert a banner",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "Sameas" => "Sameas",
// "Tag to existing footnote" => "Tag to existing footnote",
// "CheckDuplicate" => "CheckDuplicate",
// "check for duplcate footnotes" => "check for duplcate footnotes",
// "Inserts a section for collected footnotes within the wiki page" => "Inserts a section for collected footnotes within the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Frame title" => "Frame title",
// " (experimental - possible successor to img in 4.0)" => " (experimental - possible successor to img in 4.0)",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)" => "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Include a page\\'s content" => "Include a page\\'s content",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Insert a javascript file or/and some javascript code" => "Insert a javascript file or/and some javascript code",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Initial" => "Initial",
// "txt" => "txt",
// "Structure Head" => "Structure Head",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Related to Find" => "Related to Find",
// "For List Pages" => "For List Pages",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// ".ext" => ".ext",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Extents" => "Extents",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "One of" => "One of",
// "Padding" => "Padding",
// "MWTable" => "MWTable",
// "wiki_classes" => "wiki_classes",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text" => "Takes regex expressions and parses the content between the REGEX tags and replaces the text",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace" => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace",
// "This data is put in a CODE caption" => "This data is put in a CODE caption",
// "Missing url parameter for SNARF plugin" => "Missing url parameter for SNARF plugin",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Top Friends" => "Top Friends",
// "Maximum result count" => "Maximum result count",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// ", " => ", ",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "width" => "width",
// "height" => "height",
// "quality" => "quality",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "list topics with links to the articles" => "list topics with links to the articles",
// "Article Topics" => "Article Topics",
// "Categorize %s in %s" => "Categorize %s in %s",
// "Please provide an Id" => "Please provide an Id",
// "no object here yet" => "no object here yet",
// "List by month" => "List by month",
// "Please wait.." => "Please wait..",
// "updated tracker items" => "updated tracker items",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can browse the calendar" => "Can browse the calendar",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Can admin categories" => "Can admin categories",
// "Can edit items in categories" => "Can edit items in categories",
// "Can view categories" => "Can view categories",
// "Can view categorized items" => "Can view categorized items",
// "Can search on objects of this category" => "Can search on objects of this category",
// "Can admin charts" => "Can admin charts",
// "Autovalidate suggestions" => "Autovalidate suggestions",
// "Can suggest items" => "Can suggest items",
// "Can view charts" => "Can view charts",
// "Can vote" => "Can vote",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Can use the chat system" => "Can use the chat system",
// "Can admin the cms" => "Can admin the cms",
// "Can approve submissions" => "Can approve submissions",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Can edit articles" => "Can edit articles",
// "Can edit submissions" => "Can edit submissions",
// "Can read articles" => "Can read articles",
// "Can remove articles" => "Can remove articles",
// "Can remove submissions" => "Can remove submissions",
// "Can submit articles" => "Can submit articles",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can admin contributions" => "Can admin contributions",
// "Can admin the directory" => "Can admin the directory",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Submited links are valid" => "Submited links are valid",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can validate submited links" => "Can validate submited links",
// "Can use the directory" => "Can use the directory",
// "Can admin drawings" => "Can admin drawings",
// "Can edit drawings" => "Can edit drawings",
// "Can admin faqs" => "Can admin faqs",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can view faqs" => "Can view faqs",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Can admin users" => "Can admin users",
// "Can access site when closed" => "Can access site when closed",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Can ban users or ips" => "Can ban users or ips",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin rss modules" => "Can admin rss modules",
// "Can clean cache" => "Can clean cache",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can admin cookies" => "Can admin cookies",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit site templates" => "Can edit site templates",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view referer stats" => "Can view referer stats",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can admin blogs" => "Can admin blogs",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can post to a blog" => "Can post to a blog",
// "Can create a blog" => "Can create a blog",
// "Can read blogs" => "Can read blogs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can create file galleries" => "Can create file galleries",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can upload files" => "Can upload files",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view file galleries" => "Can view file galleries",
// "Can admin forums" => "Can admin forums",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can post in forums" => "Can post in forums",
// "Can start threads in forums" => "Can start threads in forums",
// "Can read forums" => "Can read forums",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can create image galleries" => "Can create image galleries",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload images" => "Can upload images",
// "Can browse freetags" => "Can browse freetags",
// "Can view image galleries" => "Can view image galleries",
// "Can admin games" => "Can admin games",
// "Can play games" => "Can play games",
// "Can admin newsletters" => "Can admin newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can vote polls" => "Can vote polls",
// "Can view poll voters" => "Can view poll voters",
// "Can admin quicktags" => "Can admin quicktags",
// "Can admin quizzes" => "Can admin quizzes",
// "Can take quizzes" => "Can take quizzes",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view user quiz results" => "Can view user quiz results",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can view shoutbox" => "Can view shoutbox",
// "Can admin surveys" => "Can admin surveys",
// "Can take surveys" => "Can take surveys",
// "Can view survey stats" => "Can view survey stats",
// "Can admin trackers" => "Can admin trackers",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can list trackers" => "Can list trackers",
// "Can change tracker items" => "Can change tracker items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can admin the wiki" => "Can admin the wiki",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can edit pages" => "Can edit pages",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can create and edit structures" => "Can create and edit structures",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can lock pages" => "Can lock pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can remove" => "Can remove",
// "Can rename pages" => "Can rename pages",
// "Can rollback pages" => "Can rollback pages",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can view page/pages" => "Can view page/pages",
// "Can watch structure" => "Can watch structure",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin workflow processes" => "Can admin workflow processes",
// "Can abort a process instance" => "Can abort a process instance",
// "Can declare an instance as exception" => "Can declare an instance as exception",
// "Can send instances after completion" => "Can send instances after completion",
// "Can execute workflow activities" => "Can execute workflow activities",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can configure modules" => "Can configure modules",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the newsreader" => "Can use the newsreader",
// "Can use the notepad" => "Can use the notepad",
// "Can admin public tasks" => "Can admin public tasks",
// "Can use tasks" => "Can use tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can upload personal files" => "Can upload personal files",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can use the messaging system" => "Can use the messaging system",
// "Can admin comments" => "Can admin comments",
// "Can edit all comments" => "Can edit all comments",
// "Can post new comments" => "Can post new comments",
// "Can read comments" => "Can read comments",
// "Can delete comments" => "Can delete comments",
// "Can vote comments" => "Can vote comments",
// "Can admin content templates" => "Can admin content templates",
// "Can edit content templates" => "Can edit content templates",
// "Can use content templates" => "Can use content templates",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can view HTML pages" => "Can view HTML pages",
// "Can list registered users" => "Can list registered users",
// "Admin live support system" => "Admin live support system",
// "Can use live support system" => "Can use live support system",
// "Can create new mapfile" => "Can create new mapfile",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use webmail" => "Can use webmail",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wysiwyg toolbar" => "wysiwyg toolbar",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastmodif" => "fgal list lastmodif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "change password" => "change password",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki workflow" => "users prefs mytiki workflow",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "validateRegistration" => "validateRegistration",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature newsreader" => "feature newsreader",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "feature charts" => "feature charts",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth create user tiki" => "auth create user tiki",
// "auth create user auth" => "auth create user auth",
// "auth skip admin" => "auth skip admin",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "feature games" => "feature games",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature swfobj" => "feature swfobj",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "quicktags over textarea" => "quicktags over textarea",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "feature floating help" => "feature floating help",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty security" => "smarty security",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature drawings" => "feature drawings",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature workflow" => "feature workflow",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session db" => "session db",
// "session lifetime" => "session lifetime",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "system os" => "system os",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "feature mootools" => "feature mootools",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "use minified scripts" => "use minified scripts",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature tikitests" => "feature tikitests",
// "feature magic" => "feature magic",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "transition style ver" => "transition style ver",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "country" => "country",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki workflow" => "mytiki workflow",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "Anti-Bot verification code" => "Anti-Bot verification code",
// "Random Image" => "Random Image",
// "Enter the code you see above" => "Enter the code you see above",
// "RSS feed" => "RSS feed",
// "Watched by categories" => "Watched by categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "top of page" => "top of page",
// "Report this post" => "Report this post",
// "Comments are locked" => "Comments are locked",
// "Reply to the selected post" => "Reply to the selected post",
// "Comment on the selected post" => "Comment on the selected post",
// "Enter your name" => "Enter your name",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Reply to parent post" => "Reply to parent post",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Post as Anonymous" => "Post as Anonymous",
// "Your comment will have to be approved by the moderator before it is displayed" => "Your comment will have to be approved by the moderator before it is displayed",
// "Syntax" => "Syntax",
// "Page generation debugging log" => "Page generation debugging log",
// "Features state" => "Features state",
// "features matched" => "features matched",
// "Watchlist" => "Watchlist",
// "duplicate" => "duplicate",
// "There are individual permissions set for this file gallery" => "There are individual permissions set for this file gallery",
// "Please login" => "Please login",
// "Private Gallery" => "Private Gallery",
// "Active Perms" => "Active Perms",
// "Upload New Version" => "Upload New Version",
// "Download and lock" => "Download and lock",
// "Name-filename" => "Name-filename",
// "Filename only" => "Filename only",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "any type" => "any type",
// "Clear Filter" => "Clear Filter",
// "Show php error messages" => "Show php error messages",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "RSS Wiki" => "RSS Wiki",
// "RSS Blogs" => "RSS Blogs",
// "RSS Articles" => "RSS Articles",
// "RSS Image Galleries" => "RSS Image Galleries",
// "RSS File Galleries" => "RSS File Galleries",
// "RSS Forums" => "RSS Forums",
// "RSS Maps" => "RSS Maps",
// "RSS Directories" => "RSS Directories",
// "RSS Calendars" => "RSS Calendars",
// "Loading" => "Loading",
// "\\074span class=\"shortcut\"\\076C\\074/span\\076lose" => "\\074span class=\"shortcut\"\\076C\\074/span\\076lose",
// "\\074span class=\"shortcut\"\\076N\\074/span\\076ext" => "\\074span class=\"shortcut\"\\076N\\074/span\\076ext",
// "\\074span class=\"shortcut\"\\076P\\074/span\\076revious" => "\\074span class=\"shortcut\"\\076P\\074/span\\076revious",
// "Are you sure you want to delete the selected files" => "Are you sure you want to delete the selected files",
// "No Additionnal Sort" => "No Additionnal Sort",
// "Hi {\$mail_user} has sent you this link" => "Hi {\$mail_user} has sent you this link",
// "Somebody or you tried to subscribe this email address at our site" => "Somebody or you tried to subscribe this email address at our site",
// "To the newsletter" => "To the newsletter",
// "In order to confirm your subscription you must access the following URL" => "In order to confirm your subscription you must access the following URL",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "A new message was posted to forum" => "A new message was posted to forum",
// "You sent a request with the subject" => "You sent a request with the subject",
// "Use the subject to indicate the operation to apply" => "Use the subject to indicate the operation to apply",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in instructions" => "Tiki mail-in instructions",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Page not found" => "Page not found",
// "Hi" => "Hi",
// "A new message was posted to you at {\$mail_machine}" => "A new message was posted to you at {\$mail_machine}",
// "New message arrived from %s" => "New message arrived from %s",
// "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now" => "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now",
// "To login with your username and password, please follow this link" => "To login with your username and password, please follow this link",
// "Enjoy the site" => "Enjoy the site",
// "User Account Activated" => "User Account Activated",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "has requested an account on" => "has requested an account on",
// "To validate that account, please follow the link" => "To validate that account, please follow the link",
// "best regards" => "best regards",
// "your Tikiwiki" => "your Tikiwiki",
// "User Tracker" => "User Tracker",
// "User Registration Request" => "User Registration Request",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "You're invited to join my network of friends" => "You're invited to join my network of friends",
// "The user" => "The user",
// "registered at your site" => "registered at your site",
// "New user registration" => "New user registration",
// "Bye bye" => "Bye bye",
// "This email address has been removed to the list of subscriptors of" => "This email address has been removed to the list of subscriptors of",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "You can unsubscribe from this newsletter following this link" => "You can unsubscribe from this newsletter following this link",
// "Welcome to our newsletter" => "Welcome to our newsletter",
// "This email address has been added to the list of subscriptors of" => "This email address has been added to the list of subscriptors of",
// "You can always cancel your subscription using" => "You can always cancel your subscription using",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above" => "Important: The old password remains active if you don't click the link above",
// "Your account information for %s" => "Your account information for %s",
// "A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}",
// "You can edit the submission following this link" => "You can edit the submission following this link",
// "New article submitted at %s" => "New article submitted at %s",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Tracker was modified at" => "Tracker was modified at",
// "Please visit this link before login again" => "Please visit this link before login again",
// "Last attempt" => "Last attempt",
// "Confirm your account at %s" => "Confirm your account at %s",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "You or someone registered this email address at" => "You or someone registered this email address at",
// "If you want to be a registered user in this site you will have to use the following link to login for the first time" => "If you want to be a registered user in this site you will have to use the following link to login for the first time",
// "Your registration confirmation" => "Your registration confirmation",
// "You will receive an email with information to login for the first time into this site" => "You will receive an email with information to login for the first time into this site",
// "Your account request has been stored and will be activated by the admin as soon as possible" => "Your account request has been stored and will be activated by the admin as soon as possible",
// "You'll receive email notification once your account is activated" => "You'll receive email notification once your account is activated",
// "Please do not attempt to login until you receive the email notification" => "Please do not attempt to login until you receive the email notification",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "View the article at" => "View the article at",
// "If you don't want to receive these notifications follow this link" => "If you don't want to receive these notifications follow this link",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}",
// "View the blog at" => "View the blog at",
// "New blog post at %s" => "New blog post at %s",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "changed" => "changed",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "Removed by" => "Removed by",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "updated" => "updated",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the updated map following this link" => "You can view the updated map following this link",
// "You can edit the map following this link" => "You can edit the map following this link",
// "A page has been added to your watched sub-structure" => "A page has been added to your watched sub-structure",
// "A page has been removed from your watched sub-structure" => "A page has been removed from your watched sub-structure",
// "A page has been promoted out your watched sub-structure" => "A page has been promoted out your watched sub-structure",
// "A page has been demoted to your watched structure" => "A page has been demoted to your watched structure",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "You can view the page by following this link" => "You can view the page by following this link",
// "You can view a diff back to the previous version by following this link" => "You can view a diff back to the previous version by following this link",
// "The changes in this version follow below, followed after by the current full page text" => "The changes in this version follow below, followed after by the current full page text",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "The old page content follows below" => "The old page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "click on the map to zoom or pan, do not drag" => "click on the map to zoom or pan, do not drag",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Scale" => "Scale",
// "Zoom out" => "Zoom out",
// "Query" => "Query",
// "Pan" => "Pan",
// "Zoom in" => "Zoom in",
// "Redraw" => "Redraw",
// "select zoom/pan/query and image size" => "select zoom/pan/query and image size",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Click on the map or click redraw" => "Click on the map or click redraw",
// "Overview" => "Overview",
// "Layer Manager" => "Layer Manager",
// "Layer" => "Layer",
// "On" => "On",
// "Download Layer" => "Download Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "you have requested to download the layer" => "you have requested to download the layer",
// "from the mapfile" => "from the mapfile",
// "Here are the files to download, do not forget to rename them" => "Here are the files to download, do not forget to rename them",
// "Mapfile" => "Mapfile",
// "hits last 7 days" => "hits last 7 days",
// "monitor this map" => "monitor this map",
// "Stop Monitoring this Map" => "Stop Monitoring this Map",
// "Create a new mapfile" => "Create a new mapfile",
// "Mapfile listing" => "Mapfile listing",
// "You can view this map in your browser using" => "You can view this map in your browser using",
// "Zoom out x2" => "Zoom out x2",
// "Zoom in x2" => "Zoom in x2",
// "Mapfile History" => "Mapfile History",
// "Comparing version {\$old.version} with version {\$new.version}" => "Comparing version {\$old.version} with version {\$new.version}",
// "Full side-by-side diff" => "Full side-by-side diff",
// "Unified diff" => "Unified diff",
// "Side-by-side view" => "Side-by-side view",
// "back to" => "back to",
// "Bytes maximum" => "Bytes maximum",
// "index file (.shp)" => "index file (.shp)",
// "files to index (regexp)" => "files to index (regexp)",
// "Message Archive" => "Message Archive",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "is reply to" => "is reply to",
// "Find replied message" => "Find replied message",
// "Auto-archive age for read messages" => "Auto-archive age for read messages",
// "Return to mailbox" => "Return to mailbox",
// "Unflag" => "Unflag",
// "Cc" => "Cc",
// "Return to archive" => "Return to archive",
// "Return to outbox" => "Return to outbox",
// "Sent Messages" => "Sent Messages",
// "Not replied" => "Not replied",
// "move to archive" => "move to archive",
// "receiver" => "receiver",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "Move module up" => "Move module up",
// "Move module down" => "Move module down",
// "Move module to opposite side" => "Move module to opposite side",
// "opp side" => "opp side",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module" => "Are you sure you want to unassign this module",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "\$tpl_module_title" => "\$tpl_module_title",
// "Search Stats" => "Search Stats",
// "Chat" => "Chat",
// "Admin Drawings" => "Admin Drawings",
// "Referer Stats" => "Referer Stats",
// "Import PHPWiki Dump" => "Import PHPWiki Dump",
// "phpinfo" => "phpinfo",
// "External Wikis" => "External Wikis",
// "Syntax Highlighting" => "Syntax Highlighting",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number " => "You forgot your Google ad_client number ",
// "\$module_title" => "\$module_title",
// "To configure your Tiki" => "To configure your Tiki",
// "Select" => "Select",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as the Admin" => "as the Admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "Last `\$module_rows` blog comments" => "Last `\$module_rows` blog comments",
// "Last blog comments" => "Last blog comments",
// "on blogpost" => "on blogpost",
// "\$modcattitle" => "\$modcattitle",
// "Last `\$module_rows` Sites" => "Last `\$module_rows` Sites",
// "Top \$module_rows Sites" => "Top \$module_rows Sites",
// "Current events" => "Current events",
// "Top `\$module_rows` topics" => "Top `\$module_rows` topics",
// "Last `\$module_rows` forum posts" => "Last `\$module_rows` forum posts",
// "Last forum posts" => "Last forum posts",
// "Last `\$module_rows` forum topics" => "Last `\$module_rows` forum topics",
// "Folksonomy" => "Folksonomy",
// "Tags This Page Has" => "Tags This Page Has",
// "My prefered tags" => "My prefered tags",
// "Last `\$module_rows` actions" => "Last `\$module_rows` actions",
// "Last `\$module_rows` articles" => "Last `\$module_rows` articles",
// "Last `\$module_rows` blog posts" => "Last `\$module_rows` blog posts",
// "\$type" => "\$type",
// "Last `\$module_rows` Created blogs" => "Last `\$module_rows` Created blogs",
// "Last `\$module_rows` Created FAQs" => "Last `\$module_rows` Created FAQs",
// "Last `\$module_rows` Created Quizzes" => "Last `\$module_rows` Created Quizzes",
// "Last `\$module_rows` modified file galleries" => "Last `\$module_rows` modified file galleries",
// "Last `\$module_rows` Files" => "Last `\$module_rows` Files",
// "Last `\$module_rows` galleries" => "Last `\$module_rows` galleries",
// "Last `\$module_rows` Images" => "Last `\$module_rows` Images",
// "Last `\$module_rows` modified events" => "Last `\$module_rows` modified events",
// "Last modifed events" => "Last modifed events",
// "Last `\$module_rows` changes" => "Last `\$module_rows` changes",
// "Last `\$module_rows` Modified Items" => "Last `\$module_rows` Modified Items",
// "Last `\$module_rows` Modified blogs" => "Last `\$module_rows` Modified blogs",
// "Last `\$module_rows` submissions" => "Last `\$module_rows` submissions",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "Last `\$module_rows` Items" => "Last `\$module_rows` Items",
// "Last `\$module_rows` visitors" => "Last `\$module_rows` visitors",
// "You" => "You",
// "Login through CAS" => "Login through CAS",
// "Login as admin" => "Login as admin",
// "Login through Shibboleth" => "Login through Shibboleth",
// "CapsLock is on" => "CapsLock is on",
// "Click here to register" => "Click here to register",
// "Click here if you've forgotten your password" => "Click here if you've forgotten your password",
// "Click here to login using the default security protocol" => "Click here to login using the default security protocol",
// "Standard" => "Standard",
// "Click here to login using a secure protocol" => "Click here to login using a secure protocol",
// "local account" => "local account",
// "OpenID Login" => "OpenID Login",
// "What is OpenID" => "What is OpenID",
// "Tiki Logo" => "Tiki Logo",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "Your email could not be validated; make sure you email is correct and click register below" => "Your email could not be validated; make sure you email is correct and click register below",
// "Wiki RSS" => "Wiki RSS",
// "Blogs RSS" => "Blogs RSS",
// "Articles RSS" => "Articles RSS",
// "Image Galleries RSS" => "Image Galleries RSS",
// "File Galleries RSS" => "File Galleries RSS",
// "Forums RSS" => "Forums RSS",
// "Maps RSS" => "Maps RSS",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "New Tracker Items" => "New Tracker Items",
// "New Calendar Events" => "New Calendar Events",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "Top `\$module_rows` articles" => "Top `\$module_rows` articles",
// "Top `\$module_rows` File Galleries" => "Top `\$module_rows` File Galleries",
// "Top `\$module_rows` files" => "Top `\$module_rows` files",
// "Top files" => "Top files",
// "Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
// "Top Forum Posters" => "Top Forum Posters",
// "Top `\$module_rows` games" => "Top `\$module_rows` games",
// "Top `\$module_rows` galleries" => "Top `\$module_rows` galleries",
// "Top `\$module_rows` Images" => "Top `\$module_rows` Images",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Top `\$module_rows` Pages" => "Top `\$module_rows` Pages",
// "Top `\$module_rows` Quizzes" => "Top `\$module_rows` Quizzes",
// "Most `\$module_rows` visited blogs" => "Most `\$module_rows` visited blogs",
// "Top `\$module_rows` Visited FAQs" => "Top `\$module_rows` Visited FAQs",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "The Next Event" => "The Next Event",
// "No Upcoming Events" => "No Upcoming Events",
// "click to view" => "click to view",
// "Done" => "Done",
// "Public tasks" => "Public tasks",
// "select" => "select",
// "User informations" => "User informations",
// "Group informations" => "Group informations",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Top users" => "Top users",
// "Whats related" => "Whats related",
// "on host" => "on host",
// "Last `\$module_rows` wiki comments" => "Last `\$module_rows` wiki comments",
// "Last wiki comments" => "Last wiki comments",
// "on page" => "on page",
// "Videos on YouTube" => "Videos on YouTube",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "[-]" => "[-]",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "By" => "By",
// "Read more" => "Read more",
// "To edit the copyright notices" => "To edit the copyright notices",
// "The content on this page is licensed under the terms of the" => "The content on this page is licensed under the terms of the",
// "Email This Post" => "Email This Post",
// "Permalink" => "Permalink",
// "referenced by" => "referenced by",
// "references" => "references",
// "View Comments" => "View Comments",
// "Trackback pings" => "Trackback pings",
// "URI" => "URI",
// "Blog name" => "Blog name",
// "i18n" => "i18n",
// "Editing and Plugins" => "Editing and Plugins",
// "RSS" => "RSS",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "Sef URL" => "Sef URL",
// "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or",
// "Blogs Listing" => "Blogs Listing",
// "Create a blog" => "Create a blog",
// "Custom blog headings" => "Custom blog headings",
// "Blog-level" => "Blog-level",
// "Post-level" => "Post-level",
// "Blogs Listings" => "Blogs Listings",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "Default article image width" => "Default article image width",
// "Default article image height" => "Default article image height",
// "Users Listing" => "Users Listing",
// "E-mail" => "E-mail",
// "Character set for mail" => "Character set for mail",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "Floating help aka the Big Blue Help Icon" => "Floating help aka the Big Blue Help Icon",
// "Features that may change or might be re-worked in the future" => "Features that may change or might be re-worked in the future",
// "Print Indexed" => "Print Indexed",
// "Ajax auto-save" => "Ajax auto-save",
// "SWFObject" => "SWFObject",
// "SwfObject" => "SwfObject",
// "Used to embed Flash content in wiki pages, banners etc" => "Used to embed Flash content in wiki pages, banners etc",
// "Group Watches" => "Group Watches",
// "Group Alert" => "Group Alert",
// "Programmer Features" => "Programmer Features",
// "requires PHP5 or more" => "requires PHP5 or more",
// "Use Minified Scripts" => "Use Minified Scripts",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "Score is disabled" => "Score is disabled",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "System Command" => "System Command",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Spring (connection) size" => "Spring (connection) size",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Friction constant" => "Friction constant",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "Pixels Default" => "Pixels Default",
// "TikiWiki will check for updates when you access the main Administration page" => "TikiWiki will check for updates when you access the main Administration page",
// "Check for updates now" => "Check for updates now",
// "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences" => "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Use different URL as home page" => "Use different URL as home page",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "Default charset for sending mail" => "Default charset for sending mail",
// "Mail end of line" => "Mail end of line",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Include Smarty notices" => "Include Smarty notices",
// "Log mail in Tiki logs" => "Log mail in Tiki logs",
// "Log SQL" => "Log SQL",
// "Log queries using more than" => "Log queries using more than",
// "Add HTML comment at start and end of each Smarty template (TPL)" => "Add HTML comment at start and end of each Smarty template (TPL)",
// "Use these options to protect against cross-site request forgeries (CSRF)" => "Use these options to protect against cross-site request forgeries (CSRF)",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "Site Access" => "Site Access",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Enabling this feature will immediately log you out when you save this preference" => "Enabling this feature will immediately log you out when you save this preference",
// "The default help system may not be complete" => "The default help system may not be complete",
// "You can help with the TikiWiki documentation" => "You can help with the TikiWiki documentation",
// "Show user's real name instead of login (when possible)" => "Show user's real name instead of login (when possible)",
// "Highlight group" => "Highlight group",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Choices" => "Choices",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Default language" => "Default language",
// "User preferences are disabled" => "User preferences are disabled",
// "Structures are disabled" => "Structures are disabled",
// "Multilingual One Page feature" => "Multilingual One Page feature",
// "Syntax error" => "Syntax error",
// "Look and Feel" => "Look and Feel",
// "Wysiwyg" => "Wysiwyg",
// "Semantic" => "Semantic",
// "Webservices management" => "Webservices management",
// "CAS" => "CAS",
// "Tiki" => "Tiki",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Cookie name" => "Cookie name",
// "Use email as username" => "Use email as username",
// "Minimum length" => "Minimum length",
// "Maximum length" => "Maximum length",
// "Force lowercase" => "Force lowercase",
// "Username pattern" => "Username pattern",
// "Store password as plain text" => "Store password as plain text",
// "Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Store passwords in plain text is activated. You should never set this unless you know what you are doing",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords </em>are stored<em> as plain text, the password will be emailed to the user" => "If passwords </em>are stored<em> as plain text, the password will be emailed to the user",
// "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user" => "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user",
// "Encryption method" => "Encryption method",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "You must change the Authentication Method to PEAR::Auth for these changes to take effect" => "You must change the Authentication Method to PEAR::Auth for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in Auth" => "Create user if not in Auth",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "LDAP Group" => "LDAP Group",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group OC" => "Group OC",
// "LDAP Member" => "LDAP Member",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "Admin password" => "Admin password",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "Shadow layer" => "Shadow layer",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Custom End of <body> Code" => "Custom End of <body> Code",
// "Power by" => "Power by",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "JQuery Reflection" => "JQuery Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "List of CSS selectors to be fixed, each selector separated by comma" => "List of CSS selectors to be fixed, each selector separated by comma",
// "List of HTMLDomElements to be fixed, each element separated by comma" => "List of HTMLDomElements to be fixed, each element separated by comma",
// "Context Menus (only in file galleries so far)" => "Context Menus (only in file galleries so far)",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "Are you sure you want to install the profile" => "Are you sure you want to install the profile",
// "Feed for articles" => "Feed for articles",
// "Homepage URL" => "Homepage URL",
// "Feed for blogs" => "Feed for blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Feed for forums" => "Feed for forums",
// "Feed for directory" => "Feed for directory",
// "Feed for maps" => "Feed for maps",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Admin modules" => "Admin modules",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "(experimental - not comprehensively tested and requires new JQuery feature)" => "(experimental - not comprehensively tested and requires new JQuery feature)",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Engine" => "Engine",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "WikiWords" => "WikiWords",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "Polls are disabled" => "Polls are disabled",
// "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page" => "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "TikiCache/System" => "TikiCache/System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "DSN" => "DSN",
// "kb" => "kb",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Configure" => "Configure",
// "Url" => "Url",
// "Perso" => "Perso",
// "Perms inherited from closest parent if possible or from global perms" => "Perms inherited from closest parent if possible or from global perms",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}" => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}",
// "cookie" => "cookie",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link" => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link",
// "Admin External Wikis" => "Admin External Wikis",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "Create/Edit External Wiki" => "Create/Edit External Wiki",
// "ExtWiki" => "ExtWiki",
// "Enable Features" => "Enable Features",
// "Online" => "Online",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "PPD" => "PPD",
// ".." => "..",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "Edit Repository" => "Edit Repository",
// "Create New Repository" => "Create New Repository",
// "List Repositories" => "List Repositories",
// "New Repository" => "New Repository",
// "View Repository" => "View Repository",
// "Human readable repository name" => "Human readable repository name",
// "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')",
// "File name of start page" => "File name of start page",
// "CSS file to load when browse this repository" => "CSS file to load when browse this repository",
// "Is repository visible to users" => "Is repository visible to users",
// "Can files from repository be cached" => "Can files from repository be cached",
// "Cacheable" => "Cacheable",
// "Are files from repository can be cached" => "Are files from repository can be cached",
// "Clear all cached pages of this repository" => "Clear all cached pages of this repository",
// "Seconds count 'till cached page will be expired" => "Seconds count 'till cached page will be expired",
// "Cache expiration" => "Cache expiration",
// "Human readable text description of repository" => "Human readable text description of repository",
// "Available Repositories" => "Available Repositories",
// "Edit rules" => "Edit rules",
// "Edit Rules for Repository" => "Edit Rules for Repository",
// "Configure Repositories" => "Configure Repositories",
// "Configure this Repository" => "Configure this Repository",
// "View this Repository" => "View this Repository",
// "view/hide copy rules dialog" => "view/hide copy rules dialog",
// "Source repository" => "Source repository",
// "According this order rules will be applied ('0' or empty = auto)" => "According this order rules will be applied ('0' or empty = auto)",
// "Rule order" => "Rule order",
// "Text to search for" => "Text to search for",
// "Text to replace" => "Text to replace",
// "Is this regular expression or simple search/replacer" => "Is this regular expression or simple search/replacer",
// "Regex" => "Regex",
// "Is case sensitive (for simple replacer)" => "Is case sensitive (for simple replacer)",
// "Case sensitive" => "Case sensitive",
// "subset of chars: imsxeADSXUu, which is regex modifiers" => "subset of chars: imsxeADSXUu, which is regex modifiers",
// "Regex modifiers" => "Regex modifiers",
// "Human readable text description of rule" => "Human readable text description of rule",
// "Check to enable this rule" => "Check to enable this rule",
// "Enabled" => "Enabled",
// "Preview options" => "Preview options",
// "Apply all rules or just this to generate preview" => "Apply all rules or just this to generate preview",
// "Apply all rules" => "Apply all rules",
// "View source code after rules applied" => "View source code after rules applied",
// "Code preview" => "Code preview",
// "Generate HTML preview" => "Generate HTML preview",
// "HTML preview" => "HTML preview",
// "Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
// "Preview Results" => "Preview Results",
// "Rules List" => "Rules List",
// "Case" => "Case",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "Discard to the end from" => "Discard to the end from",
// "mn" => "mn",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "sorted section level 0" => "sorted section level 0",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "Folder Icon" => "Folder Icon",
// "Active Permissions" => "Active Permissions",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "Move to Right Column" => "Move to Right Column",
// "Unassign" => "Unassign",
// "Move to Left Column" => "Move to Left Column",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Visibility" => "Visibility",
// "Displayed now for all eligible users even with personal assigned modules" => "Displayed now for all eligible users even with personal assigned modules",
// "Displayed for the eligible users with no personal assigned modules" => "Displayed for the eligible users with no personal assigned modules",
// "Displayed now, can't be unassigned" => "Displayed now, can't be unassigned",
// "Not displayed until a user chooses it" => "Not displayed until a user chooses it",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "phpLayersMenus" => "phpLayersMenus",
// "Use phplayermenu" => "Use phplayermenu",
// "Use Wiki Structure" => "Use Wiki Structure",
// "Edit Newsletter" => "Edit Newsletter",
// "Create Newsletter" => "Create Newsletter",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "Span" => "Span",
// "Edit this RSS Module" => "Edit this RSS Module",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "Are you sure you want to delete this word" => "Are you sure you want to delete this word",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "This survey stats" => "This survey stats",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "Min" => "Min",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "with" => "with",
// "Create a group for each item" => "Create a group for each item",
// "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL",
// "and display last comment user/date" => "and display last comment user/date",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Use site default" => "Use site default",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a field .." => "choose a field ..",
// "Users Information Tracker" => "Users Information Tracker",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Group tracker item not found" => "Group tracker item not found",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Members List" => "Members List",
// "Remove from Group" => "Remove from Group",
// "users in group" => "users in group",
// "Add to group" => "Add to group",
// "Download CSV export" => "Download CSV export",
// "Assign users to group" => "Assign users to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "CSV File" => "CSV File",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Updated users" => "Updated users",
// "Edit user" => "Edit user",
// "ago" => "ago",
// "Need to validate email" => "Need to validate email",
// "Assign to group" => "Assign to group",
// "Edit Included Group" => "Edit Included Group",
// "Edit Group" => "Edit Group",
// "Validate user" => "Validate user",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "Template wiki page" => "Template wiki page",
// "bcc" => "bcc",
// "Assign user to Groups" => "Assign user to Groups",
// "Use the email as username" => "Use the email as username",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth" => "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Actions on this article type" => "Actions on this article type",
// "Directory batch upload" => "Directory batch upload",
// "Remove File Extension from Image Name" => "Remove File Extension from Image Name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Select a Gallery" => "Select a Gallery",
// "Process" => "Process",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "available files" => "available files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "Use Wysiwyg Editor" => "Use Wysiwyg Editor",
// "Use Normal Editor" => "Use Normal Editor",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "Upload image for this post" => "Upload image for this post",
// "Report to Webmaster" => "Report to Webmaster",
// "The TikiWiki Community" => "The TikiWiki Community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "Execution time" => "Execution time",
// "Memory usage" => "Memory usage",
// "database queries used in " => "database queries used in ",
// "Server load" => "Server load",
// "Last update from SVN" => "Last update from SVN",
// "Admin the Category System" => "Admin the Category System",
// "Upper level" => "Upper level",
// "\$feature_label" => "\$feature_label",
// "Directory Batch" => "Directory Batch",
// "Hit" => "Hit",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "You can include the image in a tiki page using one of these lines" => "You can include the image in a tiki page using one of these lines",
// "Edit Image" => "Edit Image",
// "Slideshow Forward" => "Slideshow Forward",
// "Cyclic" => "Cyclic",
// "Click to zoom" => "Click to zoom",
// "Image Scale" => "Image Scale",
// "You can include the image in an HTML page using one of these lines" => "You can include the image in an HTML page using one of these lines",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Click to select visible calendars" => "Click to select visible calendars",
// "advanced parameters" => "advanced parameters",
// "Delete event" => "Delete event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "Change Focus" => "Change Focus",
// "+" => "+",
// "o" => "o",
// "New Calendar Item" => "New Calendar Item",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "times" => "times",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Date and time of end" => "Date and time of end",
// "Events cannot end before they start" => "Events cannot end before they start",
// "Choose users to alert" => "Choose users to alert",
// "Roles" => "Roles",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "%m/%d" => "%m/%d",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Change your password" => "Change your password",
// "You can browse the generated WebHelp here" => "You can browse the generated WebHelp here",
// "Top page" => "Top page",
// "Tiki Debugger Console" => "Tiki Debugger Console",
// "exec" => "exec",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Parent directory category" => "Parent directory category",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Directory Subcategories" => "Directory Subcategories",
// "Admin related directory categories" => "Admin related directory categories",
// "Directory Category" => "Directory Category",
// "Add a Directory Category" => "Add a Directory Category",
// "in current directory category" => "in current directory category",
// "Related directory categories" => "Related directory categories",
// "Total directory categories" => "Total directory categories",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Topline" => "Topline",
// "Article image" => "Article image",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "A category is mandatory" => "A category is mandatory",
// "Edit Style Sheet" => "Edit Style Sheet",
// "Style Sheet" => "Style Sheet",
// "The file will be saved in" => "The file will be saved in",
// "choose a stylesheet" => "choose a stylesheet",
// "Try" => "Try",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "horizontal rule" => "horizontal rule",
// "New wms Metadata" => "New wms Metadata",
// "New Class" => "New Class",
// "New Projection" => "New Projection",
// "New Scalebar" => "New Scalebar",
// "New Web" => "New Web",
// "New Outputformat" => "New Outputformat",
// "New Mapfile" => "New Mapfile",
// "Add image from File Gallery" => "Add image from File Gallery",
// "Leave Fullscreen Edit" => "Leave Fullscreen Edit",
// "The following image was successfully edited" => "The following image was successfully edited",
// "Upload from disk to change the image" => "Upload from disk to change the image",
// "Save and Go Next" => "Save and Go Next",
// "reset table" => "reset table",
// "Program dynamic content for block" => "Program dynamic content for block",
// "Return to block listing" => "Return to block listing",
// "Block description: " => "Block description: ",
// "You are editing block" => "You are editing block",
// "Publishing date" => "Publishing date",
// "Publishing Date" => "Publishing Date",
// "Edit question options" => "Edit question options",
// "%" => "%",
// "canRepeat" => "canRepeat",
// "Edit quiz questions" => "Edit quiz questions",
// "Create/edit questions for quiz" => "Create/edit questions for quiz",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character" => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character",
// "Input" => "Input",
// "maxScore" => "maxScore",
// "Edit quiz results" => "Edit quiz results",
// "From Points" => "From Points",
// "To Points" => "To Points",
// "Answer" => "Answer",
// "The page already exists. The page that has been added to the structure is the existing one" => "The page already exists. The page that has been added to the structure is the existing one",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "Template listing" => "Template listing",
// "Available templates" => "Available templates",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Save Only in the Theme" => "Save Only in the Theme",
// "Delete the copy in the theme" => "Delete the copy in the theme",
// "Admin notifications" => "Admin notifications",
// "View Page" => "View Page",
// "View Article" => "View Article",
// "Unspecified" => "Unspecified",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "Update '{\$page}'" => "Update '{\$page}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "Disable" => "Disable",
// "You should ask an admin to create them" => "You should ask an admin to create them",
// "or use" => "or use",
// "an existing poll" => "an existing poll",
// "AutoSave" => "AutoSave",
// "If you want the saved version instead of the autosaved one" => "If you want the saved version instead of the autosaved one",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Autodetect" => "Autodetect",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Dump All Tracker Items" => "Dump All Tracker Items",
// "Dump" => "Dump",
// "View FAQ" => "View FAQ",
// "Edit this FAQ" => "Edit this FAQ",
// "New Question" => "New Question",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "Use a question from another FAQ" => "Use a question from another FAQ",
// "FAQ questions" => "FAQ questions",
// "Suggested questions" => "Suggested questions",
// "No suggested questions" => "No suggested questions",
// "File Archive" => "File Archive",
// "File Galleries tpl" => "File Galleries tpl",
// "Size (width x height)" => "Size (width x height)",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Edit queued message" => "Edit queued message",
// "make this a thread of" => "make this a thread of",
// "None, this is a thread message" => "None, this is a thread message",
// "No messages queued yet" => "No messages queued yet",
// "Reported messages for forum" => "Reported messages for forum",
// "Reported by" => "Reported by",
// "No records to display" => "No records to display",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Pending requests" => "Pending requests",
// "Request Time" => "Request Time",
// "Cancel friendship request" => "Cancel friendship request",
// "Admin process activities" => "Admin process activities",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Add or edit an activity" => "Add or edit an activity",
// "split" => "split",
// "join" => "join",
// "standalone" => "standalone",
// "interactive" => "interactive",
// "auto routed" => "auto routed",
// "Add transitions" => "Add transitions",
// "Add transition from" => "Add transition from",
// "Add transition to" => "Add transition to",
// "No roles associated to this activity" => "No roles associated to this activity",
// "Add Role" => "Add Role",
// "Add New" => "Add New",
// "Process activities" => "Process activities",
// "Int" => "Int",
// "Routing" => "Routing",
// "Interactive" => "Interactive",
// "Auto routed" => "Auto routed",
// "#" => "#",
// "inter" => "inter",
// "route" => "route",
// "(no roles)" => "(no roles)",
// "No activities defined yet" => "No activities defined yet",
// "Process Transitions" => "Process Transitions",
// "List of transitions" => "List of transitions",
// "No transitions defined yet" => "No transitions defined yet",
// "Add a transition" => "Add a transition",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
// "This process is invalid" => "This process is invalid",
// "Process Graph for" => "Process Graph for",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed" => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed",
// "List of processes" => "List of processes",
// "Inactive" => "Inactive",
// "act" => "act",
// "val" => "val",
// "Active Process" => "Active Process",
// "Invalid Process" => "Invalid Process",
// "Valid Process" => "Valid Process",
// "Activities" => "Activities",
// "New Minor" => "New Minor",
// "New Major" => "New Major",
// "No processes defined yet" => "No processes defined yet",
// "Admin instance" => "Admin instance",
// "Instance" => "Instance",
// "Workitems" => "Workitems",
// "exception" => "exception",
// "Aborted" => "Aborted",
// "Send all to" => "Send all to",
// "Don't move" => "Don't move",
// "Act status" => "Act status",
// "Ended" => "Ended",
// "Not Defined" => "Not Defined",
// "Not Interactive" => "Not Interactive",
// "Not Ended" => "Not Ended",
// "Property" => "Property",
// "Add property" => "Add property",
// "run instance" => "run instance",
// "Executed" => "Executed",
// "erase" => "erase",
// "Galaxia Admin Processes" => "Galaxia Admin Processes",
// "Galaxia Admin Processes tpl" => "Galaxia Admin Processes tpl",
// "Add or edit a process" => "Add or edit a process",
// "Process Name" => "Process Name",
// "ver" => "ver",
// "is active" => "is active",
// "Or upload a process using this form" => "Or upload a process using this form",
// "Admin process roles" => "Admin process roles",
// "Add or edit a role" => "Add or edit a role",
// "Process roles" => "Process roles",
// "No roles defined yet" => "No roles defined yet",
// "Map users to roles" => "Map users to roles",
// "map" => "map",
// "Map groups to roles" => "Map groups to roles",
// "Operation" => "Operation",
// "No roles are defined yet so no roles can be mapped" => "No roles are defined yet so no roles can be mapped",
// "List of mappings" => "List of mappings",
// "No mappings defined yet" => "No mappings defined yet",
// "Admin process sources" => "Admin process sources",
// "select source" => "select source",
// "Shared code" => "Shared code",
// "Set next user" => "Set next user",
// "Get property" => "Get property",
// "Set property" => "Set property",
// "Process form" => "Process form",
// "Set Next act" => "Set Next act",
// "If:SetNextact" => "If:SetNextact",
// "Switch construct" => "Switch construct",
// "Map process roles" => "Map process roles",
// "Admin Processes" => "Admin Processes",
// "Admin Activities" => "Admin Activities",
// "Edit this Process" => "Edit this Process",
// "Monitor Activities" => "Monitor Activities",
// "Galaxia Monitor Activities" => "Galaxia Monitor Activities",
// "Galaxia Monitor Activities tpl" => "Galaxia Monitor Activities tpl",
// "List of activities" => "List of activities",
// "Proc" => "Proc",
// "auto" => "auto",
// "int" => "int",
// "routing" => "routing",
// "Instances" => "Instances",
// "run" => "run",
// "run activity" => "run activity",
// "Enter the name of this instance" => "Enter the name of this instance",
// "The name is not valid. Please, enter the name again" => "The name is not valid. Please, enter the name again",
// "Monitor" => "Monitor",
// "monitor processes" => "monitor processes",
// "monitor activities" => "monitor activities",
// "monitor instances" => "monitor instances",
// "monitor workitems" => "monitor workitems",
// "Monitor Instances" => "Monitor Instances",
// "Galaxia Monitor Instances" => "Galaxia Monitor Instances",
// "Galaxia Monitor Instances tpl" => "Galaxia Monitor Instances tpl",
// "List of instances" => "List of instances",
// "Not ended" => "Not ended",
// "No instances created yet" => "No instances created yet",
// "Monitor Processes" => "Monitor Processes",
// "Galaxia Monitor Processes" => "Galaxia Monitor Processes",
// "Galaxia Monitor Processes tpl" => "Galaxia Monitor Processes tpl",
// "processes" => "processes",
// "being run" => "being run",
// "Exceptions" => "Exceptions",
// "Monitor workitems" => "Monitor workitems",
// "List of workitems" => "List of workitems",
// "instance" => "instance",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "My activities" => "My activities",
// "Current Activity" => "Current Activity",
// "Assigned To" => "Assigned To",
// "exception instance" => "exception instance",
// "exceptions instance" => "exceptions instance",
// "Send Instance" => "Send Instance",
// "abort instance" => "abort instance",
// "grab instance" => "grab instance",
// "release instance" => "release instance",
// "No activities found" => "No activities found",
// "My instances" => "My instances",
// "No instances found" => "No instances found",
// "Galaxia User Activities" => "Galaxia User Activities",
// "Galaxia User Activities tpl" => "Galaxia User Activities tpl",
// "process" => "process",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "user processes" => "user processes",
// "user activities" => "user activities",
// "user instances" => "user instances",
// "User Instances" => "User Instances",
// "Galaxia User Instances" => "Galaxia User Instances",
// "Galaxia User Instances tpl" => "Galaxia User Instances tpl",
// "Inst Status" => "Inst Status",
// "Not defined" => "Not defined",
// "No instances defined yet" => "No instances defined yet",
// "User Processes" => "User Processes",
// "Galaxia User Processes" => "Galaxia User Processes",
// "Galaxia User Processes tpl" => "Galaxia User Processes tpl",
// "Browsing Workitem" => "Browsing Workitem",
// "Workitem information" => "Workitem information",
// "Geographic" => "Geographic",
// "Make Map" => "Make Map",
// "Reset view to default" => "Reset view to default",
// "Reset view to site default" => "Reset view to site default",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "Overwrite existing pages if the name is the same" => "Overwrite existing pages if the name is the same",
// "Previously remove existing page versions" => "Previously remove existing page versions",
// "excerpt" => "excerpt",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "Last 2 days" => "Last 2 days",
// "Last 3 days" => "Last 3 days",
// "Last 5 days" => "Last 5 days",
// "Last week" => "Last week",
// "Last 2 weeks" => "Last 2 weeks",
// "Last month" => "Last month",
// "v" => "v",
// "View Submissions" => "View Submissions",
// "ExpireDate" => "ExpireDate",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block" => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "/" => "/",
// "Flash binary (.swf or .dcr)" => "Flash binary (.swf or .dcr)",
// "Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)",
// "Edit game" => "Edit game",
// "Played" => "Played",
// "If you can't see the game then you need a flash plugin for your browser" => "If you can't see the game then you need a flash plugin for your browser",
// "Edit New Submission" => "Edit New Submission",
// "Survey stats" => "Survey stats",
// "Take Survey" => "Take Survey",
// "users registered" => "users registered",
// "Distance (km)" => "Distance (km)",
// "List Movies" => "List Movies",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Choose a movie" => "Choose a movie",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "Back to admin" => "Back to admin",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "To display the objects you participate" => "To display the objects you participate",
// "The newsletter was sent to {\$sent} email addresses" => "The newsletter was sent to {\$sent} email addresses",
// "Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed" => "Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed",
// "Your email address was removed from the list of subscriptors" => "Your email address was removed from the list of subscriptors",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription confirmed" => "Subscription confirmed",
// "Reading article from" => "Reading article from",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "reset" => "reset",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "View Details" => "View Details",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Any" => "Any",
// "Sum" => "Sum",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "Viewing blog post" => "Viewing blog post",
// "Return to blog" => "Return to blog",
// "Edit quiz" => "Edit quiz",
// "at " => "at ",
// "Use " => "Use ",
// "randomly selected questions" => "randomly selected questions",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)" => "&nbsp question(s)",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz" => "Allow students to store partial results and return to quiz",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "P/F" => "P/F",
// "Passed" => "Passed",
// "Stats for this quiz Questions " => "Stats for this quiz Questions ",
// "List all articles of this same topic" => "List all articles of this same topic",
// "Please, change the name if you want the page to be uploaded" => "Please, change the name if you want the page to be uploaded",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "A valid email is mandatory to register" => "A valid email is mandatory to register",
// "Select your group" => "Select your group",
// "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter" => "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter",
// "Tiki site registered" => "Tiki site registered",
// "The following site was added and validation by admin may be needed before appearing on the lists" => "The following site was added and validation by admin may be needed before appearing on the lists",
// "Register this site at tikiwiki.org" => "Register this site at tikiwiki.org",
// "Read this first" => "Read this first",
// "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites" => "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites",
// "Registering is voluntary" => "Registering is voluntary",
// "Registering does not give you any benefits except one more link to your site" => "Registering does not give you any benefits except one more link to your site",
// "You don't get any emails, we don't sell the data about your site" => "You don't get any emails, we don't sell the data about your site",
// "Registering is just for us to get an overview of Tiki's usage" => "Registering is just for us to get an overview of Tiki's usage",
// "If your site is private or inside your intranet, you should not register" => "If your site is private or inside your intranet, you should not register",
// "Information about your site" => "Information about your site",
// "Enter your username or email" => "Enter your username or email",
// "Slave" => "Slave",
// "Master" => "Master",
// "Operations" => "Operations",
// "Operations Log" => "Operations Log",
// "Rollback page" => "Rollback page",
// "\$name" => "\$name",
// "A link to this post was sent to the following addresses" => "A link to this post was sent to the following addresses",
// "Send post to this addresses" => "Send post to this addresses",
// "List of email addresses separated by commas" => "List of email addresses separated by commas",
// "Please Confirm" => "Please Confirm",
// "This newsletter will be sent to {\$subscribers} email addresses" => "This newsletter will be sent to {\$subscribers} email addresses",
// "octets" => "octets",
// "Prepare a newsletter to be sent" => "Prepare a newsletter to be sent",
// "Apply content template" => "Apply content template",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "big grin" => "big grin",
// "confused" => "confused",
// "eek" => "eek",
// "lol" => "lol",
// "mr green" => "mr green",
// "razz" => "razz",
// "redface" => "redface",
// "rolleyes" => "rolleyes",
// "surprised" => "surprised",
// "twisted" => "twisted",
// "santa" => "santa",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Params" => "Params",
// "Date of first pageview" => "Date of first pageview",
// "Days since first pageview" => "Days since first pageview",
// "Stats for surveys" => "Stats for surveys",
// "Last taken" => "Last taken",
// "Stats for survey" => "Stats for survey",
// "TikiTests Edit" => "TikiTests Edit",
// "Summary mode" => "Summary mode",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "Edit File" => "Edit File",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "Maximum amount of downloads" => "Maximum amount of downloads",
// "Add File" => "Add File",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// "Image ID thumb" => "Image ID thumb",
// "You can include the image in an Wiki page using" => "You can include the image in an Wiki page using",
// "or upload a local image from your disk" => "or upload a local image from your disk",
// "Batch Upload" => "Batch Upload",
// "User assigned modules" => "User assigned modules",
// "The column is disabled" => "The column is disabled",
// "Assign module" => "Assign module",
// "Column" => "Column",
// "Folder in" => "Folder in",
// "(non public)" => "(non public)",
// "Homepage" => "Homepage",
// "Users HomePage" => "Users HomePage",
// "Create page" => "Create page",
// "This user is your friend" => "This user is your friend",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Request friendship from this user" => "Request friendship from this user",
// "Toggle options" => "Toggle options",
// "Toggle" => "Toggle",
// "Male" => "Male",
// "Female" => "Female",
// "View extra information" => "View extra information",
// "Displays users' info tooltip on mouseover for every user who allows his information to be public" => "Displays users' info tooltip on mouseover for every user who allows his information to be public",
// "Not Accepted User" => "Not Accepted User",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "User_versions_for" => "User_versions_for",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Remove Row" => "Remove Row",
// "Remove Column" => "Remove Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "Before" => "Before",
// "After" => "After",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "Banner stats" => "Banner stats",
// "Create new banner" => "Create new banner",
// "Banner Information" => "Banner Information",
// "Click ratio" => "Click ratio",
// "Banner raw data" => "Banner raw data",
// "Cached" => "Cached",
// "This is a cached version of the page" => "This is a cached version of the page",
// "Click here to view the Google cache of the page instead" => "Click here to view the Google cache of the page instead",
// "Edit Items" => "Edit Items",
// "List Charts" => "List Charts",
// "Last Chart" => "Last Chart",
// "Previous Chart" => "Previous Chart",
// "Chart created" => "Chart created",
// "Next Chart" => "Next Chart",
// "Pre" => "Pre",
// "Permanency" => "Permanency",
// "chg" => "chg",
// "Avg" => "Avg",
// "info/vote" => "info/vote",
// "Next chart will be generated on" => "Next chart will be generated on",
// "View or vote items not listed in the chart" => "View or vote items not listed in the chart",
// "Select something to vote on" => "Select something to vote on",
// "Dif" => "Dif",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Add Suggestion" => "Add Suggestion",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Reported Messages" => "Reported Messages",
// "Merge into topic" => "Merge into topic",
// "Emot" => "Emot",
// "pts" => "pts",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Filter Posts" => "Filter Posts",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Archived" => "Archived",
// "Topic List" => "Topic List",
// "The post has been reported and will be reviewed by a moderator" => "The post has been reported and will be reviewed by a moderator",
// "Tracker Items" => "Tracker Items",
// "Insert new item" => "Insert new item",
// "Filter Tracker Items" => "Filter Tracker Items",
// "Add a Comment" => "Add a Comment",
// "Special Operations" => "Special Operations",
// "There was an error connecting to your e-mail account" => "There was an error connecting to your e-mail account",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "Click to activate" => "Click to activate",
// "This is the active account" => "This is the active account",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "Clip" => "Clip",
// "Back To Mailbox" => "Back To Mailbox",
// "Full Headers" => "Full Headers",
// "Normal Headers" => "Normal Headers",
// "Reply To All" => "Reply To All",
// "Forward" => "Forward",
// "Select from address book" => "Select from address book",
// "Use HTML mail" => "Use HTML mail",
// "The following addresses are not in your address book" => "The following addresses are not in your address book",
// "Add Contacts" => "Add Contacts",
// "Attachment 1" => "Attachment 1",
// "Attachment 2" => "Attachment 2",
// "Attachment 3" => "Attachment 3",
// "Address book" => "Address book",
// "page id" => "page id",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Jump to Content" => "Jump to Content",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Remove Image" => "Remove Image",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Number of voices" => "Number of voices",
// "Your vote" => "Your vote",
// "Click to vote for this value" => "Click to vote for this value",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Use this thread to discuss the page" => "Use this thread to discuss the page",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Reinstall" => "Reinstall",
// "Undecided" => "Undecided",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "Save Minor Edit" => "Save Minor Edit",
// "Save the page as a draft" => "Save the page as a draft",
// "Compose Message" => "Compose Message",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "Separate multiple usernames with a comma (&nbsp;,&nbsp;)" => "Separate multiple usernames with a comma (&nbsp;,&nbsp;)",
// "%s set" => "%s set",
// "%s unset" => "%s unset",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Wiki Attachments" => "Wiki Attachments",
// "RSS settings" => "RSS settings",
// "Maps configuration" => "Maps configuration",
// "Look & Feel" => "Look & Feel",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Current version is up to date : <b>%s</b>" => "Current version is up to date : <b>%s</b>",
// "A new %s  major release branch is available" => "A new %s  major release branch is available",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Test Image" => "Test Image",
// "Your admin password has been changed" => "Your admin password has been changed",
// "You cannot have a blank password" => "You cannot have a blank password",
// "All Fields except gdaltindex must be filled" => "All Fields except gdaltindex must be filled",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "If you use apache, you need a .htaccess file to have this feature working" => "If you use apache, you need a .htaccess file to have this feature working",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Repository name can't be an empty" => "Repository name can't be an empty",
// "Requested action is not supported on repository" => "Requested action is not supported on repository",
// "No repository" => "No repository",
// "Search is mandatory field" => "Search is mandatory field",
// "File not found " => "File not found ",
// "Requested action in not supported on repository" => "Requested action in not supported on repository",
// "Non-existent link" => "Non-existent link",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer" => "Frequency should be a positive integer",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "Unassign module" => "Unassign module",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "unsafe" => "unsafe",
// "register_globals should be off by default. See the php manual for details" => "register_globals should be off by default. See the php manual for details",
// "session.use_trans_sid should be off by default. See the php manual for details" => "session.use_trans_sid should be off by default. See the php manual for details",
// "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code" => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "File is not readable. Unable to check" => "File is not readable. Unable to check",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous" => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous",
// "This is a modified File. Cannot check version. Check if it is dangerous" => "This is a modified File. Cannot check version. Check if it is dangerous",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// "You have to provide a word" => "You have to provide a word",
// "No Errors detected" => "No Errors detected",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "Invalid or unknown email" => "Invalid or unknown email",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "User %s already exists" => "User %s already exists",
// "User login contains invalid characters" => "User login contains invalid characters",
// "%s %s successfully deleted" => "%s %s successfully deleted",
// "Deleted account %s" => "Deleted account %s",
// "%s %s removed from %s %s" => "%s %s removed from %s %s",
// "%s <b>%s</b> successfully deleted" => "%s <b>%s</b> successfully deleted",
// "%s <b>%s</b> assigned to %s <b>%s</b>" => "%s <b>%s</b> assigned to %s <b>%s</b>",
// "%s <b>%s</b> removed from %s <b>%s</b>" => "%s <b>%s</b> removed from %s <b>%s</b>",
// "group <b>%s</b> set as the default group of user <b>%s</b>" => "group <b>%s</b> set as the default group of user <b>%s</b>",
// "Login contains invalid characters" => "Login contains invalid characters",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "%s modified successfully" => "%s modified successfully",
// "%s modification failed" => "%s modification failed",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Permission denied you cannot view backlinks for this page" => "Permission denied you cannot view backlinks for this page",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s" => "Could not read image %s",
// "Image %s upload failed" => "Image %s upload failed",
// "Image %s uploaded successfully" => "Image %s uploaded successfully",
// "Image %s removed from Batch directory" => "Image %s removed from Batch directory",
// "Impossible to remove image %s from Batch directory" => "Impossible to remove image %s from Batch directory",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images" => "Incorrect directory chosen for batch upload of images",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator" => "Please contact the website administrator",
// "Invalid directory name" => "Invalid directory name",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "Tiki RSS feed for blog: " => "Tiki RSS feed for blog: ",
// "Last modifications to the blog" => "Last modifications to the blog",
// "No blogId specified" => "No blogId specified",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs" => "Last posts to weblogs",
// "You must clear your browser cache" => "You must clear your browser cache",
// "No gallery indicated" => "No gallery indicated",
// "Permission denied you cannot view the calendar" => "Permission denied you cannot view the calendar",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "event without name" => "event without name",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "Access Denied" => "Access Denied",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string",
// "%H:%M %Z" => "%H:%M %Z",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "No category indicated" => "No category indicated",
// "Permission denied; you cannot assign permissions for this category" => "Permission denied; you cannot assign permissions for this category",
// "Invalid username or activation code. Maybe this code has already been used" => "Invalid username or activation code. Maybe this code has already been used",
// "You can not use the same password again" => "You can not use the same password again",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "Account validated successfully" => "Account validated successfully",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "Last sites" => "Last sites",
// "Must enter a name to add a site. " => "Must enter a name to add a site. ",
// "Must enter a url to add a site. " => "Must enter a url to add a site. ",
// "URL already added to the directory. Duplicate site? " => "URL already added to the directory. Duplicate site? ",
// "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. ",
// "Must select a category. " => "Must select a category. ",
// "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory",
// "No site indicated" => "No site indicated",
// "No parent specified" => "No parent specified",
// "Last sites of directory \".\$rc[\"name\"].\" " => "Last sites of directory \".\$rc[\"name\"].\" ",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "You do not have permission to write the style sheet" => "You do not have permission to write the style sheet",
// "Shortname must be 2 Characters" => "Shortname must be 2 Characters",
// "You must provide a longname" => "You must provide a longname",
// "No content id indicated" => "No content id indicated",
// "No quiz indicated" => "No quiz indicated",
// "No structure indicated" => "No structure indicated",
// "Invalid structure_id or page_ref_id" => "Invalid structure_id or page_ref_id",
// "Permission denied you cannot send submissions" => "Permission denied you cannot send submissions",
// "Permission denied you cannot edit submissions" => "Permission denied you cannot edit submissions",
// "No topic id specified" => "No topic id specified",
// "Invalid topic id specified" => "Invalid topic id specified",
// "No object indicated" => "No object indicated",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "No type indicated" => "No type indicated",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "page imported" => "page imported",
// "created from import" => "created from import",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Can't import remote HTML page" => "Can't import remote HTML page",
// "No questions group indicated" => "No questions group indicated",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Permission denied you cannot edit this file" => "Permission denied you cannot edit this file",
// "Permission denied you cannot remove files from this gallery" => "Permission denied you cannot remove files from this gallery",
// "Last files" => "Last files",
// "Tiki RSS feed for file galleries" => "Tiki RSS feed for file galleries",
// "Last files uploaded to the file galleries" => "Last files uploaded to the file galleries",
// "No galleryId specified" => "No galleryId specified",
// "Tiki RSS feed for the file gallery: " => "Tiki RSS feed for the file gallery: ",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "Last replied forum topics" => "Last replied forum topics",
// "No forumId specified" => "No forumId specified",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums" => "Last topics in forums",
// "Not supported yet" => "Not supported yet",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship" => "I have broken our friendship",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "I have accepted your friendship request" => "I have accepted your friendship request",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "No process indicated" => "No process indicated",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "Activity name already exists" => "Activity name already exists",
// "indicates if the process is active. Invalid processes cant be active" => "indicates if the process is active. Invalid processes cant be active",
// "No instance indicated" => "No instance indicated",
// "No activity indicated" => "No activity indicated",
// "The process name already exists" => "The process name already exists",
// "Process already exists" => "Process already exists",
// "Invalid source path" => "Invalid source path",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "You cant execute this activity" => "You cant execute this activity",
// "You couldn't abort a instance" => "You couldn't abort a instance",
// "You couldn't exception a instance" => "You couldn't exception a instance",
// "No title indicated" => "No title indicated",
// "No comment indicated" => "No comment indicated",
// "No date indicated" => "No date indicated",
// "No item indicated" => "No item indicated",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required" => "No valid renderer found. GD or PDFLib required",
// "No sheet specified" => "No sheet specified",
// "You must select a renderer" => "You must select a renderer",
// "Invalid Series for current graphic" => "Invalid Series for current graphic",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries" => "Last images uploaded to the image galleries",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "updated from structured text import" => "updated from structured text import",
// "page created" => "page created",
// "created from structured text import" => "created from structured text import",
// "Operations executed successfully" => "Operations executed successfully",
// "No name indicated for wiki page" => "No name indicated for wiki page",
// "No repository given" => "No repository given",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Permission denied you cannot view pages like this page" => "Permission denied you cannot view pages like this page",
// "Permission denied you can upload files but not to this file gallery" => "Permission denied you can upload files but not to this file gallery",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Could not upload the file" => "Could not upload the file",
// "Could not find the file requested" => "Could not find the file requested",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read file" => "Cannot read file",
// "Cannot read the file" => "Cannot read the file",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "File update was successful" => "File update was successful",
// "Permission denied you can't upload files so you can't edit them" => "Permission denied you can't upload files so you can't edit them",
// "This gallery does not exist" => "This gallery does not exist",
// "The game file must have .swf or .dcr extension" => "The game file must have .swf or .dcr extension",
// "The thumbnail name must be" => "The thumbnail name must be",
// "Please supply both files" => "Please supply both files",
// "Permission denied you cannot remove submissions" => "Permission denied you cannot remove submissions",
// "Permission denied you cannot approve submissions" => "Permission denied you cannot approve submissions",
// "Unable to contact remote server" => "Unable to contact remote server",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Sorry, you can't use this feature" => "Sorry, you can't use this feature",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "Welcome at Hawiki" => "Welcome at Hawiki",
// "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more" => "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more",
// "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site" => "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site",
// "tiki-mobile.php" => "tiki-mobile.php",
// "About" => "About",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled" => "Your PHP installation does not have zlib enabled",
// "Missing information to read news (server,port,username,password,group) required" => "Missing information to read news (server,port,username,password,group) required",
// "No note indicated" => "No note indicated",
// "merged note" => "merged note",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "created from notepad" => "created from notepad",
// "Page already exists" => "Page already exists",
// "Not enough information to display this page" => "Not enough information to display this page",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot browse this page history" => "Permission denied you cannot browse this page history",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "Pageviews" => "Pageviews",
// "You don't have permission to edit quizzes" => "You don't have permission to edit quizzes",
// "No result indicated" => "No result indicated",
// "You must choose a group" => "You must choose a group",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "mail adress" => "mail adress",
// "Invalid or unknown username" => "Invalid or unknown username",
// "Unable to send mail. User has not configured email" => "Unable to send mail. User has not configured email",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password" => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "A password and your IP address reminder email has been sent " => "A password and your IP address reminder email has been sent ",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email" => "to the email",
// "to the registered email address for" => "to the registered email address for",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Permission denied you cannot rename this page" => "Permission denied you cannot rename this page",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "changed '%s' from '%s' to '%s'" => "changed '%s' from '%s' to '%s'",
// "Non-existent version" => "Non-existent version",
// "Permission denied you cannot rollback this page" => "Permission denied you cannot rollback this page",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "Post recommendation at" => "Post recommendation at",
// "invalid email" => "invalid email",
// "successfully sent" => "successfully sent",
// "not sent" => "not sent",
// "Error: " => "Error: ",
// "Notice: this variable may not be empty" => "Notice: this variable may not be empty",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Clean the sql logs" => "Clean the sql logs",
// "Quiz time limit exceeded quiz cannot be computed" => "Quiz time limit exceeded quiz cannot be computed",
// "You cannot take this survey twice" => "You cannot take this survey twice",
// "Report to the webmaster" => "Report to the webmaster",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "No permission to upload zipped file packages" => "No permission to upload zipped file packages",
// "Error processing zipped image package" => "Error processing zipped image package",
// "No permission to upload zipped image packages" => "No permission to upload zipped image packages",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "Permission denied you cannot upload images" => "Permission denied you cannot upload images",
// "Permission denied you can upload images but not to this gallery" => "Permission denied you can upload images but not to this gallery",
// "Cannot get image from URL" => "Cannot get image from URL",
// "That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
// "Usage" => "Usage",
// "No url indicated" => "No url indicated",
// "You are not logged in and no user indicated" => "You are not logged in and no user indicated",
// "The user has chosen to make his information private" => "The user has chosen to make his information private",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "unicode" => "unicode",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "open / in process" => "open / in process",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries" => "Task entries",
// "Changes" => "Changes",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Login and click the link below" => "Login and click the link below",
// "Please read the task and work on it" => "Please read the task and work on it",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "Language watch" => "Language watch",
// "Cannot upload this file not enough quota" => "Cannot upload this file not enough quota",
// "Non-existent user" => "Non-existent user",
// "No banner indicated" => "No banner indicated",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "No faq indicated" => "No faq indicated",
// "You are not permitted to remove someone else\\'s post" => "You are not permitted to remove someone else\\'s post",
// "Incorrect thread" => "Incorrect thread",
// "A SheetId is required" => "A SheetId is required",
// "That tracker don't use extras" => "That tracker don't use extras",
// " The connection failed, so check the server names" => " The connection failed, so check the server names",
// "The connection was OK" => "The connection was OK",
// " But the login failed, so check the Username and Password" => " But the login failed, so check the Username and Password",
// "No subject" => "No subject",
// "Tiki RSS feed for the wiki pages" => "Tiki RSS feed for the wiki pages",
// "Last modifications to the Wiki" => "Last modifications to the Wiki",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Andorra" => "Andorra",
"Angola" => "Angola",
"Anguilla" => "Anguilla",
"Antigua" => "Antigua",
"Aruba" => "Aruba",
"Belgium" => "Belgium",
"Belize" => "Belize",
"Benin" => "Benin",
"Bermuda" => "Bermuda",
"Bhutan" => "Bhutan",
"Brunei" => "Brunei",
"Burkina Faso" => "Burkina Faso",
"Burundi" => "Burundi",
"Chile" => "Chile",
"Costa Rica" => "Costa Rica",
"Ecuador" => "Ecuador",
"El Salvador" => "El Salvador",
"Eritrea" => "Eritrea",
"Gabon" => "Gabon",
"Gambia" => "Gambia",
"Grenada" => "Grenada",
"Guatemala" => "Guatemala",
"Guinea" => "Guinea",
"Haiti" => "Haiti",
"Honduras" => "Honduras",
"Hong Kong" => "Hong Kong",
"India" => "India",
"Kenya" => "Kenya",
"Kiribati" => "Kiribati",
"Kuwait" => "Kuwait",
"Liechtenstein" => "Liechtenstein",
"Luxemburg" => "Luxemburg",
"Malawi" => "Malawi",
"Mali" => "Mali",
"Moldova" => "Moldova",
"Monaco" => "Monaco",
"Montenegro" => "Montenegro",
"Nauru" => "Nauru",
"Nicaragua" => "Nicaragua",
"Niger" => "Niger",
"Niue" => "Niue",
"Oman" => "Oman",
"Palau" => "Palau",
"Panama" => "Panama",
"latin" => "latin",
"CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
"Shibboleth" => "Shibboleth",
"blog" => "blog",
"Blog" => "Blog",
"km" => "km",
"wiki" => "wiki",
"index" => "index",
"max" => "max",
"jscalendar" => "jscalendar",
"~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
"1|0" => "1|0",
"Banner" => "Banner",
"Blog ID" => "Blog ID",
"wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
"BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
"on|off" => "on|off",
"DBReport" => "DBReport",
"Div" => "Div",
"left|right|center|justify" => "left|right|center|justify",
"0|1" => "0|1",
"name_asc" => "name_asc",
"Flash video" => "Flash video",
"ftp" => "ftp",
"googledoc" => "googledoc",
"HTML" => "HTML",
"URL" => "URL",
"Iframe" => "Iframe",
"iframe" => "iframe",
"Stop" => "Stop",
"Jabber" => "Jabber",
"255,255,255" => "255,255,255",
"JQuery" => "JQuery",
"NotOnReady" => "NotOnReady",
"NoJQuery" => "NoJQuery",
"Javascript" => "Javascript",
"Limit" => "Limit",
"Mediaplayer" => "Mediaplayer",
"MP3 URL" => "MP3 URL",
"FLV URL" => "FLV URL",
"Instructions::Feedback" => "Instructions::Feedback",
"Flip" => "Flip",
"Max" => "Max",
"np" => "np",
"Monospace" => "Monospace",
"#FFFFFF" => "#FFFFFF",
"true|false" => "true|false",
"MySpace" => "MySpace",
"SourceForge" => "SourceForge",
"Pop-up" => "Pop-up",
"name|desc" => "name|desc",
"Skype" => "Skype",
"asc|desc|shuffle" => "asc|desc|shuffle",
"SQL" => "SQL",
"ADODB DNS" => "ADODB DNS",
"hits|user" => "hits|user",
"asc|desc" => "asc|desc",
"plain|fancy" => "plain|fancy",
"user|page" => "user|page",
"o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
"Popup" => "Popup",
"Checkbox" => "Checkbox",
"goIfOne" => "goIfOne",
"fieldId" => "fieldId",
"Maximum" => "Maximum",
"__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
"External Wiki" => "External Wiki",
"WikiWord" => "WikiWord",
"Youtube" => "Youtube",
"Plugin " => "Plugin ",
"id" => "id",
"podcast (audio)" => "podcast (audio)",
"podcast (video)" => "podcast (video)",
"OK" => "OK",
"Invalid" => "Invalid",
"CC" => "CC",
"BCC" => "BCC",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"November" => "November",
"December" => "December",
"Minichat" => "Minichat",
"JsCalendar" => "JsCalendar",
"PHPLayers" => "PHPLayers",
"Shadowbox" => "Shadowbox",
"Mootools" => "Mootools",
"Ajax" => "Ajax",
"Mindmap" => "Mindmap",
"SEFURL" => "SEFURL",
"Neglected" => "Neglected",
"XMLRPC API" => "XMLRPC API",
"Unix" => "Unix",
"Windows" => "Windows",
"(standard)" => "(standard)",
"Port" => "Port",
"port" => "port",
"IP" => "IP",
"PEAR::Auth" => "PEAR::Auth",
"PAM" => "PAM",
"HTTP port" => "HTTP port",
"HTTPS port" => "HTTPS port",
"LDAP" => "LDAP",
"JQuery Superfish" => "JQuery Superfish",
"JQuery UI" => "JQuery UI",
"Geo URL" => "Geo URL",
"geo.position" => "geo.position",
"geo.region" => "geo.region",
"geo.placename" => "geo.placename",
"Token" => "Token",
"Invert" => "Invert",
"Self" => "Self",
"Latin" => "Latin",
"Side-by-side diff" => "Side-by-side diff",
"Valid" => "Valid",
"PDF" => "PDF",
"Xml Zip" => "Xml Zip",
"Powered by" => "Powered by",
"powered by" => "powered by",
"URL:" => "URL:",
"hard space" => "hard space",
"wiki link'" => "wiki link'",
"rss feed" => "rss feed",
"tagline" => "tagline",
"flash" => "flash",
"{\$label}" => "{\$label}",
"XML Zip" => "XML Zip",
"MultiTiki" => "MultiTiki",
"Powered by TikiWiki" => "Powered by TikiWiki",
"Program" => "Program",
"Tikiwiki Mods" => "Tikiwiki Mods",
"MyTiki" => "MyTiki",
"Plugin" => "Plugin",
"tikiwiki.org" => "tikiwiki.org",
"Replicate" => "Replicate",
"TOC" => "TOC",
"Mb" => "Mb",
"%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Ez a funkció most nincs bekapcsolva",
"Permission denied you cannot view pages" => "Oldalak megtekintéséhez magasabb szintű jogosultágra van szükség",
"The copyright management feature is not enabled." => "A szerzői jogok kezelése funkció nincs bekapcsolva",
"Copyright management" => "Szerzői jogok kezelése",
"No page indicated" => "Nincs megadva oldal",
"You must supply all the information, including title and year." => "Minden információt meg kell adni (különösen címet és az évet)",
"You do not have permission to use this feature" => "A funkció használatához magasabb szintű jogosultágra van szükség",
"Type" => "Típus",
"Name" => "Név",
"Description" => "Leírás",
"Size" => "Méret",
"Created" => "Létrehozás",
"Uploaded" => "Feltöltés",
"Last Modified" => "Utolsó módosítás",
"Creator" => "Létrehozó",
"Author" => "Szerző",
"Last editor" => "Legutóbbi szerkesztő",
"Comment" => "Komment",
"Files" => "Fájlok",
"Hits" => "Látogatók",
"Locked by" => "Zárolta:",
"Path" => "Útvonal",
"Default View" => "Alapértelmezett nézet",
"Afghanistan" => "Afganisztán",
"Aland Islands" => "Aland Szigetek",
"Albania" => "Albánia",
"Algeria" => "Algéria",
"American Samoa" => "Amerikai Samoa",
"Argentina" => "Argentína",
"Armenia" => "Örményország",
"Australia" => "Ausztrália",
"Austria" => "Ausztria",
"Azerbaijan" => "Azerbajdzsán",
"Bahamas" => "Bahamák",
"Bahrain" => "Bahrein",
"Bangladesh" => "Banglades",
"Barbados" => "Barbadosz",
"Belarus" => "Fehéroroszország",
"Bolivia" => "Bolívia",
"Bosnia and Herzegovina" => "Bosznia Hercegovina",
"Botswana" => "Botswána",
"Bouvet Island" => "Bouvet Sziget",
"Brazil" => "Brazilia",
"Bulgaria" => "Bulgária",
"Cambodia" => "Kambodzsa",
"Cameroon" => "Kamerum",
"Canada" => "Kanada",
"Cape Verde" => "Zöld-foki Köztársaság",
"Cayman Islands" => "Kajmán-szigetek",
"Chad" => "Csád",
"China" => "Kína",
"Christmas Island" => "Karácsony-sziget",
"Colombia" => "Kolumbia",
"Congo" => "Kongó",
"Croatia" => "Horvátország",
"Cuba" => "Kuba",
"Cyprus" => "Ciprus",
"Czech Republic" => "Csehország",
"Denmark" => "Dánia",
"Dominica" => "Dominika",
"Dominican Republic" => "Dominikai Köztársaság",
"Egypt" => "Egyiptom",
"Equatorial Guinea" => "Egyenlítői Guinea",
"Estonia" => "Észtország",
"Ethiopia" => "Etiópia",
"Europe" => "Europa",
"Falkland Islands" => "Falkland-szigetek",
"Faroe Islands" => "Faröe-szigetek",
"Fiji" => "Fidzsi",
"Finland" => "Finnország",
"France" => "Franciaország",
"French Guiana" => "Francia Guayana",
"French Polynesia" => "Francia Polinézia",
"Germany" => "Németország",
"Ghana" => "Ghána",
"Gibraltar" => "Gibraltár",
"Greece" => "Görögország",
"Greenland" => "Grönland",
"Hungary" => "Magyarország",
"Iceland" => "Izland",
"Indonesia" => "Indonézia",
"Iran" => "Irán",
"Iraq" => "Irák",
"Ireland" => "Írország",
"Israel" => "Izrael",
"Italy" => "Olaszország",
"Jamaica" => "Jamaika",
"Japan" => "Japán",
"Jordan" => "Jordánia",
"Kazakstan" => "Kazaksztán",
"Kyrgyzstan" => "Kirgizisztán",
"Laos" => "Laosz",
"Latvia" => "Lettország",
"Lebanon" => "Libanon",
"Liberia" => "Libéria",
"Libya" => "Líbia",
"Lithuania" => "Litvánia",
"Macao" => "Makao",
"Macedonia" => "Macedónia",
"Madagascar" => "Madagaszkár",
"Malaysia" => "Malázia",
"Maldives" => "Maldív-szigetek",
"Malta" => "Málta",
"Mauritania" => "Mauritánia",
"Mexico" => "Mexikó",
"Mongolia" => "Mongólia",
"Morocco" => "Marokkó",
"Mozambique" => "Mozambik",
"Myanmar" => "Burma (Myanmar)",
"Namibia" => "Namíbia",
"Nepal" => "Nepál",
"Netherlands Antilles" => "Holland Antillák",
"Netherlands" => "Hollandia",
"New Caledonia" => "Új Kaledónia",
"New Zealand" => "Új-Zéland",
"Nigeria" => "Nigéria",
"None" => "Nincs",
"Norfolk Island" => "Norfolk-szigetek",
"North Korea" => "Észak Korea",
"Norway" => "Norvégia",
"Other" => "Egyéb",
"Pakistan" => "Pakisztán",
"Palestine" => "Palesztina",
"Papua New Guinea" => "Papua Új Guinea",
"Simplified Chinese" => "egyszerűsített kínai",
"Chinese" => "kínai",
"Czech" => "cseh",
"Danish" => "dán",
"German" => "német",
"English" => "Angol",
"Spanish" => "spanyol",
"Greek" => "görög",
"French" => "francia",
"Hebrew" => "jiddis",
"Croatian" => "horvát",
"Italian" => "olasz",
"Japanese" => "japán",
"Korean" => "koreai",
"Hungarian" => "magyar",
"Dutch" => "holland",
"Norwegian" => "norvég",
"Polish" => "lengyel",
"Russian" => "orosz",
"Slovak" => "szlovák",
"Serbian" => "szerb",
"Swedish" => "svéd",
"Traditional Chinese" => "hagyományos kínai",
"Ukrainian" => "Ukrajna",
"Activity" => "Aktivitás",
"points" => "pontok",
"on left side" => "bal oldalon",
"on center" => "középen",
"on right side" => "jobb oldalon",
"Disabled" => "Letiltva",
"Plain text" => "Egyszerű szöveg",
"Link to user information" => "Link a felhasználói információkhoz",
"User avatar" => "Felhasználói avatár",
"Creation date (desc)" => "Létrehozás dátuma (csökk)",
"Last modification date (desc)" => "Utolsó módositás dátuma (csökk)",
"Blog title (asc)" => "Blog címe (növ)",
"Number of posts (desc)" => "Posztok száma (csökk)",
"Visits (desc)" => "Látogatottság (csökk)",
"Activity (desc)" => "Aktivitás (csökk)",
"Top bar" => "Felső sáv",
"Bottom bar" => "Alsó sáv",
"no cache" => "nincs cache",
"minute" => "perc",
"minutes" => "perc",
"hour" => "óra",
"hours" => "óra",
"as Creator &amp; Last Editor" => "Létrehozó &amp; Legutóbbi szerkesztő",
"Business style" => "Üzleti stílus",
"Collaborative style" => "Kollaboratív stílus",
"Page last modified on" => "Oldal legutóbbi módosítása:",
"no (disabled)" => "nincs (kikapcsolva)",
"|| for rows" => "|| sorokhoz",
"complete" => "teljes",
"english" => "angol",
"Day" => "Nap",
"Week" => "Hét",
"Month" => "Hónap",
"Quarter" => "Negyedév",
"Semester" => "Szemeszter",
"Year" => "Év",
"Saturday" => "Szombat",
"Sunday" => "Vasárnap",
"Monday" => "Hétfő",
"Depends user language" => "Felhasználó nyelvétől függ",
"No error reporting" => "Nincs hibajelentés",
"Report all PHP errors" => "Minden PHP hiba jelentése",
"Report all errors except notices" => "Figyelemeztetéseken kívűl minden hiba jelentése",
"Creation Date (asc)" => "Létrehozás dátuma (növ.)",
"Creation Date (desc)" => "Keletkezés dátuma (csökk)",
"Topics (desc)" => "Témák (csökk)",
"Threads (desc)" => "Fórumtémák (csökk)",
"Last post (desc)" => "Utolsó poszt (csökk)",
"Name (desc)" => "Név (csökk)",
"Name (asc)" => "Név (növ)",
"Score ascending" => "Pontszám alapján emelkedő",
"Score descending" => "Pontszám alapján csökkenő",
"Name ascending" => "Név alapján emelkedő",
"Name descending" => "Név alapján csökkenő",
"Login ascending" => "Bejelentkezési név alapján emelkedő",
"Login descending" => "Bejelentkezési név alapján  csökkenő",
"replace current window" => "jelenlegi ablak kicserélése",
"new window" => "új ablak",
"inline frame" => "belső keret",
"Q and A" => "K & V",
"Question ID" => "Kérdés azonosító",
"Each day" => "Minden nap",
"Each week" => "Minden héten",
"Each month" => "Minden hónapban",
"5 minutes" => "5 perc",
"15 minutes" => "15 perc",
"30 minutes" => "30 perc",
"1 day" => "1 nap",
"1 week" => "1 hét",
"1 month" => "1 hónap",
"Allow secure (https) login" => "Biztonságos (https) bejelentkezés engedélyezése",
"Encourage secure (https) login" => "Biztonságos (https) bejelentkezés bátorítása",
"Require secure (https) login" => "Biztonságos (https) bejelentkezés szükséges",
"tikihash (old)" => "tikihash (régi)",
"Just Tiki" => "Csak Tiki",
"Web Server" => "Webszerver",
"Tiki and PEAR::Auth" => "Tiki és PEAR::Auth",
"Tiki and PAM" => "Tiki és PAM",
"OpenID and Tiki" => "OpenID és Tiki",
"choose a group ..." => "csoport kiválasztása ...",
"Never use transition css" => "Sose használjon tranzíciós css-t",
"Use @version:x.x specified in theme css or none if not specified" => "Használja a téma css-ben megadott @verzió:x.x-t vagy semmit ha nincs megadva",
"Use @version:x.x specified in theme css or 1.9 if not specified" => "Használja a téma css-ben megadott @verzió:x.x-t vagy az 1.9-et ha nincs semmi megadva",
"LastModif" => "Utolsó módosítás",
"Use database to store files" => "Adatbázis használata a fájlok tárolásához",
"Use a directory to store files" => "Könyvtár használata a fájlok tárolásához",
"Ascending" => "Növekvő",
"Descending" => "Csökkenő",
"No forums" => "Nincsenek fórumok",
"%s enabled" => "%s bekapcsolva",
"%s disabled" => "%s kikapcsolva",
"Permission denied" => "Hozzáférés megtagadva, magasabb szintű jogosultságra van szükség",
"The file is not a CSV file or has not a correct syntax" => "Ez vagy nem egy vesszővel elválasztott (CSV) fájl, vagy rossz a fájl belső formátuma",
"locked" => "zárolva",
"locked by" => "zárolta",
"Administration:" => "Adminisztráció:",
"in" => "itt",
"continued" => "bővebben",
"New Image Uploaded by" => "Az új képet feltöltötte:",
"tracker" => "űrlap",
"by" => "Felhasználó:",
"Image Gallery" => "Képgaléria",
"Articles" => "Cikkek",
"Blogs" => "Blogok",
"Forums" => "Fórumok",
"Directory" => "Könytár",
"File Gallery" => "Fájlgaléria",
"FAQs" => "Gyakori kérdések",
"Quizzes" => "Kvízek",
"Trackers" => "Űrlapok",
"Survey" => "Kérdőív",
"Newsletter" => "Hírlevél",
"Charts" => "Slágerek",
"article" => "cikk",
"directory" => "könytár",
"faq" => "gyik",
"file gallery" => "fájlgaléria",
"forum" => "fórum",
"image gallery" => "képgaléria",
"poll" => "szavazás",
"quiz" => "kvíz",
"survey" => "kérdőív",
"wiki page" => "wiki oldal",
"image" => "kép",
"calendar" => "naptár",
"Cannot upload this file maximum upload size exceeded" => "Túl nagy a fájl, nem tudom feltölteni",
"Cannot write to this file:" => "Nem tudok írni ebbe a fájlba:",
"Wrong password. Cannot post comment" => "Rossz jelszó! A komment nem lett elküldve.",
"text" => "szöveg",
"Find" => "Keresés",
"find" => "keresés",
"prev" => "előző",
"Page" => "Oldal",
"next" => "következő",
"Page name" => "Lap neve",
"Wiki Home" => "Wiki főoldal",
"Home" => "Főoldal",
"previous page" => "előző oldal",
"next page" => "következő oldal",
"posted on" => "beküldés időpontja:",
"Continue" => "Tovább",
"By:" => "Szerző:",
"Read" => "Olvasás",
"List articles" => "Cikkek listázása",
"Last post" => "Utolsó hozzászólás",
"Errors detected" => "Hiba lépett fel",
"No image yet, sorry." => "Még nincs kép",
"unknown" => "ismeretlen",
"Wiki top pages" => "Leglátogatottabb wiki oldalak",
"Most relevant pages" => "Legrelevánsabb oldalak",
"Relevance" => "Relevancia",
"Wiki last pages" => "Legutóbbi wiki oldalak",
"Modified" => "Módosítva",
"Forums last topics" => "Legutóbbi fórum témák:",
"Topic date" => "Téma dátuma",
"Forums most read topics" => "A legolvasottabb fórum topic-ok",
"Reads" => "Olvasás",
"Forums best topics" => "A legjobb topic-ok",
"Score" => "Pontszám",
"Forums most visited forums" => "Leglátogatottabb fórumok",
"Visits" => "Látogatások",
"Forums with most posts" => "A legtöbb üzenettel rendelkező fórumok",
"Posts" => "Hozzászólások",
"Wiki top galleries" => "Wiki leglátogatottabb galériái",
"Wiki top file galleries" => "Wiki leglátogatottabb fájlgalériái",
"Wiki top images" => "Wiki legjobb képek",
"Wiki top files" => "Wiki legjobb fájlok",
"Downloads" => "Letöltések",
"Wiki last images" => "Wiki utóbbi képek",
"Upload date" => "Feltöltés dátuma",
"Most visited blogs" => "Legtöbbet látogatott blogok",
"Post date" => "Beküldés időpontja:",
"Wiki top authors" => "A wiki oldalak kiemelkedő szerzői",
"Pages" => "Oldalak",
"User already exists" => "Ez felhasználónév már létezik ebben a rendszerben",
"Login" => "Bejelentkezés",
"See other user's profile" => "Más felhasználó profijának megtekintése",
"Have your profile seen" => "Más felhasználó megtekinti a profilomat",
"Make friends" => "Barátságkötés",
"Receive message" => "Üzenet fogadása",
"Send message" => "Üzenet küldése",
"Read an article" => "Cikk olvasása",
"Publish an article" => "Cikk publikálása",
"Have your article read" => "Más felhasználó olvassa egy cikkemet",
"Create new file gallery" => "Új fájlgaléria létrehozása",
"Upload new file to gallery" => "Új fájl feltöltése galériába",
"Download other user's file" => "Más felhasználó fájljának letöltése",
"Have your file downloaded" => "Más felhasználó letölti egy fájlomat",
"Create a new image gallery" => "Új képgaléria létrehozása",
"Upload new image to gallery" => "Új kép feltöltése galériába",
"See other user's gallery" => "Más felhasználó galériájának megtekintése",
"See other user's image" => "Más felhasználó képének megtekintése",
"Have your gallery seen by other user" => "Más felhasználó megtekinti egy galériámat",
"Have your image seen" => "Más felhasználó megnézi egy képemet",
"Create new blog" => "Új blog létrehozása",
"Post in a blog" => "Posztolás egy blogba",
"Read other user's blog" => "Más felhasználó blogjának olvasása",
"Have your blog read" => "Más felhasználó olvassa egy blogomat",
"Create a new wiki page" => "Új wikioldal létrehozása",
"Edit an existing page" => "Létező oldal szerkesztése",
"Attach file" => "Fájl csatolása",
"Tracker" => "Űrlap",
"Unknown" => "Ismeretlen",
"Trackeritem" => "Űrlap tétel",
"Image" => "Kép",
"Article" => "Cikk",
"FAQ" => "GYIK",
"Forum" => "Fórum",
"Wiki Comment" => "Wiki komment",
"Calendar item" => "Naptár tétel",
"Gallery" => "Galéria",
"Blog post" => "Blog poszt",
"Tracker item" => "Űrlap tétel",
"Simple" => "Alap",
"Advanced" => "Haladó",
"Prev" => "Előző",
"Next" => "Következő",
"Edit Template" => "Sablon szerkesztése",
"Admin Feature" => "Funkció adminisztrálása",
"Hide" => "Elrejtés",
"help" => "súgó",
"All" => "Összes",
"Date Selector" => "Dátum kiválasztó",
"Select All" => "Összes kijelölése",
"days" => "nap",
"day" => "nap",
"mins" => "perc",
"min" => "perc",
"secs" => "másodperc",
"sec" => "msp",
"done" => "kész",
"Task" => "Feladat",
"from" => "tól",
"for" => "",
"Priority" => "Prioritás",
"User information - Click for more info" => "Felhasználói adatok - Kattintás további információkért",
"Friend" => "Barát",
"Last seen on" => "Legutóbbi bejelentkezés",
"Yes" => "Igen",
"No" => "Nem",
"pvs" => "oldalmegtekintés",
"Table of contents" => "Tartalomjegyzék",
"unknown error" => "ismeretlen hiba",
"You are not logged in" => "Először <a href=\"tiki-login_scr.php\">be kell jelentkezni</a> ehhez!",
"Page cannot be found" => "Ez az oldal nem található!",
"Permission denied you cannot view this section" => "Magasabb szintű jogosultágra van szükség a szekció megtekintéséhez",
"An error occured in a database query!" => "Hiba lépett fel az adatbázis lekérdezése közben!",
"Help link" => "Súgó",
"Help" => "Súgó",
"You are banned from" => "Kitiltottak innen:",
"faqs" => "gyakran intézett kérdések",
"quizzes" => "kvízek",
"blogs" => "blogok",
"forums" => "fórumok",
"games" => "játékok",
"Edit Plugin" => "Plugin szerkesztése",
"Update variables" => "Változók frissítése",
"Edit Section" => "Szekció szerkesztése",
"Show" => "Megjelenítés",
"Altering database table failed" => "Adatbázis megváltoztatása nem sikerült",
"Removed" => "Eltávolítva",
"at" => "ekkor",
"new" => "új",
"Create page:" => "Oldal létrehozása:",
"Unknown language" => "Ismeretlen nyelv",
"Click here to confirm your action" => "Akció megerősítése",
"Rating" => "Értékelés",
"Item Modification" => "Tétel módosítása",
"Item" => "Tétel",
"Item creation" => "Tétel létrehozása",
"Subject" => "Tárgy",
"Field is not numeric" => "A mező nem numerikus",
"text field" => "szöveges mező",
"half column" => "fél oszlop",
"size" => "méret",
"prepend" => "előtte",
"append" => "utána",
"textarea" => "szöveges terület",
"checkbox" => "jelölőnégyzet",
"numeric field" => "numerikus mező",
"drop down" => "legördülő",
"drop down with other textfield" => "legördülő egyéb szöveges mezővel",
"radio buttons" => "választó kapcsoló",
"user selector" => "felhasználó kiválasztása",
"group selector" => "csoport kiválasztása",
"country selector" => "ország kiválasztása",
"date and time" => "dátum és idő",
"action" => "akció",
"header" => "fejléc",
"static text" => "statikus szöveg",
"category" => "kategória",
"item link" => "tétel link",
"items list" => "tételek listája",
"dynamic items list" => "dinamikus tétellista",
"email" => "E-mail",
"multimedia" => "multimédia",
"auto-increment" => "automatikus számozás",
"user subscription" => "felhasználói előfizetés",
"Google Maps" => "Google térképek",
"system" => "rendszer",
"computed field" => "számított mező",
"user preference" => "felhasználói preferencia",
"attachment" => "melléklet",
"open" => "nyitva",
"pending" => "függőben",
"closed" => "lezárva",
"Message" => "Üzenet",
"child categories" => "gyermek kategóriák",
"objects in category" => "elemek ebben a kategóriában",
"Password should be at least" => "A jelszónak legalább",
"characters long" => "karakter hosszúnak kell lennie",
"Password must contain both letters and numbers" => "A jelszónak betűket és számjegyeket is tartalmaznia kell!",
"Personal Phone" => "Személyes telefon",
"Personal Mobile" => "Személyes mobil",
"Personal Fax" => "Személyes fax",
"Work Phone" => "Munkahelyi telefon",
"Work Mobile" => "Munkahelyi mobil",
"Work Fax" => "Munkahelyi fax",
"Company" => "Vállalat",
"Organization" => "Szervezet",
"Department" => "Részleg",
"Division" => "Divízió",
"Job Title" => "Munkakör",
"Street Address" => "Utca cím",
"City" => "Város",
"State" => "Régió",
"Zip Code" => "irányítószám",
"Country" => "Ország",
"Displays browser client info" => "Megjeleníti a böngésző kliens információit",
"Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Linket helyez el egy wiki oldal egy horgonyához. Együtt kell használni a horgony helyét és nevét megadó ANAME pluginnal",
"Anchor Name" => "Horgony név",
"Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Horgonyt helyez el egy wiki oldalon. Együtt kell használni a horgonyra mutató linket létrehozó ALINK pluginnal",
"Image Annotation" => "Kép annotáció",
"Location" => "Lokáció",
"Width" => "Szélesség",
"Height" => "Magasság",
"Alignment" => "Igazítás",
"Save changes to annotations" => "Menti az annotációk válozásait",
"Creates an annotation block for an image." => "Annotációs blokkot hoz létre egy képhez",
"Field" => "Mező",
"Article ID" => "Cikk ID",
"Includes an article" => "Cikket illeszt be",
"Id is optional. If not given, last article is used. Default field is heading." => "Id megadása opcionális. Ha nincs megadva akkor a legutolsó cikk kerül megjelenítésre. Az alapértelmezett mező a fejléc.",
"Article List" => "Cikk lista",
"Includes a list of articles within the page." => "Cikkek listáját jeleníti meg az oldalon",
"Articles displayed" => "Megjelenített cikkek",
"Topics expression" => "Témák kifejezés",
"Topic ID expression" => "Téma ID kifejezés",
"Type expression" => "Típus kifejezés",
"Category ID" => "Kategória ID",
"Language" => "Nyelv",
"Sort order" => "Rendezés módja",
"Quiet" => "Csendes",
"Title only" => "Csak cím",
"Start date" => "Kezdés dátuma",
"End date" => "Befejezés dátuma",
"Includes articles listing into a wiki page" => "Cikkek listáját jeleníti meg egy wiki oldalon",
"Attachment" => "Melléklet",
"File" => "Fájl",
"Show description" => "Leírás megjelenítése",
"Number" => "Szám",
"Show icon" => "Ikon megjelenítése",
"No such attachment on this page" => "Nincs ilyen melléklet ezen az oldalon",
"Displays an attachment or a list of them" => "Megjelenít egy mellékletet vagy a mellékletek listáját",
"Gives the name of the attached file to link to" => "Megadja link céljául szolgáló melléklet nevét",
"Same as name" => "Ugyanaz mint a név",
"Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Megadja a másik oldal nevét ",
"Shows the description as the link text instead of the file name" => "Nem a fájlnevet hanem a leírást jeleníti meg a link szövegeként",
"Makes the list of attachments a bulleted list" => "Listázza a mellékleteket",
"Says that this file is an image, and should be displayed inline using the img tag" => "Jelzi hogy a fájl egy kép és sorban kell megjeleníteni az img tag használatával",
"Puts the stuff between {ATTACH} tags as the link text instead of the file name or description" => "Beteszi az adott dolgot az {ATTACH} tag-ek közé link szövegeként a fájlnév vagy a leírás helyett",
"Shows all attachments from the whole wiki" => "Megmutatja a teljes wiki összes mellékletét",
"Gives the number, in the list of attachments, of the attachment to link to" => "Megadja a mellékletek listájában a melléklet számát melyre a link mutat",
"Gives the actual id of the attachment to link in. You probably should never use this" => "Megadja a melléklet tényleges Id-ját melyre a link mutat. Ezt valószínűleg sosenem fogja bárki is használni :)",
"Puts the number of downloads in the alt comment" => "Megjeleníti a letöltések számát",
"Shows a file icon" => "Fájl ikonját jeleníti meg",
"Avatar" => "Avatár",
"Displays the user Avatar" => "Megjeleníti a felhasználó avatárját",
"username" => "felhasználónév",
"Float" => "Lebegés",
"left|right" => "bal|jobb",
"Back" => "Vissza",
"Backlinks" => "Hivatkozások",
"No Header" => "Nincs fejléc",
"List all pages which link to specific pages" => "Listázza az adott oldara mutató összes oldalt",
"No pages links to" => "Nincs ide mutató oldal",
"One page links to" => "Egy oldal mutat ide",
"pages link to" => "idemutató oldal",
"Zone" => "Zóna",
"Target" => "Cél",
"missing parameter" => "hiányzó paraméter",
"Blog List" => "Blog lista",
"Numeric value" => "Numerikus érték",
"Items" => "Tétel",
"Box" => "Doboz",
"Insert theme styled box on wiki page" => "Stílus szerint mintázott dobozt jelenít meg a wikioldalon",
"Box title" => "Doboz címe",
"Displayed above the content" => "A tartalom felett kerül megjelenítésre",
"Background color" => "Háttérszín",
"Box width" => "Doboz szélesség",
"Text Alignment" => "Szöveg igazítása",
"Float Position" => "Lebegő pozíció",
"CSS Class" => "CSS osztály",
"Category" => "Kategória",
"Category IDs" => "Kategória azonosítók (ID-k)",
"Types" => "Típusok",
"List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "Objektumtípusok listája + jellel elválasztva. Pld: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
"Sort Order" => "Rendezési sorrend",
"fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid mezők: type, created, name, hits, shuffle",
"Split" => "Felosztás",
"And" => "És",
"Insert list of items for the current/given category into wiki page" => "Beilleszti az adott kategória tételeit a wikioldalba",
"Categories are disabled" => "Kategória funkció nincs aktiválva",
"Category Orphans" => "Kategória nélküliek",
"Display Tiki objects that have not been categorized" => "Megjeleníti a nem kategorizált tiki objektumokat",
"Objects" => "Objektumok",
"Category Path" => "Kategória útvonal",
"Separator" => "Szeparátor",
"Display top category" => "Legfelső kategória megjelenítése",
"yes|no, default to no" => "yes|no (alapértelmezés: no)",
"Insert the full category path for each category that this wiki page belongs to" => "Beilleszti a kategória teljes útvonalát minden egyes kategóriához melybe az oldal beletartozik",
"Center" => "Középre",
"Centers the plugin content in the wiki page" => "A plugin a tartalmat a wiki oldal közepére teszi",
"Chart" => "Grafikon",
"Sheet ID" => "Ív ID",
"Data sheet ID" => "Adatív ID",
"Chart Type" => "Ábta típus",
"Chart Width" => "Ábra szélesség",
"Chart Height" => "Ábra magasság",
"Value series" => "Érték sorozat",
"Required for pie charts" => "Torta ábrához szükséges",
"Independant series" => "Független sorozat",
"Required for types other than pie chart" => "Nem torta ábrákhoz szükséges",
"Dependant series" => "Függő sorozatok",
"Styles" => "Stílusok",
"Labels" => "Feliratok",
"title" => "cím",
"Chart as PDF" => "Grafikon PDF-ként",
"Chart as PostScript" => "Grafikon PostScript-ként",
"Code" => "Kód",
"Displays a snippet of code" => "Megjelenít egy kódrészletet",
"code" => "kód",
"Caption" => "Képfelirat",
"Word Wrap" => "Szövegtörés",
"Colors" => "Színek",
"Line numbers" => "Sorok száma",
"Wiki syntax" => "Wiki szintakszis",
"Right to left" => "Jobbról balra",
"0|1, switch the text display from left to right to right to left" => "0|1, a szöveg megjelenítését jobbról balra irányra állítja át",
"Content is HTML" => "A tartalom HTML",
"0|1, display the content as is instead of escaping HTML special chars" => "0|1, tartalom megjelenítése úgy ahogy van ahelyett hogy átugraná a speciális HTML karaktereket",
"note: colors and ln are exclusive" => "figyelem: a színek és az ln exkluzívak (kizárják egymást)",
"Dynamic Content" => "Dinamikus tartalom",
"Content ID" => "Tartalom ID",
"Cookie" => "Süti",
"Also known as Fortune cookies or Taglines" => "Más néven szerencssüti vagy címkesor",
"Copyright" => "Szerzői jogok",
"Insert copyright notices" => "Szerzői jogi információt szúr be",
"Countdown" => "Visszaszámlálás",
"Locate Time" => "Helyi idő",
"Example" => "Például",
"and" => "és",
"seconds" => "másodperc",
"Run a database report" => "Adatbázis riportot futtat",
"report definition" => "riport definíció",
"Full DSN" => "Teljes DSN",
"A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "Teljes DSN (Data Source Name) kapcsolódási sztring. Pld: mysql://user:pass@server/database",
"Wiki DSN name" => "Wiki DSN név",
"Debug" => "Hibakeresés",
"Missing db or dsn parameter" => "Hiányzó db vagy dsn paraméter",
"You do not have permission to use this DSN" => "Nincs elegendő jogosultság ezen DSN használatához",
"Insert a division block on wiki page" => "DIV blokkot illeszt a wikioldalra",
"Definition List" => "Definíciós lista",
"Creates a definition list" => "Definíciós listát készít",
"term" => "fogalom",
"definition" => "definíció",
"one definition per line" => "soronként egy definíció",
"Draw" => "Rajz",
"Displays drawings in the wiki page" => "Rajzot jelenít meg a wiki oldalban",
"drawing not found" => "a rajz nem található",
"Name parameter missing" => "Név paraméter hiányzik",
"Equation" => "Egyenlet",
"equation" => "egyenlet",
"Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "LaTeX szintakszisban írt egyenletet renderel png kiterjesztésű képpé. Opcionális paraméterek a size (méret) mely alapértelmezett értéke 100 és a normál méret százaléka,  például size=200 jelzi hogy az egyenlet a normál méret kétszerese",
"Events" => "Események",
"Calendar ID" => "Naptár ID",
"Numeric" => "Numerikus",
"Maximum days" => "Maximum napok",
"Maximum Rows" => "Maximum sorok",
"Datetime" => "Dátum idő",
"Desc" => "Leírás",
"~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} RSS feed-et illeszt be egy wiki oldalba",
"Upcoming events" => "Jövőbeli események",
"Fade" => "Előtűnés",
"Label" => "Címke",
"Label to display on first display" => "Első megjelenéskor mutatandó felirat",
"Unspecified label" => "Nincs felirat megadva",
"Fancy List" => "Puccos lista",
"Use div" => "Div használata",
"Use div instead of ol" => "Div használata rendezett lista formátum helyett",
"Class" => "Osztály",
"CSS class of the fancylist" => "CSS osztály a puccos listához",
"Creates a fancy looking list" => "Puccos kinézetű listát hoz létre",
"num" => "szám",
"item text" => "tétel szöveg",
"one item per line" => "egy tétel soronként",
"Fancy Table" => "Puccos tábla",
"Heading row" => "Fejléc sor",
"Heading CSS Class" => "Fejléc CSS osztály",
"Displays the data using the Tikiwiki odd/even table style" => "Az adatot a TikiWiki páros/páratlan táblastílusban jeleníti meg",
"cells" => "cellák",
"heads and cells separated by ~|~" => "fejlécek és cellák ~|~-al kerülnek elválasztásra",
"Title" => "Cím",
"Gallery ID" => "Galéria ID",
"sort" => "rendezés",
"Shows ID" => "ID megjelenítése",
"Shows Icon" => "Ikon megjelenítése",
"Shows Name" => "Név megjelenítése",
"Shows Filename" => "Fájlnév megjelenítése",
"Shows Size" => "Méret megjelenítése",
"Shows Description" => "Leírás megjelenítése",
"Shows Creation Date" => "Létrehozás dátumának megjelenítése",
"Shows Hits" => "Találatok megjelenítése",
"Shows Locked by" => "Zároló megjelenítése",
"Shows Modification Date" => "Módosítás dátumának megjelenítése",
"Shows Author" => "Szerző megjelenítése",
"Shows Creator" => "Létrehozó megjelenítése",
"Shows Parent Gallery Name" => "Szülő galéria megjelenítése",
"Shows Number of Files" => "Fájlok megjelenítése",
"Shows the slideshow of a gallery" => "Galéria bemutató megjelenítése",
"Displays a SWF on the wiki page" => "SWF-et jelenít meg a wiki oldalon",
"Movie URL" => "Film URL",
"Default width: 425" => "Alapértelmezett szélesség: 425",
"Default height: 350" => "Alapértelmezett magasság: 350",
"Quality" => "Minőség",
"Flash video quality. Default value: high" => "Flash video minőség. Alapértelmezett érték: 'high'",
"Missing parameter movie to the plugin flash" => "Hiányzó film paraméter a flash pluginhez",
"Footnote" => "Lábjegyzet",
"The footnote" => "A lábjegyzet",
"Footnotearea" => "Lábjegyzet terület",
"file name" => "fájl név",
"Ftp Server Name" => "Ftp szerver név",
"Ftp User name" => "Ftp felhasználó név",
"Ftp password" => "Ftp jelszó",
"Download button label" => "Letöltési gomb felirata",
"missing parameters" => "hiányzó paraméterek",
"Connection failed" => "Sikertelen kapcsolat",
"Incorrect param" => "Hibás paraméter",
"failed" => "sikertelen",
"description" => "leírás",
"Value" => "Érték",
"current value (REQUIRED)" => "jelenlegi érték (SZÜKSÉGES)",
"Maximum Value" => "Maximális érték",
"Maximum possible value. Default: 100" => "Maximális lehetséges érték. Alapértelmezés: 100",
"Color" => "Szín",
"Background Color" => "Háttérszín",
"Label Width" => "Címke szélesség",
"Display Percentage" => "Százalék megjelenítése",
"Display Value" => "Érték megjelenítése",
"Displays a graphical GAUGE" => "Grafikus mérőt mutat",
"Google Analytics" => "Google analitika",
"Account number" => "Számla szám",
"Missing parameter" => "Hiányzó paraméter",
"type" => "típus",
"Type of Google document" => "Google dokumentum típus",
"key" => "kulcs",
"Google doc key - for example pXsHENf1bGGY92X1iEeJJI" => "Google dokumentum kulcs - például pXsHENf1bGGY92X1iEeJJI",
"Name of iframe" => "Iframe neve",
"Pixels or %" => "Pixel vagy %",
"Margin Height" => "Margó magasság",
"Pixels" => "Pixel",
"Margin Width" => "Margó szélesség",
"Scrolling" => "Görgetés",
"Displays a Google document" => "Google dokumentumot jelenít meg",
"Group" => "Csoport",
"Allowed Groups" => "Engedélyzett csoportok",
"Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "A blokkot megtekinthető csoportok listája függőleges vonallal elválasztva. Pld: Admins|Developers",
"Denied Groups" => "Tiltott csoportok",
"Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "A blokk megtekintésétől tiltott csoportok listája függőleges vonallal elválasztva. Pld: Anonymous|Managers",
"Display wiki text if user is in one of listed groups" => "Megjeleníti a wiki szöveget ha a felhasználó a listázott csoportok egyikének tagja",
"Include literal HTML in a Wiki page" => "Szó szerinti HTML Wiki oldalban",
"HTML code" => "HTML kód",
"Include literal HTML" => "Szó szerinti HTML belefoglalása",
"name" => "név",
"Displays an iframe" => "iframe-et jelenít meg",
"File ID" => "Fájl ID",
"Image ID" => "Kép ID",
"Image Source" => "Kép forrása",
"Image size" => "Kép méret",
"Image height" => "Kép magasság",
"Image width" => "Kép szélesség",
"Link Relation" => "Link kapcsolat",
"Link title" => "Link címe",
"Image alt text" => "Kép alt. szöveg",
"Image Map" => "Térkép kép",
"CSS Style" => "CSS stílus",
"Default configuration" => "Alapértelmezett konfiguráció",
"Mandatory configuration" => "Kötelező konfiguráció",
"Img" => "Kép",
"Alternate Text" => "Alternatív szöveg",
"Link Title" => "Link címe",
"Float Alignment" => "Lebegés igazítása",
"Include" => "Tartalmazza",
"Page Name" => "Oldal neve",
"Start" => "Kezdés",
"Include a page" => "Oldal magába folgalása",
"Runs a Java applet to access a local Jabber service" => "Java appletet futtat a lokális Jabber szolgáltatás eléréséhez",
"Applet height in pixels" => "Applet magassága pixelben",
"Default Color" => "Alapértelmezett szín",
"JQuery Code" => "JQuery kód",
"jquery code e.g. \$jq(\"img\\" => "jquery kód, pld: \$jq(\"img\\",
"javascript code" => "javascript kód",
"Not Language" => "Nyelv kizárása",
"Displays the text only if the language matchs" => "Csak akkor jeleníti meg a szöveget ha a nyelv megegyezik",
"Last Modification" => "Utolsó módosítás",
"The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "A last_mod_plugin kicseréli saját magát a megnevezett wiki oldal legutolsó módosítási dátumával - vagy a jelenlegi oldaléval ha nem lett oldal megadva",
"List Pages" => "Lapok listázása",
"List wiki pages." => "Wiki oldalakat listáz",
"Result Count" => "Eredmények száma",
"Show Name Only" => "Csak név megjelenítése",
"Show Page Alias" => "Oldal álnév megjelenítése",
"Orphan Language" => "Árva nyelv",
"Exact Match" => "Pontos egyezés",
"Only Orphan Pages" => "Csak árva oldalak",
"Sort" => "Rendezés",
"or" => "vagy",
"List Directory" => "Könyvtár listázása",
"Lists files in a directory" => "Könyvtárban lévő fájlok listája",
"URL Prefix" => "URL előtag",
"Filter" => "Szűrő",
"Maximum amount of files to display" => "Megjelenítendő fájlok maximális száma",
"Map" => "Térkép",
"Displays a map" => "Megjelenít egy térképet",
"Map File" => "Térkép fájl",
"Feature disabled" => "A szolgáltatás ki van kapcsolva",
"Style" => "Stílus",
"Mini Quiz" => "Minikvíz",
"Displays a miniquiz" => "Minikvízt jelenít meg",
"Tracker ID" => "Űrlap ID",
"Insert Module" => "Modul beszúrása",
"Module Name" => "Modul neve",
"Decoration" => "Dekoráció",
"notitle" => "Nincs cím",
"Please choose a module" => "Kérem válasszon egy modult",
"to be used as argument" => "amit használni fog paraméterként",
"Displays a module inlined in page" => "A modult a lapon belül jeleníti meg",
"Sorry no such module" => "Sajnálom, nincs ilyen modul",
"Font" => "Betűtípus",
"Displays the data using a monospace font" => "Az adatot monospace betűtípus használatával jeleníti meg",
"Mouse Over" => "Egérmozgatás felirata",
"Create a mouseover feature on some text" => "Egér szöveg felé mozgatásakor megjelenő szöveget hoz létre",
"Mouseover text if param label exists. Page text if text param exists" => "Egérmozgatási felirat ha a felirat paraméter létezik. Oldal szövege ha a szöveg paraméter létezik",
"Text displayed on the page. The body is the mouseover content" => "Oldalon megjelenített szöveg. A törzs lesz az egérmozgatáskor megjelenő tartalom",
"Destination link when moused-over text is clicked. Use http:// for external links" => "Egérmozgatási szövegre való kattintáskor megjelenő cél link. Használjuk a http:// kezdést külső linkekhez",
"Text" => "Szöveg",
"DEPRECATED" => "NEM MŰKÖDIK",
"Mouse over box width. Default: 400px" => "Egérdoboz szélessége. Alapértelmezés: 400px",
"Mouse over box height. Default: 200px" => "Egérdoboz magassága. Alapértelmezés: 200px",
"Offset X" => "Eltolás X",
"Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px" => "Eltolja a feliratot jobbra a kurzorhoz képest a megadott pixelszámmal. Alapértelmezés: 5px",
"Offset Y" => "Eltolás Y",
"Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px" => "Eltolja a feliratot balra a kurzorhoz képest a megadott pixelszámmal. Alapértelmezés: 0px",
"Parse Body" => "Törzs elemzése",
"y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, wiki tartalomként elemzi a plugin törzsét (Alapértelmezés: y)",
"Color of the inside popup" => "A popup belsejének színe",
"Default: #F5F5F5" => "Alapértelmezés: #F5F5F5",
"Text popup color" => "Szöveg popup szín",
"Sticky" => "Ragadós",
"No label specified" => "Nincs felirat megadva",
"fancy" => "puccos",
"Displays the data using (sort of) MediaWiki syntax" => "Az adatot MediaWiki szintakszissal jeleníti meg",
"data" => "adat",
"Displays a table using MediaWiki syntax" => "Táblázatot jelenít meg MediaWiki szintakszissal",
"MySpace Page" => "MySpace oldal",
"Displays a SWF myspace mp3 playlist on the wiki page" => "Megjelenít egy SWF myspace mp3 playlistet a wikioldalon",
"Object Hits" => "Objektum találatok",
"Object" => "Objektum",
"Object ID" => "Objektum ID",
"Object Type" => "Objektum típusa",
"Days" => "Napok",
"Displays object hit info by object and days" => "Objektum látogatottságát mutatja objektumonként és naponként",
"Picture" => "Kép",
"Search for images uploaded by users" => "Felhasználók által feltöltött képek keresése",
"picture not found" => "a kép nem található",
"Plugin Manager" => "Pluginok kezelése",
"Information" => "Információ",
"Provides a list of plugins on this wiki." => "Megjeleníti ezen wiki pluginjainak listáját",
"No version indicated" => "Nincs verzió feltüntetve",
"No arguments indicated" => "Nincs argumentum megadva",
"Poll" => "Szavazás",
"Poll ID" => "Szavazás ID",
"Displays the output of a poll, fields are indicated with numeric ids." => "Megjeleníti egy kérdőív eredményét, a mezőket numerikus azonosítók jelölik",
"missing poll ID for plugin POLL" => "hiányzik a kérdőív ID a POLL pluginhez",
"Proposal" => "Ajánlat",
"Accept proposal" => "Ajánlat elfogadása",
"Still undecided" => "Még nincs eldöntve",
"Reject proposal" => "Ajánlat elutasítása",
"Displays a proposal acceptance widget" => "Előterjesztés elfogadására szolgáló widget megjelenítése",
"Quote" => "Idézet",
"Quoted text" => "Idézett szöveg",
"Reply to" => "Válasz",
"Quote:" => "Idézet:",
"Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Idézett szöveget dobozba foglalja úgy mint a [QUOTE] BBCode",
"Random Dynamic Content" => "Véletlenszerű dinamikus tartalom",
"Redirect" => "Átirányítás",
"Redirects you to another wiki page" => "Átirányítás más wiki oldalra",
"one data per line" => "egy adat soronként",
"Search" => "Keresés",
"Displays a comment, tip, note or warning box" => "Megjelenít egy kommentet, tippet, megjegyzést vagy figyelmeztető dobozt",
"remarks text" => "megjegyzés szövege",
"Remarks Box" => "Megjegyzés doboz",
"Highlight" => "Kiemelés",
"Icon" => "Ikon",
"RSS Feed" => "RSS feed",
"IDs" => "ID-k",
"List of feed IDs separated by colons. ex: feedId:feedId2" => "Feed ID-k kettőspont által elválasztott listája. Pld: feedId:feedId2",
"Date" => "Dátum",
"You need to specify a RSS Id" => "Meg kell adni egy RDD ID-t",
"RSS Id incorrect:" => "RSS Id inkorrekt:",
"~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} RSS feed tartalmát jeleníti meg wiki oldalon",
"Automatically creates a link to the appropriate SourceForge object" => "Automatikus linket hoz létre a megfelelő SourceForge objektumhoz",
"Sheet" => "Tiki táblázat",
"Sheet Heading" => "Ív címsor",
"New sheet in page: " => "Új ív ezen az oldalon: ",
"Create new sheet" => "Új ív létrehozása",
"TikiSheet" => "Tikiív",
"Edit Sheet" => "Ív szerkesztése",
"Show Pages" => "Oldalak megjelnítése",
"List wiki pages" => "Wikioldalak listázása",
"Search criteria" => "Keresési kritérium",
"Display" => "Leírás",
"Last modified by" => "Utoljára módosította",
"Clickable Skype link" => "Klikkelhető Skype link",
"Action" => "Akció",
"Sorts the plugin content in the wiki page" => "A plugin tartalmát rendezi a wiki oldalon",
"Order" => "Sorrend",
"Split a page into rows and columns" => "Feloszt egy oldalt sorokra és oszlopokra",
"Join Columns" => "Oszlopok egyesítése",
"Generate the colspan attribute if columns are missing" => "Generálja a colspan attribútumot ha hiányoznak oszlopok",
"Fixed Size" => "Rögzített méret",
"Generate the width attribute on the columns" => "A width (szélesség) attribútumot generálja az oszlopokhoz",
"Column Size" => "Oszlop méret",
"First" => "Első",
"Editable" => "Szerkeszthető",
"Display edit icon for each section" => "Szerkesztési ikon megjelenítése minden egyes szekciónál",
"Custom class" => "Saját osztály (custom class)",
"add a class to customize the design" => "Osztály hozzáadása a design testreszabásához",
"Edit" => "Szerkesztés",
"row1col1" => "sor1oszlop1",
"row1col2" => "sor1oszlop2",
"row2col1" => "sor2oszlop1",
"row2col2" => "sor2oszlop2",
"Run a sql query" => "SQL lekérdezést futtat",
"sql query" => "SQL lekérdezés",
"DNS Name" => "DNS név",
"Missing db param" => "Hiányzó db paraméter",
"Subscript" => "Alsó index",
"Displays text in subscript." => "Alsó indexben jelenít meg szöveget",
"Subscribe or unsubscribe to a group" => "Csoportra történő fel/leiratkozás",
"Subscribe Group" => "Feliratkozás csoportra",
"Group Name" => "Csoport neve",
"As known in Tikiwiki" => "Tikiwikiben használt név",
"Subscribe Text" => "Feliratkozás szövege",
"Unsubscribe Text" => "Leiratkozás szövege",
"Subscribe Action" => "Felirtakozási akció",
"Unsubscribe Action" => "Leiratkozási akció",
"Subscribe Groups" => "Feliratkozás csoportokra",
"Subscribe" => "Feliratkozás",
"Groups" => "Csoportok",
"Superscript" => "Felső index",
"Displays text in superscript." => "Felső indexben jelenít meg szöveget",
"Id" => "ID",
"Wiki Page to redirect the user after his vote" => "Wiki oldal neve melyre a felhasználó átirányításra kerül a szavazata leadása utána",
"Displays a survey" => "Kérdőívet jelenít meg",
"Tag" => "HTML tag",
"Displays the text between an html tag" => "Szöveget jelenít meg HTML tagek között",
"Tag Name" => "Tag neve",
"Displays text between an html tag" => "Megjelenít HTML tag közti szöveget",
"Thumbnail" => "Előnézet",
"Displays the thumbnail for an image" => "Megjeleníti egy kép előnézeti képét",
"Maximum Size" => "Maximális méret",
"Floating" => "Lebegés",
"Original" => "Eredeti",
"Title Search" => "Cím keresése",
"Search Criteria" => "Keresési kritérium",
"Exclude" => "Kizárás",
"Search the titles of all pages in this wiki" => "Összes oldalcím keresése a teljes wikiben",
"No pages found for title search" => "Nem található a kritériumoknak megfelelő oldal",
"One page found for title search" => "A keresés egy találatot adott",
"pages found for title search" => "oldal felelt meg a keresési kritériumoknak",
"Table of Contents (Structure)" => "Tartalomjegyzék (Struktúra)",
"Maximum Depth" => "Maximális mélység",
"Structure ID" => "Struktúra neve",
"Show Description" => "Leírás megjelenítése",
"0|1, show the page description instead of the page name" => "0|1, az oldal leírását mutatja az oldal neve helyett (1)",
"Show Numbering" => "Számozás megjelenítése",
"0|1, display the section numbers or not" => "0|1, szekció számok megjelenítése (1) vagy nem (0)",
"Public" => "Publikus",
"List top scoring users" => "Legtöbb pontot szerző felhasználók listázása",
"Translate" => "Fordítás",
"string" => "sztring",
"Translate a string" => "Sztring lefordítása",
"Confirmation message after posting form" => "Űrlap elküldése után megjelenő üzenet",
"Fields" => "Mezők",
"Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Megjelenítendő mező ID-k kettősponttal elválasztott listája. Például: 2:4:5",
"Label on the submit button" => "A Küldés gombon megjelenő felirat",
"Show Title" => "Cím megjelenítése",
"Show Mandatory" => "Kötelező megjelenítése",
"Embedded" => "Beépített",
"Url used for the field links" => "Mező linkekhez használt URL",
"Values" => "Értékek",
"Preview" => "Előnézet",
"preview" => "előnézet",
"View" => "Megtekintés",
"itemId" => "Tétel azonosító (ID)",
"itemId if you want to edit an item" => "Tétel ID a tétel szerkesztéséhez",
"Template File" => "Sablon fájl",
"New Status" => "Új státusz",
"Width of first column " => "Első oszlop szélessége",
"Incorrect fieldId:" => "Hibás mezőID:",
"Error" => "Hiba",
"Following mandatory fields are missing" => "A következő kötelező mezők hiányoznak",
"Following fields are incorrect" => "A következő mezők hibásak",
"Displays an input form for tracker submit" => "Beviteli űrlapot jelenít meg űrlap felviteléhez",
"You do not have permission to insert an item" => "Nincs elegendő jogosultság tétel beszúrásához",
"You do not have permission to modify an item" => "Nincs elegendő jogosultság tétel megváltoztatásához",
"Fields marked with a * are mandatory." => "A *-gal jelölt mezőket kötelező kitölteni",
"Filters" => "Szűrők",
"Display List" => "Lista megjelenítése",
"Tracker Filter" => "Űrlap szűrő",
"notice" => "megjegyzés",
"tracker field type not processed yet" => "űrlap mező típusa még nem került feldolgozásra",
"Filters the items of a tracker, fields are indicated with numeric ids." => "Szűri az űrlap tételeit, a mezőket numerikus azonosítók (ID-k) jelzik",
"Wiki text" => "Wiki szöveg",
"Tracker Item Field" => "Űrlap tétel mező",
"Item ID" => "Tétel ID",
"Field ID" => "Mező ID",
"Status" => "Státusz",
"Test" => "Teszt",
"Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)." => "Megjeleníti egy űrlapmező értékét vagy a wiki szöveget ha a mező értéke beállításra került vagy értéke van (ha itemId nincs megadva akkor használjuk az URL itemId-ját vagy felhasználói űrlapot)",
"Tracker List" => "Űrlap lista",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "Megjeleníti egy űrlap tartalmát, a mezőket numerikus azonosítók (ID-k) jelzik",
"Notice" => "Megjegyzés",
"Colon-separated list of fields to display on click. Example: 6:7" => "Kattintásra megjelenítendő mezők listája kettősponttal elválasztva. Például: 6:7",
"Sticky Popup" => "Ragadós popup",
"Show Links" => "Linkek megjelenítése",
"shownbitems" => "Tételek számának megjelenítése",
"Show Initials" => "Kezdőbetűk megjelenítése",
"Show Status" => "Státusz megjelenítése",
"Show Creation Date" => "Létrehozás dátumának megjelenítése",
"Show Last Modification" => "Legutóbbi módosítás megjelenítése",
"Show Field Name" => "Mezőnév megjelenítése",
"Status Filter" => "Státusz szűrő",
"Sort Mode" => "Rendezés módja",
"Filter Field" => "Szűrő mező",
"Filter Value" => "Szűrő érték",
"Exact Value" => "Pontos érték",
"More" => "Több",
"More URL" => "Több URL",
"Select automatically the item of the current user or the page" => "A jelenlegi felhasználóhoz vagy az oldalhoz tartozó tétel kiválasztása",
"Template" => "Sablon",
"View User" => "Felhasználó megtekintése",
"List of items Ids" => "Tétel ID-k listája",
"link url" => "Link url",
"Left Deliminator" => "Bal deliminator",
"Right Deliminator" => "Jobb deliminator",
"Mode" => "Mód",
"If y, value will be truncated" => "Ha igen ('y') akkor az érték le lesz csapva (trunc)",
"Export Button" => "Export gomb",
"Compute" => "Számítás",
"incorrect filterfield" => "hibás szűrőmező",
"Error in tracker ID" => "Hiba az űrlap ID-ban",
"No field indicated" => "Nincs mező megadva",
"Displays a button to link to a page with a tracker plugin with prefilled tracker fields." => "Megjelenít egy gombot mely hivatkozik egy űrlap plugint használó oldalra ahol előre kitöltött űrlapmezők találhatók",
"Tracker Prefill" => "Űrlap előzetes kitöltése",
"Tracker page name" => "Űrlap oldal név",
"Field 1" => "Mező 1",
"Value 1" => "Érték 1",
"Field 2" => "Mező 2",
"Value 2" => "Érték 2",
"Field 3" => "Mező 3",
"Value 3" => "Érték 3",
"Field 4" => "Mező 4",
"Value 4" => "Érték 4",
"Field 5" => "Mező 5",
"Value 5" => "Érték 5",
"Tracker Stats" => "Űrlap statisztika",
"Show Percentage" => "Százalék megjelenítése",
"Show Bar" => "Sáv megjelenítése",
"Show link to tiki-view_tracker" => "Link mutatása a tiki-view_tracker-hez",
"Displays some stat of a tracker content, fields are indicated with numeric ids." => "Űrlap tartalmának statisztikáját mutatja, a mezőket numerikus azonosítók (ID-k) jelzik",
"incorrect fieldId" => "hibás mezőID",
"Tracker Timeline" => "Űrlap idő",
"Title Field" => "Név mező",
"Summary Field" => "Összegző mező",
"Start Date" => "Kezdés dátuma",
"End Date" => "Befejezés dátuma",
"Element Group" => "Elem csoport",
"Lower Bound" => "Alsó határ",
"Upper Bound" => "Felső határ",
"Primary Scale Unit" => "Elsődleges mérési egység",
"hour, day, week, month or year (default to hour)" => "óra, nap, hét, hónap vagy év (értékek: hour, day, week, month or year (alapértelmezés: hour)",
"Secondary Scale Unit" => "Másodlagos mérési egység",
"hour, day, week, month, year or empty (default to empty)" => "óra, nap, hét, hónap vagy év (értékek: hour, day, week, month or year (alapértelmezés: hour)",
"Link Group Name" => "Csoportnév link",
"Convert the group name to a link. (y|n)" => "Csoport nevének linkké alakítása (y|n)",
"Page Link Field" => "Oldallink mező",
"Missing parameter: %0" => "Hiányzó paraméter: %0",
"Translated" => "Fordítás",
"Links to a translated content" => "Lefordított tartalomra mutat",
"[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] vagy ((wikiname)) vagy ((inter:interwiki)) (wiki szintakszist használ)",
"Two letter language code of the language, ex: fr" => "A nyelv két betűs kódja, pld: hu",
"Flag" => "Zászló",
"Country name, ex: France" => "Ország neve, pld: Franciaország",
"User Count" => "Felhasználók száma",
"Displays the number of registered users" => "Megjeleníti a regisztrált felhasználók számát",
"Group name" => "Csoport neve",
"User List" => "Felhasználók listája",
"Displays a list of registered users" => "Regisztrált felhasználók számát mutatja",
"Login Filter" => "Felhasználói név szűrő",
"Layout" => "Kinézet",
"users" => "felhasználók",
"Preferences" => "Beállítások",
"User Information" => "Felhasználói információk",
"Versions" => "Verziók",
"Split the text in parts visible only under some conditions" => "Felosztja a szöveget olyan részekre melyek csak bizonyos feltételek esetén kerülnek megjelenítésre",
"Navigation" => "Navigáció",
"Default" => "Alapértelmezés",
"This is the default text" => "Ez az alapértelmezett szöveg",
"(version 3)" => "(verzió 3)",
"This is version 3 info" => "Ez verzió 3 információ",
"(version 2)" => "(verzió 2)",
"This is version 2 info" => "Ez verzió 2 információ",
"(version 1)" => "(verzió 1)",
"This is version 1 info" => "Ez verzió 1 információ",
"Vote" => "Szavazás",
"Show Stats" => "Statisztika megjelenítése",
"Show Stats After" => "Statisztika megjelenítése utána",
"Show Creator" => "Létrehozó megjelenítése",
"Table" => "Tábla",
"Level" => "Szint",
"Lists ''wanted'' Wiki pages: " => "''wanted'' wiki oldalakat listázza: ",
"Page-Pattern" => "Oldal-minta",
"Custom-Level-Regex" => "Saját szintű regex",
"^Parameters: key=>value,...\n" => "^Paraméterek: key=>value,...\n",
"empty string" => "üres sztring",
"(refer to PHP function fnmatch() for details)\n" => "(részletekért lásd az fnmatch() PHP függvényt)\n",
"The character, by which ignored patterns are separated." => "A karakter mely által a figyelmen kívűl hagyott minták elválasztásra kerülnek",
"possible values: characters\n" => "lehetséged értékek: karakterek\n",
"Whether to include external wikis in the list." => "Megadja hogy tartalmazzon-e vagy sem külső wikiket a lista",
"possible values: " => "lehetséges értékek: ",
"Collect either originating or wanted pages in a cell and display them in the second column." => "Forrás vagy keresett oldalak összegyűjtése egy cellában és meggjelenítése a második oszlopban",
"Switch-on debug output with details about the items." => "Tételek részleteit tartalmazó hibakeresés bekapcsolása",
"Multiple collected items are separated in distinct table rows, or by comma or line break in one cell." => "Több összegyűjtött tétel külön táblasorban vagy vesszővel vagy egy cellában sortöréssel kerül elkönítésre",
"Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex." => "Keresett oldalak listájának szűrése page_regex vagy saját szűrő alapján. Az alapértelmezett érték a weblaphoz tartozó __current__ page_regex",
"A custom filter for wanted pages to be listed (only used when level=>custom)." => "Saját szűrő listázandó wanted oldalakhoz (csak ha level=>custom).",
"a valid regex-expression (PCRE)" => "egy valid regex-expression (PCRE)",
"non-valid custom regex" => "nem valid custom regex",
"ignored" => "ignorálva",
"dash-WikiWord" => "elválasztás-WikiWord",
"not in level" => "nincs szintben",
"valid" => "érvényes",
"End of debug output." => "Hibakeresési adatok vége",
"Wanted Page" => "Wanted oldal",
"Referenced By Page" => "Oldal által hivatkozva",
"Service Name" => "Szolgáltatás neve",
"Template Name" => "Sablon neve",
"Unknown Template" => "Ismeretlen sablon",
"Unknown Service" => "Ismeretlen szolgáltatás",
"Missing parameters" => "Hiányzó paraméterek",
"Display youtube video in a wiki page" => "Youtube videót jelenít meg wiki oldalon",
"URL to the Youtube video" => "A Youtube videóra mutató URL",
"Width in pixels" => "Szélesség pixelben",
"Height in pixels" => "Magasság pixelben",
"Missing parameter movie to the youtube plugin" => "Hiányzik a film paraméter",
"Removed version \$version" => "Eltávolított verzió \$version",
"rollback version " => "verzió visszaállítása",
"Top" => "Legfelső szint",
"Page locked" => "Oldal zárolva",
"Page unlocked" => "Oldal feloldva",
"Removed last version" => "Legutóbbi verzió eltávolítva",
"ERROR: Either the subject or body must be non-empty" => "Az üzenet tárgya vagy az üzenet törzse nem lehet üres!",
"ERROR: No valid users to send the message" => "HIBA: Nincs érvényes felhasználó akinek el lehetne küldeni az üzenetet",
"Invalid user" => "Érvénytelen felhasználó",
"Message sent to" => "Az üzeneted elküldve. Címzettje:",
"Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Kimenő üzenetek fiókja betelt. Levélküldés előtt törölni vagy archíválni kellene pár üzenetet.",
"You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "Üzenetek küldéséhez előbb lehetővé kell tenni üzenetek fogadását. Ezt a lehetőséget a felhasználói preferenciák között a 'Más felhasználók üzenhetnek nekem' opció bekapcsolásával lehet aktiválni",
"User %s can not receive messages, mailbox is full" => "%s felhasználó nem tud üzeneteket fogadni mert betelt a postafiókja",
"User %s can not receive messages" => "%s felhasználó nem tud üzeneteket fogadni",
"Invalid user: %s" => "Érvénytelen felhasználó: %s",
"Message will be sent to: " => "Az üzenet címzettje: ",
"Archive is full. Delete some messages from archive first." => "Az archívum megtelt. Először törölni kell néhány üzenetet az archívumból.",
"No more messages" => "Nincs több üzenet",
"Tiki Calendar" => "Tiki Naptár",
"Calendar" => "Naptár",
"Create/Edit" => "Létrehozás/szerkesztés",
"Quick Edit a Wiki Page" => "Wiki oldal szerkesztése",
"Post" => "Poszt",
"Changes since" => "Változások",
"Since your last visit..." => "Legutóbbi látogatás óta",
"new comments" => "új kommentek",
"new posts" => "új poszt",
"wiki pages changed" => "módosított wiki lap",
"new articles" => "új cikk",
"new FAQs" => "új GYIK",
"new blogs" => "új blog",
"new blog posts" => "új blogposzt",
"new image galleries" => "új képgaléris",
"new images" => "új kép",
"new file galleries" => "új fájlgaléria",
"new files" => "új fájl",
"new polls" => "új szavazás",
"new users" => "új felhasználók",
"new tracker items" => "új űrlaptétel",
"Invalid username or password" => "Nem megfelelő felhasználónév vagy jelszó",
"Button" => "Gomb",
"change theme" => "stílus megváltoztatása",
"default calendars" => "alapértelmezett naptárak",
"style" => "stílus",
"smarty notice reporting" => "smarty üzenetek riportálása",
"List of attached files" => "Mellékletek listája",
"desc" => "Leírás",
"uploaded" => "Feltöltés ideje",
"Download" => "Letöltés",
"Delete" => "Törlés",
"Remove" => "Eltávolítás",
"Upload file" => "Fájl feltöltése",
"Attach" => "Csatolás",
"Attach a file to this item" => "Fájl csatolása az űrlaptételhez",
"Version" => "Verzió",
"Attachments" => "Mellékletek",
"more info" => "további információ",
"No attachments for this item" => "Nincsenek mellékletek csatolva ehhez a tételhez",
"debug" => "hibakereső",
"Fatal error" => "Hiba",
"Created by" => "Létrehozó",
"on" => "Dátum",
"Edit blog" => "Blog szerkesztése",
"Monitor this Blog" => "Blog figyelése",
"Stop Monitoring this Blog" => "Blog figyelésének felfüggesztése",
"Group Monitor" => "Csoport figyelés",
"Activity=" => "Aktivitás=",
"Actions" => "Akciók",
"Properties" => "Tulajdonságok",
"No records found" => "Nincs megjeleníthető rekord",
"Categorize" => "Kategorizálás",
"Select Categories" => "Kategóriák kiválasztása",
"Admin Categories" => "Kategóriák beállítása",
"No categories defined" => "Nincsenek még létrehozva kategóriák",
"Browse Category" => "Kategóriák böngészése",
"stars" => "csillagok",
"User Level" => "Felhasználói szint",
"private message" => "privát üzenet",
"Send eMail to User" => "E-mail küldése felhasználónak",
"user online" => "felhasználó online",
"user offline" => "felhasználó offline",
"Reply" => "Válasz",
"Approve" => "Jóváhagyás",
"Reject" => "Elutasítás",
"Save to notepad" => "Mentés jegyzettömbbe",
"Monitor this Topic" => "Téma figyelése",
"Stop Monitoring this Topic" => "Téma figyelésének felfüggesztése",
"Errors" => "Hibák",
"Moderator actions" => "Moderátori akciók",
"reported:" => "jelentve:",
"queued:" => "sorban áll:",
"Move to topic:" => "Mozgatás ebbe a témába:",
"Move" => "Mozgatás",
"Delete Selected" => "Kijelöltek törlése",
"Comments Locked" => "Kommentek zárolva",
"Unlock" => "Feloldás",
"Lock" => "Zárolás",
"Messages" => "Üzenetek",
"Plain" => "Normál",
"Threaded" => "Témák",
"Headers Only" => "Csak a fejlécek látszanak",
"Newest first" => "Időben csökkenő",
"Oldest first" => "Időben növekvő",
"Title (desc)" => "Cím (csökk)",
"Title (asc)" => "Cím (növ)",
"Threshold" => "Küszöb",
"Set" => "Beállítás",
"Replies" => "Válaszok",
"below your current threshold" => "küszöbérték alatt van",
"Note" => "Megjegyzés",
"New Reply" => "Új válasz",
"Editing reply" => "Válasz szerkesztése",
"Post new message" => "Új üzenet küldése",
"Editing comment" => "Komment szerkesztése",
"Post new comment" => "Új komment küldése",
"required" => "szükséges",
"Smileys" => "Mosolyok",
"Quicktags" => "Quicktag-ek",
"Post new reply" => "Új válasz küldése",
"Cancel" => "Visszavonás",
"Posting replies" => " Általános tudnivalók",
"Posting comments" => "Kommentek küldése",
"Use" => "Használat",
"for links" => "formátumot linkek megadásához",
"HTML tags are not allowed inside posts" => "HTML tag-ek nem szerepelhetnek az üzenetekben",
"Add Comment" => "Komment hozzáfűzése",
"1 comment" => "1 komment",
"Comments" => "Komment",
"Go back" => "Vissza",
"Return to home page" => "Vissza a kezdőlaphoz",
"Type of contribution:" => "Hozzájárulás típusa:",
"Contributors" => "Hozzájárulók",
"Copyrights" => "Szerzői jogok",
"Authors" => "Szerzők",
"Add" => "Hozzáadás",
"Total" => "Összesen",
"Duplicate File Gallery" => "Fájlgaléria duplikálása",
"Duplicate categories" => "Kategóriák duplikálása",
"Duplicate perms" => "Jogosultságok duplikálása",
"Save" => "Mentés",
"View inserted gallery" => "Beszúrt galéria megtekintése",
"Display Properties" => "Tulajdonságok megjelenítése",
"required field for podcasts" => "podcast-okhoz szükséges",
"any file" => "bármely fájl",
"Gallery is visible to non-admin users?" => "A galéria látható a nem admin felhasználók számára?",
"This Gallery is Public" => "A galéria publikus",
"Users with perms and not only the owner of the gallery can upload in it" => "A galéria tulajdonosán kívűl a megfelelő jogosultságokkal rendelkező felhasználók is feltölthetnek a galériába",
"The files can be locked at download:" => "A fájlok zárolásra kerülhetnek letöltéskor:",
"Maximum number of archives for each file" => "Archívumok maximális száma fájlonként",
"unlimited" => "nincs korlát",
"none" => "nincs",
"Parent gallery" => "Szülő (felettes) galéria",
"Owner of the gallery" => "Galéria tulajdonosa",
"Group of users alerted when file gallery is modified" => "Galéria módosításakor értesítendő felhasználói csoport",
"Allows to select each user for small groups" => "Kisebb csoportok esetén az egyes felhasználók kiválasztása",
"Default sort order" => "Alapértelmezett rendezési sorrend",
"descending" => "csökkenő",
"ascending" => "növekvő",
"Max description display size" => "Leírás megjelenítésének maximális hossza",
"Max Rows per page" => "Sorok max száma oldalanként",
"Listing configuration" => "Listázás beállítása",
"Perhaps you were looking for:" => "Hasonló nevű oldalak:",
"There are no wiki pages similar to '{\$page}'" => "Nincsenek ehhez hasonló nevű oldalak:'{\$page}'",
"You are not logged in." => "Be kell jelentkezni",
"Go to Login Page" => "Ugrás a bejelentkezési oldalra",
"Create this page" => "Oldal létrehozása",
"(page will be orphaned)" => "(árva oldalként)",
"Close Window" => "Ablak bezárása",
"Go to" => "Ugrás",
"Perms" => "Jogosultságok",
"Archives" => "Archivumok",
"Replace" => "Kicserélés",
"List" => "Lista",
"Browse" => "Tallózás",
"Show as a column" => "Megjelenítés oszlopként",
"Show in popup box" => "Megjelenítés felugró dobozban",
"Both" => "Mindkettő",
"Show an icon in a column" => "Ikon megjelenítése oszlopban",
"Close" => "Bezárás",
"all topic" => "összes téma",
"any language" => "bármely nyelv",
"not in" => "de nem",
"any category" => "bármely kategória",
"Number of displayed rows" => "Megjelenített sorok száma",
"Go" => "Indítás",
"in:" => "itt:",
"Folksonomy Tags" => "Címkézés",
"Put tags separated by spaces. For tags with more than one word, use no spaces and put words together." => "A címkéket (tag-eket) szóközzel válasszuk el. Több szóból álló címkéknél írjuk egybe a szavakat a szóközök elhagyásával.",
"Tags" => "Címkék",
"You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page?" => "Az oldal elhagyásakor a mentetlen változások elvesznek.",
"Show Tree" => "Fastruktúra megjelenítése",
"Hide Tree" => "Fastruktúra elrejtése",
"Move Selected Files" => "A kijelölt fájlok mozgatása",
"Download the zip" => "Zip fájl letöltése",
"Assign Permissions" => "Jogosultságok kiosztása",
"Move to" => "Mozgatás ide",
"Assign" => "Hozzárendelés",
"Filename" => "Fájlnév",
"Other Sorts" => "Egyéb rendezések",
"No information" => "Nincs információ",
"New topic:" => "Új téma:",
"Topic:" => "Téma:",
"Contribution" => "Hozzájárulás",
"From" => "Feladó",
"Email notification" => "Tiki E-mail értesítés",
"Title:" => "Cím:",
"Body:" => "Törzs:",
"User:" => "Felhasználó:",
"created" => "létrehozva",
"Old" => "Régi",
"New" => "Új",
"File Name" => "Fájl név",
"Posted by" => "Szerző",
"File Description" => "Fájl leírása",
"An object was added to category" => "Egy objektum hozzáadásra került a kategóriához",
"Added by" => "Hozzáadta:",
"Object type" => "Objektum típusa",
"An object was removed from category" => "Egy objektum eltávolításra került a kategóriából",
"Structure modified" => "Struktúraváltozás",
"A new file have been attached to page" => "Új fájl lett csatolva az oldalhoz",
"File name" => "Fájlnév",
"New attachment on %s, page" => "Új melléklet, %s, oldal:",
"Comment:" => "Komment:",
"The new page content follows below." => "Az oldal új tartalma az alábbiakban található:",
"Wiki page %s was commented on by" => "Wiki oldalhoz %s kommentet fűzött",
"an anonymous user" => "egy anonim felhasználó",
"Wiki page renamed" => "Wiki oldal átnevezve",
"Old name" => "Régi név",
"New name" => "Új név",
"Thank you for your registration. You may log in now." => "Köszönjük a regisztrálást, mostmár be lehet jelentkezni.",
"Last modification date" => "Utolsó módosítás dátuma",
"Legend" => "Rövidítések értelmezése",
"Mapfiles" => "Térkép fájlok",
"Available mapfiles" => "Jelenlegi térképfájlok",
"Create" => "Létrehozás",
"Reload" => "Újratöltés",
"History" => "Előzmények",
"of" => " ",
"Compare" => "Összehasonlítás",
"Current" => "Jelenlegi",
"Versions are identical" => "A verziók megegyeznek!",
"v=view" => "v=view (megtekintés)",
"c=compare" => "c=compare (összehasonlítás)",
"d=diff" => "d=diff (eltérés)",
"User" => "Felhasználó",
"Ip" => "IP",
"Diff" => "Eltérések",
"Older Version" => "Régebbi verzió",
"Directories" => "Könyvtárak",
"Upload Files" => "Fájlok feltöltése",
"messages" => "üzenetek",
"Unread" => "Nem olvasott",
"Flagged" => "Jelölt",
"Unflagged" => "Nem jelölt",
"Containing" => "Tartalmazza",
"Sender" => "Feladó",
"No messages to display" => "Nincs megjeleníthető üzenet",
"Broadcast message" => "Körüzenet",
"All users" => "Összes felhasználó",
"Lowest" => "Legalacsonyabb",
"Low" => "Alacsony",
"Normal" => "Normál",
"High" => "Magas",
"Very High" => "Legmagasabb",
"Send" => "Küldés",
"Compose message" => "Üzenet írása",
"ERROR" => "HIBA",
"To" => "Címzett",
"No messages to download" => "Nincs letölthető üzenet",
"Archive" => "Archívum",
"Mark as read" => "Olvasottként jelöl",
"Mark as unread" => "Olvasatlanként jelöl",
"Mark as flagged" => "Flagged-ként jelöl",
"Mark as unflagged" => "Unflagged-ként jelöl",
"Mark" => "Megjelöl",
"Mailbox" => "Postaláda",
"Compose" => "Levélírás",
"Broadcast" => "Körüzenet",
"Sent" => "Elküldve",
"Read message" => "Üzenet olvasása",
"replyall" => "válasz mindenkinek",
"Flag this message" => "Üzenet megjelölése",
"Replied" => "Megválaszolás",
"Up" => "Fel",
"Down" => "Le",
"Admin Menu" => "Menü adminisztrálása",
"Live Support" => "Élő támogatás",
"Banning" => "Kitiltások",
"Users" => "Felhasználók",
"Cache" => "Gyorsítótár",
"Modules" => "Modulok",
"Links" => "Linkek",
"Hotwords" => "Kulcsszavak",
"RSS Modules" => "RSS modulok",
"Menus" => "Menük",
"Polls" => "Szavazások",
"Mail Notifications" => "E-mailes értesítések",
"QuickTags" => "Quicktag-ek",
"Categories" => "Kategóriák",
"Banners" => "Bannerek",
"Edit Templates" => "Sablonok szerkesztése",
"Cookies" => "Cookie-k",
"Mail-in" => "Bejövő levelezés",
"Content Templates" => "Tartalom sablonok",
"HTML Pages" => "HTML oldalak",
"Shoutbox" => "Üzenőfal",
"Shoutbox Words" => "Üzenőfal szóhasználata",
"Admin dsn" => "DSN adatbáziskapcsolatok beállítása",
"Tiki Cache/Sys Admin" => "Cache/rendszer",
"Security Admin" => "Biztonsági beállítások",
"More..." => "Több...",
"Tikiwiki Assistant" => "Tikiwiki Asszisztens",
"Thank you for installing Tikiwiki" => "Köszönjük hogy a Tikiwiki-t választottad!",
"Admin Home" => "Adminisztrációs központ",
"Admin" => "Adminisztráció",
"Admin Modules" => "Modulok adminisztrálása",
"Admin Menus" => "Menük adminisztrálása",
"login" => "bejelentkezés",
"Recently visited pages" => "Mostanában látogatott lapok",
"January" => "Január",
"February" => "Február",
"March" => "Március",
"April" => "Április",
"May" => "Május",
"June" => "Június",
"July" => "Július",
"August" => "Augusztus",
"September" => "Szeptember",
"October" => "Október",
"Tuesday" => "Kedd",
"Wednesday" => "Szerda",
"Thursday" => "Csütörtök",
"Friday" => "Péntek",
"Today" => "Ma",
"Add event" => "Esemény hozzáadása",
"Received objects" => "Fogadott objektumok",
"Pages:" => "Lapok:",
"Last Sites" => "Utolsó helyek",
"Directory Stats" => "Könyvtár statisztika",
"Sites" => "Weblapok",
"Sites to validate" => "Érvényesítendő oldalcímek",
"Searches" => "Keresések",
"Visited links" => "Látogatott linkek",
"Top Sites" => "Top helyek",
"Featured links" => "Kiemelt linkek",
"Top topics" => "Top témák",
"Last forum topics" => "Legutóbbi fórum témák",
"Most commented forums" => "Legtöbbet kommentált fórumok",
"Most read topics" => "legtöbbet olvasott témák",
"Most visited forums" => "Leglátogatottabb fórumok",
"Add tags" => "Címkék hozzáadása",
"More Like This" => "Több hasonló",
"Most popular tags" => "Legnépszerűbb címkék",
"List everything tagged" => "Összes felcímkézett listázása",
"Google Search" => "Google keresés",
"Last actions" => "Legutóbbi akciók",
"Last articles" => "Legutóbbi cikkek",
"Last blog posts" => "Legutóbbi blogposztok",
"Last" => "Utolsó",
"Last Created blogs" => "Legutóbbi létrehozott blogok",
"Last Created FAQs" => "Utoljára készült Gyakori kérdések",
"Last Created Quizzes" => "Utoljára készült kvíz",
"Last modified file galleries" => "Utoljára módosított fájlgalériák",
"Last Files" => "Legutóbbi fájlok",
"Last galleries" => "Legutóbbi galériák",
"Last Images" => "Legutóbbi képek",
"insert original" => "eredeti beszúrása",
"insert thumbnail" => "előnézeti kép beszúrása",
"Last changes" => "Legutóbbi változások",
"more" => "több",
"Last Modified Items" => "Legutóbbi módosított elemek",
"Last Modified blogs" => "Legutóbb módosított blogok",
"Last submissions" => "Legutóbbi hozzászólások",
"Last Items" => "Legutóbbi elemek",
"Last Visitors" => "Legutóbbi látogatók",
"Register" => "Regisztráció",
"Live support" => "Élő támogatás",
"Open operator console" => "Operátor konzol megnyitása",
"Online users" => "Online felhasználók",
"We have" => "Itt van",
"online users" => "online felhasználó",
"Logged in as" => "Bejelentkezve mint",
"Logout" => "Kijelentkezés",
"Switch User" => "Felhasználó váltása",
"Switch" => "Csere",
"Switch user" => "Felhasználó váltása",
"Login as" => "Bejelentkezés mint",
"Email" => "E-mail",
"eMail" => "E-mail",
"Password" => "Jelszó",
"Remember me" => "Emlékezz rám",
"week" => "hét",
"month" => "hónap",
"year" => "év",
"I forgot my password" => "Jelszó emlékeztető",
"Secure" => "Biztonságos",
"Stay in ssl Mode" => "Maradok titkosított módban",
"Menu" => "Menü",
"You have" => "",
"New Messages" => "Új üzenetek",
"New Message" => "Új üzenet",
"You have 0 new messages" => "Nincs új üzeneted",
"Waiting Submissions" => "Várakozó beadványok",
"submissions waiting to be examined" => "megvizsgálásra váró beadványok",
"Old articles" => "Régi cikkek",
"Send a message to" => "Üzenet küldése:",
"Random Pages" => "Véletlenszerű lapok",
"Register as a new user" => "Regisztrálás új felhasználóként",
"Your registration code:" => "Regisztrációs kód:",
"Username" => "Felhasználónév",
"Passcode to register (not your user password)" => "Regisztrációs továbbmenőkód(nem jelszó)",
"Registration code" => "Regisztrációs kód",
"Repeat password" => "Jelszó ismét",
"Generate a password" => "Jelszó generálása",
"RSS Feeds" => "RSS feed-ek",
"Image Galleries" => "Képgalériák",
"File Galleries" => "Fájlgalériák",
"Maps" => "Térképek",
"Calendars" => "Naptárak",
"Entire Site" => "Teljes weblap",
"Wiki Pages" => "Wiki oldalak",
"Image Gals" => "Képgalériák",
"Images" => "Képek",
"Blog Posts" => "Blogposztok",
"Advanced Search Help" => "Részletes keresés súgó",
"Search Wiki PageName" => "Wiki oldal nevének keresése",
"Read More" => "Bővebben",
"Since your last visit" => "Utolsó látogatás óta",
"Since your last visit on" => "Utolsó látogatás óta a",
"New Images" => "új kép",
"Wiki Pages Changed" => "Módosított wiki lapok",
"New Files" => "Új fájl",
"New Comments" => "Új komment",
"New Users" => "Új felhasználó",
"click to edit" => "Kattintás a szerkesztéshez",
"Nothing has changed" => "Nincs változás",
"Site Language:" => "Weblap nyelve:",
"Theme" => "Stílus",
"Site default" => "Weblap alapértelmezettje",
"Most Active blogs" => "Legaktívabb blog",
"Top articles" => "Legolvasottabb cikkek",
"Top File Galleries" => "Legnépszerűbb fájlgalériák",
"Top games" => "Legjobb játékok",
"Top galleries" => "Leglátogatottabb galériák",
"Top Images" => "Legjobb képek",
"Top Pages" => "Legjobb lapok",
"Top Quizzes" => "Legjobb kvízek",
"Top Visited FAQs" => "Legtöbbet látogatott Gyakori kérdések",
"Page translation" => "Oldal fordításai",
"There are no translations of this page." => "Ennek az oldalnak nincsenek fordításai",
"Up-to-date-ness" => "Naprakészség",
"Better translations" => "Naprakészebb fordítások",
"update from it" => "oldal frissítése ebből",
"view" => "megtekintés",
"None match your" => "Egyik sem egyezik a",
"Set your preferred languages." => "Preferált nyelvek beállítása",
"preferred languages" => "preferált nyelvekkel",
"Equivalent translations" => "Megegyező fordítások",
"Translations that need improvement" => "Frissítésre szoruló fordítások",
"update it" => "frissítés",
"My blogs" => "Blogjaim",
"Bookmarks" => "Könyvjelzők",
"My galleries" => "Galériáim",
"My Pages" => "Oldalaim",
"User tasks" => "Felhasználói feladatok",
"Del" => "Törlés",
"online user" => "online felhasználó",
"Real Name" => "Valódi név",
"vote" => "szavazás",
"Send Newsletter" => "Hírlevelek küldése",
"Insert an image" => "Kép beszúrása",
"Structures:" => "Struktúrák:",
"show structures" => "Struktúrák megjelenítése",
"hide structures" => "Struktúrák elrejtése",
"Manage structures" => "Struktúrák kezelése",
"Location : " => "Hely : ",
"Find:" => "Keresés:",
"pages" => "oldal",
"Click Here" => "Klikk ide",
"Print" => "Nyomtatás",
"comment" => "komment",
"comments" => "kommentek",
"First page" => "Első oldal",
"Previous page" => "Előző oldal",
"page" => "oldal",
"Next page" => "Következő oldal",
"Last page" => "Utolsó oldal",
"Enlarge area height" => "Terület magasságának növelése",
"Reduce area height" => "Terület magasságának csökkentése",
"Do not group by item" => "Ne csoportosítson tételenként",
"Group by item" => "Csoportosítás tételenként",
"Calendar View" => "Naptár nézet",
"List View" => "Lista nézet",
"Tiki Action Calendar" => "Tiki akció naptár",
"Tools Calendars" => "Naptár eszközök",
"Check / Uncheck All" => "Megjelöli / nem jelöli mindet",
"Refresh" => "Frissítés",
"Tip" => "Tipp",
"Cancel Edit" => "Szerkesztés visszavonása",
"Change preferences" => "Beállítások megváltoztatása",
"Site Ads and Banners" => "Hirdetések és bannerek",
"Content" => "Tartalom",
"Activate" => "Aktiválás",
"Publish" => "Publikálás",
"General" => "Általános",
"Features" => "Funkciók",
"Profiles" => "Profilok",
"Customize look and feel of your Tiki" => "Tiki stílusának testreszabása",
"Look &amp; Feel" => "Stílus",
"Text area" => "Szöveges terület",
"Module" => "Modul",
"Meta Tags" => "Meta címkék",
"Community" => "Társaság",
"Freetags" => "Címkék",
"Multimedia" => "Multimédia",
"User files" => "Felhasználói fájlok",
"Webmail" => "Webes levelezés",
"Wysiwyg editor" => "Wysiwyg szerkesztő",
"Semantic wiki links" => "Szemantikus wiki linkek",
"Semantic links" => "Szemantikus linkek",
"Webservices" => "Webes szolgáltatások",
"General Settings" => "Általános beállítások",
"Home Blog (main blog)" => "Kezdőblog (fő blog)",
"Rankings" => "Rangsor",
"Not Installed" => "Nincs installálva",
"Spell checking" => "Helyesírás ellenőrzése",
"Requires a separate download" => "Külön letöltést igényel",
"Default number per page" => "Alapértelmezett szám oldalanként",
"Default ordering" => "Alapértelmezett rendezés",
"Points" => "Pontok",
"Force and limit categorization to within subtree of" => "Kategorizálás kényszerítése és korlátozása ezen kategóriaág alá",
"Title length" => "Cím hossza",
"Creation date" => "Létrehozás dátuma",
"Last modified" => "Utolsó módositás",
"To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "Naptárak hozzáadásához/eltávolításához lásd a \"Naptár\" menüpontot az \"Adminisztráció\" menü alatt az alkalmazás menüjében, vagy",
"Change settings" => "Beállítások megváltoztatása",
"General settings" => "Általános beállítások",
"Default calendars to display" => "Alapértelmezésben megjelenített naptárak",
"Create calendar" => "Naptár létrehozása",
"Default view mode" => "Alapértelmezett megjelenítési mód",
"First day of the week" => "Hét első napja",
"Split hours in periods of" => "Óra felosztása a következő periódusokra",
"1 minute" => "1 perc",
"10 minutes" => "10 perc",
"Manual selection of time/date" => "Idő/dátum manuális kiválasztása",
"JS calendar" => "JS naptár",
"First year in the dropdown" => "Első év a legördülő menüben",
"Last year in the dropdown" => "Utolsó év a legördülő menüben",
"Group calendars" => "Csoport naptárak",
"Sticky popup" => "'Ragadós' felugró ablak",
"Item view tab" => "Tétel nézet fül",
"Browse categories" => "Kategóriák böngészése",
"Administer categories" => "Kategóriák adminisztrálása",
"Category path" => "Kategória útvonal",
"Exclude these categories" => "Ezen kategóriák kizárása",
"Separate category IDs with a comma (,)" => "kategória ID-k vesszővel elválasztva (,)",
"Show category objects" => "Kategória objektumok megjelenítése",
"Use PHPLayers for category browser" => "PHPLayers használata a kategóriák böngészéséhez",
"PHPLayers is disabled" => "PHPLayers ki van kapcsolva",
"Enable now" => "Bekapcsolás most",
"Categories used in templates (TPL)" => "Sablonokban (TPL) használt kategóriák",
"Permissions" => "Jogosultságok",
"Ignore category viewing restrictions" => "Kategória megtekintési korlátozások figyelmen kívűl hagyása",
"Will improve performance, but may show forbidden results" => "Javítja a teljesítményt de megjeleníthet tiltott (jogosultság nélküli) eredményeket",
"Permission to all (not just any) of an object's categories is required for access" => "Objektum kategóriáihoz tartozó összes jogosultság szükséges a hozzáféréshez",
"Look under \"Articles\" on the application menu for links to" => "Lásd a \"Cikkek\" menüpontot az alkalmazás fő menüjében, link:",
"Admin topics" => "Témák beállítása",
"Admin types" => "Típusok beállítása",
"Articles Listing" => "Cikkek listázása",
"Title of articles home page" => "Cikkek kezdőlapja",
"Topic" => "Téma",
"Maximum number of articles on articles home page" => "Cikkek maximális száma a cikkek kezdőlapján",
"Submissions" => "Beküldések",
"Specify notification emails when creating articles" => "Értesítési E-mail címek megadása cikk létrehozásakor",
"Import CSV file" => "CSV fájl importálása",
"Batch upload (CSV file)" => "Kötegelt feltöltés (CSV file)",
"File format: title,authorName,heading,body,lang,user" => "Fájlformátum: cím,szerző neve,fejléc,törzs,nyelv,felhasználó,stb",
"Import" => "Importálás",
"Select which items to display when listing articles" => "Cikkek listázásakor megjelenítendő tételek",
"Publication date" => "Publikálás dátuma",
"Expiration date" => "Lejárat dátuma",
"Visible" => "Látható",
"Users can choose to show their gender" => "Felhasználók megmutathatják nemüket",
"Requires User Preferences feature" => "Felhasználói preferenciák funkció szükséges hozzá",
"Show user's information on mouseover" => "Felhasználói információk megjelenítése egér felhasználói név felé mozgatásakor",
"Requires user's information to be public" => "A felhasználói infomrációknak publikusnak kell lennie",
"Real name" => "Valódi név",
"Gender" => "Nem",
"avatar" => "avatár",
"Number of friends" => "Barátok száma",
"Feature is disabled" => "A funkció ki van kapcsolva",
"Last login" => "Legutóbbi bejelentkezés",
"Distance" => "Távolság",
"Default user preferences" => "Alapértelmezett felhasználói preferenciák",
"Users Default Preferences" => "Alapértelmezett felhasználói preferenciák",
"default" => "alapértelmezés",
"Number of visited pages to remember" => "A nyilvántartott látogatott lapok száma",
"Displayed time zone" => "Használt időzóna",
"Detect user timezone if browser allows, otherwise site default" => "Felhasználói időzóna felismerése (ha a böngésző lehetővé teszi), egyébként az oldal alapértelmezettje",
"User information" => "Felhasználói információ",
"Private" => "privát",
"public" => "publikus",
"Use double-click to edit pages" => "Oldal szerkesztése duplakattintással",
"Show user's info on mouseover" => "Felhasználói információk mutatása egér felhasználói név felé mozgatásakor",
"Tasks per page" => "Laponkénti feladatok",
"User messages" => "Felhasználói üzenetek",
"Messages per page" => "Üzenetek száma oldalanként",
"Allow messages from other users" => "Más felhasználók üzenhetnek nekem",
"Send me an email for messages with priority equal or greater than" => "E-mail küldése azokról az üzenetekről melyek prioritása legalább:",
"Auto-archive read messages after x days" => "Olvasott üzenetek automatikus arhíválása x nap után",
"never" => "soha",
"My Tiki" => "Saját Tikim",
"My pages" => "Lapjaim",
"My messages" => "Üzeneteim",
"My tasks" => "Feladataim",
"My forum topics" => "Fórum témáim",
"My forum replies" => "Fórum válaszaim",
"My items" => "Tételeim",
"My workflow" => "Munkafolyamatom",
"Select which items to display when listing users" => "Felhasználók listázásakor megjelenítendő tételek kiválasztása",
"Copyright allows to determine a copyright for all the objects of tikiwiki" => "A Szerzői jogok segítségével szerzői jogi megjegyzést lehet fűzni a tikiwiki egyes objektumaihoz",
"License page" => "Licensz lap",
"Submit notice" => "Megjegyzés küldése",
"Enable copyright management for" => "Szerzői jogok kezelésének bekapcsolása",
"Feature" => "Funkció",
"To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "Könyvtár beállításához lásd a \"Könyvtár adminisztrálása\" menüpontot a \"Könyvtár\" menü alatt az alkalmazás menüjében, vagy",
"Number of columns per page when listing categories" => "A laponkénti oszlopok száma a kategóriák megtekintésénél",
"Links per page" => "Laponkénti hivatkozások (linkek)",
"Validate URLs" => "URL-ek hitelesítése",
"enable cool sites" => "Népszerű oldalak számontartásának engedélyezése",
"Show Country Flag" => "Országzászló mutatása",
"Method to open directory links" => "Könyvtárban szereplő linkek megnyitásának módja",
"New Window" => "Új ablak",
"To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "GYIK-ek hozzáadásához/eltávolításához lásd\"Gyakori kérdések adminisztrálása\" menüpontot a \"Gyakori kérdések\" menü alatt az alkalmazás menüjében, vagy",
"Default number of comments per page" => "Kommentek alapértelmezett száma oldalanként",
"Comments default ordering" => "Kommentek alapértelmezett rendezési elve",
"Question and Answer prefix on Answers" => "Kérdés és Válasz előtag válaszoknál",
"Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site." => "Az <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>egyes funkciók értékelése</a> megtalálható a Tiki fejlesztői weblapján",
"No tabs" => "Fülek nélkül",
"Apply" => "Alkalmazás",
"Reset" => "Visszaállítás",
"Main" => "Fő funkciók",
"Global Features" => "Globális funkciók",
"More Functionality" => "További hasznos funkciók",
"UI Enhancements" => "Felhasználói felület",
"Experimental" => "Kísérleti",
"Programmer" => "Programozás",
"Main Features" => "Fő funkciók",
"Newsletters" => "Hírlevelek",
"Site Global Features" => "Weblap globális funkciói",
"Action Log" => "Akció log",
"Action log setting" => "Akció log beállítás",
"Internationalization" => "i18n",
"Multilingual" => "Többnyelvű",
"Additional Features" => "További funkciók",
"Surveys" => "Kérdőívek",
"Featured Help" => "Featured súgó",
"Copyright System" => "Szerzői jogok rendszere",
"Copyright system" => "Szerzői jog rendszer",
"Live support system" => "Élő támogatási rendszer",
"Tell a Friend" => "Szólj egy barátodnak",
"HTML pages" => "HTML oldalak",
"Contact Us" => "Kapcsolatfelvétel",
"Comments Moderation" => "Kommentek moderálása",
"Comments Locking" => "Kommentek zárolása",
"User interface enhancement features" => "Felhasználói felületet kiterjesztő funkciók",
"JavaScript popup date selector" => "JavaScript felugró dátumválasztó",
"PhpLayers Dynamic menus" => "PhpLayers dinamikus menük",
"Fullscreen" => "Teljes képernyő",
"Allow users to activate fullscreen mode" => "Felhasználók aktiválhatják a teljesképernyős módot",
"Css Menus (suckerfish)" => "Css menük (suckerfish)",
"Mootools or JQuery" => "Mootools vagy JQuery",
"Experimental Features" => "Kísérleti funkciók",
"Seem ok" => "Jól működik",
"HTML Purifier" => "HTML tisztító",
"HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)" => "HTML tisztító (a tartalom XHTML 1.1-es tisztításra kerül szigorúan minden mentésnél)",
"JQuery: JavaScript UI effects" => "JQuery: JavaScript UI effektusok",
"Mobile" => "Mobil",
"Morcego 3D browser" => "Morcego 3D böngésző",
"Need polish" => "Csiszolandó",
"Features that need admin help and user patience to work well" => "Ezen funkciók működnek de adminisztrátori segítség és türelem kell hozzájuk",
"Search engine friendly url" => "Keresőmotor-barát URL",
"Spreadsheet" => "Táblázatkezelés",
"Tiki Sheet" => "Tiki ív",
"Malfunctioning" => "Hibásan működik",
"These features have critical faults - not recommended" => "Ezen funkciók kritikus hibákkal rendelkeznek - nem ajánlott",
"Magic Admin Panel" => "Magic adminisztrációs panel",
"Old features no longer maintained" => "Nem karbantartott régi funkciók",
"Drawings" => "Rajzok",
"Friendship" => "Barátság",
"Friendship Network" => "Baráti körök",
"Games" => "Játékok",
"Administration Features" => "Adminisztrációs eszközök",
"Banning System" => "Kitiltási rendszer",
"Banning system" => "Kitiltási rendszer",
"Stats" => "Statisztikák",
"Action Calendar" => "Akció naptár",
"Tiki action calendar" => "Tiki akció naptár",
"Redirect On Error" => "Átirányítás hiba esetén",
"Communications (send/receive objects)" => "Kommunikáció (objektum küldése/fogadás)",
"Custom Home" => "Saját kezdőlap",
"User Features" => "Felhasználói eszközök",
"Display 'MyTiki' in the application menu" => "MyTiki megjelenítése az alkalmazás fő menüjében",
"Mini Calendar" => "Mini Naptár",
"User Preferences Screen" => "Felhasználói preferenciák képernyő",
"User Notepad" => "Felhasználói jegyzettömb",
"User Bookmarks" => "Felhasználói könyvjelzők",
"User Contacts" => "Felhasználó kapcsolatai",
"User Watches" => "Felhasználói figyelések",
"User Watches Translations" => "Felhasználó figyeli a fordításokat",
"User Menu" => "Felhasználói menü",
"User Tasks" => "Felhasználói feladatok",
"User Messages" => "Felhasználói üzenetek",
"User Files" => "Felhasználói fájlok",
"Newsreader" => "Hírolvasó",
"User Levels" => "Felhasználói szintek",
"Integrator" => "Integrátor",
"Debugger Console" => "Debug konzol",
"TikiTests" => "TikiTest",
"Workflow" => "Munkafolyamatok",
"Workflow engine" => "Munkafolyamatok",
"If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "Ha úgy döntünk hogy a fájlokat könyvtárban tároljuk akkor biztosítsuk hogy a felhasználók közvetlenül nem érhetik el az adott könyvtárat",
"You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "Ennek megoldására két lehetőség van:<br /><ul><li>Használjunk a dokumentum gyökéren kívűli könyvtárat és biztosítsuk hogy a php szkript olvashatja és írhatja könyvtárat</li><li>Használjunk a dokumentum gyökerén belüli könyvtárat és használjuk .htaccess fájlt annak megakadályozására hogy a felhasználók listázhassák a könyvtár tartalmát</li></ul>",
"To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "A könyvtár útvonalának konfigurálásához használjunk UNIX jellegű útvonalat, például: files/ vagy c:/foo/files vagy /www/files/",
"Gallery Listing" => "Galériák listázása",
"Search Indexing" => "Keresés indexelése",
"Home Gallery (main gallery)" => "Kezdőgaléria (fő galéria)",
"Create a Gallery" => "Galéria létrehozása",
"Store in database" => "Tárolás adatbázisban",
"Store in directory" => "Tárolás könyvtárban",
"The server must be able to read/write the directory." => "A szervernek tudnia kell olvasni/írni a könyvtárat",
"The directory can be outside the web space." => "A könyvtár lehet a webes területen kívűl",
"Podcast directory" => "Podcast könyvtár",
"Default Ordering" => "Alapértelmezett rendezés",
"Allow download limit per file" => "Fájlonkénti letöltési limit engedélyezése",
"Prevent download if score becomes negative" => "Letöltés tiltása ha a pontszám negatív",
"Allow same file to be uploaded more than once" => "Egyazon fájl többszöri feltöltésének engedélyezése",
"Never" => "Soha",
"Yes, even in the same gallery" => "Igen, még ugyanabba a galériába is",
"Only in different galleries" => "Csak más galériákba",
"Batch uploading" => "Kötegelt feltöltés",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "Ha bekapcsoljuk a Kötegelt könyvtár feltöltést akkor létre kell hoznunk egy weben keresztül olvasható könyvtárat, lehetőleg a webes könyvtárterületen kívűl. Ezután hozzunk létre egy módszert a feltöltés végrehajtására (scp, ftp vagy más protokoll)",
"The server must be able to read the directory." => "A szervernek tudnia kell olvasni könyvtárat",
"Require file author's name for anonymous uploads" => "Fájl szerzőjének megadása kötelező anonim feltöltéskor",
"Upload Regex" => "Feltöltési Regex",
"Must match" => "Egyeznie kell",
"Cannot match" => "Nem egyezhet",
"Gallery Listings" => "Galéria listázás",
"Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Ezen beállítások megváltoztatása  <em>nincs</em> hatással a létező fájlgalériákra. Ezen változások <em>csak</em> az új galériákra lesznek hatással",
"Select which items to display when listing galleries: " => "Galériák listázásakor megjelenítendő tételek",
"MIME Type" => "MIME típus",
"Reindex all files for search" => "Összes fájl újraindexelése kereséshez",
"To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "Fórumok hozzáadásához/eltávolításához lásd a \"Fórumok adminisztrálása\" menüpontot a \"Fórumok\" menüben vagy",
"Forums Listing" => "Fórumok listázása",
"Home Forum (main forum)" => "Kezdő fórum (fő fórum)",
"Create a forum" => "Fórum létrehozása",
"Accept wiki syntax" => "Wiki szintakszis elfogadása",
"Topic archiving" => "Téma archiválás",
"Quick jumps" => "Gyors ugrások",
"Replies are empty" => "Válaszok üresek",
"If disabled, replies will quote the original post" => "Ha ki van kapcsolva akkor a válaszok idézik az eredeti posztot",
"Do not prefix messages titles by 'Re: '" => "Az üzenetek ne kapjanak 'Re:' előtagot",
"First post of a thread can have an empty body" => "Egy thread első posztjának törzse lehet üres",
"Will be a thread title" => "Thread cím lesz",
"Threads" => "Threadek",
"Allows users to override the defaults" => "Felhasználók felülírhatják az alapértelmezéseket",
"Keep settings for all forums during the user session" => "Beállítások megtartása az összes fórumban a felhasználói munkamenet alatt",
"Default style" => "Alapértelmezett stílus",
"Default sort mode" => "Alapértelmezett rendezési mód",
"Forum name search" => "Fórum név keresés",
"When listing forums" => "Fórumok listázásakor",
"Forum content search" => "Fórum tartalom keresés",
"Topic content search" => "Téma tartalom keresés",
"Search is disabled" => "Keresés ki van kapcsolva",
"Select which items to display when listing forums" => "Fórumok listázásakor megjelenítendő tételek",
"Topics" => "Témák",
"Posts per day" => "Napi posztok száma",
"Description length" => "Leírás hossza",
"3D Tag Browser" => "3D címke böngészés",
"Show tag cloud" => "Címke felhő megjelenítése",
"Maximum number of tags in cloud" => "Címkék maximális száma a felhőben",
"Show freetags in middle column" => "Szabad címkék (freetagek) megjelenítése a középső oszlopban",
"Preload freetag random tag" => "Véletlenszerű freetag előtöltése",
"Random tag cloud colors" => "Véletlenszerű címkefelhő színek",
"Separate colors with a comma (,)" => "Színek elválasztása vesszővel (,)",
"Number of Tags to show in Tag Suggestions" => "Címke javaslatok között megjelenítendő címkék száma",
"Valid characters pattern" => "Érvényes kartakterek mintája",
"Lowercase tags only" => "Csak kisbetűs címkék",
"Multilingual freetags" => "Többnyelvű freetag-ek",
"Multiligual disabled" => "Többnyelvűség kikapcsolva",
"&quot;More Like This&quot; algorithm" => "&quot;Több hasonló&quot; algoritmus",
"basic" => "alap",
"weighted" => "súlyozott",
"Minimum amount of tags in common" => "Közös címkék miniális száma",
"Tag Management" => "Címkék kezelése",
"Cleanup unused tags" => "Nem használt címkék kitakarítása",
"Morcego 3D browser disabled" => "Morcego 3D böngésző kikapcsolva",
"Enable freetags 3D browser" => "3D címkeböngésző bekapcsolása",
"Browser width" => "Böngésző szélessége",
"Browser height" => "Böngésző magassága",
"Graph appearance" => "Grafika megjelenése",
"Navigation depth" => "Navigáció mélysége",
"Node size" => "Csopont méret",
"Text size" => "Szöveg méret",
"Node color" => "Csomópont szín",
"Camera settinsg" => "Kamera beállítások",
"Camera distance adjusted relative to nearest node" => "Kamera távolság hozzáigazítva a legközelebbi csomóponthoz",
"Camera distance" => "Kamera távolság",
"Field of view" => "Nézet mező",
"Physics engine" => "Fizikai engine",
"Elastic constant" => "Elasztikai konstans",
"Eletrostatic constant" => "Elektrostatikus konstans",
"To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "Képgalériák hozzáadásához /eltávolításához lásd a \"Képgalériák\" menüpontot az alkalmazás fő menüjében, vagy",
"You can upload images of a size of " => "A feltölthető képek maximális mérete ",
"Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Ezen érték megváltoztatásához módosítsuk a php.ini-ben található file_uploads, upload_max_filesize, post_max_size és adatbázi változókat (max_allowed_packet mysql esetén)",
"Home Gallery" => "Kezdőgaléria",
"Galleries features" => "Galériák beállításai",
"Uses Slideshow" => "Bemutató használata",
"Use database to store images" => "Adatbázisban tárolja a képeket",
"Use a directory to store images" => "Könyvtárban tárolja a képeket",
"Directory path" => "Könyvtár útvonala",
"Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below." => "Megjegyzés: ha megváltoztatjuk ezt a könyvtárat akkor a tartalmat át kell mozgatni az új könyvtárba. Ehhez használhatjuk a lentebb található 'Mozgató'-t is.",
"Library to use for processing images" => "A képek átalakitásához használt programkönyvtár",
"Uploaded image names must match regex" => "A feltöltött kép nevének egyezni kell a kifejezéssel",
"Uploaded image names cannot match regex" => "A feltöltött kép neve nem egyezhet a kifejezéssel",
"Directory Batch Loading" => "Kötegelt könyvtár feltöltés",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "Ha bekapcsoljuk a Kötegelt könyvtár feltöltést akkor létre kell hoznunk egy weben keresztül olvasható könyvtárat, lehetőleg a webes könyvtárterületen kívűl. Ezután hozzunk létre egy módszert a feltöltés végrehajtására (scp, ftp vagy más protokoll)",
"Enable directory batch loading" => "Kötegelt könyvtár feltöltés engedélyzése",
"Batch loading directory" => "Köteg feltöltési könyvtára",
"Display image informations in a mouseover box" => "Képinformációk megjelenítése dobozban mikor az egér a kép felett van",
"yes, and don't display those informations under the image" => "Igen, és ezen információk ne a kép alatt jelenjenek meg",
"Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Alapértelmezett maximális sor, képek soronként, előnézet méret és arány használata minden galériánál (értékek beállítása lentebb)",
"Default:" => "Alapértelmezés:",
"Images per row" => "Soronkénti képek",
"Thumbnails size X" => "Előnézet X mérete",
"Thumbnails size Y" => "Előnézet Y mérete",
"Default scale size" => "Alapértelmezett arány mérete",
"pixels" => "pixel",
"Set features" => "Tulajdonságok beállítása",
"Exterminator" => "Exterminátor",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Wiki oldalak, blog posztok, cikkek által nem használt képek eltávolitása a rendszergalériából",
"Mover" => "Mozgató",
"Move images from database storage to filesystem storage" => "Képek mozgatása adatbázisból fájlrendszerbe",
"Move images from filesystem storage to database storage" => "Képek mozgatása fájlrendszerből adatbázisba",
"All galleries" => "Összes galéria",
"System Gallery" => "Rendszergaléria",
"Move images from old filesystem store to new directory" => "Képek mozgatása régi fájlrendszerbeli helyről új fájlrendszerbeli helyre",
"Moved" => "Mozgatásra került",
"Gallery listing configuration" => "Galériák listázásának beállítása",
"Parent" => "Szülő",
"Change configuration" => "Beállítások megváltoztatása",
"Image galleries comments settings" => "Képgalériák kommentjeinek beállítása",
"General Preferences" => "Általános beállítások",
"Date and Time Formats" => "Dátum és idő formátumok",
"Admin Password" => "Adminisztrátori jelszó",
"Release Check" => "Kiadási verzió ellenőrzése",
"Reset or upgrade your database" => "Adatbázis visszaállítása vagy frissítése",
"Check for updates automatically" => "Frissítések automatikus ellenőrzése",
"Check frequency" => "Ellenőrzés gyakorisága",
"Site Identity" => "Weblap identitás",
"Browser title" => "Böngésző címsora",
"Sender email" => "Levélküldési E-mail cím",
"Home Page" => "Főoldal",
"Use group homepages" => "Csoportkezdőlapok használata",
"Go to group homepage only if login from default homepage" => "Csak akkor menjen a csoportkezdőlapra ha a bejelentkezés az alapértelmezett kezdőlapról történt",
"Custom home" => "Egyedi home",
"Miscellaneous" => "Egyéb",
"Server OS" => "Szerver OS",
"Unknown/Other" => "Ismeretlen/Egyéb",
"Smarty Security" => "Smarty biztonság",
"(some Unix MTA)" => "(valami Unix MTA)",
"Logging and Reporting" => "Loggolás és riportolás",
"PHP error reporting level:" => "PHP hibajelentés szinje:",
"Visible to Admin only" => "Csak adminisztrátor számára látható",
"This may impact performance" => "Ez hatással lehet a teljesítményre",
"CSRF Security" => "CSRF biztonság",
"Protect against CSRF with a ticket" => "CSRF elleni védekezés jeggyel",
"Use proxy" => "Proxy használata",
"Host" => "Hoszt",
"Performance" => "Teljesítmény",
"Cache external pages" => "Külső oldalak cache-elése",
"Cache external images" => "Külső képek cache-elése",
"GZip output" => "GZip kimenet",
"Tikiwiki.org help" => "doc.tikiwiki.org felhasználói kézikönyv",
"Compression is handled by" => "Tömörítés kezelője",
"Session" => "Munkamenet",
"Store session data in database" => "Munkamenet információinak tárolása az adatbázisban",
"Session lifetime" => "Munkamenet ideje",
"Contact" => "Kontakt",
"Allow anonymous visitors to use the \"Contact Us\"" => "Engedélyezi anonim látogatók számára a \"Kapcsolatfelvétel\" használatát",
"Contact user" => "Kapcsolattartó felhasználó",
"Count admin pageviews" => "Adminisztrátori lapnézések számolása",
"Temporary directory" => "Ideiglenes könyvtár",
"Help System" => "Segítségnyújtás",
"Help URL" => "Súgó URL",
"Separators" => "Szeparátorok",
"Examples" => "Példák",
"Default timezone" => "Alapértelmezett időzóna",
"Use site default to show times" => "Weblap alapértelmezésének használata idők megjelenítésére",
"Long date format" => "Hosszú dátum formátum",
"Sample" => "Minta",
"Short date format" => "Rövid dátum formátum",
"Long time format" => "Hosszú időformátum",
"Short time format" => "Rövid időformátum",
"Fields display order" => "Mezők megjelenítési sorrendje",
"Date and Time Format Help" => "Dátum és idő formátum segítség",
"Change admin password" => "Admin jelszó megváltoztatása",
"Change the <strong>Admin</strong> password" => "<strong>Adminisztrátori</strong> jelszó megváltoztatása",
"New password" => "Új jelszó",
"Change password" => "Jelszó megváltoztatása",
"Google Map setup" => "Google térkép beállítása",
"You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "Kérni kell egy Google térképkulcsot a weboldal számára. Ezen a címen lehet ezt könnyedén megtenni :",
"Google Map Key" => "Google térképkulcs",
"Default x for map center" => "Alapértelmezett x koordináta a térkép közepéhez",
"Default y from map center" => "Alapértelmezett y koordináta a térkép közepéhez",
"Default zoom level" => "Alapértelmezett zoom szint",
"whole earth" => "teljes Föld",
"country size" => "ország méret",
"city size" => "város méret",
"max zoom" => "maximális zoom",
"Detect browser language" => "Böngésző nyelvének felismerése",
"Show pages in user's preferred language" => "Oldal mutatása a felhasználó által preferált nyelven",
"Users can change site language" => "Felhasználól változtathatják a weblap nyelvét",
"Restrict supported languages" => "Támogatott nyelvek korlátozása",
"Available languages" => "Rendelkezésre álló nyelvek",
"Use Ctrl+Click to select multiple languages" => "Ctrl+kattintás segítségével több nyelv is kiválasztható",
"Display available translations" => "Rendelkezésre álló fordítások megjelenítése",
"Changing page language will also change the site language" => "Oldal nyelvének változtatása változtatja a weblap nyelvét",
"Translation assistant" => "Fordítási asszisztens",
"Urgent translation notifications" => "Sürgős fordítási figyelmeztetések",
"Quantify change size" => "Méret változásának számszerűsítése",
"Multilingual structures" => "Többnyelvű struktúrák",
"Use database for translation" => "Adatbázis használata fordításhoz",
"Edit or ex/import Languages" => "Nyelvek szerkesztése vagy exportálása/importálása",
"Record untranslated" => "Nem lefordítottak rögzítése",
"Intertiki exchange feature" => "Intertiki exchange funkció",
"Intertiki client" => "Intertiki kliens",
"Tiki Unique key" => "Tiki egyedi kulcs",
"InterTiki Slave mode" => "InterTiki Slave mód",
"Warning: overrides manually registered local users" => "Figyelmeztetés: felülírja a manuálisan regisztrált felhasználókat",
"as master" => "master-ként",
"Import user preferences" => "Felhasználói preferenciák importálása",
"Import user groups" => "Felhasználói csoportok importálása",
"Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Csoport importálás szűkítése (vesszővel elválasztott lista az importált csoportokról, hagyjuk üresen ha nem akarunk szűkíteni)",
"Intertiki shared cookie for sliding auth under same domain" => "Intertiki megosztott cookie azonosítás átengedéséhez ugyanazon domain alatt",
"InterTiki Server" => "InterTiki szerver",
"host" => "hoszt",
"Add new server" => "Új szerver hozzáadása",
"Intertiki server" => "Intertiki szerver",
"Intertiki Server enabled" => "Intertiki szerver bekapcsolva",
"Access Log file" => "Hozzáférés log fájl",
"Errors Log file" => "Hiba log fájl",
"Known hosts" => "Ismert hosztok",
"Key" => "Kulcs",
"Enable/disable Tiki features in " => "Tiki funkciók bekapcsolása/kikapcsolása itt végezhető el:",
", but configure them elsewhere" => " (az egyes funkciók konfigurálását máshol kell elvégezni)",
"Text Area" => "Szöveges terület",
"Admin Groups" => "Csoportok adminisztrálása",
"Admin Users" => "Felhasználók adminisztrálása",
"Authentication method" => "Azonosítási módszer",
"Tiki and HTTP Auth" => "Tiki és HTTP Auth",
"Registration" => "Regisztráció",
"Users can register" => "A felhasználók regisztrálhatnak",
"Use challenge/response authentication" => "Kérdés/válasz azonosítás használata",
"Users can choose to stay in SSL mode after an HTTPS login" => "Felhasználók választhatnak hogy SSL módban maradnak HTTPS bejelentkezés után",
"Users can switch between secured or standard mode at login" => "Felhasználók választhatnak standard és biztonságos mód között bejelentkezéskor",
"User's choice" => "Felhasználó választása",
"Always" => "Mindig",
"Duration" => "Időtartam",
"PAM service" => "PAM szolgáltatás",
"Currently unused" => "Jelenleg nem használt",
"Shibboleth Authentication " => "Shibboleth autentikáció",
"Default group" => "Alapértelmezett csoport",
"You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "Külön fel kell tölteni a <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS könyvtárat</a> ide: lib/phpcas/",
"CAS server version" => "CAS szerver verzió",
"Version 1.0" => "Verzió 1.0",
"Version 2.0" => "Verzió 2.0",
"General Layout" => "Általános kinézet",
"UI Effects" => "UI effektusok",
"Theme not saved yet - click \"Apply\"" => "A stílus még nincs elmentve - kattintani kell az \"Alkalmazás\" gombra",
"Theme options" => "Stílus opciók",
"Users can change theme" => "Regisztrált felhasználók megváltoztathatják a stílust",
"Restrict available themes" => "Rendelkezésre álló stílusok korlátozása",
"Available styles:" => "Rendelkezésre álló stílusok:",
"Each group can have its theme" => "Minden csoportnak saját stílusa lehet",
"Slideshows theme" => "Bemutató stílusa",
"Use transition style sheet from version" => "Tranzíciós stílusok használata verziótól",
"Edit CSS" => "CSS szerkesztése",
"Theme Control" => "Stílus kontroll",
"Template Viewing" => "Sablon megtekintés",
"Tiki Template Viewing" => "Tiki sablon megtekintés",
"View Templates" => "Sablonok megtekintése",
"General Layout options" => "Általános szerkezet beállításai",
"Enable additional general layout layers for shadows, rounded corners or other decorative styling" => "További általános kinézeti rétegek (árnyékok, lekerekített sarkok vagy egyéb dekoratív stílusok) bekapcsolása",
"Custom Site Header" => "Weblap fejléc testreszabása",
"logged as" => "bejelentkezve mint:",
"Site Logo and Title" => "Weblap logó és cím",
"Site logo source (image path)" => "Weblaplogó forrása (kép útvonala)",
"Site logo background color" => "Weblaplogó háttérszíne",
"Site logo background style" => "Weblaplogó háttér stílusa",
"Site logo alignment" => "Weblaplogó helye",
"Site logo title (on mouse over)" => "Weblaplogó neve (egér felémozgatásakor)",
"Alt. description (e.g. for text browsers)" => "Képleírás (pld szöveges böngészés számára)",
"Site title" => "Weblap címe",
"Site subtitle" => "Weblap alcíme",
"Site Search Bar" => "Weblap keresés sor",
"Site Login Bar" => "Weblap bejelentkezési sor",
"Top Bar" => "Legfelső sor",
"Site menu bar" => "Weblap menü sor",
"Note: Needs feature PHPLayers on(default), or feature CSS Menu on  " => "Megjegyzés: PHPLayers funkciót (alapértelmezés) vagy a CSS Menu funkciót be kell kapcsolni",
"Menu ID" => "Menü ID",
"Current Version" => "Jelen verzió",
"Custom code" => "Saját kód",
"Users can Flip Columns" => "Felhasználók Users can Flip Columns",
"Left column" => "Bal oszlop",
"always" => "mindig",
"user decides" => "felhasználó dönt",
"Site Breadcrumbs" => "Weblap kenyérmorzsák",
"Site location bar" => "Weblap lokáció sor",
"at top of page" => "oldal tetején",
"at top of center column" => "középső oszlop tetején",
"Prefix breadcrumbs with 'Location : '" => "Kenyérmorzsák előtagja 'Location : '",
"Larger font for" => "Nagyobb betűméret itt",
"entire location" => "teljes kiterjedés",
"page name" => "oldalnév",
"Use page description:" => "Oldalleírás használata:",
"Right column" => "Jobb oszlop",
"Site Report Bar" => "Weblap riport sor",
"Webmaster Report" => "Webmester riport",
"Webmaster Email" => "Webmester E-mail",
"Left blank to use the default sender email" => "Hagyjuk üresen az alapértelmezett küldési E-mail használatához",
"Email this page" => "Oldal küldése E-mailben",
"Custom Site Footer" => "Testreszabott weblap lábléc",
"Bottom bar icons" => "Alsó sor ikonjai",
"Bottom bar debug" => "Hibakereső az alsó soron",
"Bottom bar (RSS)" => "Alsó sor (RSS)",
"Pagination links" => "Oldalléptetési linkek",
"Maximum number of records in listings" => "A rekordok maximum száma listázásnál",
"Use relative (next / previous) pagination links" => "Relatív (következő/előző) oldalléptetési linkek használata",
"Use direct pagination links" => "Direkt oldalléptetési linkek használata",
"Max. number of links around the current item:" => "Linkek maximális száma a jelenlegi tétel körül:",
"Max. number of links after the first or before the last item:" => "Linkek maximális száma az első tétel után vagy az utolsó tétel előtt:",
"Display 'First' and 'Last' links" => "'Első' és 'Utolsó' linkek megjelenítése",
"Display fast move links (by 10 percent of the total number of pages) " => "Gyorsugrási linkek megjelnítése (az oldalak teljes számának 10%-ánál) ",
"Use Icons" => "Ikonok használata",
"JQuery plugins and add-ons" => "JQuery pluginok és kiegészítők",
"Warning" => "Figyelmeztetés",
"Requires jquery feature" => "JQuery funkciót igényel",
"JQuery Tooltips" => "JQuery tippek",
"JQuery Cycle (slideshow)" => "JQuery ciklus (bemutató)",
"For future use" => "Jövőbeli használatra",
"JQuery UI: More JQuery functionality" => "JQuery UI: További JQuery funkcionalitás",
"JQuery Sheet" => "JQuery ív",
"JQuery Spreadsheet" => "JQuery táblázat",
"JQuery Sortable Tables" => "JQuery rendezhető táblák",
"Standard UI effects" => "Sztenderd UI effektusok",
"Effect for modules etc" => "Effektus modulokhoz, stb",
"Main JQuery effect" => "Fő JQuery effektus",
"Effect speed" => "Effektus sebessége",
"Fast" => "Gyors",
"Slow" => "Lassú",
"Effect direction" => "Effektus iránya",
"Vertical" => "Vertikális",
"Horizontal" => "Horizontális",
"Left" => "Bal",
"Right" => "Jobb",
"Tab UI effects" => "Fülek UI effektusai",
"Effect for tabs" => "Effektus fülekhez",
"JQuery effect for tabs" => "JQuery effektus fülekhez",
"Effect speed for tabs" => "Effektus sebessége fülekhez",
"Effect direction for tabs" => "Effektus iránya fülekhez",
"Other options" => "Egyéb opciók",
"Use Tabs" => "Fülek használata",
"Display menus as folders" => "A menüket megjelenítése mappaként",
"Layout per section" => "Szekciónkénti kinézet",
"Admin layout per section" => "Kinézet adminisztrálása szekciónként",
"Favicon icon file name:" => "Favicon ikon fájlnév:",
"Favicon icon MIME type:" => "Favicon ikon MIME típus:",
"image/png" => "kép/png",
"image/bmp" => "kép/bmp",
"image/x-icon" => "kép/x-icon",
"Correct PNG images alpha transparency in IE6 (experimental)" => "PNG képek alfa transparenciájának javítása IE6-ban (kísérleti)",
"full path to mapfiles" => "Teljes útvonal a térképfájlokhoz",
"default mapfile" => "Alapértelmezett térképfájl",
"Wiki Page for Help" => "Súgó wikioldal",
"Wiki Page for Comments" => "Kommentek wikioldala",
"Full path to gdaltindex" => "Teljes útvonal a gdaltindex-hez",
"Full path to ogr2ogr" => "Teljes útvonal az ogr2ogr-hoz",
"Map Zone" => "Térkép zóna",
"Generate User Map" => "Felhasználói térkép generálása",
"Users can opt-out internal messages" => "Belső üzenetek kizárásának lehetősége",
"Users accept internal messages by default" => "Alapértelmezés szerint a felhasználók fogadhatnak üzeneteket",
"Maximum mailbox size (messages, 0=unlimited)" => "Levelezőfiók maximális mérete (üzenetek, 0=nincs határ)",
"Maximum mail archive size (messages, 0=unlimited)" => "Levél arhívum maximális mérete (üzenetek, 0=nincs határ)",
"Maximum sent box size (messages, 0=unlimited)" => "Elküldött levelek mappa maximális mérete (üzenetek, 0=nincs határ)",
"Change Preferences" => "Preferenciák megváltoztatása",
"Meta tags" => "Meta címkék",
"Keywords" => "Kulcsszavak",
"Include freetags" => "Freetag-ek belefoglalása",
"Use thread title instead" => "Thread használata inkább",
"Use image title instead" => "Kép címének használat inkább",
"Robots" => "Robotok",
"Meta robots" => "Meta robotok",
"Revisit after" => "Újralátogatás ennyi után",
"&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modulok&quot; a bal &amp; jobb oldali oszlopokban látható, különböző tartalmat megjelenítő dobozok",
"Admin &gt; Modules" => "Adminisztráció &gt; Modulok",
"from the menu to create and edit modules" => "menüt modulok létrehozására és szerkesztésére",
"Show module controls" => "Modul vezérlők megjelenítése",
"Users can configure modules" => "Felhasználók konfigurálhatják a modulokat",
"Users can shade modules" => "Felhasználók elrejthetik a modulokat",
"Module decides" => "Modultól függ",
"Display modules to all groups always" => "Minden modult mindig mutasson minden csoportnak",
"Hide anonymous-only modules from registered users" => "A csak anonim látogatók számára megjelenítésre kerülő modulok elrejtése a regisztrált felhasználók elől",
"It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "Ez a funkció fájlgalériáknál, wiki oldalaknál (plugin segítségével) és multimédiás űrlaptételeknél működik",
"ProgressBarPlay Color" => "Folyamatcsík lejátszás színe",
"ProgressBarLoad Color" => "Folyamatcsík töltés színe",
"ProgressBarButton Color" => "Folyamatcsík gomb színe",
"ProgressBar Color" => "Folyamatcsík színe",
"Volume On Color" => "Hangerő bekapcsolás színe",
"Volume Off Color" => "Hangerő kikapcsolás színe",
"Volume Button Color" => "Hangerő gomb színe",
"Button Color" => "Gomb szín",
"Button Pressed Color" => "Lenyomott gomb színe",
"Button Over Color" => "Gomb színe egér felémozgatásakor",
"Button Info Color" => "Gombinformáció szín",
"Button Info Pressed Color" => "Lenyomott gombinformáció színe",
"Button Info Over Color" => "Gombinformáció színe egér felémozgatásakor",
"Button Info Text Color" => "Gombinformáció szöveg szín",
"ID3 Tag Color" => "ID3 címke szín",
"Play Time Color" => "Lejátszási idő színe",
"Total Time Color" => "Teljes idő színe",
"Panel Display Color" => "Panel kijelzés színe",
"Alert Message Color" => "Figyelmeztetőüzenet színe",
"Flash Length" => "Flash hossza",
"Flash Heigth" => "Flash magassága",
"Video Length" => "Video hossza",
"Video Heigth" => "Video magassága",
"Preload Delay" => "Előtöltés késleltetése",
"Max Play time" => "Max lejátszási idő",
"URL Append" => "Hozzáfűzött URL",
"Message after limited time" => "Üzenet meghatározott idő után",
"ID of System File Galleries to upload multimedia files" => "A fájlgaléria azonosítója ahova a multimédiás fájlok feltöltésre kerülnek",
"To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "Szavazások hozzáadásához/eltávolításához lásd a \"Szavazások\" menüpontot az \"Adminisztráció\" menü alatt az alkalmazás menüjében, vagy",
"Anonymous voting" => "Anonim szavazás",
"Allow re-voting" => "Újboli szavazás megengedése",
"Show categories" => "Kategóriák megjelenítése",
"Categories disabled" => "Kategóriák ki vannak kapcsolva",
"Show objects" => "Objektumok megjelenítése",
"TikiWiki Profiles" => "TikiWiki profilok",
"Profile repository" => "Profil gyűjtemény",
"Last update" => "Legutóbbi frissítés",
"Filter the list of profiles" => "Profilok listájának szűrése",
"Profile" => "Profil",
"Repository" => "Gyűjtemény",
"installed" => "installálva",
"Repositories" => "Gyűjtemények",
"Repository URLs" => "Gyűjtemény URLek",
"Enter multiple repository URLs, one per line" => "Több gyűjtemény URL megadása, soronként egy",
"Data Channels" => "Adat csatornák",
"Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Adatcsatornák nevesített csatornát hoznak létre profilok futtatásához a felhasználói felületről. Egy csatornát adjunk meg soronként. Minden sor vesszővel elválasztott és tartalmazza a következőket: <strong>csatorna neve, domain, profil, engedélyezett csoportok</strong>. ",
"More information" => "További információ",
"Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or" => "Ezen az oldalon lehet konfigurálni a Tiki által generált RSS feedeket. RSS feedek szindikálásához más weblapokról használjuk az <strong>Adminisztráció</strong> &gt; <strong>RSS Modulok</strong> menüpontok, vagy",
"Feature is disabled." => "A funkció ki van kapcsolva",
"Maximum number of items to display" => "Megjelenítendő tételek maximális száma",
"Show Author" => "Szerző megjelenítése",
"Individual blogs" => "Egyedi blogok",
"Image galleries" => "Képgalériák",
"Individual image galleries" => "Egyedi képgalériák",
"Individual file galleries" => "Egyedi fájlgalériák",
"Individual forums" => "Egyedi fórumok",
"Individual trackers items" => "Egyedi űrlap példányok",
"Calendar events" => "Naptári események",
"Map files" => "Térképfájlok",
"Defaults" => "Alapértelmezések",
"Default RDF version" => "Alapértelmezett RDF verzió",
"Specification" => "Specifikáció",
"Documentation" => "Dokumentáció",
"Editor" => "Szerkesztő",
"Webmaster" => "Webmester",
"Image Path" => "Kép útvonala",
"Caching time:" => "Cache-elési idő:",
"Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public." => "Cache-elés engedélyezése felülírja a meglévő jogosultságokat - az összes tartalom publikus lesz.  <strong>Csak</strong> akkor aktiváljuk ezt az opciót ha szeretnénk hogy a szindikált tartalom publikus legyen.",
"You can see users rank by score in the module users_rank, for that go to" => "A felhasználók pontszámon alapuló rangsorát a users_rank modulban lehet megtekinteni itt",
"Expiration" => "Lejárat",
"Search stats" => "Keresési statisztika",
"can be seen on page" => "megtekinthető a",
"in Admin menu" => "menüpont alatt az Adminisztráció menüben",
"Search Results" => "Keresési eredmények",
"Search type" => "Keresés típusa",
"Database search" => "Adatbázis keresés",
"This search uses the MySQL Full-Text feature" => "Ez a keresési módszer a MySQL Full-Text funkciót használja",
"Tiki search" => "Tiki keresés",
"This database-independent search is always enabled" => "Ez az adatbázis független keresés mindig be van kapcsolva",
"Specify the Tiki search settings" => "Tiki keresés beállításainak megadása",
"Refresh mode" => "Frissítés módja",
"random" => "véletlenszerű",
"Refresh rate" => "Frissítési idő",
"Use <strong>0</strong> for no refresh" => "<strong>0</strong> ha nincs frissítés",
"Minimum length of search word" => "Keresett szó minimális hossza",
"Max. number of words containing a syllable" => "Egy szótagot tartalmazó szavak maximális száma",
"Max. age in hours of syllable search cache" => "Szótagkeresés cache maximális kora órákban",
"LRU list purging rate" => "LRU lista tisztításának gyakorisága",
"LRU list length" => "LRU lista hossza",
"When the Database search is enabled, you must manually refresh the Tiki search indexes" => "Ha az Adatbázis keresés be van kapcsolva akkor a Tiki indexeket manuálisan kell frissíteni",
"Refresh all search index now" => "Összes keresési index frissítése most",
"Refresh wiki search index now" => "Wiki keresési index frissítése most",
"Refresh trackers search index now" => "Űrlap keresési index frissítése most",
"Refresh tracker search index now" => "Űrlap keresési index frissítése most",
"Refresh files search index now" => "Fájl keresési index frissítése most",
"Referer Search Highlighting" => "Hivatkozott keresés kiemelése",
"Parse the results" => "Eredmények elemzése",
"May impact performance" => "Hatással lehet a teljesítményre",
"Enabling these options will improve performance, but may show forbidden results" => "Ezen opciók bekapcsolása javítja a teljesítményt de mutathat tiltott (jogosultságot figylembe nem vevő) eredményeket is",
"Ignore individual object permissions" => "Egyedi objektumjogosultságok ignorálása",
"Select the items to display on the search results page" => "Találatokat soroló oldalakon megjelenítendő tételek kiválasztása",
"Object filter" => "Objektum szűrő",
"Search box" => "Keresődoboz",
"Select the information to display for each result" => "Minden egyes találatnál megjelenítendő információk kiválasztása",
"hits" => "találat",
"Pertinence" => "Helyesség (relevancia)",
"Last modified date" => "Utolsó módosítás dátuma",
"Known Types" => "Ismert típusok",
"Show Usage" => "Használat megjelenítése",
"Delete &amp; Unreference" => "Törlés &amp; Hivatkozás visszavonása",
"Invert Relation" => "Kapcsolat megfordítása",
"New Types" => "Új típusok",
"Fix" => "Javítás",
"Text area (that apply throughout many features)" => "Szöveges terület beállításait több funkció is használja",
"Plugins" => "Plugin-ok",
"Plugin Aliases" => "Plugin álnevek",
"Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonim szerkesztőknek anti-bot kódot (CAPTCHA) kell megadniuk",
"Protect email against spam" => "E-mail védése spam ellen",
"External link icon" => "Külső link ikon",
"External links will be identified with" => "Külső linkek azonosítója",
"Open external links in new window" => "Külső linkek megnyitása új ablakban",
"Use File Galleries to store pictures " => "Fájlgalériák használata képek tárolására",
"Dynamic Content System" => "Dinamikus tartalomkezelő rendszer",
"Allow to post comments as Anonymous" => "Anonim komment feladás engedélyezése",
"Wiki paragraph formatting" => "Wiki bekezdés formázás",
"...but still create line breaks within paragraphs" => "...de mégis hozzon létre sortöréseket bekezdéseken belül",
"Automonospaced text" => "Automonospaced szöveg",
"Tables syntax" => "Táblázat szintaxis",
"&lt;return&gt; for rows" => "&lt;enter&gt; új sorhoz",
"AutoLinks" => "Automatikus linkek (AutoLink-ek)",
"Show quicktags above textareas" => "Quicktagek megjelenítése szöveges területek felett",
"If disabled, quicktags will be shown to the left of textareas" => "Ha ki van kapcsolva akkor a quicktagek a szöveges területek bal oldalán jelennek meg",
"Open Hotwords in new window" => "Hotword megnyitása új ablakban",
"Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Idézet (Quote) plugin használata &ldquo;&gt;&rdquo; helyett idézetekhez",
"Plugin disabled" => "Plugin kikapcsolva",
"Default size" => "Alapértelmezett nézet",
"rows" => "sorok",
"Comments " => "Kommentek",
"Forum reply" => "Fórum válasz",
"Enable" => "Bekapcsolás",
"Available Alias" => "Rendelkezésre álló alias",
"Enable Plugins" => "Pluginok bekapcsolása",
"General Information" => "Általános információ",
"Plugin Name" => "Plugin neve",
"Base Plugin" => "Alap plugin",
"Body Label" => "Törzs címke",
"Dependencies" => "Függőségek",
"Validation" => "Validálás",
"Inline (No Plugin Edit UI)" => "Szövegben (nincs plugin szerkesztési felület)",
"Simple Plugin Arguments" => "Egyszerű plugin argumentumok",
"Plugin Parameter Documentation" => "Plugin paraméter dokumentáció",
"Required" => "Szükséges",
"Safe" => "Biztonságos",
"Plugin Body" => "Plugin törzs",
"Ignore User Input" => "Felhasználói bevitel ignorálása",
"Default Content" => "Alapértelmezett tartalom",
"Parameters" => "Paraméterek",
"Encoding" => "Kódolás",
"Default Value" => "Alapértelmezett érték",
"Composed Plugin Arguments" => "Szerkesztett plugin argumentumok",
"Pattern" => "Minta",
"To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "Űrlapok beállításához lásd az \"Űrlapok adminisztrálása\" menüpontot az \"Űrlapok\" menü alatt az alkalmazás fő menüjében, vagy",
"Tracker attachment preferences" => "Űrlap mellékletek beállítása",
"Trackers with mirror tables" => "Űrlapok tükörtáblákkal",
"Use trackers with mirror tables" => "Űrlapok használata tükörtáblákkal",
"Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Az értékek külön tárolódnak az egyes űrlapok számára dedikált táblákban, így könnyű változtatni őket Tikiwikin kívűl is",
"WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "FIGYELEM: Régi és új űrlapok nem létehetnek együtt. Új könyvtárban készített űrlapok nem fognak működni a régi könyvtárral és fordítva",
"Validate choice" => "Választás érvényesítése",
"Tracker attachments" => "Űrlap mellékletek",
"dls" => "Letöltések",
"Storage" => "Tárolás",
"Change" => "Változás",
"No records" => "Nincsenek rekordok",
"Change all to db" => "Összes átváltása adatbázisba",
"Change all to file" => "Összes átváltása fájlba",
"Quota (Mb)" => "Limit (Mb)",
"Use database to store userfiles" => "Adatbázis használata a felhasználói fájlok tárolásához",
"Use a directory to store userfiles" => "Könyvtár használata a felhasználói fájlok tárolásához",
"Allow viewing HTML mails?" => "HTML levelek megtekintésének engedélyezése?",
"Maximum size for each attachment" => "Csatolt állomány maximum mérete",
"Unlimited" => "Nincs korlát",
"Create New" => "új létrehozása",
"Lookup" => "Keresés",
"Register Service" => "Szolgáltatás regisztrálása",
"Registered Templates" => "Regisztrált sablonok",
"Output" => "Kimenet",
"Register Template" => "Sablon regisztrálása",
"Staging &amp; Approval" => "Előkészítés &amp; Jóváhagyás",
"Page Listings" => "Oldalak listázása",
"Home page" => "Kezdőlap",
"If the page does not exist, it will be created" => "Ha az oldal még nem létezik akkor létre lesz hozva",
"Wiki link format" => "Wiki link formátum",
"Complete" => "Teljes",
"Select the characters that can be used with Wiki link syntax: ((page name))" => "Válasszuk ki a karaktereket melyek a Wiki link szintakszisban használhatóak: ((page name))",
"Page display" => "Oldal megjelenítés",
"Page ID" => "Oldal ID (azonosító)",
"Page version" => "Oldal verzió",
"Page name display stripper" => "Oldalnév stripper",
"Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>" => "Adjunk meg egy karaktert ami elválasztóként szolgál oldalnevek megjeleníŧésekor. Az elválasztó után szereplő összes karakter leválasztásra kerül az oldalnév megjelenítésekor.</em>",
"Allow override per page" => "Oldalanként változtatható",
"Display show/hide icon displayed before headings" => "Megjelenítés/elrejtés ikon megjelenítése címsorok előtt",
"Wiki action bar" => "Wiki akció sor",
"Page navigation bar location" => "Oldal navigációs sor helye",
"When using the ...page... page break wiki syntax" => "A '...page...' oldaltörési wiki szintakszis használata esetén",
"Wiki top line" => "Wiki felső sor",
"Neither" => "Egyik sem",
"Wiki buttons" => "Wiki gombok",
"Cache wiki pages (global):" => "Wiki oldalak cache-lése (globális):",
"Individual cache" => "Egyedi cache",
"Content templates" => "Tartalom sablonok",
"Warn on edit conflict" => "Figyelmeztessen szerkesztési konfliktusnál",
"Edit idle timeout:" => "Nem tevékeny szerkesztés időkorlátja:",
"Undo" => "Visszaállítás (undo)",
"Save draft" => "Piszkozat mentése",
"Requires AJAX" => "AJAX-ot igényel",
"experimental" => "kísérleti",
"Footnotes" => "Lábjegyzetek",
"Permission" => "Jogosultság",
"Allow HTML" => "HTML engedélyezése",
"Edit section" => "Szekció szerkesztése",
"Allow minor edits" => "Kisebb szerkesztések engedélyezése",
"Force and limit categorization to within subtree of:" => "Kategorizálás erőltetése és korlátozása ezen alkategóriákra:",
"Regex search and replace" => "Regex keresés és kicserélés",
"Log bytes changes (+/-) in action logs" => "Bájt változások (+/-) az akció logban",
"Sandbox" => "Homokozó",
"Display by default" => "Alapértelmezésben megjelenítve",
"Path:" => "Útvonal:",
"Manage attachments" => "Mellékletek kezelése",
"Dumps" => "Dump-ok",
"Tag for current wiki" => "Címke a jelenlegi wikihez",
"Restore wiki to tag" => "Wiki címke visszaállítása",
"Restore" => "Visszaállítás",
"Remove a tag" => "Címke eltávolítása",
"Generate dump" => "Dump generálása",
"Download last dump" => "Legutóbbi dump letöltése",
"Pictures" => "Képek",
"Remove unused pictures" => "Nem használt képek eltávolítása",
"Export" => "Exportálás",
"Export Wiki Pages" => "Wiki oldalak exportálása",
"Accept dashes and underscores in WikiWords" => "Kötőjelek és aláhúzások elfogadás WikiWordben",
"Link plural WikiWords to their singular forms" => "Többesszámú WikiWord hozzákötése az egyes számú formához (angolul)",
"Never delete versions younger than" => "Ennél fiatalabb verziók nem törölhetőek",
"Display IP address" => "IP cím megjelenítése",
"Default diff style" => "Eltérés alapértelmezett stílusa",
"HTML diff" => "HTML formátumú eltérés",
"Side-by-side diff by characters" => "Karakterenkénti eltérés egymás mellett",
"Inline diff" => "Tartalmon belüli eltérés",
"Inline diff by characters" => "Tartalmon belüli eltérés karakterenként",
"History includes only page data, description, and change comment" => "Előzmények csak oldaladatokat, leírást és változási kommentet tartalmaz",
"Discuss pages on forums" => "Oldalak megbeszélése fórumokban",
"Forums are disabled." => "Fórum funkció ki van kapcsolva",
"Forum for discussion:" => "Megbeszélésre használt fórum:",
"View source" => "Forrás megtekintése",
"Similar" => "Hasonló",
"like pages" => "hasonló oldalak",
"Structures" => "Struktúrák",
"Open page as structure" => "Oldal megnyitása struktúraként",
"Make structure from page" => "Struktúra készítése oldalból",
"Categorize structure pages together" => "Struktúra oldalainak közös kategóriába helyezése",
"Create webhelp from structure:" => "Websúgó létrehozása struktúrából:",
"Import HTML" => "HTML importálása",
"Import pages" => "Oldalak importálása",
"Slideshows" => "Bemutatók",
"User's page" => "Felhasználói oldal",
"UserPage prefix:" => "Felhasználói oldal előtagja:",
"Users can lock pages" => "Felhasználók zárolhatják az oldalakat",
"Page creators are admin of their pages" => "A lap készítője saját lapjának adminisztrátora",
"MultiPrint" => "Tömeges nyomtatás",
"Wiki watch" => "Wiki figyelés",
"Create watch for author on page creation" => "Figyelés bekapcsolása az oldal létrehozójának az oldal létrehozásakor",
"Enable watch events when I am the editor" => "Figyelés bekapcsolása a szerkesztőnek",
"Enable watches on comments" => "Kommentek figyelése",
"Watch minor edits" => "Kisebb szerkesztések figyelése",
"If not in the group, edit is always redirected to the staging page edit:" => "Ha nincs a csoportban akkor a szerkesztés mindig átirányításra kerül a jóváhagyási oldalváltozat szerkesztésre:",
"Unique page name prefix to indicate staging copy:" => "Egyedi oldalnév előtag használata a jóváhagyás alatt lévő oldalmásolatok megkülönböztetésére:",
"Approved" => "Jóváhagyva",
"Out-of-sync" => "Nincs szinkronban",
"List pages" => "Oldalak listázása",
"Orphan page" => "Árva oldal",
"Configuration" => "Konfiguráció",
"Select which items to display when listing pages" => "Oldalak listázásakor megjelenítendő tételek kiválasztása",
"Default sort order:" => "Alapértelmezett rendezési sorrend:",
"Name length:" => "Név hossza:",
"Edit comments" => "Kommentek szerkesztése",
"Description length:" => "Leírás hossza:",
"Categories path" => "Kategória útvonala",
"Wiki attachments" => "Wiki mellékletek",
"Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "A Wysiwyg (What You See Is What You Get rövidítve) szerkesztő lehetővé teszi a könnyed szövegszerkesztést és szövegformázást. Tikiwiki a <a href=\"http://fckeditor.net\">FCKeditor</a> megoldást használja",
"Wysiwyg Editor Features" => "Wysiwyg szerkesztő funkciói",
"Wysiwyg Editor is optional" => "Wysiwyg szerkesztő opcionális",
"... and is displayed by default" => "... és alapértelmezésben megjelenítve",
"Reopen with the same editor" => "Újranyitás ugyanazzal a szerkesztővel",
"Content is parsed like wiki page" => "Tartalom wiki oldalként elemzett",
"Content is partially parsed" => "Tartalom részlegesen elemzett",
"Toolbar skin" => "Eszköztár felület",
"Toolbar content" => "Eszköztár tartalom",
"Restore defaults" => "Alapértékek visszaállítása",
"Database Version Problem" => "Adatbázis verzió probléma",
"disabled" => "kikapcsolva",
"enabled" => "bekapcsolva",
"information" => "információ",
"preference" => "preferencia",
"Crosslinks to other features and settings" => "Linkek más funkciókhoz és beállításokhoz",
"Other sections" => "Egyéb szekciók",
"Contact us" => "Kapcsolatfelvétel",
"Administration features" => "Adminisztratív funkciók",
"Security" => "Biztonság",
"Edit Languages" => "Nyelvek szerkesztése",
"Transversal features" => "Átfogó funkciók",
"which apply to more than one section" => "több mint egy szekcióra vonatkoznak",
"Navigation features" => "Navigációs funkciók",
"Look &amp; feel" => "Kinézet &amp; stílus",
"themes" => "stílusok",
"Text area features" => "Szövegmezővel kapcsolatos funkciók",
"features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "ezeket a funkciókat lehet használni az összes szöveges területen, mint például wiki oldalak, blogok, cikkek, fórumok, stb",
"Stats &amp; banners" => "Statisztikák &amp; bannerek",
"Report" => "Riport",
"Setting" => "Beállítások",
"Please select some actions to view." => "Válasszuk ki a megjelenítendő akciókat",
"bytes" => "bájt",
"Graph Contributions" => "Hozzájárulások grafikon",
"contribution" => "hozzájárulás",
"contributor" => "hozzájáruló",
"Edit Action" => "Akció szerkesztése",
"Save Action" => "Akció mentése",
"Statistics" => "Statisztikák",
"Volumes are equally distributed on each contributors/author" => "A mennyiségek egyenletesen kerülnek elosztásra minden egyes szerzőre/hozzájárulóra",
"Number of actions per user" => "Akciók száma felhasználónként",
"Total number of users" => "Felhasználók teljes száma",
"Number of actions per object" => "Akciók száma objektumonként",
"Total number of objects" => "Objektumok teljes száma",
"Volumn per contribution and time" => "Mennyiség hozzájárulás és idő alapján",
"Weeks" => "Hét",
"recorded" => "rögzítve",
"viewed" => "megtekintve",
"Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki oldal akciók - a megtekintés kivételével - mindig rögzítésre kerülnek de nem riportálhatóak",
"Add or edit a rule" => "Szabály hozzáadása vagy szerkesztése",
"Rule title" => "Szabály neve",
"Username regex matching" => "Felhasználói név egyezik a kifejezéssel",
"IP regex matching" => "IP egyezik a kifejezéssel",
"Banned from sections" => "Az alábbi szekciókból van kitiltva",
"Rule activated by dates" => "A szabályt dátumok aktiválják",
"Rule active from" => "Érvényesség kezdete",
"Rule active until" => "Érvényesség vége",
"Custom message to the user" => "Egyedi üzenet a felhasználónak",
"Rules" => "Szabályok",
"x" => "törlés",
"User/IP" => "Felhasználó/IP",
"Sections" => "Szekciók",
"Admin Calendars" => "Naptárak beállítása",
"Create Calendar" => "Naptár létrehozása",
"View Calendars" => "Naptárak megtekintése",
"List of Calendars" => "Naptárak listáa",
"Edit Calendar" => "Naptár szerkesztése",
"Loc" => "Hely",
"Participants" => "Résztvevők",
"Cat" => "Kat",
"Lang" => "Nyelv",
"Prio" => "Prioritás",
"Subscription" => "Előfizetés",
"View Calendar" => "Naptár megtekintése",
"Add Event" => "Esemény hozzáadása",
"Create/Edit Calendars" => "Naptárak létrehozása/szerkesztése",
"Custom Locations" => "Egyedi hely",
"Custom Participants" => "Saját résztvevők",
"Custom Categories" => "Egyedi kategória",
"Custom Languages" => "Egyedi nyelv",
"Custom URL" => "Saját URL",
"Custom Subscription List" => "Saját előfizetési lista",
"Custom Priorities" => "Egyedi prioritás",
"Personal Calendar" => "Személyes naptár",
"Start of day" => "Nap kezdete",
"h" => "ó",
"End of day" => "Nap vége",
"Standard Colors" => "Alap színek",
"Green" => "Zöld",
"Blue" => "Kék",
"Purple" => "Lila",
"Red" => "Piros",
"Orange" => "Narancs",
"Yellow" => "Sárga",
"Let me select my own colors" => "Saját szín",
"Custom foreground color" => "Saját szín",
"Custom background color" => "Saját háttérszín",
"Default event status" => "Esemény alapértelmezett státusza",
"Show in calendar view" => "Megjelenítése naptár nézetben",
"Group of users alerted when calendar event is modified" => "Naptári esemény módosításakor értesítendő felhasználói csoport",
"Delete events older than:" => "Ennél öregebb események törlése:",
"Browse the category system" => "Kategóriarendszer böngészése",
"Current category" => "Jelenlegi kategória",
"Current Category ID:" => "Jelenlegi kategória azonosítója:",
"Child categories" => "kategória fa levelei",
"Edit permissions for this category" => "Kategóriához tartozó jogosultságok szerkesztése",
"Edit this category:" => "Ezen kategória szerkesztése",
"Add new category" => "Új kategória hozzáadása",
"Assign permissions automatically" => "A rendszer automatikusan osszon jogosultságokat",
"recommended for best performance" => "ajánlott a legjobb teljesítményhez",
"Batch upload (CSV file):" => "Tömeges feltöltés (CSV fájlból)",
"Objects in category" => "Objektumok ebben a kategóriában:",
"Remove from this Category" => "Eltávolítás ebből a kategóriából",
"No records found." => "Nincs rekord",
"Add objects to category" => "Elemek hozzáadása a kategóriához",
"image gal" => "képgaléria",
"file gal" => "fájlgaléria",
"Admin chart items" => "Slágerlista elemeinek adminisztrálása",
"Edit Chart" => "Slágerlista szerkesztése",
"Add or edit an item" => "Elem hozzáadása/szerkesztése",
"Update" => "Frissítés",
"Chart items" => "Slágerlista elemek",
"No items defined yet" => "Nincsenek elemek definiálva",
"Admin charts" => "Slágertémák adminisztrálása",
"Add or edit a chart" => "Sláger téma hozzáadása/szerkesztése",
"Active" => "Aktív",
"Users can vote for only one item from this chart per period" => "Időszakonként a felhasználók csak egy elemre szavazhatnak",
"Prevent users from voting for the same item more than once" => "Alkalmanként a felhasználók ugyanarra az elemre csak egyszer adhatják le szavazatukat",
"Users can suggest new items" => "A felhasználók javasolhatnak új slágereket",
"Auto validate user suggestions" => "Automatikusan jóváhagyja a felhasználói javaslatokat",
"Ranking shows" => "Rang mutatása",
"All items" => "Minden elem",
"Top 10 items" => "Top 10 elem",
"Top 20 items" => "Top 20 elem",
"Top 40 items" => "Top 40 elem",
"Top 50 items" => "Top 50 elem",
"Top 100 items" => "Top 100 elem",
"Top 250 items" => "Top 250 elem",
"Voting system" => "Szavazási rendszer",
"Vote items" => "Elemre szavazás",
"Rank 1..5" => "Rang 1..5",
"Rank 1..10" => "Rang 1..10",
"Ranking frequency" => "Időszak",
"Realtime" => "Valós idő",
"Each 5 minutes" => "Minden 5 percben",
"Daily" => "Napi",
"Weekly" => "Heti",
"Monthly" => "Havi",
"Show Average" => "Átlag mutatása",
"Show Votes" => "Szavazatok mutatása",
"Use Cookies for unregistered users" => "Cookie használata a nem regisztrált felhasználóknál",
"Users can vote again after" => "Ennyi idő múlva lehet megint szavazni:",
"Anytime" => "Bármikor",
"Ranks" => "Rangok",
"No charts defined yet" => "Nincsenek még sláger témák",
"Admin templates" => "Sablonok adminisztrálása",
"Edit this template:" => "Ezen sablon szerkesztése:",
"Create new template" => "Új sablon létrehozása",
"Use wysiwyg editor" => "Wysiwyg szerkesztő használata",
"Use normal editor" => "Normál szerkesztő használata",
"Use in" => "Használat itt",
"CMS" => "Hírek",
"No features are configured to use templates." => "Egy funkcióhoz sincs beállítva a sablonok használata",
"Templates" => "Sablonok",
"Admin Contributions" => "Hozzájárulások adminisztrálása",
"Edit the contribution:" => "Hozzájárulás szerkesztése:",
"Settings" => "Beállítások",
"Contributions are mandatory in wiki pages" => "Hozzájárulások kötelezőek wiki oldalakon",
"Contributions are mandatory in forums" => "Hozzájárulások kötelezőek fórumokban",
"Contributions are mandatory in comments" => "Hozzájárulások kötelezőek kommentekben",
"Contributions are mandatory in blogs" => "Hozzájárulások kötelezőek blogokban",
"Contributions are displayed in the comment/post" => "Hozzájárulások megjelenítésre kerülnek a kommentben/posztban",
"Create a new contribution" => "Új hozzájárulás létrehozása",
"List of contributions" => "Hozzájárulások listája",
"Admin cookies" => "Cookiek adminisztrálása",
"Create/edit cookies" => "Cookie létrehozása/szerkesztése",
"Upload Cookies from textfile" => "Cookie feltöltése szöveges fájlból",
"Upload from disk:" => "Feltöltés lemezről",
"Upload" => "Feltöltés",
"Remove all cookies" => "Minden cookie eltávolítása",
"Admin drawings" => "Rajzok adminisztrálása",
"Available drawings" => "Rendelkezésre álló rajzok",
"Ver" => "Verzió",
"Use Admin DSN to define the database to be used by the SQL plugin." => "DSN (Data Source Name - Adatforrás neve) adatbáziskapcsolatok megadásával lehet megadni az SQL plugin által használt adatbázisokat",
"Create/edit dsn" => "DSN létrehozása/szerkesztése",
"Admin external wikis" => "Külső wiki-k adminisztrálása",
"View template" => "Sablon megtekintése",
"Edit template" => "Sablon szerkesztése",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (használjon \$lap kifejezést a lap nevével, mint az alábbi példában: http://www.example.com/tiki-index.php?page=\$page)",
"Admin Forums" => "Fórumok adminisztrálása",
"Create new forum" => "Új fórum létrehozása",
"Duplicate forum" => "Fórum duplikálása",
"View this forum" => "Fórum megtekintése",
"Import forums" => "Fórumok importálása",
"List forums" => "Fórumok listázása",
"Edit this Forum:" => "Ezen fórum szerkesztése:",
"Create New Forum" => "Új fórum létrehozása",
"There are individual permissions set for this forum" => "Egyéni jogosultságok vannak ehhez a fórumhoz",
"Prevent flooding" => "Flood megakadályozása",
"Minimum time between posts" => "Hozzászólások közti minimum idő",
"Section" => "Szekció",
"Create new" => "Új készítése",
"Moderator user" => "Moderátor felhasználó",
"Moderator group" => "Moderátor csoport",
"Password protected" => "Jelszóval védett",
"Topics only" => "Csak témák",
"All posts" => "Minden üzenet",
"Forum password" => "Fórum jelszó",
"Only allow replies to the first message (flat forum)" => "Csak az első üzenetre küldhető válasz (lapos fórum)",
"Send this forums posts to this email" => "Fórum hozzászólásainak elküldése az alábbi E-mail címre",
"Prune unreplied messages after" => "Válasz nélküli üzenetek eltávolítása ennyi idő után",
"Prune old messages after" => "Régi üzenetek eltávolítása ennyi idő után",
"Topic list configuration" => "Témalista beállítása",
"Posts can be rated" => "A hozzászólások pontozhatóak",
"Display last post titles" => "Utolsó hozzászólások címeinek megjelenítése",
"no display" => "nincs megjelenítés",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Üzenetek továbbítása erre e fórumra erre az E-mail címre olyan formátumban mely felhasználható visszaküldésre a beérkező fórum E-mail címre",
"Send mails even when the post is generated by inbound mail" => "Levelek küldése ha a hozzászólást beérkező levél generálta",
"Append a reply link to outbound mails" => "Válaszlink hozzáadása a kimenő levelekhez",
"Originating e-mail address for mails from this forum" => "Ezen fórum leveleihez tartozó forrás E-mail cím",
"Add messages from this email to the forum" => "Alábbi E-mail üzeneteket hozzáadása a fórumhoz",
"POP3 server" => "POP3 szerver",
"Use topic smileys" => "Mosolyok használata a témákban is legyen engedélyezett",
"Show topic summary" => "Témaösszesítő",
"User information display" => "Felhasználói információs képernyő",
"Approval type" => "Jóváhagyás típusa",
"All posted" => "Minden elküldött",
"Queue anonymous posts" => "Névtelen hozzászólások sorbaállítása",
"Queue all posts" => "Összes hozzászólás sorbaállítása",
"No attachments" => "Nincsenek mellékletek",
"Everybody can attach" => "Bárki csatolhat",
"Only users with attach permission" => "Csak csatolási jogosultsággal rendelkezők csatolhatnak",
"Moderators and admin can attach" => "Moderátorok és adminisztrátorok csatolhatnak",
"Store attachments in:" => "Mellékletek tárolása itt:",
"Database" => "Adatbázis",
"Max attachment size (bytes)" => "Melléklet maximális mérete (bájt)",
"Set topics preferences" => "Témapreferenciák beállítása",
"Show topics preferences" => "Témapreferenciák megjelenítése",
"hide topics preferences" => "Témapreferenciák elrejtése",
"Default ordering for topics" => "Témák rendezésének alapbeállítása",
"Date (desc)" => "Dátum (csökk)",
"Date (asc)" => "Dátum (növ)",
"Score (desc)" => "Pontszám (csökk)",
"Replies (desc)" => "Válaszok (csökk)",
"Reads (desc)" => "Olvasottság (csökk)",
"Topics per page" => "Témák száma laponként",
"Default ordering for threads" => "A szálak alap rendezési beállítása",
"Duplicate Forum" => "Fórum duplikálása",
"Duplicate" => "Duplikálás",
"List Forums" => "Fórumok listája",
"Coms" => "Kommentek",
"Age" => "Életkor",
"Admin Hotwords" => "Hotword adminisztráció",
"Add Hotword" => "Hotword hozzáadása",
"Word" => "Szó",
"Admin HTML Page Dynamic Zones" => "HTML oldalak dinamikus zónáinak adminisztrálása",
"Admin HTML pages" => "HTML oldalak adminisztrálása",
"Edit this page" => "Ezen oldal szerkesztése",
"View page" => "Oldal megtekintése",
"Edit zone" => "Zóna szerkesztése",
"Dynamic zones" => "Dinamikus zónák",
"zone" => "zóna",
"content" => "tartalom",
"Mass update" => "Tömeges frissítés",
"Create new HTML page" => "Új HTML oldal létrehozása",
"Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Használjuk a {literal}{ed id=name}{/literal} vagy {literal}{ted id=name}{/literal} formulát dinamikus zónák beszúrásához",
"Edit this HTML page:" => "Ezen HTML oldal szerkesztése:",
"Apply template" => "Sablon alkalmazása",
"Dynamic" => "Dinamikus",
"Static" => "Statikus",
"Refresh rate (if dynamic)" => "Frissítési ráta (ha dinamikus)",
"Last Modif" => "Utolsó módosítás",
"Admin dynamic zones" => "Dinamikus zónák adminisztrálása",
"Start page" => "Kezdő oldal",
"CSS file" => "CSS fájl",
"Clear cache" => "Cache ürítése",
"CSS File" => "CSS fájl",
"New Rule" => "Új szabály",
"Copy Rules" => "Szabályok másolása",
"Copy" => "Másolás",
"Configure/Options" => "Konfigurálás",
"Admin layout" => "Kinézet adminisztrálása",
"Theme control" => "Stílusvezérlés",
"layout options" => "kinézet beállítások",
"Generate positions by hits" => "A helyeket a találatok alapján alakítsa ki",
"List of featured links" => "Kiemelt linkek listáa",
"Position" => "Pozíció",
"Add Featured Link" => "Kiemelt link hozzáadása",
"Edit this Featured Link:" => "Ezen kiemelt link szerkesztése:",
"Create new Featured Link" => "Új kiemelt link készítése",
"disables the link" => "link letiltása",
"Link type" => "Link típusa",
"replace current page" => "A jelenlegi lap lecserélése",
"framed" => "frame-ben",
"open new window" => "új ablak nyitása",
"Mail-in accounts" => "Bejövő levelezési fiókok",
"Account" => "Fiók",
"Add new Mail-in account" => "Bejövő levelezési fiók hozzáadása",
"Edit Mail-in account" => "Bejövő levelezési fiók szerkesztése",
"Account name" => "Postaláda neve",
"POP server" => "POP szerver",
"SMTP server" => "SMTP szerver",
"SMTP requires authentication" => "SMTP felhasználóazonosítást igényel",
"article-put" => "cikk-put",
"wiki-get" => "wiki-leszed",
"wiki-put" => "wiki-felrak",
"wiki-append" => "wiki-hozzáfűz",
"Article Topic" => "Cikk téma",
"Admin Topics" => "Témák beállításai",
"Article Type" => "Cikk típus",
"Admin Types" => "Típusok adminisztrálása",
"Allow anonymous acces" => "Anonymus hozzáférés engedélyezése",
"Allow attachments" => "Mellékletek engedélyezése",
"Check Mail-in accounts" => "Bejövő levelezési fiókok ellenőrzése",
"Check automatically" => "Automatikus ellenőrzés",
"Frequency" => "Gyakoriság",
"List menus" => "Menük listázása",
"Edit this menu" => "Ezen szerkesztése",
"Edit menu options" => "Menü beállításainak szerkesztése",
"Show Quick Urls" => "Gyors URL-ek megjelenítése",
"Some useful URLs" => "Néhány hasznos URL",
"Hide Quick Urls" => "Gyors URL-ek elrejtése",
"Use Ctrl+Click to select multiple groups." => "Ctrl+kattintás alkalmazásával több csoport is kiválasztható",
"option" => "opció",
"section level 0" => "szekció szint 0",
"section level 1" => "szekció szint 1",
"section level 2" => "szekció szint 2",
"section level 3" => "szekció szint 3",
"separator" => "szeparátor",
"Choose" => "Kiválasztás",
"Home Blog" => "Kezdőblog",
"Home Image Gal" => "Fő képgaléria",
"Home Image Gallery" => "Fő képgaléria",
"Home File Gal" => "Fő fájlgaléria",
"Home File Gallery" => "Fő fájlgaléria",
"User preferences" => "Felhasználói beállítások",
"User prefs" => "Felhasználói beáll.",
"List galleries" => "Galériák listázása",
"List image galleries" => "Képgalériák listázása",
"Upload image" => "Kép feltöltése",
"Gallery Rankings" => "Galéria rangok",
"Browse a gallery" => "Galéria böngészése",
"Articles home" => "Cikkek főoldala",
"All articles" => "összes cikk",
"Submit" => "Elküld",
"List Blogs" => "Blogok listázása",
"Create blog" => "Blog létrehozása",
"File galleries" => "Fájlgalériák",
"View a forum" => "Fórum megtekintése",
"View a thread" => "Egy fórumtéma megtekintése",
"View a FAQ" => "Gyakori kérdések megtekintése",
"Take a quiz" => "Kvíz kitöltése",
"Quiz stats" => "Kvízek statisztikái",
"Stats for a Quiz" => "Statisztikák a kvízekhez",
"Preview menu" => "Menü előnézet",
"Menu options" => "Menü opciók",
"Export CSV data" => "CSV adat exportálása",
"Import CSV data" => "CSV adat importálása",
"To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu." => "Menük használatához egy <a href=\"tiki-admin_modules.php\">modulban</a>, <a href=\"tiki-admin.php?page=siteid\">weblap identitásban</a> vagy sablonban használjuk ezt a szintakszist: {literal}{menu id=x}{/literal}, ahol x a menü ID-ja",
"To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "<a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">Phplayersmenu</a> használatához az alábbi három szintakszis egyikét lehet használni:",
"This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "Ez a kiválasztott stílustól függően jól vagy kevésbé jól fog működni. Stílusokról bővebben <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">itt</a>",
"To use a menu in a tiki format:" => "Menü használata tiki formátumban:",
"To use menu in a css/suckerfish format:" => "Menü használata css/suckerfish formátumban: ",
"Edit this Menu:" => "Ezen menü szerkesztése:",
"Create new Menu" => "Új menü készítése",
"dynamic collapsed" => "dinamikus összezárt",
"dynamic extended" => "dinamikus nyitott",
"fixed" => "rögzített",
"Path and filename of closed folder icon" => "A bezárt mappa ikonjának útvonala és fájlneve",
"For example, the default icon is: pics/icons/folder.png" => "Például ha az alapértelmezett ikon: pics/icons/folder.png",
"The name of the \"open folder\" icon is: pics/icons/ofolder.png" => "Akkor a \"kinyitott mappa\" ikonja: pics/icons/ofolder.png",
"Options" => "Opciók",
"Clear Cache" => "Gyorsítótár törlése",
"Assign/Edit modules" => "Modulok hozzárendelése/szerkesztése",
"User Modules" => "Felhasználói modulok",
"Assigned Modules" => "Hozzárendelt modulok",
"Left Modules" => "Bal modulok",
"Rows" => "Sorok",
"Right Modules" => "Jobb modulok",
"Assign new module" => "Új modul hozzárendelése",
"Edit this assigned module:" => "Ezen hozzárendelt modult szerkesztése:",
"Cache Time" => "Gyorsítótár idő",
"Create new user module" => "Új felhasználói modul készítése",
"Edit this user module:" => "Ezen felhasználói modul szerkesztése:",
"Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site." => "Saját modult itt hozhatunk létre. Tekintsük meg előnézetben és bizonyosodjunk meg arról hogy nincs benne hiba mielőtt <a href=\"#assign\">hozzárendelnénk</a>. HTML-t használva elkerülhetőek a problémák, de wiki szintakszis vagy Smarty kód helytelen használata során akár még az oldalról is kizárhatjuk magunkat (ilyenkor 'hátulról', azaz az adatbázis közvetlen módosításán keresztül lehet csak visszajutni.) Szóval csak óvatosan.",
"Must be wiki parsed" => "Wiki által elemzettnek kell lennie",
"Objects that can be included" => "A felhasználható objektumok",
"Available polls" => "Rendelkezésre álló szavazások",
"Use Poll" => "Szavazás használata",
"Random image from" => "Véletlenszerű kép innen",
"Use Gallery" => "Galéria használata",
"Dynamic content blocks" => "Dinamikus tartalmú rész",
"Use Dynamic Content" => "Dinamikus tartalom használata",
"Use RSS Module" => "Rss modul használata",
"Use Menu" => "Menü használata",
"Banner zones" => "Banner zónák",
"Use Banner Zone" => "Banner zónák használata",
"Data" => "Adat",
"Admin newsletter subscriptions" => "Hírlevél előfizetések adminisztrálása",
"List Newsletters" => "Hírlevelek listázása",
"Admin Newsletters" => "Hírlevelek adminisztrálása",
"Send Newsletters" => "Hírlevelek kiküldése",
"Add a subscription newsletters" => "Hírlevél előfizetés hozzáadása",
"You can add several email addresses by separating them with commas." => "Több E-mail cím is megadható vesszővel elválasztva",
"Group users" => "Felhasználói csoport",
"Group subscription also subscribes included groups" => "Csoportos előfizetés a kiválasztott csoportokat is tartalmazza",
"Don't send confirmation mail" => "Ne küldjön megerősítési E-mailt",
"The user email will be refreshed at each newsletter sending" => "A felhasználói E-mail az egyes kiküldések alkalmával kerül frissítésre",
"Batch e-mail subscribe" => "Kötegelt E-mail feliratkozás",
"txt file, one e-mail per line" => "txt fájl, egy E-mail soronként",
"Export Subscriber Emails" => "Feliratkozók E-mail címének exportálása",
"Subscribe group" => "Csoport feliratkozása",
"Included group, group users and emails will be refreshed at each newsletter sending" => "A tartalmazott csoport, csoportban lévő felhasználók és E-mail címek az egyes kiküldések alkalmával kerülnek frissítésre",
"Add subscribers of another newsletter" => "Egy másik hírlevél előfizetőinek hozzáadása",
"Subscriptions" => "Előfizetések",
"Subscribed" => "Feliratkozva",
"Admin newsletters" => "Hírlevelek adminisztrálása",
"There are individual permissions set for this newsletter" => "Ennél a hírlevélnél egyéni jogosultságok vannak beállítva",
"Users can subscribe/unsubscribe to this list" => "A listára a felhasználók fel/leiratkozhatnak",
"Users can subscribe any email address" => "A felhasználók bármely E-mail címre feliratkozhatnak",
"Add unsubscribe instructions to each newsletter" => "Leiratkozási instrukciók hozzáadása minden egyes hírlevélhez",
"Validate email addresses" => "E-mail címek validálása",
"Allow customized text message to be sent with the html version" => "Testreszabott szöveges üzenet küldésének engedélyezése a HTML verzióval",
"Editions" => "Kiadások",
"Drafts" => "Piszkozatok",
"Last Sent" => "Utoljára elküldve",
"Mail notifications" => "E-mailes értesítések",
"You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications." => "Be kell állítani a <a href=\"tiki-admin.php?page=general\">Küldési E-mail címet</a> az E-mailes értesítések létrehozása előtt",
"Add notification" => "Értesítés hozzáadása",
"Alert" => "Riasztás",
"Event" => "Esemény",
"A user registers" => "Egy felhasználó regisztrál",
"A user submits an article" => "Felhasználó cikket küld",
"A user edits an article" => "Egy felhasználó cikket szerkeszt",
"A user deletes an article" => "Egy felhasználó cikket töröl",
"Any wiki page is changed" => "Bármely wiki oldal megváltozik",
"Any wiki page is changed, even minor changes" => "Bármely wiki oldal megváltozik, kisebb változások is",
"A comment in a wiki page is posted or edited" => "Wiki oldal komment létrehozásakor vagy szerkesztésekor",
"PHP error" => "PHP hiba",
"Email:" => "E-mail:",
"Preload Admin Account" => "Adminisztrátori fiók betöltése",
"User / Group" => "Felhasználó / Csoport",
"Multiple" => "Több",
"List polls" => "Szavazások listázása",
"Edit this poll" => "Ezen szavazást szerkesztése",
"Preview poll" => "Szavazás előnézet",
"Option" => "Opció",
"Poll options" => "Szavazás opciók",
"Votes" => "szavazatok",
"Admin Polls" => "Szavazások adminisztrálása",
"Set last poll as current" => "Az utolsó szavazás jelenlegivé tétele",
"Close all polls but last" => "Minden szavazás bezárása az utolsó kivételével",
"Activate all polls" => "Minden szavazás aktiválása",
"Create poll" => "Kérdőív létrehozása",
"Edit poll" => "Kérdőív szerkesztése",
"active" => "aktív",
"current" => "jelenlegi",
"template" => "sablon",
"object" => "objektum",
"Add Option" => "Opció hozzáadása",
"PublishDate" => "Publikálás dátuma",
"0 for no limit" => "0 ha nincs szükség határra",
"Results" => "Eredmények",
"Add poll to pages" => "Kérdőív hozzáadása oldalakhoz",
"Wiki pages" => "Wiki oldalak",
"Lock the pages" => "Oldalak zárolása",
"Admin Quicktags" => "Quicktag-ek beállítása",
"Create/Edit QuickTags" => "Quicktag létrehozása/szerkesztése",
"Quicktags category filter" => "Quicktag kategória szűrő",
"Insert (use 'text' for figuring the selection)" => "Beszúrás (használjuk a 'text' szót a szövegrész megjelölésére)",
"Path to the tag icon" => "Útvonal a címke ikonjához",
"Admin RSS Modules" => "RSS modulok adminisztrálása",
"Tips" => "Tippek",
"This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "Ezen az oldalon lehet a Tiki által beolvasott/importált RSS feed-eket konfigurálni. RSS feed generálásához/exportálához használjuk a központi adminisztráció felületet vagy",
"To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "RSS feed-ek használatához szöveges területen (Wiki oldal, stb), <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">modulban</a> vagy sablonban használjuk a következőt: {literal}{rss id=x}{/literal}, ahol x az RSS feed azonosítója",
"Content for the feed" => "Az adatfolyam tartalma",
"Create new RSS Module" => "Új RSS modul létrehozása",
"show feed title" => "feed címének megjelenítése",
"show publish date" => "publikálás dátumának megjelenítése",
"RSS channels" => "RSS csatornák",
"Show Title?" => "Cím megjelenítése?",
"Show Date?" => "Dátum megjelenítése?",
"View feed" => "Feed megtekintése",
"To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "<a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">Biztonsággal kapcsolatos események jelentése itt</a>",
"PHP settings" => "PHP beállítások",
"PHP variable" => "PHP változó",
"Risk Factor" => "Kockázati faktor",
"Explanation" => "Magyarázat",
"TikiWiki settings" => "TikWiki beállítások",
"Tiki variable" => "Tiki változó",
"Security checks" => "Biztonsági ellenőrzések",
"Check all tiki files" => "Összes tiki fájl ellenőrzése",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Ez a művelet nagyon sokáig eltarthat, érdemes előtte ellenőrizni a max_execution_time beállítást a php.ini-ben",
"Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Megjegyzés: A biztonsági adatokat a telepítési folyamaton keresztül kell importálni (<a href=\"tiki-install.php\">tiki-install.php</a>). Importáljuk a *secdb* frissítő fájlokat az adatbázisba.",
"File checks" => "Fájlok ellenőrzése",
"Check file permissions" => "Fájl jogosultságok ellenőrzése",
"This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments." => "Ez az ellenőrzés igyekszik megtalálni a problematikusnak tűno jogosultsági beállításokkal rendelkező fájlokat. Megeshet hogy az itt problematikusnak feltüntetett fájlhoz kötodő jogosultságok bizonyos környezetekben nem számítanak problematikusnak vagy éppen elkerülhetetlenek (mivel abban a környezetben nem változtathatóak).",
"See end of table for detailed explanations." => "A tábla végén részletes magyarázat található",
"owner" => "tulajdonos",
"special" => "speciális",
"user" => "felhasználó",
"group" => "csoport",
"other" => "egyéb",
"sticky" => "ragadós",
"Admin Shoutbox Words" => "Az üzenőfal szóhasználatának beállításai",
"Add Banned Word" => "Tiltott szó hozzáadása",
"The structure" => "A struktúra",
"has just been created." => "létrejött",
"You will remove structure" => "A struktúra eltávolításra kerül",
"Destroy the structure leaving the wiki pages" => "A struktúra megsemmisítése meghagyva a wiki lapokat",
"Destroy the structure and remove the pages" => "A struktúra megsemmisítése és a lapok eltávolítása",
"Edit structure" => "Struktúra szerkesztése",
"View structure" => "Struktúra megtekintése",
"Export Pages" => "Oldalak exportálása",
"Dump Tree" => "Struktúra kimentése",
"Create WebHelp" => "Websúgó létrehozása",
"View WebHelp" => "Websúgó megjelenítése",
"Create new structure" => "Új struktúra létrehozása",
"Alias" => "Megjelenített neve",
"Tree" => "Fa",
"Use single spaces to indent structure levels" => "Szóköz használatával lehetséges a struktúra szintjeinek megadása",
"Create New Structure" => "Új struktúra létrehozása",
"Add a New Question" => "Új kérdés hozzáadása",
"List surveys" => "Kérdőívek listázása",
"Survey Stats" => "Kérdőív statisztika",
"Edit this Survey" => "Kérdőív szerkesztése",
"Admin Surveys" => "Kérdőívek adminisztrálása",
"Question" => "Kérdés",
"One choice" => "Egy válasz",
"Multiple choices" => "Több válasz",
"Short text" => "Rövid szöveg",
"Wiki textarea" => "Wiki szöveges terület",
"Rate (1..5)" => "Súlyozás (1..5)",
"Rate (1..10)" => "Súlyozás (1..10)",
"Rate" => "Értékelés",
"Options (if apply)" => "Beállítások (ha kéri)",
"Questions" => "Kérdések",
"Admin surveys" => "Kérdőívek adminisztrálása",
"List Surveys" => "Kérdőívek listázása",
"Edit this Survey:" => "Ezt a kérdőívet szerkeszd:",
"Create New Survey" => "Új kérdőív létrehozása",
"There are individual permissions set for this survey" => "Ehhez a kérdőívhez egyéni jogosultságok vannak beállítva",
"Open" => "Nyitva",
"Tiki Cache/System Admin" => "Cache/rendszer",
"If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)." => "Ürítsük ki a cache-t ha a Tiki furcsán kezd viselkedni. Nagyon fontos a cache törlése (ha kell FTP/SSH segítségével) rendszerfrissítés (upgrade) után is",
"Exterminator of cached content" => "Cache ürítése",
"Directory to exterminate" => "Kiürítendő könyvtárak",
"Clear all Tiki caches" => "Összes Tiki cache kiürítése",
"Empty" => "Kiürítés",
"All user prefs sessions" => "Összes felhasználói preferencia munkamenet",
"Directories to save" => "Mentendő könyvtárak",
"Generate a zip of those directories" => "Zip fájl generálása könyvtárakból",
"A zip has been written to {\$zipPath}" => "A zip fájl kiírásra került ide: {\$zipPath}",
"Directory is not writeable" => "A könyvtár nem írható",
"Templates compiler" => "Sablonok fordítása",
"Compile" => "Fordítás",
"Advanced feature" => "Extra funkció",
"Fix UTF-8 Errors in Tables" => "UTF-8 hibák fixálása táblákban",
"Warning: Make a backup of your Database before using this function!" => "Figyelmeztetés: a funkció használata előtt ajánlott biztonsági mentés készíteni az adatbázisról!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Figyelmeztetés: nagy táblák konvertálásakor érdemes megemelni a php.ini maximális végrehajtási időkeretét!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "A funkció az ISO-8859-1-ben kódolt sztringeket átalakítja UTF-8-ra a táblákban",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "Minderre akkor lehet szükség ha Tiki &lt; 1.8.4-el készült tartalom van és az Apache alapértelmezett karakterkészlete ISO-8859-1",
"UTF-8 Errors fixed" => "UTF-8 hibák fixálva",
"Investigate" => "Vizsgálat",
"Fix it" => "Fixálás",
"Create a new topic" => "Új téma létrehozása",
"Topic Name" => "Téma neve",
"Upload Image" => "Kép feltöltése",
"List of topics" => "Témák listája",
"Articles (subs)" => "Cikkek (beküldések)",
"topic image" => "téma kép",
"Inactive - Click to Activate" => "Inaktív - Klikk az aktiváláshoz",
"Deactivate" => "Deaktiválás",
"Active - Click to Deactivate" => "Aktív - Klikk a deaktiváláshoz",
"Remove with articles" => "Eltávolítás cikkekkel együtt",
"List Trackers" => "Űrlapok listázása",
"Admin Trackers" => "Űrlapok adminisztrálása",
"Edit This Tracker" => "Ezen űrlap szerkesztése",
"View This Tracker's Items" => "Ezen űrlap tételeinek megtekintése",
"New tracker field" => "Új űrlap mező",
"Edit tracker field" => "Űrlapmező szerkesztése",
"Is column visible when listing tracker items?" => "Oszlop látható űrlaptételek listázásakor?",
"Column links to edit/view item?" => "Oszlop linkel a tétel szerkesztéséhez/megtekintéséhez?",
"Multilingual content" => "Többnyelvű tartalom",
"Column is searchable?" => "Kereshető oszlop?",
"Field is public? (viewed in trackerlist plugin)" => "Mező publikus? (űrlaplistázó plugin megtekintésekor)",
"Field is hidden?" => "Mező rejtett?",
"not hidden" => "nem rejtett",
"visible to admin only" => "csak adminisztrátor számára látható",
"editable by admin only" => "csak adminisztrátor szerkesztheti",
"visible by creator &amp; admin only" => "létrehozó &amp; adminisztrátor láthatja csak",
"The option creator needs a field of type user selector and option 1" => "A opció létrehozásánál kell hogy legyen egy 'felhasználó kiválasztása' típus 1-es opcióval",
"Visible by:" => "Láthatja:",
"Editable by:" => "Szerkesztheti:",
"Field is mandatory?" => "Mező kötelező?",
"Error message:" => "Hibaüzenet:",
"Tracker fields" => "Űrlapmezők",
"isMain" => "Fő",
"Tbl vis" => "Táblában látható",
"Searchable" => "Kereshető",
"Hidden" => "Rejtett",
"Mandatory" => "Kötelező",
"Import/Export Trackers Fields" => "Űrlapmezők importálása/exportálása",
"Export fieldId also" => "Mező ID-t is exportálja",
"Edit This Tracker's Fields" => "Ezen űrlap mezőinek szerkesztése",
"Edit Tracker" => "Űrlap szerkesztése",
"Import/Export" => "Importálás/Exportálás",
"Create Tracker" => "Űrlap létrehozása",
"Duplicate Tracker" => "Űrlap duplikálása",
"Found" => "Találat",
"trackers" => "űrlapok",
"Create/Edit Tracker" => "Űrlap létrehozása/szerkesztése",
"There are individual permissions set for this tracker" => "Egyedi jogosultságok vannak rendelve ehhez az űrlaphoz",
"No individual permissions. Global permissions apply." => "Nincsenek egyéni jogosultságok megadva ezért a globális jogosultságok érvényesek",
"Auto create corresponding categories" => "Vonatkozó kategóriák automatikus létrehozása",
"Use \"explicit\" names in the mirror table" => "\"explicit\" nevek használata a tükörtáblában",
"Show status" => "Státusz megjelenítése",
"Default status displayed in list mode" => "Alapértelmezett státusz megjelenítése listázási nézetben",
"Show status to tracker admin only" => "Státusz megjelenítése csak az űrlap adminisztrátora számára",
"Send copies of all activity in this tracker to this e-mail address" => "Az űrlappal kapcsolatos összes tevékenység másolatának elküldése erre az E-mail címre",
"Use simplified e-mail format" => "Egyszerűsített E-mail formátum használata",
"The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "Az űrlap a Tárgy mező tartalmát fogja használni a tárgy megadásához, valamint a felhasználó E-mail címét vagy anonim küldő esetén az E-mail mező tartalmát a küldő megadásához",
"New items are created with status" => "Új tételek ebben a státuszban jöjjenek létre:",
"Authoritative status for modified items" => "Módosított tételek jóváhagyási státusza",
"No change" => "Nincs változás",
"Item creator can modify his items?" => "Tétel létrehozója módosíthatja saját tételeit?",
"The tracker needs a user field with the option 1" => "Az űrlaphoz szükséges egy felhasználói mező 1-es opcióval",
"Only one item per user or IP" => "Felhasználónként vagy IP-nként egy tétel lehetséges",
"The tracker needs a user or IP field with the option 1" => "Az űrlaphoz szükséges egy felhasználói vagy IP mező 1-es opcióval",
"Member of the default group of creator can modify items?" => "A létrehozó alapértelmezett csoportjának tagja módosíthatja a tételeket",
"The tracker needs a group field with the option 1" => "Az űrlapnál meg kell adni egy csoport mezőt 1-es opcióval",
"Show creation date when listing tracker items?" => "Létrehozás idejének megjelenítése űrlaptételek listázásakor",
"Format if not the default short one:" => "Formátum (ha nem az alapértelmezett rövid formátum):",
"Show creation date when viewing tracker item?" => "Létrehozás idejének megjelenítése űrlaptétel megtekintésekor",
"Show lastModif date when listing tracker items?" => "Utolsó módosítás idejének megjelenítése űrlaptételek listázásakor",
"Show lastModif date when viewing tracker item?" => "Utolsó módosítás idejének megjelenítése űrlaptétel megtekintésekor",
"What field is used for default sort?" => "Melyik mező szerint legyen az alapértelmezett felsorolás?",
"ItemId" => "Tétel ID",
"What is default sort order in list?" => "Felsorolás listázásának alapértelmezett rendezési elve",
"Tracker items allow ratings?" => "Űrlaptételeket lehet értékelni?",
"with values" => "ezen értékekkel",
"and display rating results in listing?" => "és szerepeljenek az értékek listázáskor?",
"Tracker items allow comments?" => "Űrlaptételeket lehet kommentálni?",
"and display comments in listing?" => "és szerepeljenek a kommentek listázáskor?",
"Tracker items allow attachments?" => "Űrlaptételekhez lehet mellékletet csatolni?",
"and display attachments in listing?" => "és megjelenjenek a mellékletek listázáskor?",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Melléklet megjelenítésének lehetőségei (Számokkal lehet a tételeket sorba rendezni, 0-ásak nem kerülnek listázásra, negatív értékek felugró dobozban jelennek meg)",
"Filesize" => "Fájlméret",
"Filetype" => "Fájltípus",
"LongDesc" => "Hosszú leírás",
"Items can be created only during a certain time" => "Tételeket csak egy meghatározott időszak alatt lehet létrehozni",
"After:" => "Kezdés:",
"Before:" => "Befejezés:",
"Do not show empty fields in item view?" => "Üres mezők elrejtése tétel megtekintésekor",
"Show these fields (ID comma separated) in a popup on item link when listing tracker items?" => "Ezen mezők megjelenítése (mező ID-k vesszővel elválasztva) felugró dobozban a tétel linkjén űrlaptételek listázásakor",
"Group of users alerted when tracker is modified" => "Űrlap módosításakor értesítendő felhasználói csoport",
"Import/export trackers" => "Űrlapok importálása/exportálása",
"Charset encoding" => "Karakterkódolás",
"Admin groups" => "Csoportok adminisztrálása",
"Admin users" => "Felhasználók adminisztrálása",
"Add new group" => "Új csoport hozzáadása",
"Edit group" => "Csoport szerkesztése",
"Members" => "Tagok",
"Add a New Group" => "Új csoport hozzáadása",
"List of existing groups" => "Létező csoportok listája",
"Includes" => "Tartalmazza",
"User Choice" => "Felhasználó kiválasztása",
"Only directly included" => "Csak közvetlenül belefoglalva",
"will have all the permissions of the included groups" => "a tartalmazott csoportok összes jogosultságát meg fogja kapni",
"Group Homepage" => "Csoport kezdőlapja",
"Use wiki page name or full URL" => "Egy Wiki oldal nevét vagy teljes elérési utat (URL-t) kell használni",
"For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)." => "Más Tiki funkciókhoz relatív linkeket kell használni (pld: <em>http:tiki-forums.php</em>)",
"Default category assigned to uncategorized objects edited by a user with this default group" => "Alapértelmezett kategória melybe a nem kategorizált objektumok kerülnek melyeket az itt megadott alapértelmezett csoport egy felhasználója szerkesztett",
"Group Theme" => "Csoport stílusa",
"choose a group tracker ..." => "csoportűrlap kiválasztása...",
"choose a users tracker ..." => "felhasználói űrlap kiválasztása...",
"Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Regisztrációkor kért felhasználói űrlap mezők <br />(mezőId-k elválasztója :)",
"User can assign to the group himself" => "Felhasználó felveheti magát a csoportba",
"Edit Item" => "Tétel szerkesztése",
"Add a New User" => "Új felhasználó hozzáadása",
"Rejected users" => "Elutasított felhasználók",
"Reason" => "Ok",
"More Criteria" => "További kritériumok",
"Group (direct)" => "Csoport (közvetlen)",
"Edit Account Settings" => "Fiókadatok szerkesztése",
"to groups" => "csoportokhoz",
"Change user preferences" => "Felhasználói preferenciák megváltoztatása",
"Remove Users and their Userpages" => "Felhasználók és felhasználói oldalaik eltávolítása",
"Manage Group Assignments" => "Csoporthozzárendelések kezelése",
"Set Default Groups" => "Alapértelmezett csoportok megadása",
"Assign selected to" => "Kiválasztottak hozzárendelése",
"Remove selected from" => "Kiválasztottak eltávolítása",
"the following groups:" => "a következő csoportokhoz/csoportokból:",
"Tip: Hold down CTRL to select multiple" => "Tipp: CTRL lenyomva tartásával többet is ki lehet választani",
"Repeat Password" => "Jelszó újra",
"User must change password at first login" => "A felhasználónak meg kell változtatnia a jelszavát első bejelentkezéskor",
"Last Login" => "Legutolsó bejelentkezés",
"User tracker item : {\$usersitemid}" => "Felhasználói űrlap tétel : {\$usersitemid}",
"Overwrite" => "Felülírás",
"Overwrite but keep the previous login if the login exists in another case" => "Felülírás de a korábbi bejelentkezési név megtartása ha a név már létezik",
"Don't overwrite" => "Ne írja felül",
"Overwrite groups:" => "Csoportok felülírása:",
"You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "Egy adott csoportba tartozó felhasználókat itt lehet exportálni <a href=\"tiki-admingroups.php\">Adminisztráció->Csoportok->a_group</a>",
"New attachments" => "Új mellékletek",
"Old attachments" => "Régi mellékletek",
"Source" => "Forrás",
"Admin Article Types" => "Cikktípusok adminisztrálása",
"List of types" => "Típusok listája",
"Show Help" => "Súgó megjelenítése",
"Article type" => "Cikk típus",
"Shows up in the drop down list of article types" => "Megjelenik a cikkek listáját tartalmazó legördülő listában",
"Allow ratings by the author" => "Szerző általi értékelés engedélyezése",
"Show before publish date" => "Megjelenítés a publikálás dátuma előtt",
"non-admins can view before the publish date" => "nem adminisztrátor felhasználók megtekinthetik publikálás dátuma előtt",
"Show after expire date" => "Megjelenítés lejárat dátuma után",
"non-admins can view after the expire date" => "nem adminisztrátor felhasználók megtekinthetik a lejárati dátum után",
"Heading only" => "Csak fejléc",
"No article body, heading only" => "Nincs törzs, csak fejléc",
"Allow comments for this type" => "Kommentek engedélyezése ezen típusnál",
"Comment Can Rate Article" => "Komment értékelheti a cikket",
"Allow comments to include a rating value" => "Commentek tartalmazhatnak értékelési értéket",
"Show image" => "Kép megjelenítése",
"Show topic or own image" => "Téma vagy saját kép megjelenítése",
"Show avatar" => "Avatár megjelenítése",
"Show author's avatar" => "A szerző avatárjának megjelenítése",
"Show author" => "Szerző megjelenítése",
"Show author name" => "Szerző nevének megjelenítése",
"Show publish date" => "Publikálás dátumának megjelenítése",
"Show expire date" => "Lejárati dátum megjelenítése",
"Show reads" => "Olvasások megjelenítése",
"Show the number of times the article was read" => "Megjeleníti hogy a hírt hányszor olvasták el",
"Show size" => "Méret megjelenítése",
"Show the size of the article" => "Cikk méretének megjelenítése",
"Show topline" => "Felső vonal megjelenítése",
"Show a small title over the title" => "Kis címet jelenít meg a cím felett",
"Show subtitle" => "Felirat megjelenítése",
"Show the subtitle" => "A felirat megjelenítése",
"Show source" => "Forrás megjelenítése",
"Show link to source after article body" => "Forrásra mutató link megjelenítése a cikk törzse után",
"Show Image Caption" => "Képfelirat megjelenítése",
"Show a legend under the image" => "Képfelirat megjelenítése",
"Show Language" => "Nyelv megjelenítése",
"Show the language" => "A nyelv megjelenítése",
"Creator can edit" => "Létrehozó szerkesztheti",
"The person who submits an article of this type can edit it" => "A személy aki beküld egy ilyen típusú cikket szerkesztheti is",
"Show lang" => "Nyelv megjelenítése",
"Review" => "Átnézés",
"Classified" => "Titkos",
"Create a new type" => "Új típus létrehozása",
"Group Information" => "Csoport információ",
"level" => "szint",
"inherited from" => "örökölve ettől:",
"inherited" => "öröklött",
"Level configuration" => "Szint konfiguráció",
"Create level" => "Szint készítése",
"all permissions in level" => "minden jogosultságot e szinten",
"Assign User {\$assign_user} to Groups" => "{\$assign_user} nevű felhasználó hozzárendelése csoportokhoz",
"Default Group" => "Alapértelmezett csoport",
"Assign Perms to this Group" => "Jogosultságok hozzárendelése ehhez a csoporthoz",
"Assign User to Group" => "Felhasználó hozzárendelése csoporthoz",
"backlinks to" => "hivatkozások a",
"No backlinks to this page" => "Erre az oldalra nem hivatkozik másik oldal",
"Browse Gallery" => "Galéria böngészése",
"Upload From Disk" => "Feltöltés lemezről",
"available images" => "rendelkezésre álló képek",
"Edit Post" => "Poszt szerkesztése",
"View Blog" => "Blog megtekintése",
"Use ...page... to separate pages in a multi-page post" => "Használjuk a '...page...' szintaxist oldalak elválasztásához többoldalas posztok esetén",
"Trash" => "Lomtár",
"Mark entry as private:" => "Privát bejegyzés",
"Spellcheck" => "Helyesírás ellenőrzése",
"Save and Exit" => "Mentés és kilépés",
"Made with" => "Készült",
"Watch Only This Category" => "Csak ezen kategória figyelése",
"Watch This Category and Their Descendants" => "Ezen kategória és alárendeltjei figyelése",
"Stop Watching Only This Category" => "Ezen kategória figyelésének felfüggesztése",
"Stop Watching This Category and Their Descendants" => "Ezen kategória és alárendeltjei figyelésének felfüggesztése",
"Admin Category" => "Kategória beállítása",
"Browse in" => "Böngészés",
"Trackers Items" => "Űrlap tételek",
"Sheets" => "Ívek",
"in the current category - and its subcategories: " => "a jelenlegi kategóriában - és annak alkategóriáiban:",
"Hide subcategories objects" => "Alkategóriák objektumainak elrejtése",
"Show subcategories objects" => "Alkategóriák objektumainak megjelenítése",
"Browse related tags" => "Címkék böngészése",
"Network of Tags related to" => "Kapcsolódó címkék hálózata:",
"Clear" => "Kiürítés",
"With all selected tags" => "Összes kiválasztott címke",
"With one selected tag" => "Egyik kiválasztott címke",
"With last selected tag" => "Legutolsó kiválasztott címke",
"More Popular Tags" => "További népszerű címkék",
"Sort:" => "Rendezési elv:",
"Alphabetically" => "Abc sorrend",
"By Size" => "Méret",
"Cloud" => "Felhő",
"results found" => "találat",
"List Galleries" => "Galériák listázása",
"Edit Gallery" => "Galéria szerkesztése",
"Rebuild Thumbnails" => "Előnézeti képek újraépítése",
"List Gallery" => "Galéria listázása",
"All Images" => "Összes kép",
"Monitor this Gallery" => "Galéria figyelése",
"Stop Monitoring this Gallery" => "Galéria figyelésének felfüggesztése",
"Sort Images by" => "A képek rendezése",
"subgallery" => "algaléria",
"Subgallery" => "Algaléria",
"Original Size" => "Eredeti méret",
"rotate right" => "jobbra forgatás",
"rotate" => "forgatás",
"Details" => "Részletek",
"popup" => "előugró",
"Return to Gallery" => "Vissza a galériához",
"First Image" => "Első kép",
"Prev Image" => "Előző kép",
"Smaller" => "Kisebb",
"Bigger" => "Nagyobb",
"Popup window" => "Előugró ablak",
"Next Image" => "Következő kép",
"Last Image" => "Utolsó kép",
"Direction" => "Irány",
"Image Name" => "Kép neve",
"Latitude (WGS84/decimal degrees)" => "Szélességi fok (WGS84/decimális fokokban kifejezve)",
"Longitude (WGS84/decimal degrees)" => "Hosszúsági fok (WGS84/decimális fokokban kifejezve)",
"Move image" => "Kép mozgatása",
"You can view this image in your browser using" => "Ezt a képet meg lehet nézni a böngészőből ennek használatával",
"Stop Monitoring this Page" => "Oldal figyelésének felfüggesztése",
"Monitor this Page" => "Oldal figyelése",
"Visible Calendars" => "Látható naptárak",
"Group Calendars" => "Csoport naptárak",
"Export calendars" => "Naptárak exportálása",
"Edit event" => "Esemény szerkesztése",
"View event" => "Esemény megtekintése",
"Organized by" => "Szervező",
"Tentative" => "Függő",
"Confirmed" => "Megerősítve",
"Cancelled" => "Visszavonva",
"View this Day" => "Ezen nap megtekintése",
"Calendar Item" => "Naptári tétel",
"New event" => "Új esemény",
"Edit Calendar Item" => "Naptár tétel szerkesztése",
"End" => "Befejezés",
"or new" => "vagy új",
"Update this event only" => "Csak ezen esemény frissítése",
"Update every unchanged events of this recurrence rule" => "Az ismétlődési szabály összes változatlan eseményének frissítése",
"Update every events of this recurrence rule" => "Ezen ismétlődési szabály összes eseményének frissítése",
"Delete Recurrent events" => "Ismétlődő események törlése",
"Calendar import" => "Naptár importálása",
"Calendar has been updated" => "Naptár frissítésre került",
"import" => "importálás",
"Previous" => "Előző",
"Avanced parameters for iCal export" => "iCal exportálás további paraméterei",
"Calendars to be exported" => "Exportálásra kerülő naptárak",
"Assign permissions to category" => "Jogosultság kiosztása kategóriához",
"Categories checking is not done in the database search." => "A kategóriák nincsenek ellenőrizve az adatbázisban",
"Current permissions for this category" => "Ezen kategóriához tartozó jelenlegi jogosultságok",
"Remove from this Category Only" => "Eltávolítás csak ebből a kategóriából",
"Remove from this Category &amp; all its Children" => "Eltávolítás ebből a kategóriából &amp; és összes alárendeltjéből",
"Perform action with checked" => "Akció végrehajtása a kijelöltekkel",
"Assign permissions" => "Jogosultságok kiosztása",
"to group" => "csoporthoz",
"this category &amp; all its children" => "ezen kategória &amp; összes alárendeltje",
"this category only" => "csak ezen kategória",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "Jogosultságokat <b>összes alárendelthez</b> érdemes megadni a legjobb teljesítmény eléréséhez",
"Change password enforced" => "Jelszócsere kötelező",
"Old password" => "Régi jelszó",
"Send a message to us" => "Üzenet küldése nekünk",
"Contact us by email" => "Kapcsolatfelvétel E-mail-en keresztül",
"Click here to send us an email" => "E-mail küldéshez klikk az E-mail címre",
"Send another message" => "Másik üzenet küldése",
"Contacts" => "Kontaktok",
"Group View" => "Csoport nézet",
"Create/edit contacts" => "Kontaktok létrehozása/szerkesztése",
"First Name" => "Keresztnév",
"Publish this contact to groups" => "Kontakt publikálása csoportok felé",
"Last Name" => "Vezetéknév",
"Nickname" => "Becenév",
"Structure" => "Struktúra",
"Current URL" => "Jelenlegi URL",
"Command" => "Parancs",
"Type <code>help</code> to get list of available commands" => "Írd be <code>help</code> a rendelkezésre álló parancsok listázásához",
"Add a new site" => "Új weblap hozzáadása",
"You cannot add sites until Directory Categories are setup." => "Weblapok hozzáadása nem lehetséges amíg a könyvtár kategóriák nicsenek beállítva",
"Please contact the Site Administrator" => "Kapcsolatfelvétel az oldal adminisztrátorával",
"<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>." => "<a href=\"tiki-directory_admin_catSelect which items to display when listing galleries:egories.php\">Kategória hozzáadása most</a>.",
"Site added" => "Weblap hozzáadva",
"The following site was added, but may require validation by the admin before appearing on the lists." => "A weblap hozzáadásra került de lehet hogy még adminisztrátori validálásra szorul mielőtt megjelenne a listákban",
"Edit a site" => "Weblap szerkesztése",
"Add a site" => "Weblap hozzáadása",
"Directory Administration" => "Könyvtár adminisztrálása",
"There are" => "Összesen",
"invalid sites" => "érvénytelen weblap van",
"valid sites" => "érvényes weblap van",
"Users have visited" => "A felhasználók",
"sites from the directory" => "könyvtári weblapot látogattak meg",
"Users have searched" => "A felhasználók",
"times from the directory" => "alkalommal kerestek a könyvtárban",
"Related" => "Kapcsolódó",
"Validate" => "Validálás",
"Admin directory categories" => "Könyvtári kategóriák adminisztrálása",
"Add a directory category" => "Könyvtári kategória hozzáadása",
"Edit this directory category" => "Könyvtárkategória szerkesztése",
"Children type" => "Gyerekek típusa",
"Most visited sub-categories" => "Leglátogatottabb alkategóriák",
"Category description" => "Kategória leírása",
"Random sub-categories" => "Véletlenszerű alkategóriák",
"Maximum number of children to show" => "Megjelenítendő alkategóriák száma",
"Editor group" => "Szerkesztő csoport",
"cType" => "Kategória típusa",
"allow" => "engedélyezés",
"count" => "számosság",
"editor" => "szerkesztő",
"relate" => "kapcsolás",
"Parent category" => "Felettes (szülő) kategória",
"Add a related category" => "Kapcsolódó kategória hozzáadása",
"Mutual" => "Kölcsönös",
"Related categories" => "Kapcsolódó kategóriák",
"Admin sites" => "Weblapok adminisztrálása",
"Use Ctrl+Click to select multiple categories." => "Ctrl+kattintás alkalmazásával több kategória is kiválasztható",
"Is valid" => "Valid",
"Perform action with selected:" => "Akció végrehajtása a kijelöltekkel:",
"New Sites" => "Új weblapok",
"Cool Sites" => "Népszerű weblapok",
"Add a Site" => "Weblap hozzáadása",
"any" => "bármely",
"in entire directory" => "teljes könyvtárban",
"Sort by" => "Rendezési elv",
"name (desc)" => "név (csökk)",
"name (asc)" => "név (növ)",
"hits (desc)" => "látogatások (csökk)",
"hits (asc)" => "látogatások (növ)",
"creation date (desc)" => "létrehozás dátuma (csökk)",
"creation date (asc)" => "létrehozás dátuma (növ)",
"last updated (desc)" => "legutóbbi frissítés (csökk)",
"last updated (asc)" => "legutóbbi frissítés (növ)",
"Added" => "Hozzáadva",
"Last updated" => "Legutóbbi frissítés",
"No records." => "Nincsenek rekordok",
"Total links" => "Összes link",
"Links to validate" => "Validálásra váró linkek",
"Searches performed" => "Végrehajtott keresések",
"Total links visited" => "Összes látogatott link",
"Directory ranking" => "Könyvtár rangsor",
"Search results" => "Keresés eredménye",
"Validate sites" => "Weblapok validálása",
"Edit article" => "Cikk szerkesztése",
"List Articles" => "Cikkek listázása",
"View Articles" => "Cikkek megtekintése",
"Subtitle" => "Alcím",
"Author Name" => "Szerző neve",
"Own Image" => "Saját kép",
"Use own image" => "Saját kép használata",
"Float text around image" => "Szöveg körbefolyatása a kép körül",
"Own image size x" => "Saját kép mérete x",
"Own image size y" => "Saját kép mérete y",
"Image caption" => "Képfelirat",
"Heading" => "Fejléc",
"Body" => "Törzs",
"Publish Date" => "Publikálás dátuma",
"Expiration Date" => "Lejárat dátuma",
"Edit or create banners" => "Bannerek létrehozása és szerkesztése",
"List banners" => "Banner lista",
"URL to link the banner" => "URL melyre a banner mutat",
"Client" => "Kliens",
"Max impressions" => "Max impresszió",
"-1 for unlimited" => "-1 esetén nincs határ",
"Max clicks" => "Max kattintás",
"Or, create a new zone" => "Vagy új zóna létrehozása",
"Show the banner only between these dates" => "Banner megjelenítése csak ezen dátumok között",
"From date" => "Kezdés dátuma",
"To date" => "Befejezés dátuma",
"Use dates" => "Dátumok használata",
"Show the banner only in this hours" => "Banner megjelenítése csak ezen órák között",
"to" => "ig",
"Show the banner only on" => "Banner megjelenítése csak ekkor",
"Mon" => "Hétfő",
"Tue" => "Kedd",
"Wed" => "Szerda",
"Thu" => "Csütörtök",
"Fri" => "Péntek",
"Sat" => "Szombat",
"Sun" => "Vasárnap",
"Select ONE method for the banner" => "EGY módszer kiválasztása a bannerhez",
"Use HTML" => "HTML használata",
"Use image" => "Kép használata",
"Image:" => "Kép:",
"Current Image" => "Jelenlegi kép",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "URL által generált kép használata (a kép minden egyes impressziónál kérésre kerül az URL-ről)",
"Use Flash" => "Flash használata",
"Movie Size" => "Film mérete",
"FlashPlugin min version" => "FlashPlugin min verzió",
"ex" => "pld",
"Use text" => "Szöveg használata",
"Save the Banner" => "Banner mentése",
"Remove Zones (you lose entered info for the banner)" => "Zónák eltávolítása (a bannerbe bevitt információ elveszik)",
"Create Blog" => "Blog létrehozása",
"Current heading" => "Jelenlegi fejléc",
"There are individual permissions set for this blog" => "Ehhez a bloghoz egyedi jogosultságok vannak beálllítva",
"Number of posts to show" => "Megjelenítendő posztok száma",
"Allow other user to post in this blog" => "Más felhasználó is posztolhat a blogba",
"Use titles in blog posts" => "Címek használata blogposztoknál",
"Allow search" => "Keresés engedélyezése",
"Allow comments" => "Kommentek engedélyezése",
"Show user avatar" => "Felhasználó avatárjának megjelenítése",
"Blog heading" => "Blog fejléc",
"Wiki Help" => "Wiki súgó",
"For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor" => "További információkért lásd: <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki oldal szerkesztése",
"Wiki Syntax" => "Wiki szintakszis",
"The syntax system used for creating pages in TikiWiki" => "Oldalak létrehozásához használt szintakszis rendszer TikiWikiben",
"Bold text" => "Félkövér szöveg",
"Italic text" => "Dőlt szöveg",
"single quotes" => "idézőjel",
"Underlined text" => "Aláhúzott szöveg",
"Colored text" => "Színezett szöveg",
"Deleted text" => "Törölt szöveg",
"2 dashes" => "2 kötőjel",
"Headings" => "Címsorok",
"Show/Hide" => "Megjelenítés/Elrejtés",
"show/hide heading section. + (shown) or - (hidden) by default" => "felsorolási szekció megjelenítése/elrejtése. + (megjelenítve) vagy - (elrejtve) alapértelmezés szerint",
"Autonumbered Headings" => "Automatikusan számozott címsorok",
"Horizontal rule" => "Vízszintes vonal",
"Text box" => "Szöveges doboz",
"Box content" => "Doboz tartalma",
"Centered text" => "Középre rendezett szöveg",
"Dynamic variables" => "Dinamikus változók",
"Inserts an editable variable" => "Beilleszt egy szerkeszthető változót",
"External links" => "Külső linkek",
"use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)." => "Használjunk szögletes zárójeleket külső linkhez: [URL], [URL|link_leírás],[URL|link_leírás|reláció] vagy [URL|leírás|reláció|nocache] (ez utóbbi megakadályozza hogy a helyi wiki cache-elje a linkelt oldalt; reláció a rel attribútum használatát teszi lehetővé a link számára - hasznos lehet pld. shadowbox funkció számára).",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "Külső Wikihez használjuk a KülsőWikiNeve:Oldalnév vagy ((Külső Wiki Neve: Oldal Neve)) szintakszist",
"Square Brackets" => "Szögletes zárójelek",
"Use [[foo] to show [foo]." => "Használjuk a [[foo] formátumot hogy ez jelenjen meg: [foo]",
"Wiki References" => "Wiki hivatkozások",
"JoinCapitalizedWords or use" => "NagybetűsSzavakEgyesítése vagy használjuk az",
"page|description" => "oldalnév|megjelenő leírás",
"for wiki references" => "formátumot wiki hivatkozásokhoz",
"page|#anchor" => "oldal|#horgony",
"page|#anchor|desc" => "oldal|#horgony|leírás",
"for wiki heading/anchor references" => "címsor/horgony hivatkozásokhoz",
"SomeName" => "Valamilyen név",
"prevents referencing" => "megakadályozza a hivatkozást",
"Lists" => "Listák",
"for bullet lists" => "felsorolásos listákhoz",
"for numbered lists" => "számozott listákhoz",
"for definiton lists" => "defincíciós listákhoz",
"Indentation" => "Behúzás",
"Creates an indentation for each plus (useful in list to continue at the same level)" => "Minden + jellel eggyel beljebb húzza (hasznos listázások ugyanazon szinten történő folytatására)",
"Tables" => "Táblák",
"row" => "sor",
"col" => "oszlop",
"Title bar" => "Címléc",
"Monospace font" => "Monospace betű",
"Code sample" => "Kód minta",
"Line break" => "Sortörés",
"(very useful especially in tables)" => "(nagyon hasznos például táblázatok esetén)",
"creates the editable drawing foo" => "létrehozza a szerkeszthető 'foo' rajzot",
"Multi-page pages" => "Többoldalas oldalak",
"to separate pages" => "szintakszist az oldalak elválasztásához",
"Non parsed sections" => "Nem elemzett szekciók",
"Prevents wiki parsing of the enclosed data." => "Megakadályozza a belefoglalt adatok wiki általi elemzését",
"Preformated sections" => "Előformázott szekciók",
"Block Preformatting" => "Blokk előformázása",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Lehetőséget nyújt tetszőleges számú szóközt tartalmazó szöveg bekezdéssel indítására és átformálására monospaced blokká úgy, hogy az továbbra is kövesse a Wiki formázási utasításokat. Amennyi szóközt használtunk annyival lesz behúzva. Vegyük figyelembe hogy ez a módszer nem őrzi meg a pontos szóközöléseket és sortöréseket ; ehhez használjuk a ~pp~...~/pp~ szintakszist",
"Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew." => "Jobbról-balra illetbe balról-jobbra írás lehetőségét teremti meg DIV beszúrásával a szöveg végéig, valamint jelzéseket rak be arab, héber és hasonló nyelveknél",
"Special characters" => "Speciális karakterek",
"numeric between ~ for html numeric characters entity" => "numerikus ~ között html numerikus entitásokhoz",
"Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines." => "Mivel a Wiki bekezdés formázás be van kapcsolva ezért a nem üres sorok összes csoportja bekezdésbe van összegyűjtve. A sorok bármilyen hosszúságúak lehetnek és egybe lesznek tördelve a következő sorral. A bekezdéseket üres sorok választják el.",
"Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line." => "Mivel a Wiki bekezdés formázás ki van kapcsolva ezért minden sor úgy jelenik meg ahogy írjuk. Ez azt jelenti hogy ha szeretnénk hogy a sorok rendesen legyenek tördelve akkor a teljes bekezdés egy sorból álljon.",
"Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt;" => "Plugin argumentumok dupla idézőjel közé tehetők (&quot;); lehetővé téve így hogy = vagy &gt; operandusokat tartalmazzanak",
"No description available" => "Nincs elérhető leírás",
"text, bold" => "szöveg, félkövér",
"text, italic" => "szöveg, dőlt",
"text, underline" => "szöveg, aláhúzás",
"table" => "tábla",
"table new" => "új tábla",
"external link" => "külső link",
"heading1" => "címsor 1",
"title bar" => "címléc",
"box" => "doboz",
"dynamic content" => "dinamikus tartalom",
"center text" => "szöveg középre igazítása",
"colored text" => "szöveg színe",
"dynamic variable" => "dinamikus változó",
"New Query" => "Új lekérdezés",
"New Layer" => "Új réteg",
"New Label" => "Új címke",
"New Reference" => "Új hivatkozás",
"New Legend" => "Új felirat",
"quote" => "idézet",
"Add Image from File Gallery" => "Kép hozzáadása fájlgalériából",
"special chars" => "különleges karakterek",
"special characters" => "különleges karakterek",
"Fullscreen Edit" => "Teljes képernyős szerkesztés",
"Browse Images" => "Képek böngészése",
"Image Description" => "Kép leírása",
"Edit and create Languages" => "Nyelvek létrehozása és szerkesztése",
"Im-Export Languages" => "Nyelvek importálása/exportálása",
"Toggle interactive translation off" => "Interaktív fordítás kikapcsolása",
"Toggle interactive translation on" => "Interaktív fordítás bekapcsolása",
"Edit and create languages" => "Nyelvek létrehozása és szerkesztése",
"Create Language" => "Nyelv létrehozása",
"Shortname" => "Rövid név",
"like" => "hasonló",
"Longname" => "Teljes név",
"Select the language to edit" => "Szerkesztendő nyelv kiválasztása",
"Add a translation" => "Fordítás hozzáadása",
"Edit translations" => "Fordítások szerkesztése",
"Translate recorded" => "Rögzítettek lefordítása",
"Translation" => "Fordítás",
"Create New Block" => "Új blokk létrehozása",
"List Quizzes" => "Kvízek listázása",
"Quiz Stats" => "Kvíz statisztika",
"This Quiz Stats" => "Ezen kvíz statisztikája",
"Edit this Quiz" => "Ezen kvíz szerkesztése",
"Admin Quizzes" => "Kvízek adminisztrálása",
"Create/edit options for question" => "Opciók létrehozása / szerkesztése a kérdéshez",
"Create/edit quizzes" => "Kvíz létrehozása/szerkesztése",
"There are individual permissions set for this quiz" => "Ezen kvízhez egyedi jogosultságok tartoznak",
"Quiz can be repeated" => "Kvízt meg lehet ismételni",
"Store quiz results" => "Kvíz eredményeinek tárolása",
"Immediate feedback" => "Azonnali visszajelzés",
"Show correct answers" => "Helyes válaszok megjelenítése",
"Shuffle questions" => "Kérdések véletlenszerű sorrendje",
"Shuffle answers" => "Válaszok véletlenszerű sorrendje",
"Questions per page" => "Kérdések oldalanként",
"Quiz is time limited" => "Kvíz idő korlátozása",
"Maximum time" => "Maximális idő",
"Passing Percentage" => "Megfelelés százaléka",
"Quiz" => "Kvíz",
"timeLimit" => "Időkorlát",
"Modify Structure" => "Struktúra szerkesztése",
"You will remove" => "Eltávolításra kerül a(z)",
"and its subpages from the structure, now you have two options:" => "oldalt és aloldalait e struktúrából, 2 opció áll rendelkezésre:",
"and its subpages from the structure" => "és aloldalait a struktúrából",
"Remove only from structure" => "Eltávolítás csak a struktúrából",
"Remove from structure and remove page too" => "Eltávolítás a struktúrából majd az oldal eltávolítása",
"The following pages added have automatically been categorized with the same categories as the structure:" => "A következő hozzáadott oldalak a struktúra kategóriabeállításainak megfelelően automatikusan kategorizálásra kerültek",
"Structure Layout" => "Struktúra felépítése",
"Monitor the Sub-Structure" => "Alstruktúra figyelése",
"Stop Monitoring the Sub-Structure" => "Alstruktúra figyelésének felfüggesztése",
"Promote" => "Szinttel feljebb",
"Demote" => "Szinttel lejjebb",
"Current Node" => "Jelenlegi ág",
"Page alias" => "Megjelenített neve:",
"Move in this structure" => "Mozgatás ebben a struktúrában",
"Move to another structure" => "Átmozgatás másik struktúrába",
"at the beginning" => "elejére",
"at the end" => "végére",
"Add pages to current node" => "Oldalak hozzáadása az ághoz",
"After page" => "Oldal után",
"Create Page" => "Oldal létrehozása",
"Use pre-existing page" => "Meglévő oldal használata",
"Categorize all pages in structure together" => "Struktúra összes oldalának egy kategóriába rendezése",
"Remove existing categories from ALL pages before recategorizing" => "Eltávolítás az összes kategóriából az újrakategorizálás előtt",
"Submit article" => "Cikk beküldése",
"List Submissions" => "Beküldött hírek listázása",
"<b>*</b>=optional" => "<b>*</b>=opcionális",
"Submit Article" => "Cikk beküldése",
"Auto-Approve Article" => "Cikk automatikus jóváhagyása",
"Edit templates" => "Sablonok szerkesztése",
"Edit a topic" => "Téma szerkesztése",
"Add Notification Email" => "Tájekoztató E-mail hozzáadása",
"Translate:" => "Fordítás:",
"You must specify the object language" => "Meg kell adni az objektum nyelvét",
"The object doesn't exist" => "Az objektum nem létezik",
"The object doesn't have a language" => "Az objektumhoz nincs nyelv rendelve",
"The object has already a translation for this language" => "Az objektumhoz már létezik fordítás ezen a nyelven",
"The object is already in the set of translations" => "Az objektum már szerepel a fordítások között",
"Language of newly translated page" => "Újonnan fordított oldal nyelve",
"Name of newly translated page" => "Újonnan fordított oldal neve",
"Create translation" => "Fordítás létrehozása",
"Or" => "Vagy",
"Add existing page as a translation of this page" => "Létező oldal hozzáadása fordításként",
"Manage existing translations of this page" => "Oldal létező fordításainak kezelése",
"detach" => "lecsatolás",
"Change language for this page" => "Oldal nyelvének megváltoztatása",
"Select from available options..." => "Választási lehetőségek...",
"Change Language" => "Nyelv megváltoztatása",
"No language is assigned to this page." => "Ehhez az oldalhoz nincs nyelv rendelve",
"Please select a language before performing translation." => "Fordítás elvégzése előtt ki kell választani egy nyelvet",
"Set Current Page's Language" => "Jelen oldal nyelvének megadása",
"Your edit session will expire in" => "A szerkesztési munkamenet lejár ennyi perc múlva:",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "A Homokozó egy oldal ahol gyakorolni lehet az oldalszerkesztést. Az előnézet gombbal megtekinthető a szerkesztési munka eredménye. A Homokozónak nincsenek tárolt verziói.",
"Perhaps you are looking for:" => "Hasonló oldalak:",
"This edit session will expire in {\$edittimeout} minutes" => "A szerkesztési munkamenet {\$edittimeout} perc múlva lejár",
"<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer." => "Az <strong>Előnézet</strong> vagy <strong>Mentés</strong> gomb lenyomásával a szerkesztési munkamenet időkerete  újraindul.",
"Categories will be inherited from the structure top page" => "Kategorizálás a struktúra legfelső oldalának kategóriái alapján történik",
"Admin Content Templates" => "Tartalomsablonok adminisztrálása",
"Use rating" => "Értékelés használata",
"There is no available poll template." => "Nincs elérhető kérdőív sablon",
"votes" => "szavazat",
"Regex search " => "Regex keresés",
"Replace to" => "Kicserélés erre",
"Case Insensitivity" => "Kis/nagybetű érzékeny",
"My Footnotes" => "Lábjegyzeteim",
"Translation request" => "Fordítási kérés",
"Send urgent translation request." => "Fordítási kérés küldése",
"Edit Comment" => "Szerkesztési megjegyzés",
"Monitor this page" => "Oldal figyelése",
"Year:" => "Év:",
"Authors:" => "Szerzők:",
"Try to convert HTML to wiki" => "Próbálja átkonvertálni a HTML kódot wikivé",
"Import page" => "Lap importálása",
"export all versions" => "összes verzió exportálása",
"Upload picture" => "Kép feltöltése",
"Add another image" => "További kép hozzáadása",
"License" => "Licensz",
"Important" => "Fontos",
"Lock this page" => "Oldal zárolása",
"Format" => "Formátum",
"Export Tracker Items" => "Űrlaptételek exportálása",
"status" => "státusz",
"lastModif" => "Legutóbbi módosítás",
"Admin FAQ" => "Gyakori kérdések beállításai",
"List FAQs" => "GYIK-ek listázása",
"Upload File" => "Fájl feltöltése",
"View tpl" => "Tpl megtekintése",
"Be careful to set the right permissions on the files you link to" => "Győződjünk meg róla hogy jól lettek beállítva a jogosultságok a fájlhoz melyre a link mutat",
"Create New File Gallery" => "Új fájlgaléria létrehozása",
"You can access the file gallery using the following URL" => "A fájlgaléria a következő URL-lel érhető el",
"Forum Importer" => "Fórumok importálása",
"Admin forums" => "Fórumok adminisztrálása",
"Import from a Local SQL File" => "Importálás lokális SQL fájlból",
"Forum Type" => "Fórum típusa",
"DB Prefix" => "Adatbázis előtag",
"Local SQL Filename on Server (path will be stripped)" => "Lokális SQL fájlnév a szerveren (az útvonalat le lesz csupaszítva)",
"Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Helye a tiki gyökérkönyvtár /{\$tmpdir} vagy tiki gyökérkönyvtár/img/wiki_up",
"Back to forum" => "Vissza a fórumhoz",
"summary" => "összefoglaló",
"normal" => "normál",
"announce" => "kihirdetés",
"hot" => "forró",
"no feeling" => "nincs érzelem",
"frown" => "haragos",
"exclaim" => "felkiáltás",
"idea" => "ötlet",
"mad" => "őrült",
"neutral" => "semleges",
"question" => "kérdés",
"sad" => "szomorú",
"happy" => "boldog",
"wink" => "kacsintás",
"Save and Approve" => "Mentés és jóváhagyás",
"convert to topic" => "témává konvertálás",
"List of messages" => "Üzenetek listája",
"New Topic" => "Új téma",
"no summary" => "nincs összefoglaló",
"Search by name" => "Keresés név szerint",
"Search in content" => "Keresés a tartalomban",
"Last Post" => "Utolsó hozzászólás",
"Configure Forum" => "Fórum konfigurálása",
"Tag translation" => "Címke fordítása",
"Set language" => "Nyelv beállítása",
"Accept" => "Elfogadás",
"Refuse" => "Visszautasítás",
"Waiting requests" => "Függő kérések",
"Your friends" => "Barátaim",
"break friendship" => "megszakítom a barátságot vele",
"Activity completed" => "Tevékenység befejeződött",
"activity" => "aktivitás",
"Expiration Time" => "Lejárat ideje",
"Years" => "Évek",
"Months" => "Hónapok",
"Hours" => "Órák",
"Minutes" => "Percek",
"Automatic" => "Automatikus",
"Manual" => "Manuális",
"Origin" => "Eredet",
"Edit Tpl" => "Tpl szerkesztése",
"completed" => "befejezve",
"Owner" => "Tulajdonos",
"Started" => "Elindítva",
"Admin processes" => "Folyamatok beállítása",
"Admin Roles" => "Szerepek adminisztrálása",
"Completed" => "Befejezve",
"User Activities" => "Felhasználói tevékenységek",
"Galleries" => "Galériák",
"Create New Gallery" => "Új galéria létrehozása",
"Create a gallery" => "Galéria létrehozása",
"Edit this gallery:" => "Ezen galéria szerkesztése:",
"There are individual permissions set for this gallery" => "Ehhez a galériához egyéni jogosultságok vannak beállítva",
"Fields to show during browsing the gallery" => "Galéria böngészésekor megjelenítendő mezők",
"Creation Date" => "Létrehozás dátuma",
"XY-Size" => "XY-méret",
"Gallery Image" => "Galéria képe",
"Available scales" => "Elérhető méretarányok",
"Global default" => "Globális alapértelmezés",
"Bounding box" => "Határoló doboz",
"default scale" => "alapértelmezett arány",
"No scales available" => "Nincs elérhető méretarány",
"Original image is default scale" => "Eredeti kép az alapértelmezett arány",
"Add scaled images with bounding box of square size" => "Arányosított képek hozzáadása négyzetes határoló dobozzal",
"Other users can upload images to this gallery" => "Más felhasználók is tölthetnek fel képet ebbe a galériába",
"You can access the gallery using the following URL" => "A galéria a következő URL-en érhető el:",
"Available Galleries" => "Rendelkezésre álló galériák",
"Choose a filter" => "Szűrő kiválasztása",
"Imgs" => "Képek",
"Google Map Locator" => "Google Map lokátor",
"Save clicked point" => "Klikkelt pont mentése",
"Save current view as default" => "Jelen nézet mentése alapértelmezettként",
"Center map to saved point" => "Térkép beállítása a mentett pontra",
"Users Map" => "Felhasználói térkép",
"Im- Export languages" => "Nyelvek importálása/exportálása",
"Select the language to Import" => "Importálandó nyelv kiválasztása",
"Select the language to Export" => "Exportálandó nyelv kiválasztása",
"Modify String in Source Language" => "Sztring (karakterlánc) módosítása a forrás nyelvben",
"Original String" => "Eredeti sztring",
"New String" => "Új sztring",
"Result" => "Eredmény",
"body" => "törzs",
"Locked" => "Zárolva",
"Tiki installer" => "Tiki telepítő",
"Welcome" => "Üdvözlet",
"Use this script to install a new Tiki database or upgrade your existing database to release" => "Ezt a szkriptet új Tiki adatbázis telepítéséhez vagy egy létező adatbázis ezen legújabb kiadásra történő frissítéséhez használjuk:",
"For the latest information about this release, please read the" => "További információk a legutóbbi kiadásról itt:",
"Release Notes" => "Kiadási megjegyzések",
"For complete documentation, please visit" => "Teljes dokumentációt lásd itt:",
"For more information about Tiki, please visit" => "További információk a TikiWikiről itt:",
"Read the License" => "Licensz elolvasása",
" <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Ide kattintva elolvasható a licensz bárki által könnyen áttekinthető és értelmezhető rövid kivonata több nyelven.</a>",
"Review the System Requirements" => "Rendszerkövetelmények áttekintése",
"Memory" => "Memória",
"Success" => "Sikeres",
"Mail" => "Levelezés",
"Copy test mail to " => "Másolat küldése a teszt E-mailről ide:",
"Send Test Message" => "Tesztüzenet küldése",
"Tiki was able to send a test message to" => "A Tiki sikeresen kiküldte a tesztüzenetet erre a címre:",
"Image Processing" => "Képek feldolgozása",
"Set the Database Connection" => "Adatbázis kapcsolat megadása",
"Use Existing Connection" => "Létező kapcsolat használata",
"Database information" => "Adatbázis információ",
"Database user" => "Adatbázis felhasználó",
"Install &amp; Update Profile" => "Profil telepítése &amp; frissítése",
"Install Profile" => "Profil telepítése",
"Install" => "Telepítés",
"Reinstall the database" => "Az adatbázis újratelepítése",
"Bare-bones default install" => "Alapértelmezett minimális telepítés",
"Personal Blog and Profile" => "Személyes blog és profil",
"Small Organization Web Presence" => "Kisvállalat webes megjelenése",
"Company Intranet" => "Vállalati intranet",
"Collaborative community" => "Kollaboratív közösség",
"Upgrade" => "Frissítés",
"Automatically upgrade your existing database to v" => "Létező adatbázis frissítése erre a verzióra:",
"Review the Upgrade" => "Frissítés áttekintése",
"Review the Installation" => "Telepítés áttekintése",
"Upgrade complete" => "Frissítés befejezve",
"Installation complete" => "Telepítés befejezve",
"Failed" => "Nem sikerült",
".htaccess File" => ".htaccess fájl",
"Configure General Settings" => "Általános beállítások megadása",
"Secure Login" => "Biztonságos bejelentkezés",
"Administrator" => "Adminisztrátor",
"Enter Your Tiki" => "Belépés a Tiki-be",
"Installation" => "Telepítés",
"Enter Tiki and Lock Installer" => "Belépés a Tikibe és a telepítő zárolása",
"Recommended" => "Ajánlott",
"Enter Tiki Without Locking Installer" => "Belépés a Tikibe a telepítő zárolása nélkül",
"MultiTiki Setup" => "MultiTiki beállítás",
"Default Installation" => "Alapértelmezett telepítés",
"DB OK" => "Adatbátis OK",
"No DB" => "Nincs adatbázis",
"Install/Upgrade" => "Telepítés/Frissítés",
"Database Connection" => "Adatbázis kapcsolat",
"Reset the Database Connection" => "Adatbázis kapcsolat beállítása",
"Configure the General Settings" => "Általános beállítások",
"Tiki Icon" => "Tiki ikon",
"TikiWiki Project Web Site" => "TikiWiki projekt weboldala",
"Support Forums" => "Támogató fórumok",
"TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware projekt",
"Clear cached version and refresh cache" => "Cache-elt verzió kiürítése és cache frissítése",
"configure rules" => "szabályok konfigurálása",
"Interactive translator" => "Interaktív fordítás",
"has been updated" => "frissítésre került",
"Close this window" => "Ablak bezárása",
"Go Back" => "Vissza",
"Clicking 'Close this window' will reload the main window from where it was opened" => "Az Ablak bezárása linkre való kattintás hatására újra betöltésre kerül a fő ablak (ahonnan az Interaktív fordítás ablak megnyitásra került)",
"Last Changes" => "Legutóbbi változások",
"Search by Date" => "Keresés dátum szerint",
"LastChanges" => "Legutóbbi változások",
"Rollback" => "Visszagörgetés",
"Pages like" => "Hasonló nevű oldalak",
"No pages found" => "Nincs megfelelő lap",
"Edit New Article" => "Új cikk szerkesztése",
"AuthorName" => "Szerző neve",
"To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "Banner használatához egy <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">modulban</a> vagy egy sablonban alkalmazzuk a  {literal}{banner zone=ABC}{/literal} formulát, ahol ABC a zóna neve",
"Create banner" => "Banner készítése",
"Method" => "Metódus",
"Use Dates?" => "Dátumok használata?",
"Max Impressions" => "Max nézőszám",
"Impressions" => "Nézőszám",
"Max Clicks" => "Max Klikkek",
"Clicks" => "Kattintások",
"Create New Blog" => "Új blog létrehozása",
"Use cache for external pages" => "Cache használata a külső lapokhoz",
"Approval" => "Jóváhagyás",
"Rejected" => "Elutasítva",
"Dynamic content system" => "Dinamikus tartalom rendszer",
"Edit content block" => "Tartalom blokk szerkesztése",
"Create content block" => "Tartalom blokk létrehozása",
"Available content blocks" => "Elérhető tartalom blokkok",
"Current Value" => "Jelenlegi érték",
"Current ver" => "Jelenlegi verzió",
"Next ver" => "Következő verzió",
"Future vers" => "Jövőbeli verzió",
"Edit this FAQ:" => "GYIK szerkesztése:",
"Create new FAQ" => "Új GYIK létrehozása",
"Create New FAQ:" => "Új GYIK létrehozása",
"Users can suggest questions" => "Felhasználók javasolhatnak kérdéseket",
"Available FAQs" => "Jelenlegi GYIK-ek",
"Create a File Gallery" => "Fájlgaléria létrehozása",
"SlideShow" => "Bemutató",
"Keep gallery window open" => "Galériaablak nyitva tartása",
"Your comment" => "Megjegyzés",
"optional" => "opcionális",
"Modifications" => "Módosítások",
"Property <b>{\$fgp_name}</b> Changed" => "Megváltoztatott tulajdonság: <b>{\$fgp_name}</b>",
"Gallery Images" => "Galéria képek",
"All games are from" => "A játékok származási helye",
"visit the site for more games and fun" => "látogasd meg több játékért és szórakozásért",
"Upload a game" => "Játék feltöltése",
"Upload a new game" => "Új játék feltöltése",
"Edit Blog" => "Blog szerkesztése",
"Blog Title" => "Blog címe",
"Last mod" => "Utolsó módosítás",
"Last modification" => "Utolsó módosítás",
"Page creator" => "Oldal létrehozója",
"Last author" => "Utolsó szerző",
"Last version" => "Legutóbbi verzió",
"Status of the page" => "Oldal státusza",
"Backl." => "Visszahiv.",
"Page size" => "Oldal mérete",
"unlocked" => "feloldva",
"Open client window" => "Kliens ablak megnyitása",
"Generate HTML" => "HTML generálása",
"Transcripts" => "Leíratok",
"Online operators" => "Elérhető operátorok",
"Operator" => "Operátor",
"Accepted requests" => "Elfogadott kérések",
"since" => "óta",
"transcripts" => "leiratok",
"offline" => "nem elérhető",
"Offline operators" => "Nem elérhető operátorok",
"Add an operator to the system" => "Operátor hozzáadása a rendszerhez",
"Operators must be tiki users" => "Csak Tiki felhasználók lehetnek operátorok",
"Set as Operator" => "Beállítás operátorként",
"Chat started" => "Csevegés elindítva",
"Operator:" => "Operátor:",
"Live support:User window" => "Élő támogatás:Felhasználói ablak",
"Request live support" => "Élő támogatás kérése",
"Request support" => "Támogatás kérése",
"Open a support ticket instead" => "Inkább egy támogatási jegy megnyitása",
"Your request is being processed" => "A kérés feldolgozás alatt",
"cancel request and exit" => "kérés visszavonása és kilépés",
"cancel request and leave a message" => "kérés visszavonása és üzenet hagyása",
"Live support:Console" => "Élő támogatás:Konzol",
"be online" => "elérhetővé válás",
"be offline" => "elérhetetlenné válás",
"Support requests" => "Támogatási kérések",
"Requested" => "Kérve",
"Join" => "Csatlakozás",
"Support chat transcripts" => "Támogatási csevegés leiratok",
"operator" => "operátor",
"started" => "kezdve",
"reason" => "ok",
"msgs" => "üzenetek",
"Transcript" => "Leirat",
"For security purposes we must periodically validate your email address to allow continued access to this site." => "Biztonsági okokból időszakosan validálnunk kell az E-mail címet hogy továbbrais elérhető maradjon az oldal",
"A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site." => "A validálási E-mail elküldésre került. A megadott címen megtekinthető a levél tartalma és a benne található információkat követve az oldal újra elérhetővé válik.",
"Thank you" => "Köszönöm",
"This is an experimental feature" => "Ez egy kísérleti jellegű funkció",
"Requires" => "Szükséges hozzá",
"Not Enabled" => "Nincs bekapcsolva",
"Mail-in feature" => "Mail-in funkció",
"Prefs" => "Beállítások",
"Remove old events" => "Régi események eltávolítása",
"duration" => "időtartam",
"Mini Calendar: Preferences" => "Mini Naptár: Beállítások",
"Calendar Interval in daily view" => "Naptár intervallum napi nézetben",
"Start hour for days" => "A nap kezdőóráa",
"End hour for days" => "A nap utolsó óráa",
"Reminders" => "Emlékeztető",
"no reminders" => "nincs emlékeztető",
"Or enter path or URL" => "vagy útvonal / URL megadása",
"Add Topic" => "Téma hozzáadása",
"Mods Configuration" => "Mods konfiguráció",
"Update remote index" => "Távoli index frissítése",
"Rebuild local list" => "Lokális lista újraépítése",
"Republish all" => "Összes újrapublikálása",
"Publish all" => "Összes publikálása",
"Unpublish all" => "Összes publikálásának visszavonása",
"Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>." => "Tiki \"mods\" kiegészítő funkciókat tartalmaz melyek nem beépített részei a hivatalos csomagnak. Több információ róluk itt: <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>.",
"Attention" => "Figyelem",
"all types" => "összes típus",
"Display only this type" => "Csak ezen típus megjelenítése",
"Unpublish" => "Publikálás visszavonása",
"Republish" => "Újrapublikálás",
"licence" => "licensz",
"Tikiwiki Mods Configuration" => "Tikiwiki Mods konfiguráció",
"Mods Install/uninstall" => "Mods telepítés/eltávolítás",
"Enable Mods providing" => "Mods nyújtás aktiválása",
"Mods local directory" => "Mods helyi könyvtár",
"Mods remote server" => "Mods távoli szerver",
"Package Config" => "Csomag beállítás",
"User Pages" => "Felhasználói lapok",
"y" => "i",
"User Galleries" => "Felhasználói galériák",
"My Articles" => "Cikkeim",
"User Articles" => "Felhasználói cikkek",
"My User Items" => "Tételeim",
"User Items" => "Felhasználói tételek",
"Unread Messages" => "Olvasatlan üzenetek",
"Tasks" => "Feladatok",
"User forum topics" => "Felhasználó fórum témái",
"Forum topics" => "Fórum témák",
"Date of post" => "Hozzászólás ideje",
"User forum replies" => "Felhasználó fórum válaszai",
"Forum replies" => "Fórum válaszok",
"User Blogs" => "Felhasználói blogok",
"My Infos" => "Személyes információim",
"Contacts Preferences" => "Kontakt preferenciák",
"Notepad" => "Jegyzettömb",
"MyFiles" => "Fájljaim",
"My Watches" => "Figyeléseim",
"My Contacts" => "Kontaktjaim",
"My Wiki Pages" => "Wiki oldalaim",
"My Galleries" => "Galériáim",
"My Tracker Items" => "Űrlapjaim",
"Assigned items" => "Hozzárendelt elemek",
"My Messages" => "Üzeneteim",
"My Tasks" => "Feladataim",
"Sent editions" => "Küldött szerkesztések",
"Sent Edition" => "Küldött szerkesztés",
"HTML version" => "HTML verzió",
"Text version" => "Szöveges verzió",
"Delete errors" => "Hibák törlése",
"Not sent" => "Nem került elküldésre",
"Subscribe to Newsletter" => "Feliratkozás Hírlevélre",
"Subscribe to this Newsletter" => "Feliratkozás erre a hírlevélre",
"Available Newsletters" => "Rendelekzésre álló hírlevelek",
"Select news group" => "Hírcsoport választása",
"Back to servers" => "Vissza a szerverekhez",
"Msgs" => "üzenetek",
"News from" => "Hírek feladója",
"Back to groups" => "Vissza a csoportokhoz",
"Save position" => "Pozíció mentése",
"Back to list of articles" => "Vissza a cikkek listájához",
"Newsgroup" => "Hírcsoport",
"Configure news servers" => "Hírszerver konfigurálása",
"Configure Newsreader" => "Hírolvasó beállítása",
"configure newsreader server tpl" => "Hírolvasó szerver beállítás tpl",
"Select a news server to browse" => "Egy hírszerver választása böngészésre:",
"server" => "szerver",
"Read the news" => "Hírek olvasása",
"Add a news server" => "Hírszerver hozzáadása",
"Edit news server" => "Hírszerver frissítése",
"News server" => "Hírszerver",
"Notes" => "Jegyzetek",
"Write a note" => "Jegyzet írása",
"quota" => "Kvóta",
"No notes yet" => "Nincsenek még jegyzeteim",
"Merge selected notes into" => "A kiválasztott jegyzeteket egyesítésem ebben:",
"Reading note:" => "Jegyzet olvasása:",
"List notes" => "Jegyzetek listázása",
"Write note" => "Jegyzet írása",
"Wiki Create" => "Wiki létrehozása",
"Wiki Overwrite" => "Wiki felülírása",
"Assign permissions to " => "Jogosultságok megadása: ",
"View Permissions" => "Jogosultságok megtekintése",
"Edit Permissions" => "Jogosultságok szerkesztése",
"These permissions override any global permissions or category permissions affecting this object." => "Ezek a jogosultságok erősebbek mint az objektumra vonatkozó globális jogosultságok vagy kategóriajogosultságok",
"To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>." => "Globális jogosultságok szerkesztéséhez <a class=\"rbox-link\" href=\"tiki-admingroups.php\">katt ide</a>.",
"Current permissions for this object" => "Az objektum jelenlegi jogosultságai",
"No individual permissions, category permissions apply" => "Nincsenek egyedi jogosultságok, a kategóriajogosultságok érvényesek",
"Current permissions for categories that this object belongs to" => "Azon kategóriák jogosultságai melyekbe az objektum tartozik",
"These permissions do not apply. Special permissions apply." => "Ezek a jogosultságok nem alkalmazhatóak. Egyedi jogosultságok érvényesek",
"No category permissions; global permissions apply" => "Nincsenek kategória-jogosultságok beállítva; a globális jogosultságok érvényesek",
"No category permissions; special permissions apply" => "Nincsenek kategória-jogosultságok beállítva; egyedi jogosultságok érvényesek",
"and also to all pages of the sub-structure:" => "és az alárendeltekhez tartozó összes oldalra vonatkozóan is:",
"Assign permissions to this object" => "Jogosultságok hozzárendelése ehhez az objektumhoz",
"Perms Help" => "Jogosultság súgó",
"Published" => "Publikált",
"Your OpenID identity is valid" => "Az OpenID identitás valid",
"Associate OpenID with an existing Tikiwiki account" => "OpenID hozzákapcsolása létező Tikiwiki fiókhoz",
"Select account" => "Fiók kiválasztása",
"Orphan Pages" => "Árva oldalak",
"Browser not supported" => "Nem támogatott böngésző",
"Rename" => "Átnevezés",
"Make Structure" => "Struktúra létrehozása",
"Slides" => "Bemutató",
"Discuss" => "Megbeszélés",
"Attach File" => "Fájl csatolása",
"1 File Attached" => "1 csatolt fájl",
"{\$atts|@count} files attached" => "{\$atts|@count} melléklet",
"Preview of version" => "Verzió előnézete",
"(current)" => "(jelenlegi)",
"Rollback to this version" => "Visszaállítás erre a verzióra",
"Source of version" => "Verzió forrása",
"s=source" => "s=source (forrás)",
"b=rollback" => "b=rollback (visszaállítás)",
"Update Translation" => "Fordítás frissítése",
"Hide translation history" => "Fordítási változások elrejtése",
"Show translation history" => "Fordítási változások megjelenítése",
"Pick your avatar" => "Avatar kiválasztása",
"User Preferences" => "Felhasználói beállítások",
"Your current avatar" => "Jelenlegi avatárom",
"no avatar" => "Nincs avatár",
"Pick avatar from the library" => "Avatár kiválasztása könyvtárból",
"Pick user Avatar" => "Felhasználói avatár kiválasztása",
"Hide all" => "Összes elrejtése",
"icons" => "ikon",
"Show all" => "Összes mutatása",
"Avatar Image" => "Avatár kép",
"Upload your own avatar" => "Saját avatár feltöltése",
"File (only .gif, .jpg and .png images approximately 45px × 45px)" => "Fájl (csak .gif, .jpg és .png kitejesztésű képek kb 45px × 45px méretben)",
"Insert" => "Beszúrás",
"Items found:" => "Talált tételek:",
"atts" => "mellékletek",
"List Attachments" => "Mellékletek listázása",
"Average" => "Átlag",
"Plugin Approval" => "Plugin jóváhagyása",
"View Results" => "Eredmények megtekintése",
"Vote poll" => "Szavazás",
"Other Polls" => "Egyéb szavazások",
"Topic image" => "Téma kép",
"The original document is available at" => "Az eredeti dokumentum itt érhető el:",
"Print multiple pages" => "Oldalak tömeges nyomtatása",
"Selected Structures" => "Kiválasztott struktúrák",
"Add Structure" => "Struktúra hozzáadása",
"No structures" => "Nincsenek struktúrák",
"Add Pages" => "Oldalak hozzáadása",
"No pages" => "Nincsnek oldalak",
"Use Ctrl+Click to select multiple pages" => "Ctrl+Kattintás segítségével több oldal is kiválasztható",
"Add Page" => "Oldal hozzáadása",
"Add Pages from Structures" => "Oldalak hozzáadása struktúrákból",
"Add Structure Pages" => "Struktúra oldalainak hozzáadása",
"Selected Pages" => "Kiválaszott oldalak",
"No pages selected." => "Nincsenek oldalak kiválasztva",
"General Options" => "Általános beállítások",
"Publication Date" => "Publikálás dátuma",
"Grading method " => "Osztályozási módszer",
"Publish statistics " => "Statisztikák publikálása",
"Extra Options" => "Extra opciók",
"Quiz result stats" => "Kvíz eredményeinek statisztikája",
"Time" => "Idő",
"User answers" => "Felhasználói válaszok",
"Stats for quizzes" => "Kvízek statisztikája",
"taken" => "kitöltött kvíz",
"Av score" => "Átlagos eredmény",
"Av time" => "Átlagos idő",
"Clear Stats" => "Statisztika törlése",
"time taken" => "eltöltött idő",
"Top 10" => "Első 10",
"Top 20" => "Első 20",
"Top 50" => "Első 50",
"Top 100" => "Első 100",
"Rank" => "Rang",
"star" => "csillag",
"half star" => "fél csillag",
"Send a link" => "Link küldése",
"Received articles" => "Fogadott cikkek",
"Edit received article" => "Beérkezett cikk szerkesztése",
"Use Image" => "Kép használata",
"Image x size" => "Kép x méret",
"Image y size" => "Kép y méret",
"Image name" => "Kép neve",
"Accept Article" => "Cikk elfogadása",
"Site" => "Oldal",
"Received Pages" => "Oldalak fogadása",
"Edit Received Page" => "Beérkezett oldal szerkesztése",
"Received Structures" => "Beérkezett struktúrák",
"Referer stats" => "Hivatkozási statisztika",
"Use your email as login" => "E-mail cím használata felhasználónévként",
"Send me my Password" => "Küldd el a jelszóm",
"Request Password Reset" => "Jelszóváltoztatás kérése",
"Remove page" => "Oldal eltávolítása",
"Last Version" => "Legutóbbi verzió",
"Back to page" => "Vissza az oldalra",
"You are about to remove the page" => "Ezzel eltávolításra kerül a lap",
"permanently" => "oldalt",
"Remove all versions of this page" => "Az oldal összes verziójának eltávolítása",
"to version" => "verzióra",
"Searched" => "Keresések száma",
"Search in" => "Keresés itt",
"Faqs" => "GYIK-ek",
"Simple search" => "Egyszerű keresés",
"No pages matched the search criteria" => "Nincs a keresési kritériumoknak megfelelő oldal",
"Blogs Post" => "Blog posztok",
"All dates" => "Összes dátum",
"Calendar Items" => "Naptár tételek",
"Send blog post" => "Blog poszt küldése",
"Data HTML" => "Adat HTML",
"Data Txt" => "Adat Txt",
"Attached Files" => "Mellékelt fájlok",
"remove" => "eltávolítás",
"To add a file, click here" => "Kattintás ide fájl hozzáadásához",
"Save as Draft" => "Mentés piszkozatként",
"Send objects" => "Objektumok küldése",
"Transmission results" => "Átvitel eredménye",
"Send Wiki Pages" => "Wiki oldalak küldése",
"Send a structure" => "Struktúra küldése",
"Send Articles" => "Cikkek küldése",
"Add Article" => "Cikk hozzáadása",
"Send objects to this site" => "Objektumok küldése erre az oldalra",
"Create a sheet" => "Ív létrehozása",
"Create New Sheet" => "Új ív létrehozása",
"Header Rows" => "Fejléc sorok",
"Footer Rows" => "Lábléc sorok",
"Create new Sheet" => "Új ív hozzáadása",
"Change shoutbox general settings" => "Az üzenőfal általános beállításai",
"auto-link urls" => "URL-ek automatikus linkelése",
"Post or edit a message" => "Üzenet szerkesztése vagy elküldése",
"This is the staging copy of" => "Ez egy előkészítési példánya ennek az oldalnak:",
"Parent page" => "Felettes oldal",
"Child" => "Alárendelt oldal",
"page: %0/%1" => "oldal: %0/%1",
"Last edited by" => "Utoljára szerkesztette:",
"based on work by" => "a következő felhasználó munkája alapján:",
"Contributors to this page" => "Hozzájárulók az oldal szerkesztéséhez",
"Page last modified on %0 by %1" => "Oldal legutóbbi módosítása: %0 %1 által",
"Created by %0" => "Létrehozta %0",
"Last Modification: %0 by %1" => "Legutóbbi módosítás: %0 %1 által",
"cool" => "király",
"cry" => "sírás",
"evil" => "gonosz",
"smile" => "mosoly",
"arrow" => "nyíl",
"Clean" => "Törlés",
"Most viewed objects" => "Leglátogatottabb objektumok",
"Most viewed objects in the last 7 days" => "Leglátogatottabb objektumok az elmúlt 7 napban",
"Site Stats" => "Általános weblap statisztika",
"Total pageviews" => "Összesen ennyiszer tekintették meg az oldalakat",
"Average pageviews per day" => "Naponta átlagosan ennyiszer tekintették meg az oldalakat",
"Best day" => "Leglátogatottabb nap",
"Worst day" => "Legkevésbé látogatott nap",
"Wiki Stats" => "Wiki oldal statisztika",
"Size of Wiki Pages" => "Wiki oldalak mérete",
"Average page length" => "Wiki oldalak átlagos mérete (forrásban)",
"Average versions per page" => "Az oldalaknak átlagosan ennyi verziójuk van",
"Visits to wiki pages" => "Látogatások a Wiki oldalakban",
"Orphan pages" => "Forrás oldalak",
"Average links per page" => "Wiki oldalak átlagos hivatkozásainak száma",
"Image galleries Stats" => "Képgaléria statisztika",
"Average images per gallery" => "Képek átlagos száma galériánként",
"Total size of images" => "Képek összes mérete",
"Average image size" => "Egy kép átlagos mérete",
"Visits to image galleries" => "Látogatások a képgalériákban",
"File galleries Stats" => "Fájlgaléria statisztika",
"Average files per gallery" => "Fájlok átlagos száma galériánként",
"Total size of files" => "Fájlok összes mérete",
"Average file size" => "Egy fájl átlagos mérete",
"Visits to file galleries" => "Látogatások a fájlgalériákban",
"CMS Stats" => "CMS statisztika",
"Total reads" => "Összes olvasás",
"Average reads per article" => "Cikkek átlagos olvasottsága",
"Total articles size" => "Cikkek teljes mérete",
"Average article size" => "Cikkek átlagos mérete",
"Forum Stats" => "Fórum statisztika",
"Total topics" => "Összes téma",
"Average topics per forums" => "Átlagos témák száma fórumonként",
"Total replies" => "Összes válasz",
"Average number of replies per topic" => "Válaszok átlagos száma témánként",
"Visits to forums" => "Látogatások a Fórumokon",
"Blog Stats" => "Blog statisztika",
"Weblogs" => "Webblogok",
"Total posts" => "Összes poszt",
"Average posts per weblog" => "Posztok átlagos száma blogonként",
"Total size of blog posts" => "Blogposztok teljes mérete",
"Average posts size" => "Posztok átlagos mérete",
"Visits to weblogs" => "Webblogok látogatottsága",
"Poll Stats" => "Szavazás statisztika",
"Total votes" => "Összes szavazat",
"Average votes per poll" => "Szavazatok átlagos száma szavazásonként",
"FAQ Stats" => "Gyik statisztika",
"Total questions" => "Összes kérdés",
"Average questions per FAQ" => "Kérdések átlagos száma témánként",
"User Stats" => "Felhasználó statisztika",
"User bookmarks" => "Felhasználói könyvjelzők",
"Average bookmarks per user" => "Könyvjelzők átlagos száma felhasználónként",
"Average questions per quiz" => " Kérdések átlagos száma kvízenként",
"Quizzes taken" => "Kitöltött kvízek száma",
"Average quiz score" => "Kvízek átlagos eredménye",
"Average time per quiz" => "Átlagos idő kvízenként",
"Usage chart" => "Használati diagram",
"Usage chart image" => "Használati diagram kép",
"Daily Usage" => "Napi használat",
"Tiki Logs" => "Tiki logok",
"Clean logs older than" => "Összes olyan log törlése mely idősebb mint",
"months" => "hónap",
"Time Left" => "Hátralévő idő",
"Send Answers" => "Kérések küldése",
"Thank you for your submission" => "Köszönjük a beküldést",
"Send a link to a friend" => "Link küldése ismerősnek",
"Your email was sent" => "Az E-mail elküldésre került",
"The link was sent to the following addresses:" => "A link a következp címekre került elküldésre:",
"Friend's email" => "Ismerős E-mail címe",
"Separate multiple email addresses with a comma." => "Több E-mail cím is megadható vesszőkkel elválasztva",
"Your name" => "Küldő neve",
"Your email" => "Küldő E-mail címe",
"I found an interesting page that I thought you would like." => "Találtam itt egy oldalt ami szerintem érdekelni fog, ha van időd, nézz rá, üdv,",
"Show Page Differences" => "Oldaleltérések megjelenítése",
"Delete this link" => "Ezen link törlése",
"Theme is selected as follows" => "A stílus a következo sorrendben kerül kiválasztásra",
"If a theme is assigned to the individual object that theme is used." => "Ha az adott objektumhoz stílus van megadva, akkor az lesz használva",
"If not then if a theme is assigned to the object's category that theme is used" => "Ha nincs megadva, akkor az objektum kategóriájához rendelt,",
"If not then a theme for the section is used" => "ha az sincs, akkor a szekció stílusa, ",
"If none of the above was selected the user theme is used" => "ha az sincs akkor a felhasználó általi prefereált stílus,",
"Finally if the user didn't select a theme the default theme is used" => "és végül ha az sincs megadva akkor az oldal alapértelmezett stílusa kerül felhasználásra",
"Control by Objects" => "Objektumonkénti vezérlés",
"Control by Sections" => "Szekciónkénti vezérlés",
"Assign themes to categories" => "Stílusok hozzárendelése kategóriákhoz",
"Assigned categories" => "Hozzárendelt kategóriák",
"Theme Control Center: Objects" => "Stílusvezérlés: Objektumok",
"Control by Categories" => "Kategóriánkénti vezérlés",
"Assign themes to objects" => "Stílus hozzárendelése objektumokhoz",
"Assigned objects" => "Hozzárendelt objektumok",
"Assign themes to sections" => "Stílus hozzárendelése szekciókhoz",
"Assigned sections" => "Hozzárendelt szekciók",
"The following file was successfully uploaded" => "A következő fájl sikeresen feltöltésre került",
"The following files have been successfully uploaded" => "A következő fájlok sikeresen feltöltésre kerültek",
"Additional Info" => "További információ",
"You can download this file using" => "Link a fájl letöltéséhez",
"You can link to the file from a Wiki page using" => "Link a fájlhoz Wiki oldalról",
"You can display an image in a Wiki page using" => "Kép megjelenítéséhez Wiki oldalon",
"You can link to the file from an HTML page using" => "Link a fájlhoz HTML oldalról",
"You locked the file" => "A fájl zárolásra került",
"Unzip zip files" => "Zip fájlok kitömörítése",
"Author if not the file creator:" => "Szerző neve (ha nem egyezik meg a létrehozóval):",
"Maximum file size is limited to:" => "Maximális fájlméret:",
"No gallery available." => "Nincs elérhető galéria.",
"You have to create a gallery first!" => "Először létre kell hozni egy galériát!",
"Batch Upload Results" => "Tömeges (kötegelt) feltöltés eredménye",
"Upload successful!" => "A feltöltés sikeres!",
"The following image was successfully uploaded" => "Az alábbi kép sikeresen feltöltésre került",
"or use filename" => "vagy fájlnév használata",
"Now enter the image URL" => "A kép URL-jének beírása",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Előnézeti kép (opcionális, felülírja az automatikusan generáltat)",
"Note: Maximum image size is limited to" => "Megjegyzés: kép maximális mérete",
"top" => "felülre",
"Current folder" => "Jelenlegi mappa",
"Folders" => "Mappák",
"Remove Folder" => "Mappa eltávolítása",
"Refresh Cache" => "Cache frissítése",
"Admin folders and bookmarks" => "Mappák és könyvjelzők beállítása",
"a folder" => ": mappa",
"a URL" => ": URL",
"User Contacts Preferences" => "Felhasználói kontaktok beállításai",
"Manage Fields" => "Mezők kezelése",
"Default view" => "Alapértelmezett nézet",
"Send me a message" => "Üzenj nekem!",
"Assign Group" => "Csoport hozzárendelése",
"Personal Wiki Page" => "Személyes Wiki oldal",
"System" => "Rendszer",
"Forum comments" => "Fórum kommentek",
"Personal Information" => "Személyes adatok",
"Use Google Map locator" => "Google Map lokátor használata",
"Your personal Wiki Page" => "Személyes Wiki oldalam",
"Your personal tracker information" => "Személyes űrlap adataim",
"Is email public? (uses scrambling to prevent spam)" => "E-mail nyilvános? (van spamvédelem)",
"Unavailable - please set your e-mail below" => "Nem elérhető - be kell állítani az E-mail címet lentebb",
"Does your mail reader need a special charset" => "Levelezőkliens speciális karakterkészlete:",
"Your preferred language" => "Preferált nyelvem",
"Can you read more languages?" => "További nyelvek amiket értek",
"Other languages you can read (select on the left to add to the list on the right)" => "További olyan nyelvek megadása amiket tudok olvasni (bal oldalon kiválasztás, jobb oldalon a lista)",
"Select language..." => "Nyelv kiválasztása..",
"Note author when reading his mail" => "Szerző értesítése levél olvasásakor",
"My user items" => "Felhasználói tételeim",
"My level" => "Szintem",
"Account Information" => "Felhasználói fiók információ",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "A jelenlegi jelszó megtartásához az \"Új jelszó\" és az \"Új jelszó megerősítése\" mezőket üresen kell hagyni",
"Email address" => "E-mail cím",
"Confirm new password" => "Új jelszó megerősítése",
"Current password (required)" => "Jelenlegi jelszó (szükséges)",
"Change administrative info" => "Fiók adatainak mentése",
"New task" => "Új feladat",
"Task list" => "Feladat lista",
"Admin mode off" => "Adminisztrátor mód ki",
"Admin mode on" => "Adminisztrátor mód be",
"Task help" => "Feladat súgó",
"Empty Trash" => "Lomtár ürítése",
"Received task" => "Kapott feladatok",
"You received this task, please read and execute it" => "Ez a feladat kiosztásra került, olvasás után kérünk hajtsd végre",
"Send task" => "Feladat küldése",
"You send this task to a other user" => "A feladat más felhasználóra lett kiosztva",
"Shared task" => "Megosztott feladat",
"This task is public to a special group" => "Ez a feladat egy adott csoport számára lett kiosztva",
"Accepted by Task User and Creator" => "Elfogadva a feladat felhasználója és létrehozója által",
"Accepted User and Creator" => "Elfogadó felhasználó és létrehozó",
"Task is accepted by user and creator" => "Feladat elfogadva felhasználó és létrehozó által",
"Not Accepted by One User" => "Egy felhasználó nem fogadta el",
"Task is rejected by one user" => "A feladatot egy felhasználó elutasította",
"Waiting for Me" => "Rám vár",
"Task is not accepted by you, read the task and accept or reject it" => "A feladatot még nem fogadtad el, kérünk olvasd el és fogadd vagy utasítsd el",
"Waiting for Other User" => "Másik felhasználóra vár",
"Task is not accepted/rejected by other user" => "Más felhasználó nem fogadta / utasította el a feladatot",
"Admin Mode" => "Adminisztrátor mód",
"Edit task" => "Feladat szerkesztése",
"NOT accept" => "Visszautasítás",
"Remove from Trash" => "Eltávolítás lomtárból",
"Move into Trash" => "Lomtárba helyezés",
"Task saved" => "Feladat elmentve",
"Edit Task" => "Feladat szerkesztése",
"View Task" => "Feladat megtekintése",
"Open a new task" => "Új feladat megnyitása",
"taskId" => "feladat azonosítója",
"Task user" => "Feladat felhasználója",
"Only the creator can delete this task" => "Csak a feladat létrehozója törölheti a feladatot",
"Use start date and time" => "Kezdési dátum és idő használata",
"Use end date and time" => "Befejezési dátum és idő használata",
"Open / In Process" => "Nyitva / Folyamatban",
"Waiting / Not Started" => "Várakozó / Nincs elkezdve",
"Percentage completed" => "Kész (százalékban)",
"Waiting" => "Várakozó",
"Shared for Group" => "Megosztva csoport részére",
"Accepted by User" => "Felhasználó által elfogadva",
"No / Rejected" => "Nem / Elutasítva",
"Accepted by Creator" => "Létrehozó által elfogadva",
"This message will be send to users if you are makeing changes of assigned tasks" => "Ez az üzenet kerül kiküldésre a felhasználók felé ha módosítjuk a kiosztott feladatokat",
"Send message with changes" => "Üzenet küldése a változásokkal együtt",
"Modified by" => "Módosította",
"Marked as deleted" => "Megjelölve töröltként",
"Inform task user by email" => "Feladat felhasználójának tájékoztatása E-mailben",
"You can only view this task" => "Csak a feladat megtekintéséhez elegendő a jogosultság",
"No tasks entered" => "Nincs bevitt feladat",
"Select One" => "Egy kiválasztása",
"Undo Trash" => "Lomtár visszaállítása",
"Show:" => "Megjelenítés:",
"Received" => "Fogadott",
"Submitted" => "Elküldött",
"Shared" => "Megosztott",
"All Shared Tasks" => "Összes megosztott feladat",
"completed (100%)" => "kész (100%)",
"Public for group" => "Publikus csoport részére",
"Use \"watches\" to monitor wiki pages or other objects." => "Használjuk a \"Figyelés\" funkciót wiki oldalak vagy más objektumok monitorozására.",
"Watch new items by clicking the {icon _id=eye} button on specific pages." => "Új figyelendő tételeket a {icon _id=eye} ikonra kattintva vehetünk fel a meghatározott oldalakon",
"Add Watch" => "Figyelés hozzáadása",
"Select event type" => "Esemény típus kiválasztása",
"Watches" => "Figyelések",
"All watched events" => "Összes figyelt esemény",
"A user submits a blog post" => "Felhasználó blogot küld be",
"A user posts a forum thread" => "Felhasználó fórumtémát (thread) nyit",
"A user posts a forum topic" => "Felhasználó fórumtémát (topic) nyit",
"A user edited a wiki page" => "Felhasználó wiki oldalt szerkeszt",
"A user created a wiki page in a language" => "Felhasználó wiki oldalt hoz létre egy nyelven",
"Used space:" => "Felhasznált terület:",
"up to" => "határ",
"no limit for admin" => "adminisztrátor számára nincs határ",
"May need to refresh twice to see changes" => "Lehet, hogy kétszer is frissíteni kell az oldalt a változások láthatóvá tételéhez",
"Add top level bookmarks to menu" => "Felsőszintű könyvjelzők hozzáadása menühöz",
"replace window" => "ablak lecserélése",
"Pos" => "Pozíció",
"This page is being edited by" => "Ezt az oldalt most szerkeszti",
"Proceed at your own peril" => "Csak saját felelősségre...",
"expires:" => "elévül:",
"Weekdays" => "Hétköznapok",
"mon" => "hétfő",
"tue" => "kedd",
"wed" => "szerda",
"thu" => "csütörtök",
"fri" => "péntek",
"sat" => "szombat",
"sun" => "vasárnap",
"Item information" => "Tétel információ",
"Best Position" => "Legjobb pozíció",
"Vote this item" => "Szavazás erre a tételre",
"Highest" => "Legmagasabb",
"Answers" => "Válaszok",
"Q" => "Kérdés",
"A" => "Válasz",
"Forum List" => "Fórum lista",
"Edit Forum" => "Fórum szerkesztése",
"Editing" => "Szerkesztés",
"Post New" => "Új feladása",
"Summary" => "Összefoglalás",
"Editing posts" => "Posztok szerkesztése",
"Moderator Actions" => "Moderátori akciók",
"Move Selected Topics" => "Kiválasztott témák mozgatása",
"Unlock Selected Topics" => "Kiválasztott témák feloldása",
"Lock Selected Topics" => "Kiválasztott témák zárolása",
"Delete Selected Topics" => "Kiválasztott témák törlése",
"Merge" => "Összeolvasztás",
"Merge Selected Topics" => "Kiválasztott témák egyesitése",
"Queued Messages:" => "Sorbanálló üzenetek:",
"Announce" => "Hirdetmény",
"Hot" => "Forró",
"Forum Lock" => "Fórum zárolása",
"No topics yet" => "Még nincsenek témák",
"Jump to forum" => "Ugorj a fórumra",
"Last hour" => "Utóbbi óra",
"Last 24 hours" => "Utóbbi 24 óra",
"Last 48 hours" => "Utóbbi 48 óra",
"prev topic" => "előző téma",
"next topic" => "következő téma",
"Print this page only" => "Csak ezen oldal nyomtatása",
"Print all pages" => "Összes oldal nyomtatása",
"Show posts" => "Bejegyzések megjelenítése",
"Stop Monitor" => "Figyelés felfüggesztése",
"Insert New Item" => "Új tétel hozzáadása",
"Edit Fields" => "Mezők szerkesztése",
"Pending" => "Függő",
"View inserted item" => "Hozzáadott tétel megtekintése",
"Tracker Item:" => "Űrlaptétel:",
"Edit/Delete" => "Szerkesztés / Törlés",
"View Item" => "Tétel megtekintése",
"Items list" => "a tételek listájához",
"close" => "bezárás",
"Add a new" => "Új hozzáadása",
"Show All" => "Összes megjelenítése",
"Refresh now" => "Frissítés most",
"3d browser" => "3d böngésző",
"Show/Hide Left Menus" => "Baloldali menü +/-",
"Show/Hide Right Menus" => "Jobboldali menü +/-",
"Other:" => "Egyéb:",
"Categories:" => "Kategóriák:",
"List authors:" => "Szerzők listázása:",
"Preview your changes." => "Változások előnézete",
"Save the page as a partial translation." => "Oldal mentése részleges fordításként",
"Partial Translation" => "Részleges fordítás",
"Save the page as a completed translation." => "Oldal mentése teljes fordításként",
"Complete Translation" => "Teljes fordítás",
"Save the page, but do not send notifications and do not count it as new content to be translated." => "Oldal mentése, de a kapcsolódó üzenetek nem kerülnek kiküldésre és nem számít lefordítandó tartalomnak",
"Save the page." => "Az oldal mentése",
"Save Draft" => "Piszkozat mentése",
"Cancel the edit, you will lose your changes." => "Szerkesztés visszavonása (a változások elvesznek)",
"Permission denied you cannot view the Tiki calendar" => "Nincs elegendő jogosultság a Tiki naptár megtekintéséhez",
"Administration" => "Adminisztráció",
"Enable/disable Tiki features here, but configure them elsewhere" => "Különböző funkciók aktiválása vagy deaktiválása (a konfigurálásukat máshol kell elvégezni)",
"General preferences and settings" => "Általános tulajdonságok és beállítások",
"User registration, login and authentication" => "Felhasználói regisztráció, bejelentkezés és azonosítás",
"Wiki settings" => "Wiki beállítások",
"Article/CMS settings" => "Cikk/CMS beállítások",
"Poll comments settings" => "Szavazás kommentjeinek beállítása",
"Configuration options for all blogs on your site" => "Beállítási lehetőségek a weblap összes blogja számára",
"Forums settings" => "Fórumok beállítása",
"FAQ comments settings" => "GYIK kommentek beállítása",
"Trackers settings" => "Űrlapok beállítása",
"RSS feeds" => "RSS feed-ek",
"Directory settings" => "Könyvtár beállítása",
"Meta Tags settings" => "Meta címkék beállítása",
"Search settings" => "Keresés beállításai",
"Score settings" => "Pontszámozás beállítása",
"Community settings" => "Közösség beállításai",
"Calendar settings" => "Naptár beállítása",
"Intertiki settings" => "Intertiki beállítások",
"Freetags settings" => "Címkék beállítása",
"Configure Site Ads and Banners" => "Hirdetések és bannerek konfigurálása",
"silver" => "ezüst",
"Click here to delete the category:" => "Kategória törlésének megerősítése:",
"No chart indicated" => "Nincs megjeleníthető sláger",
"Upload failed" => "Sikertelen feltöltés",
"Detected, Version:" => "Felismerve, Verzió:",
"Not detected." => "Nem található",
"Tag already exists" => "A tag már létezik ",
"Tag not found" => "nem találom a tag-ot",
"No menu indicated" => "Nincs megjeleníthető menü",
"No newsletter indicated" => "Nincs megjeleníthető hírlevél",
"Invalid email" => "Érvénytelen E-mail",
"No poll indicated" => "Nincs megjeleníthető szavazás",
"safe" => "biztonságos",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "Nem sikerült annak ellenőrzése hogy az upload_tmp_dir elérheto-e webböngészőn keresztül. A biztonság kedvéért ajánlott a webszerver beállításainak ellenőrzése",
"risky" => "kockázatos",
"allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "Az allow_url_fopen használható távoli adatok vagy szkriptek feltöltésére. Ha nem használjuk a blog funkciót akkor inkább kapcsoljuk ki",
"Permission denied you cannot view this page" => "Magasabb szintű jogosultágra van szükség az oldal megtekintéséhez",
"Permission denied you cannot edit this page" => "Magasabb szintű jogosultágra van szükség az oldal szerkesztéséhez",
"You must specify a page name, it will be created if it doesn't exist." => "Meg kell adni egy oldalnevet. Ha nincs még ilyen nevű oldal akkor új oldal lesz létrehozva ezen a néven.",
"page not added (Exists)" => "a lap nincs hozzáadva (létezik)",
"No survey indicated" => "Nincs megjeleníthető kérdoív",
"You don't have permission to use this feature" => "A funkció használatához magasabb szintű jogosultágra van szükség",
"No tracker indicated" => "Nincs megjeleníthető űrlap",
"Group already exists" => "A csoport már létezik",
"User doesn't exist" => "A felhasználó nem létezik",
"No records were found. Check the file please!" => "Nincsenek rekordok. Ellenőrizzük a fájlt!",
"User login is required" => "Ehhez be kell jelentkezni",
"Password is required" => "Szükséges a jelszó megadása",
"Email is required" => "Szükséges az E-mail cím megadása",
"User is duplicated" => "A felhasználó többször létezik",
"New %s created with %s %s." => "Új %s létrehozva, a hozzátartozó %s : %s",
"Impossible to create new %s with %s %s." => "Nem lehetséges létrehozni %s ezzel: %s %s.",
"password" => "jelszó",
"rss feed disabled" => "az rss adagoló ki van kapcsolva",
"Unknown group" => "Ismeretlen csoport",
"Group doesn't exist" => "A csoport nem létezik",
"The page cannot be found" => "A lap nem található",
"You can't post in any blog maybe you have to create a blog first" => "Új blogot kell készíteni a posztoláshoz!",
"Permission denied you cannot post" => "Magasabb szintű jogosultágra van szükség a posztoláshoz",
"Permission denied you cannot edit this post" => "Magasabb szintű jogosultágra van szükség a poszt szerkesztéséhez",
"Top visited blogs" => "Leglátogatottabb blogok",
"Last posts" => "Legutóbbi posztok",
"Top active blogs" => "Legaktívabb blogok",
"TOP" => "Forrás",
"Nothing tagged yet" => "Még nincs felcímkézett tartalom",
"Permission denied you cannot access this gallery" => "Magasabb szintű jogosultágra van szükség a galériához való hozzáféréshez",
"Permission denied you can not view this section" => "Magasabb szintű jogosultágra van szükség a szekció megtekintéséhez",
"Permission denied you cannot remove images from this gallery" => "Magasabb szintű jogosultágra van szükség képek eltávolításához ebbol a galériából",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Magasabb szintű jogosultágra van szükség az elonézetek Újraépítéséhez",
"Permission denied you cannot rotate images in this gallery" => "Magasabb szintű jogosultágra van szükség a képek forgatásához ebben a galériában",
"No image indicated" => "Nincs kép feltüntetve",
"Permission denied you cannot move images from this gallery" => "Magasabb szintű jogosultágra van szükség képek mozgatásához ebbol a galériából",
"Top authors" => "Remeklo szerzők",
"ERROR: you must include a subject or a message at least" => "Hiba: meg kell adni legalább egy üzenetet vagy tárgyát",
"This feature has been disabled" => "Ez a funkció ki van kapcsolva",
"Must enter a name to add a site" => "Meg kell adni egy nevet új weblap hozzáadásához",
"Must enter a url to add a site" => "Meg kell adni egy URL-t új weblap hozzáadásához",
"URL already added to the directory. Duplicate site?" => "Ez az URL már egyszer fel lett véve! Szerepeljen mégegyszer?",
"Must select a category" => "Ki kell választani egy kategóriát",
"Article not found" => "Cikk nem található",
"Permission denied you cannot edit this article" => "Magasabb szintű jogosultágra van szükség a cikk szerkesztéséhez",
"You do not have permissions to edit banners" => "Nincs Elegendő a jogosultság bannerek szerkesztéséhez",
"Banner not found" => "Banner nem található",
"You do not have permission to edit this banner" => "Nincs Elegendő a jogosultság a banner szerkesztéséhez",
"Permission denied you cannot create or edit blogs" => "Magasabb szintű jogosultágra van szükség blogok létrehozásához és szerkesztéséhez",
"Permission denied you cannot edit this blog" => "Magasabb szintű jogosultágra van szükség a blog szerkesztéséhez",
"Invalid request to edit an image" => "A kép szerkesztéséhez érvénytelen kérés érkezett",
"Permission denied you cannot edit images" => "Magasabb szintű jogosultágra van szükség a képek szerkesztéséhez",
"Permission denied you can edit images but not in this gallery" => "A jogosultság általában elég képek szerkesztéséhez de ebben a galériában sajnos nem",
"Failed to edit the image" => "A kép módosítási kísérlete sikertelen",
"Permission denied to use this feature" => "Magasabb csoportszintű jogosultágra van szükséged, hogy ezt a funkciót használhasd",
"Language created" => "Az új nyelv létre lett hozva",
"No question indicated" => "Nincs kérdés feltüntetve",
"You have to create a topic first" => "Először témát kell létrehoznod",
"You do not have permission to do that" => "Ehhez több jogosultságra van szükség",
"You do not have permission to read the template" => "A sablonok megtekintéséhez több jogosultságra van szükség",
"Translation in progress." => "Fordítás folyamatban",
"The SandBox is disabled" => "A Homokozó ki van kapcsolva",
"Cannot edit page because it is locked" => "Ezt az oldalt nem lehet szerkeszteni mivel zárolva van",
"Page already exists. Go back and choose a different name." => "Ilyen nevű oldal már létezik ezért más nevet kell választani",
"The translation set already contains a page in this language." => "A fordítási készlet már tartalmaz egy oldalt ezen a nyelven.",
"Top visited file galleries" => "Leglátogatottabb fájlgalériák",
"Most downloaded files" => "Legtöbbször letöltött fájlok",
"No forum indicated" => "Nincs fórum feltüntetve",
"Forum posts" => "Fórum hozzászólások",
"You must be logged in to use this feature" => "Először <a href=\"tiki-login_scr.php\" alt=\"Login\">be kell jelentkezni</a> a funkció használatához",
"No user indicated" => "Nincs felhasználó feltüntetve",
"first uploaded image" => "először feltöltött kép",
"last uploaded image" => "utoljára feltöltött kép",
"first image" => "első kép",
"last image" => "utolsó kép",
"random image" => "véletlenszerű kép",
"Permission denied you cannot create galleries and so you cant edit them" => "Magasabb szintű jogosultágra van szükség galéria létrehozásához és szerkesztéséhez",
"Permission denied you cannot edit this gallery" => "Magasabb szintű jogosultágra van szükség a galéria szerkesztéséhez",
"Permission denied you cannot remove this gallery" => "Magasabb szintű jogosultágra van szükség a galéria eltávolításához",
"Top images" => "Legjobb képek",
"Last images" => "Új képek",
"Back to preferences" => "Vissza a beállításokhoz",
"overwriting old page" => "régi lap felülírása",
"Permission denied you cannot remove articles" => "Magasabb szintű jogosultágra van szükség a cikkek eltávolításához",
"Permission denied you cannot remove banners" => "Nem távolíthatsz el banner-eket! Hozzáférés megtagadva...",
"Permission denied you cannot remove this blog" => "Magasabb szintű jogosultágra van szükség a blog törléséhez",
"Delete comments" => "Kommentek letöltése",
"Approved Status" => "Jóváhagyási státusz",
"Queued" => "Sorban áll",
"Non-existent gallery" => "Nem létező galéria",
"The file is already locked by %s" => "A fájlt már zárolta: %s",
"Remove file: " => "Fájl eltávolítása: ",
"You cannot admin blogs" => "Magasabb szintű jogosultágra van szükség a blogok adminisztrálásához",
"You have to enable cookies to be able to login to this site" => "Engedélyezni kell a sütiket az oldal használatához",
"Invalid password" => "Érvénytelen jelszó",
"You must first setup MapServer" => "Először be kell állítani a Térképszervert",
"invalid mapfile name" => "érvénytelen mapfile név",
"edit" => "szerkesztés",
"Please create a directory named '.\$prefs['map_path'].' to hold your map files." => "Létre kell hozni egy könyvtárat a térképfájlok részére a következő néven '.\$prefs['map_path'].'",
"You do not have permissions to view the maps" => "Nincs elegendő jogosultság a térképek megtekintéséhez",
"Maps feature is not correctly setup : Maps path is missing." => "Térkép funkció nincs megfelelően beállítva, hiányzik az útvonal",
"mapfile name incorrect" => "mapfile név nem megfelelő",
"This mapfile already exists" => "Ez a mapfile már létezik",
"You do not have permission to write to the mapfile" => "Nincs elegendő jogosultság a mapfile írásához",
"You do not have permission to delete the mapfile" => "Nincs elegendő jogosultság a mapfile törléséhez",
"I could not make a copy" => "Másolat létrehozása nem sikerült",
"You do not have permission to read the mapfile" => "Nincs elegendő jogosultság a mapfile olvasásához",
"map edit" => "térkép szerkesztése",
"You dont have permission to do that" => "Nincs elegendő jogosultság ehhez az akcióhoz",
"Tiki RSS feed for maps" => "Tiki RSS feed térképek számára",
"List of maps available." => "Rendelkezésre álló térképek listája",
"You do not have permissions to view the layers" => "Nincs elegendő jogosultság a rétegek megtekintéséhez",
"You do not have permissions to delete a file" => "Nincs elegendő jogosultság a fájl törléséhez",
"File not found" => "Fájl nem található",
"You do not have permissions to create a directory" => "Nincs elegendő jogosultság könyvtár létrehozásához",
"The Directory is not empty" => "A könyvtár nem üres",
"You do not have permissions to delete a directory" => "Nincs elegendő jogosultság könyvtár törléséhez",
"You do not have permissions to create an index file" => "Nincs elegendő jogosultság index fájl létrehozásához",
"Invalid file name" => "Érvénytelen fájlnév",
"Invalid files to index" => "Érvénytelen indexelendő fájlok",
"I do not know where is gdaltindex. Set correctly the Map feature" => "Gdaltindex nem található. Állítsuk be helyesen a Térkép funkciót",
"I could not create the index file" => "Az index fájl létrehozása nem sikerült",
"Must be logged to use this feature" => "Be kell jelentkezni a funkció használatához",
"You must log in to use this feature" => "Először <a href=\"tiki-login_scr.php\">be kell jelentkezni</a> ehhez!",
"You do not have permission to view other users data" => "Nincs Elegendő jogosultság más felhasználók adatainak a megtekintéséhez",
"You must be logged in to subscribe to newsletters" => "Először <a href=\"tiki-login_scr.php\" alt=\"Login\">be kell jelentkezni</a> hírlevelekre való feliratkozáshoz",
"No server indicated" => "Nincs szerver feltüntetve",
"Cannot connect to" => "Nem tudok ide csatlakozni:",
"Cannot get messages" => "Nem tudom letölteni az üzeneteket",
"File is too big" => "A megadott fájl túl nagy!",
"No article indicated" => "Nincs ilyen cikk",
"Article is not published yet" => "A cikk még nincs publikálva",
"No post indicated" => "Nincs hozzászólás feltüntetve",
"Blog not found" => "Nincs találat",
"No pages indicated" => "Nincs oldal feltüntetve",
"The passwords don't match" => "Figyelem, hogy egyezzenenek a megadott jelszavak!",
"empty" => "üres",
"last version" => "legutóbbi verzió",
"Permission denied you cannot remove versions from this page" => "Magasabb szintű jogosultágra van szükség az oldal verzióinak eltávolításához",
"Cannot rename page maybe new page already exists" => "Oldal átnevezése nem sikerült, lehet már létezik oldal ezen a néven",
"Error Message" => "Hibaüzenet",
"Page must be defined inside a structure to use this feature" => "Az oldalt egy struktúrán belül kell elhelyezni ahhoz hogy ezt a funkció használni lehessen",
"You cannot take this quiz twice" => "Ezt a kvízt nem lehet kétszer kitölteni!",
"Please create a category first" => "Előbb létre kell hozni egy kategóriát",
"Unknown user" => "Ismeretlen felhasználó",
"Password has been changed" => "A jelszó megváltoztatásra került",
"Email is set to %s" => "E-mail beállítva: %s",
"The passwords did not match" => "A jelszavak nem egyeznek",
"no" => "nem",
"A new page is created in a language" => "Új oldal jött létre egy adott nyelven",
"No blog indicated" => "Nincs blog feltüntetve",
"Permission denied you cannot remove the post" => "Magasabb szintű jogosultágra van szükség a poszt törléséhez",
"No cache information available" => "Nincs cache-információ",
"No thread indicated" => "Nincs fórumtéma feltüntetve",
"Top pages" => "Leglátogatottabb oldalak",
"Last pages" => "Legutóbbi oldalak",
"###end###"=>"###end###");
?>
