<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Wiki page" => "Sivu",
"pageviews" => "sivunäyttöjä",
"Security check failed!" => "Turvallisuus tarkistus epäonnistui!",
"Your Tiki account information for" => "Sinun tilisi tiedot",
"A password reminder email has been sent " => "Salasanan muistutus lähetetty ",
"A new password has been sent " => "Uusi salasana on lähetetty ",
"You have to type a searchword" => "Kirjoita etsintä sana",
"Upload was not successful (maybe a duplicate file)" => "Lähetys ei onnistunut (ehkä sillä nimellä on tiedosto)",
"You have to provide a name to the image" => "Sinun on annettava nimi kuvalle",
"Invalid password.  You current password is required to change your email address." => "Väärä salasana.  Nykyinen salasanasi tarvitaan voidaksesi muuttaa sähköpostiosoitetta.",
" new topic:" => " uusi aihe:",
"topic:" => "aihe:",
"You are not permitted to edit someone else\\'s post!" => "Et voi muokata kenenkään toisen posteja!",
"Only an admin can remove a thread." => "Vain ylläpito voi poistaa ketjun.",
"forum topic" => "foorumin aihe",
"New article submitted at " => "Uusi artikkeli lisätty ",
" line " => " rivi ",
"Error: Invalid" => "Virhe: Väärä",
"Error: No" => "Virhe: Ei",
"permission." => "lupa.",
"Error: Call to hw_page_fetch_by_id failed!" => "Virhe: Kutsu hw_page_fetch_by_id epäonnistui!",
"New message arrived from " => "Uusi viesti vastaanotettu: ",
"Welcome to " => "Tervetuloa ",
"Bye bye from " => "Heippa ",
" at " => "  ",
"Insert articles into a wikipage" => "Lisää artikkeli sivulle",
"note: those parameters are exclusive" => "huomio: nuo parametrit ovat valikoivia",
"__key__ | __defaults__ | __comments__\n" => "__key__ | __oletus__ | __kommentit__\n",
"Are you sure you want to delete this attachment?" => "Oletko varma, että haluat poistaa liitteen?",
"Click here to delete this attachment" => "Paina tästä, poistaaksesi liitteen",
"Posted comments" => "Lähetetyt kommentit",
"Are you sure you want to delete this comment?" => "Oletko varma, että haluat poistaa kommentin?",
"Click here to delete this comment" => "Paina tästä, poistaaksesi kommentin",
"reply to this" => "vastaa tähän",
"parent" => "isäntä",
"Reply to parent comment" => "Vastaa isäntä kommenttiin",
"Are you sure you want to delete this copyright?" => "Oletko varma, että haluat poistaa tämän copyrightin?",
"Click here to delete this copyright" => "Paina tästä, poistaaksesi copyright",
"compose message tpl" => "muodosta viesti tpl",
"messages tpl" => "viestien tpl",
"Return to messages" => "Palaa viesteihin",
"Unflagg" => "Poista merkki",
"Click here to unassign this module" => "Paina tästä, poistaaksesi modulin",
"Admin structures" => "Hallitse rakenteita",
"Reduce area width" => "Pienennä alueen leveyttä",
"Enlarge area width" => "Suurenna alueen leveyttä",
"Blog settings" => "Blogi asetukset",
"In blog listing show user as" => "Blogi listalla näytä käyttäjät",
"CMS settings" => "CMS asetukset",
"FAQs settings" => "UKK asetukset",
"FAQ comments" => "UKK kommentit",
"Email Encoding" => "Sähköpostin koodaus",
"Time Zone" => "Aika Vyöhyke",
"Server time zone" => "Palvelimen Aika Vyöhyke",
"Time Zone Map" => "Aika Vyöhyke Kartta",
"Remind passwords by email" => "Muistuta salasanoista sähköpostilla",
"Poll settings" => "Poll settings",
"Append CSS file to feed urls" => "Lisää CSS urlin syötteeseen",
"Publisher" => "Julkaisija",
"Create a tag for the current wiki" => "Luo kiinnike nykyiseen sivustoon",
"Restore the wiki" => "Palauta wiki",
"Wiki comments settings" => "Wiki kommenttien asetukset",
"Wiki page list configuration" => "Wiki sivulistaus asetukset",
"Ranking" => "Arvostus",
"Warn on edit" => "Varoita muokkauksesta",
"Are you sure you want to delete this rule?" => "Oletko varma, että haluat poistaa tämän säännön?",
"List Calendars" => "Listaa Kalenterit",
"Are you sure you want to delete this calendar?" => "Oletko varma, että haluat poistaa tämän kalenterin?",
"Delete item from category?" => "Poista luokan osa?",
"Are you sure you want to delete this category?" => "Oletko varma, että haluat poistaa tämän luokan?",
"admin charts tpl" => "ylläpidä kaavio tpl",
"ChatAdmin" => "JutYlläp",
"ChatAdmin tpl" => "JutYlläp tpl",
"Click here to delete this channel" => "Paina tästä poistaaksesi tämän kanavan",
"Are you sure you want to delete this channel?" => "Oletko varma, että haluat poistaa tämän kanavan?",
"admin content templates tpl" => "ylläpidä sisältö mallien tpl",
"Click here to delete this template" => "Paina tästä poistaaksesi tämän mallin",
"Are you sure you want to delete this template?" => "Oletko varma, että haluat poistaa tämän mallin?",
"Are you sure you want to delete this cookie?" => "Oletko varma, että haluat poistaa tämän keksin?",
"Click here to delete this cookie" => "Paina tästä poistaaksesi tämän keksin",
"admin Drawings" => "ylläpidä Piirroksia",
"Are you sure you want to delete this drawing?" => "Oletko varma, että haluat poistaa tämän piirroksen?",
"Click here to delete this drawing" => "Paina tästä poistaaksesi tämän piirroksen",
"AdminDSN" => "YlläpidäDSN",
"Are you sure you want to delete this dsn?" => "Oletko varma, että haluat poistaa tämän dsn:n?",
"admin ExternalWiki" => "ylläpidä UlkoinenWiki",
"tiki admin external wikis tpl" => "tiki ylläpidä ulkoinen wiki tpl",
"Are you sure you want to delete this external wiki?" => "Oletko varma, että haluat poistaa tämän ulkoisen wikin?",
"admin forums tpl" => "ylläpidä foorumien tpl",
"Threads can be voted" => "Ketjuja voi äänestää",
"Are you sure you want to delete this forum?" => "Oletko varma, että haluat poistaa tämän foorumin?",
"admin hotwords tpl" => "ylläpidä hotwords tpl",
"Are you sure you want to delete this hotword?" => "Oletko varma, että haluat poistaa tämän hotword?",
"admin HtmlPages" => "ylläpidä HtmlSivuja",
"admin HtmlPages tpl" => "ylläpidä HtmlSivun tpl",
"Are you sure you want to delete this HTML page?" => "Oletko varma että haluat poistaa tämän HTML sivun?",
"Are you sure you want to delete this repository?" => "Oletko varma, että haluat poistaa tämän säilytyspaikan?",
"Click here to delete this repository" => "Paina tästä poistaaksesi tämän säilytyspaikan",
"Click here to delete this rule" => "Paina tästä poistaaksesi tämän säännön",
"admin featured links tpl" => "ylläpidä ominaisuus linkkien tpl",
"WebMail accounts" => "WebMail tilit",
"admin mailin tpl" => "ylläpidä mail tpl",
"Are you sure you want to delete this menu?" => "Oletko varma, että haluat poistaa tämän valikon?",
"Click here to delete this menu" => "Paina tästä poistaaksesi tämän valikon",
"Edit tpl" => "Muuta tpl",
"Click here to edit this menu" => "Paina tästä muokataksesi tätä valikkoa",
"Click here to configure this menu" => "Paina tästä muuttaaksesi tämän valikon kokoonpanoa",
"admin modules tpl" => "ylläpidä moduulien tpl",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br/>\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Huomaa 1</b>: jos annat käyttäjien muokata moduuleja liitetyt\nmoduulit eivät reagoi näytöllä ennen kuin muokkaat niitä\nMyTiki->modules valikosta.<br/>\n<b>Huomaa 2</b>: Jos liität moduuleja ryhmille pidä huoli että sinulla on \nvalinta merkattuna 'näytä kaikki moduulit kaikille aina'\nYlläpito->Yleiset\n",
"Add all your site users to this newsletter (broadcast)" => "Lisää kaikki sivuston käyttäjät tähän uutislehteen (lähetykseen)",
"Add users" => "Lisää käyttäjiä",
"admin newsletters tpl" => "ylläpidä uutislehden tpl",
"admin notifications tpl" => "ylläpidon ilmoitus tpl",
"admin polls tpl" => "ylläpidä äänestyksien tpl",
"tiki admin quicktags tpl" => "ylläpidä pikalisien tpl",
"admin RSSmodules tpl" => "ylläpidä RSSmoduulien tpl",
"admin structures tpl" => "ylläpidä rakenne tpl",
"admin surveys tpl" => "ylläpidä tutkimusten tpl",
"Create New Survey:" => "Luo Uusi Tutkimus:",
"stat" => "tila",
"admin topics tpl" => "ylläpidä aiheiden tpl",
"(Dropdown options : list of items separated with commas)" => "(Alasveto vaihtoehdot : lista osista eroteltuna pilkulla)",
"(Image options : xSize,ySize indicated in pixels)" => "(Kuva vaihtoehdot : xKoko,yKoko annetaan pixeleinä)",
"Show status when listing tracker items?" => "Näytä tila kun listataan kortiston osia?",
"admin groups tpl" => "ylläpidä ryhmien tpl",
"Add New Group" => "Lisää Uusi Ryhmä",
"Edit this group:" => "Muokkaa tätä ryhmää:",
"Are you sure you want to delete this group?" => "Oletko varma, että haluat poistaa tämän ryhmän?",
"admin users tpl" => "ylläpidä käyttäjä tpl",
"File gals" => "Tiedosto gal",
"Image gals" => "Kuva gal",
"Comm" => "Komm",
"Cms" => "Cms",
"ExtWikis" => "ExtWikit",
"assgn" => "assgn",
"Klick to enlarge" => "Paina suurentaaksesi",
"You can include the image in an HTML or Tiki page using" => "Voit lisätä kuvan HTML tai normaali sivulle käyttäen",
"Calendars Panel" => "Kalenterien Paneeli",
"Events Panel" => "Tapahtumien Paneeli",
"Add Calendar Item" => "Lisää Kalenterin Osa",
"-1m" => "-1m",
"-7d" => "-7d",
"-1d" => "-1d",
"+1d" => "+1d",
"+7d" => "+7d",
"+1m" => "+1m",
"today" => "tänään",
"save a custom copy" => "tallenna muunneltu kopio",
"For more information, please see <a\nhref=\"http://www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\non <a href=\"http://www.tikiwiki.org\">Tikiwiki.org</a>." => "Lisätietoja, katso <a\nhref=\"http://www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\non <a href=\"http://www.tikiwiki.org\">Tikiwiki.org</a>.",
"use square brackets for an" => "käytä hakasulkuja",
"link_description" => "linkki_kuvaus",
"Prevents parsing data" => "Estää tiedon jäsentämisen",
"Reuse question" => "Uudellen käytä kysymys",
"Edit Submissions" => "Muokkaa Ehdotuksia",
"file galleries tpl" => "tiedosto galleria tpl",
"act status" => "act tila",
"running" => "käynnissä",
"Add scaled images size X x Y" => "Lisää muutetut kuvat kokoa X x Y",
"admin DynamicContent" => "ylläpidä MuuttuvaSisältö",
"op" => "op",
"MyTikiDoc" => "OmaSivuOhje",
"Comparing versions" => "Verrataan versioita",
"Actual_version" => "Varsinainen_versio",
"Diff to version" => "Erot versioon",
"Send Objects" => "Lähetä Kohteet",
"The cord" => "Nauha",
"Show chart for the last " => "Näytä kaavio jossa viimeiset ",
"days (0=all)" => "päivää (0=all)",
"Control by Object" => "Hallinta Kohteella",
"Control by category" => "Hallinta Luokalla",
"use filename" => "käytä tiedostonimeä",
"remove bookmark" => "poista kirjanmerkki",
"Use dbl click to edit pages" => "Käytä kaksoisklikkausta muokataksesi sivuja",
"Change your email" => "Muuta sähköposti osoitettasi",
"change email" => "muuta sähköposti",
"Configure this page" => "Konfiguroi tätä sivua",
"All tasks" => "Kaikki tehtävät",
"mark as done" => "merkitse tehdyksi",
"open tasks" => "avaa tehtävät",
"Add or edit a task" => "Lisää tai muokkaa tehtävää",
"perm" => "pysyvä",
"FAQ Questions" => "UKK kysymykset",
"FAQ Answers" => "UKK Vastaukset",
"Show suggested questions/suggest a question" => "Näytä ehdotettuja kysymyksiä/ehdotettua kysymystä",
"Hide suggested questions" => "Piilota ehdotetut kysymykset",
"this post was reported" => "tämä lähetys oli raportoitu",
"report this post" => "raportoi tämä lähetys",
"checked" => "merkitty",
"unchecked" => "merkitsemätön",
"Are you sure you want to delete this tracker?" => "Oletko varma, että haluat poistaa tämän kortiston?",
"Click here to delete this tracker" => "Paina tästä poistaaksesi tämän kortiston",
"Editing tracker item" => "Muuta kortiston osaa",
"Click here to edit this comment" => "Paina tästä muokataksesi tätä kommenttia",
"Webmail Doc tpl" => "Webmail Doc tpl",
"Are you sure you want to delete this contact?" => "Oletko varma, että haluat poistaa tämän yhteyden?",
"Click here to delete this contact" => "Paina tästä poistaaksesi yhteys",
"someone from" => "joku",
"requested a reminder of the password for the" => "pyydetty muistutus salasanasta",
"since this is your registered email address we inform that the" => "mikäli tämä on sinun rekisteröity sähköpostiosoitteesi tiedotamme",
"password for this account is" => "salasana tähän jäsenyyteen on",
"Information:" => "Tiedot:",
"You can edit the page following this link:" => "Voit muokata sivua seuraamalla tätä linkkiä:",
"Diff:" => "Erot:",
"The new page content is:" => "Uuden sivun sisältö on:",
"You can view the page following this link:" => "Voit katsoa sivua seuraavasta linkistä:",
"You can view the page by following this link:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}" => "Voit katsoa sivua seuraamalla tätä linkkiä:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}",
"You can edit the page by following this link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "Voit muokata sivua seuraamalla linkkiä:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"You can view a diff back to the previous version by following\nthis link:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}" => "Voit katsoa erot edelliseen versioon\ntästä linkistä:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}",
"Are you sure you want to delete this directory?" => "Oletko varma, että haluat poistaa tämän hakemiston?",
"Are you sure you want to delete this file?" => "Oletko varma, että haluat poistaa tämän tiedoston?",
"More info about" => "Lisää tietoa koskien",
"idle" => "odottava",
"Click the :: option on the menu for more options." => "Paina :: vaihtoehtoa valikosta saadaksesi lisää vaihtoehtoja.",
"Please also see" => "Katso myös",
"Admin->Modules" => "Ylläpidä->Moduuleja",
"Insert javascript into a page on the fly! You can both include an external file and/or just type the javascript in between the tags" => "Lisää javascript:in lennossa sivulle! Voit molempia joko antaa tiedostonimen/tai kirjoittaa suoraan javascripti tagien väliin",
"typed-inline javascript" => "kirjoitettu-sisä javascript",
"%A %d %B, %Y" => "%A %d %B, %Y",
"%A %d %B, %Y[%H:%M:%S %Z]" => "%A %d %B, %Y[%H:%M:%S %Z]",
"%a %d %b, %Y" => "%a %d %b, %Y",
"%a %d %b, %Y[%H:%M %Z]" => "%a %d %b, %Y[%H:%M %Z]",
"You do not have permission to write the template\".': '.\$file));\n\t\t\$smarty->display('error.tpl');\n\t\tdie;\n\t}\n\t\$_REQUEST[\"data\"] = str_replace(\"\r\n" => "Oikeutesi eivät riitä kirjoittamaan malleja\".': '.\$file));\n\t\t\$smarty->display('error.tpl');\n\t\tdie;\n\t}\n\t\$_REQUEST[\"data\"] = str_replace(\"\r\n",
"Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\r\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\r\n\r\nDone! You should be logged in." => "Paina seuraavaa linkkiä varmistaaksesi toivomuksesi uudesta salasanasta ja mene ruudulle kirjoittamaan uusi \"pysyvä\" salasana. Valitse salasanaksi sellainen jonka vain sinä tiedät äläkä kerro sitä muille.\r\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\r\n\r\nTehty! Olet kirjautunut sisään.",
"from\r\nthe mapfile:" => "\r\nkarttatiedostosta:",
"Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://dev.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site." => "Katso <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://dev.tikiwiki.org/tiki-index.php?page=Features\">ominaisuuden kehittelystä</a> Tikin kehittäjien toimesta.",
"Create a group for each user <br />(with the same\r\nname as the user)" => "Luo ryhmä jokaiselle käyttäjälle <br />(jolla on sama\r\nnimi kuin käyttäjä)",
"WARNING : Old and New trackers cannot coexist. Trackers created with new library\r\nwill not work with old library and conversely" => "WAROITUS : Vanha ja Uusi kortisto eivät voi esiintyä yhtaikaa. Uudella kirjastolla luodut kortistot\r\neivät toimi vanhojen kanssa ja päinvastoin",
"An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">ominaisuus linkki</a> ominaisuus." => "Helpoin tapa tuoda aineistoa toiselta sivustolta suoraan sivuston sivuksi <a class=\"rbox-link\" href=\"tiki-admin_links.php\">ominaisuuslinkit</a> ominaisuus.",
"To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "Käyttääksesi <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduulia</a> tai mallia, käytä {literal}{menu id=x}{/literal}, missä x on valikon ID. Käyttääksesi <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, voit käyttää yhtä näistä kolmesta esitystavasta:",
"\r\n<b>Note 1</b>: if you allow your users to configure modules then assigned\r\nmodules won't be reflected in the screen until you configure them\r\nfrom MyTiki->modules.<br />\r\n<b>Note 2</b>: If you assign modules to groups make sure that you\r\nhave turned off the option 'display modules to all groups always'\r\nfrom Admin->General\r\n" => "\r\n<b>Huomaa 1</b>: jos annat käyttäjien muokata moduulien asetuksia\r\nmoduulit eivät reagoi näytöllä ennen kuin ne määritellään\r\nOmaValikko->moduulit.<br />\r\n<b>Huomaa 2</b>: Jos liität moduuleja ryhmille \r\non valinta 'näytä moduulit kaikille aina' pois päältä\r\nYlläpito->Yleiset\r\n",
"tracker name must be unique, field names must be unique \r\nfor a tracker and they must be valid in SQL" => "kortiston nimi on oltava ainutkertainen, samoin kenttien nimet \r\nkortistossa, nimien on sovelluttava SQL kyselyyn",
"Note: if you want to use images please save the post first and you\r\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\r\nor use the image URL to include images using the WYSIWYG editor" => "Huomaa: jos haluat käytää kuvia niin tallenna lähetys ensin ja voit\r\nmuokata/lähetettyjä kuvia. Käytä &lt;img&gt; leikettä lisätäksesi kuva tekstialueelle\r\ntai käytä kuvan URL osoitetta suoraan WYSIWYG muokkaimessa",
"Your message has been queued for approval, the message will be posted after\r\na moderator approves it." => "Viestisi on laitettu hyväksyntä jonoon, se lähetetään kun\r\na ylläpitäjä hyväksyy sen.",
"www.plazes.com" => "www.plazes.com",
"ver" => "ver",
"Jukebox" => "Jukebox",
"Workspace not selected" => "Työaluetta ei valittu",
"Permission denied you cannot edit assignments" => "Oikeutesi eivät riitä liitosten muokkaamiseen",
"Permission denied you cannot create assignments" => "Oikeuteisi eivät riitä luomaan liitoksia",
"Permission denied you cannot remove assignments" => "Oikeutesi eivär riitä poistamaan liitoksia",
"Workspace not found" => "Työaluetta ei löytynyt",
"Resource name not selected" => "Resurssin nimeä ei valittu",
"Resource not found" => "Resurssia ei löytynyt",
"Name requiered" => "Tarvitaan nimi",
"Module not set" => "Moduulia ei ole asetettu",
"Closed Workspace" => "Suljettu Työalue",
"Workspace type not found" => "Työalue tyyppiä ei löytynyt",
"Code in use, please select a different code" => "Koodi on käytössä, valitse toinen koodi",
"Code not selected" => "Koodia ei valittu",
"Sorry, the currency \$currency is not available." => "Valitan, valuutta \$currency ei ole saatavilla.",
"Sorry, you are not registered into currency \$currency." => "Valitan, et ole rekisteröitynyt valuuttaan \$currency.",
"DNS check failed for %s" => "DNS tarkistus epäonnistui %s",
"Request failed for %s" => "Pyyntö epäonnistui %s",
"Project Group for " => "Ryhmä Hanke ",
"Project Admin Group for " => "Hankkeen Ylläpito Ryhmä ",
"no description" => "ei kuvausta",
"Image options: xListSize,yListSize,xDetailsSize,yDetailsSize indicated in pixels." => "Kuva vaihtoehdot: xListaaKoko,yListaaKoko,xYksityiskohtainenKoko,yYksityiskohtainenKoko näytetään pixeleinä.",
"Puts an anchor and links to the anchor onto a wiki page" => "Laittaa ankkurin ja linkittää ankkurin sivulle",
"~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,aihe=>aiheNimi)}{ARTICLES} Laittaa artikkelit sivulle",
"Insert CSS styles into a wiki page on the fly! You can both include an external file and/or just type the CSS in between the tags" => "Liittää CSS tyylin sivulle lennossa! Voit molempia joko liittää ulkoisen tiedoston/tai kirjoittaa CSS määrittelyn tagien väliin",
"typed-inline style" => "kirjoitettu-sisä tyylinä",
"Insert an iframe into a wiki page. Put the web address in between the tags (the URL of the page you want to show." => "Laittaa iframe:in sivulle. Laittaa verkko osoitteen tagien väliin (eli URL:in sivusta jonka haluat näyttää.",
"Insert an AUTO-SIZING iframe into a wiki page. Only works right for internal pages (those under the same domain as your Tiki.)<br />The iframe height sizes to the height of the contained page. Put the web address in between the tags (the URL of the page you want to show." => "Laittaa AUTO-SIZING iframe:in sivulle. Toimii oikein vain sisäisillä sivuilla (omalla sivustolla.)<br />iframe korkeus on sisältönä olevan sivun korkeus. Laittaa verkko osoitteen tagien väliin (sivun URL jonka haluat näyttää.",
"Insert javascript into a page." => "Lisää javascript sivulle.",
"Loads a complete WebPage into the Wiki page.<BR>Parameter: page=Page to load, replaceLink=add this URL to all Links, onlyBody='yes' search for body tag to diplay only body." => "Lataa koko verkkosivun sivuston sivulle.<BR>Parametri: sivu=Ladattava sivu, korvaaLinkki=lisää tämä URL kaikkiin Linkkeihin, vainRunko='kyllä' etsii runko tagin näyttääkseen vain rungon.",
"Displays a Quicktime Movie on the wiki page" => "Näyttää Quicktime Elokuvan sivulla",
"URL to Movie" => "Elokuvan URL",
"with and height is optional if leaving blank 320 x 240 is used. controller is set to true by default." => "leveys ja korkeus ovat vaihtoehtoisia jos jätät tyhjäksi käytetään 320 x 240. Oletuksena hallinta on tosi.",
"Scroll" => "Vierittäjä",
"Put this on the page to modify the text size of the page on demand, by clicking on an Increase or Decrease Font Size link" => "Laittaa tämän sivulle tekstin koon muutosta varten, paina Suurenna tai Pienennä Kirjasimen Koko linkkiä",
"Displays an alphabetically sorted list of registered users" => "Näyttää aakkostetun luettelon rekisteröityneistä jäsenistä",
"Renders a graph, with linked pages navigation visually figured.\n" => "Luo kaavion, jossa sivut linkkeinä visuaalista siirtymistä varten.\n",
"the number of hops the graph follows\n" => "hyppyjen määrä joita seurataan\n",
"the title of the map\n" => "kartan otsikko\n",
"the space between nodes\n" => "sanaväli solmujen väliin\n",
"Left to Right, the direction of graph\n" => "Vasemmalta oikealle, kaavion suunta\n",
"the background color, use #rrvvbb color types.\n" => "taustaväri, käytä #rrvvbb väri arvoja.\n",
"nothing there, unlimited size. use 5,3 type sizes in inches\n" => "ei mitään siellä, rajoittamaton koko. käytä 5,3 koko tuumina\n",
"the font size in pts presumably\n" => "kirjasimen koko pisteinä\n",
"the name of the font used for labels\n" => "kirjasimen nimeä käytetään etiketeissä\n",
"the shape of a node. can be " => "solmun muoto. voi olla ",
"plaintext ellipse circle egg triangle box diamond trapezium parallelogram house hexagon octagon\n" => "tavallinenteksti ellipsi ympyrä muna kolmio laatikko timantti trapetsi rinnakkais talo hexagon octagon\n",
"style for drawing nodes.\n" => "solmujen piirtotyyli.\n",
"color of the border\n" => "kehyksen väri\n",
"background color of the node\n" => "solmun taustaväri\n",
"sortof relative width ??\n" => "lajitellaan suhteellinen leveys ??\n",
"same mystery as above\n" => "sama mysteerio kuin yllä\n",
"color for links (called edges here)\n" => "linkkien väri (kutsutaan reunoiksi täällä)\n",
"shape of the arrow that come with the link\n" => "nuolen muoto joka tulee linkin mukana\n",
"Displays an alphabetically sorted list of WikiPages" => "Näyttää aakkostetun listan sivuista",
"Resource type not selected" => "Resurssin tyyppiä ei valittu",
"Permission denied you cannot create new resources" => "Oikeutesi eivät riitä luomaan uutta resurssia",
"Permission denied, you cannot admin the workspace" => "Oikeutesi eivät riitä ylläpitämään resursseja",
"Not a portfolio workspace" => "Ei työnäyte työalue",
"Assignment not found" => "Liitosta ei löydy",
"Page not found\".\" \".\$page));\n\t}\n}else{\n\t\$smarty->assign('error_msg', tra(\"Param name not found" => "Sivua ei löydy\".\" \".\$page));\n\t}\n}tai{\n\t\$smarty->assign('error_msg', tra(\"Param nimeä ei löydy",
"Assignments Administration" => "Liitosten Ylläpito",
"are you sure to remove the assigment" => "oletko varma, että haluat poistaa liitoksen",
"Period" => "Ajanjakso",
"Grade Weight" => "Laatu Vaatimus",
"Exam" => "Koe",
"Exercise" => "Harjoitus",
"New Assignment" => "Uusi Liitos",
"Weight" => "Taso",
"Cuaderno de Problemas de" => "Niputetut Ongelmat",
"Admin resource" => "Ylläpidä resurssia",
"My Workspaces" => "Oma Työalueeni",
"Object type:" => "Kohteen tyyppi:",
"Roles Administration" => "Roolien Ylläpito",
"Permission levels" => "Oikeustasot",
"Subject Administration" => "Otsikon Ylläpito",
"Studies" => "Opinnot",
"Gradebook" => "Arvostelukirja",
"Select period" => "Valitse ajanjakso",
"Save grades" => "Tallenna arvostelut",
"Workspace path:" => "Työalue polku:",
"Workspace Types Administration" => "Työalue Tyyppien Ylläpito",
"MenuID" => "ValikkoID",
"Allow Anonymous" => "Salli Nimettömyys",
"Allow Registered" => "Salli Rekisteröityneet",
"Allow private user zone" => "Salli yksityinen käyttäjä alue",
"Workspace resources" => "Työalue resurssit",
"Workspace Types Resources" => "Työalue Tyyppien Resurssit",
"Workspace type name" => "Työalue tyypin nimi",
"Resource name" => "Resurssin nimi",
"Resource description" => "Resurssin kuvaus",
"Resource type" => "Resurssin tyyppi",
"Workspaces Administration" => "Työalueiden Ylläpito",
"Closed" => "Suljettu",
"User workspace" => "Käyttäjän työalue",
"Hide workspace" => "Piilota työalue",
"Assigned modules" => "Liitetyt moduulit",
"Remove all" => "Poista kaikki",
"Cache time" => "Puskurointi aika",
"AulaWiki Assistant" => "Aula Avustus",
"Welcome to AulaWiki" => "Tervetuloa Aulaan",
"First configuration steps" => "Kokoonpanon ensi askeleet",
"Workspace Calendar" => "Työalue Kalenteri",
"List events" => "Listaa tapahtumat",
"Child Workspaces" => "Ali Työtilat",
"Inactive workspace" => "Ei aktiivinen työtila",
"Clipboard" => "Leikepöytä",
"Workspace History" => "Työtila Historia",
"Current workspace:" => "Nykyinen työtila:",
"Active workspace" => "Aktiivinen työtila",
"My workspaces:" => "Omat työtilat:",
"Resources" => "Resurssit",
"are you sure to remove object " => "haluatko varmasti poistaa kohteen ",
"UserGroups" => "KäyttäjäRyhmät",
"Group Name:" => "Ryhmän Nimi:",
"are you sure to remove group " => "haluatko varmasti poista ryhmän ",
"are you sure to remove user from group " => "haluatko varmasti poistaa käyttäjän ryhmästä ",
"User Workspaces" => "Käyttäjän Työtilat",
"Assignment details" => "Liitos yksityiskohdat",
"Grade" => "Arvostelu",
"Save Grades" => "Tallenna Arvostelut",
"Grade for" => "Arvostele",
"View Structure" => "Näytä Rakenne",
"Workspace Members" => "Työtilan Jäsenet",
"offline users" => "koti käyttäjät",
"Personal portfolio" => "Oma työnäyte",
"Edit information" => "Muuta tietoja",
"Personal Learning Folder" => "Oma Opiskelu Kansio",
"Currencies Admin" => "Valuuttojen Ylläpito",
"Currency Provider Unique Name" => "Valuutan Tarjoajan uniikki nimi",
"Contact email" => "Yhteys sähköposti",
"Domain for list of CC service providers" => "Domain lista Valuutta palvelujen tarjoajista",
"Approval?" => "Hyväksy?",
"Listed?" => "Listattu?",
"Population" => "Asukasluku",
"Transaction" => "Tapahtuma",
"Examine" => "Tutki",
"Unregister" => "Poista rekisteröinti",
"Reregister" => "Uudelleen rekisteröi",
"Pending Registration" => "Odottava Rekisteröinti",
"Modify a Currency" => "Muokkaa Valuuttaa",
"Create a new Currency" => "Luo uusi Valuutta",
"List Currencies" => "Listaa Valuutat",
"My Currencies" => "Omat Valuutat",
"Requires approval" => "Tarvitsee hyväksynnän",
"Listed publicly" => "Listattu julkisesti",
"Register Owner" => "Rekisterin Omistaja",
"Examine Currency" => "Tutki Valuuttaa",
"Edit currency" => "Muokkaa valuuttaa",
"Balance" => "Vaihtotase",
"Amount of transactions" => "Tapahtumien määrä",
"Number of transactions" => "Tapahtumien lukumäärä",
"Last transaction" => "Viimeinen tapahtuma",
"Approved?" => "Hyväksytty?",
"Main Ledger" => "PääKirja",
"New Transaction with" => "Uusi Tapahtuma",
"last transaction date" => "viimeisen tapahtuman päiväys",
"balance" => "vaihtotase",
"total volume" => "kokonaismäärä",
"transactions" => "tapahtumia",
"out" => "ulos",
"{\$thelist[i].age|duration} ago" => "{\$thelist[i].age|duration} sitten",
"Revert Transaction" => "Palauta Tapahtuma",
"record" => "tallenne",
"revert" => "palauta",
"Displays your Plazes info" => "Näyttää Paikkasi tiedot",
"Displays your Plazes WhereIs page" => "Näyttää paikkasi MissäOn sivun",
"New blog post: {\$mail_title}: {\$title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Uusi blogi kirjoitus: {\$mail_title}: {\$title} , {\$mail_user}: {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at\n{\$mail_date|tiki_short_datetime}" => "Sivua {\$mail_page} on muuttanut {\$mail_user}  \n{\$mail_date|tiki_short_datetime}",
"You can view the page by following this link:\n    {\$mail_machine}tiki-index.php?page={\$mail_page|escape:\"url\"}" => "Voit katsoa sivua seuraamalla tätä linkkiä:\n    {\$mail_machine}tiki-index.php?page={\$mail_page|escape:\"url\"}",
"You can edit the page by following this link:\n    {\$mail_machine}tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "Voit muokata sivua seuraamalla tätä linkkiä:\n    {\$mail_machine}tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"You can view a diff back to the previous version by following\nthis link:\n    {\$mail_machine}tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}" => "Voit katsoa edellisiä versioita seuraamalla\ntätä linkkiä:\n    {\$mail_machine}tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}",
"List Courses" => "Listaa Kurssit",
"Upcoming `\$module_rows` modified events" => "Tulossa olevat `\$module_rows` muutetut tapahtumat",
"Go \r\n                    back" => "Mene \r\n                    takaisin",
"Return to home \r\n                    page" => "Palaa etu \r\n                    sivulle",
"Confirmation required" => "Tarvitaan varmistus",
"Wiki quick help" => "Wiki pika apu",
"Quicklinks" => "Pikalinkit",
"Please" => "Pyydän",
"log in" => "kirjaudu",
"to access full functionalities" => "käyttääksesi täyttä toiminnallisuutta",
"Go \n                    back" => "Mene \n                    takaisin",
"Return to home \n                    page" => "Palaa omalle \n                    sivulle",
"Skip to navigation" => "Hyppää siirtymiin",
"MyTiki (click!)" => "OmatSivut (paina!)",
"Admin (click!)" => "Ylläpito (paina!)",
"TikiTabs" => "TikiTabit",
"Use Quote plugin for quoting" => "Käytä Lainaus plugia lainaukseen",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Käytä {literal}{{/literal}ed id=nimi} tai {literal}{{/literal}ted id=nimi} lisätäksesi muuttuvia alueita",
"Field is hidden? (visible by admin only)" => "Kenttä on piilotettu? (näkyy vain ylläpidolle)",
"slideshow backward" => "kuvaesitys taaksepäin",
"Emphasis" => "Korostaa",
"italics" => "kallistettu",
"both" => "molemmat",
"use ...page... to separate pages" => "käytä ...sivu... erottaaksesi sivut",
"make_headings" => "tee_pääosia",
"underlines text" => "alleviivaa tekstin",
"Simple box" => "Yksikertainen laatikko",
"Will display using the indicated HTML color" => "Näytetään käyttäen osoitettuja HTML värejä",
"Will display the text centered" => "Näytetään teksti keskitettynä",
"Insert Module Output" => "Liitä Moduuli Tulostus",
"{literal}{MODULE(module=>some_module)}text{MODULE}{/literal}  can be used to insert the output of module \"some_module\" into your Wiki page. See <a href=\"{\$helpurl}PluginModule\">PluginModule</a> for more information. " => "{literal}{MODUULI(module=>some_module)}text{MODUULI}{/literal}  käytetään lisätäksesi moduulin tulostus \"some_module\" sivullesi. Katso <a href=\"{\$helpurl}PluginModule\">PluginModule</a> lisätietoihin. ",
"Rendering Program Code" => "Muodosta Ohjelma Koodi",
"{literal}{CODE()}some code{CODE} {/literal} will render \"some code\" as program code. This plugin has other options; see <a href=\"{\$helpurl}PluginCode\">PluginCode</a>." => "{literal}{CODE()}jotain koodia{CODE} {/literal} muodostaa \"jotain koodia\" ohjelmakoodin. Tällä plugilla on muita vaihtoehtoja; katso <a href=\"{\$helpurl}PluginCode\">PluginCode</a>.",
"Import pages from a PHPWiki Dump" => "Tuo sivuja PHPWiki Dumpista",
"Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)" => "Polku missä dumppi tiedostot ovat (suhteellinen tiki basedir kautta viivan kanssa ex: dump/)",
"updated by the phpwiki import process" => "päivitetty phpwiki tuontiprosessissa",
"created from phpwiki import" => "luotu phpwiki tuonnista",
"Invalid variable value : " => "Väärä muuttujan arvo : ",
"Textarea options: quicktags,width,height,max - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved." => "Tekstialue valinnat: pikatagit,leveys,korkeus,max - Käytä Pikatageja on 1 tai 0, leveys ilmoitetaan merkkeinä, korkeus riveinä, max on maksimi määrä merkkejä jotka voidaan tallentaa.",
"You need to supply information for : " => "Sinun on annettava tietoja : ",
"Lists ''wanted'' Wiki pages" => "Listaus ''halutaan'' sivuja",
"Please follow the steps below to have your password properly reset:\n\n1. Click the following link to confirm you wish to reset your password:\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\n2. Click the following link to go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user}&oldpass={\$mail_pass}\n\nAlternatively, go to {\$mail_site} and login using your username and temporary password:\n Username:   {\$mail_user}\n Temporary password:  {\$mail_pass}\n\n3. Done! You should be logged in." => "Ole hyvä ja seuraa alla olevia ohjeita salasanan muuttamiseksi:\n\n1. Paina seuraavaa linkkiä varmistaaksesi salasanan vaihdon:\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\n2. Paina seuraavaa linkkiä päästäksesi ruudulle johon kirjoitat uuden \"pysyvän\" salasanan. Valitse salasana jonka vain sinä tiedät, äläkä kerro sitä muille.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user}&oldpass={\$mail_pass}\n\nVaihtoehtoisesti mene {\$mail_site} ja kirjaudu käyttäen käyttäjänimeäsi ja väliaikaista salasanaa:\n Käyttäjänimi:   {\$mail_user}\n Väliaikainen salasana:  {\$mail_pass}\n\n3. Tehty! Olet kirjautunut sisään.",
"Like pages" => "Sivut kuin",
"creates an editable drawing named foo" => "luo muokattavan piirroksen nimeltä foo",
"Activs" => "Toimint",
"Ins" => "Pyy",
"time" => "aikka",
"Preview Poll" => "Äänestyksen esikatselu",
"Jukebox preference" => "Jukebox asetukset",
"You do not have permission to write the template" => "Oikeutesi eivät riitä kirjoittamaan mallia",
"Go to your <a href=\"tiki-friends.php\">friendship network</a> to accept or refuse this request" => "Mene <a href=\"tiki-friends.php\">ystävä verkosto</a> hyväksyäksesi tai hylätäksesi pyyntö",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"ok" => "ok",
"dsn" => "dsn",
"extwiki" => "extwiki",
"ppd" => "ppd",
"url" => "url",
"adm" => "adm",
"You do not have permission to use this feature." => "Oikeutesi eivät riitä käyttämään tätä ominaisuutta.",
"refresh" => "päivitä",
"uploaded by" => "lähettänyt",
"not specified" => "ei määritelty",
"There was a problem with your upload." => "Ilmeni ongelmia lähetyksesi kanssa.",
"The file you are trying to upload is too big." => "Tiedosto jota yrität lähettää on liian suuri.",
"The file you are trying to upload was only partially uploaded." => "Tiedosto jota yrität lähettää tuli vain osittain.",
"You must select a file for upload." => "On valittava tiedosto lähetettäväksi.",
"%s is an empty archive file" => "%s on tyhjä tiedosto",
"Invalid remote file on url %s" => "Väärä ulkoinen tiedosto url %s",
"%A %d of %B, %Y" => "%A %d %B, %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d %B, %Y[%H:%M:%S %Z]",
"%a %d of %b, %Y" => "%a %d %b, %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d %b, %Y[%H:%M %Z]",
"Updated" => "Päivitetty",
"User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "Käyttäjä Valitsin: käytä valintoja automaattiseen kenttien täyttöön : valitse 1 kirjoittajan kirjautumiseksi tai 2 muokkaajan kirjautumiseksi.",
"Category options: parentId" => "Luokan vaihtoehdot: isäntäId",
"Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing" => "Osa Linkki vaihtoehdot: kortistoId,kenttäId,linkkiOsaan linkittää osan kortistoId:stä jonka kenttäId täsmää kenttä osan kanssa. linkkiOsan 1|0 luodaksesi linkin osaan näytöllä ja listalla",
"num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "numero on vaihtoehtoinen ja on järjestysnumero liite listalla. Jos se puuttuu, lista kaikista liitteistä näytetään. Tekee kommentista tekstin linkin.",
"~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>syöteId,max=>3,päivä=>1,runko=>1)}{RSS} Laittaa rss syötteen tuloksen sivulle",
"missing tracker ID for plugin TRACKER" => "puuttuu kortiston ID TRACKER plugille",
"delete" => "poista",
"post" => "lähetä",
"stop monitoring this blog" => "Lopeta tämän blogin tarkkailu",
"posts" => "lähetyksiä",
"visits" => "vierailut",
"show categories" => "näytä luokittelut",
"Tip: hold down CTRL to select multiple categories" => "Vinkki: paina CTRL:ia valitaksesi useita luokitteluja",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "Vinkki: poista merkintä alla olevasta laatikosta poistaaksesi luokittelun sivulta/kohteelta",
"author" => "kirjoittaja",
"user level" => "käyttäjä taso",
"send email to user" => "lähetä viesti käyttäjälle",
"score" => "tilanne",
"delete selected" => "poista valitut",
"move" => "siirrä",
"Posted messages" => "Lähetetyt viestit",
"set" => "aseta",
"replies" => "vastauksia",
"new reply" => "uusi vastaus",
"cancel" => "peruuta",
"up" => "ylös",
"down" => "alas",
"add" => "lisää",
"stop monitoring this map" => "lopeta tämän kartan tarkkailu",
"create" => "luo",
"save" => "tallenna",
"edit template" => "muokkaa mallia",
"send" => "lähetä",
"reply to" => "vastaa",
"Hide module contents" => "Piilota moduulin kommentit",
"Last visitors" => "Viime vierailijat",
"register" => "rekisteröi",
"standard" => "standardi",
"secure" => "salattu",
"stay in ssl mode" => "pysy ssl moodissa",
"new messages" => "uusia viestejä",
"new message" => "uusi viesti",
"go" => "mene",
"cache" => "puskuri",
"use" => "käytä",
"cached" => "puskuroitu",
"print" => "tulosta",
"create pdf" => "luo pdf",
"monitor this page" => "tarkkaile tätä sivua",
"stop monitoring this page" => "lopeta tämän sivun tarkkailu",
"backlinks" => "paluulinkit",
"last modification" => "muokattu viimeksi",
"click here" => "paina tästä",
"rename" => "nimeä",
"unlock" => "aukaise",
"lock" => "lukitse",
"perms" => "oikeud",
"history" => "historia",
"similar" => "samanlainen",
"undo" => "peru",
"slides" => "kuvat",
"export" => "vie",
"discuss" => "pohtia",
"add comment" => "lisää kommentti",
"attach file" => "liite tiedosto",
"translation" => "käännös",
"attachments" => "liitteet",
"stats" => "tilastot",
"last changes" => "viimeiset muutokset",
"list pages" => "listaa sivut",
"back to homepage" => "takaisin etusivulle",
"cancel edit" => "peruuta muutos",
"No attachments for this page" => "Ei liitteitä tälle sivulle",
"switch" => "kytkin",
"reads" => "lukijaa",
"view comments" => "näytä kommentit",
"Click here to create it" => "Paina tästä luodaksesi sen",
"wiki help" => "wiki apu",
"Site Calendar" => "Sivusto Kalenteri",
"Best language" => "Paras kieli",
"Enable cache images to all galleries" => "Oikeuta puskurointi kaikille kuva gallerioille",
"Images cache directory" => "Kuvien puskuri hakemisto",
"images" => "kuvista",
"PHP error reporting level for non-admin:" => "PHP virhe raportointi taso ei ylläpidolle:",
"Report PHP errors only for admin" => "Raportoi PHP virheet vain ylläpidolle",
"Server name (for absolute URIs)" => "Palvelimen Nimi (tarkkaa URI:ia varten)",
"HTTPS Server" => "HTTPS Palvelin",
"Automatic (uses HTTPS variable)" => "Automaattinen (käyttää HTTPS muuttujaa)",
"Wiki_Tiki_Title" => "Wiki_Tiki_Otsikko",
"path" => "polku",
"groups" => "ryhmät",
"Admin->Features" => "Ylläpito->Ominaisuudet",
"must be turned on and notification is sent to the admin's" => "on oltava päällä ja ilmoitus ylläpidolle lähetetään",
"inter-user message inbox" => "inter-käyttäjän postilaatikko",
"Create a group for each user <br />(with the same\nname as the user)" => "Luo ryhmä jokaiselle <br />(samalla\nnimellä kuin käyttäjä)",
"Validate email address (may not work)" => "Varmista sähköposti osoite (ei ehkä toimi)",
"Require HTTP Basic authentication" => "Vaaditaan HTTP perus varmistus",
"HTTP server name" => "HTTP palvelin nimi",
"HTTP URL prefix" => "HTTP URL etuliite",
"HTTPS server name" => "HTTPS palvelin nimi",
"HTTPS URL prefix" => "HTTPS URL etuliite",
"Only for users" => "Vain käyttäjille",
"Users and admins" => "Käyttäjät ja Ylläpitäjät",
"Full Text Search" => "Täysi Teksti Haku",
"Don't forget: to use feature you will need to enable it on" => "Äläkä unohda: käytääksesi ominaisuutta se on pantava päälle täältä",
"Custom Code" => "Muokattu Koodi",
"Site breadcrumbs" => "Sivusto palat",
"Site search bar" => "Sivuston etsintä palkki",
"Site logo" => "Sivusto logo",
"Site logo source" => "Sivusto logo lähde",
"Site ads and banners" => "Sivuston mainokset ja bannerit",
"Site Menu" => "Sivusto Valikko",
"Note: This feature also requires phplayers to be turned on in Admin->Features" => "Huomio: Tämä ominaisuus tarvitsee myös phplayers päällä olon se löytyy Ylläpitä->Ominaisuudet",
"change" => "vaihda",
"Manage attachment preferences" => "Hallitse liite kokoonpanoa",
"HTML in Wiki Pages" => "HTML Sivuilla",
"Wiki syntax used when a page contains HTML" => "Sivu syntaxia käytetään kun sivu sisältää HTML:ää",
"full" => "koko",
"partial" => "osittain",
"Search and replace" => "Etsi ja korvaa",
"Enable Feature" => "Käytä Ominaisuutta",
"Wiki attachments preferences" => "Liitteiden kokoonpanot",
"admin banning tpl" => "ylläpidon esto tpl",
"loc" => "pai",
"participants" => "osallistujat",
"cat" => "luet",
"lang" => "kieli",
"prio" => "ensis",
"subscription" => "tilaukset",
"perso" => "henkilö",
"permissions" => "oikeudet",
"admin categories" => "ylläpidä luokitteluja",
"admin categories tpl" => "ylläpidä luokittelujen tpl",
"create new" => "luo uusi",
"edit chart" => "muuta kaavio",
"update" => "päivitä",
"admin charts template" => "ylläpidä kaavion mallia",
"admin content templates" => "ylläpidä sisältö malleja",
"admin content templates template" => "ylläpidä sisälltö mallin mallia",
"use in cms" => "käytä cms:ssä",
"use in wiki" => "käytä wikissä",
"use in newsletters" => "käytä uutislehdessä",
"use in events" => "käytä tapahtumia",
"use in HTML pages" => "käytä HTML sivuilla",
"last modif" => "viimeki muokannut",
"sections" => "osastot",
"admin FortuneCookie" => "ylläpidä OnnenKeksejä",
"admin FortuneCookie tpl" => "ylläpidä OnnenKeksi tpl",
"upload" => "lähetä",
"admin Drawings tpl" => "ylläpidä Piirros tpl",
"admin External Wikis" => "ylläpidä ulkoisia sivuja",
"admin forums template" => "ylläpidä foorumien malli",
"Edit existing forums" => "Muokka olemassa olevia foorumeja",
"flag" => "lippu",
"online" => "linjalla",
"topics" => "aiheet",
"coms" => "kom",
"age" => "ikä",
"last post" => "viimeinen lähetys",
"Assign Permissions (Active)" => "Anna Oikeudet (Aktivoi)",
"Click here to delete this forum" => "Paina tästä poistaaksesi tämän foorumin",
"admin hotwords" => "ylläpidä hotwords",
"admin hotwords template" => "ylläpidä kuumasanojen malli",
"admin HTML page dynamic zones" => "ylläpidä HTML muuttuvia alueita",
"admin Html Pages" => "ylläpidä Html Sivuja",
"admin Html Pages template" => "ylläpidä Html Sivujen malli",
"list repositories" => "lista säilytyspaikoista",
"new repository" => "uusi säilytyspaikka",
"view repository" => "näytä säilytyspaikka",
"view this repository" => "näytä tämä säilytyspaikka",
"new rule" => "uusi sääntö",
"admin featured links" => "ylläpidä ominaisuus linkit",
"admin featured links template" => "ylläpidä ominaisuus linkkien malli",
"position" => "paikka",
"admin Webmail" => "ylläpidä Webmail",
"admin mailin template" => "ylläpidä postitsisään malli",
"section" => "osasto",
"sorted section" => "lajiteltu osasto",
"admin menu builder" => "ylläpidä valikon rakentajaa",
"admin menus template" => "ylläpidä valikko malli",
"options" => "vaihtoehdot",
"admin modules" => "ylläpidä moduuleja",
"admin modules template" => "ylläpidä moduulien malli",
"assign module" => "liitä moduuli",
"left modules" => "moduulit vasemmalla",
"right modules" => "moduulit oikealla",
"edit/create" => "muokkaa/luo",
"clear cache" => "tyhjennä puskuri",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Huomaa 1</b>: jos annat käyttäjien muokata moduuleja silloin liitetyt\nmoduulit eivät reagoi muutoksiin ennen kuin muutat niitä vastaavasti\nOmaSivu->moduulit.<br />\n<b>Huomaa 2</b>: Jos liität moduuleja ryhmille pidä huoli että\nnäytä kaikki 'moduulit kaikille ryhmille aina on päällä'\nYlläpidä->Yleiset\n",
"assign" => "liitä",
"left" => "vasen",
"right" => "oikea",
"order" => "järjestys",
"parameters" => "parametrit",
"create/edit" => "luo/muokkaa",
"use poll" => "käytä äänestystä",
"use gallery" => "käytä galleriaa",
"use dynamic  content" => "käytä muuttuvaa sisältöä",
"use rss module" => "käytä rss moduulia",
"use menu" => "käyttäjä valikko",
"use phplayermenu" => "käytä phplayervalikkoa",
"use banner zone" => "käytä banneri aluetta",
"structure" => "rakenne",
"list newsletters" => "listaa uutislehdet",
"admin newsletters" => "ylläpidä uutislehtiä",
"send newsletters" => "lähetä uutislehdet",
"admin newsletters template" => "ylläpidä uutiskirjeen malli",
"editions" => "laitokset",
"last sent" => "viimeksi lähetetty",
"send newsletter" => "lähetä uutiskirje",
"admin Email Notifications" => "ylläpidon sähköposti ilmoitus",
"admin notifications template" => "ylläpidon huomautus malli",
"use admin email" => "käytä ylläpidon sähköpostia",
"event" => "tapahtuma",
"admin polls" => "ylläpidä äänestyksiä",
"admin polls template" => "ylläpidä äänestys malli",
"admin QuickTags" => "ylläpidä PikaLisiä",
"label" => "etiketti",
"admin RSS Modules" => "ylläpidä RSS moduuleje",
"admin RSSmodules template" => "ylläpidä RSSmoduulien malli",
"edit tpl" => "muuta tpl",
"admin shoutbox words" => "ylläpidä pikaviestin sanoja",
"admin shoutbox words template" => "ylläpidä pikaviesti sanojen malli",
"admin structures template" => "ylläpidä rakenne malli",
"export pages" => "tulosta sivut",
"dump tree" => "dumppi puu",
"create webhelp" => "luo webapu",
"view webhelp" => "näytä webapu",
"tree" => "puu",
"create new structure" => "luo uusi rakenne",
"survey stats" => "tutkimus tilastot",
"edit this survey" => "muuta tätä tutkimusta",
"admin surveys" => "ylläpidä tutkimuksia",
"list surveys" => "listaa tutkimukset",
"questions" => "kysymykset",
"files" => "tiedostot",
"admin topics template" => "ylläpidä aiheiden malli",
"Field is public? (for use thru trackerlist plugin)" => "Kenttä on julkinen? (käytetään trackerlist plugin kautta)",
"admin Trackers tpl" => "ylläpidä Kortistojen tpl",
"Edit fields for tracker" => "Muuta kortiston kenttiä",
"items" => "osat",
"The tracker needs a text field named Subject" => "Kortisto tarvitsee kentän nimeltä Otsikko",
"version" => "versio",
"admin groups" => "ylläpidä ryhmiä",
"admin groups template" => "ylläpidä ryhmä malli",
"assign permissions" => "anna oikeudet",
"admin" => "ylläpitäjä",
"remove from group" => "poista ryhmäsät",
"admin users" => "ylläpidä käyttäjiä",
"admin users template" => "ylläpidä käyttäjien malli",
"Added users" => "Lisätyt käyttäjät",
"edit account settings" => "muokkaa tili asetuksia",
"edit included group" => "muokkaa sisällytettyä ryhmää",
"assign to groups" => "liitä ryhmiä",
"Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Ryhmä lähetys (CSV tiedosto<a {popup text='kirjaus,salasana,sähköposti,ryhmät<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
"edit article tpl" => "muokkaa artikkeli tpl",
"advanced feature" => "kehittyneempi ominaisuus",
"all" => "kaikki",
"Assign user" => "Liitä käyttäjä",
"Available groups" => "Saatavilla olevat ryhmät",
"assign perms to this group" => "anna oikeudet tälle ryhmälle",
"admin backups" => "ylläpidon varmuuskopio",
"admin admin tpl" => "ylläpidä ylläpitäjän tpl",
"Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead." => "Tämän ominaisuuden käyttöä EI suositella. Käytä ohjelmaa phpMyAdmin tai mysqldump tämän sijasta.",
"List of available backups" => "Listaa saatavilla olevat varmuuskopiot",
"Restoring a backup" => "Palautetaan varmuuskopio",
"Warning!" => "Varoitus!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Tietojen palautus varmuuskopiosta tuhoaa kaiken uudemman tiedon. Kaikki tiedot korvataan varmuuskopion teko hetken aikaisilla tiedoilla.",
"Click here to confirm restoring" => "Paina tästä aloittaaksesi palautus",
"Create new backup" => "Luo uusi varmuuskopio",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Varmuuskopion luominen kestää kauan. Jos kopiointi ei mene loppuun asti näet tyhjän ruudun. Sinun on lisättävä scriptin maksimi ajo aikaa php.ini tiedostossa",
"Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "Sinun kuvagalleriasi levytila on \"{\$gal_use_dir}\", tee varmuuskopio käyttäen FTP:tä tai SCP:tä.",
"Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "Sinun tiedostogalleriasi levytila on \"{\$fgal_use_dir}\", tee varmuuskopio käyttäen FTP:tä tai SCP:tä.",
"If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "Jos foorumiesi liitetiedostot on tallennettu hakemistoon tee varmuuskopio käyttäen FTP:tä tai SCP:tä.",
"Upload a backup" => "Lähetä varmuuskopio",
"Upload backup" => "Lähetä varmuuskopio",
"remove file extension from image name" => "poista tiedostopääte kuvan nimestä",
"convert sub directories to sub galleries" => "muuntaa alihakemistot aligallerioiksi",
"eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "esim. \"misc/screenshots/digicam0001.jpg\" ja galleria nimeltä screenshots luodaan",
"use sub directory names as description" => "käyttää alihakemiston nimiä kuvauksena",
"eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "esim. \"misc/screenshots/digicam0001.jpg\" ja luodaan kuvaus misc/screenshots ",
"view blog" => "näytä blogi",
"list blogs" => "listaa blogit",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "Huomio: jos haluat käyttää kuvia tallenna lähetys ensin ja sinä\nvoit muokata/lähettää kuvia. Käytä &lt;img&gt; palaa lisätäksesi lähettämäsi kuvat editorin tekstialueelle\ntai voit käyttää URL lisätäksesi kuvat WYSIWYG editoriin. ",
"save and exit" => "tallenna ja poistu",
"admin the category system" => "ylläpidä luokka järjestelmää",
"admin category" => "ylläpidä luokittelua",
"search category" => "etsi luokka",
"deep" => "syvä",
"list galleries" => "listaa galleriat",
"edit gallery" => "muokkaa galleriaa",
"rebuild thumbnails" => "rakenna minikuvat",
"upload image" => "lähetä kuva",
"list gallery" => "listaa galleria",
"hit" => "osuma",
"original size" => "alkuperäinen kuva",
"return to gallery" => "palaa galleriaan",
"edit image" => "muokkaa kuvaa",
"smaller" => "pienempi",
"bigger" => "suurempi",
"prev image" => "edellinen kuva",
"popup window" => "popup ikkuna",
"next image" => "seuraava kuva",
"slideshow forward" => "kuvaesitys eteenpäin",
"stop" => "seis",
"imagescale" => "kuvamuunnos",
"add item" => "lisää osa",
"list view" => "listaus näyttö",
"Subscription List" => "Tilaaja Lista",
"or create a new category" => "tai luo uusi luokka",
"or create a new location" => "tai luo uusi sijainti",
"comma separated usernames" => "pilkku erottaa käyttäjänimet",
"comma separated username:role" => "pilkku erottaa käyttäjänimen:tehtävän",
"with roles" => "ja tehtävät",
"Chair" => "Istuin",
"Optional" => "Vaihtoehtoinen",
"Format: mm/dd/yyyy hh:mm<br />..." => "Muoto: kk/pp/vvvv tt:mm<br />...",
"See strtotime php function" => "Katso strtotime php toiminto",
"Format: mm/dd/yyy hh:mm<br />..." => "Muoto: kk/pp/vvv tt:mm<br />...",
"save_to" => "tallenna",
"permission" => "oikeudet",
"remove from this category &amp; all its children" => "poista tästä luokasta &amp; ja kaikki alaluokat",
"remove from this category only" => "poista vain tästä luokasta",
"Textheight" => "Tekstinkorkeus",
"Height of top Heading" => "Ylimmän pääosan korkeus",
"Height of mid Heading" => "Medium pääosan korkeus",
"Height of inner Heading" => "Sisäisen pääosan korkeus",
"tbheight" => "tbkorkeus",
"Automatic Page Breaks" => "Automaattiset Sivu Jaot",
"remove page" => "poista sivu",
"admin directory tpl" => "ylläpidä hakemisto tpl",
"browse" => "selaa",
"related" => "liittyvä",
"validate" => "vahvista",
"admin directory categories tpl" => "ylläpidä hakemisto luokittelujen tpl",
"add a site" => "lisää sivusto",
"add a category" => "lisää luokka",
"search" => "etsi",
"list articles" => "listaa artikkelit",
"view articles" => "näytä artikkelit",
"create zone" => "luo alue",
"save the banner" => "tallenna banneri",
"edit blog tpl" => "muuuta blog tpl",
"try" => "kokeile",
"display" => "näytä",
"For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "Saadaksesi lisää tietoja, katso <a href=\"{\$helpurl}WikiSyntax\">SivuSyntaxi</a>",
"Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Näyttää esimuotoillun tekstin/koodin; mitään prosesseja ei suoriteta näillä osastoilla (kuin np), ja tila on vakio (ei automaattista rivitystä).",
"admin quicktags" => "ylläpidon pikatagit",
"create new block" => "luo uusi blokki",
"list quizzes" => "listaa visailut",
"quiz stats" => "visailu tilastot",
"edit this quiz" => "muuta tätä visailua",
"admin quizzes" => "ylläpidä visailuja",
"admin quizzes tpl" => "ylläpidä visailut tpl",
"results" => "tulokset",
"edit quiz questions" => "muokkaa visailun kysymyksiä",
"edit quiz questions tpl" => "muokkaa visailun kysymyksiä tpl",
"create page" => "luo sivu",
"edit submissions tpl" => "muokkaa ehdotus tpl",
"list submissions" => "listaa ehdotukset",
"save only in the theme:" => "tallenna vain teemaan:",
"edit translations" => "muokkaa käännöksiä",
"edit translations template" => "muokkaa käännöksiä malli",
"add to the set" => "lisää sarjaan",
"Search " => "Etsi ",
"replace" => "korvaa",
"Admin ephemerides" => "Ylläpidä ephemerides",
"admin Ephemerides tpl" => "ylläpidä Ephemerides tpl",
"All ephemerides" => "Kaikki ephemerides",
"new question" => "uusi kysymys",
"approve" => "hyväksy",
"configure listing" => "kokoonpano listaus",
"create new gallery" => "luo uusi galleria",
"topic" => "aihe",
"save and approve" => "tallenna ja hyväksy",
"new topic" => "uusi aihe",
"reject" => "hylätty",
"accept" => "hyväksy",
"refuse" => "hylkää",
"add new" => "lisää uusi",
"add role" => "lisää tehtävä",
"new minor" => "uusi pieni",
"new major" => "uusi iso",
"admin processes" => "ylläpidä prosesseja",
"admin activities" => "ylläpidä toimintoja",
"admin roles" => "ylläpidä tehtäviä",
"edit this process" => "muuta tätä prosessia",
"monitor" => "tarkkailija",
"send instance" => "lähetä pyyntö",
"rebuild cache" => "rakenna puskuri",
"result" => "tulos",
"reload" => "lataa uudelleen",
"edit repository" => "muuta tallennuspaikka",
"source" => "lähde",
"list articles tpl" => "listaa artikkelit tpl",
"edit new article" => "muuta uutta artikkelia",
"admin Banners" => "ylläpidä Bannerit",
"admin Banners tpl" => "ylläpidä Bannerit tpl",
"create new blog" => "luo uusi blogi",
"admin cache" => "ylläpidä puskuri",
"admin cache tpl" => "ylläpidä puskuri tpl",
"admin DynamicContent tpl" => "ylläpidä MuuttuvaSisältö tpl",
"list faqs tpl" => "listaa ukk tpl",
"upload file" => "Lähetä tiedosto",
"Edit a file using this form" => "Muokkaa tiedostoa käyttäen tätä lomaketta",
"monitor this gallery" => "tarkkaile tätä galleriaa",
"stop monitoring this gallery" => "lopeta tämän gallerian tarkkailu",
"delete selected files" => "poista valitut tiedostot",
"browse gallery" => "selaa galleriaa",
"Flash binary (.sqf or .dcr)" => "Flash binary (.sqf tai .dcr)",
"list posts tpl" => "listaa lähetys tpl",
"edit blog" => "muokkaa blogia",
"list quizzes tpl" => "listaa visailu tpl",
"edit new submission" => "muuta uutta ehdotusta",
"edit quiz stats tpl" => "muokkaa visailu tilastoja tpl",
"actions" => "toiminnot",
"take survey" => "ota tutkimus",
"list trackers tpl" => "listaa kortistot tpl",
"admin live support tpl" => "ylläpidä elävä tuki tpl",
"set as operator" => "aseta operaattoriksi",
"add topic" => "lisää aihe",
"Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./setup.sh\" for example)." => "Apachella on oikeus kirjoittaa hakemistopuuhusi, joka mahdollistaa asennukset, poiston tai \npakettien päivitykse. Kun nämä toimenpiteet on tehty, muuta oikeudet takaisin turvalliseen tilaan (käyttäen \n\"./setup.sh\" esimerkiksi).",
"To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./setup.sh open\" to set it up). After installation you need to remove that\npermission (using \"./setup.sh\")." => "Asentaaksesi, poistaaksesi tai päivittääksesi paketteja apache tarvitsee oikeudet\nkirjoittaa tiedostoja hakemistopuuhusi (voit käyttää \"./setup.sh open\" antaaksesi oikeudet). Asennuksen jälkeen palauta \noikeudet (käyttäen \"./setup.sh\").",
"install" => "asenna",
"wiki create" => "wiki luonti",
"wiki overwrite" => "wiki päällekirjoitus",
"back" => "takaisin",
"Assign permissions to page" => "Liitä sivuun oikeudet",
"Current permissions for this page" => "Nykyiset oikeudet tälle sivulle",
"remove from this page" => "poista tältä sivulta",
"remove from this structure" => "poista tästä rakenteesta",
"No individual permissions; category or global permissions apply" => "Ei yksittäisoikeuksia; luokka tai yleiset oikeudet annetaan",
"this page" => "tämä sivu",
"this structure" => "tämä rakenne",
"Current permissions for categories that this page belongs to" => "Nykyiset oikeudet tämän sivun luokkiin kuuluvat",
"Send email notifications when this page changes to" => "Lähetä sähköposti ilmoitus kun tämä sivu muuttuu tänne",
"add email" => "lisää sähköposti",
"Notifications" => "Huomautukset",
"clear" => "tyhjennä",
"clear stats" => "tyhjennä tilastot",
"Edit received page" => "Muokkaa vastaanotettua sivua",
"admin Referer stats" => "ylläpidä Suositus tilastoja",
"admin Referer stats tpl" => "ylläpidä Suositus tilastoja tpl",
"last" => "viimeinen",
"send me my password" => "lähetä salasanani",
"searched" => "etsitty",
"galleries" => "gallerioista",
"blog posts" => "blogi lähetyksistä",
"articles" => "artikkeleista",
"wiki pages" => "sisäiset sivut",
"admin send objects tpl" => "ylläpidä lähetä kohteet tpl",
"site" => "sivusto",
"add article" => "lisää artikkeli",
"create new sheet" => "luo uusi arkki",
"admin Tiki Shoutbox" => "ylläpidä Pikaviestintä",
"admin Tiki Shoutbox tpl" => "ylläpidä Pikaviestintä tpl",
"first" => "ensimmäinen",
"send answers" => "lähetä vastaukset",
"move to right column" => "siirrä oikeaan palstaan",
"unassign" => "poistaliitos",
"move to left column" => "siirrä vasempaan palstaan",
"remove folder" => "poista kansio",
"refresh cache" => "päivitä puskuri",
"General preferences" => "Yleiset asetukset",
"Other preferences" => "Muut asetukset",
"HomePage" => "EtuSivu",
"Change information" => "Muuta tietoja",
"admin mode" => "ylläpidollinen",
"trash" => "roskis",
"empty trash" => "tyhjennä roskis",
"remove from trash" => "poista roskiksesta",
"use start date and time" => "käytä aloituspäivää ja aikaa",
"use end date and time" => "käytä lopetuspäivää ja aikaa",
"edit user files" => "muokkaa käyttäjä tiedostoja",
"no comments" => "ei kommentteja",
"edit items" => "muokkaa osia",
"list charts" => "listaa kaaviot",
"last chart" => "viimeisin kaavio",
"item" => "osa",
"view faq" => "näytä ukk",
"view faq tpl" => "näytä ukk tpl",
"admin menus tpl" => "ylläpidä valikoiden tpl",
"add suggestion" => "lisää ehdotus",
"monitor this forum" => "tarkkaile tätä foorumia",
"stop monitoring this forum" => "lopeta tämän foorumin tarkkailu",
"delete selected topics" => "poista valitut aiheet",
"topics in this forum" => "Tämän foorumin aiheet",
"stop monitoring this topic" => "lopeta tämän aiheen tarkkailu",
"Comments below your current threshold" => "Kommentit nykyisen kynnyksen alta",
"list attachments" => "listaa liitteet",
"remove image" => "poista kuva",
"add contacts" => "lisää yhtyeksiin",
"DATE-of" => "PÄIVÄYS",
"The passwords dont match" => "Salasana ei kelpaa",
"The passwords didn't match" => "Salasana ei täsmää",
"You cannot edit this page because it is a user personal page" => "Et voi muokata tätä sivua, koska se on käyttäjän oma sivu",
"Permission denied you cannot assign permissions for this page" => "Oikeutesi eivät riitä asettamaan oikeuksia tälle sivulle",
"You do not have permission to edit messages" => "Oikeutesi eivät riitä muokkaamaan viestiä",
"Cannot read file" => "Tiedostoa ei voi lukea",
"Permission denied you cannot upload files" => "Et voi lähettää tiedostoja",
"cannot process upload" => "ei voi käsitellä lähetystä",
"Your email address has been removed from the list of addresses monitoring this tracker" => "Sähköpostiosoitteesi on poistettu tarkkailtavien listalta",
"Your email address has been added to the list of addresses monitoring this tracker" => "Sähköpostiosoitteesi on lisätty tarkkailtavien listalle",
"Cancel monitoring" => "Peruuta tarkkailu",
"Your email address has been removed from the list of addresses monitoring this item" => "Sähköpostiosoitteesi on poistettu tämän osan tarkkailtavien listalta",
"Your email address has been added to the list of addresses monitoring this item" => "Sähköpostiosoitteesi on lisätty tämän osan tarkkailtavien listalle",
"tikiwiki logo" => "tikiwiki logo",
"Dls" => "Dls",
"pdf" => "pdf",
"UTC" => "UTC",
"zoom" => "zoom",
"pop" => "pop",
"new image uploaded by" => "uuden kuvan lähettäjä",
"new subscriptions" => "uudet tilaukset",
"new item in tracker" => "uusi osa kortistossa",
"show" => "näytä",
"hide" => "piilota",
"field is not numeric" => "kenttä ei ole numeerinen",
"Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode." => "Tekstialueen vaihtoehdot: pikatagit,leveys,korkeus,max,listaa maksimi - Käytä pikatagian on 1 tai 0, tämän leveys osoitetaan merkkeinä, korkeus osoitetaan riveinä, max on tallennettavissa olevien merkkien suurin määrä, listaa maksimi on maksimi määrä merkkejä jotka näytetään listauksessa.",
"Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag" => "Maa Valitsimen vaihtoehdot: 1|2 missä 1 näyttää vain maan nimen ja 2 näyttää vain maan lipun. Oletuksena näytetään molemmat",
"message" => "viesti",
"Include all post in a blog" => "Sisällytä kaikki blogin lähetykset",
"Include an article" => "Sisällytä artikkeli",
"no such attachment on this page" => "ei sellaista liitettä sivulla",
"select all" => "valitse kaikki",
"filter" => "suodin",
"missing fields list" => "puuttuu kenttä lista",
"move %s in %s" => "siirrä %s -> %s",
"no such file" => "ei sellaista tiedostoa",
"downloads" => "imuroinnit",
"download" => "imuroi",
"attach" => "liitä",
"monitor this blog" => "tarkkaile tätä blogia",
"hide categories" => "piilota luokittelut",
"Admin categories" => "Admin luokittelut",
"browse category" => "selaa luokkaa",
"reply" => "vastaa",
"monitor this topic" => "tarkkaile tätä aihetta",
"active perms" => "aktiiviset oikeudet",
"with checked" => "merkityt",
"move selected files" => "siirrä valitut tiedostot",
"Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Paina seuraavaa linkkiä varmistaaksesi salasanan uudelleen asetuksen ja mene näytölle jolla voit vaihtaa \"pysyvän\" salasanan. Valitse salasana jonka vain itse tiedät, äläkä kerro sitä kenellekään.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nTehty! Olet kirjautunut sisään.",
"Thank you for you registration. You may log in now." => "Kiitos rekisteröinnistäsi. Nyt voi kirjautua normaalisti.",
"Zoom out x4" => "Suurenna x4",
"Zoom out x3" => "Suurenna x3",
"Zoom in x3" => "Pienennä x3",
"Zoom in x4" => "Pienennä x4",
"from\nthe mapfile:" => " \nkarttatiedostosta:",
"compare" => "vertaa",
"diff" => "erot",
"older version" => "vanhempi versio",
"Click the :: options in the Menu for more options." => "Paina :: vaihtoehdosta saadaksesi lisää valikko vaihtoehtoja.",
"Please, also see" => "Katso myös",
"for more setup details." => "lisää asetus yksityiskohtia.",
"Note 1:" => "Huomio 1:",
"You can remove this module in" => "Voit poistaa moduulin täältä",
"as well as assign or edit many others." => "tai liitä ja muokkaa monia muita.",
"Note 2:" => "Huomio 2:",
"The menu module installed by default is named" => "Oletuksena asennettu valikko moduuli on nimetty",
"it is a \"custom module\" which includes menu ID " => "se on \"muokattu moduuli\" jolla on valikko ID ",
"That menu is stored in database and it can be edited from " => "Se valikko on varastoitu tietokantaan ja voi muuttaa ",
"Do not mix this with the original <em>application_menu</em> module" => "Älä sekoita tätä alkuperäiseen <em>ohjelmat valikko</em> moduuliin",
"That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "Sitä voi muokata jotta se sopisi tyyliin, mutta sen voi tehdä vain muokkaamalla mod-application_menu.tpl tiedostoa \"käsin\"",
"del" => "pois",
"Create pdf" => "Luo pdf",
"1 file attached" => "1 liite tiedosto",
"categories" => "luokkaa",
"List pages where I am a creator" => "Listaa sivut joilla olen luojana",
"by creator" => "luojana",
"List pages where I am a modificator" => "Listaa sivut joita olen muokannut",
"by modificator" => "muokkaajana",
"at tracker" => "kortistossa",
"calendar view" => "kalenteri näyttö",
"check / uncheck all" => "merkitse / poista merkintä kaikista",
"Tiki sections and features" => "Osastot ja ominaisuudet",
"tikiwiki.org help" => "tikiwiki.org apu",
"Site Logo and Identity" => "Sivusto Logo ja Identity",
"Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Käytä Lainaus plugia mieluummin kuin &ldquo;>&rdquo; lainauksiin",
"Storing files in a directory" => "Tiedostot varastoidaan hakemistoon",
"please read" => "ole hyvä ja lue",
"yes" => "kyllä",
"Click here for more details." => "Paina tästä saadaksesi lisätietoja.",
"Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "Sivuston kokoonpanon kenttäarvo tietokannassa on asetettu max. 250 pituiseksi oletuksena nyt. Se on myös muokatussa koodisisällössä. Tarkista tämä kenttä jos haluat päivittää kokoonpanoasi että tietokanta tukee suurempia kuin 250 merkkiä (testattu ja toimii ainakin mysql, Aina kun teet tietokanta muutoksia tee käsin varmuuskopiot)",
"Users &amp; groups" => "Käyttäjät &amp; ryhmät",
"Local" => "Paikallinen",
"private" => "yksityinen",
"<b>Item</b>" => "<b>Osa</b>",
"<b>Value</b>" => "<b>Arvo</b>",
"This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS Modules\" on the application menu, or" => "Tämä sivu on kokoonpano sivu RSS syötteille jotka muodostetaa/tulostetaan sivuston. Lukeaksesi/hakeaksesi RSS syötteen, katso \"RSS moduulit\" ohjelmisto valikossa, tai",
"<b>Feed</b>" => "<b>Syöte</b>",
"<b>enable/disable</b>" => "<b>päälle/pois</b>",
"<b>Max number of items</b>" => "<b>Maksimi määrä osia</b>",
"Feed for Articles" => "Syöte Artikkeleille",
"Feed for Weblogs" => "Syöte Weblogeille",
"Feed for Image Galleries" => "Syöte Kuva Gallerioille",
"Feed for File Galleries" => "Syöte Tiedosto Gallerioille",
"Feed for the Wiki" => "Syöte Wiki",
"Feed for individual Image Galleries" => "Syöte yksittäiselle Kuva Gallerialle",
"Feed for individual File Galleries" => "Syöte yksittäiselle Tiedosto Gallerialle",
"Feed for individual weblogs" => "Syöte yksittäiselle weblogille",
"Feed for individual forums" => "Syöte yksittäiselle foorumille",
"Feed for mapfiles" => "Syöte karttatiedostoille",
"Feed for directories" => "Hakemistojen syöte",
"Feed for individual tracker items" => "Syöte yksittäisen kortiston osille",
"Feed for tracker items" => "Kortisto osien syöte",
"Feed for upcoming calendar events" => "Syöte tuleville kalenteri tapahtumille",
"Prefix breadcrumbs with 'Location:' label?" => "Etuliite palasta ja 'Sijainti:' etiketti?",
"Site Search" => "Sivusto Etsintä",
"Change style only" => "Muuta vain tyyli",
"WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely" => "WAROITUS : Vanha ja uusi kortisto eivät voi esiintyä yhtaikaa. Kortistot jotka on luotu uuden kirjaston alaisena\nei näy vanhalla ja päinvastoin",
"PDF generation" => "PDF luonti",
"IP not displayed in history" => "IP:tä ei näytetä sivuhistoriassa",
"Use in CMS" => "Käytä cms:ssä",
"Use in Wiki" => "Käytä wikissä",
"Use in newsletters" => "Käytä uutislehdessä",
"Use in events" => "Käytä tapahtumia",
"Use in HTML pages" => "Käytä HTML sivuilla",
"Edit Existing Forums" => "Muuta olemassa olevia foorumeja",
"Refresh rate (if dynamic) [secs]" => "Päivitys väli (jos muuttuva) [sek]",
"configure repositories" => "säilytyspaikan kokoonpano",
"configure this repository" => "Muuta säilytyspaikan kokoonpanoa",
"copy rules" => "kopio säännöt",
"Create/edit newsletters" => "<Luo/muokkaa uutislehteä",
"subscriptions" => "tilaus",
"archives" => "arkistot",
"Use Admin Email" => "Käytä ylläpidon sähköpostia",
"Edit or add poll options" => "Muuta tai lisää äänestys vaihtoehtoja",
"configure polls" => "muokkaa äänestyksiä",
"Create/edit Polls" => "Luo/muuta Äänestyksiä",
"Tip: hold down CTRL to select multiple" => "Vihje: paina CTRL alas valitaksesi useampia",
"Rss channels" => "Rss kanavat",
"show pubdate" => "näytä julkaisupäivä",
"activate" => "aktivoi",
"Admin tracker" => "Ylläpidä kortistoa",
"Edit this tracker" => "Muokkaa tätä kortistoa",
"View this tracker items" => "Näytä tämän kortiston osat",
"Edit tracker fields" => "Muokkaa kortiston kenttiä",
"Import/export trackers fields" => "Tuonti/vienti kortiston kentistä",
"Edit tracker" => "Muuta kortisto",
"Create trackers" => "Luo kortistoja",
"Import/export" => "Tuonti/vienti",
"fields" => "kentät",
"active permissions" => "aktiiviset oikeudet",
"Create/edit trackers" => "Luo/muokkaa kortistoja",
"filename" => "tiedostonimi",
"filesize" => "tiedostokoko",
"filetype" => "tiedostoyyppi",
"longdesc" => "pitkäkuvaus",
"Add a new group" => "Lisää uusi ryhmä",
"Edit item" => "Muuta osaa",
"List all members" => "Listaa kaikki jäsenet",
"Add a new user" => "Lisää uusi käyttäjä",
"manage group assignments" => "hallitse ryhmä liitoksia",
"set default groups" => "aseta oletus ryhmät",
"Popup Window" => "Popup ikkuna",
"details" => "yksityiskohdat",
"change focus" => "muuta keskitystä",
"quater" => "neljäsosa",
"quarter" => "neljännes",
"semester" => "puolivuotis",
"No individual permissions global permissions apply" => "Ei erityisoikeuksia yleiset oikeudet liitetään",
"Welcome to the Tiki Chat Rooms" => "Tervetuloa Sivuston JuttuHuoneisiin",
"Please select a chat channel" => "Valitse juttu kanava",
"enter chat room" => "mene juttu huoneeseen",
"There are no channels setup, please contact a site admin" => "Ei ole kanava asetusta, ota yhteyttä ylläpitoon",
"Chatroom" => "Juttuhuone",
"Active Channels" => "Aktiiviset Kanavat",
"Users in this channel" => "Käyttäjiä tällä kanavalla",
"Channel Information" => "Kanava tiedot",
"Channel" => "Kanava",
"Ratio" => "Suhde",
"Use :nickname:message for private messages" => "Käytä :lempinimi:viesti yksityis viesteille",
"Use [URL|description] or [URL] for links" => "Käytä [URL|kuvaus] tai [URL] linkkejä",
"Use (:smileyname:) for smileys" => "Käytä (:hymiönimi:) hymiöille",
"Create PDF" => "Luo PDF",
"PDF Settings" => "PDF Asetukset",
"Select Wiki Pages" => "Valitse Sivu",
"Remove Page" => "Poista sivu",
"click here to send us an email" => "paina, lähettääksesi meille sähköpostia",
"Add or edit a site" => "Lisää tai muokkaa sivustoa",
"sites" => "sivustot",
"cool sites" => "siistit sivustot",
"Use ...page... to separate pages in a multi-page article" => "Käytä ...sivu... erotellaksesi sivut monisivuisessa artikkelissa",
"Create Zone" => "Luo alue",
"use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "käytä hakasulkuja ulkoisia linkkejä varten: [URL] tai [URL|linkin_kuvaus] tai [URL|kuvaus|eipuskuria]  (viimeisin muoto estää sivustoa puskuroimasta sivua; käytä sitä kun sivulla on paljon tavaraa!).",
"browse image" => "katso kuva",
"translate" => "käännä",
"Create or edit content" => "Luo tai muuta sisältöä",
"this quiz stats" => "tämän visailut tilasto",
"answer" => "vastaus",
"Edit Translation:" => "Muokkaa Käännöstä:",
"Use this section to set the language of the version you are currently working on." => "Käytä tätä osastoa asettaaksesi kielen versio jota työstät.",
"Set of Translations" => "Käännökset",
"Select the article for which the current article is the translation." => "Valitse artikkeli josta nykyinen artikkeli on käännös.",
"Translation of:" => "Käännetty:",
"Enter the name of the page for which the current page is the translation." => "Kirjoita sivun nimi josta nykyinen sivu on käännös.",
"Add to the Set" => "Lisää sarjaan",
"graph" => "graafi",
"Edit FAQ questions" => "Muokkaa UKK kysymyksiä",
"Edit this file gallery:" => "Muokkaa tätä tiedosto galleriaa:",
"icon" => "kuvake",
"Other users can upload files to this gallery" => "Muut käyttäjät voivat lähettää tiedostoja galleriaan",
"Available File Galleries" => "Saatavilla olevat Tiedosto Galleriat",
"configure forum" => "foorumin kokoonpano",
"start" => "aloita",
"end" => "loppu",
"roles" => "tehtävät",
"Add role" => "Lisää tehtävä",
"active process" => "aktiivinen prosessi",
"invalid" => "toimimaton",
"invalid process" => "toimimaton prosessi",
"valid process" => "toimiva prosessi",
"activities" => "toiminnot",
"aborted" => "keskeytetty",
"value" => "arvo",
"proc" => "pros",
"exceptions" => "poikkeukset",
"rollback" => "taaksekelaus",
"Create or edit content block" => "Luo tai muokkaa sisältö blokkia",
"Listing Gallery" => "Galleria Listaus",
"Gallery Files" => "Gallerian Tiedostot",
"Last ver" => "Viimeisin ver",
"Com" => "Kom",
"Vers" => "Ver",
"To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>." => "Oppiaksesi lisää <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>.",
"subscribe" => "tilaa",
"Sent edition" => "Lähetä esitys",
"Subscribe to newsletter" => "Tilaa uutislehti",
"Add or edit a news server" => "Lisää tai muuta uutispalvelinta",
"rollback to this version" => "takaisin tähän versioon",
"Print Wiki Pages" => "Tulosta Wiki Sivut",
"add page" => "lisää sivu",
"add structure" => "lisää rakenne",
"P" => "Os",
"F" => "Ko",
"entire site" => "koko sivusto",
"click to navigate" => "paina siirtyäksesi",
"Total threads" => "Ketjuja kaikkiaan",
"Average threads per topic" => "Ketjuja keskimäärin per aihe",
"You can include the file in an HTML/Tiki page using" => "Voit lisätä tiedoston HTML/normaali sivulle käyttäen",
"Now enter the file URL" => "Kirjoita tiedoston URL",
" or upload a local file from your disk" => " tai lähetä oma tiedostosi kovalevyltäsi",
"Add or edit folder" => "Lisää tai muokka kansiota",
"Add or edit a URL" => "Lisää tai muokkaa URL:ia",
"received" => "vastaanotettu",
"submitted" => "lähetetty",
"shared" => "jaettu",
"accepted by task user and creator" => "hyväksytty tehtävän tekijän ja luojan puolesta",
"accepted user and creator" => "hyväksytyt käyttäjä ja luoja",
"not accepted by one user" => "yksi käyttäjä ei ole hyväksynyt",
"not accepted user" => "ei hyväksyntää käyttäjä",
"waiting for me" => "odottaa minua",
"waiting for other user" => "odottaa muita käyttäjiä",
"red" => "punainen",
"move into trash" => "siirrä roskikseen",
"waiting / not started" => "odottaa / ei käynnistetty",
"waiting" => "odottaa",
"shared for group" => "jaettu ryhmälle",
"accepted by user" => "hyväksynyt käyttäjä",
"no / rejected" => "ei / hylätty",
"accepted by creator" => "hyväksynyt luojana",
"priority" => "ensisijaisuus",
"select one" => "valitse yksi",
"undo trash" => "peruuta roskis",
"show:" => "näytä:",
"all shared tasks" => "kaikki jaetut tehtävät",
"previous chart" => "edellinen kaavio",
"next chart" => "seuraava kaavio",
"pos" => "paik",
"pre" => "edel",
"permanency" => "pysyvyys",
"avg" => "keskim",
"post new comment" => "lähetä uusi kommentti",
"Post New Comment" => "Lähetä uusi kommentti",
"HTML tags are not allowed inside comments" => "HTML tagit eivät ole sallittuja kommenteissa",
"moderator actions" => "moderaattorin toiminnot",
"move selected topics" => "siirrä valitut aiheet",
"unlock selected topics" => "avaa valitut aiheet",
"lock selected topics" => "lukitse valitut aiheet",
"merge" => "yhdistä",
"merge selected topics" => "yhdistä valitut aiheet",
"reported messages:" => "raportoidut viestit:",
"queued messages:" => "Viestit jonossa:",
"emot" => "tunt",
"Edit fields" => "Muuta kenttiä",
"View item" => "Näytä osa",
"Add a comment" => "Lisää kommentti",
"account" => "tili",
"Projects" => "Projektit",
"Projects configuration" => "Projektien kokoonpano",
"Site Identity features" => "Sivusto Yksilöinti ominaisuus",
"Click here to delete this category" => "Paina tästä poistaaksei tämäm luokan",
"Group doesnt exist" => "Ryhmää ei ole olemassa",
"User doesnt exist" => "Käyttäjää ei ole olemassa",
"Event without Name" => "Nimetön tapahtuma",
"Invalid old password" => "Väärä vanha salasana",
"No channel indicated" => "Ei kanavaa osoitettu",
"No nickname indicated" => "Ei lempinimeä osoitettu",
"No permission to view the page" => "Ei oikeutta katsoa sivua",
"I have refused your friendship request!" => "Olen hylännyt ystävyyspyyntösi!",
"Please create a directory named \$map_path to hold your map files." => "Luo hakemisto nimeltä \$map_path säilyttääksesi karttatiedostoja.",
"Permision denied" => "Lupa evätty",
"A new (and temporary) password and your IP address has been sent " => "Uusi (ja väliaikainen) salasana ja IP osoite on lähetetty ",
"Phillippines" => "Filippiinit",
"sender" => "lähettäjä",
"subject" => "otsake",
"date" => "päiväys",
"flagged" => "merkitty",
"mark" => "merkitse",
"find replied message" => "etsi vastatut viestit",
"replied" => "vastattu",
"Click" => "Paina",
"posted by" => "lähettänyt",
"email this post" => "sähköpostita tämä lähetys",
"Tag name" => "Tagin nimi",
"Enable wiki 3D browser" => "Oikeuta 3D selain",
"Load page on navigation" => "Lataa navikointi sivu",
"Existing page node color" => "Olemassa olevan sivun solmu väri",
"Missing page node color" => "Puuttuvan sivun solmu väri",
"Anonymous editors must input anti-bot code" => "Tuntemattoman käyttäjän on annettava anti-bot koodi",
"Edit idle timeout" => "Muokkauksen odotusaika loppui",
"Use page description" => "Käytä sivun kuvausta",
"Show page title" => "Näytä sivun otsikko",
"Show page ID" => "Näytä sivu ID",
"Cache wiki pages (global)" => "Puskuroi sivut (yleinen)",
"Users can lock pages (if perm)" => "Käyttäjä voi lukita sivut (jos lupa)",
"Use WikiWords" => "Käytä WikiSanoja",
"Use Wiki paragraph formatting" => "Käytä sivun kappale muotoilua",
"Use external link icons" => "Käytä ulkoisia linkki iconeja",
"User's Page" => "Käyttäjän Sivu",
"UserPage prefix" => "KäyttäjäSivun etuliite",
"List authors" => "Listaa kirjoittajat",
"Print Page" => "Tulosta Sivu",
"Maximum number of versions for history" => "Maksimi määrä versio historiaa",
"Never delete versions younger than days" => "Älä poista päivää nuorempia versioita",
"Diff style" => "Erilainen tyyli",
"This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "Tämä toimii hyvin (tai ei!) riippuen käyttämästäsi teemasta. Oppiaksesi lisää <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
"Old vers" => "Vanha vers",
"Add or edit event" => "Lisää tai muuta tapahtumaa",
"merge selected notes into" => "yhdistä valitut huomiot",
"Faq Stats" => "Ukk Tilastot",
"Edit User Files" => "Muokkaa käyttäjä tiedostoja",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Viestisi on laitettu jonoon hyväksyntää varten, viesti lähtetetään kun \na ylläpito hyväksyy sen.",
"Webmail Doc" => "Verkkoposti Doc",
"Webmail Doc template" => "Verkkoposti Doc malli",
"settings" => "asetukset",
"mailbox" => "postilaatikko",
"compose" => "muodosta",
"contacts" => "yhteydet",
"clip" => "pala",
"back to mailbox" => "takaisin postilaatikkoon",
"full headers" => "täydet pääosat",
"normal headers" => "tavalliset pääosat",
"reply all" => "vastaa kaikille",
"forward" => "lähetä edelleen",
"select from address book" => "valitse osoitekirjasta",
"cc" => "kopio",
"item found" => "osa löytynyt",
"items found" => "osaa löytynyt",
"A wildcard pattern of originating pages to be ignored.<br />" => "Jokerimerkki kuvio huomiotta jätettävistä sivuista.<br />",
"The character, by which ignored patterns are separated.<br />" => "Merkki, jolla huomiotta jätettävät kuviot on eroteltu.<br />",
"Whether to include external wikis in the list.<br />" => "Liittääksesi ulkoiset sivut listaan.<br />",
"Collect either originating or wanted pages in a cell and display them in the second column.<br />" => "Kootaan lähtöarvojen tai haluttujen sivujen mukaan kennoon ja näytetään ne toisella palstalla.<br />",
"Switch-on debug output with details about the items.<br />" => "Laita yksityiskohtainen osien debug tulostus päälle.<br />",
"Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />" => "Useat kerätyt osat on eroteltu taulukko riveillä, tai pilkulla tai rivityksellä yhdessä kennossa.<br />",
"Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />" => "Suodattaa haluttujen sivujen listan näyte sivu_regex:llä tai omalla suotimella. Oletus arvo on sivuston __nykyinen__ sivu_regex.<br />",
"A custom filter for wanted pages to be listed (only used when level=>custom).<br />" => "Oma suodin haluttujen sivujen listaukseen (käytetään vain kun taso on =>muokattu).<br />",
"tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
"hist" => "hist",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Tekstivaihtoehdot: 1,koko,lisäalkuun,lisäys,maximi merkkien määränä, lisäysalkuun näytetään ensin, lisäys kenttä näytetään heti sen jälkeen, max on maksimi määrä merkkejä jotka voidaan tallentaa, ja merkintä 1 seuraavan kentän tai merkintälaatikon samalle riville. Jos valintasi on 1 se tarkoittaa, että seuraava kenttä on samalla rivillä myös.",
"Checkbox options: put 1 if you need that next field is on the same row." => "Merkintälaatikko valinnat: laita 1 jos tarvitset kentän samalle riville.",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numeeriset valinnat: 1,koko,lisäalkuun,lisäys maximi merkkien määränä, lisäys alkuun näytetään ensin, lisäys kenttä näytetään heti sen jälkeen, ja merkintä 1 tehdäksesi seuraavan kentän tai merkintälaatikon samalle riville. Jos valitaan vain 1 se tarkoittaa, että seuraava kenttä on samalla rivillä myös.",
"Dropdown options: list of items separated with commas." => "Alasveto valinnat: listaus osista eroteltuna pilkulla.",
"Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Ryhmä Valitsin: käytä valintoja automaattiseen kenttien täyttöön : valitse 1 luoja ryhmälle ja 2 muokkaaja ryhmälle. Oletus ryhmä on asetettava, tai ryhmä jonka käyttäjä valitsee, tai oletus ryhmä on rekisteröityneet.",
"Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Toiminto vaihtoehdot: Etiketti,postitukset,tiki-index.php,sivu:kenttänimi,korosta=testi",
"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Osien listaus vaihtoehdot: kortistoId,kenttäIdSiellä, kenttäIdTäällä, näyttökenttäIdSiellä, linkkiOsiin näyttää listauksen näyttöKenttäIdSiellä osasta kortistoa jonka kortistoId:n kenttäIdSiellä täsmää kenttäIdTäällä. linkkiOsiin 1|0 luodaksesi linkin näytöllä olevan osaan ja listaukseen",
"Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Sähköposti Osoitteen vaihtoehdot: 0|1|2 missä 0 on tavallista tekstiä, 1 tekee hex-koodatun linkin osoitteeseen (vaikeampi vakoojille selvittää joten vähemmän roskapostia) ja 2 tekee normaalin href mailto linkin.",
"Formula" => "Kaava",
"No formula specified." => "Ei kaavaa määritelty.",
"Impossible to render the graphic." => "Mahdotonta muodostaa grafiikkaa.",
"View graphic" => "Näytä grafiikka",
"new sites" => "uudet sivustot",
"Message Broadcast" => "Viestilähetys",
"Paramaters" => "Parametrit",
"Are you sure you want to remove this module?" => "Oletko varma, että haluat poistaa tämän moduulin?",
"database queries used" => "tietokanta kyselyjä",
"{\$atts_cnt} files attached" => "{\$atts_cnt} liite tiedostoa",
"pass" => "salasana",
"Page generated in" => "Sivu luotu",
"sent" => "lähetä",
"Homework" => "Kotitehtävä",
"Assignments" => "Liitokset",
"Favorites" => "Mieltymykset",
"Member list" => "Jäsen luettelo",
"Back to Homepage" => "Takaisin etusivulle",
"Edit Summary" => "Muokkaa Yhteenvetoa",
"Minor" => "Pieni",
"RSS Trackers" => "RSS Kortistot",
"Last update from CVS" => "Viimeksi päivitetty CVS:stä",
"Translate in" => "Käännä",
"babelfish it" => "babelfish se",
"Welcome to" => "Tervetuloa",
"Content Features" => "Sisältö Ominaisuudet",
"Contact Us (Anonymous)" => "Ota Yhteyttä (Nimettömänä)",
"Prevent automatic/robot registration" => "Estä automaattinen/robotin rekisteröinti",
"Site Logo" => "Sivusto Logo",
"Admin Groups Template" => "Ylläpidä ryhmä malli",
"Help on Banning System" => "Avusta Poisto Järjestelmässä",
"Admin banning tpl" => "Ylläpidon esto tpl",
"Create/edit Calendars" => "Luo/muokkaa Kalentereita",
"Admin Categories tpl" => "Ylläpidä luokittelujen tpl",
"charts" => "kaaviot",
"Admin Charts Template" => "Ylläpidä kaavion mallia",
"Chat Administration" => "Juttelu Ylläpidolle",
"Chat Admin" => "Puhu Ylläpidolle",
"Chat Admin tpl" => "Puhu Ylläpidolle tpl",
"Create/edit channel" => "Luo/muokkaa kanavaa",
"Half a second" => "Puoli sekuntia",
"second" => "sekunti",
"Chat channels" => "Juttu kanavat",
"Admin Content Templates Template" => "Ylläpidä sisälltö mallin mallia",
"Help on Drawings" => "Auta Piirroksissa",
"Admin DSN" => "Ylläpidä DSN",
"Admin Forums Template" => "Ylläpidä foorumien malli",
"Admin Hotwords Template" => "Ylläpidä kuumasanojen malli",
"Admin Featured Links" => "Ylläpidä ominaisuus linkit",
"Admin Featured Links Template" => "Ylläpidä ominaisuus linkkien malli",
"To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "Käyttääksesi näitä linkkejä, on ominaisuus linkki liitettävä modulina <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> moduuli</a>.",
"Admin Webmail" => "Ylläpidä Webmail",
"Admin Mailing Template" => "Ylläpidä postitsisään malli",
"Admin Menu Builder" => "Ylläpidä valikon rakentajaa",
"Admin Menus Template" => "Ylläpidä valikko malli",
"Admin Modules Template" => "Ylläpidä moduulien malli",
"Assign Module" => "Liitä moduuli",
"Edit/Create" => "Muokkaa/Luo",
"subscribed" => "tilattu",
"Admin Newsletters Template" => "Ylläpidä uutiskirjeen malli",
"Admin Notifications Template" => "Ylläpidon huomautus malli",
"Admin Polls Template" => "Ylläpidä äänestys malli",
"Configure Polls" => "Muokkaa äänestyksiä",
"tiki admin quicktags template" => "sivusto ylläpito pikatagien malli",
"Score System" => "Piste Järjestelmä",
"security admin" => "turvallisuus ylläpito",
"security admin tpl" => "turvallisuus ylläpito tpl",
"Admin Shoutbox Words Template" => "Ylläpidä pikaviesti sanojen malli",
"Edit survey questions" => "Muuta tutkimuksen kysymyksiä",
"administer surveys template" => "ylläpidä tutkimuksen malli",
"system admin" => "järjestelmän ylläpito",
"system admin tpl" => "järjestelmän ylläpito tpl",
"Admin Topics Template" => "Ylläpidä aiheiden malli",
"Admin Tracker" => "Ylläpidä kortistoa",
"Admin Users Template" => "Ylläpidä käyttäjien malli",
"Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Waroitus: nimen muutokseen tarvitaan käyttäjä vaihtamaan salasana ja sekoittaa orja intertiki sivuston joka käyttää tätä isäntänä",
"Warning: changing the username will require the user to change his password" => "Waroitus: jos muutat käyttäjänimen tarvitaan käyttäjä muuttamaan salasana",
"Again" => "Uudelleen",
"Article Types tpl" => "Artikkeli Tyyppien tpl",
"Assign permissions to group" => "Liitä oikeudet ryhmälle",
"Edit Article Tpl" => "Muokkaa artikkeli tpl",
"Browsing Gallery" => "Gallerian Selaus",
"Admin Directory tpl" => "Ylläpidä hakemisto tpl",
"Admin Directory Categories tpl" => "Ylläpidä hakemisto luokittelujen tpl",
"Admin Directory Related" => "Ylläpidä Hakemistoon Liittyvät",
"directory admin related tpl" => "hakemiston ylläpitoon liittyvä tpl",
"Admin Directory Sites" => "Ylläpidä Hakemisto Sivustoja",
"Admin Directory Sites tpl" => "Ylläpidä Hakemisto Sivusto tpl",
"Validate Sites" => "Hyväksy Sivustot",
"directory validate sites tpl" => "hakemisto hyväksy sivustot tpl",
"Edit Article" => "Muokkaa Artikkelia",
"Edit Blog Tpl" => "Muuuta blog tpl",
"Show Plugins Help" => "Näyttää Plugi Avun",
"Show Text Formatting Rules" => "Näyttää tekstin muotoilu säännöt",
"Program dynamic content for block" => "Ohjelmoi muuttuva sisältö blokille",
"Admin quizzes" => "Ylläpidä visailuja",
"Admin Quizzes tpl" => "Ylläpidä visailut tpl",
"Edit Quiz Questions" => "Muokkaa visailun kysymyksiä",
"Edit Quiz Questions Tpl" => "Muokkaa visailun kysymyksiä tpl",
"Help on Articles" => "Auta Artikkeleissa",
"Edit Submissions Tpl" => "Muokkaa ehdotus tpl",
"EditTemplates" => "MuutaMallia",
"EditTemplates tpl" => "MuutaMallia tpl",
"Edit Translations" => "Muokkaa käännöksiä",
"Edit Translations Template" => "Muokkaa käännöksiä malli",
"Message queue for" => "Viesti jono",
"back to forum" => "takaisin foorumille",
"Reported messages for" => "Raportoidut viestit",
"friends tpl" => "ystävät tpl",
"galleries tpl" => "galleriat tpl",
"ImportingPagesPhpWikiPageAdmin" => "TuoSivutPhpWikiSivuYlläpito",
"tiki-import_phpwiki tpl" => "tiki-tuonti_phpwiki tpl",
"List Articles Tpl" => "Listaa artikkelit tpl",
"Admin Cache" => "Ylläpidä puskuri",
"Admin Cache tpl" => "Ylläpidä puskuri tpl",
"Help on Dynamic Content" => "Auta Muuttuvassa Sisällössä",
"List FAQs Tpl" => "Listaa ukk tpl",
"games tpl" => "pelit tpl",
"List Posts Tpl" => "Listaa lähetys tpl",
"List Quizzes Tpl" => "Listaa visailu tpl",
"Edit Quiz Stats Tpl" => "Muokkaa visailu tilastoja tpl",
"List Trackers Tpl" => "Listaa kortistot tpl",
"Admin Live Support tpl" => "Ylläpidä elävä tuki tpl",
"back to admin" => "takaisin ylläpitoon",
"User Calendar" => "Käyttäjä Kalenteri",
"User Calendar Doc tpl" => "Käyttäjä Kalenteri Doc tpl",
"User Calendar Doc" => "Käyttäjä Kalenteri Doc",
"User Calendar Preferences Doc tpl" => "Käyttäjä Kalenteri Kokoonpano Doc tpl",
"my tiki tpl" => "oma sivu tpl",
"Subscribe to This Newsletter" => "Tilaa",
"Stats for quiz" => "Visailun tilasto",
"Received Articles" => "Vastaanotetut Artikkelit",
"received articles tpl" => "vastaanotetut artikkelit tpl",
"Help on Communication Center" => "Auta Yhteistoiminta Keskuksessa",
"received pages tpl" => "vastaanotetut sivut tpl",
"Rename page" => "Nimeä sivu",
"to_version" => "versioon",
"search stats tpl" => "etsintä tilastot tpl",
"Admin Send Objects tpl" => "Ylläpidä lähetä kohteet tpl",
"sheets tpl" => "arkkien tpl",
"Stats for survey" => "Tutkimuksen tilasto",
"system logs" => "järjestelmä logit",
"system logs tpl" => "järjestelmä logit tpl",
"Theme Control Center: categories" => "Teeman Hallinta Keskus: luokittelut",
"ThemeControl" => "TeemaHallinta",
"ThemeControl tpl" => "TeemaHallinta tpl",
"ThemeControl Objects" => "TeemaHallinta Kohteet",
"theme control objects tpl" => "teeman hallinta kohteet tpl",
"Theme Control Center: sections" => "Teeman Hallinta Keskus: osastot",
"theme control sections tpl" => "teeman hallinta osastot tpl",
"File Title" => "Tiedosto Otsikko",
"Image Gallery tpl" => "Kuva Galleria tpl",
"User Assigned Modules" => "Käyttäjän Liittämät Moduulit",
"User Assigned Modules tpl" => "Käyttäjän Liittämät Moduulit tpl",
"User Bookmarks tpl" => "Käyttäjän Kirjanmerkki tpl",
"UserPreferences tpl" => "KäyttäjäKokoonpanot tpl",
"User Tasks tpl" => "Käyttäjä Tehtävät tpl",
"User Watches tpl" => "Käyttäjä Vahdit tpl",
"View FAQ Tpl" => "Näytä ukk tpl",
"Admin Menus tpl" => "Ylläpidä valikoiden tpl",
"IRC log" => "IRC logi",
"Edit mail account" => "Muokkaa postitiliä",
"Add new mail account" => "Lisää uusi postitili",
"User accounts" => "Käyttäjä tilit",
"View All" => "Näytä Kaikki",
"Msg" => "Viesti",
"Can't parse remote HTML page" => "Ei voi jäsentää ulkoista HTML sivua",
"Permission denied you cannot remove pages" => "Oikeutesi eivät riitä poistamaan sivuja",
"Debugger console" => "Debugger console",
"OS" => "OS",
"LDAP Base DN" => "LDAP Base DN",
"LDAP User DN" => "LDAP User DN",
"Geourl" => "Geourl",
"Zoom" => "Zoom",
"SysLog" => "SysLog",
"Cannot write to this file" => "Tähän tiedostoon ei voi kirjoittaa",
"Missing title or body when trying to post a comment" => "Puuttuu joko otsikko tai kuva kommentista",
"\\n for rows" => "\\n riveille",
"Use this thread to discuss the %s page." => "Käytä tätä ketjua keskusteluun %s sivusta.",
"Newsletter subscription information at " => "Tilaustiedot uutislehdestä ",
"Changes" => "Muutokset",
"categorize this object" => "luokittele tämä kohde",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Rekisteröinti pyyntösi on tallennettu ja ylläpito käsittelee ja aktivoi sen mahdollisimman pian.",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Uuden artikkelin lähettänyt: {\$mail_user} {\$mail_date|tiki_short_datetime} {\$mail_title} ",
"New article post at %s" => "Uuden artikkelin lähettänyt %s",
"Syntax highlighting" => "Syntaksi korostus",
"MyTiki Home" => "OmaSivu perus",
"My Files" => "Omat tiedostot",
"Mini calendar" => "Mini kalenteri",
"FriendsMenu" => "YstäväValikko",
"User list" => "Käyttäjä lista",
"Send Pages" => "Lähetä sivut",
"Received pages" => "Vastaanotetut sivut",
"Admin Posts" => "Ylläpidä posteja",
"Submit a New Link" => "Lähetä uusi linkki",
"Browse directory" => "Selaa hakemistoa",
"Admin Directory" => "Ylläpidä hakemistoa",
"Layer Management" => "Tasojen hallinta",
"List quizzes" => "Listaa visailut",
"ShtMenu" => "ShtValikko",
"List trackers" => "Listaa kortistot",
"Ephemerides Admin" => "Lyhytaikaisten Ylläpito",
"Charts Admin" => "Kaavioiden Ylläpito",
"I forgot my pass" => "Olen unohtanut salasanani",
"Click to see the ratings" => "Paina nähdäksesi luokitukset",
"Send trackback pings to:" => "Lähetä viittaustoiminnon pingit:",
"(comma separated list of URIs)" => "(pilkku erottelee listan URI:ja)",
"This is" => "Tämä on",
"by the" => " ",
"Tiki community" => "Tiki yhteisö",
"User identity features" => "Käyttäjän yksilöinti ominaisuudet",
"Use URI as Home Page" => "Käytä URI EtuSivuna",
"Default charset for sending mail:" => "Oletus kirjainasetus postin lähetykseen:",
"Mail end of line:" => "Lähetä lopetus:",
"Disallow access to the site (except for those with permission)" => "Älä salli pääsyä sivustolle (paitsi niiltä joilla on lupa)",
"Message to display when site is closed" => "Näytettävä viesti kun sivusto on suljettu",
"Disallow access when load is above the threshold (except for those with permission)" => "Älä salli palvelimen käyttöä kun kuormituskynnys ylittyy (paitsi niiltä joilla on lupa)",
"Max average server load threshold in the last minute" => "Palvelimen kuormituskynnys on juuri ylittynyt",
"Message to display when server is too busy" => "Viesti joka näytetään, kun palvelin on ylikuormitettu",
"Use cache for external images" => "Käytä puskuria ulkoisille kuville",
"Use gzipped output" => "Käytä pakattua tulostusta",
"output compression is active." => "tulostuksen pakkaus on päällä.",
"compression is handled by" => "pakkauksen käsittelee",
"Sender Email" => "Lähettäjän Sähköposti",
"Allow anonymous users to \"Contact Us\"" => "Sallii nimettömien käyttäjien \"Ottaa Yhteyttä\"",
"contact feature disabled" => "yhteyden otto ominaisuus poistettu",
"Session lifetime in minutes" => "Istunnon elinikä minuutteina",
"Proxy Host" => "Proxy Isäntä",
"Proxy port" => "Proxy portti",
"Please expect not found help-pages with the default-URL." => "Ei löytynyt avustesivuja oletus URL osoitteella.",
"Any help with the documentation is welcome." => "Kaikki apu ohjeiden tekoon on tervetullutta.",
"Locations separator" => "Sijainnin erottelija",
"User registration and login" => "Käyttäjän rekisteröinti ja kirjautuminen",
"Use WebServer authentication for Tiki" => "Käytä palvelinta varmennukseen",
"... but need admin validation" => "... mutta tarvitsee ylläpidon hyväksynnän",
"Use tracker for more user information" => "Käytä kortistoa muulle käyttäjä tiedoille",
"Use tracker for more group information" => "Käytä kortistoa muulle ryhmä tiedoille",
"Request passcode to register" => "Pyydä passikoodi rekisteröityäksesi",
"Php GD library required" => "Php GD kirjasto tarvitaan",
"Validate users by email" => "Varmista käyttäjät sähköpostilla",
"Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Muistuta salasanasta sähköpostilla (jos \"Tallenna teksti salasanat\" on aktivoitu.) Muutoin, Lähetä uusi salasana sähköpostilla",
"Store plaintext passwords" => "Varastoi teksti salasanat",
"Reg users can change password" => "Rekisteröitynyt käyttäjä voi vaihtaa salasanaa",
"Reg users can change language" => "Rekisteröityneet käyttäjät voivat vaihtaa kieltä",
"Restrict available languages" => "Rajoita saatavilla olevia kieliä",
"Available languages:" => "Saatavilla olevat kielet:",
"Force to use chars and nums in passwords" => "Pakota käyttämään kirjaimia ja numeroita salasanassa",
"Minimum password length" => "Salasanan minimi pituus",
"Password invalid after days" => "Salasana vanhenee päivien jälkeen",
"Remember me feature" => "Muista minut",
"Duration:" => "Kesto:",
"Remember me name" => "Muista minut nimi",
"Remember me domain" => "Muista minut domain",
"Remember me path" => "Muista minut polku",
"Protect against CSRF with a confirmation step" => "Suojele CSRF varmistus portain",
"Highlight Group" => "Korosta Ryhmä",
"Create user if not in Tiki?" => "Luo käyttäjä jos ei ole?",
"Create user if not in Auth?" => "Luo käyttäjä jos ei Auth?",
"Just use Tiki auth for admin?" => "Käytä vain varmistusta ylläpitäjälle?",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(jos asetettu, tämä ylikirjoittaa isännän ja portin alhaalta)",
"LDAP Host" => "LDAP Isäntä",
"LDAP Port" => "LDAP Portti",
"LDAP Scope" => "LDAP Kattavuus",
"LDAP User Attribute" => "LDAP Käyttäjä Ominaisuudet",
"LDAP User OC" => "LDAP Käyttäjä OC",
"LDAP Group DN" => "LDAP Ryhmä DN",
"LDAP Group Attribute" => "LDAP Ryhmä Ominaisuudet",
"LDAP Group OC" => "LDAP Ryhmä OC",
"LDAP Member Attribute" => "LDAP Jäsen Ominaisuudet",
"LDAP Member Is DN" => "LDAP Jäsen Is DN",
"LDAP Admin User" => "LDAP Ylläpito Käyttäjä",
"LDAP Admin Pwd" => "LDAP Ylläpito Pwd",
"CAS server hostname" => "CAS palvelimen isäntänimi",
"CAS server port" => "CAS palvelimen portti",
"CAS server path" => "CAS palvelimen polku",
"Change CAS preferences" => "Muuta CAS kokoonpanoa",
"Meta Keywords" => "Meta Avainsanat",
"Meta Description" => "Meta Kuvaus",
"Meta Author" => "Meta Kirjoittaja",
"meta robots" => "meta robotit",
"revisit after" => "uudelleen vieraillut",
"Allow Smileys" => "Salli Hymiöt",
"Hotwords in New Windows" => "Hotwords Uudessa Ikkunassa",
"Trackers attachments preferences" => "Kortisto liitteiden kokoonpanot",
"Trackers attachments" => "Kortistojen liitteet",
"To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "Lisätäksesi/muokataksesi sivuja helposti, lisää moduuli quick_edit \"Moduulit\" ohjelmisto valikosta, tai",
"Create a Tag for the Current Wiki" => "Luo Tagi Nykyiseen sivustoon",
"Restore the Wiki" => "Palauta Sivut",
"restore" => "palauta",
"Remove a Tag" => "Poista Tagi",
"Wiki Comments Settings" => "Kommenttien Asetukset",
"Wiki Administration" => "Ylläpito",
"Wiki Home Page" => "KotiSivu",
"Wiki Discussion" => "Wiki Keskustelut",
"Wiki Link Format" => "Wiki Linkin Muoto",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Hallitsee wiki linkin tunnistusta käyttäen sulkumerkkejä <i>((sivun nimi))</i>.",
"Wiki Page List Configuration" => "Sivusto Listaus Kokoonpano",
"Wiki 3D Browser Configuration" => "3D Selain Kokoonpano",
"Wiki Features" => "Wiki Ominaisuudet",
"Wiki History" => "Wiki Historia",
"Wiki Watch" => "Wiki Vahti",
"browse the category system" => "selaa luokittelu järjestelmää",
"Admin Charts" => "Ylläpidä kaavioita",
"Add new rule" => "Lisää uusi sääntö",
"EMail notifications" => "Sähköposti ilmoitus",
"Edit this RSS module:" => "Muokkaa tätä RSS moduulia:",
"Create new RSS module" => "Luo uusi RSS moduuli",
"Tikiwiki settings" => "Sivusto asetukset",
"Create/edit questions for survey" => "Luo/muuta tutkimuksen kysymyksiä",
"Active?" => "Aktiivinen?",
"Create Trackers" => "Luo kortistoja",
"Create/Edit Trackers" => "Luo/muokkaa kortistoja",
"tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "kortiston nimen on oltava yksilöllinen, kenttien nimien tulee olla yksilöllisiä \nkortistossa ja niiden käytävä SQL kyselyyn",
"Create item" => "Luo osa",
"Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Waroitus: koska tämä sivusto on orja muodossa, kaikki käsin lisätyt käyttäjätiedot ylikirjoitetaan isäntä sivuston tiedoilla, mukaan lukien käyttäjä oikeudet",
"Assign to Groups" => "Liitä ryhmiä",
"Delete this type" => "Poista tämä tyyppi",
"level configuration" => "taso kokoonpano",
"Browse gallery" => "Selaa galleriaa",
"Upload from disk" => "Lähetä kovalevyltä",
"Directory batch" => "Hakemisto erä",
"Browsing Image" => "Kuvan Selaus",
"Again please" => "Uudelleen, kiitos",
"Admin category relationships" => "Ylläpidä luokan suhteita",
"Validate links" => "Vahvista linkit",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Tiedoston nimien kanssa lisännyt -{\$user} muokattavissa, muut voivat kopioida tai käyttää mallina.",
"Im- Export Languages" => "Tuo- Vie Kieliä",
"disable" => "poista käytöstä",
"Create a file gallery" => "Luo tiedosto galleria",
"Support tickets" => "Tuki lipuille",
"Return to HomePage" => "Palaa EtuSivulle",
"Stats for this survey Questions " => "Tämän tutkimuksen kysymysten tilasto ",
"Batch upload" => "Joukko lähetys",
"1 suggestion" => "1 ehdotus",
"suggestions" => "ehdotusta",
"fields marked with a * are mandatory" => "kentät jotka on merkitty * ovat pakollisia",
"\$title" => "\$otsikko",
"Minor Edit" => "Pieni",
"The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => " \"Snarf plugi\" on asennettu. Sitä voi ylläpito käyttää sisällyttämään sivuja paikallisesta verkosta ja regex korvaukseen mistätahansa html:stä.",
"The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => " \"Regex plugi\" on asennettu. Sitä voi ylläpito käyttää minkätahansa html:n regex korvaamiseen.",
"The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => " \"Lsdir plugi\" on asennettu. Sitä voi ylläpito käyttää katsoakseen minkätahansa hakemiston sisältöä",
"The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => " \"Bloglist plugi\" on asennettu. Sitä voi ylläpito käyttää avaamaan yksityis blogin postia.",
"You can not download files" => "Et voi imuroida tiedostoja",
"cannot be found" => "ei löydy",
"Invalid password.  Your current password is required to change administrative information" => "Väärä salasana.  Nykyinen salasanasi tarvitaan muuttaaksesi ylläpidollisa tietoja",
"Please wait 2 minutes between posts" => "Odota 2 minuuttia lähetysten välillä",
"The text in RED is" => "PUNAINEN teksti on",
"Old:" => "Vanha:",
"New:" => "Uusi:",
"Show Categories" => "Näytä luokittelut",
"Hide Categories" => "Piilota luokittelut",
"Wiki page %s changed" => "Sivu %s muuttunut",
"Blog features" => "Blogi ominaisuudet",
"Blog level comments" => "Blogi tason kommentit",
"Post level comments" => "Lähetys tason kommentit",
"Post level trackback pings" => "Lähetys tason viittaustoiminnon pingit",
"Spellchecking" => "Oikeinkirjoitus",
"Default ordering for blog listing" => "Oletus järjestys blogilistalle",
"Blog listing configuration (when listing available blogs)" => "Blogi listauksen asetukset (kun listataan saatavilla olevia blogeja)",
"Last modification time" => "Muokattu viimeksi",
"Blog comments settings" => "Blogi kommenttien asetukset",
"Group calendar sticky popup" => "Ryhmä kalenterin pysyvä popup",
"Group calendar item view tab" => "Ryhmä kalenterin osan näyttö tabi",
"Calendar manual selection of time/date" => "Kalenterin ajan/päiväyksen valinta käsin",
"Show Category Path" => "Näytä Luokan Polku",
"Show Category Objects" => "Näytä Luokan Kohteet",
"Search may show forbidden results. Much better performance though." => "Etsintä voi näyttää kiellettyjä tuloksia. Parempi suorituskyky.",
"CMS features" => "CMS ominaisuudet",
"Use templates" => "Käytä malleja",
"Settings for page articles home" => "Asetukset artikkelien perus sivulle",
"Maximum number of articles in home" => "Artikkeleiden suurin määrä kotona",
"Article comments settings" => "Artikkeli kommenttien asetukset",
"Fields to display on page" => "Sivulla näytettävät kentät",
"Expire Date" => "Poistumis päivä",
"Copyright Management" => "Copyright Hallinta",
"License Page" => "Lisenssi Sivu",
"Submit Notice" => "Toimita Huomautus",
"To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "Lisätäksesi/poistaaksesi tiedoston galleriasta, mene \"Tiedosto Galleriat\" ohjelmisto valikossa, tai",
"Uploaded filenames must match regex" => "Lähetettyjen tiedostojen nimien täytyy sopia yhteen regex kanssa",
"Uploaded filenames cannot match regex" => "Lähetettyjen tiedostojen nimet eivät saa sopia yhteen regex kanssa",
"File galleries comments settings" => "Tiedosto gallerian kommentti asetukset",
"File galleries search indexing" => "Tiedosto gallerioiden etsintä indeksointi",
"Leave command blank to delete handler" => "Jätä kehote tyhjäksi poistaaksesi käsittelijän",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Käytä %1 jolloin sisäinen tiedostonimi korvataan (esimerkki: \"strings %1\" muuntaa asiakirjan tekstiksi käyttäen unix strings komentoja)",
"Enable auto indexing on file upload or change" => "Valitse auto indeksointi tiedosto lähetyksiin tai muutoksiin",
"System command" => "Järjestelmän komento",
"Home Forum" => "Perus Foorumi",
"Forums features" => "Foorumin ominaisuudet",
"Forum quick jumps" => "Foorumin nopea vaihto",
"Ordering for forums in the forum listing" => "Valitsee foorumit foorumi listalta",
"Forum listing configuration" => "Foorumi listauksen asetukset",
"Show Babelfish Translation URLs" => "Näytä Babelfish käännös URL:it",
"Show Babelfish Translation Logo" => "Näytä Babelfish käännös Logo",
"Show Module Controls" => "Näytä Moduulin hallinta",
"Users can Configure Modules" => "Käyttäjä voi hallita Moduuleja",
"Users can Shade Modules" => "Käyttäjät voivat pienentää Moduulit",
"module decides" => "moduuli valitsee",
"Allow Anonymous Poll Voting" => "Sallii nimettömien äänestää",
"Performance issues" => "Suorituskyky asiat",
"Search features" => "Etsintä ominaisuudet",
"SearchStats" => "EtsintäTilastot",
"Settings for searching content" => "Asetukset sisällön etsintään",
"Search refresh rate" => "Etsinnän päivitys väli",
"this survey stats" => "tämän tutkimuksen tilastot",
"bold" => "lihava",
"italic" => "kallistus",
"underline" => "alleviivaus",
"hr" => "linja",
"Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./setup.sh\" for example)." => "Apachella on oikeus kirjoittaa hakemistopuuhusi, mikä sallii asennuksen, poiston tai pakettien päivityksen. Kun nuo asennukset on tehty, kannattaa oikeudet palauttaa turvalliseen tilaan (käyttäen \"./setup.sh\" esimerkiksi).",
"To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./setup.sh open\" to set it up). After installation you need to remove that permission (using \"./setup.sh\")." => "Asentaaksesi, poistaaksesi tai päivittääksesi paketteja sinun on annettava apache käyttäjälle oikeudet kirjoittaa tiedostoja web puuhun (voit käyttää \"./setup.sh open\" komentoa). Asennuksen jälkeen palauta oikeudet (käyttäen \"./setup.sh\").",
"To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "Oppiaksesi lisää <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
"theme" => "teema",
"You have {\$unread} unread private messages" => "Sinulla on {\$unread} lukematonta yksityisviestiä",
"unread private messages" => "lukematonta yksityisviestiä",
"chat" => "chat",
"debugger console" => "debugger console",
"Status:" => "Tila:",
"(unchanged)" => "(muuttamattomat)",
"Remaining:" => "Jäljellä:",
"This module requires parameters trackerId and name set" => "Tämä moduuli tarvitsee kortistoId:n ja nimen",
"you or someone registered this email address at" => "sinä tai joku muu on rekisteröitynyt tällä sähköpostiosoitteella",
"Your Tiki information registration" => "Sinun tietosi rekisteröintiin",
"left/right" => "vasen/oikea",
"Unassign module" => "poista moduuli",
"home" => "koti",
"contact us" => "ota yhteyttä",
"MyMenu" => "OmaValikko",
"User menu" => "Käyttäjä valikko",
"WfMenu" => "WfValikko",
"WikiMenu" => "WikiValikko",
"dump" => "dumppi",
"rankings" => "arvostukset",
"orphan pages" => "yksinäiset sivut",
"sandbox" => "hiekkaloota",
"received pages" => "vastaanotetut sivut",
"structures" => "rakenteet",
"GalMenu" => "GalValikko",
"Articles Home" => "Artikkelien Koti",
"Send articles" => "Lähetä artikkelit",
"Create/Edit Blog" => "Luo/Muokkaa Blogia",
"ForMenu" => "Valikolle",
"DirMenu" => "HakValikko",
"Browse Directory" => "Selaa Hakemistoa",
"FileGalMenu" => "TiedostoGalValikko",
"Admin FAQs" => "Ylläpidä UKK:iä",
"Edit mapfiles" => "Muokkaa karttatiedostoja",
"QuizMenu" => "VisailuValikko",
"Admin quiz" => "Ylläpidä visailua",
"TrkMenu" => "KorValikko",
"Admin trackers" => "Ylläpidä kortistoja",
"SrvMenu" => "PalValikko",
"Send newsletters" => "Lähetä uutislehti",
"Send events" => "Laita tapahtumat",
"Admin events" => "Ylläpidä tapahtumia",
"EphMenu" => "EphValikko",
"Ephemerides" => "Lyhytaikaiset",
"ChartMenu" => "KaavioValikko",
"AdmMenu" => "YllValikko",
"Admin home" => "perus Ylläpito",
"Backups" => "Varmuuskopio",
"Edit languages" => "Muokkaa kieliä",
"External wikis" => "Ulkoiset wikit",
"Mods Admin" => "Modien Ylläpito",
"UsrMenu" => "KäytValikko",
"Click here to manage your personal menu" => "Paina tästä hallitaksesi henkilökohtaista valikkoa",
"Quick edit a Wiki page" => "PikaMuutos sivuun",
"Language: " => "Kieli: ",
"Sort posts by:" => "Lajittele postit:",
"read more" => "lue listää",
"Pass" => "Salasana",
"System Admin" => "Järjestelmän Ylläpito",
"Displays an miniquiz" => "Näyttää minivisailun",
"some text" => "joku teksti",
"Creates a box with the data" => "Luo laatikon tietoineen",
"creates a title bar" => "luo otsikko palkin",
"creates a table" => "luo taulukko",
"makes a horizontal rule" => "tekee vaaka viivan",
"page|desc" => "sivu|kuvaus",
"displays an image" => "näyttää kuvan",
"Non cacheable images" => "Puskuroimattomia kuvia",
"height width desc link and align are optional" => "korkeus leveys kuvaus linkki ja keskitys ovat vaihtoehtoja",
"Wiki File Attachments" => "Tiedosto Liitteet",
"Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Luo linkin nimettyyn tiedostoon.  Jos sivua ei anneta, tiedosto on liitettävä nykyiseen sivuun.  Jos kuvausta ei anneta, tiedoston nimeä käytetään linkin tekstissä, kunnes näytäkuvaus käytetään, jolloin kuvausta käytetään liitteen linkkitekstinä.  Jos kuva=1 on annettu, liite toimii kuten kuva ja näytetään suoraan sivulla; linkkiä ei muodosteta.",
"displays rss feed with id=n maximum=m items" => "näyttää rss syötteen id=n maximum=m osaa",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Korvataan arvolla, joka saadaan muuttuva sisältöisestä osasta jolla on id=n",
"\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" tulostaa sisällysluettelon sivusta perustuen rakenteeseen (toc) tai ! pääosiin (maketoc)",
"Misc" => "Sekal",
"Click to Navigate" => "Paina siirtyäksesi",
"Focus:" => "Keskitys:",
"Tiki User Account Activated" => "Käyttäjä Tili Aktivoitu",
"Tiki User Registration Request" => "Käyttäjä Rekisteröinti Pyyntö",
"Tiki email notification" => "Sähköposti ilmoitus",
"Your Tiki account information for %s" => " %s sinun tilitietosi ovat",
"Reg users can change theme" => "Rekisteröityneet käyttäjät voivat vaihtaa teemaa",
"Create/Edit Newsletters" => "<Luo/muokkaa uutislehteä",
"Tiki Shoutbox" => "Pikaviestitn",
"Allow sites in this category" => "Salli sivustot tässä luokassa",
"Show number of sites in this category" => "Näytä montako sivustoa on tässä luokassa",
"Subcategories" => "Alaluokat",
"Admin related categories" => "Ylläpitoon liittyvät luokat",
"Add a Category" => "Lisää luokka",
"in current category" => "nykyiseen luokkaan",
"Total categories" => "Luokitteluja kaikkiaan",
"Days online" => "Päivää linjalla",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "Cookies must be allowed to vote" => "Cookies must be allowed to vote",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "Copyright management" => "Copyright management",
// "Tiki is unable to connect to the database " => "Tiki is unable to connect to the database ",
// "Tiki was unable to retrieve login data from the database " => "Tiki was unable to retrieve login data from the database ",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Is your database up and running" => "Is your database up and running",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "Uploaded" => "Uploaded",
// "Explorer" => "Explorer",
// "Slideshow" => "Slideshow",
// "Default View" => "Default View",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Aland_Islands" => "Aland_Islands",
// "Albania" => "Albania",
// "American_Samoa" => "American_Samoa",
// "Andorra" => "Andorra",
// "Anguilla" => "Anguilla",
// "Aruba" => "Aruba",
// "Azerbaijan" => "Azerbaijan",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bhutan" => "Bhutan",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Bosnia_and_Herzegovina" => "Bosnia_and_Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "Bouvet_Island" => "Bouvet_Island",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "British_Indian_Ocean_Territory" => "British_Indian_Ocean_Territory",
// "British_Virgin_Islands" => "British_Virgin_Islands",
// "Burkina Faso" => "Burkina Faso",
// "Burkina_Faso" => "Burkina_Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Cape Verde" => "Cape Verde",
// "Cape_Verde" => "Cape_Verde",
// "Catalan_Countries" => "Catalan_Countries",
// "Cayman_Islands" => "Cayman_Islands",
// "Central African Republic" => "Central African Republic",
// "Central_African_Republic" => "Central_African_Republic",
// "Chad" => "Chad",
// "Christmas Island" => "Christmas Island",
// "Christmas_Island" => "Christmas_Island",
// "Cocos Islands" => "Cocos Islands",
// "Cocos_Islands" => "Cocos_Islands",
// "Comoros" => "Comoros",
// "Congo Democratic" => "Congo Democratic",
// "Congo" => "Congo",
// "Congo_Democratic" => "Congo_Democratic",
// "Cook_Islands" => "Cook_Islands",
// "Costa_Rica" => "Costa_Rica",
// "Czech_Republic" => "Czech_Republic",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Dominican_Republic" => "Dominican_Republic",
// "El_Salvador" => "El_Salvador",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Equatorial_Guinea" => "Equatorial_Guinea",
// "Eritrea" => "Eritrea",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Falkland_Islands" => "Falkland_Islands",
// "Faroe Islands" => "Faroe Islands",
// "Faroe_Islands" => "Faroe_Islands",
// "Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
// "French Guiana" => "French Guiana",
// "French Southern Territories" => "French Southern Territories",
// "French_Guiana" => "French_Guiana",
// "French_Polynesia" => "French_Polynesia",
// "French_Southern_Territories" => "French_Southern_Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guernsey" => "Guernsey",
// "Guinea Bissau" => "Guinea Bissau",
// "Guinea" => "Guinea",
// "Guinea_Bissau" => "Guinea_Bissau",
// "Guyana" => "Guyana",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Heard_Island_and_McDonald_Islands" => "Heard_Island_and_McDonald_Islands",
// "Hong Kong" => "Hong Kong",
// "Hong_Kong" => "Hong_Kong",
// "Isle of Man" => "Isle of Man",
// "Ivory_Coast" => "Ivory_Coast",
// "Jersey" => "Jersey",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Marshall_Islands" => "Marshall_Islands",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mayotte" => "Mayotte",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Netherlands Antilles" => "Netherlands Antilles",
// "Netherlands_Antilles" => "Netherlands_Antilles",
// "New_Caledonia" => "New_Caledonia",
// "New_Zealand" => "New_Zealand",
// "Niger" => "Niger",
// "Norfolk Island" => "Norfolk Island",
// "Norfolk_Island" => "Norfolk_Island",
// "North Korea" => "North Korea",
// "North_Korea" => "North_Korea",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "Northern_Mariana_Islands" => "Northern_Mariana_Islands",
// "Oman" => "Oman",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Puerto_Rico" => "Puerto_Rico",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Republic_of_Macedonia" => "Republic_of_Macedonia",
// "Reunion" => "Reunion",
// "Russian_Federation" => "Russian_Federation",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "Saint_Helena" => "Saint_Helena",
// "Saint_Kitts_and_Nevis" => "Saint_Kitts_and_Nevis",
// "Saint_Lucia" => "Saint_Lucia",
// "Saint_Pierre_and_Miquelon" => "Saint_Pierre_and_Miquelon",
// "San Marino" => "San Marino",
// "San_Marino" => "San_Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Sao_Tome_and_Principe" => "Sao_Tome_and_Principe",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "Sierra_Leone" => "Sierra_Leone",
// "Solomon_Islands" => "Solomon_Islands",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "South_Africa" => "South_Africa",
// "South_Georgia_and_South_Sandwich_Islands" => "South_Georgia_and_South_Sandwich_Islands",
// "South_Korea" => "South_Korea",
// "Sri_Lanka" => "Sri_Lanka",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Sudan" => "Sudan",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Svalbard_and_Jan_Mayen" => "Svalbard_and_Jan_Mayen",
// "Swaziland" => "Swaziland",
// "Syria" => "Syria",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Tunisia" => "Tunisia",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Turks_and_Caicos_Islands" => "Turks_and_Caicos_Islands",
// "US Virgin Islands" => "US Virgin Islands",
// "US_Virgin_Islands" => "US_Virgin_Islands",
// "Uganda" => "Uganda",
// "United Nations Organization" => "United Nations Organization",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_Kingdom_-_England_and_Wales" => "United_Kingdom_-_England_and_Wales",
// "United_Kingdom_-_Northern_Ireland" => "United_Kingdom_-_Northern_Ireland",
// "United_Kingdom_-_Scotland" => "United_Kingdom_-_Scotland",
// "United_Nations_Organization" => "United_Nations_Organization",
// "United_States" => "United_States",
// "United_States_Minor_Outlying_Islands" => "United_States_Minor_Outlying_Islands",
// "Uzbekistan" => "Uzbekistan",
// "Vatican" => "Vatican",
// "Viet Nam" => "Viet Nam",
// "Viet_Nam" => "Viet_Nam",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Wallis_and_Futuna" => "Wallis_and_Futuna",
// "Western Sahara" => "Western Sahara",
// "Western_Sahara" => "Western_Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "the former Yugoslav Republic of Macedonia" => "the former Yugoslav Republic of Macedonia",
// "the_former_Yugoslav_Republic_of_Macedonia" => "the_former_Yugoslav_Republic_of_Macedonia",
// "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter" => "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter",
// "MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Requires MySQL 4.1+",
// "MySQL classic (mysql)" => "MySQL classic (mysql)",
// "PostgeSQL 7.2+" => "PostgeSQL 7.2+",
// "Oracle" => "Oracle",
// "Sybase" => "Sybase",
// "SQLLite" => "SQLLite",
// "MSSQL" => "MSSQL",
// "Email address not valid, test mail not sent" => "Email address not valid, test mail not sent",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Test mail from Tiki installer " => "Test mail from Tiki installer ",
// "Tiki version" => "Tiki version",
// "PHP version" => "PHP version",
// "Server" => "Server",
// "Congratulations!\n\nYour server can send emails.\n\n" => "Congratulations!\n\nYour server can send emails.\n\n",
// "Slovene" => "Slovene",
// "Farsi" => "Farsi",
// "Fijian" => "Fijian",
// "Galician" => "Galician",
// "newest" => "newest",
// "oldest" => "oldest",
// "on left side" => "on left side",
// "on center" => "on center",
// "on right side" => "on right side",
// "Day" => "Day",
// "Week" => "Week",
// "Month" => "Month",
// "Quarter" => "Quarter",
// "Semester" => "Semester",
// "Depends user language" => "Depends user language",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "utf-8" => "utf-8",
// "iso-8859-1" => "iso-8859-1",
// "CRLF (standard)" => "CRLF (standard)",
// "LF (some Unix MTA)" => "LF (some Unix MTA)",
// "15 minutes" => "15 minutes",
// "30 minutes" => "30 minutes",
// "1 hour" => "1 hour",
// "2 hours" => "2 hours",
// "10 hours" => "10 hours",
// "20 hours" => "20 hours",
// "1 year" => "1 year",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are always in HTTPS, but do not check" => "Consider we are always in HTTPS, but do not check",
// "crypt-md5" => "crypt-md5",
// "crypt-des" => "crypt-des",
// "tikihash (old)" => "tikihash (old)",
// "Shibboleth" => "Shibboleth",
// "OpenID and Tiki" => "OpenID and Tiki",
// "Admins" => "Admins",
// "Never use transition css" => "Never use transition css",
// "Use @version:x.x specified in theme css or none if not specified" => "Use @version:x.x specified in theme css or none if not specified",
// "Use @version:x.x specified in theme css or 1.9 if not specified" => "Use @version:x.x specified in theme css or 1.9 if not specified",
// "Use @version:x.x specified in theme css or 2.0 if not specified" => "Use @version:x.x specified in theme css or 2.0 if not specified",
// "LastModif" => "LastModif",
// "Ascending" => "Ascending",
// "Descending" => "Descending",
// "No forums" => "No forums",
// "\$feature is turned on" => "\$feature is turned on",
// "\$feature is turned off" => "\$feature is turned off",
// "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing" => "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing",
// "\$feature set to nothing" => "\$feature set to nothing",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "All Day" => "All Day",
// "(not registered)" => "(not registered)",
// "Please wait %d secondes between posts" => "Please wait %d secondes between posts",
// "A contribution is mandatory" => "A contribution is mandatory",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval, the message will be posted after a moderator approves it" => "Your message has been queued for approval, the message will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "Foo" => "Foo",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "Newsletter subscription information at" => "Newsletter subscription information at",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to" => "Select a Wiki page to link to",
// "Cannot open this file" => "Cannot open this file",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "Contributions" => "Contributions",
// "Query point" => "Query point",
// "layer" => "layer",
// "Record" => "Record",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "menu" => "menu",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "section edit" => "section edit",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "The passwords do not match" => "The passwords do not match",
// "Feed provided by %s. Click to visit" => "Feed provided by %s. Click to visit",
// "Wiki Comment" => "Wiki Comment",
// "Calendar item" => "Calendar item",
// "Tracker item" => "Tracker item",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "You need either JQuery or MooTools enabled for this feature" => "You need either JQuery or MooTools enabled for this feature",
// "Help page" => "Help page",
// "Admin Feature" => "Admin Feature",
// "phplayers are not available on this site" => "phplayers are not available on this site",
// "Invert Sort" => "Invert Sort",
// "sec" => "sec",
// "Gender" => "Gender",
// "No pageviews yet" => "No pageviews yet",
// "n/a" => "n/a",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "Help link" => "Help link",
// "Edit Plugin" => "Edit Plugin",
// "Edit Section" => "Edit Section",
// "You are not allowed to upload this type of file" => "You are not allowed to upload this type of file",
// "The file you are trying upload was only partially uploaded" => "The file you are trying upload was only partially uploaded",
// "You must select a file" => "You must select a file",
// "Flash player not available" => "Flash player not available",
// "__WARNING__: Plugin disabled \$plugin" => "__WARNING__: Plugin disabled \$plugin",
// "Upload was not successful. Duplicate file content " => "Upload was not successful. Duplicate file content ",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "drop down with other textfield" => "drop down with other textfield",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "radio buttons" => "radio buttons",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "ip selector" => "ip selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "static text" => "static text",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "dynamic items list" => "dynamic items list",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "multimedia" => "multimedia",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "auto-increment" => "auto-increment",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "user subscription" => "user subscription",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "Google Maps" => "Google Maps",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "computed field" => "computed field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "user preference" => "user preference",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "The administrator has not yet validated your account. Please wait" => "The administrator has not yet validated your account. Please wait",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "Personal Phone" => "Personal Phone",
// "Personal Mobile" => "Personal Mobile",
// "Personal Fax" => "Personal Fax",
// "Work Phone" => "Work Phone",
// "Work Mobile" => "Work Mobile",
// "Work Fax" => "Work Fax",
// "Company" => "Company",
// "Organization" => "Organization",
// "Department" => "Department",
// "Division" => "Division",
// "Job Title" => "Job Title",
// "Street Address" => "Street Address",
// "City" => "City",
// "Zip Code" => "Zip Code",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "Anchor Name" => "Anchor Name",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "The name of the anchor" => "The name of the anchor",
// "Image Annotation" => "Image Annotation",
// "Autogenerated content. Leave blank initially" => "Autogenerated content. Leave blank initially",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Width" => "Width",
// "Image width" => "Image width",
// "Height" => "Height",
// "Image height" => "Image height",
// "Alignment" => "Alignment",
// "Image alignment. Possible values: left, right, center" => "Image alignment. Possible values: left, right, center",
// "Save changes to annotations" => "Save changes to annotations",
// "Image annotations changed" => "Image annotations changed",
// "Creates an annotation block for an image" => "Creates an annotation block for an image",
// "Displays an image and allow the users to define zones to highlight information on the image" => "Displays an image and allow the users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "The article field to display. Default field is Heading" => "The article field to display. Default field is Heading",
// "Article ID" => "Article ID",
// "The article to display. If no value is provided, most recent article will be used" => "The article to display. If no value is provided, most recent article will be used",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading" => "Id is optional. If not given, last article is used. Default field is heading",
// "Article List" => "Article List",
// "Includes a list of articles within the page" => "Includes a list of articles within the page",
// "Articles displayed" => "Articles displayed",
// "The amount of articles to display in the list" => "The amount of articles to display in the list",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "Category ID" => "Category ID",
// "The ID of the category to list from" => "The ID of the category to list from",
// "The article language to list" => "The article language to list",
// "Sort order" => "Sort order",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Quiet" => "Quiet",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Title only" => "Title only",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "End date" => "End date",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Number" => "Number",
// "Show icon" => "Show icon",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description" => "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "The wiki page the avatar will link to" => "The wiki page the avatar will link to",
// "Float" => "Float",
// "left|right" => "left|right",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "1|0" => "1|0",
// "No Header" => "No Header",
// "Banner" => "Banner",
// "Insert a banner" => "Insert a banner",
// "Target" => "Target",
// "missing parameter" => "missing parameter",
// "Blog List" => "Blog List",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Blog ID" => "Blog ID",
// "Numeric value" => "Numeric value",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Box" => "Box",
// "Box title" => "Box title",
// "Displayed above the content" => "Displayed above the content",
// "Background color" => "Background color",
// "As defined by CSS, name or Hex code" => "As defined by CSS, name or Hex code",
// "Box width" => "Box width",
// "In pixels or percentage. Default value is 100%" => "In pixels or percentage. Default value is 100%",
// "Text Alignment" => "Text Alignment",
// "Float Position" => "Float Position",
// "for box with width lesser than 100%, make text wrap around the box" => "for box with width lesser than 100%, make text wrap around the box",
// "CSS Class" => "CSS Class",
// "Apply custom CSS class to the box" => "Apply custom CSS class to the box",
// "Category IDs" => "Category IDs",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "Types" => "Types",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "Sort Order" => "Sort Order",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "And" => "And",
// "Category Orphans" => "Category Orphans",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Separator" => "Separator",
// "String used to separate the categories in the path. Default character is >" => "String used to separate the categories in the path. Default character is >",
// "Display top category" => "Display top category",
// "yes|no, default to no" => "yes|no, default to no",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Sheet ID" => "Sheet ID",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Chart Width" => "Chart Width",
// "Width in pixels" => "Width in pixels",
// "Chart Height" => "Chart Height",
// "Height in pixels" => "Height in pixels",
// "Value series" => "Value series",
// "Required for pie charts" => "Required for pie charts",
// "Independant series" => "Independant series",
// "Required for types other than pie chart" => "Required for types other than pie chart",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "List of colors to use" => "List of colors to use",
// "Styles" => "Styles",
// "List of styles to use" => "List of styles to use",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Colors" => "Colors",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "Line numbers" => "Line numbers",
// "0|1, may not be used with colors" => "0|1, may not be used with colors",
// "Wiki syntax" => "Wiki syntax",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "Right to left" => "Right to left",
// "0|1, switch the text display from left to right to right to left" => "0|1, switch the text display from left to right to right to left",
// "Content is HTML" => "Content is HTML",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "Includes content from the dynamic content system" => "Includes content from the dynamic content system",
// "Content ID" => "Content ID",
// "Also known as Fortune cookies or Taglines" => "Also known as Fortune cookies or Taglines",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Countdown" => "Countdown",
// "Displays a countdown from now until the specified date" => "Displays a countdown from now until the specified date",
// "Text to append to the countdown" => "Text to append to the countdown",
// "Target date. Multiple formats accepted" => "Target date. Multiple formats accepted",
// "Locate Time" => "Locate Time",
// "on|off" => "on|off",
// "DBReport" => "DBReport",
// "Run a database report" => "Run a database report",
// "report definition" => "report definition",
// "Full DSN" => "Full DSN",
// "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database",
// "Wiki DSN name" => "Wiki DSN name",
// "The name of a DSN connection defined by the Wiki administrator" => "The name of a DSN connection defined by the Wiki administrator",
// "0|1, parse wiki syntax within the report" => "0|1, parse wiki syntax within the report",
// "Debug" => "Debug",
// "0|1, display the parsed report definition" => "0|1, display the parsed report definition",
// "Missing db or dsn parameter" => "Missing db or dsn parameter",
// "You do not have permission to use this DSN" => "You do not have permission to use this DSN",
// "No DSN connection string found" => "No DSN connection string found",
// "Div" => "Div",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "left|right|center|justify" => "left|right|center|justify",
// "left|right, for box with width lesser than 100%, make text wrap around the box" => "left|right, for box with width lesser than 100%, make text wrap around the box",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Definition List" => "Definition List",
// "One entry per line. Each line is in \"Term: Definition\" format" => "One entry per line. Each line is in \"Term: Definition\" format",
// "Draw" => "Draw",
// "Displays drawings in the wiki page" => "Displays drawings in the wiki page",
// "Name of the drawing to display" => "Name of the drawing to display",
// "Name parameter missing" => "Name parameter missing",
// "Equation" => "Equation",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "equation" => "equation",
// "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Includes the list of events from a calendar in the page" => "Includes the list of events from a calendar in the page",
// "Calendar ID" => "Calendar ID",
// "Numeric" => "Numeric",
// "Maximum days" => "Maximum days",
// "Maximum Rows" => "Maximum Rows",
// "Datetime" => "Datetime",
// "0|1" => "0|1",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Wiki syntax containing the text to display" => "Wiki syntax containing the text to display",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Use div" => "Use div",
// "Use div instead of ol" => "Use div instead of ol",
// "Class" => "Class",
// "CSS class of the fancylist" => "CSS class of the fancylist",
// "Creates a fancy looking list" => "Creates a fancy looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "One row per line, cells separated by ~|~" => "One row per line, cells separated by ~|~",
// "Heading row" => "Heading row",
// "Heading row of the table, same format as the body section" => "Heading row of the table, same format as the body section",
// "Heading CSS Class" => "Heading CSS Class",
// "CSS Class to apply on the heading row" => "CSS Class to apply on the heading row",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "name_asc" => "name_asc",
// "Shows ID" => "Shows ID",
// "Shows Icon" => "Shows Icon",
// "Shows Name" => "Shows Name",
// "Shows Filename" => "Shows Filename",
// "Shows Size" => "Shows Size",
// "Shows Description" => "Shows Description",
// "Shows Creation Date" => "Shows Creation Date",
// "Shows Hits" => "Shows Hits",
// "Shows Locked by" => "Shows Locked by",
// "Shows Modification Date" => "Shows Modification Date",
// "Shows Author" => "Shows Author",
// "Shows Creator" => "Shows Creator",
// "Shows Parent Gallery Name" => "Shows Parent Gallery Name",
// "Shows Number of Files" => "Shows Number of Files",
// "Shows the slideshow of a gallery" => "Shows the slideshow of a gallery",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include" => "Complete URL to the movie to include",
// "Default width: 425" => "Default width: 425",
// "Default height: 350" => "Default height: 350",
// "Quality" => "Quality",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Footnote" => "Footnote",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "The footnote" => "The footnote",
// "Sameas" => "Sameas",
// "Tag to existing footnote" => "Tag to existing footnote",
// "CheckDuplicate" => "CheckDuplicate",
// "check for duplcate footnotes" => "check for duplcate footnotes",
// "Footnotearea" => "Footnotearea",
// "Inserts a section for collected footnotes within the wiki page" => "Inserts a section for collected footnotes within the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "ftp" => "ftp",
// "file name" => "file name",
// "Ftp Server Name" => "Ftp Server Name",
// "Ftp User name" => "Ftp User name",
// "Ftp password" => "Ftp password",
// "Download button label" => "Download button label",
// "missing parameters" => "missing parameters",
// "Connection failed" => "Connection failed",
// "Incorrect param" => "Incorrect param",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "current value (REQUIRED)" => "current value (REQUIRED)",
// "Maximum Value" => "Maximum Value",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Color" => "Color",
// "Background Color" => "Background Color",
// "Bar width in pixels" => "Bar width in pixels",
// "Label Width" => "Label Width",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "Display Percentage" => "Display Percentage",
// "true|false, if true then a percentage of the maximum is displayed" => "true|false, if true then a percentage of the maximum is displayed",
// "Display Value" => "Display Value",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "Google Analytics" => "Google Analytics",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "Missing parameter" => "Missing parameter",
// "googledoc" => "googledoc",
// "Leave this empty" => "Leave this empty",
// "Type of Google document" => "Type of Google document",
// "key" => "key",
// "Google doc key - for example pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example pXsHENf1bGGY92X1iEeJJI",
// "Name of iframe" => "Name of iframe",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Pixels or %" => "Pixels or %",
// "Margin Height" => "Margin Height",
// "Pixels" => "Pixels",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Displays a Google document" => "Displays a Google document",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed Groups" => "Allowed Groups",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Denied Groups" => "Denied Groups",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "HTML" => "HTML",
// "Include literal HTML in a Wiki page" => "Include literal HTML in a Wiki page",
// "0|1, parse wiki syntax within the html code" => "0|1, parse wiki syntax within the html code",
// "Include literal HTML" => "Include literal HTML",
// "Iframe" => "Iframe",
// "Frame title" => "Frame title",
// "iframe" => "iframe",
// "Displays an iframe" => "Displays an iframe",
// " (experimental - possible successor to img in 4.0)" => " (experimental - possible successor to img in 4.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image Source" => "Image Source",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Link title" => "Link title",
// "Title text" => "Title text",
// "Image alt text" => "Image alt text",
// "Alternate text to display if impossible to load the image" => "Alternate text to display if impossible to load the image",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS Style" => "CSS Style",
// "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)" => "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration" => "Default configuration",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration" => "Mandatory configuration",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display an image" => "Display an image",
// "Displays an image" => "Displays an image",
// "Full URL to the image to display" => "Full URL to the image to display",
// "Alternate Text" => "Alternate Text",
// "Height of the image to display" => "Height of the image to display",
// "Width of the image to display" => "Width of the image to display",
// "Link Title" => "Link Title",
// "Image alignment in the page. (left, right, center) Uses HTML IMG tag" => "Image alignment in the page. (left, right, center) Uses HTML IMG tag",
// "Float Alignment" => "Float Alignment",
// "Image alignment in the flow of the document. (left, right, none) Uses CSS float property" => "Image alignment in the flow of the document. (left, right, none) Uses CSS float property",
// "Style to apply to the image" => "Style to apply to the image",
// "Include a page\\'s content" => "Include a page\\'s content",
// "Page Name" => "Page Name",
// "Wiki page name to include" => "Wiki page name to include",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Jabber" => "Jabber",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Default Color" => "Default Color",
// "255,255,255" => "255,255,255",
// "JQuery" => "JQuery",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Javascript" => "Javascript",
// "Javascript filename" => "Javascript filename",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Amount of results displayed in the list" => "Amount of results displayed in the list",
// "Initial" => "Initial",
// "txt" => "txt",
// "Show Name Only" => "Show Name Only",
// "Structure Head" => "Structure Head",
// "Show Page Alias" => "Show Page Alias",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Orphan Language" => "Orphan Language",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Exact Match" => "Exact Match",
// "Related to Find" => "Related to Find",
// "Only Orphan Pages" => "Only Orphan Pages",
// "For List Pages" => "For List Pages",
// "List Directory" => "List Directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "URL Prefix" => "URL Prefix",
// ".ext" => ".ext",
// "Limit" => "Limit",
// "Maximum amount of files to display" => "Maximum amount of files to display",
// "Map File" => "Map File",
// "Extents" => "Extents",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Mediaplayer" => "Mediaplayer",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "One of" => "One of",
// "Mini Quiz" => "Mini Quiz",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "Flip" => "Flip",
// "Max" => "Max",
// "np" => "np",
// "notitle" => "notitle",
// "Displays a module inlined in page. More parameters can be added, not supported by UI" => "Displays a module inlined in page. More parameters can be added, not supported by UI",
// "Monospace" => "Monospace",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Mouse Over" => "Mouse Over",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when moused-over text is clicked. Use http:// for external links" => "Destination link when moused-over text is clicked. Use http:// for external links",
// "DEPRECATED" => "DEPRECATED",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouse over box width. Default: 400px" => "Mouse over box width. Default: 400px",
// "Mouse over box height. Default: 200px" => "Mouse over box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px" => "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Color of the inside popup" => "Color of the inside popup",
// "Default: #F5F5F5" => "Default: #F5F5F5",
// "Text popup color" => "Text popup color",
// "#FFFFFF" => "#FFFFFF",
// "Padding" => "Padding",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "true|false" => "true|false",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace" => "MySpace",
// "MySpace Page" => "MySpace Page",
// "Displays a SWF myspace mp3 playlist on the wiki page" => "Displays a SWF myspace mp3 playlist on the wiki page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "Object Type" => "Object Type",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Plugin Manager" => "Plugin Manager",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "Poll ID" => "Poll ID",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Proposal" => "Proposal",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username",
// "Accept proposal" => "Accept proposal",
// "Still undecided" => "Still undecided",
// "Reject proposal" => "Reject proposal",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quote" => "Quote",
// "Quoted text" => "Quoted text",
// "Reply to" => "Reply to",
// "Name of the quoted person" => "Name of the quoted person",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "Redirect" => "Redirect",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Wiki page name to redirect to" => "Wiki page name to redirect to",
// "Complete URL, internal or external" => "Complete URL, internal or external",
// "Redirects you to another wiki page" => "Redirects you to another wiki page",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon ID" => "Icon ID",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Amount of results displayed" => "Amount of results displayed",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect" => "RSS Id incorrect",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "SourceForge" => "SourceForge",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Sheet" => "Sheet",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "Show Pages" => "Show Pages",
// "Search criteria" => "Search criteria",
// "Maximum amount of results displayed" => "Maximum amount of results displayed",
// "name|desc" => "name|desc",
// "Skype" => "Skype",
// "Clickable Skype link" => "Clickable Skype link",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "asc|desc|shuffle" => "asc|desc|shuffle",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Fixed Size" => "Fixed Size",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Column Size" => "Column Size",
// "Editable" => "Editable",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "SQL" => "SQL",
// "DNS Name" => "DNS Name",
// "ADODB DNS" => "ADODB DNS",
// "Subscript" => "Subscript",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Subscribe Group" => "Subscribe Group",
// "Group Name" => "Group Name",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe Text" => "Unsubscribe Text",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Colon separated list of groups" => "Colon separated list of groups",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Displays a survey" => "Displays a survey",
// "Tag" => "Tag",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent of the style attribute on the HTML tag" => "Equivalent of the style attribute on the HTML tag",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "URL to the image" => "URL to the image",
// "Maximum Size" => "Maximum Size",
// "Maximum width or height for the image" => "Maximum width or height for the image",
// "Floating" => "Floating",
// "Link target of the image" => "Link target of the image",
// "File is not an image" => "File is not an image",
// "Server does not support image manipulation" => "Server does not support image manipulation",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Exclude" => "Exclude",
// "Pipe separated list of page names to exclude from results" => "Pipe separated list of page names to exclude from results",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Maximum Depth" => "Maximum Depth",
// "Maximum amount of levels to display. On very large structures, this should be limited" => "Maximum amount of levels to display. On very large structures, this should be limited",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "Show Description" => "Show Description",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "List top scoring users" => "List top scoring users",
// "Maximum result count" => "Maximum result count",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "string" => "string",
// "Translate a string" => "Translate a string",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Title" => "Show Title",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "Url used for the field links" => "Url used for the field links",
// "Values" => "Values",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Incorrect fieldId" => "Incorrect fieldId",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Display List" => "Display List",
// "Line" => "Line",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Filters the items of a tracker, fields are indicated with numeric ids" => "Filters the items of a tracker, fields are indicated with numeric ids",
// "Wiki text" => "Wiki text",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "Field ID" => "Field ID",
// "Colon separated list of field IDs" => "Colon separated list of field IDs",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Test" => "Test",
// "Value to compare against" => "Value to compare against",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Tracker List" => "Tracker List",
// "Notice" => "Notice",
// "Popup" => "Popup",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "Show Links" => "Show Links",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Status" => "Show Status",
// "Show Creation Date" => "Show Creation Date",
// "Show Last Modification" => "Show Last Modification",
// "Show Field Name" => "Show Field Name",
// "Status Filter" => "Status Filter",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Sort Mode" => "Sort Mode",
// "Filter Field" => "Filter Field",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "Filter Value" => "Filter Value",
// "Exact Value" => "Exact Value",
// "Checkbox" => "Checkbox",
// "goIfOne" => "goIfOne",
// "More" => "More",
// "More URL" => "More URL",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Left Deliminator" => "Left Deliminator",
// "Right Deliminator" => "Right Deliminator",
// "If y, value will be truncated" => "If y, value will be truncated",
// "Export Button" => "Export Button",
// "Compute" => "Compute",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Button label" => "Button label",
// "Field 1" => "Field 1",
// "Value 1" => "Value 1",
// "Content of the field" => "Content of the field",
// "Field 2" => "Field 2",
// "Value 2" => "Value 2",
// "Field 3" => "Field 3",
// "Value 3" => "Value 3",
// "Field 4" => "Field 4",
// "Value 4" => "Value 4",
// "Field 5" => "Field 5",
// "Value 5" => "Value 5",
// "Tracker Stats" => "Tracker Stats",
// "Show Percentage" => "Show Percentage",
// "Show Bar" => "Show Bar",
// "Show link to tiki-view_tracker" => "Show link to tiki-view_tracker",
// "Displays some stat of a tracker content, fields are indicated with numeric ids" => "Displays some stat of a tracker content, fields are indicated with numeric ids",
// "incorrect fieldId" => "incorrect fieldId",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Title Field" => "Title Field",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Summary Field" => "Summary Field",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "hour, day, week, month or year (default to hour)" => "hour, day, week, month or year (default to hour)",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "hour, day, week, month, year or empty (default to empty)" => "hour, day, week, month, year or empty (default to empty)",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "Missing parameter: %0" => "Missing parameter: %0",
// "Start date after end date" => "Start date after end date",
// "Translated" => "Translated",
// "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)",
// "Two letter language code of the language, ex: fr" => "Two letter language code of the language, ex: fr",
// "Country name, ex: France" => "Country name, ex: France",
// "User Count" => "User Count",
// "Group name" => "Group name",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Maximum" => "Maximum",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Default" => "Default",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Show Stats" => "Show Stats",
// "Show Stats After" => "Show Stats After",
// "Show Creator" => "Show Creator",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Level" => "Level",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Switch-on debug output with details about the items" => "Switch-on debug output with details about the items",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Service Name" => "Service Name",
// "Registered service name" => "Registered service name",
// "Template Name" => "Template Name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "Unknown Template" => "Unknown Template",
// "Unknown Service" => "Unknown Service",
// "Missing parameters" => "Missing parameters",
// "Youtube" => "Youtube",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "URL to the Youtube video" => "URL to the Youtube video",
// "quality" => "quality",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "Removed last version" => "Removed last version",
// "list topics with links to the articles" => "list topics with links to the articles",
// "Article Topics" => "Article Topics",
// "Categorize %s in %s" => "Categorize %s in %s",
// "List by month" => "List by month",
// "Please wait.." => "Please wait..",
// "Since your last visit.." => "Since your last visit..",
// "updated tracker items" => "updated tracker items",
// "Cookie not found" => "Cookie not found",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can browse the calendar" => "Can browse the calendar",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Can admin categories" => "Can admin categories",
// "Can edit items in categories" => "Can edit items in categories",
// "Can view categories" => "Can view categories",
// "Can view categorized items" => "Can view categorized items",
// "Can search on objects of this category" => "Can search on objects of this category",
// "Can admin charts" => "Can admin charts",
// "Autovalidate suggestions" => "Autovalidate suggestions",
// "Can suggest items" => "Can suggest items",
// "Can view charts" => "Can view charts",
// "Can vote" => "Can vote",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Can use the chat system" => "Can use the chat system",
// "Can admin the cms" => "Can admin the cms",
// "Can approve submissions" => "Can approve submissions",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Can edit articles" => "Can edit articles",
// "Can edit submissions" => "Can edit submissions",
// "Can read articles" => "Can read articles",
// "Can remove articles" => "Can remove articles",
// "Can remove submissions" => "Can remove submissions",
// "Can submit articles" => "Can submit articles",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can admin contributions" => "Can admin contributions",
// "Can admin the directory" => "Can admin the directory",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Submited links are valid" => "Submited links are valid",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can validate submited links" => "Can validate submited links",
// "Can use the directory" => "Can use the directory",
// "Can admin drawings" => "Can admin drawings",
// "Can edit drawings" => "Can edit drawings",
// "Can admin faqs" => "Can admin faqs",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can view faqs" => "Can view faqs",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Can admin users" => "Can admin users",
// "Can access site when closed" => "Can access site when closed",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Can ban users or ips" => "Can ban users or ips",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin rss modules" => "Can admin rss modules",
// "Can clean cache" => "Can clean cache",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can admin cookies" => "Can admin cookies",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit site templates" => "Can edit site templates",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view referer stats" => "Can view referer stats",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can admin blogs" => "Can admin blogs",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can post to a blog" => "Can post to a blog",
// "Can create a blog" => "Can create a blog",
// "Can read blogs" => "Can read blogs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can create file galleries" => "Can create file galleries",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can upload files" => "Can upload files",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view file galleries" => "Can view file galleries",
// "Can admin forums" => "Can admin forums",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can post in forums" => "Can post in forums",
// "Can start threads in forums" => "Can start threads in forums",
// "Can read forums" => "Can read forums",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can create image galleries" => "Can create image galleries",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload images" => "Can upload images",
// "Can browse freetags" => "Can browse freetags",
// "Can view image galleries" => "Can view image galleries",
// "Can admin games" => "Can admin games",
// "Can play games" => "Can play games",
// "Can admin newsletters" => "Can admin newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can vote polls" => "Can vote polls",
// "Can view poll voters" => "Can view poll voters",
// "Can admin quicktags" => "Can admin quicktags",
// "Can admin quizzes" => "Can admin quizzes",
// "Can take quizzes" => "Can take quizzes",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view user quiz results" => "Can view user quiz results",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can view shoutbox" => "Can view shoutbox",
// "Can admin surveys" => "Can admin surveys",
// "Can take surveys" => "Can take surveys",
// "Can view survey stats" => "Can view survey stats",
// "Can admin trackers" => "Can admin trackers",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can list trackers" => "Can list trackers",
// "Can change tracker items" => "Can change tracker items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can admin the wiki" => "Can admin the wiki",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can edit pages" => "Can edit pages",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can create and edit structures" => "Can create and edit structures",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can lock pages" => "Can lock pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can remove" => "Can remove",
// "Can rename pages" => "Can rename pages",
// "Can rollback pages" => "Can rollback pages",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can view page/pages" => "Can view page/pages",
// "Can watch structure" => "Can watch structure",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin workflow processes" => "Can admin workflow processes",
// "Can abort a process instance" => "Can abort a process instance",
// "Can declare an instance as exception" => "Can declare an instance as exception",
// "Can send instances after completion" => "Can send instances after completion",
// "Can execute workflow activities" => "Can execute workflow activities",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can configure modules" => "Can configure modules",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the newsreader" => "Can use the newsreader",
// "Can use the notepad" => "Can use the notepad",
// "Can admin public tasks" => "Can admin public tasks",
// "Can use tasks" => "Can use tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can upload personal files" => "Can upload personal files",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can use the messaging system" => "Can use the messaging system",
// "Can admin comments" => "Can admin comments",
// "Can edit all comments" => "Can edit all comments",
// "Can post new comments" => "Can post new comments",
// "Can read comments" => "Can read comments",
// "Can delete comments" => "Can delete comments",
// "Can vote comments" => "Can vote comments",
// "Can admin content templates" => "Can admin content templates",
// "Can edit content templates" => "Can edit content templates",
// "Can use content templates" => "Can use content templates",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can view HTML pages" => "Can view HTML pages",
// "Can list registered users" => "Can list registered users",
// "Admin live support system" => "Admin live support system",
// "Can use live support system" => "Can use live support system",
// "Can create new mapfile" => "Can create new mapfile",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use webmail" => "Can use webmail",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wysiwyg toolbar" => "wysiwyg toolbar",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastmodif" => "fgal list lastmodif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki workflow" => "users prefs mytiki workflow",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "validateRegistration" => "validateRegistration",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature newsreader" => "feature newsreader",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "feature charts" => "feature charts",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth create user tiki" => "auth create user tiki",
// "auth create user auth" => "auth create user auth",
// "auth skip admin" => "auth skip admin",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "feature games" => "feature games",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature swfobj" => "feature swfobj",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "quicktags over textarea" => "quicktags over textarea",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "feature floating help" => "feature floating help",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty notice reporting" => "smarty notice reporting",
// "smarty security" => "smarty security",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature drawings" => "feature drawings",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature workflow" => "feature workflow",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session db" => "session db",
// "session lifetime" => "session lifetime",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "system os" => "system os",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "feature mootools" => "feature mootools",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "use minified scripts" => "use minified scripts",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature tikitests" => "feature tikitests",
// "feature magic" => "feature magic",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "transition style ver" => "transition style ver",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki workflow" => "mytiki workflow",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "Group Monitor" => "Group Monitor",
// "Watched by categories" => "Watched by categories",
// "Select Categories" => "Select Categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "top of page" => "top of page",
// "Report this post" => "Report this post",
// "Errors" => "Errors",
// "Comments Locked" => "Comments Locked",
// "Comments are locked" => "Comments are locked",
// "Note" => "Note",
// "required" => "required",
// "Maximum size" => "Maximum size",
// "Enter your name" => "Enter your name",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Post as Anonymous" => "Post as Anonymous",
// "Your comment will have to be approved by the moderator before it is displayed" => "Your comment will have to be approved by the moderator before it is displayed",
// "Type of contribution" => "Type of contribution",
// "Contributors" => "Contributors",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate perms" => "Duplicate perms",
// "View inserted gallery" => "View inserted gallery",
// "Display Properties" => "Display Properties",
// "required field for podcasts" => "required field for podcasts",
// "any file" => "any file",
// "podcast (audio)" => "podcast (audio)",
// "podcast (video)" => "podcast (video)",
// "This Gallery is Public" => "This Gallery is Public",
// "Users with perms and not only the owner of the gallery can upload in it" => "Users with perms and not only the owner of the gallery can upload in it",
// "The files can be locked at download" => "The files can be locked at download",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "Group of users alerted when file gallery is modified" => "Group of users alerted when file gallery is modified",
// "Allows to select each user for small groups" => "Allows to select each user for small groups",
// "Go to Login Page" => "Go to Login Page",
// "Go to" => "Go to",
// "Private Gallery" => "Private Gallery",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Download and lock" => "Download and lock",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Both" => "Both",
// "Show an icon in a column" => "Show an icon in a column",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "not in" => "not in",
// "any category" => "any category",
// "Clear Filter" => "Clear Filter",
// "Show php error messages" => "Show php error messages",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together" => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "RSS Calendars" => "RSS Calendars",
// "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page" => "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page",
// "Loading" => "Loading",
// "\\074span class=\"shortcut\"\\076C\\074/span\\076lose" => "\\074span class=\"shortcut\"\\076C\\074/span\\076lose",
// "\\074span class=\"shortcut\"\\076N\\074/span\\076ext" => "\\074span class=\"shortcut\"\\076N\\074/span\\076ext",
// "\\074span class=\"shortcut\"\\076P\\074/span\\076revious" => "\\074span class=\"shortcut\"\\076P\\074/span\\076revious",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Are you sure you want to delete the selected files" => "Are you sure you want to delete the selected files",
// "Download the zip" => "Download the zip",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "Contribution" => "Contribution",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "User Tracker" => "User Tracker",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Please visit this link before login again" => "Please visit this link before login again",
// "Last attempt" => "Last attempt",
// "Confirm your account at %s" => "Confirm your account at %s",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "You'll receive email notification once your account is activated" => "You'll receive email notification once your account is activated",
// "Please do not attempt to login until you receive the email notification" => "Please do not attempt to login until you receive the email notification",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "Old" => "Old",
// "updated" => "updated",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "An object was added to category" => "An object was added to category",
// "Added by" => "Added by",
// "Object type" => "Object type",
// "An object was removed from category" => "An object was removed from category",
// "A page has been added to your watched sub-structure" => "A page has been added to your watched sub-structure",
// "A page has been removed from your watched sub-structure" => "A page has been removed from your watched sub-structure",
// "A page has been promoted out your watched sub-structure" => "A page has been promoted out your watched sub-structure",
// "A page has been demoted to your watched structure" => "A page has been demoted to your watched structure",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "The old page content follows below" => "The old page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Thank you for your registration. You may log in now" => "Thank you for your registration. You may log in now",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Zoom out" => "Zoom out",
// "Zoom in" => "Zoom in",
// "from the mapfile" => "from the mapfile",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "ERROR" => "ERROR",
// "is reply to" => "is reply to",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "\$tpl_module_title" => "\$tpl_module_title",
// "Admin Drawings" => "Admin Drawings",
// "External Wikis" => "External Wikis",
// "Tiki Cache/Sys Admin" => "Tiki Cache/Sys Admin",
// "Syntax Highlighting" => "Syntax Highlighting",
// "\$module_title" => "\$module_title",
// "More.." => "More..",
// "To configure your Tiki" => "To configure your Tiki",
// "Admin Home" => "Admin Home",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as the Admin" => "as the Admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "Last `\$module_rows` blog comments" => "Last `\$module_rows` blog comments",
// "Last blog comments" => "Last blog comments",
// "on blogpost" => "on blogpost",
// "Add event" => "Add event",
// "\$modcattitle" => "\$modcattitle",
// "Current events" => "Current events",
// "Folksonomy" => "Folksonomy",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "More Like This" => "More Like This",
// "Most popular tags" => "Most popular tags",
// "List everything tagged" => "List everything tagged",
// "My prefered tags" => "My prefered tags",
// "\$type" => "\$type",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "more" => "more",
// "No avatar" => "No avatar",
// "You" => "You",
// "Logged in as" => "Logged in as",
// "Switch User" => "Switch User",
// "Switch user" => "Switch user",
// "Login through Shibboleth" => "Login through Shibboleth",
// "Login as" => "Login as",
// "CapsLock is on" => "CapsLock is on",
// "OpenID Login" => "OpenID Login",
// "What is OpenID" => "What is OpenID",
// "RSS Feeds" => "RSS Feeds",
// "Calendars" => "Calendars",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Advanced search" => "Advanced search",
// "Advanced Search Help" => "Advanced Search Help",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "New Calendar Events" => "New Calendar Events",
// "Nothing has changed" => "Nothing has changed",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Site Language" => "Site Language",
// "Site default" => "Site default",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "Page translation" => "Page translation",
// "There are no translations of this page" => "There are no translations of this page",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Set your preferred languages" => "Set your preferred languages",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "The Next Event" => "The Next Event",
// "No Upcoming Events" => "No Upcoming Events",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Videos on YouTube" => "Videos on YouTube",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "By" => "By",
// "Read more" => "Read more",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Tiki Action Calendar" => "Tiki Action Calendar",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Profiles" => "Profiles",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Look &amp; Feel" => "Look &amp; Feel",
// "i18n" => "i18n",
// "Editing and Plugins" => "Editing and Plugins",
// "Text area" => "Text area",
// "Freetags" => "Freetags",
// "Multimedia" => "Multimedia",
// "Semantic wiki links" => "Semantic wiki links",
// "Semantic links" => "Semantic links",
// "Webservices" => "Webservices",
// "Sef URL" => "Sef URL",
// "Blogs Listing" => "Blogs Listing",
// "Create a blog" => "Create a blog",
// "Spell checking" => "Spell checking",
// "Requires a separate download" => "Requires a separate download",
// "Custom blog headings" => "Custom blog headings",
// "Blog-level" => "Blog-level",
// "Post-level" => "Post-level",
// "Default number per page" => "Default number per page",
// "Default ordering" => "Default ordering",
// "Blogs Listings" => "Blogs Listings",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "Title length" => "Title length",
// "General settings" => "General settings",
// "Default calendars to display" => "Default calendars to display",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "Create calendar" => "Create calendar",
// "Default view mode" => "Default view mode",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "First day of the week" => "First day of the week",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "Manual selection of time/date" => "Manual selection of time/date",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Group calendars" => "Group calendars",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Category path" => "Category path",
// "Exclude these categories" => "Exclude these categories",
// "Separate category IDs with a comma (,)" => "Separate category IDs with a comma (,)",
// "Show category objects" => "Show category objects",
// "Use PHPLayers for category browser" => "Use PHPLayers for category browser",
// "PHPLayers is disabled" => "PHPLayers is disabled",
// "Enable now" => "Enable now",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Will improve performance, but may show forbidden results" => "Will improve performance, but may show forbidden results",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Admin topics" => "Admin topics",
// "Admin types" => "Admin types",
// "Articles Listing" => "Articles Listing",
// "Title of articles home page" => "Title of articles home page",
// "Maximum number of articles on articles home page" => "Maximum number of articles on articles home page",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "Specify notification emails when creating articles" => "Specify notification emails when creating articles",
// "Default article image width" => "Default article image width",
// "Default article image height" => "Default article image height",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Select which items to display when listing articles" => "Select which items to display when listing articles",
// "Publication date" => "Publication date",
// "Expiration date" => "Expiration date",
// "Users Listing" => "Users Listing",
// "Users can choose to show their gender" => "Users can choose to show their gender",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "Show user's information on mouseover" => "Show user's information on mouseover",
// "Requires user's information to be public" => "Requires user's information to be public",
// "Real name" => "Real name",
// "Feature is disabled" => "Feature is disabled",
// "Default user preferences" => "Default user preferences",
// "Users Default Preferences" => "Users Default Preferences",
// "Character set for mail" => "Character set for mail",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "User messages" => "User messages",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "Select which items to display when listing users" => "Select which items to display when listing users",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "License page" => "License page",
// "Submit notice" => "Submit notice",
// "Enable copyright management for" => "Enable copyright management for",
// "Feature" => "Feature",
// "Show Country Flag" => "Show Country Flag",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site",
// "No tabs" => "No tabs",
// "Apply" => "Apply",
// "Reset" => "Reset",
// "Main" => "Main",
// "Global Features" => "Global Features",
// "More Functionality" => "More Functionality",
// "UI Enhancements" => "UI Enhancements",
// "Experimental" => "Experimental",
// "Programmer" => "Programmer",
// "Main Features" => "Main Features",
// "Site Global Features" => "Site Global Features",
// "Action Log" => "Action Log",
// "Action log setting" => "Action log setting",
// "Internationalization" => "Internationalization",
// "Additional Features" => "Additional Features",
// "Copyright System" => "Copyright System",
// "Copyright system" => "Copyright system",
// "Tell a Friend" => "Tell a Friend",
// "HTML pages" => "HTML pages",
// "Minichat" => "Minichat",
// "Comments Moderation" => "Comments Moderation",
// "Comments Locking" => "Comments Locking",
// "User interface enhancement features" => "User interface enhancement features",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "Fullscreen" => "Fullscreen",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "Mootools or JQuery" => "Mootools or JQuery",
// "Mootools" => "Mootools",
// "Floating help aka the Big Blue Help Icon" => "Floating help aka the Big Blue Help Icon",
// "Experimental Features" => "Experimental Features",
// "Seem ok" => "Seem ok",
// "Features that may change or might be re-worked in the future" => "Features that may change or might be re-worked in the future",
// "Ajax" => "Ajax",
// "HTML Purifier" => "HTML Purifier",
// "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)" => "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)",
// "JQuery: JavaScript UI effects" => "JQuery: JavaScript UI effects",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Need polish" => "Need polish",
// "Features that need admin help and user patience to work well" => "Features that need admin help and user patience to work well",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "SEFURL" => "SEFURL",
// "Search engine friendly url" => "Search engine friendly url",
// "Ajax auto-save" => "Ajax auto-save",
// "Malfunctioning" => "Malfunctioning",
// "These features have critical faults - not recommended" => "These features have critical faults - not recommended",
// "Magic Admin Panel" => "Magic Admin Panel",
// "Neglected" => "Neglected",
// "Old features no longer maintained" => "Old features no longer maintained",
// "Friendship" => "Friendship",
// "SWFObject" => "SWFObject",
// "SwfObject" => "SwfObject",
// "Used to embed Flash content in wiki pages, banners etc" => "Used to embed Flash content in wiki pages, banners etc",
// "Action Calendar" => "Action Calendar",
// "Tiki action calendar" => "Tiki action calendar",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "User Contacts" => "User Contacts",
// "Group Watches" => "Group Watches",
// "User Levels" => "User Levels",
// "Group Alert" => "Group Alert",
// "Programmer Features" => "Programmer Features",
// "TikiTests" => "TikiTests",
// "requires PHP5 or more" => "requires PHP5 or more",
// "Use Minified Scripts" => "Use Minified Scripts",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "Gallery Listing" => "Gallery Listing",
// "Search Indexing" => "Search Indexing",
// "Create a Gallery" => "Create a Gallery",
// "Store in database" => "Store in database",
// "Store in directory" => "Store in directory",
// "The server must be able to read/write the directory" => "The server must be able to read/write the directory",
// "The directory can be outside the web space" => "The directory can be outside the web space",
// "Podcast directory" => "Podcast directory",
// "Required for podcasts" => "Required for podcasts",
// "Default Ordering" => "Default Ordering",
// "Allow download limit per file" => "Allow download limit per file",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Score is disabled" => "Score is disabled",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "Batch uploading" => "Batch uploading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory" => "The server must be able to read the directory",
// "Require file author's name for anonymous uploads" => "Require file author's name for anonymous uploads",
// "Upload Regex" => "Upload Regex",
// "Must match" => "Must match",
// "Cannot match" => "Cannot match",
// "Gallery Listings" => "Gallery Listings",
// "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries",
// "Select which items to display when listing galleries: " => "Select which items to display when listing galleries: ",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "System Command" => "System Command",
// "Forums Listing" => "Forums Listing",
// "Create a forum" => "Create a forum",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Will be a thread title" => "Will be a thread title",
// "Threads" => "Threads",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Default style" => "Default style",
// "Default sort mode" => "Default sort mode",
// "Forum name search" => "Forum name search",
// "When listing forums" => "When listing forums",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Search is disabled" => "Search is disabled",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Use database (full-text) search" => "Use database (full-text) search",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Description length" => "Description length",
// "3D Tag Browser" => "3D Tag Browser",
// "Show tag cloud" => "Show tag cloud",
// "Maximum number of tags in cloud" => "Maximum number of tags in cloud",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Separate colors with a comma (,)" => "Separate colors with a comma (,)",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "Multilingual freetags" => "Multilingual freetags",
// "Multiligual disabled" => "Multiligual disabled",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Graph appearance" => "Graph appearance",
// "Node color" => "Node color",
// "Camera settinsg" => "Camera settinsg",
// "Physics engine" => "Physics engine",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below" => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Pixels Default" => "Pixels Default",
// "Default scale size" => "Default scale size",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Admin Password" => "Admin Password",
// "Release Check" => "Release Check",
// "Reset or upgrade your database" => "Reset or upgrade your database",
// "Check for updates automatically" => "Check for updates automatically",
// "Check frequency" => "Check frequency",
// "TikiWiki will check for updates when you access the main Administration page" => "TikiWiki will check for updates when you access the main Administration page",
// "Check for updates now" => "Check for updates now",
// "Sender email" => "Sender email",
// "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences" => "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Use different URL as home page" => "Use different URL as home page",
// "Miscellaneous" => "Miscellaneous",
// "Server OS" => "Server OS",
// "Smarty Security" => "Smarty Security",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "Default charset for sending mail" => "Default charset for sending mail",
// "Mail end of line" => "Mail end of line",
// "Logging and Reporting" => "Logging and Reporting",
// "PHP error reporting level" => "PHP error reporting level",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Visible to Admin only" => "Visible to Admin only",
// "Include Smarty notices" => "Include Smarty notices",
// "Log mail in Tiki logs" => "Log mail in Tiki logs",
// "Log SQL" => "Log SQL",
// "Log queries using more than" => "Log queries using more than",
// "This may impact performance" => "This may impact performance",
// "Add HTML comment at start and end of each Smarty template (TPL)" => "Add HTML comment at start and end of each Smarty template (TPL)",
// "CSRF Security" => "CSRF Security",
// "Use these options to protect against cross-site request forgeries (CSRF)" => "Use these options to protect against cross-site request forgeries (CSRF)",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "Site Access" => "Site Access",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "Host" => "Host",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Performance" => "Performance",
// "Cache external pages" => "Cache external pages",
// "Cache external images" => "Cache external images",
// "GZip output" => "GZip output",
// "Output compression is active" => "Output compression is active",
// "Compression is handled by" => "Compression is handled by",
// "Session" => "Session",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Enabling this feature will immediately log you out when you save this preference" => "Enabling this feature will immediately log you out when you save this preference",
// "Session lifetime" => "Session lifetime",
// "The \"Contact Us\" feature is disabled" => "The \"Contact Us\" feature is disabled",
// "Allow anonymous visitors to use the \"Contact Us\"" => "Allow anonymous visitors to use the \"Contact Us\"",
// "The default help system may not be complete" => "The default help system may not be complete",
// "You can help with the TikiWiki documentation" => "You can help with the TikiWiki documentation",
// "Show user's real name instead of login (when possible)" => "Show user's real name instead of login (when possible)",
// "Highlight group" => "Highlight group",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Separators" => "Separators",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Examples" => "Examples",
// "Choices" => "Choices",
// "Default timezone" => "Default timezone",
// "Use site default to show times" => "Use site default to show times",
// "Detect user timezone (if browser allows). Otherwise use site default" => "Detect user timezone (if browser allows). Otherwise use site default",
// "Sample" => "Sample",
// "Fields display order" => "Fields display order",
// "Change the <strong>Admin</strong> password" => "Change the <strong>Admin</strong> password",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at " => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at ",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Default language" => "Default language",
// "Show pages in user's preferred language" => "Show pages in user's preferred language",
// "User preferences are disabled" => "User preferences are disabled",
// "Users can change site language" => "Users can change site language",
// "Restrict supported languages" => "Restrict supported languages",
// "Available languages" => "Available languages",
// "Use Ctrl+Click to select multiple languages" => "Use Ctrl+Click to select multiple languages",
// "Display available translations" => "Display available translations",
// "Changing page language will also change the site language" => "Changing page language will also change the site language",
// "Translation assistant" => "Translation assistant",
// "Urgent translation notifications" => "Urgent translation notifications",
// "Quantify change size" => "Quantify change size",
// "Multilingual structures" => "Multilingual structures",
// "Structures are disabled" => "Structures are disabled",
// "Multilingual One Page feature" => "Multilingual One Page feature",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "Look and Feel" => "Look and Feel",
// "Text Area" => "Text Area",
// "Wysiwyg" => "Wysiwyg",
// "Semantic" => "Semantic",
// "Webservices management" => "Webservices management",
// "CAS" => "CAS",
// "Tiki" => "Tiki",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "User's choice" => "User's choice",
// "Always" => "Always",
// "Cookie name" => "Cookie name",
// "Use email as username" => "Use email as username",
// "Minimum length" => "Minimum length",
// "Maximum length" => "Maximum length",
// "Force lowercase" => "Force lowercase",
// "Username pattern" => "Username pattern",
// "Store password as plain text" => "Store password as plain text",
// "Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Store passwords in plain text is activated. You should never set this unless you know what you are doing",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords </em>are stored<em> as plain text, the password will be emailed to the user" => "If passwords </em>are stored<em> as plain text, the password will be emailed to the user",
// "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user" => "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user",
// "Encryption method" => "Encryption method",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "You must change the Authentication Method to PEAR::Auth for these changes to take effect" => "You must change the Authentication Method to PEAR::Auth for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in Auth" => "Create user if not in Auth",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "LDAP Group" => "LDAP Group",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group OC" => "Group OC",
// "LDAP Member" => "LDAP Member",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "Admin password" => "Admin password",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "Default group" => "Default group",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "General Layout" => "General Layout",
// "UI Effects" => "UI Effects",
// "The \"users can change theme\" feature will override the theme displayed" => "The \"users can change theme\" feature will override the theme displayed",
// "Theme not saved yet - click \"Apply\"" => "Theme not saved yet - click \"Apply\"",
// "Theme options" => "Theme options",
// "Each group can have its theme" => "Each group can have its theme",
// "Use transition style sheet from version" => "Use transition style sheet from version",
// "View Templates" => "View Templates",
// "Shadow layer" => "Shadow layer",
// "Enable additional general layout layers for shadows, rounded corners or other decorative styling" => "Enable additional general layout layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Custom Site Header" => "Custom Site Header",
// "Activate will only show content for admin. Check Publish to use content for all users" => "Activate will only show content for admin. Check Publish to use content for all users",
// "Site Logo and Title" => "Site Logo and Title",
// "Site logo source (image path)" => "Site logo source (image path)",
// "Site logo background style" => "Site logo background style",
// "Site logo alignment" => "Site logo alignment",
// "Site title" => "Site title",
// "Site subtitle" => "Site subtitle",
// "Site Search Bar" => "Site Search Bar",
// "Site Login Bar" => "Site Login Bar",
// "Top Bar" => "Top Bar",
// "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  " => "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  ",
// "Menu ID" => "Menu ID",
// "Prefix breadcrumbs with 'Location : '" => "Prefix breadcrumbs with 'Location : '",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Left blank to use the default sender email" => "Left blank to use the default sender email",
// "Email this page" => "Email this page",
// "Custom Site Footer" => "Custom Site Footer",
// "Custom End of <body> Code" => "Custom End of <body> Code",
// "Bottom bar (RSS)" => "Bottom bar (RSS)",
// "Power by" => "Power by",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item" => "Max. number of links around the current item",
// "Max. number of links after the first or before the last item" => "Max. number of links after the first or before the last item",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "Use Icons" => "Use Icons",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Requires jquery feature" => "Requires jquery feature",
// "JQuery Tooltips" => "JQuery Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "JQuery Superfish" => "JQuery Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "JQuery Reflection" => "JQuery Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "For future use" => "For future use",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules etc" => "Effect for modules etc",
// "Main JQuery effect" => "Main JQuery effect",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Effect speed" => "Effect speed",
// "Fast" => "Fast",
// "Slow" => "Slow",
// "Effect direction" => "Effect direction",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Effect speed for tabs" => "Effect speed for tabs",
// "Effect direction for tabs" => "Effect direction for tabs",
// "Other options" => "Other options",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "List of CSS selectors to be fixed, each selector separated by comma" => "List of CSS selectors to be fixed, each selector separated by comma",
// "List of HTMLDomElements to be fixed, each element separated by comma" => "List of HTMLDomElements to be fixed, each element separated by comma",
// "Context Menus (only in file galleries so far)" => "Context Menus (only in file galleries so far)",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Change Preferences" => "Change Preferences",
// "Meta tags" => "Meta tags",
// "Keywords" => "Keywords",
// "Include freetags" => "Include freetags",
// "Use thread title instead" => "Use thread title instead",
// "Use image title instead" => "Use image title instead",
// "Geo URL" => "Geo URL",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "Admin &gt; Modules" => "Admin &gt; Modules",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Show module controls" => "Show module controls",
// "Users can configure modules" => "Users can configure modules",
// "Users can shade modules" => "Users can shade modules",
// "Module decides" => "Module decides",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Video Length" => "Video Length",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Show categories" => "Show categories",
// "Categories disabled" => "Categories disabled",
// "Show objects" => "Show objects",
// "Are you sure you want to install the profile" => "Are you sure you want to install the profile",
// "TikiWiki Profiles" => "TikiWiki Profiles",
// "Profile repository" => "Profile repository",
// "Filter the list of profiles" => "Filter the list of profiles",
// "Profile" => "Profile",
// "Repository" => "Repository",
// "Repositories" => "Repositories",
// "Repository URLs" => "Repository URLs",
// "Enter multiple repository URLs, one per line" => "Enter multiple repository URLs, one per line",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "More information" => "More information",
// "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or" => "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or",
// "Feed for articles" => "Feed for articles",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Show Author" => "Show Author",
// "Homepage URL" => "Homepage URL",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Map files" => "Map files",
// "Feed for maps" => "Feed for maps",
// "Defaults" => "Defaults",
// "Image Path" => "Image Path",
// "Caching time" => "Caching time",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public" => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Search Results" => "Search Results",
// "Search type" => "Search type",
// "Database search" => "Database search",
// "This search uses the MySQL Full-Text feature" => "This search uses the MySQL Full-Text feature",
// "Tiki search" => "Tiki search",
// "This database-independent search is always enabled" => "This database-independent search is always enabled",
// "Specify the Tiki search settings" => "Specify the Tiki search settings",
// "Refresh mode" => "Refresh mode",
// "Use <strong>0</strong> for no refresh" => "Use <strong>0</strong> for no refresh",
// "When the Database search is enabled, you must manually refresh the Tiki search indexes" => "When the Database search is enabled, you must manually refresh the Tiki search indexes",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "Parse the results" => "Parse the results",
// "May impact performance" => "May impact performance",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Object filter" => "Object filter",
// "Search box" => "Search box",
// "Select the information to display for each result" => "Select the information to display for each result",
// "Pertinence" => "Pertinence",
// "Last modified date" => "Last modified date",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Known Types" => "Known Types",
// "Token" => "Token",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "No occurences found" => "No occurences found",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Plugins" => "Plugins",
// "Plugin Aliases" => "Plugin Aliases",
// "Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonymous editors must enter anti-bot code (CAPTCHA)",
// "Protect email against spam" => "Protect email against spam",
// "External link icon" => "External link icon",
// "External links will be identified with" => "External links will be identified with",
// "Use File Galleries to store pictures " => "Use File Galleries to store pictures ",
// "Allow to post comments as Anonymous" => "Allow to post comments as Anonymous",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "&lt;return&gt; for rows" => "&lt;return&gt; for rows",
// "Show quicktags above textareas" => "Show quicktags above textareas",
// "If disabled, quicktags will be shown to the left of textareas" => "If disabled, quicktags will be shown to the left of textareas",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Plugin disabled" => "Plugin disabled",
// "Default size" => "Default size",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "(experimental - not comprehensively tested and requires new JQuery feature)" => "(experimental - not comprehensively tested and requires new JQuery feature)",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "General Information" => "General Information",
// "Plugin Name" => "Plugin Name",
// "Base Plugin" => "Base Plugin",
// "Body Label" => "Body Label",
// "Dependencies" => "Dependencies",
// "Validation" => "Validation",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Encoding" => "Encoding",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Default Value" => "Default Value",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Tracker attachments" => "Tracker attachments",
// "No records" => "No records",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Page Listings" => "Page Listings",
// "If the page does not exist, it will be created" => "If the page does not exist, it will be created",
// "Wiki link format" => "Wiki link format",
// "Latin" => "Latin",
// "Select the characters that can be used with Wiki link syntax: ((page name))" => "Select the characters that can be used with Wiki link syntax: ((page name))",
// "Page display" => "Page display",
// "Page ID" => "Page ID",
// "Page version" => "Page version",
// "Page name display stripper" => "Page name display stripper",
// "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>" => "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>",
// "Allow override per page" => "Allow override per page",
// "Display show/hide icon displayed before headings" => "Display show/hide icon displayed before headings",
// "Wiki action bar" => "Wiki action bar",
// "Buttons: Save, Preview, Cancel, .." => "Buttons: Save, Preview, Cancel, ..",
// "Page navigation bar location" => "Page navigation bar location",
// "When using the ...page... page break wiki syntax" => "When using the ...page... page break wiki syntax",
// "Wiki top line" => "Wiki top line",
// "Neither" => "Neither",
// "Page description, icons, backlinks, .." => "Page description, icons, backlinks, ..",
// "Wiki buttons" => "Wiki buttons",
// "Buttons: Edit, Source, Remove, .." => "Buttons: Edit, Source, Remove, ..",
// "Save draft" => "Save draft",
// "Requires AJAX" => "Requires AJAX",
// "experimental" => "experimental",
// "Edit section" => "Edit section",
// "Edit section level" => "Edit section level",
// "Allow minor edits" => "Allow minor edits",
// "Minor edits do not flag new content for translation and do not send watch notifications" => "Minor edits do not flag new content for translation and do not send watch notifications",
// "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled",
// "Regex search and replace" => "Regex search and replace",
// "Log bytes changes (+/-) in action logs" => "Log bytes changes (+/-) in action logs",
// "Display by default" => "Display by default",
// "Manage attachments" => "Manage attachments",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Restore" => "Restore",
// "WikiWords" => "WikiWords",
// "Maximum number of versions" => "Maximum number of versions",
// "Never delete versions younger than" => "Never delete versions younger than",
// "Display IP address" => "Display IP address",
// "Default diff style" => "Default diff style",
// "HTML diff" => "HTML diff",
// "Side-by-side diff by characters" => "Side-by-side diff by characters",
// "Inline diff" => "Inline diff",
// "Inline diff by characters" => "Inline diff by characters",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "History includes only page data, description, and change comment" => "History includes only page data, description, and change comment",
// "Forums are disabled" => "Forums are disabled",
// "Forum for discussion" => "Forum for discussion",
// "View source" => "View source",
// "Polls are disabled" => "Polls are disabled",
// "like pages" => "like pages",
// "Make structure from page" => "Make structure from page",
// "Categorize structure pages together" => "Categorize structure pages together",
// "Create webhelp from structure" => "Create webhelp from structure",
// "Import pages" => "Import pages",
// "Slideshows" => "Slideshows",
// "User's page" => "User's page",
// "Users can lock pages" => "Users can lock pages",
// "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page" => "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page",
// "Wiki watch" => "Wiki watch",
// "Watch minor edits" => "Watch minor edits",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "Approved" => "Approved",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Out-of-sync" => "Out-of-sync",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Orphan page" => "Orphan page",
// "Configuration" => "Configuration",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Name length" => "Name length",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Categories path" => "Categories path",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Toolbar content" => "Toolbar content",
// "Database Version Problem" => "Database Version Problem",
// "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "The following list of changes has been applied" => "The following list of changes has been applied",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "information" => "information",
// "preference" => "preference",
// "preference name" => "preference name",
// "TikiCache/System" => "TikiCache/System",
// "Edit Languages" => "Edit Languages",
// "Report" => "Report",
// "Please select some actions to view" => "Please select some actions to view",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "recorded" => "recorded",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Configure" => "Configure",
// "Create Calendar" => "Create Calendar",
// "View Calendars" => "View Calendars",
// "Edit Calendar" => "Edit Calendar",
// "View Calendar" => "View Calendar",
// "Add Event" => "Add Event",
// "Create/Edit Calendars" => "Create/Edit Calendars",
// "Custom URL" => "Custom URL",
// "Start of day" => "Start of day",
// "End of day" => "End of day",
// "Standard Colors" => "Standard Colors",
// "Green" => "Green",
// "Blue" => "Blue",
// "Purple" => "Purple",
// "Orange" => "Orange",
// "Yellow" => "Yellow",
// "Let me select my own colors" => "Let me select my own colors",
// "Custom foreground color" => "Custom foreground color",
// "Ex" => "Ex",
// "Custom background color" => "Custom background color",
// "Default event status" => "Default event status",
// "Show in calendar view" => "Show in calendar view",
// "Group of users alerted when calendar event is modified" => "Group of users alerted when calendar event is modified",
// "Delete events older than" => "Delete events older than",
// "Browse the category system" => "Browse the category system",
// "Current Category ID" => "Current Category ID",
// "Remove from this Category" => "Remove from this Category",
// "Admin charts" => "Admin charts",
// "Use in" => "Use in",
// "No features are configured to use templates" => "No features are configured to use templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Admin Contributions" => "Admin Contributions",
// "Edit the contribution" => "Edit the contribution",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "Admin External Wikis" => "Admin External Wikis",
// "Enable Features" => "Enable Features",
// "Duplicate forum" => "Duplicate forum",
// "View this forum" => "View this forum",
// "Import forums" => "Import forums",
// "Only allow replies to the first message (flat forum)" => "Only allow replies to the first message (flat forum)",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate" => "Duplicate",
// "List Forums" => "List Forums",
// ".." => "..",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "For wiki page, use ((PageName))" => "For wiki page, use ((PageName))",
// "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Use Ctrl+Click to select multiple groups" => "Use Ctrl+Click to select multiple groups",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format" => "To use a menu in a tiki format",
// "To use menu in a css/suckerfish format" => "To use menu in a css/suckerfish format",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "Folder Icon" => "Folder Icon",
// "Path and filename of closed folder icon" => "Path and filename of closed folder icon",
// "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder",
// "In the same directory, include an icon for the opened folder" => "In the same directory, include an icon for the opened folder",
// "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>",
// "For example, the default icon is: pics/icons/folder.png" => "For example, the default icon is: pics/icons/folder.png",
// "The name of the \"open folder\" icon is: pics/icons/ofolder.png" => "The name of the \"open folder\" icon is: pics/icons/ofolder.png",
// "Assign/Edit modules" => "Assign/Edit modules",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site" => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site",
// "Use Wiki Structure" => "Use Wiki Structure",
// "Edit Newsletter" => "Edit Newsletter",
// "You can add several email addresses by separating them with commas" => "You can add several email addresses by separating them with commas",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Create Newsletter" => "Create Newsletter",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Drafts" => "Drafts",
// "Mail notifications" => "Mail notifications",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications",
// "Alert" => "Alert",
// "A user edits an article" => "A user edits an article",
// "A user deletes an article" => "A user deletes an article",
// "A comment in a wiki page is posted or edited" => "A comment in a wiki page is posted or edited",
// "Preload Admin Account" => "Preload Admin Account",
// "User / Group" => "User / Group",
// "Multiple" => "Multiple",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Add Option" => "Add Option",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "0 for no limit" => "0 for no limit",
// "Span" => "Span",
// "Add poll to pages" => "Add poll to pages",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Lock the pages" => "Lock the pages",
// "Quicktags category filter" => "Quicktags category filter",
// "Tips" => "Tips",
// "Edit this RSS Module" => "Edit this RSS Module",
// "Create new RSS Module" => "Create new RSS Module",
// "RSS channels" => "RSS channels",
// "Show Date" => "Show Date",
// "View feed" => "View feed",
// "TikiWiki settings" => "TikiWiki settings",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
// "Security checks" => "Security checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments" => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments",
// "See end of table for detailed explanations" => "See end of table for detailed explanations",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "The structure" => "The structure",
// "has just been created" => "has just been created",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "Edit structure" => "Edit structure",
// "View structure" => "View structure",
// "PDF" => "PDF",
// "Xml Zip" => "Xml Zip",
// "Add a New Question" => "Add a New Question",
// "This survey stats" => "This survey stats",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Wiki textarea" => "Wiki textarea",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "Min" => "Min",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Tiki Cache/System Admin" => "Tiki Cache/System Admin",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Directory to exterminate" => "Directory to exterminate",
// "Clear all Tiki caches" => "Clear all Tiki caches",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save" => "Directories to save",
// "Full Path to the Zip File" => "Full Path to the Zip File",
// "Generate a zip of those directories" => "Generate a zip of those directories",
// "A zip has been written to {\$zipPath}" => "A zip has been written to {\$zipPath}",
// "Directory is not writeable" => "Directory is not writeable",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "New tracker field" => "New tracker field",
// "Select list items that will be displayed" => "Select list items that will be displayed",
// "Multilingual content" => "Multilingual content",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "Field is hidden" => "Field is hidden",
// "not hidden" => "not hidden",
// "visible to admin only" => "visible to admin only",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by" => "Visible by",
// "Editable by" => "Editable by",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Error message" => "Error message",
// "Export fieldId also" => "Export fieldId also",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "Create Tracker" => "Create Tracker",
// "Duplicate Tracker" => "Duplicate Tracker",
// "Create/Edit Tracker" => "Create/Edit Tracker",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Create a group for each item" => "Create a group for each item",
// "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Format if not the default short one" => "Format if not the default short one",
// "Show creation date when viewing tracker item" => "Show creation date when viewing tracker item",
// "Show lastModif date when viewing tracker item" => "Show lastModif date when viewing tracker item",
// "ItemId" => "ItemId",
// "and display last comment user/date" => "and display last comment user/date",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "Do not show empty fields in item view" => "Do not show empty fields in item view",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items",
// "Group of users alerted when tracker is modified" => "Group of users alerted when tracker is modified",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "User Choice" => "User Choice",
// "Only directly included" => "Only directly included",
// "will have all the permissions of the included groups" => "will have all the permissions of the included groups",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Add to group" => "Add to group",
// "Download CSV export" => "Download CSV export",
// "Assign users to group" => "Assign users to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Updated users" => "Updated users",
// "More Criteria" => "More Criteria",
// "Group (direct)" => "Group (direct)",
// "ago" => "ago",
// "Need to validate email" => "Need to validate email",
// "Assign to group" => "Assign to group",
// "Edit Group" => "Edit Group",
// "Validate user" => "Validate user",
// "Remove Users and their Userpages" => "Remove Users and their Userpages",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "Template wiki page" => "Template wiki page",
// "Assign user to Groups" => "Assign user to Groups",
// "Use the email as username" => "Use the email as username",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth" => "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth",
// "Repeat Password" => "Repeat Password",
// "User must change password at first login" => "User must change password at first login",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "Last Login" => "Last Login",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "Don't overwrite" => "Don't overwrite",
// "Overwrite groups" => "Overwrite groups",
// "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
// "Loading.." => "Loading..",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Show Help" => "Show Help",
// "Article type" => "Article type",
// "Actions on this article type" => "Actions on this article type",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Level configuration" => "Level configuration",
// "Assign User {\$assign_user} to Groups" => "Assign User {\$assign_user} to Groups",
// "Assign User to Group" => "Assign User to Group",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "available files" => "available files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "Use Wysiwyg Editor" => "Use Wysiwyg Editor",
// "Use Normal Editor" => "Use Normal Editor",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "Report to Webmaster" => "Report to Webmaster",
// "The TikiWiki Community" => "The TikiWiki Community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "database queries used in " => "database queries used in ",
// "Last update from SVN" => "Last update from SVN",
// "Watch Only This Category" => "Watch Only This Category",
// "Watch This Category and Their Descendants" => "Watch This Category and Their Descendants",
// "Stop Watching Only This Category" => "Stop Watching Only This Category",
// "Stop Watching This Category and Their Descendants" => "Stop Watching This Category and Their Descendants",
// "in the current category - and its subcategories: " => "in the current category - and its subcategories: ",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "\$feature_label" => "\$feature_label",
// "results found" => "results found",
// "All Images" => "All Images",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "Cyclic" => "Cyclic",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Visible Calendars" => "Visible Calendars",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Export calendars" => "Export calendars",
// "advanced parameters" => "advanced parameters",
// "Edit event" => "Edit event",
// "Delete event" => "Delete event",
// "View event" => "View event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "View this Day" => "View this Day",
// "o" => "o",
// "Calendar Item" => "Calendar Item",
// "New event" => "New event",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Date and time of end" => "Date and time of end",
// "Events cannot end before they start" => "Events cannot end before they start",
// "or new" => "or new",
// "Choose users to alert" => "Choose users to alert",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "Update this event only" => "Update this event only",
// "Update every unchanged events of this recurrence rule" => "Update every unchanged events of this recurrence rule",
// "Update every events of this recurrence rule" => "Update every events of this recurrence rule",
// "Delete Recurrent events" => "Delete Recurrent events",
// "Avanced parameters for iCal export" => "Avanced parameters for iCal export",
// "Calendars to be exported" => "Calendars to be exported",
// "Categories checking is not done in the database search" => "Categories checking is not done in the database search",
// "Perform action with checked" => "Perform action with checked",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Send another message" => "Send another message",
// "Group View" => "Group View",
// "Publish this contact to groups" => "Publish this contact to groups",
// "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Parent directory category" => "Parent directory category",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Directory Subcategories" => "Directory Subcategories",
// "Admin related directory categories" => "Admin related directory categories",
// "Directory Category" => "Directory Category",
// "Use Ctrl+Click to select multiple categories" => "Use Ctrl+Click to select multiple categories",
// "Perform action with selected" => "Perform action with selected",
// "Add a Directory Category" => "Add a Directory Category",
// "in current directory category" => "in current directory category",
// "Related directory categories" => "Related directory categories",
// "Total directory categories" => "Total directory categories",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Max clicks" => "Max clicks",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "A category is mandatory" => "A category is mandatory",
// "The file will be saved in" => "The file will be saved in",
// "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor" => "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "Wiki Syntax" => "Wiki Syntax",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Bold text" => "Bold text",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Underlined text" => "Underlined text",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "Deleted text" => "Deleted text",
// "2 dashes" => "2 dashes",
// "Autonumbered Headings" => "Autonumbered Headings",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Horizontal rule" => "Horizontal rule",
// "Text box" => "Text box",
// "Centered text" => "Centered text",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus (useful in list to continue at the same level)" => "Creates an indentation for each plus (useful in list to continue at the same level)",
// "row" => "row",
// "col" => "col",
// "Monospace font" => "Monospace font",
// "Code sample" => "Code sample",
// "to separate pages" => "to separate pages",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew" => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew",
// "Special characters" => "Special characters",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines" => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line" => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt",
// "text, bold" => "text, bold",
// "text, italic" => "text, italic",
// "text, underline" => "text, underline",
// "horizontal rule" => "horizontal rule",
// "Add image from File Gallery" => "Add image from File Gallery",
// "quote" => "quote",
// "flash" => "flash",
// "{\$label}" => "{\$label}",
// "Add Image from File Gallery" => "Add Image from File Gallery",
// "Leave Fullscreen Edit" => "Leave Fullscreen Edit",
// "Fullscreen Edit" => "Fullscreen Edit",
// "Upload from disk to change the image" => "Upload from disk to change the image",
// "Save and Go Next" => "Save and Go Next",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Edit quiz results" => "Edit quiz results",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one" => "The page already exists. The page that has been added to the structure is the existing one",
// "The following pages added have automatically been categorized with the same categories as the structure" => "The following pages added have automatically been categorized with the same categories as the structure",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "View Article" => "View Article",
// "Language of newly translated page" => "Language of newly translated page",
// "Unspecified" => "Unspecified",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "Change language for this page" => "Change language for this page",
// "Select from available options.." => "Select from available options..",
// "Change Language" => "Change Language",
// "No language is assigned to this page" => "No language is assigned to this page",
// "Please select a language before performing translation" => "Please select a language before performing translation",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Your edit session will expire in" => "Your edit session will expire in",
// "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits" => "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits",
// "Update '{\$page}'" => "Update '{\$page}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Perhaps you are looking for" => "Perhaps you are looking for",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "This edit session will expire in {\$edittimeout} minutes" => "This edit session will expire in {\$edittimeout} minutes",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer" => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer",
// "Switch to WYSIWYG editor" => "Switch to WYSIWYG editor",
// "Switch to normal (wiki) editor" => "Switch to normal (wiki) editor",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Disable" => "Disable",
// "or use" => "or use",
// "AutoSave" => "AutoSave",
// "If you want the saved version instead of the autosaved one" => "If you want the saved version instead of the autosaved one",
// "Regex search " => "Regex search ",
// "Replace to" => "Replace to",
// "Translation request" => "Translation request",
// "Send urgent translation request" => "Send urgent translation request",
// "Edit Comment" => "Edit Comment",
// "Monitor this page" => "Monitor this page",
// "Add another image" => "Add another image",
// "Lock this page" => "Lock this page",
// "List Sheets" => "List Sheets",
// "Export to file" => "Export to file",
// "Format" => "Format",
// "Autodetect" => "Autodetect",
// "Export Tracker Items" => "Export Tracker Items",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Dump All Tracker Items" => "Dump All Tracker Items",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "Be careful to set the right permissions on the files you link to" => "Be careful to set the right permissions on the files you link to",
// "Create New File Gallery" => "Create New File Gallery",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Back to forum" => "Back to forum",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "Reported messages for forum" => "Reported messages for forum",
// "No records to display" => "No records to display",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Cancel friendship request" => "Cancel friendship request",
// "Global default" => "Global default",
// "Google Map Locator" => "Google Map Locator",
// "Save clicked point" => "Save clicked point",
// "Reset view to default" => "Reset view to default",
// "Save current view as default" => "Save current view as default",
// "Center map to saved point" => "Center map to saved point",
// "Reset view to site default" => "Reset view to site default",
// "Users Map" => "Users Map",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "XML Zip" => "XML Zip",
// "Tiki installer" => "Tiki installer",
// "Welcome" => "Welcome",
// "Welcome to the Tiki installation and upgrade script" => "Welcome to the Tiki installation and upgrade script",
// "Use this script to install a new Tiki database or upgrade your existing database to release" => "Use this script to install a new Tiki database or upgrade your existing database to release",
// "For the latest information about this release, please read the" => "For the latest information about this release, please read the",
// "Release Notes" => "Release Notes",
// "For complete documentation, please visit" => "For complete documentation, please visit",
// "For more information about Tiki, please visit" => "For more information about Tiki, please visit",
// "Select your language" => "Select your language",
// "Read the License" => "Read the License",
// "Tiki is software distributed under the LGPL license" => "Tiki is software distributed under the LGPL license",
// " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>",
// "Review the System Requirements" => "Review the System Requirements",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "This installer will perform some basic checks automatically" => "This installer will perform some basic checks automatically",
// "Memory" => "Memory",
// "Success" => "Success",
// "Tiki has not detected your PHP memory_limit" => "Tiki has not detected your PHP memory_limit",
// "This probably means you have no set limit (all is well)" => "This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution",
// "Allocating too little memory will cause Tiki to display blank pages" => "Allocating too little memory will cause Tiki to display blank pages",
// "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Mail" => "Mail",
// "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages",
// "To test your system configuration, Tiki will attempt to send a test message to you" => "To test your system configuration, Tiki will attempt to send a test message to you",
// "Test email" => "Test email",
// "Email address to send test to" => "Email address to send test to",
// "Copy test mail to " => "Copy test mail to ",
// "Send Test Message" => "Send Test Message",
// "Tiki was able to send a test message to" => "Tiki was able to send a test message to",
// "Tiki was not able to send a test message" => "Tiki was not able to send a test message",
// "Review your mail log for details" => "Review your mail log for details",
// "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)",
// "If your host requires SMTP authentication, additional configuration may be necessary" => "If your host requires SMTP authentication, additional configuration may be necessary",
// "Image Processing" => "Image Processing",
// "Tiki detected" => "Tiki detected",
// "Tiki was not able to detect the GD library" => "Tiki was not able to detect the GD library",
// "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support",
// "Set the Database Connection" => "Set the Database Connection",
// "Tiki requires an active database connection" => "Tiki requires an active database connection",
// "You must create the database and user <em>before</em> completing this page" => "You must create the database and user <em>before</em> completing this page",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "This is normal for a new installation" => "This is normal for a new installation",
// "Tiki found an existing database connection in your local.php file" => "Tiki found an existing database connection in your local.php file",
// "Use Existing Connection" => "Use Existing Connection",
// "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>",
// "Database information" => "Database information",
// "Enter your database connection information" => "Enter your database connection information",
// "Database type" => "Database type",
// "Select the type of database to use with Tiki" => "Select the type of database to use with Tiki",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension",
// "Host name" => "Host name",
// "Enter the host name or IP for your database" => "Enter the host name or IP for your database",
// "Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "For SQLite, enter the path and filename to your database file" => "For SQLite, enter the path and filename to your database file",
// "Database name" => "Database name",
// "Enter the name of the database that Tiki will use" => "Enter the name of the database that Tiki will use",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names",
// "For Oracle" => "For Oracle",
// "Enter your TNS Name here and leave Host empty" => "Enter your TNS Name here and leave Host empty",
// "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field" => "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field",
// "Database user" => "Database user",
// "Enter a database user with administrator permission for the Database" => "Enter a database user with administrator permission for the Database",
// "Install &amp; Update Profile" => "Install &amp; Update Profile",
// "Install Profile" => "Install Profile",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database" => "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "Select the installation profile to use. This profile will populate the database" => "Select the installation profile to use. This profile will populate the database",
// "Profiles can be used to pre-configure your site with specific features and settings" => "Profiles can be used to pre-configure your site with specific features and settings",
// "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information" => "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information",
// "Reinstall the database" => "Reinstall the database",
// "This will destroy your current database" => "This will destroy your current database",
// "Create a new database (clean install) with profile" => "Create a new database (clean install) with profile",
// "Bare-bones default install" => "Bare-bones default install",
// "Personal Blog and Profile" => "Personal Blog and Profile",
// "Small Organization Web Presence" => "Small Organization Web Presence",
// "Company Intranet" => "Company Intranet",
// "Collaborative community" => "Collaborative community",
// "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles" => "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles",
// "The installer could not connect to the Profiles repository" => "The installer could not connect to the Profiles repository",
// "The default installation profile will be used" => "The default installation profile will be used",
// "Upgrade" => "Upgrade",
// "Automatically upgrade your existing database to v" => "Automatically upgrade your existing database to v",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Review the Upgrade" => "Review the Upgrade",
// "Review the Installation" => "Review the Installation",
// "Upgrade complete" => "Upgrade complete",
// "Installation complete" => "Installation complete",
// "Your database has been configured and Tiki is ready to run" => "Your database has been configured and Tiki is ready to run",
// "If this is your first install, your admin password is <strong>admin</strong>" => "If this is your first install, your admin password is <strong>admin</strong>",
// "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application",
// "Upgrade operations executed successfully" => "Upgrade operations executed successfully",
// "Installation operations executed successfully" => "Installation operations executed successfully",
// "SQL queries" => "SQL queries",
// "Database was left unchanged" => "Database was left unchanged",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages",
// ".htaccess File" => ".htaccess File",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "Complete these fields to configure common, general settings for your site" => "Complete these fields to configure common, general settings for your site",
// "The information you enter here can be changed later" => "The information you enter here can be changed later",
// "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings",
// "This will appear in the browser title bar" => "This will appear in the browser title bar",
// "Email sent by your site will use this address" => "Email sent by your site will use this address",
// "Secure Login" => "Secure Login",
// "HTTPS login" => "HTTPS login",
// "Administrator" => "Administrator",
// "Admin email" => "Admin email",
// "This is the email address for your administrator account" => "This is the email address for your administrator account",
// "Enter Your Tiki" => "Enter Your Tiki",
// "The installation is complete" => "The installation is complete",
// "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Installation" => "Installation",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu",
// "Enter Tiki and Lock Installer" => "Enter Tiki and Lock Installer",
// "Recommended" => "Recommended",
// "Enter Tiki Without Locking Installer" => "Enter Tiki Without Locking Installer",
// "MultiTiki Setup" => "MultiTiki Setup",
// "Default Installation" => "Default Installation",
// "DB OK" => "DB OK",
// "No DB" => "No DB",
// "Adding a new host" => "Adding a new host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Are you upgrading an existing Tiki site" => "Are you upgrading an existing Tiki site",
// "Go directly to the <strong>Install/Upgrade</strong> step" => "Go directly to the <strong>Install/Upgrade</strong> step",
// "Install/Upgrade" => "Install/Upgrade",
// "Restart the installer" => "Restart the installer",
// "Database Connection" => "Database Connection",
// "Reset the Database Connection" => "Reset the Database Connection",
// "Configure the General Settings" => "Configure the General Settings",
// "Tiki Icon" => "Tiki Icon",
// "TikiWiki Project Web Site" => "TikiWiki Project Web Site",
// "Support Forums" => "Support Forums",
// "TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware Project",
// "Powered by TikiWiki" => "Powered by TikiWiki",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "Last 2 days" => "Last 2 days",
// "Last 3 days" => "Last 3 days",
// "Last 5 days" => "Last 5 days",
// "Last week" => "Last week",
// "Last 2 weeks" => "Last 2 weeks",
// "Last month" => "Last month",
// "Max Clicks" => "Max Clicks",
// "The cache is used by" => "The cache is used by",
// "Approval" => "Approval",
// "Rejected" => "Rejected",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "SlideShow" => "SlideShow",
// "Keep gallery window open" => "Keep gallery window open",
// "Your comment" => "Your comment",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "Flash binary (.swf or .dcr)" => "Flash binary (.swf or .dcr)",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Page creator" => "Page creator",
// "Status of the page" => "Status of the page",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl" => "Backl",
// "Page size" => "Page size",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "offline" => "offline",
// "Back to admin" => "Back to admin",
// "For security purposes we must periodically validate your email address to allow continued access to this site" => "For security purposes we must periodically validate your email address to allow continued access to this site",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site" => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site",
// "Thank you" => "Thank you",
// "This is an experimental feature" => "This is an experimental feature",
// "Requires" => "Requires",
// "Not Enabled" => "Not Enabled",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>" => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "licence" => "licence",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "My Articles" => "My Articles",
// "User Articles" => "User Articles",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you participate" => "To display the objects you participate",
// "My Infos" => "My Infos",
// "Contacts Preferences" => "Contacts Preferences",
// "My Contacts" => "My Contacts",
// "My Wiki Pages" => "My Wiki Pages",
// "My Galleries" => "My Galleries",
// "My Tracker Items" => "My Tracker Items",
// "My Messages" => "My Messages",
// "My Tasks" => "My Tasks",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription failed" => "Subscription failed",
// "Add a news server" => "Add a news server",
// "Edit news server" => "Edit news server",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "View Permissions" => "View Permissions",
// "Edit Permissions" => "Edit Permissions",
// "These permissions override any global permissions or category permissions affecting this object" => "These permissions override any global permissions or category permissions affecting this object",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>",
// "No individual permissions, category permissions apply" => "No individual permissions, category permissions apply",
// "Current permissions for categories that this object belongs to" => "Current permissions for categories that this object belongs to",
// "These permissions do not apply. Special permissions apply" => "These permissions do not apply. Special permissions apply",
// "No category permissions; special permissions apply" => "No category permissions; special permissions apply",
// "and also to all pages of the sub-structure" => "and also to all pages of the sub-structure",
// "Perms Help" => "Perms Help",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts" => "Your identity gives you access to multiple user accounts",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "View Details" => "View Details",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Any" => "Any",
// "Items found" => "Items found",
// "Sum" => "Sum",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Plugin" => "Plugin",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "Selected Structures" => "Selected Structures",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected" => "No pages selected",
// "Passed" => "Passed",
// "Rank" => "Rank",
// "star" => "star",
// "half star" => "half star",
// "Send a link" => "Send a link",
// "List all articles of this same topic" => "List all articles of this same topic",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist" => "The highlight pages already exist",
// "Please, change the name if you want the page to be uploaded" => "Please, change the name if you want the page to be uploaded",
// "Received Structures" => "Received Structures",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Use your email as login" => "Use your email as login",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "Select your group" => "Select your group",
// "Enter your username or email" => "Enter your username or email",
// "Enter your email" => "Enter your email",
// "Request Password Reset" => "Request Password Reset",
// "Back to page" => "Back to page",
// "to version" => "to version",
// "\$name" => "\$name",
// "Faqs" => "Faqs",
// "Blogs Post" => "Blogs Post",
// "Date Search" => "Date Search",
// "All dates" => "All dates",
// "Calendar Items" => "Calendar Items",
// "Please Confirm" => "Please Confirm",
// "octets" => "octets",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Attached Files" => "Attached Files",
// "To add a file, click here" => "To add a file, click here",
// "Save as Draft" => "Save as Draft",
// "Send a structure" => "Send a structure",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Approve changes" => "Approve changes",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "TOC" => "TOC",
// "page: %0/%1" => "page: %0/%1",
// "Page last modified on %0 by %1" => "Page last modified on %0 by %1",
// "Created by %0" => "Created by %0",
// "Last Modification: %0 by %1" => "Last Modification: %0 by %1",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Clean" => "Clean",
// "Date of first pageview" => "Date of first pageview",
// "Days since first pageview" => "Days since first pageview",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "FAQ Stats" => "FAQ Stats",
// "Tiki Logs" => "Tiki Logs",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Send a link to a friend" => "Send a link to a friend",
// "The link was sent to the following addresses" => "The link was sent to the following addresses",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma" => "Separate multiple email addresses with a comma",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like" => "I found an interesting page that I thought you would like",
// "TikiTests Edit" => "TikiTests Edit",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request" => "Request",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "Additional Info" => "Additional Info",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "You locked the file" => "You locked the file",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "Unzip zip files" => "Unzip zip files",
// "Author if not the file creator" => "Author if not the file creator",
// "Maximum amount of downloads" => "Maximum amount of downloads",
// "Add File" => "Add File",
// "Maximum file size is limited to" => "Maximum file size is limited to",
// "No gallery available" => "No gallery available",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// "The column is disabled" => "The column is disabled",
// "a folder" => "a folder",
// "a URL" => "a URL",
// "User Contacts Preferences" => "User Contacts Preferences",
// "Manage Fields" => "Manage Fields",
// "Default view" => "Default view",
// "(non public)" => "(non public)",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Forum comments" => "Forum comments",
// "Male" => "Male",
// "Female" => "Female",
// "Use Google Map locator" => "Use Google Map locator",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages" => "Can you read more languages",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language.." => "Select language..",
// "Displays users' info tooltip on mouseover for every user who allows his information to be public" => "Displays users' info tooltip on mouseover for every user who allows his information to be public",
// "My user items" => "My user items",
// "My level" => "My level",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Use \"watches\" to monitor wiki pages or other objects" => "Use \"watches\" to monitor wiki pages or other objects",
// "Watch new items by clicking the {icon _id=eye} button on specific pages" => "Watch new items by clicking the {icon _id=eye} button on specific pages",
// "Select event type" => "Select event type",
// "All watched events" => "All watched events",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "Used space" => "Used space",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "Forum Lock" => "Forum Lock",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Filter Posts" => "Filter Posts",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Archived" => "Archived",
// "Topic List" => "Topic List",
// "The post has been reported and will be reviewed by a moderator" => "The post has been reported and will be reviewed by a moderator",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Stop Monitor" => "Stop Monitor",
// "Pending" => "Pending",
// "Edit/Delete" => "Edit/Delete",
// "There was an error connecting to your e-mail account" => "There was an error connecting to your e-mail account",
// "Add a new" => "Add a new",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "Click to activate" => "Click to activate",
// "This is the active account" => "This is the active account",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Refresh now" => "Refresh now",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Jump to Content" => "Jump to Content",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Your vote" => "Your vote",
// "Click to vote for this value" => "Click to vote for this value",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Reinstall" => "Reinstall",
// "Undecided" => "Undecided",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "Preview your changes" => "Preview your changes",
// "Save the page as a partial translation" => "Save the page as a partial translation",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation" => "Save the page as a completed translation",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated" => "Save the page, but do not send notifications and do not count it as new content to be translated",
// "Save the page" => "Save the page",
// "Save the page as a draft" => "Save the page as a draft",
// "Save Draft" => "Save Draft",
// "Cancel the edit, you will lose your changes" => "Cancel the edit, you will lose your changes",
// "Separate multiple usernames with a comma (&nbsp;,&nbsp;)" => "Separate multiple usernames with a comma (&nbsp;,&nbsp;)",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "%s set" => "%s set",
// "%s unset" => "%s unset",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Freetags settings" => "Freetags settings",
// "Look & Feel" => "Look & Feel",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Current version is up to date : <b>%s</b>" => "Current version is up to date : <b>%s</b>",
// "A new %s  major release branch is available" => "A new %s  major release branch is available",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Click here to delete the category" => "Click here to delete the category",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Test Image" => "Test Image",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "If you use apache, you need a .htaccess file to have this feature working" => "If you use apache, you need a .htaccess file to have this feature working",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "Invalid email" => "Invalid email",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "Invalid or unknown email" => "Invalid or unknown email",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "User login contains invalid characters" => "User login contains invalid characters",
// "Deleted account %s" => "Deleted account %s",
// "Login contains invalid characters" => "Login contains invalid characters",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "Last modifications to the blog" => "Last modifications to the blog",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache" => "You must clear your browser cache",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "Translation in progress" => "Translation in progress",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Page already exists. Go back and choose a different name" => "Page already exists. Go back and choose a different name",
// "The translation set already contains a page in this language" => "The translation set already contains a page in this language",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "Last replied forum topics" => "Last replied forum topics",
// "Not supported yet" => "Not supported yet",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "Invalid source path" => "Invalid source path",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "Operations executed successfully" => "Operations executed successfully",
// "Page saved (version %d)" => "Page saved (version %d)",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Delete comments" => "Delete comments",
// "Approved Status" => "Approved Status",
// "Queued" => "Queued",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read the file" => "Cannot read the file",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Invalid password" => "Invalid password",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "Please create a directory named '.\$prefs['map_path'].' to hold your map files" => "Please create a directory named '.\$prefs['map_path'].' to hold your map files",
// "map edit" => "map edit",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "You must choose a group" => "You must choose a group",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "mail adress" => "mail adress",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password" => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email" => "to the email",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "invalid email" => "invalid email",
// "Notice: this variable may not be empty" => "Notice: this variable may not be empty",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Clean the sql logs" => "Clean the sql logs",
// "Report to the webmaster" => "Report to the webmaster",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "Password has been changed" => "Password has been changed",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "A new page is created in a language" => "A new page is created in a language",
// "Language watch" => "Language watch",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "Incorrect thread" => "Incorrect thread",
// " The connection failed, so check the server names" => " The connection failed, so check the server names",
// "The connection was OK" => "The connection was OK",
// " But the login failed, so check the Username and Password" => " But the login failed, so check the Username and Password",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"ID" => "ID",
"Algeria" => "Algeria",
"Angola" => "Angola",
"Antigua" => "Antigua",
"Armenia" => "Armenia",
"Australia" => "Australia",
"Bahrain" => "Bahrain",
"Bangladesh" => "Bangladesh",
"Barbados" => "Barbados",
"Belarus" => "Belarus",
"Bermuda" => "Bermuda",
"Bolivia" => "Bolivia",
"Brunei" => "Brunei",
"Bulgaria" => "Bulgaria",
"Chile" => "Chile",
"Colombia" => "Colombia",
"Fiji" => "Fiji",
"Guatemala" => "Guatemala",
"Haiti" => "Haiti",
"Honduras" => "Honduras",
"Indonesia" => "Indonesia",
"Iran" => "Iran",
"Israel" => "Israel",
"Kazakstan" => "Kazakstan",
"Kiribati" => "Kiribati",
"Kuwait" => "Kuwait",
"Latvia" => "Latvia",
"Luxemburg" => "Luxemburg",
"Malawi" => "Malawi",
"Malta" => "Malta",
"Mauritius" => "Mauritius",
"Nauru" => "Nauru",
"Nicaragua" => "Nicaragua",
"Nigeria" => "Nigeria",
"Niue" => "Niue",
"Pakistan" => "Pakistan",
"Panama" => "Panama",
"Peru" => "Peru",
"Romania" => "Romania",
"Samoa" => "Samoa",
"Singapore" => "Singapore",
"Slovakia" => "Slovakia",
"Slovenia" => "Slovenia",
"Somalia" => "Somalia",
"Surinam" => "Surinam",
"Taiwan" => "Taiwan",
"Tonga" => "Tonga",
"Tuvalu" => "Tuvalu",
"Vanuatu" => "Vanuatu",
"Venezuela" => "Venezuela",
"Wales" => "Wales",
"Zambia" => "Zambia",
"Zimbabwe" => "Zimbabwe",
"Pijin Solomon" => "Pijin Solomon",
"latin" => "latin",
"english" => "english",
"CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
"min" => "min",
"km" => "km",
"index" => "index",
"max" => "max",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
"Info" => "Info",
"Copyright" => "Copyright",
"URL" => "URL",
"Pop-up" => "Pop-up",
"Id" => "Id",
", " => ", ",
"Top" => "Top",
"id" => "id",
"debug" => "debug",
"RSS Wiki" => "RSS Wiki",
"Hi," => "Hi,",
"Hi" => "Hi",
"Bye bye!" => "Bye bye!",
"Ip" => "Ip",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"phpinfo" => "phpinfo",
"Tiki Logo" => "Tiki Logo",
"Wiki RSS" => "Wiki RSS",
"[-]" => "[-]",
"URI" => "URI",
"RSS" => "RSS",
"Intertiki" => "Intertiki",
"InterTiki" => "InterTiki",
"Mobile" => "Mobile",
"XMLRPC API" => "XMLRPC API",
"Debugger Console" => "Debugger Console",
"Unix" => "Unix",
"Windows" => "Windows",
"IP" => "IP",
"PEAR::Auth" => "PEAR::Auth",
"PAM" => "PAM",
"LDAP" => "LDAP",
"Webmaster" => "Webmaster",
"dls" => "dls",
"MultiPrint" => "MultiPrint",
"DSN" => "DSN",
"bytes" => "bytes",
"x" => "x",
"Url" => "Url",
"h" => "h",
"CMS" => "CMS",
"Ver" => "Ver",
"Regex" => "Regex",
"mn" => "mn",
"Alias" => "Alias",
"Tbl vis" => "Tbl vis",
"Powered by" => "Powered by",
"popup" => "popup",
"+" => "+",
"%m/%d" => "%m/%d",
"Tiki Debugger Console" => "Tiki Debugger Console",
"URL:" => "URL:",
"Sun" => "Sun",
"%" => "%",
"idea" => "idea",
"Int" => "Int",
"#" => "#",
"inter" => "inter",
"ver:" => "ver:",
"auto" => "auto",
"int" => "int",
"v" => "v",
"/" => "/",
"Top 10" => "Top 10",
"Top 20" => "Top 20",
"Top 50" => "Top 50",
"Top 100" => "Top 100",
"tikiwiki.org" => "tikiwiki.org",
"eek" => "eek",
"lol" => "lol",
"mr green" => "mr green",
"razz" => "razz",
"santa" => "santa",
"Mb" => "Mb",
"%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
"Pos" => "Pos",
"sun" => "sun",
"TOP" => "TOP",
"%H:%M %Z" => "%H:%M %Z",
"unicode" => "unicode",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Tämä ominaisuus ei ole käytössä",
"Permission denied you cannot view pages" => "Oikeutesi eivät riitä katsomaan sivuja",
"Re:" => "Vast:",
"This script cannot be called directly" => "Tätä merkkijonoa ei voi kutsua suoraan",
"The copyright management feature is not enabled." => "Copyright hallintaominaisuus ei ole käytössä.",
"No page indicated" => "Ei sivua osoitettu",
"You must supply all the information, including title and year." => "On lisättävä kaikki tieto, myös otsikko ja vuosi.",
"You do not have permission to use this feature" => "Oikeutesi eivät riitä käyttämääm tätä ominaisuutta",
"This feature is for admins only" => "Tämä ominaisuus on vain ylläpidolle",
"Type" => "Tyyppi",
"Name" => "Nimi",
"Description" => "Kuvaus",
"Size" => "Koko",
"Created" => "Luotu",
"Last Modified" => "Viimeksi muokannut",
"Creator" => "Luonut",
"Author" => "Kirjoittaja",
"Last editor" => "Viimeksi muokannut",
"Comment" => "Kommentti",
"Files" => "Tiedostot",
"Hits" => "Osumia",
"Locked by" => "Lukitsijana",
"Path" => "Polku",
"American Samoa" => "Amerikan_Samoa",
"Argentina" => "Argentiina",
"Austria" => "Itävalta",
"Bahamas" => "Bahama",
"Belgium" => "Belgia",
"Brazil" => "Brasilia",
"Canada" => "Kanada",
"Catalan Countries" => "Catalan_Countries",
"Cayman Islands" => "Cayman_Saaret",
"China" => "Kiina",
"Cook Islands" => "Cook_Saaret",
"Costa Rica" => "Costa_Rica",
"Croatia" => "Kroatia",
"Cuba" => "Kuuba",
"Cyprus" => "Kypros",
"Czech Republic" => "Tsekin_Tasavalta",
"Denmark" => "Tanska",
"Dominican Republic" => "Dominikaaninen_Tasavalta",
"Ecuador" => "Ekuadori",
"Egypt" => "Egypti",
"El Salvador" => "El_Salvador",
"Estonia" => "Eesti",
"Federated States of Micronesia" => "Federated_States_of_Micronesia",
"Finland" => "Suomi",
"France" => "Ranska",
"French Polynesia" => "Ranskan_Polynesia",
"Germany" => "Saksa",
"Greece" => "Kreikka",
"Guam" => "Guami",
"Hungary" => "Unkari",
"Iceland" => "Islanti",
"India" => "Intia",
"Iraq" => "Irak",
"Ireland" => "Irlanti",
"Italy" => "Italia",
"Ivory Coast" => "Norsunluu_Rannikko",
"Jamaica" => "Jamaika",
"Japan" => "Japani",
"Jordan" => "Jordania",
"Kenya" => "Kenia",
"Lebanon" => "Libanon",
"Lithuania" => "Liettua",
"Malaysia" => "Malesia",
"Marshall Islands" => "Marshall_Saaret",
"Mexico" => "Mexiko",
"Morocco" => "Marocco",
"Mozambique" => "Mozambiq",
"Nepal" => "Nepali",
"Netherlands" => "Alankomaat",
"New Caledonia" => "Uusi_Kaledonia",
"New Zealand" => "Uusi_Seelanti",
"None" => "EiMitään",
"Norway" => "Norja",
"Other" => "Muu",
"Papua New Guinea" => "Papua_Uusi_Ginea",
"Paraguay" => "Paraguai",
"Poland" => "Puola",
"Portugal" => "Portugali",
"Puerto Rico" => "Puerto_Rico",
"Quatar" => "Qatari",
"Russia" => "Venäjä",
"Russian Federation" => "Venäjä",
"Saudi Arabia" => "Saudi_Arabia",
"Solomon Islands" => "Salomon_Saaret",
"South Africa" => "Etelä_Afrikka",
"South Korea" => "Etelä_Korea",
"Spain" => "Espanja",
"Sri Lanka" => "Sri_Lanka",
"St Vincent Grenadines" => "St_Vincent_Grenadiinit",
"Sweden" => "Ruotsi",
"Switzerland" => "Sveitsi",
"Thailand" => "Thaimaa",
"Trinidad Tobago" => "Trinidad_Tobago",
"Turkey" => "Turkki",
"Ukraine" => "Ukraina",
"United Arab Emirates" => "Yhdistyneet_Arab_Emiraatit",
"United Kingdom" => "Yhdistynyt_Kuningaskunta",
"United States" => "Yhdysvallat",
"Uruguay" => "Uruguai",
"Yugoslavia" => "Jugoslavia",
"Arabic" => "Arabia",
"Catalan" => "Katalonia",
"Simplified Chinese" => "Yksinkertaistettu Kiina",
"Chinese" => "Kiina",
"Czech" => "Tsekki",
"Danish" => "Tanska",
"German" => "Saksa",
"English" => "Englanti",
"English British" => "Brittiläinen Englanti",
"Spanish" => "Espanja",
"Greek" => "Kreikka",
"Finnish" => "Suomi",
"French" => "Ranska",
"Hebrew" => "Hebrea",
"Croatian" => "Kroatialainen",
"Italian" => "Italia",
"Japanese" => "Japani",
"Korean" => "Korealainen",
"Hungarian" => "Unkarilainen",
"Dutch" => "Hollanti",
"Norwegian" => "Norja",
"Polish" => "Puola",
"Português" => "Portugalilainen",
"Brazilian Portuguese" => "Brazilian Portugali",
"Russian" => "Venäjä",
"Slovak" => "Slovakia",
"Serbian" => "Serbia",
"Serbian Latin" => "Serbian Latino",
"Swedish" => "Ruotsi",
"Tuvaluan" => "Tuvalualainen",
"Traditional Chinese" => "Perinteinen Kiina",
"Ukrainian" => "Ukrainalainen",
"This instance of activity is already complete" => "Tämä esimerkki toiminnon kohde on jo valmis",
"Fatal error: cannot execute automatic activity \$activityId" => "Vakava virhe: ei voi käynnistää automaattista toimintoa \$activityId",
"Fatal error: setting next activity to an unexisting activity" => "Vakava virhe: asetettu seuraava toiminto on olematon",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Vakava virhe: seuraava toiminto ei täsmää minkään ehdokkaan kanssa",
"Fatal error: non-deterministic decision for autorouting activity" => "Vakava virhe: väärä valinta automaattiseksi toiminteeksi",
"Fatal error: trying to send an instance to an activity but no transition found" => "Vakava virhe: yritys lähettää juttua toimintoon ei onnistu, koska siirtymää ei löydy",
"Cannot add transition only split activities can have more than one outbound transition" => "Ei voi lisätä siirtoa jaettuihin toimintoihin joilla voi olla useampi siirtymä",
"Circular reference found some activity has a transition leading to itself" => "Rengas asetus löydetty toiminto osoittaa itseään",
"Process does not have a start activity" => "Prosessilla ei ole käynnistävää toimintoa",
"Process does not have exactly one end activity" => "Prosessilla ei ole tasan yhtä lopetus toimintoa",
"End activity is not reachable from start activity" => "lopetus toiminto ei ole tavoitettavissa käynnistys toiminnosta",
"Activity" => "Toiminto",
"is interactive but has no role assigned" => "ei ole aktiivinen, mutta ei ole tehtävää liitettynä",
"is non-interactive and non-autorouted but has no role assigned" => "ei ole vuorovaikutteinen eikä ole tehtävää liitettynä",
"is standalone but has transitions" => "on yksinäinen, mutta sisältää siirtymiä",
"Role" => "Tehtävä",
"is not mapped" => "ei ole kartoitettu",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Toiminto '.\$res['name'].' on yksittäinen käyttäen \$instance object",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Toiminto '.\$res['name'].' on vuorovaikutteinen joten on käytettävä \$instance->complete() työtapaa",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Toiminto '.\$res['name'].' ei ole vuorovaikutteinen joten ei voi käyttää \$instance->complete() työtapaa",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Toiminto '.\$res['name'].' on kytkin joten on käytettävä \$instance->setNextActivity(\$actname) työtapaa",
"Process %d has been activated" => "Prosessi %d on käynnistetty",
"Process %d has been deactivated" => "Prosessi %d on suljettu",
"Process %s %s imported" => "Prosessi %s %s tuotu",
"Process %s removed" => "Prosessi %s poistettu",
"Process %s has been updated" => "Prosessi %s on päivitetty",
"Process %s has been created" => "Prosessi %s on luotu",
"points" => "pisteitä",
"Disabled" => "Poistettu",
"Plain text" => "Tavallinen teksti",
"Link to user information" => "Linkki käyttäjä tietoihin",
"User avatar" => "Käytä Hahmoa",
"Creation date (desc)" => "Luontipäivä (aleneva)",
"Last modification date (desc)" => "Viimeisin muokkaus päivä (aleneva)",
"Blog title (asc)" => "Blogin aihe (nouseva)",
"Number of posts (desc)" => "Lähetysten määrä (aleneva)",
"Visits (desc)" => "Vierailuja (aleneva)",
"Activity (desc)" => "Aktiivisuus (aleneva)",
"Top bar" => "Ylä palkki",
"Bottom bar" => "Ala palkki",
"no cache" => "ei puskuri",
"minute" => "minuutti",
"minutes" => "minuuttia",
"hour" => "tunti",
"hours" => "tuntia",
"as Creator &amp; Last Editor" => "Luojana &amp; Viimeksi Muokannut",
"Business style" => "Bisnes tyyli",
"Collaborative style" => "Yhteisöllinen tyyli",
"Page last modified on" => "Sivua viimeksi muutettu",
"no (disabled)" => "ei (poistettu)",
"|| for rows" => "|| riveille",
"<return> for rows" => "\\n riveille",
"Only with last version" => "Vain viimeisimmän version kanssa",
"Any 2 versions" => "Mitkä tahansa 2 versiota",
"complete" => "valmis",
"Year" => "Vuosi",
"Saturday" => "Lauantai",
"Sunday" => "Sunnuntai",
"Monday" => "Maanantai",
"No error reporting" => "Ei virhe raportointia",
"Report all PHP errors" => "Raportoi kaikki PHP virheet",
"Report all errors except notices" => "Raportoi kaikki virheet muttei huomautuksia",
"Creation Date (desc)" => "Luonti Päivä (aleneva)",
"Topics (desc)" => "Aiheet (aleneva)",
"Threads (desc)" => "Ketjut (aleneva)",
"Last post (desc)" => "Viimeiset lähetykset (aleneva)",
"Name (desc)" => "Nimi (aleneva)",
"Name (asc)" => "Nimi (nouseva)",
"replace current window" => "korvaa nykyinen ikkuna",
"new window" => "uusi ikkuna",
"inline frame" => "sisäinen kehys",
"5 minutes" => "5 minuutin kuluttua",
"1 day" => "1 päivän kuluttua",
"1 week" => "1 viikon kuluttua",
"1 month" => "1 kuukauden kuluttua",
"Allow secure (https) login" => "Salli salattu (https) kirjautuminen",
"Require secure (https) login" => "Vaaditaan salattu (https) kirjautuminen",
"Just Tiki" => "Vain Tiki",
"Web Server" => "Web Palvelin",
"Tiki and PEAR::Auth" => "Tiki ja PEAR::Auth",
"Tiki and PAM" => "Tiki ja PAM",
"choose a group ..." => "valitse ryhmä ...",
"Registered" => "Rekisteröity",
"Anonymous" => "Nimetön",
"Use database to store files" => "Käytä tietokantaa tiedostojen varastointiin",
"Use a directory to store files" => "Käytä hakemistoa tiedostojen varastointiin",
"%s enabled" => "%s päälle",
"%s disabled" => "%s poispäältä",
"Permission denied" => "Lupa evätty",
"The file is not a CSV file or has not a correct syntax" => "Tiedosto ei ole CSV tai parametrit ovat väärin",
"locked" => "lukittu",
"locked by" => "lukitsijana",
"Administration:" => "Ylläpito:",
"in" => "sisään",
"continued" => "jatkuu",
"New Image Uploaded by" => "Uuden kuvan lähettäjä",
"New Subscriptions" => "Uudet tilaukset",
"New Item in Tracker" => "Uusi osa kortistossa",
"tracker" => "kortisto",
"by" => " ",
"Wiki" => "Sivusto",
"Image Gallery" => "Kuva Galleria",
"Articles" => "Artikkelit",
"Blogs" => "Blogit",
"Forums" => "Foorumit",
"Directory" => "Hakemisto",
"File Gallery" => "Tiedosto Galleria",
"FAQs" => "UKK:t",
"Quizzes" => "Visailut",
"Trackers" => "Kortistot",
"Survey" => "Tutkimukset",
"Newsletter" => "Uutislehti",
"Charts" => "Kaaviot",
"article" => "artikkeli",
"blog" => "blogi",
"directory" => "hakemisto",
"faq" => "ukk",
"file gallery" => "tiedosto galleria",
"forum" => "foorumi",
"image gallery" => "kuva galleria",
"newsletter" => "uutiskirja",
"poll" => "äänestys",
"quiz" => "visailu",
"survey" => "tutkimus",
"wiki page" => "sivu",
"image" => "kuva",
"calendar" => "kalenteri",
"Invalid filename (using filters for filenames)" => "Väärä tiedostonimi (käyttäen suodinta tiedostonimissä)",
"Cannot upload this file maximum upload size exceeded" => "Et voi lähettää tiedostoa, maximi lähetyskoko ylittyy",
"You have mistyped the anti-bot verification code; please try again." => "Sinulla on kirjoitusvirhe anti-bot varmistus koodissa; yritä uudelleen.",
"Wrong password. Cannot post comment" => "Väärä salasana. Et voi lähettää kommenttia",
"You have to enter a title and text" => "Kirjoita otsikko ja teksti",
"text" => "teksti",
"WikiDiff::apply: line count mismatch: %s != %s" => "Diff::lisää: rivilaskuri sopimaton: %s != %s",
"WikiDiff::_check: failed" => "Diff::_tarkistus: epäonnistui",
"WikiDiff::_check: edit sequence is non-optimal" => "Diff::_tarkistus: muokkaus järjestys ei optimaalinen",
"WikiDiff Okay: LCS = %s" => "Diff Okei: LCS = %s",
"Line:" => "Viiva:",
"Lines:" => "Viivat:",
"Find" => "Etsi",
"find" => "löytyi",
"prev" => "edellinen",
"Page" => "Sivu",
"next" => "seuraava",
"Link" => "Linkki",
"Page name" => "Sivun nimi",
"Wiki Home" => "EtuSivu",
"Home" => "Etusivu",
"Blog" => "Blogi",
"previous page" => "edellinen sivu",
"next page" => "seuraava sivu",
"posted on" => "lähettänyt",
"Continue" => "Jatkuu",
"By:" => " :",
"Read" => "Lukijaa",
"List articles" => "Listaa artikkelit",
"Last post" => "Viimeiset lähetykset",
"Invalid imagename (using filters for filenames)" => "Väärä kuvanimi (käyttäen suodinta tiedostonimissä)",
"Errors detected" => "Virheitä havaittu",
"Upload was not successful" => "Lähetys ei onnistunut",
"No image yet, sorry." => "Ei kuvaa vielä, valitan.",
"No valid ogr2ogr executable" => "Ei hyväksyttävä ogr2ogr ohjelma",
"Could not create \$tdo.mif in data directory" => "Ei voi luoda \$tdo.mif tietohakemistoon",
"Could not create \$tdo.mid in data directory" => "Ei voi luoda \$tdo.mid tietohakemistoon",
"unknown" => "tuntematon",
"User Map Generated in:" => "Käyttäjäkartta muodostettu:",
"Image Map Generated in:" => "Kuvakartta muodostettu:",
"NONE" => "EIMITÄÄN",
"File %s not found" => "Tiedostoa %s ei löydy",
"File %s is not a valid archive" => "Tiedosto %s ei ole arkistoitavissa",
"Impossible to open %s : %s" => "Mahdoton aukaista %s : %s",
"This poll is closed." => "Tämä äänestys on suljettu.",
"Wiki top pages" => "Top sivut",
"Most relevant pages" => "Eniten asiaan kuuluvat sivut",
"Relevance" => "Asianmukainen",
"Wiki last pages" => "Viimeiset sivut",
"Modified" => "Muokattu",
"Forums last topics" => "Foorumin viimeiset aiheet",
"Topic date" => "Aihee päiväys",
"Forums last posts" => "Foorumin viime lähetykset",
"Forums most read topics" => "Foorumin eniten luetut aiheet",
"Reads" => "Lukijaa",
"Forums best topics" => "Foorumin parhaat aiheet",
"Score" => "Pisteytys",
"Forums most visited forums" => "Luetuimmat foorumit",
"Visits" => "Vierailut",
"Forums with most posts" => "Vastatuimmat foorumit",
"Posts" => "Lähetyksiä",
"Wiki top galleries" => "Top galleriat",
"Wiki top file galleries" => "Top tiedosto galleriat",
"Wiki top images" => "Top kuvat",
"Wiki top files" => "Top tiedostot",
"Downloads" => "Imuroinnit",
"Wiki last images" => "Viimeiset kuvat",
"Upload date" => "Lähetys päivä",
"Wiki last files" => "Viimeiset tiedostot",
"Wiki top articles" => "Top artikkelit",
"Most visited blogs" => "Luetuimmat blogit",
"Most active blogs" => "Aktiivisimmat blogit",
"Blogs last posts" => "Blogien viimeiset postit",
"Post date" => "Postitus päivä",
"Wiki top authors" => "Top kirjoittajat",
"Pages" => "Sivut",
"Top article authors" => "Top artikkelikirjoittajat",
"User already exists" => "Käyttäjä on jo olemassa",
"Wrong registration code" => "Väärä rekisteröinti koodi",
"Invalid username" => "Väärä käyttäjänimi",
"Username is too long" => "Käyttäjänimi liian pitkä",
"Username cannot contain whitespace" => "Käyttäjänimi ei voi sisältää sanavälejä",
"Wrong passcode you need to know the passcode to register in this site" => "Väärä passikoodi, sinulla on oltava oikea passikoodi rekisteröityäksesi sivustolle",
"Invalid email address. You must enter a valid email address" => "Väärä sähköpostiosoite. On käytettävä voimassa olevaa sähköpostiosoitetta",
"The registration mail can't be sent. Contact the administrator" => "Rekisteröinti sähköpostia ei voida lähettää. Ota yhteys ylläpitoon",
"Login" => "Kirjautuminen",
"See other user's profile" => "Katso muiden käyttäjien profiileja",
"Have your profile seen" => "Voiko profiiliasi katsoa",
"Make friends" => "Ystävysty",
"Receive message" => "Vastaanota viesti",
"Send message" => "Lähetä viesti",
"Read an article" => "Lue artikkeli",
"Publish an article" => "Julkaise artikkeli",
"Have your article read" => "Onko artikkeliasi luettu",
"Create new file gallery" => "Luo uusi tiedosto galleria",
"Upload new file to gallery" => "Lähetä uusi tiedosto galleriaan",
"Download other user's file" => "Imuroi toisen käyttäjän tiedosto",
"Have your file downloaded" => "Onko tiedostoasi imuroitu",
"Create a new image gallery" => "Luo uusi kuva galleria",
"Upload new image to gallery" => "Lähetä uusi kuva galleriaan",
"See other user's gallery" => "Katso toisen käyttäjän galleriaa",
"See other user's image" => "Katso toisen käyttäjän kuvaa",
"Have your gallery seen by other user" => "Onko galleriaasi katsonut toinen käyttäjä",
"Have your image seen" => "Onko kuvaasi katsottu",
"Create new blog" => "Luo uusi blogi",
"Post in a blog" => "Postita blogiin",
"Read other user's blog" => "Lue toisen käyttäjän blogia",
"Have your blog read" => "Onko blogiasi luettu",
"Create a new wiki page" => "Luo uusi sivu",
"Edit an existing page" => "Muokkaa olemassa olevaa sivua",
"Attach file" => "Liitä tiedosto",
"Tracker" => "Kortisto",
"Unknown" => "Tuntematon",
"Trackeritem" => "Kortistonosa",
"Image" => "Kuva",
"Article" => "Artikkeli",
"Directory category" => "Hakemisto luokittelu",
"FAQ" => "UKK",
"Forum" => "Foorumi",
"Gallery" => "Galleria",
"Blog post" => "Blogi lähetys",
"Prev" => "Edel",
"Next" => "Seuraava",
"Edit Template" => "Muokkaa mallia",
"Hide" => "Piilota",
"help" => "auta",
"All" => "Kaikki",
"The text is" => "Teksti on",
"character(s) too long - please edit it." => "liikaa kirjaimia - muokkaa sitä.",
"Date Selector" => "Päivä Valitsin",
"Select All" => "Valitse kaikki",
"days" => "päivää",
"day" => "päivä",
"mins" => "min",
"secs" => "sek",
"done" => "tehty",
"Text cut here" => "Teksti katkaistaan tästä",
"Task" => "Tehtävä",
"from" => "keneltä",
"for" => "varten",
"Priority" => "Ensisijaisuus",
"Start date:" => "Aloitus päivä:",
"End date:" => "Lopetus päivä:",
"User information - Click for more info" => "Käyttäjä tiedot - Painamalla lisää tietoa",
"Friend" => "Ystävä",
"Last seen on" => "Katsottu viimeksi",
"(idle for %s seconds)" => "(odottanut %s sekuntia)",
"More info about \$other_user" => "Lisää tietoa \$other_user",
"(idle for \$idletime seconds)" => "(odottanut \$idletime sekuntia)",
"Yes" => "Kyllä",
"No" => "Ei",
"pvs" => "snp",
"Use this tree to copy the structure" => "Käytä tätä puuta kopioidaksesi rakenteen",
"created from structure" => "luotu rakenteesta",
"Table of contents" => "Sisällysluettelo",
"unknown error" => "tuntematon virhe",
"You are not logged in" => "Et ole kirjautunut sisään",
"Page cannot be found" => "Sivua ei löytynyt",
"Permission denied you cannot view this section" => "Ei oikeutta katsoa tätä osastoa",
"An error occured in a database query!" => "Virhe tietokanta kyselyssä!",
"Help" => "Auta",
"You are banned from" => "Sinut on poistettu",
"wiki" => "sivusto",
"img-g" => "kuva-g",
"file-g" => "tied-g",
"faqs" => "ukk:sta",
"quizzes" => "visailuista",
"arts" => "artik",
"blogs" => "blogeista",
"forums" => "foorumeilta",
"games" => "peleistä",
"Click to edit dynamic variable" => "Paina muokataksesi dynaamista muuttujaa",
"Update variables" => "Päivitä muuttujat",
"Show" => "Näytä",
"Altering database table failed" => "Tietokannan muutos epäonnistui",
"%d points" => "%d pistettä",
"Removed" => "Poistettu",
"__WARNING__: No such module \$plugin!" => "__WAROITUS__: Ei sellaista moduuli \$plugia!",
"at" => " ",
"new" => "uusi",
"Create page:" => "Luo sivu:",
"Unknown language" => "Tuntematon kieli",
"Click here to confirm your action" => "Paina tästä, varmistaaksesi toiminnon",
"Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) havaittu. Menetelmä suljettu.",
"Rating" => "Arvostus",
"Item Modification" => "Osan Muokkaus",
"Item" => "Osa",
"Item creation" => "Osan luonti",
"Subject" => "Otsake",
"Tracker was modified at " => "Kortiston muokkaajana ",
"View the tracker item at:" => "Näytä kortisto osa:",
"Field is not numeric" => "Kenttä ei ole numeerinen",
"text field" => "teksti kenttä",
"half column" => "puoli palstaa",
"size" => "koko",
"prepend" => "lisäalkuun",
"append" => "lisäys",
"textarea" => "tekstialue",
"checkbox" => "merkintäneliö",
"numeric field" => "numeerinen kenttä",
"drop down" => "alas veto",
"user selector" => "käyttäjä valitsin",
"group selector" => "ryhmä valitsin",
"country selector" => "maa valitsin",
"date and time" => "päivä ja aika",
"jscalendar" => "jskalenteri",
"action" => "toiminto",
"header" => "pääosa",
"category" => "luokka",
"item link" => "osan linkki",
"items list" => "osien lista",
"email" => "sähköposti",
"system" => "järjestelmä",
"attachment" => "liite",
"open" => "avaa",
"pending" => "vireillä",
"closed" => "suljettu",
"Message" => "Viesti",
"No extra information for that attached file. " => "Ei lisätietoja tälle tiedostoliitteelle. ",
"child categories" => "alaluokat",
"objects in category" => "kohteita",
"Password should be at least" => "Salasanan oltava vähintään",
"characters long" => "merkkiä pitkä",
"Password must contain both letters and numbers" => "Salasanaan käytettävä sekä kirjaimia että numeroita",
"State" => "Tila",
"Country" => "Maa",
"Displays browser client info" => "Näyttää selain asiakkaan tiedot",
"Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Laittaa linkkiankkurin sivulle. Käytetään ANAME pluginin yhteydessä, joka laittaa paikan ja nimen ankkuriin",
"linktext" => "linkinteksti",
"Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Laittaa ankkurin sivulle. Käytetään ALINK pluginin yhteydessä, joka tekee linkin ankkuriin",
"Location" => "Sijainti",
"Field" => "Kenttä",
"Language" => "Kieli",
"Start date" => "Aloitus päivä",
"Attachment" => "Liite",
"File" => "Tiedosto",
"Show description" => "Näytä kuvaus",
"No such attachment on this page" => "Ei sellaista liitettä sivulla",
"Displays an attachment or a list of them" => "Näyttää liitteen tai listan niistä",
"Avatar" => "Hahmo",
"Displays the user Avatar" => "Näyttää käyttäjän Hahmon",
"username" => "käyttäjänimi",
"Back" => "Takaisin",
"Backlinks" => "Paluulinkit",
"List all pages which link to specific pages" => "Listaa kaikki sivut jotka osoittavat kyseiselle sivuille",
"No pages links to" => "Ei linkkejä sivuille",
"One page links to" => "Yksi linkki sivulle",
"pages link to" => "linkit sivuille",
"Zone" => "Alue",
"Items" => "Osat",
"Insert theme styled box on wiki page" => "Lisää teeman mukainen laatikko sivulle",
"Category" => "Luokka",
"Insert list of items for the current/given category into wiki page" => "Lisää lista osista nykyisen/annetun luokittelun sivulle",
"Categories are disabled" => "Luokittelut poistettu",
"Display Tiki objects that have not been categorized" => "Näyttää luokittelemattomat kohteet",
"Objects" => "Kohteet",
"Insert the full category path for each category that this wiki page belongs to" => "Lisää koko luokittelupolku jokaiseen luokkaan johon tämä sivu kuuluu",
"Center" => "Keskitä",
"Centers the plugin content in the wiki page" => "Keskittää plugin sisällön sivulle",
"Chart" => "Kaavio",
"title" => "otsikko",
"Code" => "Koodi",
"Displays a snippet of code" => "Näyttää palan koodia",
"code" => "koodi",
"note: colors and ln are exclusive" => "huomaa: värit ja linja ovat valikoivia",
"Dynamic Content" => "Muuttuva sisältö",
"Cookie" => "Keksi",
"Insert copyright notices" => "Lisää copyright huomautus",
"Example" => "Esimerkki",
"and" => "ja",
"seconds" => "sekuntia",
"Insert a division block on wiki page" => "Laittaa jaottelun eston sivulle",
"Creates a definition list" => "Luo määrittelylistan",
"term" => "ehto",
"definition" => "määrittely",
"one definition per line" => "yksi määrittely per rivi",
"drawing not found" => "piirrosta ei löydy",
"Events" => "Tapahtumat",
"Desc" => "Aleneva",
"Upcoming events" => "Tulossa olevat tapahtumat",
"Label" => "Etiketti",
"Displays the data using the Tikiwiki odd/even table style" => "Näyttää tiedot käyttäen pariton/parillinen taulukko tyyliä",
"cells" => "solut",
"heads and cells separated by ~|~" => "pääosat ja solut erotellaan käyttäen ~|~",
"Title" => "Otsikko",
"sort" => "lajiteltu",
"Displays a SWF on the wiki page" => "Näyttää SWF sivulla",
"failed" => "epäonnistui",
"description" => "kuvaus",
"Value" => "Arvo",
"Displays a graphical GAUGE" => "Näyttää graafisen PALKIN",
"type" => "tyyppi",
"Group" => "Ryhmä",
"Display wiki text if user is in one of listed groups" => "Näyttää sivutekstin jos käyttäjä kuuluu johonkin listan ryhmistä",
"HTML code" => "HTML koodi",
"name" => "nimi",
"Image ID" => "Kuva ID",
"Image size" => "Kuvan koko",
"Img" => "Kuva",
"Include" => "Sisällytä",
"Start" => "Aloitus",
"Stop" => "Seis",
"Include a page" => "Sisällytä sivu",
"Insert a javascript file or/and some javascript code." => "Lisää javascript tiedosto tai/ja jotain javascript koodia.",
"javascript code" => "javascript koodi",
"Displays the text only if the language matchs" => "Näyttää tekstin vain jos kieli täsmää",
"Last Modification" => "Muokattu viimeksi",
"List Pages" => "Listaa sivut",
"Sort" => "lajittele",
"or" => "tai",
"Lists files in a directory" => "Listaa kaikki tiedostot hakemistosta",
"Filter" => "Suodin",
"could not be opened because it doesn't exist or permission was denied" => "ei voida avata, tiedostoa ei ole tai lupa avaamiseen puuttuu",
"Map" => "Kartta",
"Displays a map" => "Näyttää kartan",
"Feature disabled" => "Ominaisuus poistettu",
"Style" => "Tyyli",
"Module Name" => "Moduulin Nimi",
"Please choose a module" => "Valitse moduuli",
"to be used as argument" => "käytettäväksi perustana",
"Displays a module inlined in page" => "Näyttää modulin sivun sisällä",
"Sorry no such module" => "Ei ole sellaista moduulia",
"Font" => "Kirjasin",
"Displays the data using a monospace font" => "Näyttää tiedot käyttäen vakio levyistä kirjasinta",
"Text" => "Teksti",
"Sticky" => "Pysyvä",
"data" => "tieto",
"Object" => "Kohde",
"Days" => "Päivää",
"Displays object hit info by object and days" => "Näyttää kohteen osumatiedot kohteelle ja päivät",
"Picture" => "Kuva",
"picture not found" => "kuvaa ei löydy",
"Information" => "Tiedot",
"Provides a list of plugins on this wiki." => "Näyttää listan plugeista tällä sivustolla.",
"No version indicated" => "Ei versiota osoitettu",
"No arguments indicated" => "Ei perustetta osoitettu",
"Poll" => "äänestys",
"Displays the output of a poll, fields are indicated with numeric ids." => "Näyttää äänestyksen tulokset, kentät on merkitty numeerisella id:llä.",
"missing poll ID for plugin POLL" => "puuttuu äänestys ID POLL plugille",
"wrote:" => "kirjoitti:",
"Quote:" => "Lainaus:",
"Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Ympäröi lainattavan tekstin laatikolla, kuten [QUOTE] BBCode",
"one data per line" => "yksi tieto per rivi",
"Search" => "Etsi",
"Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Ottaa oikean ilmaisun ja muokkaa sisällön REGEX tagien väliin ja korvaa tekstin.",
"Icon" => "Kuvake",
"Date" => "Päiväys",
"Automatically creates a link to the appropriate SourceForge object" => "Luo automaattisesti linkin SourceForge kohteeseen",
"Sheet Heading" => "Taulukon Pääosa",
"TikiSheet" => "LaskentaTaulukko",
"Edit Sheet" => "Muokkaa Taulukkoa",
"List wiki pages" => "Listaa sivut",
"Display" => "Näytä",
"Last modified by" => "Viimeksi muokannut",
"Action" => "Toiminto",
"The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "SNARF plugi korvaa itsensä HTML rungolla URL:sta.  Mielivaltainen regex korvaus voidaan tehdä käyttäen regex ja regexres, viimeisintä käytetään argumenttina korvauksessa preg_replace.",
"This data is put in a CODE caption." => "Tämä tieto on pantu KOODI kapseliin.",
"Missing url parameter for SNARF plugin." => "Puuttuu url parametri SNARF plugiin.",
"Sorts the plugin content in the wiki page" => "Lajittelee plugin sisällön sivulle",
"Order" => "Järjestys",
"Split a page into rows and columns" => "Jaa sivu riveihin ja palstoihin",
"First" => "Ensimmäinen",
"Edit" => "Muokkaa",
"row1col1" => "riv1pal1",
"row1col2" => "riv1pal2",
"row2col1" => "riv2pal1",
"row2col2" => "riv2pal2",
"Run a sql query" => "Aja sql kysely",
"sql query" => "sql kysely",
"Missing db param" => "Puuttuu db parametrit",
"Displays text in subscript." => "Näyttää tekstin subscriptinä.",
"Subscribe" => "Tilaa",
"Groups" => "Ryhmät",
"Tag Name" => "Kiinnikkeen nimi",
"Displays text between an html tag" => "Näyttää tekstin html tagin sisällä",
"Thumbnail" => "Minikuva",
"Displays the thumbnail for an image" => "Näyttää kuvan minikuvan",
"Original" => "Alkuperäinen",
"Search the titles of all pages in this wiki" => "Etsi otsikoita kaikilta sivuilta tällä sivustolla",
"No pages found for title search" => "Sivuja ei löytynyt aihe haulla",
"One page found for title search" => "Yksi sivu löytyi otsikkohaulla",
"pages found for title search" => "sivua löytynyt otsikkohaulla",
"Structure ID" => "Rakenne ID",
"Public" => "Julkinen",
"Translate" => "Käännä",
"Fields" => "Kentät",
"Preview" => "Näytä",
"preview" => "näytä",
"View" => "Näytä",
"Error" => "Virhe",
"Following mandatory fields are missing" => "Seuraavat pakolliset kentät puuttuvat",
"Following fields are incorrect" => "Seuraavat kentät ovat väärin",
"Displays an input form for tracker submit" => "Näyttää kortiston syöttölomakkeen",
"You do not have permission to insert an item" => "Oikeutesi eivät riitä lisäämään osaa",
"Fields marked with a * are mandatory." => "Kentät jotka on merkitty * ovat pakollisia.",
"Filters" => "Suotimet",
"Status" => "Tila",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "Näyttää kortiston sisällön, kentät on merkitty numeerisella id:llä.",
"Template" => "Malli",
"Mode" => "Moodi",
"Error in tracker ID" => "Virhe kortisto ID:ssä",
"No field indicated" => "Ei kenttää",
"Start Date" => "Aloitus Päivä",
"End Date" => "Lopetus Päivä",
"Links to a translated content" => "Linkki käännös sisältöön",
"Flag" => "Lippu",
"Displays the number of registered users" => "Näyttää rekisteröityneiden käyttäjien määrän",
"User List" => "Käyttäjä Lista",
"users" => "käyttäjät",
"Preferences" => "Kokoonpanot",
"User Information" => "Käyttäjä Tiedot",
"Versions" => "Versiot",
"Split the text in parts visible only under some conditions" => "Jakaa tekstin osiin, jotka näytetään vain joissakin tapauksissa",
"Vote" => "Äänestä",
"Table" => "Taulukko",
"Lists ''wanted'' Wiki pages: " => "Listaa ''halutaan'' sivut: ",
"Page-Pattern" => "Sivu-Kuvio",
"Custom-Level-Regex" => "Erikois-Tason-Regex",
"^Parameters: key=>value,...\n" => "^Parametrit: key=>arvo,...\n",
"__key__ | __default__ | __comments__\n" => "__avain__ | __oletus__ | __kommentit__\n",
"empty string" => "tyhjä merkkijono",
"(refer to PHP function fnmatch() for details)\n" => "(tarkista PHP functioiden fnmatch() yksityiskohdat)\n",
"possible values: characters\n" => "mahdolliset arvot: merkit\n",
"possible values: " => "mahdolliset arvot: ",
"a valid regex-expression (PCRE)" => "hyväksytty regex-ilmaisu (PCRE)",
"non-valid custom regex" => "ei hyväksytty muokattu regex",
"ignored" => "huomioimaton",
"External Wiki" => "Ulkoinen Wiki",
"dash-WikiWord" => "viiva-WSana",
"WikiWord" => "WSana",
"not in level" => "ei tasolla",
"valid" => "hyväksytty",
"End of debug output." => "Debug tulostuksen päätös.",
"Wanted Page" => "Haluttu Sivu",
"Referenced By Page" => "Lainaus Sivulta",
"width" => "leveys",
"height" => "korkeus",
"ERROR: Either the subject or body must be non-empty" => "VIRHE: Kumpaakaan osikkoa tai tekstiä ei voi jättää tyhjäksi",
"ERROR: No valid users to send the message" => "VIRHE: Ei hyväksyttyjä jäseniä joille lähettää viesti",
"Invalid user" => "Väärä käyttäjä",
"Message sent to" => "Viesti lähetetty",
"Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Postilaatikko on täynnä. Arkistoi tai poista vanhempia viestejä ensin jos haluat lähettää lisää viestejä.",
"You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "Sinun on voitava vastaanottaa viestejä lähettääksesi niitä. Mene omiin asetuksiisi ja valitse 'Salli viestit muilta jäseniltä'",
"User %s can not receive messages, mailbox is full" => "Käyttäjä %s ei voi vastaanottaa viestejä, postilaatikko on täynnä",
"User %s can not receive messages" => "Käyttäjä %s ei voi vastaanottaa viestejä",
"Invalid user: %s" => "Väärä käyttäjä: %s",
"Message will be sent to: " => "Viesti lähetetään: ",
"Archive is full. Delete some messages from archive first." => "Arkisto on täynnä. Poista vanhempia viestejä ensin.",
"No more messages" => "Ei enempää viestejä",
"Tiki Calendar" => "Kalenteri",
"Calendar" => "Kalenteri",
"Please provide an Id" => "Anna Id",
"no object here yet" => "ei kohteita täällä vielä",
"Create/Edit" => "Luo/muokkaa",
"Quick Edit a Wiki Page" => "PikaMuutos sivuun",
"Post" => "Lähetä",
"Changes since" => "Muutokset jälkeen",
"new comments" => "uusia kommentteja",
"new posts" => "uudet postit",
"wiki pages changed" => "wiki sivuja muuttunut",
"new articles" => "uudet artikkelit",
"new FAQs" => "uudet UKK:ot",
"new blogs" => "uudet blogit",
"new blog posts" => "uudet blogi lähetykset",
"new image galleries" => "uudet kuva galleriat",
"new images" => "uudet kuvat",
"new file galleries" => "uudet tiedosto galleriat",
"new files" => "uusia tiedostoja",
"new polls" => "uudet äänestykset",
"new users" => "uusia käyttäjiä",
"new tracker items" => "uudet kortiston osat",
"The task title must have at least 3 characters" => "Tehtävä otsikon oltava vähintään 3 merkkiä",
"Invalid server key" => "Väärä palvelin avain",
"Invalid username or password" => "Väärä käyttäjänimi tai salasana",
"change password" => "muuta salasana",
"country" => "maa",
"Anti-Bot verification code" => "Anti-Bot varmistus coodi",
"Random Image" => "Satunnais Kuva",
"Enter the code you see above" => "Kirjoita alla näkyvä koodi",
"List of attached files" => "Listaus tiedostoliitteistä",
"desc" => "aleneva",
"uploaded" => "lähetetty",
"Download" => "Imurointi",
"Delete" => "Poista",
"Remove" => "Poista",
"Upload file" => "Lähetä tiedosto",
"Attach" => "Liitä",
"Attach a file to this item" => "Liitä tiedosto tähän osaan",
"Version" => "Versio",
"Attachments" => "Liitteet",
"more info" => "lisä info",
"No attachments for this item" => "Ei liitteitteitä tähän osaan",
"Fatal error" => "Vakava virhe",
"Created by" => "Luonut",
"on" => " ",
"RSS feed" => "RSS syöte",
"Edit blog" => "Muokkaa blogia",
"Monitor this Blog" => "Tarkkaile tätä blogia",
"Stop Monitoring this Blog" => "Lopeta tämän blogin tarkkailu",
"Activity=" => "Toiminto=",
"Actions" => "Toiminnot",
"Properties" => "Tarpeisto",
"No records found" => "Ei löytynyt tallennetta",
"Categorize" => "Luokittele",
"Admin Categories" => "Ylläpidä luokitteluja",
"No categories defined" => "Ei luokittelua määritelty",
"Browse Category" => "Selaa luokkaa",
"posts:" => "lähetyksiä:",
"stars" => "tähtiä",
"User Level" => "Käyttäjä taso",
"private message" => "yksityis viesti",
"Send eMail to User" => "Lähetä viesti käyttäjälle",
"user online" => "käyttäjä linjalla",
"user offline" => "käyttäjä pois linjalta",
"Reply" => "Vastaa",
"Approve" => "Hyväksy",
"Reject" => "Hylätty",
"Save to notepad" => "Tallenna muistioon",
"Monitor this Topic" => "Tarkkaile tätä aihetta",
"Stop Monitoring this Topic" => "Lopeta tämän aiheen tarkkailu",
"Moderator actions" => "Moderaattorin toiminnot",
"reported:" => "raportoitu:",
"queued:" => "jonossa:",
"Move to topic:" => "Siirrä aiheeksi:",
"Move" => "Siirrä",
"Delete Selected" => "Poista valitut",
"Unlock" => "Aukaise",
"Lock" => "Lukitse",
"Messages" => "Viestit",
"Plain" => "Tavallinen",
"Threaded" => "Ketjutettu",
"Headers Only" => "Vain Pääosat",
"Newest first" => "Uusin ensimmäiseksi",
"Oldest first" => "Vanhin ensimmäiseksi",
"Title (desc)" => "Otsikko (aleneva)",
"Title (asc)" => "Otsikko (nouseva)",
"Threshold" => "Kynnys",
"Set" => "Aseta",
"Replies" => "Vastauksia",
"below your current threshold" => "alle nykyisen kynnyksesi",
"New Reply" => "Uusi vastaus",
"Editing reply" => "Muokkaa vastausta",
"Reply to the selected post" => "Vastaa valittuihin lähetyksiin",
"Post new message" => "Lähetä uusi viesti",
"Editing comment" => "Muokkaa kommenttia",
"Comment on the selected post" => "Kommentoi valittuja lähetyksiä",
"Post new comment" => "Lähetä uusi kommentti",
"Smileys" => "Hymiöt",
"Quicktags" => "Pikatagit",
"Reply to parent post" => "Vastaa isäntä lähetykseen",
"Post new reply" => "Lähetä uusi vastaus",
"Cancel" => "Peruuta",
"Posting replies" => "Lähettää vastauksia",
"Posting comments" => "Lähetetään kommentteja",
"Use" => "Käytä",
"for links" => "linkkeihin",
"HTML tags are not allowed inside posts" => "HTML tagit eivät ole sallittuja lähetyksissä",
"Add Comment" => "Lisää kommentti",
"1 comment" => "1 kommentti",
"Comments" => "Kommentit",
"Go back" => "Takaisin",
"Return to home page" => "Palaa EtuSivulle",
"Copyrights" => "Copyright",
"Authors" => "Kirjoittajat",
"Add" => "Lisää",
"Syntax" => "Syntaksi",
"Page generation debugging log" => "Sivun luoma debugging logi",
"Features state" => "Ominaisuuksien tilanne",
"Total" => "Kaikkiaan",
"features matched" => "ominaisuuksia osui",
"Watchlist" => "Vahtilista",
"duplicate" => "kaksoiskappale",
"There are individual permissions set for this file gallery" => "Tälle gallerialle on asetettu erikoisoikeudet",
"Save" => "Tallenna",
"Gallery is visible to non-admin users?" => "Näytetäänkö galleria muille kuin ylläpijille?",
"unlimited" => "rajoittamaton",
"none" => "eimitään",
"Parent gallery" => "Isäntä galleria",
"Owner of the gallery" => "Gallerian omistaja",
"Default sort order" => "Oletus lajittelu järjestys",
"descending" => "laskeva",
"ascending" => "nouseva",
"Max description display size" => "Suurin kuvauksen näyttökoko",
"Max Rows per page" => "Suurin rivi määrä per sivu",
"Listing configuration" => "Kokoonpano listaus",
"Please login" => "Ole Hyvä ja kirjaudu",
"Perhaps you were looking for:" => "Ehkä etsit:",
"There are no wiki pages similar to '{\$page}'" => "Ei ole samanlaisia sivuja kuin '{\$page}'",
"Create this page" => "Luo tämä sivu",
"(page will be orphaned)" => "(sivu muuttuu yksittäiseksi)",
"Close Window" => "Sulje Ikkuna",
"Active Perms" => "Aktiiviset oikeudet",
"Perms" => "Oikeud",
"Replace" => "Korvaa",
"List" => "Lista",
"Browse" => "Selaa",
"Name-filename" => "Nimi-tiedostonimi",
"Filename only" => "Vain tiedostonimi",
"Close" => "Sulje",
"Exact&nbsp;match" => "Tarkka&nbsp;täsmäys",
"Number of displayed rows" => "Näytettävien rivien määrä",
"Go" => "Mene",
"in:" => " :",
"RSS Blogs" => "RSS Blogit",
"RSS Articles" => "RSS Artikkelit",
"RSS Image Galleries" => "RSS Kuva Galleriat",
"RSS File Galleries" => "RSS Tiedosto Galleriat",
"RSS Forums" => "RSS Foorumit",
"RSS Maps" => "RSS Kartat",
"RSS Directories" => "RSS Hakemistot",
"Perform action with checked:" => "Suorita toiminnot valituilla:",
"Move Selected Files" => "Siirrä valitut tiedostot",
"Assign Permissions" => "Anna Oikeudet",
"Move to" => "Siirrä",
"Assign" => "Liitä",
"Filename" => "Tiedostonimi",
"Hi {\$mail_user} has sent you this link:" => "Hi {\$mail_user} lähetti sinulle linkin:",
"Blog post:" => "Blogi lähetys:",
"at:" => " :",
"Somebody or you tried to subscribe this email address at our site:" => "Joku tai sinä yrität tilata tällä sähköpostiosoitteella:",
"To the newsletter:" => "uutislehden:",
"Description:" => "Kuvaus:",
"In order to confirm your subscription you must access the following URL:" => "Varmistaaksesi tilauksesi sinun on käytettävä tätä URL:ia:",
"A new message was posted to forum" => "Uusi viesti oli lähetetty foorumille",
"New topic:" => "Uusi aihe:",
"Topic:" => "Aihe:",
"You sent a request with the subject:" => "Lähetit pyynnön otsikolla:",
"Use the subject to indicate the operation to apply:" => "Käytä otsikkoa osoittaaksesi lisättävän käsittelyn:",
"GET:WikiName to get a wiki page" => "HAE:SivuNimi saadaksesi sivun",
"PUT:WikiName to update/create a wiki page (use the body for the page data)" => "VIE:SivuNimi päivittääksesi/luodaksesi (käytä runkona sivun tietoja)",
"APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "LISÄÄ:SivuNimi lisätäksesi tietoja sivun loppuun (käytä runkona sivun tietoja lisäykseen)",
"PREPEND:WikiName to append the data at the top" => "LISALK:SivuNimi lisätäksesi tietoja sivun alkuun",
"Tiki mail-in instructions" => "Tiki postit sisään ohjeet",
"Tiki mail-in auto-reply." => "Sivuston-sisään autom-vastaus.",
"Page not found:" => "Sivua ei löydy:",
"A new message was posted to you at {\$mail_machine}" => "Uusi viesti on lähetetty sinulle {\$mail_machine}",
"From" => "Keneltä",
"New message arrived from %s" => "Uuden viestin lähettänyt %s",
"Your account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Rekisteröinti pyyntösi {\$mail_site} käsitelty ylläpidon toimesta ja jäsenyytesi on aktivoitu.",
"To login with your username and password, please follow this link:" => "Kirjautuaksesi käyttäjänimeä ja salasanaa käyttäen, seuraa tätä linkkiä:",
"Enjoy the site!" => "Nauti sivustosta!",
"User Account Activated" => "Käyttäjä Tili Aktivoitu",
"has requested an account on" => "on pyytänyt jäsenyyttä",
"To validate that account, please follow the link:" => "Varmistaaksesi jäsenyys, seuraa tätä linkkiä:",
"best regards" => "parhain terveisin",
"your Tikiwiki" => "sinun sivustosi",
"User Registration Request" => "Käyttäjä Rekisteröinti Pyyntö",
"Go to your friendship network to accept or refuse this request" => "Mene ystävä verkostoosi ja hyväksy tai hylkää tämä pyyntö",
"You're invited to join my network of friends!" => "Sinut on kutsuttu liittymään ystävyysverkostooni!",
"The user" => "Käyttäjä",
"registered at your site" => "rekisteröity sinun sivustollesi",
"New user registration" => "Uuden käyttäjän rekisteröinti",
"This email address has been removed to the list of subscriptors of:" => "Tämä sähköpostiosoite on poistettu seuraavista tilaajien listalta:",
"Newsletter:" => "Uutislehti:",
"Bye bye from %s at %s" => "Terveisin %s -> %s",
"You can unsubscribe from this newsletter following this link" => "Voit peruuttaa uutislehden tilauksen painamalla tätä linkkiä",
"Welcome to our newsletter!" => "Tervetuloa Uutislehteemme!",
"This email address has been added to the list of subscriptors of:" => "Tämä sähköpostiosoite on liitetty tilaajien listalle:",
"You can always cancel your subscription using:" => "Voit peruuttaa tilauksen aina käyttäen:",
"Welcome to %s at %s" => "Tervetuloa %s , %s",
"Email notification" => "Sähköposti ilmoitus",
"Someone coming from IP Address" => "Joku osoitteesta IP Osoite",
"requested a reminder of the password for your account" => "rekisteröinnistäsi on pyydetty salasana muistutusta",
"requested password reset for your account" => "rekisteröintisi salasana muutettu",
"Since this is your registered email address we inform that the password for this account is" => "Tämä on rekisteröity sähköpostiosoitteesi ja salasanasi on",
"Important: Username & password are CaSe SenSitiVe" => "Tärkeää: Käyttäjänimi & salasana ovat Tarkkoja oikeinkirjoituksesta",
"Important: The old password remains active if you don't click the link above." => "Tärkeää: Vanha salasana pysyy aktiivisena jos et seuraa alla olevaa linkkiä.",
"Your account information for %s" => " %s sinun tilitietosi ovat",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Uuden artkkelin lähettäjänä {\$mail_user}   {\$mail_site}   {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "Voit muokata ehdotuksia seuraamalla tätä linkkiä:",
"Title:" => "Otsikko:",
"Heading:" => "Pääosa:",
"Body:" => "Runko:",
"New article submitted at %s" => "Uutta artikkelia ehdottanut %s",
"Tracker was modified at" => "Koristoa muokattu",
"User:" => "Käyttäjä:",
"You or someone registered this email address at" => "sinä tai joku muu on rekisteröitynyt tällä sähköpostiosoitteella",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Jos haluat olla rekisteröitynyt käyttäjä tällä sivustolla sinun on seurattava tätä linkkiä kirjautuaksesi ensimmäisen kerran:",
"Your registration confirmation" => "Sinun tietosi rekisteröintiin",
"You will receive an email with information to login for the first time into this site" => "Saat kohta sähköpostia, jossa on linkki ensimmäistä kirjautumista varten tälle sivustolle",
"Your account request has been stored and will be activated by the admin as soon as possible." => "Rekisteröinti pyyntösi on tallennettu ja ylläpito käsittelee ja aktivoi sen mahdollisimman pian.",
"View the article at:" => "Näytä artikkeli:",
"If you don't want to receive these notifications follow this link:" => "Jos et halua vastaanotta näitä ilmoituksia seuraa tätä linnkiä:",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "Uudet blogi lähetykset: {\$mail_title}, \"{\$mail_post_title}\",   {\$mail_user|username}   {\$mail_date|tiki_short_datetime}",
"View the blog at:" => "Näytä blogia:",
"New blog post at %s" => "Uuden blokikirjoituksen lähettänyt %s",
"changed" => "muutettu",
"created" => "luotu",
"Removed by" => "Poistanut",
"New" => "Uusi",
"File Gallery %s changed" => "Tiedosto Galleria %s muuttunut",
"A file was removed from the file gallery" => "Tiedosto on poistettu tiedosto galleriasta",
"File Name" => "Tiedosto Nimi",
"A new file was posted to file gallery" => "Uusi tiedosto lähetetty tiedosto galleriaan",
"Posted by" => "Lähettänyt",
"File Description" => "Tiedoston Kuvaus",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Karttaa {\$mail_page} on muuttanut {\$mail_user}  {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "Voit katsoa päivitettyä karttaa seuraamalla tätä linkkiä:",
"You can edit the map following this link:" => "Voit muokata karttaa seuraamalla tätä linkkiä:",
"The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Sivun {\$mail_page} on luonut {\$mail_user}: {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Sivua {\$mail_page} on muuttanut {\$mail_user}  {\$mail_date|tiki_short_datetime}",
"Comment:" => "Kommentti:",
"You can view the page by following this link:" => "Voit katsoa sivua seuraamalla tätä linkkiä:",
"You can view a diff back to the previous version by following this link:" => "Voit katsoa edellisiä versioita seuraamalla tätä linkkiä:",
"The changes in this version follow below, followed after by the current full page text." => "Tämän version muutokset seuraavat alla, nykyisen koko sivun tekstin jälkeen.",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Riviä: {\$oldd} muutettu +Riviä: {\$newd}",
"The new page content follows below." => "Uuden sivun sisältö seuraa alla.",
"The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Sivua {\$mail_page} on kommentoinut {\$mail_user}  {\$mail_date|tiki_short_datetime}",
"Wiki page renamed" => "Sivu uudelleen nimetty",
"Old name" => "Vanha nimi",
"New name" => "Uusi nimi",
"click on the map to zoom or pan, do not drag" => "klikkaa karttaa zoomataksesi tai pan, älä tartu karttaan",
"Scale" => "Muunnos",
"Query" => "Kysely",
"Pan" => "Panoroi",
"Redraw" => "Päivitä",
"select zoom/pan/query and image size" => "valitse zoom/pan/kysely ja kuvan koko",
"View the Map Only" => "Näytä Vain Kartta",
"Reset Map" => "Palauta Kartta",
"Click on the map or click redraw" => "Klikkaa karttaa tai klikkaa päivittääksesi",
"Last modification date" => "Viimeinen muokkaus päivä",
"Overview" => "Yleiskuva",
"Legend" => "Seloste",
"Layer Manager" => "Tason Hallinta",
"Layer" => "Taso",
"On" => " ",
"Download Layer" => "Imuroi Taso",
"This layer has been set by the maps administrator to not be downloadable" => "Tämän tason on asettanut kartan ylläpitäjä eikä sitä voi imuroida",
"you have requested to download the layer:" => "olet pyytänyt tason imurointia:",
"Here are the files to download, do not forget to rename them:" => "Tässä ovat tiedostot imurointia varten, älä unohda nimetä niitä:",
"Mapfiles" => "Karttatiedostot",
"Mapfile" => "Karttatiedosto",
"Available mapfiles" => "Saatavat karttatiedostot",
"hits last 7 days" => "osumia viimeisenä 7 päivänä",
"monitor this map" => "tarkkaile tätä karttaa",
"Stop Monitoring this Map" => "Lopeta tämän kartan tarkkailu",
"Create a new mapfile" => "Luo uusi karttatiedosto",
"Create" => "Luo",
"Mapfile listing" => "Karttatiedoston listaus",
"Reload" => "Lataa uudelleen",
"History" => "Historia",
"You can view this map in your browser using" => "Voit katsoa kartaa selaimelle käyttäen ",
"Zoom out x2" => "Suurenna x2",
"Zoom in x2" => "Pienennä x2",
"Mapfile History" => "Karttatiedoston Historia",
"of" => " ",
"Compare" => "Vertaa",
"Comparing version {\$old.version} with version {\$new.version}" => "Verrataan versiota {\$old.version} versioon {\$new.version}",
"Version:" => "Versio:",
"Current" => "Nykyinen",
"Versions are identical" => "Versiot ovat identtiset",
"Legend:" => "Seloste:",
"v=view" => "n=näyttö",
"c=compare" => "v=vertaa",
"d=diff" => "e=erot",
"Full side-by-side diff" => "Kaikki erot rinnakkain",
"Unified diff" => "Yhdistetyt erot",
"Side-by-side view" => "Rinnakkaisnäyttö",
"User" => "Käyttäjä",
"Diff" => "Erot",
"Older Version" => "Vanhempi versio",
"Directories" => "Hakemistot",
"back to" => "takaisin",
"Upload From Disk:" => "Lähetä Kovalevyltä:",
"Upload Files" => "Lähetä Tiedostot",
"Bytes maximum" => "Suurin koko",
"Create Directory:" => "Luo Hakemisto:",
"index file (.shp):" => "index tiedosto (.shp):",
"files to index (regexp):" => "tiedostot index:iin (regexp):",
"Message Archive" => "Viesti Arkisto",
"messages" => "viestejä",
"Archive is full!" => "Arkisto on täynnä!",
"Unread" => "Lukemattomat",
"Flagged" => "Merkityt",
"Unflagged" => "Merkitsemättömät",
"Containing" => "Sisältäen",
"Sender" => "lähettäjä",
"No messages to display" => "Ei näytettäviä viestejä",
"Broadcast message" => "Lähetys viesti",
"OK" => "Ok",
"All users" => "Kaikki käyttäjät",
"Lowest" => "Alin",
"Low" => "Alhainen",
"Normal" => "Normaali",
"High" => "Korkea",
"Very High" => ">Korkein",
"Send" => "Lähetä",
"Compose message" => "Muodosta viesti",
"Invalid" => "Toimimaton",
"To" => "Kenelle",
"CC" => "Kopio",
"BCC" => "Varmuuskopio",
"No messages to download" => "Ei imuroitavia viestejä",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Postilaatikko on täynnä! Poista tai arkistoi viestejä jotta voit vastaanottaa lisää.",
"Find replied message" => "etsi vastatut viestit",
"Archive" => "Arkisto",
"Mark as read" => "Merkitse luetuksi",
"Mark as unread" => "Merkitse lukemattomaksi",
"Mark as flagged" => "Merkitse merkityksi",
"Mark as unflagged" => "Merkitse merkitsemättömäksi",
"Mark" => "merkitse",
"Mailbox" => "Postilaatikko",
"Compose" => "Muodosta",
"Broadcast" => "Lähetys",
"Sent" => "Lähtenyt",
"Auto-archive age for read messages:" => "Auto-arkistoi iän mukaan luetut viestit:",
"Read message" => "Lue viesti",
"Return to mailbox" => "Palaa postilaatikkoon",
"replyall" => "vastaakaikille",
"Unflag" => "Merkitsemätön",
"Flag this message" => "Merkitse tämä viesti",
"Cc" => "Kopio",
"Return to archive" => "Palaa arkistoon",
"Return to outbox" => "Palaa lähteneisiin",
"Sent Messages" => "Lähteneet Viestit",
"Replied" => "Vastatut",
"Not replied" => "Vastaamattomat",
"move to archive" => "siirrä arkistoon",
"receiver" => "vastaanottaja",
"'name' parameter for tikimodule missed" => "'nimi' parametri puuttuvalle moduulille",
"Move module up" => "Siirrä moduuli ylöspäin",
"Up" => "Ylös",
"Move module down" => "Siirrä moduuli alaspäin",
"Down" => "Alas",
"Move module to opposite side" => "Siirrä moduuli toiselle puolelle",
"opp side" => "vastakkainen puoli",
"Unassign this module" => "Poista tämä moduuli",
"Are you sure you want to unassign this module?" => "Oletko varma, että haluat poistaa modulin?",
"Admin Menu" => "Ylläpito Valikko",
"Live Support" => "Elävä Tuki",
"Banning" => "Esto",
"Users" => "Käyttäjät",
"Cache" => "Puskuri",
"Modules" => "Moduulit",
"Links" => "Linkit",
"Hotwords" => "Kuumasanat",
"RSS Modules" => "RSS moduulit",
"Menus" => "Valikot",
"Polls" => "Äänestykset",
"Mail Notifications" => "Posti ilmoitukset",
"Search Stats" => "Etsintä Tilastot",
"QuickTags" => "PikaLisät",
"Chat" => "Juttele",
"Categories" => "Luokittelut",
"Banners" => "Bannerit",
"Edit Templates" => "Muokkaa malleja",
"Cookies" => "Keksit",
"Mail-in" => "Posti-sisään",
"Content Templates" => "Sisältö Mallit",
"HTML Pages" => "HTML Sivut",
"Shoutbox" => "Pikaviestin",
"Shoutbox Words" => "Pikaviestin Sanat",
"Referer Stats" => "Suositus Tilastot",
"Import PHPWiki Dump" => "Tuo PHPWiki Dumppi",
"Admin dsn" => "Ylläpidä dsn",
"Security Admin" => "Turvallisuus Ylläpito",
"Display type unknown, you have to enter the banner type" => "Tuntematon näyttö tyyppi, anna bannerin tyyppi",
"You forgot your Google ad_client number !" => "Olet unohtanut Google ad_client numeron !",
"Tikiwiki Assistant" => "Tikiwiki Avustaja",
"Thank you for installing Tikiwiki" => "Kiitos kun installoit Tikiwikin",
"Select" => "Valitse",
"Admin" => "Ylläpitäjä",
"Admin Modules" => "Ylläpidä Moduuleja",
"Admin Menus" => "Ylläpidä Valikoita",
"login" => "kirjaus",
"Recently visited pages" => "Äskettäin vieraillut sivut",
"January" => "Tammikuu",
"February" => "Helmikuu",
"March" => "Maaliskuu",
"April" => "Huhtikuu",
"May" => "Toukokuu",
"June" => "Kesäkuu",
"July" => "Heinäkuu",
"August" => "Elokuu",
"September" => "Syyskuu",
"October" => "Lokakuu",
"November" => "Marraskuu",
"December" => "Joulukuu",
"Tuesday" => "Tiistai",
"Wednesday" => "Keskiviikko",
"Thursday" => "Torstai",
"Friday" => "Perjantai",
"Today" => "Tänään",
"Received objects" => "Vastaanotetut kohteet",
"Pages:" => "Sivut:",
"Last `\$module_rows` Sites" => "Viimeksi `\$module_rows` Sivustoja",
"Last Sites" => "Viimeiset Sivustot",
"Directory Stats" => "Hakemisto Tilastot",
"Sites" => "Sivustot",
"Sites to validate" => "Vahvistettavat sivustot",
"Searches" => "Etsinnät",
"Visited links" => "Vieraillut linkit",
"Top \$module_rows Sites" => "Top \$module_rows Sivustot",
"Top Sites" => "Top Sivustot",
"Featured links" => "Ominaisuus linkit",
"Top `\$module_rows` topics" => "Top `\$module_rows` aiheet",
"Top topics" => "Top aiheet",
"Last `\$module_rows` forum posts" => "Viimeiset `\$module_rows` foorumin lähetykset",
"Last forum posts" => "Viime foorumin lähetykset",
"Last `\$module_rows` forum topics" => "Viimeiset `\$module_rows` foorumin aiheet",
"Last forum topics" => "Viimeiset foorumin aiheet",
"Most commented forums" => "Eniten kommentoidut foorumit",
"Most read topics" => "Luetuimmat aiheet",
"Most visited forums" => "Luetuimmat foorumit",
"Google Search" => "Google Etsintä",
"Last `\$module_rows` actions" => "Viimeiset `\$module_rows` toiminnot",
"Last actions" => "Viime toiminnot",
"Last `\$module_rows` articles" => "Viimeiset `\$module_rows` artikkelit",
"Last articles" => "Viimeiset artikkelit",
"Last `\$module_rows` blog posts" => "Viimeiset `\$module_rows` blogi lähetykset",
"Last blog posts" => "Viimeiset blogi lähetykset",
"Last" => "Viimeksi",
"Last `\$module_rows` Created blogs" => "Viimeiset `\$module_rows` Luodut blogit",
"Last Created blogs" => "Viimeiset Luodut blogit",
"Last `\$module_rows` Created FAQs" => "Viimeiset `\$module_rows` Luodut UKK:t",
"Last Created FAQs" => "Viimeksi Luodut UKK:t",
"Last `\$module_rows` Created Quizzes" => "Viimeksi `\$module_rows` Luodut Visailut",
"Last Created Quizzes" => "Viimeksi Luodut Visailut",
"Last `\$module_rows` modified file galleries" => "Viimeksi `\$module_rows` muokatut tiedosto galleriat",
"Last modified file galleries" => "Viimeksi muokatut tiedosto galleriat",
"Last `\$module_rows` Files" => "Viimeiset `\$module_rows` Tiedostot",
"Last Files" => "Viimeiset Tiedostot",
"Last `\$module_rows` galleries" => "Viimeiset `\$module_rows` galleriat",
"Last galleries" => "Viimeiset galleriat",
"Last `\$module_rows` Images" => "Viimeiset `\$module_rows` Kuvat",
"Last Images" => "Viime Kuvat",
"Last `\$module_rows` modified events" => "Viimeiset `\$module_rows` muutetut tapahtumat",
"Last modifed events" => "Viime muutetut tapahtumat",
"Last `\$module_rows` changes" => "Viimeiset `\$module_rows` muutokset",
"Last changes" => "Viimeiset muutokset",
"Last `\$module_rows` Modified Items" => "Viimeksi `\$module_rows` Muokatut Osat",
"Last Modified Items" => "Viimeksi Muokatut Osat",
"Last `\$module_rows` Modified blogs" => "Viimeksi `\$module_rows` Muokatut blogit",
"Last Modified blogs" => "Viimeksi muokatut blogit",
"Last `\$module_rows` submissions" => "Viimeiset `\$module_rows` ehdotukset",
"Last submissions" => "Viimeiset ehdotukset",
"Last `\$module_rows` Modified Comments" => "Viimeiset `\$module_rows` Muutetut Kommentit",
"Last Modified Comments" => "Viimeksi Muutetut Kommentit",
"Last `\$module_rows` Items" => "Viimeiset `\$module_rows` Osat",
"Last Items" => "Viimeiset Osat",
"Last `\$module_rows` visitors" => "Viimeiset `\$module_rows` vierailijat",
"Last Visitors" => "Viime vierailijat",
"Register" => "Rekisteröity",
"Live support" => "Elävä tuki",
"Open operator console" => "Avaa operaattorin konsoli",
"Online users" => "Käyttäjät linjalla",
"We have" => "Meillä on",
"online users" => "linjalla olevaa käyttäjää",
"Logout" => "Poistu",
"Switch" => "Kytkin",
"Login through CAS" => "Kirjautuminen CAS:in kautta",
"Login as admin" => "Kirjautunut ylläpitäjänä",
"Email" => "Sähköposti",
"eMail" => "Sähköposti",
"Password" => "Salasana",
"Remember me" => "Muista minut",
"week" => "viikko",
"month" => "kuukausi",
"year" => "vuosi",
"Click here to register" => "Paina tästä rekisteröityäksesi",
"Click here if you've forgotten your password" => "Paina tästä jos olet unohtanut salasanasi",
"I forgot my password" => "Unohdin salasanan",
"Click here to login using the default security protocol" => "Paina tästä kirjautuaksesi oletuksena olevaa turvallisuus protokollaa käyttäen",
"Standard" => "Standardi",
"Click here to login using a secure protocol" => "Paina tästä kirjautuaksesi käyttäen salattua protokollaa",
"Secure" => "Salattu",
"Stay in ssl Mode" => "Pysy ssl moodissa",
"local account" => "paikallinen tili",
"Menu" => "Valikko",
"You have" => "Sinulla on",
"New Messages" => "Uusia viestejä",
"New Message" => "Uusi viesti",
"You have 0 new messages" => "Sinulla on 0 uutta viestiä",
"Waiting Submissions" => "Odottaa Ehdotuksia",
"submissions waiting to be examined" => "ehdotukset odottavat käsittelyä",
"Old articles" => "Vanhat artikkelit",
"Send a message to" => "Lähetä viesti",
"Send a message" => "Lähetä viesti",
"Random Images" => "Satunnais Kuvat",
"Random Pages" => "Satunnais Sivut",
"Register as a new user" => "Rekisteröi uutena käyttäjänä",
"Your email could not be validated; make sure you email is correct and click register below." => "Sähköpostiosoitettasi ei voida varmistaa; tarkista että sähköpostiosoite on oikein ja paina alhaalta rekisteröi.",
"Your registration code:" => "Rekisteröinti koodisi:",
"Username" => "Käyttäjänimi",
"Passcode to register (not your user password)" => "Passikoodi rekisteröintiin (ei ole salasana)",
"Registration code" => "Rekisteröinti koodi",
"Repeat password" => "Toista salasana",
"Generate a password" => "Luo salasana",
"Blogs RSS" => "Blogit RSS",
"Articles RSS" => "Artikkelien RSS",
"Image Galleries RSS" => "Kuva Gallerioiden RSS",
"Image Galleries" => "Kuva Galleriat",
"File Galleries RSS" => "Tiedosto Gallerioiden RSS",
"File Galleries" => "Tiedosto Galleriat",
"Forums RSS" => "Foorumien RSS",
"Maps RSS" => "Karttojen RSS",
"Maps" => "Kartat",
"Entire Site" => "Koko Sivusto",
"Wiki Pages" => "Wiki Sivut",
"Image Gals" => "Kuva Gal",
"Images" => "Kuvat",
"Blog Posts" => "Blogi Lähetykset",
"Search Wiki PageName" => "Etsi Wiki SivuNimeä",
"Read More" => "Lue Lisää",
"Since your last visit" => "Viime käyntisi jälkeen",
"Since your last visit on" => "Sen jälkeen kun viimeksi olet käynyt",
"New Images" => "Uudet kuvat",
"Wiki Pages Changed" => "Wiki sivuja muuttunut",
"New Files" => "Uusia tiedostoja",
"New Comments" => "Uusia kommentteja",
"New Tracker Items" => "Uudet kortiston osat",
"New Users" => "Uusia käyttäjiä",
"click to edit" => "paina muokataksesi",
"Theme" => "Teema",
"Most Active blogs" => "Aktiivisimmat blogit",
"Top `\$module_rows` articles" => "Top `\$module_rows` artikkelit",
"Top articles" => "Top artikkelit",
"Top `\$module_rows` File Galleries" => "Top `\$module_rows` Tiedosto Galleriat",
"Top File Galleries" => "Top Tiedosto Galleriat",
"Top `\$module_rows` files" => "Top `\$module_rows` tiedostot",
"Top files" => "Top tiedostot",
"Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Foorumin Lähettäjät",
"Top Forum Posters" => "Top Foorumin Lähettäjät",
"Top `\$module_rows` games" => "Top `\$module_rows` pelit",
"Top games" => "Top pelit",
"Top `\$module_rows` galleries" => "Top `\$module_rows` galleriat",
"Top galleries" => "Top galleriat",
"Top `\$module_rows` Images" => "Top `\$module_rows` Kuvat",
"Top Images" => "Top Kuvat",
"Top `\$module_rows` Objects" => "Top `\$module_rows` Kohteet",
"Top Objects" => "Top Kohteet",
"Top `\$module_rows` Pages" => "Top `\$module_rows` Sivut",
"Top Pages" => "Top Sivut",
"Top `\$module_rows` Quizzes" => "Top `\$module_rows` Visailut",
"Top Quizzes" => "Top Visailut",
"Most `\$module_rows` visited blogs" => "Most `\$module_rows` vieraillut blogit",
"Top `\$module_rows` Visited FAQs" => "Top `\$module_rows` Vieraillut UKK:t",
"Top Visited FAQs" => "Top Vieraillut UKK:t",
"view" => "näytä",
"click to view" => "paina katsoaksesi",
"My blogs" => "Omat blogit",
"Bookmarks" => "Kirjanmerkit",
"My galleries" => "Omat galleriat",
"My Pages" => "Omat Sivut",
"User tasks" => "Käyttäjä tehtävät",
"Done" => "tehty",
"Del" => "Pois",
"Public tasks" => "Julkisia tehtäviä",
"select" => "valitse",
"User informations" => "Käyttäjän tiedot",
"Group informations" => "Ryhmän tiedot",
"Top users" => "Top käyttäjät",
"Whats related" => "Mikä on liittyvää",
"online user" => "käyttäjä linjalla",
"on host" => "järjestäjänä",
"Last `\$module_rows` wiki comments" => "Viimeiset `\$module_rows` wiki kommentit",
"Last wiki comments" => "Viimeiset wiki kommentit",
"on page" => "sivulle",
"Real Name" => "Oikea Nimi",
"vote" => "äänestä",
"Send Newsletter" => "Lähetä uutiskirje",
"Structures:" => "Rakenteet:",
"show structures" => "näytä rakenteet",
"hide structures" => "piilota rakenteet",
"Manage structures" => "Hallitse rakenteita",
"Location : " => "Sijainti : ",
"Find:" => "Löytyi:",
"pages" => "sivuja",
"To edit the copyright notices" => "Muuttaaksesi copyright huomautusta",
"Click Here" => "Paina tästä",
"The content on this page is licensed under the terms of the" => "Tämän sivun sisältö on lisenssoitu seuraavien ehtojen mukaan",
"Print" => "Tulosta",
"Email This Post" => "sähköpostita tämä lähetys",
"Permalink" => "Peruslinkki",
"comment" => "kommentti",
"comments" => "kommenttia",
"First page" => "Ensimmäinen sivu",
"Previous page" => "Edellinen sivu",
"page" => "sivu",
"Next page" => "Seuraava sivu",
"Last page" => "Viimeinen sivu",
"referenced by" => "lainattu",
"references" => "viittaukset",
"View Comments" => "Näytä kommentit",
"Trackback pings" => "Viittaustoiminnon pingit",
"Blog name" => "Blogin nimi",
"Enlarge area height" => "Suurenna alueen korkeutta",
"Reduce area height" => "Pienennä alueen korkeutta",
"Calendar View" => "Kalenteri näyttö",
"List View" => "Listaus näyttö",
"Tools Calendars" => "Työkalu Kalenterit",
"Check / Uncheck All" => "Merkitse / poista merkintä kaikista",
"Refresh" => "Päivitä",
"Tip" => "Vihje",
"Cancel Edit" => "Peruuta muutos",
"Change preferences" => "Muuta asetuksia",
"Site Ads and Banners" => "Sivuston Mainokset ja Bannerit",
"Content" => "Sisältö",
"Activate" => "Aktivoi",
"Publish" => "Julkaise",
"General" => "Yleiset",
"Features" => "Ominaisuudet",
"Module" => "Moduuli",
"Meta Tags" => "Meta Tagit",
"Community" => "Yhteisö",
"User files" => "Käyttäjä tiedostot",
"Webmail" => "Verkkoposti",
"Wysiwyg editor" => "Wysiwyg muokkain",
"To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "Lisätäksesi/poistaaksesi blogeja, mene \"Luo/Muokkaa blogia\" siellä \"Blogit\" ohjelma valikossa, tai",
"General Settings" => "Yleiset Asetukset",
"Home Blog (main blog)" => "Koti Blogi (pää blogi)",
"Rankings" => "Arvostukset",
"Not Installed" => "Ei Asennettu",
"Points" => "Pisteet",
"Creation date" => "Luonti päivä",
"Last modified" => "Viimeksi muokattu",
"To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "Lisätäksesi/poistaaksesi kalentereita, katso \"Ylläpito\" \"Kalenteri\" ohjelmavalikosta, tai",
"Change settings" => "Muuta asetuksia",
"Permissions" => "Oikeudet",
"Ignore category viewing restrictions" => "Älä huomio luokittelunäytön rajoituksia",
"Look under \"Articles\" on the application menu for links to" => "Katso \"Artikkelit\" ohjelma valikon linkit",
"Topic" => "Aihe",
"Submissions" => "Ehdotukset",
"Import CSV file" => "Tuo CSV tiedosto",
"Batch upload (CSV file)" => "Joukko lähetys (CSV tiedosto)",
"Import" => "Tuo",
"Visible" => "Näkyvä",
"avatar" => "hahmo",
"Number of friends" => "Ystävien lukumäärä",
"E-mail" => "Sähköposti",
"Last login" => "Viimeksi kirjautunut",
"Distance" => "Etäisyys",
"default" => "oletus",
"Number of visited pages to remember" => "Muistettavien sivujen määrä",
"Displayed time zone" => "Näytä aika vyöhyke",
"User information" => "Käyttäjä tiedot",
"Private" => "Yksityinen",
"public" => "julkinen",
"Use double-click to edit pages" => "Käytä kaksoisklikkausta muokataksesi",
"Show user's info on mouseover" => "Näyttää käyttäjän tiedot kun hiiri on päällä",
"Tasks per page" => "Tehtäviä per sivu",
"Messages per page" => "Viestejä per sivu",
"Allow messages from other users" => "Salli viestit muilta käyttäjiltä",
"Send me an email for messages with priority equal or greater than" => "Lähetä minulle sähköpostia viesteistä joiden ensisijaisuus on sama tai suurempi kuin",
"Auto-archive read messages after x days" => "Auto-arkistoi luetut viestit x päivän jälkeen",
"never" => "ei koskaan",
"My Tiki" => "OmatSivut",
"My pages" => "Omat sivut",
"My messages" => "Omat viestit",
"My tasks" => "Omat tehtävät",
"My items" => "Omat osat",
"My workflow" => "Oma työvuo",
"To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "Muokataksesi hakemistoasi, etsi \"Ylläpidä hakemistoja\" \"Hakemiston\" alta ohjelmisto valikosta, tai",
"Number of columns per page when listing categories" => "Palstojen määrä kun listataan luokkia",
"Links per page" => "Linkkiä per sivu",
"Validate URLs" => "Tarkista URL:it",
"enable cool sites" => "valitse siistit sivustot",
"Method to open directory links" => "Menetelmä avataksesi hakemisto linkkejä",
"New Window" => "Uusi ikkuna",
"To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "Lisätäksesi/poistaaksesi UKK:siä, katso \"Ylläpidä UKK\" \"UKK:on\" alta ohjelmisto valikosta, tai",
"Default number of comments per page" => "Oletus määrä kommentteja per sivu",
"Comments default ordering" => "Kommenttien oletus järjestys",
"Newsletters" => "Uutiskirje",
"Multilingual" => "Monikielinen",
"Surveys" => "Tutkimukset",
"Featured Help" => "Ominaisuus Apu",
"Live support system" => "Elävä tuki systeemi",
"Contact Us" => "Ota Yhteyttä",
"JsCalendar" => "JsKalenteri",
"PHPLayers" => "PHPTasot",
"PhpLayers Dynamic menus" => "PhpTasojen Muuttuvat valikot",
"Spreadsheet" => "Laskentataulukko",
"Tiki Sheet" => "Laskenta Taulukko",
"Drawings" => "Piirrokset",
"Friendship Network" => "Ystävä Verkosto",
"Games" => "Pelit",
"Administration Features" => "Ylläpidon Ominaisuudet",
"Banning System" => "Esto Järjestelmä",
"Banning system" => "Esto järjestelmä",
"Stats" => "Tilastot",
"Redirect On Error" => "Uudelleen suuntaa virheet",
"Communications (send/receive objects)" => "Yhteistoiminta (lähetä/vastaanota kohteita)",
"Custom Home" => "Muunneltu Koti",
"User Features" => "Käyttäjä Ominaisuudet",
"Mini Calendar" => "Mini Kalenteri",
"User Preferences Screen" => "Käyttäjän Asetusnäyttö",
"User Notepad" => "Käyttäjän Muistio",
"User Bookmarks" => "Käyttäjän Kirjanmerkit",
"User Watches" => "Käyttäjän Vahdit",
"User Watches Translations" => "Käyttäjä Vahtien Käännökset",
"User Menu" => "Käyttäjän Valikko",
"User Tasks" => "Käyttäjän Tehtävät",
"User Messages" => "Käyttäjän Viestit",
"User Files" => "Käyttäjän Tiedostot",
"Newsreader" => "Uutislukija",
"Integrator" => "Yhdistäjä",
"Workflow" => "Työvuo",
"Workflow engine" => "Työvuo moottori",
"If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "Jos valitset tallennuspaikaksi hakemiston sinun on oltava varma ettei käyttäjät pääse suoraan siihen hakemistoon.",
"You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "Sinulla on kaksi vaihtoehtoa tähän:<br /><ul><li>Käytä hakemistoa joka on sivuston ulkopuolella, varmista, että php scripti voi lukea ja kirjoittaa siihen hakemistoon</li><li>Käytä hakemistoa sivuston sisäpuolella ja käytä .htaccess tiedostoa sulkemaan ulkopuoliset pois</li></ul>",
"To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "Muokatessasi hakemisto polkua käytä UNIX polkuja esimerkki tiedostoissa/ tai c:/foo/tiedostot tai /www/tiedostot/",
"Home Gallery (main gallery)" => "Koti Galleria (pää galleria)",
"Allow same file to be uploaded more than once" => "Sallii saman tiedoston lähetyksen useammin kuin kerran",
"Never" => "EiKoskaan",
"MIME Type" => "MIME Tyyppi",
"Reindex all files for search" => "Uudelleen indeksoi kaikki tiedostot etsintää varten",
"To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "Lisätäksesi/poistaaksesi foorumeja, katso \"Ylläpidä foorumeja\"  \"Foorumien\" alta ohjelmisto valikosta, tai",
"Home Forum (main forum)" => "Koti Foorumi (pää foorumi)",
"Accept wiki syntax" => "Hyväksy syntaksi",
"Topics" => "Aiheet",
"Posts per day" => "Lähetystä päivässä",
"Browser width" => "Selain leveys",
"Browser height" => "Selain korkeus",
"Navigation depth" => "Siirtymis syvyys",
"Node size" => "Solmun koko",
"Text size" => "Tekstin koko",
"Spring (connection) size" => "Lähteen (yhteys) koko",
"Camera distance adjusted relative to nearest node" => "Kameran etäisyys annettu suhteellisesti lähimpään solmuun",
"Camera distance" => "Kameran etäisyys",
"Field of view" => "Näytön kenttä",
"Feed animation interval (milisecs)" => "Syötä animaation tauko (milisecs)",
"Friction constant" => "Pysyvä",
"Elastic constant" => "Joustava pysyvä",
"Eletrostatic constant" => "Sähköisesti pysyvä",
"Node mass" => "Solmun massa",
"Node charge" => "Solmun kulutus",
"To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "Lisätäksesi/poistaaksesi kuva gallerioita, mene \"Kuva Galleriat\" ohjelmisto valikosta, tai",
"You can upload images of a size of " => "Voit lähettää kuvia joiden koko on max ",
"Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Muokkaa php.ini muuttujaa file_uploads, upload_max_filesize, post_max_size ja tietokanta muuttujaa (max_allowed_packet for mysql) muuttaaksesi tätä arvoa",
"Home Gallery" => "Perus Galleria",
"Galleries features" => "Gallerioiden ominaisuudet",
"Uses Slideshow" => "Käytä Kuvaesitystä",
"Use database to store images" => "Käytä tietokantaa kuvien varastointiin",
"Use a directory to store images" => "Käytä hakemistoa kuvien varastointiin",
"Directory path" => "Hakemisto polku",
"Library to use for processing images" => "Kirjasto jota käytetään kuvien käsittelyyn",
"Uploaded image names must match regex" => "Lähetettyjen kuvien nimien täytyy olla yhteen sopiva regex kanssa",
"Uploaded image names cannot match regex" => "Lähetettyjen kuvien nimet eivät saa olla yhteen sopivia regex kanssa",
"Directory Batch Loading" => "Hakemiston Ryhmä Lataus",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "Jos käytät Hakemisto Ryhmä Latausta, sinun on tehtävä hakemisto sivuston ulkopuolelle (ulkopuolinen hakemisto on parempi). Aseta polku siihen hakemistoon, molemmat scp, ftp, tai muut protokollat",
"Enable directory batch loading" => "Oikeuta hakemisto ryhmä lataus",
"Batch loading directory" => "Ryhmä lataus hakemisto",
"Images per row" => "Kuvia rivillä",
"Thumbnails size X" => "Minikuvien koko X",
"Thumbnails size Y" => "Minikuvien koko Y",
"pixels" => "pixeliä",
"Set features" => "Aseta ominaisuudet",
"Exterminator" => "Tuhoaja",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Poista kuvat sivuston galleriasta jos niitä ei ole käytetty sivuilla, artikkeleissa tai blogi lähetyksissä",
"All galleries" => "Kaikki galleriat",
"System Gallery" => "Järjestelmä galleria",
"Gallery listing configuration" => "Gallerian listaus asetukset",
"Parent" => "Isäntä",
"Change configuration" => "Muuta kokoonpanoa",
"Image galleries comments settings" => "Kuva gallerian kommenttien asetukset",
"General Preferences" => "Yleiset Oikeudet",
"Date and Time Formats" => "Päiväys ja Aika Muodot",
"Site Identity" => "Sivusto Identity",
"Browser title" => "Selain otsikko",
"Home Page" => "EtuSivu",
"Use group homepages" => "Käytä ryhmä etusivuja",
"Go to group homepage only if login from default homepage" => "Mene ryhmä etusivulle vain jos kirjautuminen tapahtuu oletus etusivulle",
"Custom home" => "Muunneltu etusivu",
"Unknown/Other" => "Tuntematon/Muu",
"(standard)" => "(standardi)",
"(some Unix MTA)" => "(jotkin Unix MTA)",
"Protect against CSRF with a ticket" => "Suojele CSRF:ta vastaan lipulla",
"Use proxy" => "Käytä proxyä",
"Port" => "Portti",
"Tikiwiki.org help" => "Tikiwiki.org apu",
"Store session data in database" => "Varastoi istunnon tiedot tietokantaan",
"Contact" => "Yhteys",
"Contact user" => "Ota yhteys käyttäjään",
"Count admin pageviews" => "Laske ylläpidon sivunäytöt",
"Temporary directory" => "Väliaikainen hakemisto",
"Help System" => "Avuste Systeemi",
"Help URL" => "Apu URL",
"Long date format" => "Pitkä päiväys muoto",
"Short date format" => "Lyhyt päiväys muoto",
"Long time format" => "Pitkä aika muoto",
"Short time format" => "Lyhyt aika muoto",
"Date and Time Format Help" => "Päiväys ja Aika Muoto Apu",
"Change admin password" => "Muuta admin salasana",
"New password" => "Uusi salasana",
"Change password" => "Muuta Salasana",
"Detect browser language" => "Katso selaimen kieli",
"Use database for translation" => "Käytä tietokantaa käännökseen",
"Edit or ex/import Languages" => "Muokkaa tai vie/tuo Kieliä",
"Record untranslated" => "Tallenne kääntämättä",
"Syntax error" => "Syntaxi virhe",
"Intertiki exchange feature" => "Intertiki keskus ominaisuus",
"Intertiki client" => "Intertiki asiakas",
"Tiki Unique key" => "Tiki Ainutkertainen avain",
"InterTiki Slave mode" => "InterTiki Orja muoto",
"Warning: overrides manually registered local users" => "Waroitus: ylikirjoittaa käsin liitetyt paikalliset käyttäjät",
"as master" => "mestarina",
"Import user preferences" => "Tuo käyttäjä kokoonpanot",
"Import user groups" => "Tuo käyttäjäryhmät",
"InterTiki Server" => "InterTiki Palvelin",
"host" => "isäntä",
"port" => "portti",
"Add new server" => "Lisää uusi palvelin",
"Intertiki server" => "Intertiki palvelin",
"Intertiki Server enabled" => "Intertiki Palvelin käynnissä",
"Access Log file" => "Avaa Logi tiedosto",
"Errors Log file" => "Virheiden Logi tiedosto",
"Known hosts" => "Tunnetut isännät",
"Key" => "Avain",
"Enable/disable Tiki features in " => "Päälle/pois Tiki ominaisuudet ",
", but configure them elsewhere" => ", mutta muokkaa kokoonpanoa muualla",
"Admin Groups" => "Ylläpidä ryhmiä",
"Admin Users" => "Ylläpidä käyttäjiä",
"Authentication method" => "Varmennus menetelmä",
"Tiki and HTTP Auth" => "Tiki ja HTTP Auth",
"Registration" => "Rekisteröinti",
"Users can register" => "Käyttäjät voivat rekisteröityä",
"Use challenge/response authentication" => "Käytä mahdollisuus/vastine varmistusta",
"HTTP port" => "HTTP portti",
"HTTPS port" => "HTTPS portti",
"Duration" => "Kesto",
"PAM service" => "PAM palvelu",
"Currently unused" => "Nyt käyttämätön",
"You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "Sinun on lähetettävä myös <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> erikseen lib/phpcas/.",
"CAS server version" => "CAS palvelin versio",
"Version 1.0" => "Versio 1.0",
"Version 2.0" => "Versio 2.0",
"Users can change theme" => "Rekisteröityneet käyttäjät voivat vaihtaa teemaa",
"Restrict available themes" => "Rajoita saatavilla olevia teemoja",
"Available styles:" => "Saatavilla olevat tyylit:",
"Slideshows theme" => "Kuvaesityksen teema",
"Edit CSS" => "Muokkaa CSS",
"Theme Control" => "Teeman Hallinta",
"Template Viewing" => "Mallin näyttö",
"Tiki Template Viewing" => "Mallin näyttö",
"General Layout options" => "Yleiset ulkoasun valinnat",
"logged as" => "kirjautunut",
"Site logo background color" => "Sivusto logo taustaväri",
"Site logo title (on mouse over)" => "Sivusto logo otsikko (kun hiiri päällä)",
"Alt. description (e.g. for text browsers)" => "Alt. kuvaus (e.g. teksti selaimille)",
"Site menu bar" => "Sivusto valikko palkki",
"Current Version" => "Nykyinen Versio",
"Custom code" => "Muokattu koodi",
"Users can Flip Columns" => "Käyttäjä voi Vaihtaa Palstoja",
"Left column" => "Vasen palsta",
"always" => "aina",
"user decides" => "käyttäjä valitsee",
"Site Breadcrumbs" => "Sivusto Palat",
"Site location bar" => "Sivuston sijainti palkki",
"at top of page" => "sivun yläosassa",
"at top of center column" => "sivun yläosassa keskipalstalla",
"Larger font for" => "Suurempi kirjasin",
"entire location" => "koko sijainti",
"page name" => "sivu nimi",
"Use page description:" => "Käytä sivun kuvausta:",
"Right column" => "Oikea palsta",
"Bottom bar icons" => "Alareunan ikonit",
"Bottom bar debug" => "Alareunan debug",
"Maximum number of records in listings" => "Asiakirjojen suurin määrä listauksessa",
"Use direct pagination links" => "Käytä suoria sivutuslinkkejä",
"Warning" => "Varoitus",
"Vertical" => "Pystysuora",
"Horizontal" => "Vaakasuora",
"Left" => "Vasen",
"Right" => "Oikea",
"Use Tabs" => "Käytä Tabeja",
"Display menus as folders" => "Näytä valikot kansioina",
"Layout per section" => "Ulkoasu osastoittain",
"Admin layout per section" => "Ylläpidon ulkoasu osastoittain",
"Favicon icon file name:" => "Favicon icon tiedostonimi:",
"Favicon icon MIME type:" => "Favicon icon MIME tyyppi:",
"image/png" => "kuva/png",
"image/bmp" => "kuva/bmp",
"image/x-icon" => "kuva/x-icon",
"full path to mapfiles" => "täydellinen polku karttatiedostoihin",
"default mapfile" => "oletus karttatiedosto",
"Wiki Page for Help" => "Apu Sivu",
"Wiki Page for Comments" => "Sivu kommenteille",
"Full path to gdaltindex" => "Koko polku gdaltindexiin",
"Full path to ogr2ogr" => "Koko polku ogr2ogr",
"Map Zone" => "Kartta Vyöhyke",
"Generate User Map" => "Luo Käyttäjä Kartta",
"Maximum mailbox size (messages, 0=unlimited)" => "Postilaatikon suurin koko (viestiä, 0=rajoittamaton)",
"Maximum mail archive size (messages, 0=unlimited)" => "Arkiston suurin koko (viestiä, 0=rajoittamaton)",
"Maximum sent box size (messages, 0=unlimited)" => "Lähetyslaatikon suurin koko (viestiä, 0=rajoittamaton)",
"geo.position" => "geo.sijainti",
"geo.region" => "geo.alue",
"geo.placename" => "geo.paikkanimi",
"Robots" => "Robotit",
"Display modules to all groups always" => "Näyttää kaikki moduulit kaikille ryhmille aina",
"Hide anonymous-only modules from registered users" => "Piilota nimettömien moduulit rekisteröityneiltä käyttäjiltä",
"To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "Lisätäksesi/poistaaksesi äänestyksiä, katso \"Äänestykset\" \"Ylläpito\" ohjelmisto valikossa, tai",
"Last update" => "Viimeisin päivitys",
"installed" => "asennettu",
"Image galleries" => "Kuva galleriat",
"Feed for forums" => "Syöte foorumeille",
"Default RDF version" => "Oletus RDF versio",
"Specification" => "Tuoteseloste",
"Documentation" => "Käsikirja",
"Editor" => "Muokkaaja",
"You can see users rank by score in the module users_rank, for that go to" => "Voit nähdä käyttäjien arvostuksen pisteinä käyttäen users_rank moduulia.",
"Admin modules" => "Ylläpidä moduuleja",
"Expiration" => "Päättyminen",
"Search stats" => "Etsintä tilastot",
"random" => "satunnainen",
"Refresh rate" => "Päivitys väli",
"Minimum length of search word" => "Etsittävän sanan minimi pituus",
"Max. number of words containing a syllable" => "´Maksimi määrä sanoja sisältäen tavuja",
"Max. age in hours of syllable search cache" => "Maksimi ikä tunteina tavutus etsinnän puskurille",
"LRU list purging rate" => "LRU listaa tyhjennys välit",
"LRU list length" => "LRU listan pituus",
"Refresh wiki search index now" => "Päivitä etsintä indeksi nyt",
"Referer Search Highlighting" => "Etsintä Viittausten Korostus",
"Ignore individual object permissions" => "Älä huomio yksittäisen kohteen oikeuksia",
"hits" => "osumia",
"Open external links in new window" => "Avaa ulkoiset linkit uuteen ikkunaan",
"Dynamic Content System" => "Muuttuvan Sisällön Systeemi",
"Automonospaced text" => "Autotasalevyinen teksti",
"Tables syntax" => "Taulukon syntaksi",
"AutoLinks" => "AutoLinkit",
"rows" => "rivit",
"Required" => "Pakollinen",
"Parameters" => "Kokoonpanot",
"To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "Muokataksesi kortistoja, katso \"Ylläpidä kortistoja\" \"Kortiston\" alla ohjelmisto valikossa, tai",
"Trackers with mirror tables" => "Kortistot ja peilaus taulukot",
"Use trackers with mirror tables" => "Käyttäjä kortistot ja peilaus taulukot",
"Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Arvot tallennetaan niille omistettuun taulukkoon jokaiseen kortistoon, joten voi helposti muokata niitä sivuston ulkopuolella",
"Validate choice" => "Varmista valinta",
"Storage" => "Varasto",
"Change" => "Muuta",
"Change all to db" => "Muuta kaikki tietokantaan",
"Change all to file" => "Muuta kaikki tiedostoon",
"Quota (Mb)" => "Levytila (Mb)",
"Use database to store userfiles" => "Käytä tietokantaa käyttäjätiedostojen varastointiin",
"Use a directory to store userfiles" => "Käytä hakemistoa käyttäjätiedostojen varastointiin",
"Allow viewing HTML mails?" => "Salli HTML lähetysten näyttäminen?",
"Maximum size for each attachment" => "Jokaisen liitteen maksimi koko",
"Unlimited" => "Rajoittamaton",
"Create New" => "Luo uusi",
"Home page" => "EtuSivu",
"Complete" => "Valmis",
"Individual cache" => "Yksittäinen puskuri",
"Content templates" => "Sisältö mallit",
"Warn on edit conflict" => "Varoita muokkaus ristiriidoista",
"Undo" => "Peruuta",
"Footnotes" => "Alaviitteet",
"Permission" => "Oikeudet",
"Allow HTML" => "Salli HTML",
"Sandbox" => "Hiekkaloota",
"Dumps" => "Dumpit",
"Remove a tag" => "Poista kiinnike",
"Generate dump" => "Luo dumppi",
"Download last dump" => "Imuroi viimeisin dumppi",
"Pictures" => "Kuvat",
"Remove unused pictures" => "Poista käyttämättömät kuvat",
"Export" => "Vie",
"Export Wiki Pages" => "Vie Wiki Sivut",
"Accept dashes and underscores in WikiWords" => "Hyväksy alleviivaus ja keno Sanoissa",
"Link plural WikiWords to their singular forms" => "Linkitä monikko WikiSanat yksikkö muotoon",
"Side-by-side diff" => "Erot rinnakkain",
"Discuss pages on forums" => "Keskustelua fooruminsivuista",
"Similar" => "Samanlainen",
"Structures" => "Rakenteet",
"Open page as structure" => "Avaa sivu rakenteena",
"Import HTML" => "Tuo HTML",
"Page creators are admin of their pages" => "Sivu luoja on ylläpitäjä luomilleen sivuille",
"Create watch for author on page creation" => "Luo vahti sivun luojaan",
"Enable watch events when I am the editor" => "Mahdollista vahti kun olen muokkaajana",
"Enable watches on comments" => "Salli vahdit kommenteille",
"List pages" => "Sivu listaus",
"Wiki attachments" => "Wiki liitteet",
"Restore defaults" => "Palauta oletukset",
"Crosslinks to other features and settings" => "Ristiviittaukset muihin ominaisuuksiin ja asetuksiin",
"Other sections" => "Muut osastot",
"Contact us" => "Ota yhteyttä",
"Administration features" => "Ylläpidon ominaisuudet",
"Security" => "Turvallisuus",
"SysLogs" => "JärLogit",
"Mods" => "Modulit",
"Transversal features" => "Käännös ominaisuudet",
"which apply to more than one section" => "jotka lisätään useampaan kuin yhteen osastoon",
"Navigation features" => "Siirtymis omaisuudet",
"Look &amp; feel" => "Ulkonäkö &amp; fiilis",
"themes" => "teemat",
"Text area features" => "Tekstialue ominaisuudet",
"features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "ominaisuudet joita voi käyttää kaikkialla, sivuston sivuilla, blogeissa, artikkeleissa, foorumeilla, jne",
"Stats &amp; banners" => "Tilastot &amp; bannerit",
"Setting" => "Asetus",
"Category:" => "Luokka:",
"Statistics" => "Tilastot",
"Weeks" => "Viikkoa",
"viewed" => "näytetty",
"Add or edit a rule" => "Lisää tai muuta sääntö",
"Rule title" => "Säännön otsikko",
"Username regex matching" => "Käyttänimi regex yhdenmukaisuuus",
"IP regex matching" => "IP regex yhdenmukaisuus",
"Banned from sections" => "Osastot estetty",
"Rule activated by dates" => "Säännön aktivointi päivä",
"Rule active from" => "Sääntö voimassa",
"Rule active until" => "Sääntö voimassa kunnes",
"Custom message to the user" => "Muunneltu viesti käyttäjälle",
"Rules" => "Säännöt",
"User/IP" => "Käyttäjä/IP",
"Sections" => "Osastot",
"Admin Calendars" => "Ylläpidä Kalentereita",
"List of Calendars" => "Kalenterien lista",
"Loc" => "Pai",
"Participants" => "Osalliset",
"Cat" => "Luet",
"Lang" => "Kieli",
"Prio" => "Ensis",
"Subscription" => "Tilaukset",
"Perso" => "Henkilö",
"Custom Locations" => "Muunnellut Sijainnit",
"Custom Participants" => "Muutetut Osallistujat",
"Custom Categories" => "Muunnellut Luokittelut",
"Custom Languages" => "Muunnellut Kielet",
"Custom Subscription List" => "Muutettujen Tilausten Lista",
"Custom Priorities" => "Muunnellut Etuoikeudet",
"Personal Calendar" => "Henkilökohtainen Kalenteri",
"Red" => "Punainen",
"Current category" => "Nykyinen luokka",
"Child categories" => "Ala luokittelut",
"Edit permissions for this category" => "Muokkaa tämän luokan oikeuksia",
"Edit this category:" => "Muokkaa tätä luokkaa:",
"Add new category" => "Lisää uusi luokka",
"Perms inherited from closest parent if possible or from global perms" => "Oikeudet katsotaan lähimmästä isännästä tai yleisistä oikeuksista",
"Assign permissions automatically" => "Anna oikeudet automaattisesti",
"recommended for best performance" => "suositellaan parhaan suorituskyvyn vuoksi",
"Objects in category" => "Kohteita luokassa",
"No records found." => "Ei löydy tallennetta.",
"Add objects to category" => "Lisää kohteita luokkaan",
"image gal" => "kuva gal",
"file gal" => "tied gal",
"Admin chart items" => "Ylläpidä kaavion osia",
"Edit Chart" => "Muuta kaavio",
"Add or edit an item" => "Lisää tai muuta osaa",
"Update" => "Päivitä",
"Chart items" => "Kaavion osat",
"No items defined yet" => "Ei määritelyjä osia vielä",
"Add or edit a chart" => "Lisää tai muuta kaavio",
"Active" => "Aktiivinen",
"Users can vote for only one item from this chart per period" => "Käyttäjä voi äänestää vain yhtä osaa kaaviosta per aikajakso",
"Prevent users from voting for the same item more than once" => "Estä käyttäjää äänestämästä samaa osaa enemmän kuin kerran",
"Users can suggest new items" => "Käyttäjät voivat ehdottaa uusia osia",
"Auto validate user suggestions" => "Vahvista automaattisesti käyttäjä ehdotukset",
"Ranking shows" => "Arvostus näyttää",
"All items" => "Kaikki osat",
"Top 10 items" => "Top 10 osat",
"Top 20 items" => "Top 20 osat",
"Top 40 items" => "Top 40 osat",
"Top 50 items" => "Top 50 osat",
"Top 100 items" => "Top 100 osat",
"Top 250 items" => "Top 250 osat",
"Voting system" => "Äänestys järjestelmä",
"Vote items" => "Äänestä osia",
"Rank 1..5" => "Arvo 1..5",
"Rank 1..10" => "Arvo 1..10",
"Ranking frequency" => "Arvostus väli",
"Realtime" => "Reaaliaika",
"Each 5 minutes" => "Joka 5 minuutti",
"Daily" => "Päivittäin",
"Weekly" => "Viikottain",
"Monthly" => "Kuukausittain",
"Show Average" => "Näytä Keskiarvo",
"Show Votes" => "Näytä Äänet",
"Use Cookies for unregistered users" => "Käytä keksejä rekisteröimättömille käyttäjille",
"Users can vote again after" => "Käyttäjä voi äänestää uudelleen kun",
"Anytime" => "Koskavain",
"Ranks" => "Arvostukset",
"No charts defined yet" => "Ei kaaviota määritelty vielä",
"Admin templates" => "Ylläpidä malleja",
"Edit this template:" => "Muuta tätä mallia:",
"Create new template" => "Luo uusi malli",
"Use wysiwyg editor" => "Käytä wysiwyg muokkainta",
"Use normal editor" => "Käytä tavallista muokkainta",
"Templates" => "Mallit",
"Settings" => "Asetukset",
"Admin cookies" => "Ylläpidä keksejä",
"To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "Keksien käyttö tekstialueella kuten (sivulla, jne), <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduuli</a> tai malli, käytä {literal}{cookie}{/literal}.",
"Create/edit cookies" => "Luo/muuta keksejä",
"Upload Cookies from textfile" => "Lähetä Keksit tekstiedostosta",
"Upload from disk:" => "Lähetä kovalevyltä:",
"Upload" => "Lähetä",
"Remove all cookies" => "Poista kaikki keksit",
"cookie" => "keksi",
"Admin drawings" => "Ylläpidä piirroksia",
"To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "Luodaksesi piirroksen sivulle, käytä {literal}{draw name=foo}{/literal}, missä foo piirroksen nimi. Tallennuksen jälkeen, paina piirroslinkkiä.",
"Available drawings" => "Saatavilla olevat piirrokset",
"Use Admin DSN to define the database to be used by the SQL plugin." => "Käytä Ylläpidä DSN määrittääksesi tietokannan jota SQL plugin käyttää.",
"Create/edit dsn" => "Luo/muokkaa dsn",
"Admin external wikis" => "Ylläpidä ulkoiset wikit",
"View template" => "Näytä malli",
"tiki admin external wikis template" => "sivusto ylläpito ulkoisten sivujen malli",
"Edit template" => "Muokkaa mallia",
"Create/Edit External Wiki" => "Luo/muuta Ulkoinen Wiki",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (käytä \$sivua korvaamaan sivun nimeltä URL esimerkki: http://www.example.com/tiki-index.php?page=\$page)",
"ExtWiki" => "Extwiki",
"Admin Forums" => "Ylläpidä Foorumeja",
"Create new forum" => "Luo uusi foorumi",
"List forums" => "Listaa foorumit",
"Edit this Forum:" => "Muokkaa tätä Foorumia:",
"Create New Forum" => "Luo Uusi Foorumi",
"There are individual permissions set for this forum" => "Tälle foorumille on erityisoikeudet",
"Prevent flooding" => "Estä vuoto",
"Minimum time between posts" => "Minimi aika lähetysten välillä",
"Section" => "Osasto",
"Create new" => "Luo uusi",
"Moderator user" => "Esimies käyttäjä",
"Moderator group" => "Esimies ryhmä",
"Password protected" => "Salasana suojattu",
"Topics only" => "Vain aiheet",
"All posts" => "Kaikki lähetykset",
"Forum password" => "Foorumin salasana",
"Send this forums posts to this email" => "Lähetä tämän foorumin lähetykset tähän sähköpostiosoitteeseen",
"Prune unreplied messages after" => "Poista vastaamattomat viestit kun täyttyy",
"Prune old messages after" => "Poista vanhat viestit kun täyttyy",
"Topic list configuration" => "Aihe listan kokoonpano",
"Posts can be rated" => "Lähetykset voi arvostella",
"Display last post titles" => "Näytä viimeiset otsikot",
"no display" => "ei näytettävää",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Lähetä tämän foorumin lähetykset tähän osoitteeseen, siinä muodossa, että vastauksen voi lähettää sähköpostilla foorumille",
"Send mails even when the post is generated by inbound mail" => "Lähetä viestit vaikka posti olisi luotu saapuneista",
"Append a reply link to outbound mails" => "Lisää vastaus linkki lähteviin posteihin",
"Originating e-mail address for mails from this forum" => "Alkuperäinen sähköpostiosoite lähetyksille tältä foorumilta",
"Add messages from this email to the forum" => "Liisää viestit tästä sähköpostiosoitteesta foorumille",
"POP3 server" => "POP3 palvelin",
"Use topic smileys" => "Käytä aihe hymiöitä",
"Show topic summary" => "Näytä aiheen yhteenveto",
"User information display" => "Käyttäjä tietojen näyttö",
"Online" => "Linjalla",
"Approval type" => "Hyväksyttävä tyyppi",
"All posted" => "Kaikki lähetetyt",
"Queue anonymous posts" => "Nimettömien postit jonoon",
"Queue all posts" => "Kaikki postit jonoon",
"No attachments" => "Ei liitteitä",
"Everybody can attach" => "Kaikki voivat liittää",
"Only users with attach permission" => "Vain käyttäjät joilla on liite lupa",
"Moderators and admin can attach" => "Esimiehet ja ylläpito voivat liittää",
"Store attachments in:" => "Varastoi liitteet:",
"Database" => "Tietokanta",
"Max attachment size (bytes)" => "Liitteen suurin koko (bytes)",
"Default ordering for topics" => "Aiheiden oletus järjestys",
"Date (desc)" => "Päiväys (aleneva)",
"Date (asc)" => "Päiväys (nouseva)",
"Score (desc)" => "Tilanne (aleneva)",
"Replies (desc)" => "Vastaukset (aleneva)",
"Reads (desc)" => "Lukijaa (aleneva)",
"Topics per page" => "Aihetta per sivu",
"Default ordering for threads" => "Oletus järjestys ketjuille",
"Coms" => "Kom",
"Age" => "Ikä",
"PPD" => "Ppd",
"Admin Hotwords" => "Ylläpidä Hotwords",
"Add Hotword" => "Lisää Hotword",
"Word" => "Sana",
"Admin HTML pages" => "Ylläpidä HTML sivuja",
"Edit this page" => ">Muokkaa tätä sivua",
"View page" => "Näytä sivu",
"Edit zone" => "Muokkaa aluetta",
"Dynamic zones" => "Muuttuvat alueet",
"zone" => "alue",
"content" => "sisältö",
"Mass update" => "Massa päivitys",
"Create new HTML page" => "Luo uusi HTML sivu",
"Edit this HTML page:" => "Muokkaa tätä HTML sivua:",
"Apply template" => "Lisää malli",
"Dynamic" => "Muuttuva",
"Static" => "Muuttumaton",
"Last Modif" => "Viimeki muokannut",
"Edit Repository:" => "Muokkaa Säilytyspaikkaa:",
"Create New Repository" => "Luo Uusi Säilytyspaikka",
"List Repositories" => "Lista säilytyspaikoista",
"New Repository" => "Uusi säilytyspaikka",
"View Repository" => "Näytä säilytyspaikka",
"Human readable repository name" => "Luettavissa oleva säilytyspaikan nimi",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Polku säilytyspaikkaan (paikallinen järjestelmä: suhteellinen/täydellinen web root, etäinen: alkuosa 'http://')",
"File name of start page" => "Aloitus sivun tiedosto nimi",
"Start page" => "Aloitus sivu",
"CSS file to load when browse this repository" => "CSS tiedosto joka ladataan kun selataan tätä säilytyspaikkaa",
"CSS file" => "CSS tiedosto",
"Is repository visible to users" => "Onko tämä säilytyspaikka kaikille näkyvä",
"Can files from repository be cached" => "Voiko säilytyspaikan tiedostoja puskuroida",
"Cacheable" => "Puskuroitavissa",
"Are files from repository can be cached" => "Onko säilytyspaikan tiedostot puskuroitavissa",
"Clear all cached pages of this repository" => "Tyhjennä sivu puskurit tästä tallennuspaikasta",
"Clear cache" => "Tyhjennä puskuri",
"Seconds count 'till cached page will be expired" => "Aika laskuri 'kunnes puskurointi päättyy",
"Cache expiration" => "Puskuroinnin päättyminen",
"Human readable text description of repository" => "Luettavissa oleva säilytyspaikan kuvaus",
"Available Repositories" => "Saatavilla olevat säilytyspaikat",
"CSS File" => "CSS tiedosto",
"Edit rules" => "Muuta sääntöjä",
"Edit Rules for Repository:" => "Muuta Säilytyspaikan Sääntöjä:",
"Configure Repositories" => "Säilytyspaikan kokoonpano",
"Configure this Repository" => "Muuta säilytyspaikan kokoonpanoa",
"View this Repository" => "Näytä tämä säilytyspaikka",
"New Rule" => "Uusi sääntö",
"Copy Rules" => "Kopio säännöt",
"view/hide copy rules dialog" => "näytä/piilota kopio sääntöjen vuoropuhelusta",
"Source repository" => "Lähde säilytyspaikka",
"Copy" => "Kopio",
"According this order rules will be applied ('0' or empty = auto)" => "Tämän määräyksen mukaan sääntöjä käytetään ('0' tai tyhjä = auto)",
"Rule order" => "Sääntö järjestys",
"Text to search for" => "Teksti jota etsitään",
"Text to replace" => "Korvattava teksti",
"Is this regular expression or simple search/replacer" => "Onko tämä normaali ilmaisu vai yksinkertainen etsi ja korvaa",
"Is case sensitive (for simple replacer)" => "Erotetaanko isot ja pienet (yksinkertaiseen korvaamiseen)",
"Case sensitive" => "Erota isot ja pienet",
"subset of chars: imsxeADSXUu, which is regex modifiers" => "osajoukko kirjaimia: imsxeADSXUu, jotka ovaat regex modifiers",
"Regex modifiers" => "Regex muokkaajat",
"Human readable text description of rule" => "Luettavissa oleva teksti kuvauksen sääntö",
"Check to enable this rule" => "Merkitse sääntö käyttöön",
"Enabled" => "Käynnistetty",
"Preview options" => "Näyttö asetukset",
"Apply all rules or just this to generate preview" => "Lisää kaikki säännöt tai vain tähän näytön muodostukseen",
"Apply all rules" => "Liitä kaikki säännöt",
"View source code after rules applied" => "Näytä koodi sääntöjen lisäämisen jälkeen",
"Code preview" => "Koodi näyttö",
"Generate HTML preview" => "Muodosta HTML näyttö",
"HTML preview" => "HTML näyttö",
"Test file from repository to generate preview for (empty = configured start page)" => "Testaa säilytyspaikan tiedosto muodostaaksesi näyttö (tyhjä = aloitus sivun asetukset)",
"Preview Results" => "Näytä Tulokset",
"Rules List" => "Sääntö luettelo",
"Case" => "Tapaus",
"Configure/Options" => "Kokoonpano/Asetukset",
"Admin layout" => "Ylläpidä layout",
"Theme control" => "Teema hallinta",
"layout options" => "layout asetukset",
"Generate positions by hits" => "Muodosta paikat osumien perusteella",
"List of featured links" => "Ominaisuuslinkkien lista",
"Position" => "Paikka",
"Add Featured Link" => "Lisää Ominaisuus Linkki",
"Edit this Featured Link:" => "Muuta tätä Ominaisuus Linkkiä:",
"Create new Featured Link" => "Luo Uusi Ominaisuus Linkki",
"disables the link" => "poistaa linkin",
"Link type" => "Linkin tyyppi",
"replace current page" => "korvaa nykyisen sivun",
"framed" => "kehystetty",
"open new window" => "avaa uuden ikkunan",
"Mail-in accounts" => "Postit-sisään tilit",
"Account" => "Tili",
"Add new Mail-in account" => "Lisää uusi postit-sisään tili",
"Edit Mail-in account" => "Muokkaa postit-sisään tiliä",
"Account name" => "Tilin nimi",
"POP server" => "POP palvelin",
"SMTP server" => "SMTP palvelin",
"SMTP requires authentication" => "SMTP tarvitsee kirjautumisen",
"article-put" => "artikkeli-laita",
"wiki-get" => "w-get",
"wiki-put" => "w-put",
"wiki-append" => "w-append",
"Article Topic" => "Artikkelin Aihe",
"Admin Topics" => "Ylläpidä Aiheita",
"Article Type" => "Artikkelin Tyyppi",
"Admin Types" => "Ylläpidon tyypit",
"Allow anonymous acces" => "Salli nimetön pääsy",
"Allow attachments" => "Salli liitteet",
"Discard to the end from" => "Poista loppuosa tästä",
"Check Mail-in accounts" => "Tarkista postit-sisään tilit",
"Check automatically" => "Tarkista automaattisesti",
"Frequency" => "Yleisyys",
"List menus" => "Listaa valikot",
"Edit this menu" => "Muokkaa tätä valikkoa",
"Edit menu options" => "Muuta valikko asetuksia",
"Show Quick Urls" => "Näytä Pika Url:it",
"Some useful URLs" => "Käyttökelpoisia URL:ja",
"Hide Quick Urls" => "Piilota Pika Url:it",
"option" => "valinnainen",
"separator" => "erotin",
"Choose" => "Valitse",
"Home Blog" => "OmaBlogi",
"Home Image Gal" => "Oma Kuva Gal",
"Home Image Gallery" => "Oma Kuva Galleria",
"Home File Gal" => "Oma Tiedosto Gal",
"Home File Gallery" => "Oma Tiedosto Galleria",
"User preferences" => "Käyttäjä kokoonpano",
"User prefs" => "Käyttäjä kokoonpano",
"List galleries" => "Listaa galleriat",
"List image galleries" => "Listaa kuva galleriat",
"Upload image" => "Lähetä kuva",
"Gallery Rankings" => "Galleria Arvostukset",
"Browse a gallery" => "Selaa galleriaa",
"Articles home" => "Artikkelien koti",
"All articles" => "Kaikki artikkelit",
"Submit" => "Lähetä",
"List Blogs" => "Listaa Blogit",
"Create blog" => "Luo blogi",
"File galleries" => "Tiedosto galleriat",
"View a forum" => "Näytä foorumi",
"View a thread" => "Näytä ketju",
"View a FAQ" => "Näytä UKK",
"Take a quiz" => "Ota visailu",
"Quiz stats" => "Visailu tilastot",
"Stats for a Quiz" => "Tilastot visailuun",
"Preview menu" => "Edellinen valikko",
"Menu options" => "Valikko valinnat",
"Edit this Menu:" => "Muuta tätä Valikkoa:",
"Create new Menu" => "Luo uusi Valikko",
"dynamic collapsed" => "muuttuva kokoon taittuva",
"dynamic extended" => "muuttuva laajentuva",
"fixed" => "vakio",
"Options" => "Vaihtoehdot",
"Active Permissions" => "Aktiiviset oikeudet",
"Clear Cache" => "Tyhjennä puskuri",
"User Modules" => "Käyttäjä Moduulit",
"Assigned Modules" => "Liitetyt Moduulit",
"Left Modules" => "Moduulit Vasemmalla",
"Rows" => "Rivejä",
"Move to Right Column" => "Siirrä oikeaan palstaan",
"Unassign" => "Poistaliitos",
"Right Modules" => "Moduulit Oikealla",
"Move to Left Column" => "Siirrä vasempaan palstaan",
"Assign new module" => "Liitä uusi moduuli",
"Edit this assigned module:" => "Muokkaa tätä liitettyä moduulia:",
"Cache Time" => "Puskurointi Aika",
"Visibility" => "Näkyvyys",
"Displayed now for all eligible users even with personal assigned modules" => "Näytetään halutuille käyttäjille vaikka heillä on omia moduuleja",
"Displayed for the eligible users with no personal assigned modules" => "Näytetään halutuille käyttäjille joilla ei ole omia moduuleja",
"Displayed now, can't be unassigned" => "Näytetään nyt, ei voi poistaa liitosta",
"Not displayed until a user chooses it" => "Ei näytetä ellei käyttäjä valitse sitä",
"Create new user module" => "Luo uusi käyttäjä moduuli",
"Edit this user module:" => "Muokkaa tätä käyttäjä moduulia:",
"Must be wiki parsed" => "Oltava wiki jäsennetty",
"Objects that can be included" => "Kohteet jotka voidaan lisätä",
"Available polls" => "Saatavilla olevat äänestykset",
"Random active poll" => "Satunnaisaktiivinen äänestys",
"Random current poll" => "Satunnasinykyinen äänestys",
"Use Poll" => "Käytä äänestystä",
"Random image from" => "Satunnais kuva",
"Use Gallery" => "Käytä galleriaa",
"Dynamic content blocks" => "Muuttuva sisältöiset palat ",
"Use Dynamic Content" => "Käytä muuttuvaa sisältöä",
"Use RSS Module" => "Käytä rss moduulia",
"Use Menu" => "Käyttäjä valikko",
"phpLayersMenus" => "phpLayersValikko",
"Use phplayermenu" => "Käytä phplayervalikkoa",
"Banner zones" => "Banneri alueet",
"Use Banner Zone" => "Käytä banneri aluetta",
"Data" => "Tietue",
"Admin newsletter subscriptions" => "Ylläpidä uutislehden tilauksia",
"List Newsletters" => "Listaa uutislehdet",
"Admin Newsletters" => "Ylläpidä uutislehtiä",
"Send Newsletters" => "Lähetä Uutislehti",
"Add a subscription newsletters" => "Lisää tilaus uutislehtiin",
"Add email:" => "Lisää sähköposti:",
"Add user:" => "Lisää käyttäjä:",
"Group users" => "Ryhmitä käyttäjät",
"Group subscription also subscribes included groups" => "Ryhmä tilaus sisältää myös sisältävät ryhmät",
"Don't send confirmation mail" => "Älä lähetä varmistus postia",
"The user email will be refreshed at each newsletter sending" => "Käyttäjän sähköposti varmistetaan jokaisen uutiskirjeen yhteydessä",
"Subscribe group" => "Tilaa ryhmälle",
"Included group, group users and emails will be refreshed at each newsletter sending" => "Sisällytetyt ryhmät, ryhmän jäsenet ja sähköpostit varmistetaan jokaisen uutiskirjeen yhteydessä",
"Subscriptions" => "Tilaukset",
"Valid" => "Hyväksytty",
"Subscribed" => "tilattu",
"Admin newsletters" => "Ylläpidä uutislehteä",
"There are individual permissions set for this newsletter" => "Tälle uutislehdelle on asetettu erityioikeudet",
"Users can subscribe/unsubscribe to this list" => "Käyttäjät voivat tilata/peruuttaa tämän listan",
"Users can subscribe any email address" => "Käyttäjä voi tilata millä tahansa sähköpostiosoitteella",
"Add unsubscribe instructions to each newsletter" => "Lisää peruutus ohjeet jokaiseen uutislehteen",
"Validate email addresses" => "Varmista sähköpostiosoitteet",
"Editions" => "Laitokset",
"Last Sent" => "Viimeksi lähetetty",
"Add notification" => "Lisää ilmoitus",
"Event" => "Tapahtuma",
"A user registers" => "Käyttäjän rekisteröinti",
"A user submits an article" => "Käyttäjä ehdottaa artikkelia",
"Any wiki page is changed" => "Mikä tahansa sivu muuttuu",
"Any wiki page is changed, even minor changes" => "Mikä tahansa sivu muuttuu, jopa pienet muutokset",
"PHP error" => "PHP virhe",
"Email:" => "Sähköposti:",
"List polls" => "Listaa äänestykset",
"Edit this poll" => "Muokkaa tätä äänestystä",
"Preview poll" => "Näytä äänestystä",
"Option" => "Vaihtoehto",
"Poll options" => "Äänestys vaihtoehdot",
"Votes" => "Ääniä",
"Admin Polls" => "Ylläpidä Äänestyksiä",
"Set last poll as current" => "Aseta viimeisin äänestys nykyiseksi",
"Close all polls but last" => "Sulje kaikki äänestykset paitsi viimeinen",
"Activate all polls" => "Käynnistä kaikki äänestykset",
"active" => "aktiivinen",
"current" => "nykyinen",
"template" => "malli",
"object" => "kohde",
"PublishDate" => "JulkaisuPäivä",
"Results" => "Tulokset",
"Wiki pages" => "Sivuja",
"Admin Quicktags" => "Ylläpidä Pikalisiä",
"Create/Edit QuickTags" => "Luo/muokkaa PikaLisiä",
"Insert (use 'text' for figuring the selection)" => "Lisää (käytä 'teksti' kuvaamaan valintaa)",
"Path to the tag icon" => "Polku lisän kuvakkeeseen",
"Admin RSS Modules" => "Ylläpidä RSS moduuleja",
"This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "Tämä sivu on kokoonpano muutoksiin RSS syötteissä lue/tuo sivustosta. Luodaksesi/viedäksesi RSS syöte, katso \"RSS syötteet\" ylläpito paneelista, tai",
"To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "Käyttääksesi RSS syötettä teksti alueella (Sivu, jne), <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduuli</a> tai malli, käytä {literal}{rss id=x}{/literal}, missä x on RSS syötteen ID.",
"Content for the feed" => "Syötteen sisältö",
"show feed title" => "näytä syötteen otsikko",
"show publish date" => "näytä julkaisu päivä",
"To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "<a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">ilmoita turvallisuus aiheista</a>.",
"PHP settings" => "PHP asetukset",
"PHP variable" => "PHP muuttujat",
"Risk Factor" => "Riski Kerroin",
"Explanation" => "Selvitys",
"Tiki variable" => "Sivusto muuttuja",
"Check all tiki files" => "Tarkista kaikki sivuston tiedostot",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Huomaa, tämä voi viedä kauan aikaa. Sinun on tarkistettava max_execution_time asetus php.ini:ssä.",
"Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Huomaa: Sinun on annettava turvallisuus tiedot asennuksen yhteydessä (<a href=\"tiki-install.php\">tiki-install.php</a>). Tuo *secdb* päivittää tiedostot tietokantaan.",
"File checks" => "Tiedosto tarkistukset",
"user" => "käyttäjä",
"group" => "ryhmä",
"sticky" => "pysyvä",
"Admin Shoutbox Words" => "Ylläpidä Pikaviestin Sanoja",
"Add Banned Word" => "Lisää Poisto Sana",
"Are you sure you want to delete this word?" => "Oletko varma, että haluat poistaa tämän sanan?",
"Destroy the structure leaving the wiki pages" => "Poista rakenne poistuessa sivuilta",
"Destroy the structure and remove the pages" => "Poista rakenne ja poista sivut poistuessa",
"Export Pages" => "Tulosta sivut",
"Dump Tree" => "Dumppi puu",
"Create WebHelp" => "Luo WebApu",
"View WebHelp" => "Näytä webapu",
"Create new structure" => "Luo uusi rakenne",
"Tree" => "Puu",
"Use single spaces to indent structure levels" => "Käytä sanaväliä sisennykseen osoittamaan rakenne tasoja",
"Create New Structure" => "Luo uusi rakenne",
"List surveys" => "Listaa tutkimukset",
"Survey Stats" => "Tutkimus tilastot",
"Edit this Survey" => "Muuta tätä tutkimusta",
"Admin Surveys" => "Ylläpidä tutkimuksia",
"Question" => "Kysymys",
"One choice" => "Yksi valinta",
"Multiple choices" => "Moni valinta",
"Short text" => "Lyhyt teksti",
"Rate (1..5)" => "Luokittele (1..5)",
"Rate (1..10)" => "Luokittele (1..10)",
"Rate" => "Kerroin",
"Options (if apply)" => "Vaihtoehdot (jos lisätty)",
"Questions" => "Kysymykset",
"Admin surveys" => "Ylläpidä tutkimuksia",
"List Surveys" => "Listaa Tutkimukset",
"Edit this Survey:" => "Muokkaa tätä tutkimusta:",
"Create New Survey" => "Luo Uusi Tutkimus",
"There are individual permissions set for this survey" => "Tälle tutkimukselle on erityisoikeudet",
"Open" => "Avaa",
"If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)." => "Jos sivustosi käyttäytyy oudosti, kokeile ensimmäiseksi tyhjentää puskuri alhaalta. Tärkeää on myös päivityksen jälkeinen puskurin tyhjennys (FTP/SSH tarvittaessa).",
"Empty" => "Tyhjennä",
"Templates compiler" => "Mallien muodostaja",
"Compile" => "Muodosta",
"Advanced feature" => "Kehittyneempi ominaisuus",
"Fix UTF-8 Errors in Tables" => "Korjaa UTF-8 Virheet taulukoihin",
"Warning: Make a backup of your Database before using this function!" => "Waroitus: Tee varmuuskopio tietokannastasi ennen kuin käytät tätä!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Waroitus: Jos yrität muuntaa suuria taulukoita, nosta scriptin maximi ajoaikaa php.ini:ssä!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "Tämä muuntaa ISO-8859-1 merkkijonot tietokannassa UTF-8 muotoon",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "Tämä voi olla välttämätöntä jos olet käyttänyt aiemmin &lt; 1.8.4 ja Oletus kirjaimisto oli ISO-8859-1",
"UTF-8 Errors fixed" => "UTF-8 Virheet korjattu",
"Investigate" => "Tutki",
"Fix it" => "Korjaa se",
"Create a new topic" => "Luo uusi aihe",
"Topic Name" => "Aiheen Nimi",
"Upload Image" => "Lähetä Kuva",
"List of topics" => "Listaa aiheet",
"Articles (subs)" => "Artikkelit (subs)",
"topic image" => "aihe kuva",
"Deactivate" => "PuraAktivointi",
"Remove with articles" => "Poista artikkelin mukana",
"List Trackers" => "Listaa Kortistot",
"Admin Trackers" => "Ylläpidä kortistoja",
"Edit This Tracker" => "Muokkaa tätä kortistoa",
"View This Tracker's Items" => "Näytä tämän kortiston osat",
"Edit tracker field" => "Muokkaa kortiston kenttiä",
"Is column visible when listing tracker items?" => "Onko palsta näkyvä kun listataan kortiston osia?",
"Column links to edit/view item?" => "Palstan linkit muuta/näytä osa?",
"Column is searchable?" => "Palsta on etsittävissä?",
"Field is mandatory?" => "Kenttä on pakollinen?",
"Tracker fields" => "Kortiston kentät",
"isMain" => "onPää",
"Searchable" => "Etsittävissä",
"Hidden" => "Piilotettu",
"Mandatory" => "Pakollinen",
"Import/Export Trackers Fields" => "Tuonti/vienti kortiston kentistä",
"Edit Tracker" => "Muuta kortisto",
"Import/Export" => "Tuonti/vienti",
"Found" => "Löytyi",
"trackers" => "kortistot",
"with" => " ",
"There are individual permissions set for this tracker" => "Tälle kortistolle on erityisoikeudet",
"No individual permissions. Global permissions apply." => "Ei erityisoikeuksia yleiset oikeudet liitetään",
"Use \"explicit\" names in the mirror table" => "Käytä \"avoimia\" nimiä peili taulukolle",
"Show status" => "Näytä tila",
"Default status displayed in list mode" => "Oletus tila näytetään listauksen yhteydessä",
"Show status to tracker admin only" => "Näytä kortiston tila vain ylläpitäjälle",
"Send copies of all activity in this tracker to this e-mail address" => "Lähetä kopio kaikesta toiminnosta tässä kortistossa tähän sähköpostiosoitteeseen",
"Use simplified e-mail format" => "Käytä yksinkertaista sähköposti muotoa",
"New items are created with status" => "Uudet osat luodaa tilan kanssa",
"Authoritative status for modified items" => "Arvovaltainen tila muokatuille osille",
"No change" => "Ei muutosta",
"Item creator can modify his items?" => "Voiko osan luoja muokata osaansa?",
"The tracker needs a user field with the option 1" => "Kortisto tarvitsee käyttäjä kentän jolla on vaihtoehto 1",
"Member of the default group of creator can modify items?" => "Oletus ryhmän jäsen luojana voi muokata osaa?",
"The tracker needs a group field with the option 1" => "Kortisto tarvitsee ryhmä kentän jolla on vaihtoehto 1",
"Show creation date when listing tracker items?" => "Näytä luonti päivä kun listataan kortiston osia?",
"Show lastModif date when listing tracker items?" => "Näytä viimeksi muokkauspäivä kun listataan kortiston osia?",
"What field is used for default sort?" => "Mitä kenttää käytetään oletus lajittelussa?",
"What is default sort order in list?" => "Mikä on oletus järjestys listauksessa?",
"Tracker items allow ratings?" => "Kortisto osat sallii luokitukset?",
"with values" => "arvoilla",
"and display rating results in listing?" => "ja näyttää luokitus tulokset listalla?",
"Tracker items allow comments?" => "Sallitaanko kortiston osien kommentointi?",
"and display comments in listing?" => "ja näyttää kommentit listauksessa?",
"Tracker items allow attachments?" => "Sallitaanko kortiston osien liitteet?",
"and display attachments in listing?" => "ja näyttää liitteet listauksessa?",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Liitteiden näyttö vaihtoehdot (Käytä numeroita osien järjestämiseen, 0 ei näytetä, ja negatiivinen näytetään popupeissa)",
"Filesize" => "Tiedostokoko",
"Filetype" => "Tiedostoyyppi",
"LongDesc" => "Pitkäkuvaus",
"Import/export trackers" => "Tuo/vie kortistoja",
"Admin groups" => "Ylläpidä ryhmiä",
"Admin users" => "Ylläpidä käyttäjiä",
"Add new group" => "Lisää uusi ryhmä",
"Edit group" => "Muokkaa ryhmää",
"Members" => "Jäsenet",
"Add a New Group" => "Lisää uusi ryhmä",
"List of existing groups" => "Lista olemassa olevista ryhmistä",
"Includes" => "Sisältää",
"Group Homepage" => "Ryhmä Etusivu",
"Use wiki page name or full URL" => "Käytä sivunnimeä tai koko URL polkua",
"Group Information Tracker" => "Ryhmä Tietojen Kortisto",
"choose a group tracker ..." => "valitse ryhmä kortisto ...",
"choose a field ..." => "valitse kenttä ...",
"Users Information Tracker" => "Käyttäjän Tietojen Kortisto",
"choose a users tracker ..." => "valitse käyttäjien kortisto ...",
"Group tracker item : {\$groupitemid}" => "Ryhmitä kortisto osa : {\$groupitemid}",
"Edit Item" => "Muuta osaa",
"Group tracker item not found" => "Ryhmä kortiston osaa ei löydy",
"Members List" => "Jäsen luettelo",
"Remove from Group" => "Poista ryhmäsät",
"users in group" => "käyttäjät ryhmässä",
"CSV File" => "CSV Tiedosto",
"Add a New User" => "Lisää uusi käyttäjä",
"Rejected users" => "Poistetut käyttäjät",
"Reason" => "Syy",
"Edit user" => "Muokkaa käyttäjää",
"Edit Account Settings" => "Muokkaa tili asetuksia",
"to groups" => "ryhmiin",
"Edit Included Group" => "Muokkaa sisällytettyä ryhmää",
"Change user preferences" => "Muuta käyttäjän asetuksia",
"Manage Group Assignments" => "Hallitse ryhmä liitoksia",
"Set Default Groups" => "Aseta oletus ryhmät",
"Assign selected to" => "Liitä valitut",
"Remove selected from" => "Poista valitut",
"the following groups:" => "seuraaviin ryhmistä:",
"Tip: Hold down CTRL to select multiple" => "Vihje: paina CTRL alas valitaksesi useampia",
"Set the default group of the selected users to" => "Aseta valittujen käyttäjien oletusryhmä->",
"bcc" => "varmuuskopio",
"User tracker item : {\$usersitemid}" => "Käyttäjän kortiston osa : {\$usersitemid}",
"Overwrite" => "Päällekirjoita",
"Source" => "Lähde",
"Admin Article Types" => "Ylläpidä Artikkeli Tyyppejä",
"List of types" => "Listaa tyypit",
"Shows up in the drop down list of article types" => "Tulee näkyviin artikkeli tyyppien alasveto valikossa",
"Allow ratings by the author" => "Sallii arvostelun kirjoittajalta",
"Show before publish date" => "Näytä ennen julkaisu päivää",
"non-admins can view before the publish date" => "muut kuin ylläpito voivat nähdä ennen julkaisupäivää",
"Show after expire date" => "Näytä poistumis päivän jälkeen",
"non-admins can view after the expire date" => "muut kuin ylläpito voivat nähdä päättymispäivän jälkeen",
"Heading only" => "Vain pääosat",
"No article body, heading only" => "Ei artikkelirunkoa, vain pääosa",
"Allow comments for this type" => "Salli kommentit tälle tyypille",
"Comment Can Rate Article" => "Kommentti voi vauhdittaa Artikkelia",
"Allow comments to include a rating value" => "Salli kommentin sisältävän arvostus arvon",
"Show image" => "Näytä kuva",
"Show topic or own image" => "Näytä aihe tai kuva",
"Show avatar" => "Näytä hahmo",
"Show author's avatar" => "Näytä kirjoittajan hahmo",
"Show author" => "Näytä kirjoittaja",
"Show author name" => "Näytä kirjoittajan nimi",
"Show publish date" => "Näytä julkaisu päivä",
"Show expire date" => "Näytä poistumis päivä",
"Show reads" => "Lukijoita",
"Show the number of times the article was read" => "Näytä montako kertaa artikkeli on luettu",
"Show size" => "Näytä koko",
"Show the size of the article" => "Näytä artikkelin koko",
"Show topline" => "Näytä ylärivi",
"Show a small title over the title" => "Näytä pieni aihe varsinaisen aiheen yläpuolella",
"Show subtitle" => "Näytä alaotsikko",
"Show the subtitle" => "Näytä Alaotsikko",
"Show source" => "Näytä lähde",
"Show link to source after article body" => "Näytä lähteen linkki artikkelin lopussa",
"Show Image Caption" => "Näytä KuvaTeksti",
"Show a legend under the image" => "Näytä seloste kuvan alla",
"Show Language" => "Näytä Kieli",
"Show the language" => "Näytä kieli",
"Creator can edit" => "Luoja voi muokata",
"The person who submits an article of this type can edit it" => "Henkilö, joka lähettää tämän tyypin artikkelin voi myös muokata sitä",
"Show lang" => "Näytä kieli",
"Review" => "EsiKatselu",
"Classified" => "Luokiteltu",
"Create a new type" => "Luo uusi tyyppi",
"Group Information" => "Ryhmän Tiedot",
"level" => "taso",
"Create level" => "Luo taso",
"all permissions in level" => "kaikki oikeudet tasolla",
"Default Group" => "Oletus Ryhmä",
"Assign Perms to this Group" => "Anna oikeudet tälle ryhmälle",
"backlinks to" => "paluulinkit",
"No backlinks to this page" => "Ei paluulinkkejä tälle sivulle",
"Directory batch upload" => "Hakemisto ryhmä lataus",
"Browse Gallery" => "Selaa galleriaa",
"Upload From Disk" => "Lähetä kovalevyltä",
"available images" => "saatavilla olevat kuvat",
"Remove File Extension from Image Name" => "Poista tiedostopääte kuvan nimestä",
"eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "esim. \"digicam0001.jpg\" joten nimeä digicam0001 käytetään nimikentässä",
"Select a Gallery" => "Valitse Galleria",
"Process" => "Prosessi",
"Edit Post" => "Muokkaa lähetystä",
"View Blog" => "Näytä blogi",
"Use ...page... to separate pages in a multi-page post" => "Käytä ...sivu... erotellaksesi sivut monisivuisessa lähetyksessä",
"Upload image for this post" => "Lähetä kuva tähän lähetykseen",
"Trash" => "Roskis",
"Mark entry as private:" => "Merkitse sisäänpääsy yksityiseksi:",
"Spellcheck" => "Oikeinkirjoitus",
"Save and Exit" => "Tallenna ja poistu",
"Made with" => "Tehty",
"powered by" => "moottorina",
"Execution time" => "Ajo aika",
"Memory usage" => "Muistin käyttö",
"Server load" => "Palvelin kuorma",
"Admin Category" => "Ylläpidä luokittelua",
"Admin the Category System" => "Ylläpidä luokka järjestelmää",
"Browse in" => "Selaa",
"Trackers Items" => "Kortiston Osia",
"Sheets" => "Arkit",
"Hide subcategories objects" => "Piilota aliluokkien kohteet",
"Show subcategories objects" => "Näytä aliluokkien kohteet",
"Upper level" => "Ylempi taso",
"Clear" => "Tyhjennä",
"List Galleries" => "Listaa galleriat",
"Edit Gallery" => "Muokkaa galleriaa",
"Rebuild Thumbnails" => "Rakenna minikuvat",
"Directory Batch" => "Hakemisto erä",
"List Gallery" => "Listaa galleria",
"Monitor this Gallery" => "Tarkkaile tätä galleriaa",
"Stop Monitoring this Gallery" => "Lopeta tämän gallerian tarkkailu",
"Sort Images by" => "Lajittele Kuvat",
"subgallery" => "aligalleria",
"Subgallery" => "Aligalleria",
"Hit" => "Osuma",
"Original Size" => "Alkuperäinen kuva",
"rotate right" => "pyöritä oikealle",
"rotate" => "pyöritä",
"Details" => "Yksityiskohdat",
"You can include the image in a tiki page using one of these lines" => "Voit käyttää kuvaa normaali sivulla käyttäen yhtä näistä riveistä",
"Return to Gallery" => "Palaa galleriaan",
"Edit Image" => "Muokkaa Kuvaa",
"First Image" => "Ensimmäinen kuva",
"Prev Image" => "Edellinen kuva",
"Smaller" => "Pienempi",
"Bigger" => "Suurempi",
"Popup window" => "Popup ikkuna",
"Next Image" => "Seuraava kuva",
"Slideshow Forward" => "Kuvaesitys eteenpäin",
"Last Image" => "Viimeisin kuva",
"Direction" => "Suunta",
"Click to zoom" => "Paina, zoom",
"Image Name" => "Kuvan Nimi",
"Image Scale" => "Kuvamuunnos",
"Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/desimaali astetta)",
"Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/desimaali astetta)",
"Move image" => "Siirrä kuva",
"You can view this image in your browser using" => "Voit katsoa kuvaa selaimessasi käyttäen",
"You can include the image in an HTML page using one of these lines" => "Voit käyttää kuvaa HTML sivulla, käyttämällä yhtä näistä riveistä",
"Stop Monitoring this Page" => "Lopeta tämän sivun tarkkailu",
"Monitor this Page" => "Tarkkaile tätä sivua",
"Group Calendars" => "Ryhmä Kalenterit",
"Organized by" => "Järjestänyt",
"Tentative" => "Alustava",
"Confirmed" => "Hyväksytty",
"Cancelled" => "Peruttu",
"Change Focus" => "Muuta keskitystä",
"Edit Calendar Item" => "Muokkaa Kalenterin Osaa",
"New Calendar Item" => "Uusi Kalenterin Osa",
"times" => "kertaa",
"End" => "Loppu",
"Roles" => "Tehtävät",
"Calendar import" => "Tuo kalenteri",
"Calendar has been updated" => "Kalenteri on päivitetty",
"import" => "tuo",
"Previous" => "Edellinen",
"Assign permissions to category" => "Anna oikeudet luokalle",
"Current permissions for this category" => "Luokan nykyiset oikeudet",
"Remove from this Category Only" => "Poista vain tästä luokasta",
"Remove from this Category &amp; all its Children" => "Poista tästä luokasta &amp; ja kaikki alaluokat",
"Assign permissions" => "Liitä oikeudet",
"to group" => "ryhmälle",
"this category &amp; all its children" => "tämä luokka &amp; ja kaikki alaluokat",
"this category only" => "vain tämä luokka",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "Anna oikeudet <b>kaikille alaluokille</b> paras tehokkuus.",
"Change password enforced" => "Vaihda salasana pakottamatta",
"Change your password" => "Muuta salasanasi",
"Old password" => "Vanha salasana",
"Send a message to us" => "Lähetä meille viesti",
"Contact us by email" => "Ota yhteyttä sähköpostilla",
"Click here to send us an email" => "Paina, lähettääksesi meille sähköpostia",
"Contacts" => "Yhteydet",
"Create/edit contacts" => "Luo/muokkaa yhteyksiä",
"First Name" => "Etu Nimi",
"Last Name" => "SukuNimi",
"Nickname" => "Lempinimi",
"You can browse the generated WebHelp here" => "Voit selata WebApua tästä",
"Structure" => "Rakenne",
"Top page" => "Ylin sivu",
"Current URL" => "Nykyinen URL",
"Command" => "Komento",
"exec" => "suorita",
"Type <code>help</code> to get list of available commands" => "Kirjoita <code>help</code> saadaksesi listan komennoista",
"Add a new site" => "Lisää uusi sivusto",
"You cannot add sites until Directory Categories are setup." => "Et voi lisätä sivustoja ennen kuin Hakemisto Luokittelut on tehty.",
"Please contact the Site Administrator" => "Ota yhteyttä Sivuston Ylläpitäjään",
"Site added" => "Sivusto lisätty",
"Directory Administration" => "Hakemisto Ylläpito",
"There are" => "Siellä on",
"invalid sites" => "kelpaamaton sivusto",
"valid sites" => "hyväksytty sivusto",
"Users have visited" => "Käyttäjät vierailleet",
"sites from the directory" => "hakemiston sivustoilla",
"Users have searched" => "Käyttäjät etsineet",
"times from the directory" => "kertaa hakemistosta",
"Related" => "Liittyvä",
"Validate" => "Vahvista",
"Admin directory categories" => "Ylläpidä hakemisto luokitteluja",
"Add a directory category" => "Lisää hakemisto luokka",
"Edit this directory category" => "Muokkaa tätä hakemisto luokkaa",
"Children type" => "Ali tyyppi",
"Most visited sub-categories" => "Eniten vieraillut alaluokat",
"Category description" => "Luokan kuvaus",
"Random sub-categories" => "Satunnais alaluokka",
"Maximum number of children to show" => "Näytettävien alaluokkien maksimi määrä",
"Editor group" => "Muokkaa ryhmää",
"cType" => "cTyyppi",
"allow" => "salli",
"count" => "laske",
"editor" => "editori",
"relate" => "liitä",
"Parent category" => "Isäntä luokka",
"Add a related category" => "Lisää liittyvä luokka",
"Mutual" => "Samanlainen",
"Related categories" => "Asiaanliittyvät luokittelut",
"Admin sites" => "Ylläpidä sivustoja",
"Is valid" => "On hyväksytty",
"New Sites" => "Uudet sivustot",
"Cool Sites" => "Siistit sivustot",
"Add a Site" => "Lisää sivusto",
"any" => "mikävain",
"in entire directory" => "koko hakemisto",
"Sort by" => "Lajittele",
"name (desc)" => "nimi (aleneva)",
"name (asc)" => "nimi (nouseva)",
"hits (desc)" => "osumia (aleneva)",
"hits (asc)" => "osumia (nouseva)",
"creation date (desc)" => "luonti päivä (aleneva)",
"creation date (asc)" => "luonti päivä (nouseva)",
"last updated (desc)" => "viimeksi päivitetty (aleneva)",
"last updated (asc)" => "viimeksi päivitetty (nouseva)",
"Added" => "Lisätty",
"Last updated" => "Viimeksi päivitetty",
"Total links" => "Linkkejä kaikkiaan",
"Links to validate" => "Linkkejä hyväksyttäväksi",
"Searches performed" => "Etsintöjä suoritettu",
"Total links visited" => "Linkki vierailuja kaikkiaan",
"Directory ranking" => "Hakemisto arvostus",
"Search results" => "Etsintä tulokset",
"Validate sites" => "Hyväksy sivustot",
"Edit article" => "Muokkaa artikkelia",
"List Articles" => "Listaa Artikkelit",
"View Articles" => "Näytä artikkelit",
"One of the email addresses you typed is invalid" => "Jokin kirjoittamistasi sähköposti osoiteista on väärin",
"Topline" => "Ylärivi",
"Subtitle" => "Alaotsikko",
"Author Name" => "Kirjoittajan Nimi",
"Own Image" => "Oma Kuva",
"Article image" => "Artikkeli kuva",
"Use own image" => "Käytä omaa kuvaa",
"Float text around image" => "Kuljeta teksti kuvan ympäri",
"Own image size x" => "Oman kuvan koko x",
"Own image size y" => "Oman kuvan koko y",
"Image caption" => "Kuvateksti",
"Heading" => "Pääosa",
"Body" => "Runko",
"Publish Date" => "Julkaisu päivä",
"Expiration Date" => "Viimeinen Päivä",
"From:" => "Keneltä:",
"Edit or create banners" => "Muokkaa tai luo bannereita",
"List banners" => "Listaa bannerit",
"URL to link the banner" => "URL linkki banneriin",
"Client" => "Asiakas",
"Max impressions" => "Maksimi vaikutelmat",
"Show the banner only between these dates" => "Näytä banneri vain näiden päivämäärien välissä",
"From date" => "Alkaen päivästä",
"To date" => "Päättyen päivään",
"Use dates" => "Käytä päiviä",
"Show the banner only in this hours" => "Näytä banneri vain näinä tunteina",
"to" => " ",
"Show the banner only on" => "Näytä banneri vain",
"Mon" => "Maa",
"Tue" => "Tii",
"Wed" => "Kes",
"Thu" => "Tor",
"Fri" => "Per",
"Sat" => "Lau",
"Select ONE method for the banner" => "Valitse vain YKSI menetelmä",
"Use HTML" => "Käytä HTML",
"Use image" => "Käytä kuvaa",
"Image:" => "Kuva:",
"Current Image" => "Nykyinen Kuva",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Käytä URL osoitteesta luotua kuvaa (kuva haetaan URL osoitteesta jokaista näyttökertaa varten)",
"Use text" => "Käytä tekstiä",
"Save the Banner" => "Tallenna banneri",
"Remove Zones (you lose entered info for the banner)" => "Poista Alueet (menetät bannerin tiedot)",
"Create Blog" => "Luo Blogi",
"Current heading" => "Nykyinen pääosa",
"There are individual permissions set for this blog" => "Tähän blogiin on erityisoikeudet",
"Number of posts to show" => "Näytettävien lähetysten määrä",
"Allow other user to post in this blog" => "Salli muiden käyttäjien lähettää tähän blogiin",
"Use titles in blog posts" => "Käytä otsikoita blogi lähetyksissä",
"Allow search" => "Salli etsintä",
"Allow comments" => "Salli kommentit",
"Show user avatar" => "Näytä käyttäjän hahmo",
"Blog heading" => "Blogin pääosa",
"Edit Style Sheet" => "Muuta Tyyli Arkkia",
"Style Sheet" => "Tyyli Arkki",
"choose a stylesheet" => "valitse tyyliarkki",
"Try" => "Kokeile",
"Wiki Help" => "Wiki apu",
"Colored text" => "Värillinen teksti",
"Headings" => "Pääosat",
"Show/Hide" => "Näytä/Piilota",
"show/hide heading section. + (shown) or - (hidden) by default" => "näytä/piilota pääosat. + (näyttää) tai - (piilottaa) oletuksena",
"Box content" => "Laatikon sisältö",
"Dynamic variables" => "Muuttuvat muuttujat",
"Inserts an editable variable" => "Lisää muokattavan muuttujan",
"External links" => "Ulkoiset linkit",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "Ulkoiset Wikit, käytä ExternalWikiName:SivuNimi tai ((External Wiki Name: Sivu Nimi))",
"Square Brackets" => "HakaSulut",
"Use [[foo] to show [foo]." => "Käytä [[foo] näyttääksesi [foo].",
"Wiki References" => "Wiki Suositukset",
"JoinCapitalizedWords or use" => "JoinCapitalizedWords tai käytä",
"page|description" => "sivu|kuvaus",
"for wiki references" => "wiki suosituksia varten",
"SomeName" => "JokuNimi",
"prevents referencing" => "estää suositukset",
"Lists" => "Listat",
"for bullet lists" => "sisennettyjä listauksia varten",
"for numbered lists" => "numeroituja listauksia varten",
"for definiton lists" => "määrittely listauksia varten",
"Tables" => "Taulukot",
"Title bar" => "Otsikko palkki",
"Line break" => "Rivin katkaisu",
"(very useful especially in tables)" => "(erittäin käyttökelpoinen taulukoissa)",
"creates the editable drawing foo" => "luo muokattavat piirroksen",
"Multi-page pages" => "MoniSivu sivut",
"Non parsed sections" => "Jäsentämättömät osastot",
"Prevents wiki parsing of the enclosed data." => "Estää sivustoa jäsentämästä oheista tietuetta.",
"Preformated sections" => "Esimuotoillut osastot",
"Block Preformatting" => "Estä Esimuotoilu",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Tee sisennys sanavälejä lisäten muuttaaksesi sen tasalevyiseksi plokiksti joka muutoin tekee muotoilut. Sisennys tehdään sen mukaan montako sanaväliä on käytetty.  Huomaa, että tämä muoto ei säilytä tarkkoja välejä eikä rivivaihtoja; käytä ~pp~...~/pp~ siihen.",
"No description available" => "Ei kuvausta saatavilla",
"table" => "taulukko",
"table new" => "uusi taulukko",
"external link" => "ulkoinen linkki",
"wiki link'" => "linkki'",
"heading1" => "pääosa1",
"title bar" => "aihe palkki",
"box" => "laatikko",
"rss feed" => "rss syöte",
"dynamic content" => "muuttuva sisältö",
"tagline" => "tagirivi",
"center text" => "keskitä teksti",
"colored text" => "värillinen teksti",
"dynamic variable" => "muuttuva muuttuja",
"New wms Metadata" => "Uusi wms Metadata",
"New Class" => "Uusi Class",
"New Projection" => "Uusi Arvio",
"New Query" => "Uusi Kysely",
"New Scalebar" => "Uusi Muutospalkki",
"New Layer" => "Uusi Taso",
"New Label" => "Uusi Etiketti",
"New Reference" => "Uusi Viittaus",
"New Legend" => "Uusi Seloste",
"New Web" => "Uusi Verkko",
"New Outputformat" => "Uusi Tulostumuoto",
"New Mapfile" => "Uusi Karttatiedosto",
"special chars" => "erikoismerkit",
"special characters" => "erikois merkit",
"Browse Images" => "Katso kuva",
"Edit successful!" => "Muutos onnistui!",
"The following image was successfully edited" => "Seuraava kuva on onnistuneesti muutettu",
"Image Description" => "Kuvan Kuvaus",
"Edit and create Languages" => "Muuta ja luo Kieliä",
"Edit and create languages" => "Muuta ja luo kieliä",
"Create Language" => "Luo Kieli",
"Shortname" => "Lyhytnimi",
"like" => "kuten",
"Longname" => "Pitkänimi",
"Select the language to edit" => "Valitse muokattava kieli",
"Add a translation" => "Lisää käännös",
"Edit translations" => "Muuta käännöstä",
"Translate recorded" => "Käännös taltioitu",
"Translation" => "Käännös",
"reset table" => "nollaa taulukko",
"Create New Block" => "Luo uusi blokki",
"Return to block listing" => "Palaa blokki listaukseen",
"Block description: " => "Blokin kuvaus: ",
"You are editing block:" => "Olet muuttamassa blokkia:",
"Publishing date" => "Julkaisu päivä",
"Publishing Date" => "Julkaisu Päivä",
"Edit question options" => "Muokkaa kysymys vaihtoehtoja",
"List Quizzes" => "Listaa Visailut",
"Quiz Stats" => "Visailu Tilastot",
"This Quiz Stats" => "Tämän visailut tilasto",
"Edit this Quiz" => "Muuta tätä visailua",
"Admin Quizzes" => "Ylläpidä visailuja",
"Create/edit options for question" => "Luo/muuta kysymys vaihtoehtoja",
"Create/edit quizzes" => "Luo/muuta visailuja",
"There are individual permissions set for this quiz" => "Visailulle on asetettu erikoisoikeudet",
"Quiz can be repeated" => "Visailun voi toistaa",
"Store quiz results" => "Tallenna visailu tulokset",
"Immediate feedback" => "Välitön palaute",
"Show correct answers" => "Näytä oikeat vastaukset",
"Shuffle questions" => "Sekoita kysymykset",
"Shuffle answers" => "Sekoita vastaukset",
"Questions per page" => "Kysymyksiä per sivu",
"Quiz is time limited" => "Visailulla on aikaraja",
"Maximum time" => "Maksimi aika",
"Passing Percentage" => "Läpäisy Prosentti",
"Quiz" => "Visailu",
"canRepeat" => "voiToistaa",
"timeLimit" => "aikaRaja",
"Edit quiz questions" => "Muuta visailun kysymyksiä",
"Create/edit questions for quiz" => "Luo/muuta visailun kysymyksiä",
"Question Type" => "Kysymyksen Tyyppi",
"Import questions from text" => "Tuo kysymykset tekstinä",
"Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Ohjeet: Kirjoita, tai liitä, monivalinta kysymyksesi alle.  Yksi kysymys riviä kohti, aloita vastaus vaihtoehdot seuraaville riveille.  Erottele lisäkysymykset tyhjällä rivillä.  Merkitse oikea vastaus aloittamalla rivi \"*\" (ilman lainausmerkkejä) merkillä.",
"Input" => "Syötä",
"maxScore" => "maxTilanne",
"From Points" => "Pisteistä",
"To Points" => "Pisteiksi",
"Answer" => "Vastaus",
"Modify Structure" => "Muokkaa Rakennetta",
"You will remove" => "Sinä poistat",
"and its subpages from the structure, now you have two options:" => "ja sen alasivut rakenteesta, nyt sinulla on kaksi vaihtoehtoa:",
"Remove only from structure" => "Poista vain rakenteesta",
"Remove from structure and remove page too" => "Poista rakenteesta ja poista myös sivu",
"Structure Layout" => "Rakenteen Layout",
"Promote" => "Mainosta",
"Demote" => "Alenna",
"Current Node" => "Nykyinen Solmu",
"Page alias" => "Sivun lisänimi",
"Add pages to current node" => "Lisää sivuja nykyiseen solmuun",
"After page" => "Sivun jälkeen",
"Create Page" => "Luo sivu",
"Use pre-existing page" => "Käytä aiemmin ollutta sivua",
"Submit article" => "Lähetä artikkeli",
"List Submissions" => "Listaa ehdotukset",
"<b>*</b>=optional" => "<b>*</b>=vaihtoehtoinen",
"<b>Topline</b>=small line above Title" => "<b>Ylärivi</b>=pieni rivi Aiheen yllä",
"<b>Subtitle</b>=small line below Title" => "<b>Alaotsikko</b>=pieni rivi Aiheen alla",
"<b>Source</b>=URL to article source" => "<b>Lähde</b>=artikkeli lähteen URL osoite",
"Edit templates" => "Muuta mallia",
"Template listing" => "Malli listaus",
"Available templates" => "Saatavilla olevat mallit",
"Save Only in the Theme:" => "Tallenna vain teemaan:",
"Delete the copy in the theme:" => "Poista kopio teemasta:",
"Edit a topic" => "Muuta aihe",
"View Page" => "Näytä Sivu",
"You must specify the object language" => "On valittava kohde kieli",
"The object doesn't exist" => "Kohdetta ei ole",
"The object doesn't have a language" => "Kohteella ei ole kieltä",
"The object has already a translation for this language" => "Kohteella on jo käännös tällä kielellä",
"The object is already in the set of translations" => "Kohde on jo kieliluettelossa",
"detach" => "erota",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Hiekkalaatikko on sivu jolla voi harjoitella sivun muokkaus taitoja, käyttää mahdollisuutta katsoa eri kokeiluja, mitään versiota tästä sivusta ei tallenneta.",
"Admin Content Templates" => "Ylläpidä sisältö malleja",
"Use rating" => "Käytä arvostelua",
"There is no available poll template." => "Ei ole saatavilla äänestys mallia.",
"You should ask an admin to create them." => "Pyydä ylläpitoa luomaan ne.",
"an existing poll" => "olemassa oleva äänestys",
"votes" => "ääniä",
"Case Insensitivity" => "Voi olla isot tai pienet",
"My Footnotes" => "Omat Alaviitteet",
"Year:" => "Vuosi:",
"Authors:" => "Kirjoittajat:",
"Try to convert HTML to wiki" => "Yritä muuttaa HTML normaali sivuksi",
"Import page" => "Tuo sivu",
"export all versions" => "vie kaikki versiot",
"Upload picture" => "Lähetä kuva",
"License" => "Lisenssi",
"Important" => "Tärkeää",
"Graph" => "Graafi",
"status" => "tila",
"lastModif" => "viimeksiMuokannut",
"Dump" => "Dumppi",
"Admin FAQ" => "Ylläpidä UKK:ä",
"List FAQs" => "Listaa UKK:t",
"View FAQ" => "Näytä UKK",
"Edit this FAQ" => "Muuta tätä UKK:ta",
"New Question" => "Uusi kysymys",
"Use a question from another FAQ" => "Käytä kysymystä toisesta UKK:sta",
"FAQ questions" => "UKK kysymykset",
"Suggested questions" => "Ehdotetut kysymykset",
"No suggested questions" => "Ei ehdotettuja kysymyksiä",
"Upload File" => "Lähetä Tiedosto",
"View tpl" => "Näytä tpl",
"File Galleries tpl" => "Tiedosto Galleria tpl",
"You can access the file gallery using the following URL" => "Pääset käsiksi tiedosto galleriaan seuraavasta URL:sta",
"Admin forums" => "Ylläpidä foorumit",
"Edit queued message" => "Muokkaa jonottavia viestejä",
"make this a thread of" => "Laita tämä ketju",
"None, this is a thread message" => "EiMitään, tämä on ketjuviesti",
"summary" => "yhteenveto",
"normal" => "normaali",
"announce" => "tiedote",
"hot" => "kuuma",
"no feeling" => "ei tunnetta",
"frown" => "paheksuva",
"exclaim" => "huudahdus",
"mad" => "vihainen",
"neutral" => "neutraali",
"question" => "kysymys",
"sad" => "surullinen",
"happy" => "onnellinen",
"wink" => "silmänisku",
"Save and Approve" => "Tallenna ja hyväksy",
"convert to topic" => "muuta aiheeksi",
"List of messages" => "Lista viesteistä",
"New Topic" => "Uusi aihe",
"no summary" => "ei yhteenvetoa",
"No messages queued yet" => "Ei viestejä jonossa vielä",
"Last Post" => "Viimeinen lähetys",
"Configure Forum" => "Foorumin kokoonpano",
"Reported by" => "Raportoijana",
"Pending requests" => "Odotus pyynnöt",
"Request Time" => "Pyyntö Aika",
"Accept" => "Hyväksy",
"Refuse" => "Hylkää",
"Waiting requests" => "Odottavat pyynnöt",
"Your friends" => "Ystäväsi",
"break friendship" => "riko ystävyys",
"Activity completed" => "Toiminto valmis",
"Admin process activities" => "Ylläpidä prosessi toimintoja",
"To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "Oppiaksesi lisää <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
"Add or edit an activity" => "Lisää tai muokkaa toimintoa",
"activity" => "toiminto",
"split" => "jaa",
"join" => "liity",
"standalone" => "itsenäinen",
"interactive" => "vuorovaikutteinen",
"auto routed" => "autom reititetty",
"Expiration Time" => "PäättymisAika",
"Years" => "Vuotta",
"Months" => "Kuukautta",
"Hours" => "Tuntia",
"Minutes" => "Minuuttia",
"Add transitions" => "Lisää siirtymä",
"Add transition from:" => "Lisää siirtymä:",
"Add transition to:" => "Lisää siirtymä:",
"No roles associated to this activity" => "Tähän toimintoon ei liity tehtäviä",
"Add Role" => "Lisää tehtävä",
"Add New" => "Lisää uusi",
"Process activities" => "Prosessi toiminnot",
"Routing" => "Reititys",
"Interactive" => "vuorovaikutteinen",
"Automatic" => "Automaattisesti",
"Auto routed" => "Autom reititetty",
"Manual" => "Käsin",
"route" => "reitti",
"(no roles)" => "(ei tehtäviä)",
"No activities defined yet" => "Ei määritelytjä toimintoja vielä",
"Process Transitions" => "Prosessin Siirrot",
"List of transitions" => "Lista siirroista",
"Origin" => "Alkup",
"No transitions defined yet" => "Ei määriteltyjä siirtoja vielä",
"Add a transition" => "Lisää siirto",
"Process Graph" => "Menetelmä Käyrä",
"Galaxia Admin Graph" => "Galaxia Ylläpito Käyrä",
"Galaxia Admin Graph tpl" => "Galaxia Ylläpito Käyrä tpl",
"Edit Tpl" => "Muuta tpl",
"This process is invalid" => "Tämä prosessi ei toimi",
"Process Graph for" => "Menetelmä Käyrä",
"No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "Ei sellaista käyrää saatavilla. Menetelmä sisältää virheitä, käyrää ei luotu vielä, tai <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> ei ole asennettu.",
"List of processes" => "Listaa prosessit",
"Inactive" => "EiAktiivinen",
"act" => "toi",
"val" => "arv",
"Active Process" => "Aktiivinen prosessi",
"Invalid Process" => "Toimimaton prosessi",
"Valid Process" => "Toimiva prosessi",
"Activities" => "Toiminnot",
"New Minor" => "Uusi pieni",
"New Major" => "Uusi iso",
"No processes defined yet" => "Ei määriteltyä prosessia vielä",
"Admin instance" => "Ylläpidä tapauksia",
"Process:" => "Prosessi:",
"Instance" => "Tapaus",
"Workitems" => "Työkohteet",
"exception" => "poikkeus",
"completed" => "valmis",
"Aborted" => "Keskeytetty",
"Owner" => "Omistaja",
"Send all to" => "Lähetä kaikille",
"Don't move" => "Älä siirrä",
"Started" => "Aloitettu",
"Act status" => "Act tila",
"Ended" => "Loppu",
"Not Defined" => "Ei Määritelty",
"Not Interactive" => "Ei Vuorovaikutteinen",
"Not Ended" => "Ei Lopussa",
"Property" => "Ominaisuus",
"Add property" => "Lisää ominaisuus",
"run instance" => "aja pyyntö",
"Executed" => "Käynnistetty",
"erase" => "hävitä",
"Admin processes" => "Ylläpidä prosesseja",
"Galaxia Admin Processes" => "Ylläpidä Galaxia Prosesseja",
"Galaxia Admin Processes tpl" => "Ylläpidä Galaxia Prosessi tpl",
"Add or edit a process" => "Lisää tai muokkaa prosessia",
"Process Name" => "Prosessin Nimi",
"is active?" => "onko aktiivinen?",
"Or upload a process using this form" => "Tai lähetä prosessi käyttäen tätä lomaketta",
"Admin process roles" => "Ylläpidä prosessi tehtäviä",
"Add or edit a role" => "Lisää tai muokkaa tehtävää",
"Process roles" => "Prosessin tehtävät",
"No roles defined yet" => "Ei määriteltyjä tehtäviä vielä",
"Map users to roles" => "Kartoita käyttäjät tehtäviin",
"map" => "kartta",
"Map groups to roles" => "Kartoita ryhmät tehtäviin",
"Operation" => "Toimenpide",
"No roles are defined yet so no roles can be mapped" => "Tehtäviä ei ole määritelty vielä, joten tehtäviä ei voi kartoittaa",
"List of mappings" => "Lista kartoituksista",
"No mappings defined yet" => "Ei kartoituksia määritelty vielä",
"Admin process sources" => "Ylläpidä prosessin lähteitä",
"select source" => "valitse lähde",
"Shared code" => "Jaettu koodi",
"Set next user" => "Aseta seuraava käyttäjä",
"Get property" => "Ota ominaisuus",
"Set property" => "Aseta ominaisuus",
"Process form" => "Prosessi lomake",
"Set Next act" => "Aseta Seuraava toiminto",
"If:SetNextact" => "Jos:AsSeutoim",
"Switch construct" => "Vaihda käsite",
"Map process roles" => "Kartoita prosessin tehtävät",
"Admin Processes" => "Ylläpidä prosesseja",
"Admin Activities" => "Ylläpidä toimintoja",
"Admin Roles" => "Ylläpidä tehtäviä",
"Edit this Process" => "Muuta tätä prosessia",
"Monitor Activities" => "Tarkkaile toimintoja",
"Galaxia Monitor Activities" => "Galaxia Tarkkaile Toimintoja",
"Galaxia Monitor Activities tpl" => "Galaxia Tarkkaile Toiminto tpl",
"List of activities" => "Lista toiminnoista",
"Proc" => "Pros",
"routing" => "reititys",
"Instances" => "Pyyntö",
"run" => "aja",
"run activity" => "aja toiminto",
"Enter the name of this instance" => "Anna pyynnön nimi",
"The name is not valid. Please, enter the name again" => "Nimi ei kelpaa. Anna nimi uudelleen",
"Monitor" => "Tarkkale",
"monitor processes" => "tarkkaile prosesseja",
"monitor activities" => "tarkkaile toimintoja",
"monitor instances" => "tarkkaile pyyntöjä",
"monitor workitems" => "tarkkaile työkohteita",
"Monitor Instances" => "Tarkkaile pyyntöjä",
"Galaxia Monitor Instances" => "Galaxia Tarkkaile Pyyntöjä",
"Galaxia Monitor Instances tpl" => "Galaxia Tarkkail Pyyntöjen tpl",
"List of instances" => "Lista pyyntöjä",
"Not ended" => "Ei lopussa",
"No instances created yet" => "Ei pyyntöjä luotu vielä",
"Monitor Processes" => "Tarkkaile prosesseja",
"Galaxia Monitor Processes" => "Galaxia Tarkkaile Prosesseja",
"Galaxia Monitor Processes tpl" => "Galaxia Tarkkaile Prosessien tpl",
"processes" => "prosessit",
"being run" => "on käynnissä",
"Completed" => "Valmis",
"Exceptions" => "Poikkeukset",
"Monitor workitems" => "Tarkkaile työkohteita",
"List of workitems" => "Listaa työkohteet",
"instance" => "pyyntä",
"Instance Id" => "Esimerkki Id",
"Instance Name" => "Esimerkki Nimi",
"Instance Status" => "Esimerkin Tila",
"Elapsed time" => "Kulunut aika",
"My activities" => "Omat toiminnot",
"Current Activity" => "Nykyinen Toiminto",
"Assigned To" => "Liitetty",
"exception instance" => "poikkeus pyyntö",
"exceptions instance" => "pyyntö poikkeukset",
"Send Instance" => "Lähetä pyyntö",
"abort instance" => "keskeytä pyyntö",
"grab instance" => "nappaa pyyntö",
"release instance" => "vapauta pyyntö",
"No activities found" => "Ei löydy toimintoja",
"My instances" => "Omat pyynnöt",
"No instances found" => "Ei löydy pyyntöjä",
"User Activities" => "Käyttäjä Toiminnot",
"Galaxia User Activities" => "Galaxia Käyttäjä Toiminnot",
"Galaxia User Activities tpl" => "Galaxia Käyttäjä Toiminnot tpl",
"process" => "prosessi",
"No processes defined or activated yet" => "Prosessia ei ole määritelty tai se ei ole aktiivinen",
"user processes" => "käyttäjä prosessit",
"user activities" => "käyttäjä toiminteet",
"user instances" => "käyttäjä pyynnöt",
"User Instances" => "Käyttäjä pyynnöt",
"Galaxia User Instances" => "Galaxia Käyttäjä Pyynnöt",
"Galaxia User Instances tpl" => "Galaxia Käyttäjä Pyyntö tpl",
"Inst Status" => "Pyynt Tila",
"Not defined" => "Ei määritelty",
"No instances defined yet" => "Ei määriteltyjä pyyntöjä vielä",
"User Processes" => "Käyttäjä prosessit",
"Galaxia User Processes" => "Galaxia Käyttäjä Prosessit",
"Galaxia User Processes tpl" => "Galaxia Käyttäjä Prosessi tpl",
"Browsing Workitem" => "Selataan Työkohteita",
"Workitem information" => "Työkohteen tiedot",
"Galleries" => "Galleriat",
"Create New Gallery" => "Luo uusi galleria",
"Create a gallery" => "Luo galleria",
"Edit this gallery:" => "Muokkaa tätä galleriaa:",
"There are individual permissions set for this gallery" => "Tälle gallerialle on asetettu erikoisoikeudet",
"Geographic" => "Maantieteellinen",
"Fields to show during browsing the gallery" => "Kentät jotka näytetään selattaessa galleriaa",
"Creation Date" => "Luonti Päivä",
"XY-Size" => "XY-Koko",
"Gallery Image" => "Galleria Kuva",
"Available scales" => "Saatavat muutokset",
"Bounding box" => "Ympäröivä laatikko",
"default scale" => "oletus koko",
"No scales available" => "Ei muutoksia tarjolla",
"Original image is default scale" => "Alkuperäinen kuva on oletuskoko",
"Add scaled images with bounding box of square size" => "Lisää muunnetut kuvat suorakaide laatikkoon",
"Other users can upload images to this gallery" => "Muut käyttäjät voivat lähettää kuvia tähän galleriaan",
"You can access the gallery using the following URL" => "Voit päästä käsiksi galleriaan seuraavasta URL:sta",
"Available Galleries" => "Saatavilla olevat Galleriat",
"Choose a filter" => "Valitse suodin",
"Imgs" => "Kuvia",
"Make Map" => "Tee Kartta",
"Select Graphic Type" => "Valitse Grafiikan Tyyppi",
"Pie Chart" => "Piirakka kaavio",
"Multiline" => "Monilinjainen",
"Multibar" => "Monipalkki",
"Bar Stack" => "Palkki Pino",
"Landscape" => "Vaakamalli",
"Portrait" => "Pystymalli",
"Independant Scale" => "Riippumaton Muunnos",
"Horizontal Scale" => "Vaakasuora Muunnos",
"Bottom" => "Alaosa",
"Vertical Scale" => "Pystysuora Muunnos",
"Series" => "Sarjat",
"Im- Export languages" => "Tuo- Vie kieliä",
"Select the language to Import" => "Valitse tuotava kieli",
"Select the language to Export" => "Valitse vietävä kieli",
"Import From File" => "Tuo Tiedostosta",
"Grab Wiki Tables" => "Tartu Taulukkoon",
"Import pages from a Structured Text Dump" => "Tuo sivuja Teksti Dumpista jossa on rakenne",
"Name of the dump file (it has to be in dump/)" => "Dumpin nimi (on oltava dumpissa/)",
"Overwrite existing pages if the name is the same" => "Päällekirjoitetaan jos tuotavalla sivulla on sama nimi",
"Previously remove existing page versions" => "Poista aiemmin olemassa olevat sivuversiot",
"excerpt" => "ote",
"Result" => "Tulos",
"body" => "runko",
"Locked" => "Lukittu",
"User name:" => "Käyttäjä nimi:",
"Install" => "Asenna",
"Configure General Settings" => "Yleiset Asetukset",
"Clear cached version and refresh cache" => "Poista puskuroidut versiot ja päivitä puskuri",
"configure rules" => "kokoonpano säännöt",
"Edit Repository" => "Muuta tallennuspaikka",
"Last Changes" => "Viimeiset Muutokset",
"Search by Date" => "Etsintä Päiväyksen mukaan",
"LastChanges" => "ViimeisetMuutokset",
"Rollback" => "Taaksekelaus",
"Pages like" => "Sivut kuin",
"No pages found" => "Ei löytynyt sivuja",
"Edit New Article" => "Muuta uutta artikkelia",
"View Submissions" => "Näytä ehdotukset",
"ExpireDate" => "PoistumisPäivä",
"AuthorName" => "KirjoittajaNimi",
"To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "Käyttääksesi <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduulia</a> tai mallia, käytä {literal}{banner zone=ABC}{/literal}, missä ABC on alueen nimi.",
"Create banner" => "Luo banneri",
"Method" => "Menetelmä",
"Use Dates?" => "Käytä Päiväystä?",
"Max Impressions" => "Max Vaikutelmat",
"Impressions" => "Vaikutelmat",
"Clicks" => "Klikkejä",
"Create New Blog" => "Luo uusi blogi",
"Use cache for external pages" => "Käytä puskuria ulkoisille sivuille",
"Dynamic content system" => "Muuttuvan sisällön järjestelmä",
"To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "Käyttääksesi sisältö plokkeja tekstialueella (sivulla, jne), <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduuli</a> tai malli, käytä {literal}{content id=x}{/literal}, missä x on sisältöplokin ID.",
"Available content blocks" => "Saatavilla olevat blokit",
"Current ver" => "Nykyinen ver",
"Next ver" => "Seuraava ver",
"Future vers" => "Tulevaisuuden versiot",
"Program" => "Ohjelma",
"Edit this FAQ:" => "Muuta tätä UKK:ta:",
"Create new FAQ" => "Luo uusi UKK",
"Create New FAQ:" => "Luo Uusi UKK:",
"Users can suggest questions" => "Käyttäjät voivat ehdottaa kysymyksiä",
"Available FAQs" => "Saatavilla olevat UKK:t",
"Create a File Gallery" => "Luo tiedosto galleria",
"optional" => "vaihtoehtoinen",
"Gallery Images" => "Gallerian Kuvat",
"All games are from" => "Kaikki pelit ovat",
"visit the site for more games and fun" => "käy sivustolla, lisää pelejä ja hauskaa",
"Upload a game" => "Lähetä peli",
"Upload a new game" => "Lähetä uusi peli",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Minikuva (jos peli on foo.swf minikuva on nimettävä foo.swf.gif tai foo.swf.png tai foo.swf.jpg)",
"Edit game" => "Muokkaa peliä",
"Played" => "Pelattu",
"If you can't see the game then you need a flash plugin for your browser" => "Jos et nää peliä, tarvitset flash-plugin selaimeesi",
"Edit Blog" => "Muokkaa Blogia",
"Blog Title" => "Blogin Otsikko",
"Edit New Submission" => "Muuta uutta ehdotusta",
"Survey stats" => "Tutkimus tilastot",
"Take Survey" => "Ota tutkimus",
"users registered" => "käyttäjät rekisteröityneet",
"Distance (km)" => "Suunta (km)",
"List Movies" => "Listaa Elokuvat",
"Choose a movie" => "Valitse elokuva",
"Last mod" => "Viimeksi muok",
"Last modification" => "Viimeisin muokkaus",
"Last author" => "Viimeisin kirjoittaja",
"Last version" => "Viimeisin versio",
"unlocked" => "lukitsematon",
"Open client window" => "Avaa asiakas ikkuna",
"Generate HTML" => "Muodosta HTML",
"Transcripts" => "Käsikirjoitukset",
"Online operators" => "Online operaattorit",
"Operator" => "Operaattori",
"Accepted requests" => "Hyväksytyt pyynnöt",
"since" => "jälkeen",
"transcripts" => "käsikirjoitukset",
"Offline operators" => "Offline operaattorit",
"Add an operator to the system" => "Lisää operaattori järjestelmään",
"Operators must be tiki users" => "Operaattorin oltava sivuston jäsen",
"Set as Operator" => "Aseta operaattoriksi",
"Chat started" => "Juttelu aloitettu",
"Operator:" => "Operaatori:",
"Live support:User window" => "Elävä tuki:Käyttäjän ikkuna",
"Request live support" => "Pyydä elävä tuki",
"Request support" => "Pyydä tukea",
"Open a support ticket instead" => "Avaa sen sijaan tukilippu",
"Your request is being processed" => "Pyyntösi on käsitelty",
"cancel request and exit" => "peruuta pyyntö ja poistu",
"cancel request and leave a message" => "peruuta pyyntö ja jätä viesti",
"Live support:Console" => "Elävä tuki:Konsoli",
"be online" => "pysy linjalla",
"be offline" => "poissa linjalta",
"Support requests" => "Tukee pyyntöjä",
"Requested" => "Pyydetty",
"Join" => "Liity",
"Support chat transcripts" => "Tukee jutun käsikirjoitusta",
"operator" => "operaattori",
"started" => "aloitettu",
"reason" => "syy",
"msgs" => "viesti",
"Transcript" => "Käsikirjoitus",
"Mail-in feature" => "Posti-sisään ominaisuus",
"Prefs" => "Kokoonp",
"Remove old events" => "Poista vanhat tapahtumat",
"duration" => "kesto",
"Mini Calendar: Preferences" => "Mini Kalenteri: Kokoonpano",
"Calendar Interval in daily view" => "Kalenterin aikaväli päivittäis näytössä",
"Start hour for days" => "Päivän aloitusaika",
"End hour for days" => "Päivän lopetusaika",
"Reminders" => "Muistutukset",
"no reminders" => "ei muistuksia",
"Or enter path or URL" => "Tai kirjoita polku tai URL",
"Add Topic" => "Lisää aihe",
"Tikiwiki Mods" => "Sivusto Modit",
"Mods Configuration" => "Moduulien Kokoonpano",
"Update remote index" => "Päivitä ulkoinen indexi",
"Rebuild local list" => "Rakenna paikallinen listaus",
"Republish all" => "Uudelleen julkaise kaikki",
"Publish all" => "Julkaise kaikki",
"Unpublish all" => "Äläjulkaise mitään",
"Attention" => "Huomio",
"all types" => "kaikki tyypit",
"Display only this type" => "Näytä vain tämän tyypin",
"Unpublish" => "Äläjulkaise",
"Republish" => "Uusintajulkaisu",
"Tikiwiki Mods Configuration" => "Modien Kokoonpano",
"Enable Mods providing" => "Oikeuta Modien tarjonta",
"Mods local directory" => "Modien paikallinen hakemisto",
"Mods remote server" => "Modien ulkoinen palvelin",
"Package Config" => "Paketti Kokoonopano",
"User Pages" => "Käyttäjä Sivut",
"y" => "k",
"User Galleries" => "Käyttäjä Galleriat",
"Unread Messages" => "Lukemattomat Viestit",
"Tasks" => "Tehtävät",
"User Blogs" => "Käyttäjä Blogit",
"MyTiki" => "OmatSivut",
"Notepad" => "Muistio",
"MyFiles" => "OmatTiedostot",
"My Watches" => "Omat vahdit",
"Assigned items" => "Liitetyt osat",
"Sent editions" => "Lähetä muokatut",
"The newsletter was sent to {\$sent} email addresses" => "Uutislehti on lähetetty {\$sent} sähköposti osoitteisiin",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Kiitos tilauksestasi. Saat kohta sähköpostia jolla varmistetaan tilauksesi. Uutislehteä ei lähetetä ennen kuin tilaus on varmistettu.",
"Your email address was removed from the list of subscriptors." => "Sähköpostiosoitteesi on poistettu tilaajien listalta.",
"Subscription confirmed!" => "Tilaus varmistettu!",
"Subscribe to Newsletter" => "Tilaa uutislehti",
"Subscribe to this Newsletter" => "Tilaa",
"Available Newsletters" => "Saatavilla olevat Uutislehdet",
"Select news group" => "Valitse uutisryhmä",
"Back to servers" => "Takaisin palvelimelle",
"Msgs" => "Viestit",
"News from" => "Uutisia",
"Back to groups" => "Takaisin ryhmiin",
"Save position" => "Tallenna paikka",
"Reading article from" => "Luetaan artikkeli",
"Back to list of articles" => "Takaisin artikkelien listaukseen",
"Newsgroup" => "Uutisryhmä",
"Configure news servers" => "Muuta uutispalvelimien kokoonpanoa",
"Configure Newsreader" => "Uutislukijan kokoonpano",
"configure newsreader server tpl" => "muokkaa uutislukijan tpl",
"Select a news server to browse" => "Valitse uutispalvelin selattavaksi",
"server" => "palvelin",
"Read the news" => "Lue uutisia",
"News server" => "Uutispalvelin",
"Notes" => "Huomiot",
"Write a note" => "Kirjoita huomio",
"quota" => "levytila",
"No notes yet" => "Ei huomioita vielä",
"Merge selected notes into" => "yhdistä valitut huomiot",
"Reading note:" => "Lukee huomiota:",
"List notes" => "Listaa huomiot",
"Write note" => "Kirjoita huomio",
"Wiki Create" => "Wiki luonti",
"Wiki Overwrite" => "Wiki päällekirjoitus",
"Added:" => "Lisätty:",
"Removed:" => "Poistettu:",
"Assign permissions to " => "Liitä oikeudet ",
"Current permissions for this object" => "Kohteen nykyiset oikeudet",
"No category permissions; global permissions apply" => "Ei luokka oikeuksia; yleiset oikeudet annetaan",
"Assign permissions to this object" => "Liitä oikeudet tälle kohteelle",
"Published" => "Julkaistu",
"Orphan Pages" => "Yksinäiset Sivut",
"Browser not supported" => "Selaimesi ei ole tuettu",
"Rename" => "Nimeä",
"Slides" => "Kuvat",
"Discuss" => "Pohtia",
"Attach File" => "Liite tiedosto",
"1 File Attached" => "1 liite tiedosto",
"Preview of version" => "Version esikatselu",
"(current)" => "(nykyinen)",
"Rollback to this version" => "Takaisin tähän versioon",
"Source of version" => "Versio Lähde",
"s=source" => "l=lähde",
"b=rollback" => "t=takaisin",
"Pick your avatar" => "Valitse hahmosi",
"User Preferences" => "Käyttäjä Kokoonpanot",
"Your current avatar" => "Nykyinen hahmosi",
"no avatar" => "ei hahmoa",
"reset" => "nollaus",
"Pick avatar from the library" => "Valitse hahmo kirjastosta",
"Pick user Avatar" => "Ota käyttäjä Hahmo",
"Hide all" => "Piilota kaikki",
"icons" => "ikonit",
"Show all" => "Näytä kaikki",
"Avatar Image" => "Hahmo Kuva",
"Upload your own avatar" => "Lähetä oma hahmosi",
"Insert" => "Lisäys",
"atts" => "liite",
"List Attachments" => "Listaa Liitteet",
"Average" => "Keskimäärin",
"View Results" => "Näytä Tulokset",
"Vote poll" => "Ota äänestys",
"Other Polls" => "Muut äänestykset",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Huomaa: Muista, että tämä on vasta esikatselu, ja sitä ei ole tallennettu!",
"on:" => ":",
"Topic image" => "Aiheen kuva",
"Viewing blog post" => "Näyttää blogilähetyksiä",
"Return to blog" => "Palaa blogiin",
"The original document is available at" => "Alkuperäinen asiakirja on saatavilla",
"Print multiple pages" => "Tulosta useita sivuja",
"Add Structure" => "Lisää rakenne",
"Add Page" => "Lisää Sivu",
"Edit quiz" => "Muokka visailua",
"General Options" => "Yleiset Vaihtoehdot",
"Name:" => "Nimi:",
"Publication Date" => "Julkaisupäivä",
"at " => " ",
"Use " => "Käytä ",
"randomly selected questions." => "satunnaisesti valitut kysymykset.",
"Test-time Options" => "Testin-aika Vaihtoehdot",
"Limit questions displayed per page to " => "Rajoita kysymysten määrä per sivu ",
"&nbsp question(s)." => "&nbsp kysymys(tä).",
"Impose a time limit of " => "Määrää aikaraja ",
"Allow students to store partial results and return to quiz." => "Salli opiskelijoiden tallentaa osittaiset tulokset ja palata visailuun.",
"Allow students to retake this quiz " => "Salli opiskelijoiden ottaa uudelleen visailu ",
"Grading and Feedback" => "Arvostelu ja Palaute",
"Grading method " => "Arvostelu menetelmä ",
"Show students their score " => "Näytä opiskelijoille heidän pisteensä ",
"Show students the correct answers " => "Näytä opiskelijoille oikeat vastaukset ",
"Publish statistics " => "Julkaise tilastot ",
"Extra Options" => "Lisä Vaihtoehdot",
"Solicit additional questions from students" => "Pyydä lisäkysymyksiä opiskelijoilta",
"Link quiz to forum named: " => "Linkitä visailu foorumiin nimeltä: ",
"Prologue:" => "Esipuhe:",
"Epilogue:" => "Jälkipuhe:",
"Quiz result stats" => "Visailu tulosten tilasto",
"Time" => "Aika",
"User answers" => "Käyttäjä vastaukset",
"Stats for quizzes" => "Visailujen tilastot",
"taken" => "otettu",
"Av score" => "Keskim tilanne",
"Av time" => "Keskim aika",
"Clear Stats" => "Tyhjennä tilastot",
"time taken" => "aikaa meni",
"P/F" => "Osittain/Koko",
"Stats for this quiz Questions " => "Tämän visailun kysymysten tilasto ",
"Received articles" => "Vastaanotetut artikkelit",
"Edit received article" => "Muokkaa vastaanotettua artikkelia",
"Use Image" => "Käytä Kuvaa",
"Image x size" => "Kuva x koko",
"Image y size" => "Kuva y koko",
"Image name" => "Kuvan nimi",
"Accept Article" => "Hyväksy Artikkeli",
"Site" => "Sivusto",
"Received Pages" => "Vastaanotetut Sivut",
"Referer stats" => "Suosittelu tilastot",
"A valid email is mandatory to register" => "Voimassa oleva sähköposti osoite on pakollinen rekisteröinnissä",
"NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter!" => "HUOMAA: Pidä huoli domain listauksesta estääksesi rekisteröinti viestien menemisen roskapostiin!",
"Tiki site registered" => "Tiki sivusto rekisteröity",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Seuraava sivusto on lisätty ja ylläpidon hyväksyntä ennen kuin se ilmestyy listalle",
"You don't have permission to use this feature." => "Oikeutesi eivät riitä käyttämään tätä ominaisuutta.",
"Please register." => "Ole Hyvä ja rekisteröidy.",
"Register this site at tikiwiki.org" => "Rekisteröi tämä sivusto tikiwiki.org:iin",
"Read this first!" => "Lue tämä ensin!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "Tällä sivulla voit tehdä sivustosi tunnetuksi tikiwiki.org:iin. Se tulee sinne näkyviin tunnettuna sivustona.",
"Registering is voluntary." => "Rekisteröinti on vapaaehtoinen.",
"Registering does not give you any benefits except one more link to your site." => "Rekisteröinti ei tuo mitään lisäetua vain yhden linkin lisää.",
"You don't get any emails, we don't sell the data about your site." => "Et saa mitään postituksia, me emme myy sivustosi tietoja eteenpäin.",
"Registering is just for us to get an overview of Tiki's usage." => "Rekisteröinti on vain meille jotta saamme paremman kuvat Tiki:en käytöstä.",
"If your site is private or inside your intranet, you should not register!" => "Jos sivustosi on yksityinen tai vain sisäisessä verkossa sitä ei pidä rekisteröidä!",
"Information about your site" => "Tietoja sivustostasi",
"Send me my Password" => "Lähetä salasanani",
"Remove page" => "Poista sivu",
"Last Version" => "Viimeinen versio",
"You are about to remove the page" => "Olet aikeissa poistaa sivun",
"permanently" => "pysyvästi",
"Remove all versions of this page" => "Poista kaikki versiot tästä sivusta",
"Replicate" => "Jäljennös",
"Slave" => "Alainen",
"Master" => "Mestari",
"Operations" => "Toimenpiteet",
"Operations Log" => "Toimenpiteiden Logi",
"Rollback page" => "Takaisinkelaa sivu",
"Searched" => "Etsitty",
"Search in" => "Etsitty",
"Simple search" => "Yksikertainen haku",
"No pages matched the search criteria" => "Ei sivuja näillä hakuehdoilla",
"Send blog post" => "Lähetä blogi lähetys",
"A link to this post was sent to the following addresses:" => "Linkki tähän lähetykseen on lähetetty osoitteeseen:",
"Send post to this addresses" => "Lähetä posti näihin osoitteisiin",
"List of email addresses separated by commas" => "Sähköposti osoitteiden lista eroteltuna pilkuilla",
"This newsletter will be sent to {\$subscribers} email addresses." => "Tämä uutislehti lähetetään {\$subscribers} sähköposti osoitteisiin.",
"Prepare a newsletter to be sent" => "Valmistele uutislehti lähetettäväksi",
"Apply content template" => "Liitä sisältö malli",
"remove" => "poista",
"Send objects" => "Lähetä kohteet",
"Transmission results" => "Siirtojen tulokset",
"Send Wiki Pages" => "Lähetä Wiki Sivut",
"Send Articles" => "Lähetä Artikkelit",
"Add Article" => "Lisää artikkeli",
"Send objects to this site" => "Lähetä kohteet tälle sivustolle",
"Create a sheet" => "Luo arkki",
"Edit this sheet:" => "Muokkaa tätä arkkia:",
"Create New Sheet" => "Luo uusi arkki",
"There are individual permissions set for this sheet" => "Tälle arkille on erityisoikeudet",
"Class Name" => "Luokka Nimi",
"Header Rows" => "Pääosan Rivejä",
"Footer Rows" => "Alaosan Rivejä",
"Create new Sheet" => "Luo uusi Arkki",
"You can access the sheet using the following URL" => "Voit päästä arkille seuraamalla tätä URL",
"Available Sheets" => "Saatavilla olevat Arkit",
"Change shoutbox general settings" => "Muuta pikaviestimen yleisiä asetuksia",
"auto-link urls" => "auto-link url:it",
"Post or edit a message" => "Lähetä tai muokkaa viestiä",
"Parent page" => "Isäntä sivu",
"Child" => "Ala",
"Last edited by" => "Viimeksi muokannut",
"based on work by" => "perustyön tehnyt",
"Contributors to this page" => "Tämän sivun avustajat",
"big grin" => "iso hymy",
"confused" => "hämmentynyt",
"cool" => "siisti",
"cry" => "itku",
"evil" => "paha",
"redface" => "punakka",
"rolleyes" => "silmitys",
"smile" => "hymy",
"surprised" => "yllättynyt",
"twisted" => "kierto",
"arrow" => "nuoli",
"Params" => "Param",
"Most viewed objects" => "Eniten näytetyt kohteet",
"Most viewed objects in the last 7 days" => "Eniten näytetyt kohteet viimeisten 7 päivän aikana",
"Site Stats" => "Sivuston Tilastot",
"Total pageviews" => "Sivunäytöt kaikkiaan",
"Average pageviews per day" => "Sivunäyttöjä keskimäärin päivässä",
"Best day" => "Paras päivä",
"Worst day" => "Huonoin päivä",
"Wiki Stats" => "Wiki Tilastot",
"Size of Wiki Pages" => "Wiki Sivujen koko",
"Average page length" => "Keskimääräinen sivun pituus",
"Average versions per page" => "Versioita keskimäärin per sivu",
"Visits to wiki pages" => "Vierailut wikisivuilla",
"Orphan pages" => "Yksinäiset sivut",
"Average links per page" => "Linkkejä keskimäärin per sivu",
"Image galleries Stats" => "Kuva galleria Tilastot",
"Average images per gallery" => "Kuvia keskimäärin per galleria",
"Total size of images" => "Kuvien koko kaikkiaan",
"Average image size" => "Kuvien keskimääräinen koko",
"Visits to image galleries" => "Vierailuja kuva gallerioissa",
"File galleries Stats" => "Tiedosto galleria Tilastot",
"Average files per gallery" => "Tiedostoja keskimäärin per galleria",
"Total size of files" => "Tiedostojen koko kaikkiaan",
"Average file size" => "Tiedoston koko keskimäärin",
"Visits to file galleries" => "Vierailuja tiedosto gallerioissa",
"CMS Stats" => "CMS Tilastot",
"Total reads" => "Luettu kaikkiaan",
"Average reads per article" => "Lukijoita keskimäärin per artikkeli",
"Total articles size" => "Artikkelien koko kaikkiaan",
"Average article size" => "Artikkelin koko keskimäärin",
"Forum Stats" => "Foorumin Tilastot",
"Total topics" => "Aiheita kaikkiaan",
"Average topics per forums" => "Aiheita keskimäärin per foorumi",
"Visits to forums" => "Vierailuja foorumeilla",
"Blog Stats" => "Blogi Tilastot",
"Weblogs" => "Weblogit",
"Total posts" => "Lähetyksiä kaikkiaan",
"Average posts per weblog" => "Lähetyksiä keskimäärin per webblogi",
"Total size of blog posts" => "Blogi lähetysten koko kaikkiaan",
"Average posts size" => "Keskimääräinen lähetyksen koko",
"Visits to weblogs" => "Vierailua weblogeissa",
"Poll Stats" => "Äänestys Tilastot",
"Total votes" => "Ääniä kaikkiaan",
"Average votes per poll" => "Ääniä keskimäärin per äänestys",
"Total questions" => "Kysymyksiä kaikkiaan",
"Average questions per FAQ" => "Kysymyksiä keskimäärin per UKK",
"User Stats" => "Käyttäjä Tilastot",
"User bookmarks" => "Käyttäjän kirjanmerkit",
"Average bookmarks per user" => "Kirjanmerkkejä keskimäärin per käyttäjä",
"Average questions per quiz" => "Kysymyksiä keskimäärin per visailu",
"Quizzes taken" => "Visailuja otettu",
"Average quiz score" => "Keskimääräinen visailu tilanne",
"Average time per quiz" => "Keskimääräinen aika per visailu",
"Usage chart" => "Kaavion käyttö",
"Usage chart image" => "Kaavio kuvan käyttö",
"Daily Usage" => "Päivittäinen Käyttö",
"Stats for surveys" => "Tutkimusten Tilasto",
"Last taken" => "Viimeksi otettu",
"Time Left" => "Aikaa Jäljellä",
"Send Answers" => "Lähetä vastaukset",
"Thank you for your submission" => "Kiitoksia ehdotuksestasi",
"Your email was sent" => "Sähköpostiosoitteesi on lähetetty",
"Theme is selected as follows" => "Teema on valittu seuraaviin",
"If a theme is assigned to the individual object that theme is used." => "Jos teema on liitetty teeman kohteita käytetään.",
"If not then if a theme is assigned to the object's category that theme is used" => "Jos ei niin kohteen luokittelun teemaa käytetään",
"If not then a theme for the section is used" => "Jos ei niin kohteen osaston teemaa käytetään",
"If none of the above was selected the user theme is used" => "Jos mitään näistä ei ole käytetään käyttäjän teemaa",
"Finally if the user didn't select a theme the default theme is used" => "Lopuksi jos mikään näistä ei täyty käytetään oletus teemaa",
"Control by Objects" => "Hallinta Kohteella",
"Control by Sections" => "Hallinta Osastolla",
"Assign themes to categories" => "Liitä teemaa luokkiin",
"Assigned categories" => "Liitetyt luokat",
"Theme Control Center: Objects" => "Teeman Hallinta Keskus: Kohteet",
"Control by Categories" => "Hallinta luokilla",
"Assign themes to objects" => "Liitä teema kohteille",
"Assigned objects" => "Liitetyt kohteet",
"Assign themes to sections" => "Liitä teema osastoihin",
"Assigned sections" => "Liitetyt osastot",
"Edit File:" => "Muokkaa Tiedostoa:",
"The following file was successfully uploaded" => "Seuraavat tiedostot onnistuneesti vastaanotettu",
"You can download this file using" => "Voit imuroida tiedoston käyttäen",
"You have to create a gallery first!" => "Sinun on luotava galleria ensin!",
"Batch Upload Results" => "Joukko Lähetyksen Tulokset",
"Upload successful!" => "Lähetys onnistui!",
"The following image was successfully uploaded" => "Seuraavat kuvat on onnistuneesti vastaanotettu",
"Image ID thumb" => "Kuva ID mini",
"You can include the image in an Wiki page using" => "Voit lisätä kuvan sivulle käyttäen",
"or use filename" => "tai käytä tiedostonimeä",
"Now enter the image URL" => "Kirjoita kuvan URL",
"or upload a local image from your disk" => "tai lähetä oma kuva kovalevyltäsi",
"Batch Upload" => "Joukko lähetys",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Minikuva (vaihtoehtoinen, ohittaa automaattisen minikuvan luonnin)",
"Note: Maximum image size is limited to" => "Huomaa: Suurin mahdollinen kuvankoko on",
"User assigned modules" => "Käyttäjän liittämät moduulit",
"Assign module" => "Liitä moduuli",
"Column" => "Palsta",
"top" => "ylä",
"Current folder" => "Nykyinen kansio",
"Folders" => "Kansiot",
"Folder in" => "Kansio",
"Remove Folder" => "Poista kansio",
"Refresh Cache" => "Päivitä puskuri",
"Admin folders and bookmarks" => "Ylläpidö kansioita ja kirjanmerkkejä",
"Send me a message" => "Lähetä minulle viesti",
"Assign Group" => "Liitä Ryhmä",
"Homepage" => "EtuSivu",
"Users HomePage" => "Käyttäjän EtuSivu",
"Personal Wiki Page" => "Henkilökohtainen Sivu",
"Create page" => "Luo sivu",
"System" => "Järjestelmä",
"This user is your friend" => "Tämä käyttäjä on ystävä",
"Request friendship from this user" => "Pyydä ystävyyttä tältä käyttäjältä",
"Toggle options" => "Nappula vaihtoehdot",
"Toggle" => "Nappurla",
"Personal Information" => "Henkilökohtaiset Tiedot",
"Your personal Wiki Page" => "Henkilökohtainen Sivusi",
"Your personal tracker information" => "Henkilökohtaiset kortistotiedot",
"View extra information" => "Näytä lisätiedot",
"Is email public? (uses scrambling to prevent spam)" => "Onko sähköposti julkinen? (käytä sekoitusta roskapostin estoon)",
"Unavailable - please set your e-mail below" => "EiSaatavilla - anna sähköpostiosoite alle",
"Does your mail reader need a special charset" => "Tarvitseeko postiohjelmasi erikois merkistöä",
"Note author when reading his mail" => "Ilmoita kirjoittajalle kun hänen viestiään luetaan",
"Account Information" => "Tili Tiedot",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Jätä \"Uusi salasana\" ja \"Toista uusi salasana\" kentät tyhjiksi säilyttääksesi nykyinen salasanasi",
"Email address" => "Sähköposti osoite",
"Confirm new password" => "Toista uusi salasana",
"Current password (required)" => "Nykyinen salasana (pakollinen)",
"Change administrative info" => "Muuta ylläpidollista tietoa",
"New task" => "Uusi tehtävä",
"Task list" => "Tehtävä lista",
"Admin mode off" => "Ylläpito pois",
"Admin mode on" => "Ylläpito päällä",
"Task help" => "Tehtävä apu",
"Empty Trash" => "Tyhjennä roskis",
"Received task" => "Vastaanotettu tehtävä",
"You received this task, please read and execute it" => "Olet vastaanottanut tämän tehtävän, lue ja tee se",
"Send task" => "Lähetä tehtävä",
"You send this task to a other user" => "Lähetit tämän tehtävän toiselle käyttäjälle",
"Shared task" => "Jaettu tehtävä",
"This task is public to a special group" => "Tämä tehtävä on julkinen määrätylle ryhmälle",
"Accepted by Task User and Creator" => "Hyväksytty tehtävän tekijän ja luojan puolesta",
"Accepted User and Creator" => "Hyväksytyt käyttäjä ja luoja",
"Task is accepted by user and creator" => "Tehtävä on hyväksytty sekä käyttäjän että luojan puolesta",
"Not Accepted by One User" => "Yksi käyttäjä ei ole hyväksynyt",
"Not Accepted User" => "Ei hyväksyntää käyttäjä",
"Task is rejected by one user" => "Yksi käyttäjä on hylännyt tehtävän",
"Waiting for Me" => "Odottaa minua",
"Task is not accepted by you, read the task and accept or reject it" => "Et ole hyväksynyt tehtävää, lue tehtävä ja hyväksy tai hylkää se",
"Waiting for Other User" => "Odottaa muita käyttäjiä",
"Task is not accepted/rejected by other user" => "Muut käyttäjät eivä ole hyväksyneet/hylänneet tehtävää",
"Admin Mode" => "Ylläpidollinen",
"Edit task" => "Muokkaa tehtävää",
"NOT accept" => "EI hyväksytty",
"Remove from Trash" => "Poista roskiksesta",
"Move into Trash" => "Siirrä roskikseen",
"Task saved" => "Tehtävä tallennettu",
"Edit Task" => "Muokka Tehtävää",
"View Task" => "Näytä Tehtävä",
"Open a new task" => "Avaa uusi tehtävä",
"taskId" => "tehtäväId",
"Task user" => "Tehtävän käyttäjä",
"Only the creator can delete this task" => "Vain tehtävän luoja voi sen poistaa",
"Use start date and time" => "Käytä aloituspäivää ja aikaa",
"Use end date and time" => "Käytä lopetuspäivää ja aikaa",
"Open / In Process" => "Avaa / menetelmään",
"Waiting / Not Started" => "Odottaa / ei käynnistetty",
"Percentage completed" => "Valmistuminen prosentteina",
"Waiting" => "Odottaa",
"Shared for Group" => "Jaettu ryhmälle",
"Accepted by User" => "Hyväksynyt käyttäjä",
"No / Rejected" => "Ei / hylätty",
"Accepted by Creator" => "Hyväksynyt luojana",
"This message will be send to users if you are makeing changes of assigned tasks" => "Tämä viesti lähetetään käyttäjille jos teet muutoksia annettuihin tehtäviin",
"Send message with changes" => "Lähetä viesti ja muutokset",
"Modified by" => "Muokkaajana",
"Marked as deleted" => "Merkitty poistetuksi",
"Inform task user by email" => "Tiedota tehtävän käyttäjää sähköpostilla",
"You can only view this task" => "Voit katsoa vain tätä tehtävää",
"No tasks entered" => "Ei lisättyjä tehtäviä",
"Select One" => "Valitse yksi",
"Undo Trash" => "Peruuta roskis",
"Show:" => "Näytä:",
"Received" => "Vastaanotettu",
"Submitted" => "Lähetetty",
"Shared" => "Jaettu",
"All Shared Tasks" => "Kaikki jaetut tehtävät",
"completed (100%)" => "valmis (100%)",
"Public for group" => "Julkaistu ryhmälle",
"Add Watch" => "Lisää Vahti",
"Watches" => "Vahdit",
"A user submits a blog post" => "Käyttäjä ehdottaa bloki lähetystä",
"A user posts a forum thread" => "Käyttäjä lähetti foorumi ketjun",
"A user posts a forum topic" => "Käyttäjä lähetti foorumin aiheen",
"A user edited a wiki page" => "Käyttäjä muokkasi sivuston sivua",
"May need to refresh twice to see changes" => "Saattaa tarvita kaksi päivitystä nähdäksesi muutoksen",
"Add top level bookmarks to menu" => "Lisää ylimmän tason kirjanmerkki valikkoon",
"replace window" => "korvaa ikkuna",
"User_versions_for" => "Käyttäjä_versio",
"This page is being edited by" => "Tätä sivua on muokannut",
"Proceed at your own peril" => "Jatka omalla vastuulla",
"Insert Row" => "Lisää Rivi",
"Insert Column" => "Lisää Palsta",
"Remove Row" => "Poista Rivi",
"Remove Column" => "Poista Palsta",
"Merge Cells" => "Yhdistä Kennot",
"Restore Cells" => "Palauta Kennot",
"Copy Calculation" => "Kopio Kaava",
"Format Cell" => "Kennon Muoto",
"Before" => "Ennen",
"After" => "Jälkeen",
"expires:" => "sulkeutuu:",
"Banner stats" => "Banneri tilastot",
"Create new banner" => "Luo uusi banneri",
"Banner Information" => "Bannerin Tiedot",
"Click ratio" => "Paina suhde",
"Weekdays" => "Viikopäivät",
"mon" => "maa",
"tue" => "tii",
"wed" => "kes",
"thu" => "tor",
"fri" => "per",
"sat" => "lau",
"Banner raw data" => "Bannerin raaka data",
"Cached" => "Puskuroitu",
"This is a cached version of the page." => "Tämä on puskuroitu versio sivusta.",
"Click here to view the Google cache of the page instead." => "Paina tästä nähdäksesi Googlen puskuroiman version sivusta.",
"Edit Items" => "Muokkaa osia",
"List Charts" => "Listaa kaaviot",
"Last Chart" => "Viimeisin kaavio",
"Previous Chart" => "Edellinen kaavio",
"Chart created" => "Kaavio luotu",
"Next Chart" => "Seuraava kaavio",
"Pre" => "Edel",
"Permanency" => "Pysyvä",
"chg" => "muuta",
"Avg" => "Keskim",
"info/vote" => "tieto/ääni",
"Next chart will be generated on" => "Seuraava kaavio muodostetaan",
"View or vote items not listed in the chart" => "Katso tai äänestä osia joita ei ole kaaviossa",
"Select something to vote on" => "Valitse jotakin äänestettävää",
"Item information" => "Osan tiedot",
"Dif" => "Erot",
"Best Position" => "Paras Sijainti",
"Vote this item" => "Äänestä tätä osaa",
"Highest" => "Korkein",
"Answers" => "Vastaukset",
"Q" => "K",
"A" => "V",
"Add Suggestion" => "Lisää ehdotus",
"Forum List" => "Foorumin Lista",
"Edit Forum" => "Muokkaa Foorumia",
"Summary" => "Yhteenveto",
"Moderator Actions" => "Moderaattorin toiminnot",
"Move Selected Topics" => "Siirrä valitut aiheet",
"Unlock Selected Topics" => "Avaa valitut aiheet",
"Lock Selected Topics" => "Lukitse valitut aiheet",
"Delete Selected Topics" => "Poista valitut aiheet",
"Merge" => "Yhdistä",
"Merge Selected Topics" => "Yhdistä valitut aiheet",
"Reported Messages:" => "Raportoidut viestit:",
"Queued Messages:" => "Viestit jonossa:",
"Merge into topic" => "Yhdistä aiheeseen",
"Emot" => "Tunt",
"pts" => "pist",
"Announce" => "Tiedote",
"Hot" => "Kuuma",
"No topics yet" => "Ei aiheita vielä",
"Jump to forum" => "Hyppää foorumille",
"Last hour" => "Viime tunti",
"Last 24 hours" => "Viimeiset 24 tuntia",
"Last 48 hours" => "Viimeiset 48 tuntia",
"prev topic" => "edel aihe",
"next topic" => "seur aihe",
"Show posts" => "Näytä lähetykset",
"Insert New Item" => "Liitä uusi osa",
"Edit Fields" => "Muuta kenttiä",
"Tracker Items" => "Kortiston osat",
"View inserted item" => "Näytä lisätty osa",
"Insert new item" => "Liitä uusi osa",
"Tracker Item:" => "Kortisto osa:",
"View Item" => "Näytä osa",
"Filter Tracker Items" => "Suodata Kortisto osia",
"Add a Comment" => "Lisää kommentti",
"Items list" => "Osien lista",
"Special Operations" => "Erikois Menetelmät",
"close" => "sulje",
"Show All" => "Näytä Kaikki",
"Clip" => "pala",
"Back To Mailbox" => "takaisin postilaatikkoon",
"Full Headers" => "täydet pääosat",
"Normal Headers" => "tavalliset pääosat",
"Reply To All" => "vastaa kaikille",
"Forward" => "lähetä edelleen",
"Select from address book" => "valitse osoitekirjasta",
"Use HTML mail" => "Käytä HTML lähetystä",
"The following addresses are not in your address book" => "Seuraava osoite ei ole osoitekirjassa",
"Add Contacts" => "Lisää yhtyeksiin",
"Attachment 1" => "Liite 1",
"Attachment 2" => "Liite 2",
"Attachment 3" => "Liite 3",
"Address book" => "Osoite kirja",
"page id" => "sivu id",
"3d browser" => "3d selain",
"Show/Hide Left Menus" => "Näytä/Piilota Valikot Vasemmalla",
"Show/Hide Right Menus" => "Näytä/Piilota Valikot Oikealla",
"Remove Image" => "Poista kuva",
"Number of voices" => "Ääniä kaikkiaan",
"Use this thread to discuss the page:" => "Käytä tätä ketjua keskustellaksesi sivusta:",
"Categories:" => "Luokittelut:",
"Start:" => "Aloitus:",
"Save Minor Edit" => "Pieni",
"Compose Message" => "Muodosta viesti",
"If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "Jos haluatte, että teille vastataan, teidän on merkittävä <a href='tiki-user_preferences.php'>Salli viestit muilta käyttäjiltä</a>",
"Administration" => "Ylläpito",
"Enable/disable Tiki features here, but configure them elsewhere" => "Aseta Tikin ominaisuudet päälle/poispäältä täällä, mutta muokkaa ominaisuutta muualla",
"General preferences and settings" => "Yleiset oikeudet ja asetukset",
"User registration, login and authentication" => "Käyttäjän rekisteröinti, kirjaus ja varmistus",
"Wiki settings" => "WAsetukset",
"Wiki Attachments" => "Sivusto Liitteet",
"Article/CMS settings" => "Artikkeli/CMS asetukset",
"Poll comments settings" => "Äänestys kommenttien asetukset",
"Configuration options for all blogs on your site" => "Kokoonpano vaihtoehdot sivuston kaikille blogeille",
"Forums settings" => "Foorumin asetukset",
"FAQ comments settings" => "UKK kommenttien asetukset",
"Trackers settings" => "Kortiston asetukset",
"RSS feeds" => "RSS syötteet",
"RSS settings" => "RSS asetukset",
"Directory settings" => "Hakemisto asetukset",
"Maps configuration" => "Karttojen kokoonpano",
"Meta Tags settings" => "Meta Tagien asetukset",
"Search settings" => "Etsintä asetukset",
"Score settings" => "Piste asetukset",
"Community settings" => "Yhteisö asetukset",
"Calendar settings" => "Kalenteri asetukset",
"Intertiki settings" => "Intertiki asetukset",
"Help on \$admintitle Config" => "Auta \$ylläpitoaiheen asetuksessa",
"Category can`t be parent of itself" => "Luokka ei voi olla itsensä isäntä",
"No chart indicated" => "Ei kaaviota osoitettu",
"Upload failed" => "Lähetys epäonnistui",
"You have to provide a hotword and a URL" => "Sinun on osoitettava hotword ja URL",
"Detected, Version:" => "Löydetty, Versio:",
"Not detected." => "Ei löytynyt.",
"Your admin password has been changed" => "Admin salasanasi on vaihdettu",
"You cannot have a blank password" => "Salasana ei voi olla tyhjä",
"All Fields except gdaltindex must be filled" => "Kaikki kentät paitsi gdaltindex on täytettävä",
"No valid gdaltindex executable" => "Ei oikea gdaltindex ohjelma",
"You cannot mix old and new trackers" => "Et voi sekoittaa uusia ja vanhoja kortistoja",
"Tag already exists" => "Lisäys on jo olemassa",
"Tag not found" => "Lisäystä ei löydy",
"Repository name can't be an empty" => "Säilytyspaikan nimi ei voi olla tyhjä",
"Requested action is not supported on repository" => "Pyydetty toiminto ei ole tuettu säilytyspaikalle",
"No repository" => "Ei säilytyspaikkaa",
"Search is mandatory field" => "Etsintäkenttä on pakollinen",
"File not found " => "Tiedostoa ei löydy ",
"Requested action in not supported on repository" => "Pyydetty toiminto ei ole tuettu säilytyspaikalle",
"Non-existent link" => "Olematon linkki",
"Mail-in account %s incorrect" => "Posti-sisään tili %s väärä",
"Mail-in account %s saved" => "Posti-sisään tili %s tallennettu",
"Frequency should be a positive integer!" => "Muutosväli on oltava positiivinen kokonaisluku!",
"Mail-in accounts set to be checked every %s minutes" => "Postit-sisään tilit tarkistetaan joka %s minuutti",
"Automatic Mail-in accounts checking disabled" => "Automaattinen postit-sisään tilien tarkistus pois päältä",
"No menu indicated" => "Ei valikkoa osoitettu",
"No newsletter indicated" => "Ei uutislehteä osoitettu",
"No poll indicated" => "Ei äänestystä osoitettu",
"unsafe" => "turvaton",
"register_globals should be off by default. See the php manual for details." => "register_globals pitää olla pois päältä oletuksena. Katso php:n käsikirjasta tarkemmin.",
"safe" => "turvallinen",
"session.use_trans_sid should be off by default. See the php manual for details." => "istunnon.use_trans_sid pitää olla pois päältä oletuksena. Katso php:n käsikirjasta tarkemmin.",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir on sivustohakemiston sisällä. On olemassa vaara, että joku voi lähettää minkätahansa tiedoston sinne ja päästä sinne selaimella",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "ei voi tarkistaa onko upload_tmp_dir selattavissa selaimella. Ollaksesi varma tarkista palvelimen asetukset.",
"setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "asetus xbithack ei ole turvallinen. Riippuen tiedoston käsittelystä palvelimella ja sivuston asetuksista, saattaa hyökkääjä voida lähettää tiedoston galleriaan ja käynnistää se sieltä",
"risky" => "riski",
"allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen mahdollistaa ohjelmien ja skripitien lähetyksen. Jos blogit eivät ole käytössä, voit ottaa sen pois päältä.",
"The Path to store files in the filegallery should be outside the tiki root directory" => "Tiedostojen tallennuspolku on oltava sivuston juuren ulkopuolella",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "Kuvien tallennuspolku on oltava sivuston juuren ulkopuolella",
"The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "Ominaisuus \"Muuta Malleja\" on päällä. Älä anna kenenkään johon et varmasti luota käyttää tätä. Sitä voi helposti käyttää ajamaan php koodia.",
"Path disclosure" => "Polun näyttäminen",
"Path disclosure through error message" => "Polku näytetään virheviestissä",
"SQL injection" => "SQL lisäys",
"SQL injection by authenticated user" => "SQL lisäys varmistetulta käyttäjältä",
"SQL injection by authenticated user with special privileges" => "SQL lisäys varmistetulta käyttäjältä, jolla on erikoisoikeudet",
"SQL injection without authentication" => "SQL lisäys ilman varmistusta",
"PHP command injection" => "PHP komentolisäys",
"PHP command injection by authenticated user" => "PHP komentolisäys varmistetulta käyttäjältä",
"PHP command injection by authenticated user with special privileges" => "PHP komentolisäys varmistetulta käyttäjältä, jolla on erikoisoikeudet",
"PHP command injection without authentication" => "PHP komentolisäys ilman varmistusta",
"File upload" => "Tiedosto lähetys",
"File is not readable. Unable to check." => "Tiedosto ei ole luettavissa. Ei voi tarkistaa.",
"This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "Tämä ei ole normaali tiedosto. Tarkista onko tiedosto lähetetty, jos niin saattaa olla vaaraksi.",
"This is a modified File. Cannot check version. Check if it is dangerous." => "Tätä Tiedostoa on muokattu. Ei voi tarkistaa versiota. Tarkista onko vaaraksi.",
"This file is from another Tikiwiki version: " => "Tämä tiedosto on sivustoversiosta: ",
"You have to provide a word" => "Sinun on annettava sana",
"Permission denied you cannot view this page" => "Oikeutesi eivät riitä katsomaan tätä sivua",
"Permission denied you cannot edit this page" => "Oikeutesi eivät riitä tämän sivun muokkaamiseen",
"You must specify a page name, it will be created if it doesn't exist." => "Sinun on annettava sivulle nimi, jos sitä ei ole ennestään se luodaan.",
"page not added (Exists)" => "sivua ei lisätty (On olemassa)",
"No survey indicated" => "Ei tutkimusta osoitettu",
"You don't have permission to use this feature" => "Oikeutesi eivät riitä käyttämään tätä ominaisuutta",
"No Errors detected" => "Virheitä Ei havaittu",
"Error:" => "Virhe:",
"No tracker indicated" => "Ei kortistoa osoitettu",
"Group already exists" => "Ryhmä on jo olemassa",
"User doesn't exist" => "Käyttäjää ei ole olemassa",
"No records were found. Check the file please!" => "Tallennusta ei löytynyt. Tarkista tiedosto!",
"User login is required" => "Tarvitaan kirjautuminen",
"Password is required" => "Tarvitaan salasana",
"Email is required" => "Tarvitaan sähköpostiosoite",
"User is duplicated" => "Käyttäjä on kopioitu",
"Created account %s <%s>" => "Luotu tili %s <%s>",
"Assigned %s in group %s" => "Liitetty %s ryhmään %s",
"User %s already exists" => "Käyttäjä %s on jo olemassa",
"New %s created with %s %s." => "Uusi %s luotu jolla on %s %s.",
"Impossible to create new %s with %s %s." => "Mahdotonta luoda uutta %s jolla on %s %s.",
"%s %s successfully deleted." => "%s %s on onnistuneesti poistettu.",
"%s %s removed from %s %s." => "%s %s poistettu %s %s.",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> on onnistuneesti poistettu.",
"%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> liitetty %s <b>%s</b>.",
"%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> poistettu %s <b>%s</b>.",
"group <b>%s</b> set as the default group of user <b>%s</b>." => "ryhmä <b>%s</b> on asetettu oletusryhmäksi käyttäjälle <b>%s</b>.",
"%s changed from %s to %s" => "%s vaihdettu %s  %s",
"Impossible to change %s from %s to %s" => "Mahdotonta vaihtaa %s  %s  %s",
"%s modified successfully." => "%s on muutettu onnistuneesti.",
"password" => "salasana",
"%s modification failed." => "%s muutos ei onnistunut.",
"rss feed disabled" => "rss syöte poistettu",
"Tiki RSS feed for articles" => "RSS artikkelien syöte",
"Last articles." => "Viimeiset artikkelit.",
"Unknown group" => "Tuntematon ryhmä",
"Group doesn't exist" => "Ryhmää ei ole olemassa",
"You have to indicate a group" => "On osoitettava ryhmä",
"This group is invalid" => "Tämä ryhmä on väärä",
"Permission denied you cannot view backlinks for this page" => "Oikeutesi eivät riitä paluulinkkien katsomiseen tältä sivulta",
"The page cannot be found" => "Sivua ei löydy",
"Image Galleries Admin Panel" => "Kuva Gallerioiden Ylläpito Paneeli",
"Could not read image %s." => "Kuvaa %s ei voi lukea.",
"Image %s upload failed." => "Kuvan %s lähetys epäonnistui.",
"Image %s uploaded successfully." => "Kuvan %s lähetys onnistui.",
"Image %s removed from Batch directory." => "Kuva %s on poistettu ryhmälähetys hakemistosta.",
"Impossible to remove image %s from Batch directory." => "Mahdotonta poistaa kuvaa %s ryhmälähetys hakemistosta.",
"Permission denied you cannot use the batch directory loading" => "Sinulla ei ole oikeutta käyttää ryhmälähetys hakemisto latausta",
"Incorrect directory chosen for batch upload of images." => "Väärä hakemisto valittu kuvien ryhmälähetystä varten.",
"Please setup that dir on " => "Tee hakemisto asetukset ",
"Please contact the website administrator." => "Ota yhteyttä sivuston ylläpitoon.",
"Invalid directory name" => "Väärä hakemiston nimi",
"You can't post in any blog maybe you have to create a blog first" => "Et voi lähettää mihinkään blogiin, ehkä sinun on luotava blogi ensin",
"Permission denied you cannot post" => "Oikeutesi eivät riitä lähettämiseen",
"Permission denied you cannot edit this post" => "Oikeutesi eivät riitä lähetyksen muokkamiseen",
"Top visited blogs" => "Eniten katsotut blogit",
"Last posts" => "Viimeiset lähetykset",
"Top active blogs" => "Aktiivisimmat blogit",
"Tiki RSS feed for blog: " => "RSS syöte blogille: ",
"No blogId specified" => "Ei blogId tarkennusta",
"Tiki RSS feed for weblogs" => "RSS syöte verkkoblogeille",
"Last posts to weblogs." => "Viimeiset lähetykset verkkoblogeihin.",
"Permission denied you cannot access this gallery" => "Oikeutesi eivät riitä tähän galleriaan",
"No gallery indicated" => "Ei galleriaa osoitettu",
"Permission denied you can not view this section" => "Oikeutesi eivät riitä katsomaan tätä osastoa",
"Permission denied you cannot remove images from this gallery" => "Oikeutesi eivät riitä poistamaan kuvia tästä galleriasta",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Oikeutesi eivät riitä tekemään minikuvia tästä galleriasta",
"Permission denied you cannot rotate images in this gallery" => "Oikeutesi eivät riitä kääntämään kuvia tässä galleriassa",
"No image indicated" => "Ei kuvaa osoitettu",
"Permission denied you cannot move images from this gallery" => "Oikeutesi eivät riitä siirtämään kuvia tästä galleriasta",
"Permission denied you cannot view the calendar" => "Oikeutesi eivät riitä katsomaan kalenteria",
"event without name" => "nimetön tapahtuma",
"Access Denied" => "Pääsy Estetty",
"First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "Viikon ensimmäinen päivä: Sunnuntai (sen ID on 0) - kääntäjät muuttakaa paikalliseksi!",
"Tiki RSS feed for calendars" => "RSS syöte kalentereille",
"Upcoming events." => "Tulossa olevat tapahtumat.",
"End:" => "Lopetus:",
"No category indicated" => "Ei luokkaa osoitettu",
"Permission denied; you cannot assign permissions for this category" => "Lupa evätty; et voi antaa oikeuksia tälle luokalle",
"Invalid username or activation code. Maybe this code has already been used." => "Väärä käyttäjänimi tai aktivointi koodi. Ehkä tämä koodi on jo käytetty.",
"You can not use the same password again" => "Et voi käyttää samaa salasanaa uudelleen",
"Top authors" => "Top kirjoittajat",
"Account validated successfully." => "Tili varmistettu onnistuneesti.",
"ERROR: you must include a subject or a message at least" => "VIRHE: otsikko on oltava tai viesti vähintään",
"You need to change chmod 'whelp' manually to 777" => "Sinun muutettava chmod 'whelp' oikeudet käsin 777",
"This feature has been disabled" => "Tämä ominaisuus poistettu",
"Tiki RSS feed for directory sites" => "RSS syöte hakemisto sivustoille",
"Last sites." => "Viimeiset sivustot.",
"Must enter a name to add a site. " => "Annettava nimi lisätäksesi sivuston. ",
"Must enter a url to add a site. " => "Annettava url lisätäksesi sivuston. ",
"URL already added to the directory. Duplicate site? " => "URL on jo hakemistossa. Kopio sivusto? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL osoite ei toimi URL on väärin tai sivusto ei ole verkossa eikä sitä voi lisätä hakemistoon. ",
"Must select a category. " => "On valittava luokittelu. ",
"Must enter a name to add a site" => "Annettava nimi lisätäksesi sivuston",
"Must enter a url to add a site" => "Annettava url lisätäksesi sivuston",
"URL already added to the directory. Duplicate site?" => "URL on jo olemassa. Kopioidaanko sivusto?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL osoite ei toimi URL on väärin tai sivusto ei ole verkossa eikä sitä voi lisätä hakemistoon",
"Must select a category" => "On valittava luokittelu",
"No site indicated" => "Ei sivustoa osoitettu",
"No parent specified" => "Ei isäntää",
"Last sites of directory \".\$rc[\"name\"].\" ." => "Viimeiset sivustot hakemistossa \".\$rc[\"nimi\"].\" .",
"Article not found" => "Artikkelia ei löytynyt",
"Permission denied you cannot edit this article" => "Oikeutesi eivät riitä tämän artikkelin muokkaamiseen",
"The language can't be changed as its set of translations has already this language" => "Kieltä ei voi muuttaa, koska sen niminen on jo kieli hakemistossa",
"You do not have permissions to edit banners" => "Oikeutesi eivät riitä bannerien muokkaamiseen",
"Banner not found" => "Banneria ei löydy",
"You do not have permission to edit this banner" => "Oikeutesi eivät riitä tämän bannerin muokkaamiseen",
"Permission denied you cannot create or edit blogs" => "Oikeutesi eivät riitä blogien luomiseen tai muokkaamiseen",
"Permission denied you cannot edit this blog" => "Oikeutesi eivät riitä tämän blogin muokkaamiseen",
"You do not have permission to write the style sheet" => "Oikeutesi eivät riitä tyylitiedoston kirjoittamiseen",
"Invalid request to edit an image" => "Väärä pyyntö muokataksesi kuvaa",
"Permission denied you cannot edit images" => "Oikeutesi eivät riitä kuvan muokkaamiseen",
"Permission denied you can edit images but not in this gallery" => "Oikeutesi riittävät kuvan muokkaamiseen, muttei tässä galleriassa",
"Failed to edit the image" => "Kuvan muokkaus epäonnistui",
"Permission denied to use this feature" => "Oikeutesi eivät riitä käyttämään tätä ominaisuutta",
"Shortname must be 2 Characters" => "Lyhenne pitää olla 2 merkkiä",
"You must provide a longname" => "Tarjottava pitempi nimi",
"Language created" => "Kieli luotu",
"No content id indicated" => "Ei sisältö id:tä osoitettu",
"No question indicated" => "Ei kysymystä osoitettu",
"No quiz indicated" => "Ei visailua osoitettu",
"No structure indicated" => "Ei rakennetta osoitettu",
"Invalid structure_id or page_ref_id" => "Väärä rakenne_id tai sivu_ref_id",
"Permission denied you cannot send submissions" => "Oikeutesi eivät riitä ehdotuksen lähettämiseen",
"Permission denied you cannot edit submissions" => "Oikeutesi eivät riitä ehdotuksen muokkaamiseen",
"You have to create a topic first" => "On luotava ensin aihe",
"You do not have permission to do that" => "Oikeutesi eivät riitä siihen",
"You do not have permission to write the template:" => "Sinulla ei ole oikeutta kirjoittaa mallia:",
"You do not have permission to read the template" => "Oikeutesi eivät riitä lukemaan mallia",
"No topic id specified" => "Ei aihe id:tä määritelty",
"Invalid topic id specified" => "Väärä aiha id määritelty",
"No object indicated" => "Ei kohdetta osoitettu",
"No type indicated" => "Ei tyyppiä osoitettu",
"page imported" => "sivu tuotu",
"created from import" => "luotu tuodusta",
"Can't import remote HTML page" => "Ei voi tuoda ulkoista HTML sivua",
"The SandBox is disabled" => "Hiekkaloota poistettu",
"Cannot edit page because it is locked" => "Et voi muokata tätä sivua, koska se on lukittu",
"No questions group indicated" => "Ei kysymysten ryhmää osoitettu",
"Permission denied you cannot edit this file" => "Oikeutesi eivät riitä muokkaamaan tätä tiedostoa",
"Permission denied you cannot remove files from this gallery" => "Oikeutesi eivät riitä poistamaan tiedostoja tästä galleriasta",
"Top visited file galleries" => "Katsotuimmat tiedosto galleriat",
"Most downloaded files" => "Imuroiduimmat tiedostot",
"Last files" => "Viimeiset tiedostot",
"Tiki RSS feed for file galleries" => "RSS syöte tiedosto gallerioille",
"Last files uploaded to the file galleries." => "Viimeksi lähetetyt tiedostot tiedostogallerioissa.",
"No galleryId specified" => "Ei galleriaId tarkennusta",
"Tiki RSS feed for the file gallery: " => "RSS syöte tiedostogallerialle: ",
"No forum indicated" => "Ei foorumia osoitettu",
"Forum posts" => "Foorumi lähetykset",
"No forumId specified" => "Ei foorumiId tarkennusta",
"Tiki RSS feed for forum: " => "RSS syöte foorumille: ",
"Tiki RSS feed for forums" => "RSS syöte foorumeille",
"Last topics in forums." => "Viimeiset foorumien aiheet.",
"Accepted friendship request from %s" => "Hyväksytty ystävyyspyyntö %s :lta",
"Refused friendship request from %s" => "Hylätty ystävyyspyyntö from %s :lta",
"Broke friendship with %s" => "Riko ystävyys %s :n",
"I have broken our friendship!" => "Olen rikkonut ystävyytemme!",
"You must be logged in to use this feature" => "Sinun on kirjauduttava sisään käyttääksesi tätä ominaisuutta",
"Friendship request sent to %s" => "Ystävyys pyyntö on lähetetty %s :lle",
"You're already friend of %s" => "Olet jo %s :n ystävä",
"I have accepted your friendship request!" => "Olen hyväksynyt ystävyyspyyntösi!",
"No process indicated" => "Ei prosessia osoitettu",
"Role name cannot be empty" => "Tehtävä nimi ei voi olla tyhjä",
"Activity name cannot be empty" => "Toiminnon nimi ei voi olla tyhjä",
"Activity name already exists" => "Toiminto tällä nimellä on olemassa",
"indicates if the process is active. Invalid processes cant be active" => "osoittaa, että menetelmä toimii, väärä menetelmä ei voi toimia",
"No instance indicated" => "Ei pyyntöä osoitettu",
"No activity indicated" => "Ei toimintoa osoitettu",
"The process name already exists" => "Prosessi tällä nimellä on olemassa",
"Process already exists" => "Prosessi on jo olemassa",
"You cant execute this activity" => "Et voi käynnistää toimintoa",
"You couldn't abort a instance" => "Et voi keskeyttää pyyntöä",
"You couldn't exception a instance" => "Et voi tehdä poikkeusta pyyntöön",
"No user indicated" => "Ei käyttäjää osoitettu",
"No title indicated" => "Ei otsikkoa osoitettu",
"No comment indicated" => "Ei kommenttia osoitettu",
"No date indicated" => "Ei päiväystä osoitettu",
"No item indicated" => "Ei osaa osoitettu",
"first uploaded image" => "lähetä ensin kuva",
"last uploaded image" => "viimeksi lähetetty kuva",
"first image" => "ensimmäinen kuva",
"last image" => "viimeisin kuva",
"random image" => "satunnais kuva",
"Permission denied you cannot create galleries and so you cant edit them" => "Oikeutesi eivät riitä gallerian luomiseen,joten et voi myöskään muokata",
"Permission denied you cannot edit this gallery" => "Oikeutesi eivät riitä gallerian muokkaamiseen",
"Permission denied you cannot remove this gallery" => "Oikeutesi eivät riitä gallerian poistamiseen",
"Permission denied you cannot make the map of this gallery" => "Lupa evätty, et voi tehdä karttaa tästä galleriasta",
"Top images" => "Top kuvat",
"Last images" => "Viimeiset kuvat",
"No valid renderer found. GD or PDFLib required." => "Ei löytynyt muodostajaa. GD tai PDFLib tarvitaan.",
"No sheet specified." => "Ei määriteltyä arkkia.",
"You must select a renderer." => "Valitse muodostaja.",
"Invalid Series for current graphic." => "Viallinen sarja nykyiselle grafiikalle.",
"Tiki RSS feed for image galleries" => "RSS syöte kuva gallerioille",
"Last images uploaded to the image galleries." => "Viimeiset lähetetyt kuvat kuva gallerioihin.",
"Tiki RSS feed for the image gallery: " => "RSS syöte kuva gallerialle: ",
"overwriting old page" => "päällekirjoitetaan vanha sivu",
"updated from structured text import" => "päivitetty rakenteen sisältävästä tekstituonnista",
"page created" => "sivu luotu",
"created from structured text import" => "luotu rakenteen sisältävästä tekstituonnista",
"No name indicated for wiki page" => "Ei nimeä osoitettu wiki sivulle",
"No repository given" => "Ei säilytyspaikkaa annettu",
"Permission denied you cannot view pages like this page" => "Oikeutesi eivät riitä tämän kaltaisten sivujen katsomiseen",
"Permission denied you cannot remove articles" => "Oikeutesi eivät riitä poistamaan artikkeleja",
"Permission denied you cannot remove banners" => "Oikeutesi eivät riitä poistamaan bannereita",
"Permission denied you cannot remove this blog" => "Oikeutesi eivät riitä poistamaan tätä blogia",
"Non-existent gallery" => "Ei olemassa oleva galleria",
"Permission denied you can upload files but not to this file gallery" => "Voit lähettää tiedostoja, mutta et tähän galleriaan",
"Could not upload the file" => "Ei voi lähettää tiedostoa",
"Could not find the file requested" => "Pyydettyä tiedostoa ei löytynyt",
"File update was successful" => "Tiedosto päivitys onnistui",
"Permission denied you can't upload files so you can't edit them" => "Oikeutesi eivät riitä lähtettämään tiedostoja, joten et voi myöskään muokata niitä",
"This gallery does not exist" => "Tällaista galleriaa ei ole",
"The game file must have .swf or .dcr extension" => "Peli tiedostolla on oltava .swf tai .dcr pääte",
"The thumbnail name must be" => "Minikuvan nimi on oltava",
"Please supply both files" => "Lähetä molemmat tiedostot",
"You cannot admin blogs" => "Et voi hallinnoida blogeja",
"Permission denied you cannot remove submissions" => "Oikeutesi eivät riitä poistamaan ehdotuksia",
"Permission denied you cannot approve submissions" => "Oikeutesi eivät riitä hyväksymään ehdotuksia",
"You have to enable cookies to be able to login to this site" => "Sinun on hyväksyttävä keksit voidaksesi kirjautua tälle sivustolle",
"Unable to contact remote server." => "Yhteyttä ulkoisiin palvelimiin ei saada.",
"XMLRPC Error: " => "XMLRPC Virhe: ",
"Tiki mail-in auto-reply" => "Postit-sisään autom-vastaus",
"Sorry, you can't use this feature." => "Valitan, et voi käyttää tätä ominaisuutta.",
"edit" => "muokkaa",
"You do not have permissions to view the maps" => "Oikeutesi eivät riitä katsomaan karttoja",
"Maps feature is not correctly setup : Maps path is missing." => "Kartta ominaisuuden asetukset ovat väärin : Karttojen polku puuttuu.",
"mapfile name incorrect" => "karttatiedoston nimi väärin",
"This mapfile already exists" => "Karttatiedosto on jo olemassa",
"You do not have permission to write to the mapfile" => "Oikeutesi eivät riitä karttatiedoston kirjoittamiseen",
"You do not have permission to delete the mapfile" => "Oikeutesi eivät riitä poistamaan karttatiedostoa",
"I could not make a copy" => "Ei voitu kopioida",
"You do not have permission to read the mapfile" => "Oikeutesi eivät riitä lukemaan karttatiedostoa",
"You dont have permission to do that" => "Oikeutesi eivät riitä sen tekemiseen",
"Tiki RSS feed for maps" => "RSS syöte kartoille",
"List of maps available." => "Saatavilla olevien karttojen luettelo.",
"You do not have permissions to view the layers" => "Oikeutesi eivär riitä katsomaan tasoja",
"You do not have permissions to delete a file" => "Oikeutesi eivät riitä poistamaan tiedostoa",
"File not found" => "Tiedostoa ei löydy",
"You do not have permissions to create a directory" => "Oikeutesi eivät riitä luomaan hakemistoa",
"The Directory is not empty" => "Hakemisto ei ole tyhjä",
"You do not have permissions to delete a directory" => "Oikeutesi eivät riitä poistamaan hakemistoa",
"You do not have permissions to create an index file" => "Oikeutesi eivät riitä luomaan index tiedostoa",
"Invalid file name" => "Väärä tiedoston nimi",
"Invalid files to index" => "Väärä tiedosto indeksiksi",
"I do not know where is gdaltindex. Set correctly the Map feature" => "En tiedä missä on gdaltindex. Aseta oikea kartta ominaisuus",
"I could not create the index file" => "Ei voi luoda index tiedostoa",
"Must be logged to use this feature" => "On kirjauduttava käyttääksesi ominaisuutta",
"Welcome at Hawiki" => "Tervetuloa Mobileen",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Sivusto on luotu käytettäväksi myös, esimerkiksi WAP puhelimilla, PDA, i-mode laitteilla ja paljon muuta.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "Voit selata sivustoa mobiili laitteella osoittamalla seuraavalle sivulle:",
"tiki-mobile.php" => "mobile.php",
"About" => " ",
"You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "Sinun on ajettava setup.sh :<br />./setup.sh \$APACHEUSER all<br />Yleinen Apache käyttäjä on www-data, apache tai nobody",
"Your PHP installation does not have zlib enabled." => "Sinun PHP asennuksessa ei ole zlib päällä.",
"You must log in to use this feature" => "On kirjauduttava käyttääksesi tätä ominaisuutta",
"You do not have permission to view other users data" => "Oikeutesi eivät riitä katsomaan muiden käyttäjien tietoja",
"You must be logged in to subscribe to newsletters" => "On kirjauduttava tilataksesi uutislehden",
"No server indicated" => "Ei palvelinta osoitettu",
"Cannot connect to" => "Ei voi yhdistää",
"Missing information to read news (server,port,username,password,group) required" => "Tietoja puuttuu lukeaksesi uutisia (palvelin,portti,käyttäjänimi,salasana,ryhmä) tarvitaan",
"Cannot get messages" => "Viestejä ei saatu",
"No note indicated" => "Ei merkintää osoitettu",
"merged note:" => "yhdistetty merkintä:",
"File is too big" => "Tiedosto liian suuri",
"created from notepad" => "luotu muistiosta",
"Page already exists" => "Sivu on jo olemassa",
"Not enough information to display this page" => "Ei tarpeeksi tietoja sivun näyttämiseen",
"Permission denied you cannot browse this page history" => "Oikeutesi eivät riitä selaamaan tämän sivun historiaa",
"No article indicated" => "Ei artikkelia osoitettu",
"Article is not published yet" => "Artikkelia ei ole vielä julkaistu",
"No post indicated" => "Ei postia osoitettu",
"Blog not found" => "Blogia ei löydy",
"No pages indicated" => "Ei sivuja osoitettu",
"Pageviews" => "Sivunäyttöjä",
"You don't have permission to edit quizzes." => "Oikeutesi eivät riitä muokkaamaan visailuja.",
"No result indicated" => "Ei tulosta osoitettu",
"The passwords don't match" => "Salasana ei kelpaa",
"empty" => "tyhjennä",
"Invalid or unknown username" => "Väärä tai tuntematon käyttäjänimi",
"Unable to send mail. User has not configured email" => "Sähköpostia ei voi lähettää. Käyttäjä ei ole antanut sähköpostiosoitetta",
"A password and your IP address reminder email has been sent " => "Salasana ja IP osoite muistutus on lähetetty ",
"to the registered email address for" => "rekisteröityyn sähköpostiosoitteeseen",
"last version" => "viimeinen versio",
"Permission denied you cannot remove versions from this page" => "Oikeutesi eivät riitä poistamaan tämän sivun versioita",
"Permission denied you cannot rename this page" => "Oikeutesi eivät riitä muuttamaan sivun nimeä",
"Cannot rename page because the new name begins with reserved prefix" => "Et voi uudelleen nimetä sivua koska uusi nimi alkaa jo varatulla etuliitteellä",
"Cannot rename page maybe new page already exists" => "Ei voi nimetä uudelleen sivua, kenties sillä nimellä on jo sivu",
"changed '%s' from '%s' to '%s'" => "vaihdettu '%s' '%s':sta '%s':oon",
"Non-existent version" => "Olemanton versio",
"Permission denied you cannot rollback this page" => "Oikeutesi eivät riitä kelata takaisin tätä sivua",
"Error Message" => "Virhe Viesti",
"Tiki RSS Feed Error Message: \$errmsg" => "RSS Syötteen Virhe Viesti: \$errmsg",
"Post recommendation at" => "Lähetä suositus",
"No newsletters available." => "Ei uutislehtiä saatavilla.",
"successfully sent" => "onnistuneesti lähetetty",
"not sent" => "ei lähetetty",
"Error: " => "Virhe: ",
"Page must be defined inside a structure to use this feature" => "Sivu on määriteltävä rakenteen sisällä käyttääksesi tätä ominaisuutta",
"You cannot take this quiz twice" => "Et voi osallistua visailuun kahdesti",
"Quiz time limit exceeded quiz cannot be computed" => "Visailun aikaraja ylitetty, ei voi pisteyttää",
"You cannot take this survey twice" => "Et voi ottaa tutkimusta kahdesti",
"Please create a category first" => "Luo luokittelu ensin",
"Tracker item:" => "Kortisto osa:",
"No trackerId specified" => "Ei kortistoId määrittelyä",
"Tiki RSS feed for individual trackers: " => "RSS syöte yksittäis kortistoille: ",
"No permission to upload zipped file packages" => "Ei oikeutta lähettää zip-paketteja",
"Error processing zipped image package" => "Virhe zip-pakettien purkamisessa",
"No permission to upload zipped image packages" => "Ei oikeutta lähettää zip-pakattuja kuvatiedostoja",
"The uploaded file ist not recognized as a image" => "Lähetettyä tiedostoa ei tunnistettu kuvaksi",
"Permission denied you cannot upload images" => "Et voi lähettää kuvia",
"Permission denied you can upload images but not to this gallery" => "Voit lähettää kuvia, mutta et tähän galleriaan",
"Cannot get image from URL" => "Kuvaa ei saatu osoitteesta URL",
"That is not an image (or you have php < 4.0.5)" => "Tämä ei ole kuva (tai sinulla on php < 4.0.5)",
"Usage" => "Käyttö",
"No url indicated" => "Ei url osoitettu",
"Unknown user" => "Tuntematon käyttäjä",
"You are not logged in and no user indicated" => "Et ole kirjautunut eikä käytäjää ole osoitettu",
"The user has chosen to make his information private" => "Käyttäjä on valinnut tietonsa yksityisiksi",
"Email is set to %s" => "Sähköpostiksi on asetettu %s",
"The passwords did not match" => "Salasana ei täsmää",
"no" => "ei",
"was moved into trash" => "on siirretty roskiin",
"trashed by" => "siirtänyt roskiin",
"open / in process" => "avaa / menetelmään",
"Rights by creator" => "Oikeudet luojalla",
"END" => "LOPPU",
"Percentage" => "Prosentteina",
"Task accepted by creator" => "Tehtävän hyväksynyt sen luoja",
"Task accepted by task user" => "Tehtävän hyväksynyt tehtävän käyttäjä",
"Task NOT accepted by creator" => "Tehtävää EI hyväksynyt sen luoja",
"Task NOT accepted by task user" => "Tehtävää EI hyväksynyt tehtävän käyttäjä",
"Sorry this task does not exist or you have no rights to view this task" => "Valitan tällaista tehtävää ei ole tai sinulla ei ole oikeutta nähdä sitä",
"Task entries:" => "Tehtävät:",
"Changes:" => "Muutokset:",
"Info message" => "Info viesti",
"NEW Task" => "UUSI Tehtävä",
"Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Valitan, mutta et voi lähettää tehtäviä muille käyttäjille, tai käyttäjällä ei ole oikeutta vastaanottaa tehtävää!",
"Changes on Task" => "Tehtävän Muutokset",
"You received a new task" => "Olet vastaanottanut uuden tehtävän",
"The priority is" => "Kiireellisyys",
"very low" => "erittäin alhainen",
"low" => "alhainen",
"high" => "korkea",
"very high" => "erittäin korkea",
"You've to start your work at least on" => "Sinun on aloitettava työsi viimeistään",
"You've to finish your work on" => "Työsi on saatava valmiiksi",
"Login and click the link below" => "Kirjaudu ja paina linkkiä alhaalta",
"Please read the task and work on it!" => "Lue tehtävä ja tee se!",
"Sorry, there was an error while trying to write data into the database" => "Valitan, ilmeni virhe kirjoitettaessa tietokantaan",
"Cannot upload this file not enough quota" => "Et voi lähettää tiedostoa, levytilasi on liian pieni",
"Non-existent user" => "Olematon käyttäjä",
"No banner indicated" => "Ei banneria osoitettu",
"No blog indicated" => "Ei blogia osoitettu",
"Permission denied you cannot remove the post" => "Et voi poistaa lähetystä",
"No cache information available" => "Ei puskuritietoja saatavilla",
"No faq indicated" => "Ei ukk:ta osoitettu",
"You are not permitted to remove someone else\\'s post!" => "Et voi poistaa kenenkään toisen posteja!",
"No thread indicated" => "Ei ketjua osoitettu",
"A SheetId is required." => "ArkkiId tarvitaan.",
"That tracker don't use extras." => "Se kortisto ei käytä ekstroja.",
"No subject" => "Ei otsaketta",
"Top pages" => "Top sivut",
"Last pages" => "Viimeiset sivut",
"Tiki RSS feed for the wiki pages" => "RSS syöte sivuston sivuille",
"Last modifications to the Wiki." => "Viimeiset muutokset sivustolla.",
"###end###"=>"###end###");
?>
