<?php
// ===================================================================================================
//                           _  __     _ _
//                          | |/ /__ _| | |_ _  _ _ _ __ _
//                          | ' </ _` | |  _| || | '_/ _` |
//                          |_|\_\__,_|_|\__|\_,_|_| \__,_|
//
// This file is part of the Kaltura Collaborative Media Suite which allows users
// to do with audio, video, and animation what Wiki platfroms allow them to do with
// text.
//
// Copyright (C) 2006-2017  Kaltura Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// @ignore
// ===================================================================================================

/**
 * @namespace
 */
namespace Kaltura\Client\Type;

/**
 * @package Kaltura
 * @subpackage Client
 */
abstract class ConversionProfileAssetParamsBaseFilter extends \Kaltura\Client\Type\RelatedFilter
{
	public function getKalturaObjectType()
	{
		return 'KalturaConversionProfileAssetParamsBaseFilter';
	}
	
	public function __construct(\SimpleXMLElement $xml = null)
	{
		parent::__construct($xml);
		
		if(is_null($xml))
			return;
		
		if(count($xml->conversionProfileIdEqual))
			$this->conversionProfileIdEqual = (int)$xml->conversionProfileIdEqual;
		if(count($xml->conversionProfileIdIn))
			$this->conversionProfileIdIn = (string)$xml->conversionProfileIdIn;
		if(count($xml->assetParamsIdEqual))
			$this->assetParamsIdEqual = (int)$xml->assetParamsIdEqual;
		if(count($xml->assetParamsIdIn))
			$this->assetParamsIdIn = (string)$xml->assetParamsIdIn;
		if(count($xml->readyBehaviorEqual))
			$this->readyBehaviorEqual = (int)$xml->readyBehaviorEqual;
		if(count($xml->readyBehaviorIn))
			$this->readyBehaviorIn = (string)$xml->readyBehaviorIn;
		if(count($xml->originEqual))
			$this->originEqual = (int)$xml->originEqual;
		if(count($xml->originIn))
			$this->originIn = (string)$xml->originIn;
		if(count($xml->systemNameEqual))
			$this->systemNameEqual = (string)$xml->systemNameEqual;
		if(count($xml->systemNameIn))
			$this->systemNameIn = (string)$xml->systemNameIn;
	}
	/**
	 * 
	 * @var int
	 */
	public $conversionProfileIdEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $conversionProfileIdIn = null;

	/**
	 * 
	 * @var int
	 */
	public $assetParamsIdEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $assetParamsIdIn = null;

	/**
	 * 
	 * @var \Kaltura\Client\Enum\FlavorReadyBehaviorType
	 */
	public $readyBehaviorEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $readyBehaviorIn = null;

	/**
	 * 
	 * @var \Kaltura\Client\Enum\AssetParamsOrigin
	 */
	public $originEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $originIn = null;

	/**
	 * 
	 * @var string
	 */
	public $systemNameEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $systemNameIn = null;

}
