<?php
// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: renderer_bytes.php 66113 2018-04-19 18:52:11Z luciash $

//this script may only be included - so its better to die if called directly.
if (strpos($_SERVER["SCRIPT_NAME"], basename(__FILE__)) !== false) {
	header("location: index.php");
	exit;
}

/**
 * Give back the kb change
 *
 */
class Text_Diff_Renderer_bytes extends Text_Diff_Renderer
{
	public function __construct($first = -1)
	{
		$this->_addBytes = 0;
		$this->_delBytes = 0;
		$this->_first = $first;
	}

	protected function _startDiff()
	{
	}

	protected function _endDiff()
	{
		return 'add=' . $this->_addBytes . '&amp;del=' . $this->_delBytes;
	}

	protected function _blockHeader($xbeg, $xlen, $ybeg, $ylen)
	{
	}

	protected function _added($lines)
	{
		$this->_addBytes += $this->_count($lines);
	}

	protected function _deleted($lines)
	{
		$this->_delBytes += $this->_count($lines);
	}

	protected function _changed($orig, $final)
	{
		if ($this->_first >= 0) { // stop recursion
			$this->_addBytes += count($final);
			$this->_delBytes += count($orig);
			return;
		}
		$change = diffChar($orig, $final, 0, 'bytes');
		preg_match("/add=([0-9]*)&amp;del=([0-9]*)/", $change, $matches);
		$this->_addBytes += $matches[1];
		$this->_delBytes += $matches[2];
	}
	protected function _count($lines)
	{
		$bytes = 0;
		foreach ($lines as $line) {
			$bytes += strlen($line);
		}
		return $bytes;
	}
}
