
#line 3 "thrift/thriftl.cc"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

#define YY_FLEX_LEX_COMPAT
extern int yylineno;
int yylineno = 1;

extern char yytext[];

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	if ( yyleng >= YYLMAX ) \
		YY_FATAL_ERROR( "token too large, exceeds YYLMAX" ); \
	yy_flex_strncpy( yytext, (yytext_ptr), yyleng + 1 ); \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 66
#define YY_END_OF_BUFFER 67
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[366] =
    {   0,
        1,    1,   67,   65,    1,    1,   64,    6,   59,    7,
        8,   63,   65,   65,   60,   60,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,    1,    6,    0,
       60,   60,    0,   63,    4,    5,    0,    0,   62,    0,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   34,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   63,
        3,    5,   61,   62,   62,   62,   62,   62,   62,   62,

       62,   62,   62,   62,   62,   62,   62,   35,   36,   37,
       62,   62,   62,   43,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   45,   62,   62,   62,   62,   62,
       62,   62,   62,   62,    0,    2,   62,   62,   32,   33,
       62,   62,   62,   62,   62,   62,   54,   62,   62,   62,
       62,   62,   44,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   10,   62,
       62,   31,   62,   58,   62,   62,   55,   62,   62,   62,
       62,   62,   62,   62,   62,    9,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   42,   62,   41,   62,

       62,   62,   62,   62,   49,   62,   62,   62,   40,   62,
       62,   62,   62,   62,   62,   38,   62,   62,   62,   62,
       62,   46,   62,   62,   62,   62,   62,   62,   62,   62,
       39,   48,   52,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   51,   30,   62,   62,
       62,   62,   62,   62,   62,   62,   53,   62,   47,   25,
       62,   62,   62,   62,   62,   62,   62,   14,   62,   62,
       62,   62,   62,   57,   62,   62,   62,   56,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   50,
       62,   11,   62,   62,   20,   62,   62,   29,   62,   62,

       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   13,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   16,   62,
       62,   62,   15,   21,   62,   62,   62,   62,   62,   27,
       26,   12,   62,   62,   19,   62,   62,   62,   28,   62,
       62,   22,   62,   62,   62,   62,   62,   62,   17,   18,
       62,   24,   62,   23,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    5,    1,    1,    6,    4,    7,
        7,    8,    9,    7,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   18,   17,   19,   17,    7,    7,    7,
        7,    7,    1,    1,   20,   20,   20,   20,   21,   20,
       22,   22,   22,   22,   22,   22,   22,   22,   22,   22,
       22,   22,   22,   22,   22,   22,   22,   22,   22,   22,
        7,    1,    7,    1,   23,    1,   24,   25,   26,   27,

       28,   29,   30,   31,   32,   33,   34,   35,   36,   37,
       38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
       48,   22,    7,    1,    7,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[49] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    3,    4,
        1,    5,    5,    5,    5,    5,    5,    5,    5,    6,
        7,    8,    8,    6,    6,    6,    6,    7,    6,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8
    } ;

static const flex_int16_t yy_base[373] =
    {   0,
        0,    0,  751,  752,   47,   49,  752,    0,  752,  752,
      752,   43,    0,   46,   46,  703,  739,   85,   48,   73,
       49,   51,   23,   52,   97,   53,   74,   56,   58,   86,
       98,   99,  104,  107,   55,   75,   76,   70,    0,    0,
        0,  701,  738,  103,  738,    0,    0,  735,  734,  734,
      733,   71,  112,  118,  110,  125,  120,  123,  126,  127,
      131,  134,  132,  140,  154,   59,  731,  147,  135,  142,
      153,  155,  159,  156,  160,  164,  162,  166,  168,  171,
      172,  173,  169,  176,  178,  179,  184,  188,  180,  731,
      194,    0,    0,  186,  185,  190,  201,  203,  205,  209,

      211,  214,  217,  216,  218,  220,  221,  729,  728,  727,
      223,  226,  224,  726,  227,  228,  229,  230,  233,  234,
      235,  239,  241,  244,  725,  249,  247,  252,  250,  258,
      262,  254,  256,  270,  265,  752,  268,  259,  724,  723,
      271,  261,  265,  288,  289,  291,  722,  267,  293,  295,
      297,  299,  721,  300,  301,  302,  304,  306,  307,  303,
      305,  308,  314,  309,  321,  311,  323,  322,  720,  324,
      326,  719,  329,  718,  327,  337,  717,  328,  340,  344,
      345,  347,  348,  351,  359,  716,  360,  349,  352,  361,
      362,  363,  371,  370,  364,  367,  715,  372,  714,  368,

      373,  375,  379,  380,  713,  390,  383,  391,  703,  396,
      386,  400,  403,  404,  406,  700,  407,  409,  410,  413,
      416,  692,  421,  422,  412,  414,  424,  431,  433,  439,
      683,  680,  679,  418,  434,  440,  443,  446,  444,  447,
      449,  450,  452,  454,  455,  456,  677,  676,  460,  463,
      458,  464,  457,  461,  472,  462,  675,  465,  674,  672,
      466,  467,  487,  491,  492,  493,  494,  671,  495,  500,
      496,  498,  499,  670,  501,  502,  503,  669,  506,  504,
      505,  507,  515,  508,  511,  516,  518,  519,  520,  668,
      535,  667,  538,  531,  665,  532,  540,  664,  541,  542,

      544,  543,  548,  554,  551,  555,  556,  558,  561,  550,
      567,  563,  559,  572,  562,  663,  574,  580,  581,  582,
      585,  588,  587,  591,  589,  592,  593,  594,  662,  597,
      595,  598,  661,  660,  607,  602,  606,  610,  614,  659,
      658,  657,  609,  616,  656,  617,  622,  626,  653,  621,
      631,  651,  629,  633,  634,  636,  638,  641,  650,  648,
      642,  646,  643,  644,  752,  691,  696,   73,  700,  706,
      711,  715
    } ;

static const flex_int16_t yy_def[373] =
    {   0,
      365,    1,  365,  365,  365,  365,  365,  366,  365,  365,
      365,  367,  368,  365,  367,   15,  369,  369,  369,  369,
      369,  369,   18,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  365,  366,  368,
       15,   15,  370,  368,  365,  371,  372,  369,  369,  370,
       18,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  370,
      365,  371,  372,  369,  369,  369,  369,  369,  369,  369,

      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  365,  365,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,

      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,

      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
      369,  369,  369,  369,    0,  365,  365,  365,  365,  365,
      365,  365
    } ;

static const flex_int16_t yy_nxt[801] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   16,   16,   16,   16,   16,   16,   17,
       18,   17,   17,   19,   20,   21,   22,   23,   24,   17,
       17,   25,   26,   17,   27,   28,   29,   30,   31,   17,
       32,   33,   34,   35,   36,   17,   37,   17,   38,   38,
       38,   38,   40,   45,   41,   40,   46,   48,   48,   61,
       48,   48,   48,   43,   48,   48,   43,   48,   48,   62,
       43,   38,   38,   43,  110,   63,   69,   44,   59,   71,
       48,   72,   48,   48,   48,   48,   56,   57,   60,   52,
       58,   87,   47,   50,   48,   48,   51,   51,   51,   51,

       51,   51,   51,   51,   53,   70,   48,   48,   48,   64,
       54,   65,   88,   48,   66,   67,   48,   89,   94,   48,
       55,   48,   73,   43,   74,   75,   78,   48,   76,   48,
       43,   80,   48,   68,   48,   48,   48,   84,   81,   82,
       48,   48,   79,   48,   48,   77,   83,   85,   95,   48,
       98,   48,   97,  101,   86,   96,   48,  108,  100,  105,
      102,   99,   48,   48,   48,   48,  107,  109,   48,   48,
      103,   48,  111,   48,  104,   48,  106,   48,   48,  112,
       48,   48,   48,  113,  120,   48,  116,   48,   48,   48,
      115,  114,  122,   48,   48,   48,  127,   48,  117,   48,

      118,  135,  119,  126,  136,  121,  134,  123,  138,  128,
       48,  124,   48,  125,   48,  132,  129,  131,   48,  133,
       48,  130,  137,   48,  139,   48,   48,   48,  140,   48,
       48,  143,   48,   48,  144,   48,   48,   48,   48,   48,
      141,  146,   48,   48,   48,  148,  142,  149,   48,  152,
       48,  147,  145,   48,  154,  158,   48,  151,   48,   48,
      156,   48,  150,   48,  157,   48,  153,   48,   48,  159,
       48,   48,  135,  155,   48,  136,   48,   48,  160,   48,
       48,  165,  172,  166,  162,  169,  161,  168,  163,  170,
      164,  171,  173,  174,  176,  167,  178,   48,   48,  175,

       48,  179,   48,  177,   48,  184,   48,  180,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,  182,
       48,  188,  186,   48,  190,  183,  192,  196,  181,  185,
       48,   48,   48,   48,  195,   48,   48,   48,   48,  191,
      187,  189,  193,  197,  194,  198,   48,  201,  202,   48,
      204,  199,  206,   48,   48,  200,   48,   48,   48,  210,
       48,   48,  205,  212,  211,  207,  208,  203,   48,   48,
       48,   48,   48,   48,  209,  216,   48,   48,  215,   48,
       48,   48,   48,  214,   48,  218,  219,  220,   48,   48,
      221,  213,   48,  217,  225,   48,  226,  229,  223,   48,

       48,  224,  231,  228,  227,   48,  237,  234,  222,   48,
      230,  241,   48,   48,  238,   48,   48,  232,   48,   48,
      233,   48,   48,   48,  235,   48,  244,   48,  245,  239,
       48,   48,  236,   48,  240,  242,  249,  248,  246,  250,
       48,  243,   48,   48,  251,  252,  259,  253,   48,   48,
      247,  255,   48,   48,  256,   48,   48,  254,   48,   48,
      257,   48,  258,   48,   48,   48,   48,   48,  260,   48,
       48,   48,   48,   48,   48,   48,   48,  267,  262,  268,
      263,   48,  261,  266,  276,  272,  264,  265,  273,  275,
      269,  270,  274,  271,  282,  277,   48,  279,  278,  280,

       48,   48,   48,   48,   48,   48,  281,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,  288,  285,
       48,  283,  284,  289,   48,   48,  292,   48,   48,   48,
      295,  291,  290,  296,  293,  287,  286,  297,  300,  302,
       48,   48,  303,  294,   48,  301,  298,   48,  299,   48,
       48,   48,   48,   48,  305,  306,  304,   48,  307,   48,
       48,  308,  311,   48,   48,   48,  313,   48,   48,  309,
       48,   48,   48,  310,  315,  316,   48,  317,  318,  312,
      314,   48,  319,   48,  322,  320,  326,  321,  323,   48,
       48,   48,  324,  327,   48,  328,   48,   48,   48,  330,

       48,   48,   48,   48,   48,  325,   48,   48,  329,  333,
      336,   48,  334,  335,  337,   48,   48,  339,   48,   48,
      340,  331,  332,   48,  342,   48,   48,  346,  341,  338,
       48,   48,  350,  343,  345,   48,  344,  348,   48,  351,
       48,  349,   48,   48,  352,   48,  355,   48,  347,  353,
       48,   48,   48,   48,  354,   48,  356,   48,  357,   48,
       48,  359,   48,  360,  358,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,  361,   48,   48,   48,   48,
       48,   48,  363,   48,   48,   48,   48,  362,   48,   48,
      364,   39,   48,   39,   39,   39,   39,   39,   39,   42,

       42,   48,   42,   49,   49,   49,   49,   49,   90,   48,
       90,   92,   48,   92,   92,   92,   92,   92,   92,   93,
       93,   93,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,  365,
       48,  365,  365,   48,  365,   91,   50,  365,   48,  365,
      365,    3,  365,  365,  365,  365,  365,  365,  365,  365,
      365,  365,  365,  365,  365,  365,  365,  365,  365,  365,
      365,  365,  365,  365,  365,  365,  365,  365,  365,  365,
      365,  365,  365,  365,  365,  365,  365,  365,  365,  365,
      365,  365,  365,  365,  365,  365,  365,  365,  365,  365

    } ;

static const flex_int16_t yy_chk[801] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    5,    5,
        6,    6,   12,   14,   12,   15,   14,   19,   21,   23,
       22,   24,   26,   12,   35,   28,   15,   29,   66,   23,
       12,   38,   38,   15,   66,   24,   26,  368,   22,   28,
       52,   29,   20,   27,   36,   37,   21,   21,   22,   19,
       21,   35,   15,   18,   18,   30,   18,   18,   18,   18,

       18,   18,   18,   18,   20,   27,   25,   31,   32,   25,
       20,   25,   36,   33,   25,   25,   34,   37,   52,   55,
       20,   53,   30,   44,   30,   31,   32,   54,   31,   57,
       44,   33,   58,   25,   56,   59,   60,   34,   33,   33,
       61,   63,   32,   62,   69,   31,   33,   34,   53,   64,
       56,   70,   55,   58,   34,   54,   68,   64,   57,   62,
       59,   56,   71,   65,   72,   74,   63,   65,   73,   75,
       60,   77,   68,   76,   61,   78,   62,   79,   83,   69,
       80,   81,   82,   70,   77,   84,   73,   85,   86,   89,
       72,   71,   79,   87,   95,   94,   82,   88,   74,   96,

       75,   91,   76,   81,   91,   78,   89,   80,   95,   83,
       97,   80,   98,   80,   99,   87,   84,   86,  100,   88,
      101,   85,   94,  102,   96,  104,  103,  105,   97,  106,
      107,  100,  111,  113,  101,  112,  115,  116,  117,  118,
       98,  103,  119,  120,  121,  105,   99,  106,  122,  112,
      123,  104,  102,  124,  115,  119,  127,  111,  126,  129,
      117,  128,  107,  132,  118,  133,  113,  130,  138,  120,
      142,  131,  135,  116,  143,  135,  148,  137,  121,  134,
      141,  127,  133,  128,  123,  130,  122,  129,  124,  131,
      126,  132,  134,  137,  141,  128,  143,  144,  145,  138,

      146,  143,  149,  142,  150,  148,  151,  143,  152,  154,
      155,  156,  160,  157,  161,  158,  159,  162,  164,  145,
      166,  152,  150,  163,  155,  146,  157,  161,  144,  149,
      165,  168,  167,  170,  160,  171,  175,  178,  173,  156,
      151,  154,  158,  162,  159,  163,  176,  166,  167,  179,
      170,  164,  173,  180,  181,  165,  182,  183,  188,  176,
      184,  189,  171,  179,  178,  173,  173,  168,  185,  187,
      190,  191,  192,  195,  175,  183,  196,  200,  182,  194,
      193,  198,  201,  181,  202,  185,  187,  188,  203,  204,
      189,  180,  207,  184,  193,  211,  194,  198,  191,  206,

      208,  192,  201,  196,  195,  210,  207,  204,  190,  212,
      200,  211,  213,  214,  207,  215,  217,  202,  218,  219,
      203,  225,  220,  226,  206,  221,  214,  234,  215,  208,
      223,  224,  206,  227,  210,  212,  220,  219,  217,  221,
      228,  213,  229,  235,  223,  224,  234,  225,  230,  236,
      218,  227,  237,  239,  228,  238,  240,  226,  241,  242,
      229,  243,  230,  244,  245,  246,  253,  251,  235,  249,
      254,  256,  250,  252,  258,  261,  262,  242,  237,  243,
      238,  255,  236,  241,  253,  249,  239,  240,  250,  252,
      244,  245,  251,  246,  262,  254,  263,  256,  255,  258,

      264,  265,  266,  267,  269,  271,  261,  272,  273,  270,
      275,  276,  277,  280,  281,  279,  282,  284,  269,  265,
      285,  263,  264,  270,  283,  286,  273,  287,  288,  289,
      277,  272,  271,  279,  275,  267,  266,  280,  283,  285,
      294,  296,  286,  276,  291,  284,  281,  293,  282,  297,
      299,  300,  302,  301,  288,  289,  287,  303,  291,  310,
      305,  293,  297,  304,  306,  307,  300,  308,  313,  294,
      309,  315,  312,  296,  302,  303,  311,  304,  305,  299,
      301,  314,  306,  317,  309,  307,  312,  308,  310,  318,
      319,  320,  311,  313,  321,  314,  323,  322,  325,  317,

      324,  326,  327,  328,  331,  311,  330,  332,  315,  320,
      323,  336,  321,  322,  324,  337,  335,  326,  343,  338,
      327,  318,  319,  339,  330,  344,  346,  336,  328,  325,
      350,  347,  343,  331,  335,  348,  332,  338,  353,  344,
      351,  339,  354,  355,  346,  356,  350,  357,  337,  347,
      358,  361,  363,  364,  348,  362,  351,  360,  353,  359,
      352,  355,  349,  356,  354,  345,  342,  341,  340,  334,
      333,  329,  316,  298,  295,  357,  292,  290,  278,  274,
      268,  260,  361,  259,  257,  248,  247,  358,  233,  232,
      363,  366,  231,  366,  366,  366,  366,  366,  366,  367,

      367,  222,  367,  369,  369,  369,  369,  369,  370,  216,
      370,  371,  209,  371,  371,  371,  371,  371,  371,  372,
      372,  372,  205,  199,  197,  186,  177,  174,  172,  169,
      153,  147,  140,  139,  125,  114,  110,  109,  108,   90,
       67,   51,   50,   49,   48,   45,   43,   42,   17,   16,
        3,  365,  365,  365,  365,  365,  365,  365,  365,  365,
      365,  365,  365,  365,  365,  365,  365,  365,  365,  365,
      365,  365,  365,  365,  365,  365,  365,  365,  365,  365,
      365,  365,  365,  365,  365,  365,  365,  365,  365,  365,
      365,  365,  365,  365,  365,  365,  365,  365,  365,  365

    } ;

/* Table of booleans, true if rule could match eol. */
static const flex_int32_t yy_rule_can_match_eol[67] =
    {   0,
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#ifndef YYLMAX
#define YYLMAX 8192
#endif

char yytext[YYLMAX];
char *yytext_ptr;
#line 1 "thrift/thriftl.ll"
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Thrift scanner.
 *
 * Tokenizes a thrift definition file.
 */
#line 27 "thrift/thriftl.ll"

/* This is redundant with some of the flags in Makefile.am, but it works
 * when people override CXXFLAGS without being careful. The pragmas are
 * the 'right' way to do it, but don't work on old-enough GCC (in particular
 * the GCC that ship on Mac OS X 10.6.5, *counter* to what the GNU docs say)
 *
 * We should revert the Makefile.am changes once Apple ships a reasonable
 * GCC.
 */
#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wunused-function"
#pragma GCC diagnostic ignored "-Wunused-label"
#endif

#ifdef _MSC_VER
#pragma warning( push )

// warning C4102: 'find_rule' : unreferenced label
#pragma warning( disable : 4102 )

// warning C4267: 'argument' : conversion from 'size_t' to 'int', possible loss of data
#pragma warning( disable : 4267 )

// avoid isatty redefinition
#define YY_NEVER_INTERACTIVE 1

#define YY_NO_UNISTD_H 1
#endif

#include <cassert>
#include <string>
#include <errno.h>
#include <stdlib.h>

#ifdef _MSC_VER
#include "thrift/windows/config.h"
#endif
#include "thrift/main.h"
#include "thrift/common.h"
#include "thrift/globals.h"
#include "thrift/parse/t_program.h"

/**
 * Must be included AFTER parse/t_program.h, but I can't remember why anymore
 * because I wrote this a while ago.
 */
#if defined(BISON_USE_PARSER_H_EXTENSION)
#include "thrift/thrifty.h"
#else
#include "thrift/thrifty.hh"
#endif

void integer_overflow(char* text) {
  yyerror("This integer is too big: \"%s\"\n", text);
  exit(1);
}

void unexpected_token(char* text) {
  yyerror("Unexpected token in input: \"%s\"\n", text);
  exit(1);
}

#line 859 "thrift/thriftl.cc"
/**
 * Provides the yylineno global, useful for debugging output
 */
/**
 * Our inputs are all single files, so no need for yywrap
 */
/**
 * We don't use it, and it fires up warnings at -Wall
 */
/**
 * Helper definitions, comments, constants, and whatnot
 */
#line 872 "thrift/thriftl.cc"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 123 "thrift/thriftl.ll"


#line 1090 "thrift/thriftl.cc"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 366 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 752 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 125 "thrift/thriftl.ll"
{ /* do nothing */                 }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 126 "thrift/thriftl.ll"
{ /* do nothing */                 }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 128 "thrift/thriftl.ll"
{
  std::string parsed("/**");
  int state = 0;  // 0 = normal, 1 = "*" seen, "*/" seen
  while(state < 2)
  {
    int ch = yyinput();
    parsed.push_back(ch);
    switch (ch) {
      case EOF:
        yyerror("Unexpected end of file in doc-comment at %d\n", yylineno);
        exit(1);
      case '*':
        state = 1;
        break;
      case '/':
        state = (state == 1) ? 2 : 0;
        break;
      default:
        state = 0;
        break;
    }
  }
  pdebug("doctext = \"%s\"\n",parsed.c_str());

 /* This does not show up in the parse tree. */
 /* Rather, the parser will grab it out of the global. */
  if (g_parse_mode == PROGRAM) {
    clear_doctext();
    g_doctext = strdup(parsed.c_str() + 3);
    assert(strlen(g_doctext) >= 2);
    g_doctext[strlen(g_doctext) - 2] = ' ';
    g_doctext[strlen(g_doctext) - 1] = '\0';
    g_doctext = clean_up_doctext(g_doctext);
    g_doctext_lineno = yylineno;
    if( (g_program_doctext_candidate == NULL) && (g_program_doctext_status == INVALID)){
      g_program_doctext_candidate = strdup(g_doctext);
      g_program_doctext_lineno = g_doctext_lineno;
      g_program_doctext_status = STILL_CANDIDATE;
      pdebug("%s","program doctext set to STILL_CANDIDATE");
    }
  }
}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 171 "thrift/thriftl.ll"
{ /* parsed, but thrown away */
  std::string parsed("/*");
  int state = 0;  // 0 = normal, 1 = "*" seen, "*/" seen
  while(state < 2)
  {
    int ch = yyinput();
    parsed.push_back(ch);
    switch (ch) {
      case EOF:
        yyerror("Unexpected end of file in multiline comment at %d\n", yylineno);
        exit(1);
      case '*':
        state = 1;
        break;
      case '/':
        state = (state == 1) ? 2 : 0;
        break;
      default:
        state = 0;
        break;
    }
  }
  pdebug("multi_comm = \"%s\"\n",parsed.c_str());
}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 196 "thrift/thriftl.ll"
{ /* do nothing */                 }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 197 "thrift/thriftl.ll"
{ /* do nothing */                 }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 199 "thrift/thriftl.ll"
{ return yytext[0];                }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 200 "thrift/thriftl.ll"
{ return yytext[0];                }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 202 "thrift/thriftl.ll"
{ yylval.iconst=0; return tok_int_constant; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 203 "thrift/thriftl.ll"
{ yylval.iconst=1; return tok_int_constant; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 205 "thrift/thriftl.ll"
{ return tok_namespace;            }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 206 "thrift/thriftl.ll"
{ error_unsupported_namespace_decl("cpp"); /* do nothing */ }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 207 "thrift/thriftl.ll"
{ return tok_cpp_include;          }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 208 "thrift/thriftl.ll"
{ return tok_cpp_type;             }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 209 "thrift/thriftl.ll"
{ error_unsupported_namespace_decl("java_package", "java"); /* do nothing */ }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 210 "thrift/thriftl.ll"
{ error_unsupported_namespace_decl("cocoa_prefix", "cocoa"); /* do nothing */ }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 211 "thrift/thriftl.ll"
{ error_unsupported_namespace_decl("csharp"); /* do nothing */ }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 212 "thrift/thriftl.ll"
{ error_unsupported_namespace_decl("delphi"); /* do nothing */ }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 213 "thrift/thriftl.ll"
{ error_unsupported_namespace_decl("php"); /* do nothing */ }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 214 "thrift/thriftl.ll"
{ error_unsupported_namespace_decl("py_module", "py"); /* do nothing */ }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 215 "thrift/thriftl.ll"
{ error_unsupported_namespace_decl("perl_package", "perl"); /* do nothing */ }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 216 "thrift/thriftl.ll"
{ error_unsupported_namespace_decl("ruby"); /* do nothing */ }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 217 "thrift/thriftl.ll"
{ error_unsupported_namespace_decl("smalltalk_category", "smalltalk.category"); /* do nothing */ }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 218 "thrift/thriftl.ll"
{ error_unsupported_namespace_decl("smalltalk_category", "smalltalk.category"); /* do nothing */ }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 219 "thrift/thriftl.ll"
{ return tok_xsd_all;              }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 220 "thrift/thriftl.ll"
{ return tok_xsd_optional;         }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 221 "thrift/thriftl.ll"
{ return tok_xsd_nillable;         }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 222 "thrift/thriftl.ll"
{ error_unsupported_namespace_decl("xsd"); /* do nothing */ }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 223 "thrift/thriftl.ll"
{ return tok_xsd_attrs;            }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 224 "thrift/thriftl.ll"
{ return tok_include;              }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 225 "thrift/thriftl.ll"
{ return tok_void;                 }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 226 "thrift/thriftl.ll"
{ return tok_bool;                 }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 227 "thrift/thriftl.ll"
{
  emit_byte_type_warning();
  return tok_i8;
}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 231 "thrift/thriftl.ll"
{ return tok_i8;                   }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 232 "thrift/thriftl.ll"
{ return tok_i16;                  }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 233 "thrift/thriftl.ll"
{ return tok_i32;                  }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 234 "thrift/thriftl.ll"
{ return tok_i64;                  }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 235 "thrift/thriftl.ll"
{ return tok_double;               }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 236 "thrift/thriftl.ll"
{ return tok_string;               }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 237 "thrift/thriftl.ll"
{ return tok_binary;               }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 238 "thrift/thriftl.ll"
{
  pwarning(0, "\"slist\" is deprecated and will be removed in a future compiler version.  This type should be replaced with \"string\".\n");
  return tok_slist;
}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 242 "thrift/thriftl.ll"
{
  pwarning(0, "\"senum\" is deprecated and will be removed in a future compiler version.  This type should be replaced with \"string\".\n");
  return tok_senum;
}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 246 "thrift/thriftl.ll"
{ return tok_map;                  }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 247 "thrift/thriftl.ll"
{ return tok_list;                 }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 248 "thrift/thriftl.ll"
{ return tok_set;                  }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 249 "thrift/thriftl.ll"
{ return tok_oneway;               }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 250 "thrift/thriftl.ll"
{ return tok_typedef;              }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 251 "thrift/thriftl.ll"
{ return tok_struct;               }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 252 "thrift/thriftl.ll"
{ return tok_union;                }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 253 "thrift/thriftl.ll"
{ return tok_xception;             }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 254 "thrift/thriftl.ll"
{ return tok_extends;              }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 255 "thrift/thriftl.ll"
{ return tok_throws;               }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 256 "thrift/thriftl.ll"
{ return tok_service;              }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 257 "thrift/thriftl.ll"
{ return tok_enum;                 }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 258 "thrift/thriftl.ll"
{ return tok_const;                }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 259 "thrift/thriftl.ll"
{ return tok_required;             }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 260 "thrift/thriftl.ll"
{ return tok_optional;             }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 261 "thrift/thriftl.ll"
{
  pwarning(0, "\"async\" is deprecated.  It is called \"oneway\" now.\n");
  return tok_oneway;
}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 265 "thrift/thriftl.ll"
{ return tok_reference;            }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 267 "thrift/thriftl.ll"
{
  errno = 0;
  yylval.iconst = strtoll(yytext, NULL, 10);
  if (errno == ERANGE) {
    integer_overflow(yytext);
  }
  return tok_int_constant;
}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 276 "thrift/thriftl.ll"
{
  errno = 0;
  char sign = yytext[0];
  int shift = sign == '0' ? 2 : 3;
  yylval.iconst = strtoll(yytext+shift, NULL, 16);
  if (sign == '-') {
    yylval.iconst = -yylval.iconst;
  }
  if (errno == ERANGE) {
    integer_overflow(yytext);
  }
  return tok_int_constant;
}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 290 "thrift/thriftl.ll"
{
  yylval.id = strdup(yytext);
  return tok_identifier;
}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 295 "thrift/thriftl.ll"
{
 /* Deliberately placed after identifier, since "e10" is NOT a double literal (THRIFT-3477) */
  yylval.dconst = atof(yytext);
  return tok_dub_constant;
}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 301 "thrift/thriftl.ll"
{
  char mark = yytext[0];
  std::string result;
  for(;;)
  {
    int ch = yyinput();
    switch (ch) {
      case EOF:
        yyerror("End of file while read string at %d\n", yylineno);
        exit(1);
      case '\n':
        yyerror("End of line while read string at %d\n", yylineno - 1);
        exit(1);
      case '\\':
        ch = yyinput();
        switch (ch) {
          case 'r':
            result.push_back('\r');
            continue;
          case 'n':
            result.push_back('\n');
            continue;
          case 't':
            result.push_back('\t');
            continue;
          case '"':
            result.push_back('"');
            continue;
          case '\'':
            result.push_back('\'');
            continue;
          case '\\':
            result.push_back('\\');
            continue;
          default:
            yyerror("Bad escape character\n");
            return -1;
        }
        break;
      default:
        if (ch == mark) {
          yylval.id = strdup(result.c_str());
          return tok_literal;
        } else {
          result.push_back(ch);
        }
    }
  }
}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 352 "thrift/thriftl.ll"
{
  unexpected_token(yytext);
}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 356 "thrift/thriftl.ll"
ECHO;
	YY_BREAK
#line 1640 "thrift/thriftl.cc"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 366 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 366 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 365);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 356 "thrift/thriftl.ll"


#ifdef _MSC_VER
#pragma warning( pop )
#endif

/* vim: filetype=lex
*/

