/***************************************************************************
 *   copyright       : (C) 2003-2023 by Pascal Brachet                     *
 *   https://www.xm1math.net/texmaker/                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   @license GPL-2.0+ <https://spdx.org/licenses/GPL-2.0+.html>           *
 ***************************************************************************/

#ifndef LOGEDITOR_H
#define LOGEDITOR_H

#include <QWidget>
#include <QString>
#include <QPlainTextEdit>
#include <QTextDocument>
#include <QTextCursor>
#include <QTextBlock>


#include "loghighlighter.h"

class LogEditor : public QPlainTextEdit  {
   Q_OBJECT
public: 
	LogEditor(QWidget *parent,QList<QColor> edcolors);
	~LogEditor();

public slots:
   void insertLine(QString l);
   void setCursorPosition(int parag, int index);
   void setColors(QList<QColor> colors);
protected:
    virtual void mousePressEvent(QMouseEvent *e);
    void paintEvent(QPaintEvent *event);
signals:
    void clickonline(int l);
private:
  LogHighlighter *highlighter;
  QColor colorBackground, colorLine, colorHighlight, colorCursor;
};

#endif
