# unitn-bimrep

A LaTeX class for the Bimonthly report for the University of Trento. The class formats the document in order to 
obtain the typical aspect required by the bimonthly report.

## Installation

If you want to use it for now, you have to put `unitn-bimrep.cls` and `unitn-bimrep.jpg` in the same directory
of your main LaTeX file.

## Usage

There are some very simple step to complete a document:

 1. Use `unitn-bimrep` as your `\documentclass`
 1. In the preamble:
     * Define the `\author` (your name)
     * Define the `\advisor` (name of your advisor, or comma separated list of advisors)
     * Define the `\title` (the title of your thesis)
     * Define the `\cycle` (your school cycle)
 3. In your document (exactly in this order):
     1. Insert the `research` (or `research*`) environment
     2. Insert the `school` (or `school*`) environment
     3. Insert the `production` (or `production*`) environment

If one of the above element is missing, the class will raise an error.

### Environments

#### Research

The `research` enviroment should contain a sequence of `\item` that describe your work. Inside the environment you can use directly the `\item` macro,
that is interpreted as in a `itemize`. The environment can also be empty.

If you prefer to write a small paragraph, you should use the `research*` environment instead.

`research` (or in alterntive `research*`) can be used **only once**.

#### School

The `school` enviroment should contain a sequence of `\item` that describe the courses you have attended. Inside the environment you can use directly the `\item` macro,
that it is slightly different with respect to the standard one. This `\item` can take upto 3 arguments:

```latex
\item{Title of the course}{Teacher or Organization}{Duration in hours or ECTS credit}
```

If you prefer to write a small paragraph, you should use the `school*` environment instead.

`school` (or in alterntive `school*`) can be used **only once**, after the `research` environment.

#### Production

The `production` enviroment should contain a sequence of `\item` that describe The course you have attended. Inside the environment you can use directly the `\item` macro,
that it is slightly different with respect to the standard one. This `\item` can take upto 3 arguments:

```latex
\item{List of Authors}{Title of the publication}{More information about the paper}
```

If you prefer to write a small paragraph, you should use the `production*` environment instead. This opens tothe usage of more advanced function, such as list of publication generated by `bibtex`.

`production` (or in alterntive `production*`) can be used **only once**, after the `research` and `school` environments.


### Examples

#### Normal Mode

The code:

```latex
\documentclass{unitn-bimrep}

\author{Student Name Surname}
\title{An awesome thesis for a PhD student}
\advisor{Advisor Name Surname}
\cycle{XXX}

\begin{document}

\begin{research*}
  For my ctivities I usually prefer to write a small paragraph. Since I used the
  \texttt{research*} environment, I cannot use the \texttt{research} after.
\end{research*}

\begin{school}
  \item{Interesting course}{A. Einstein}{20h}
\end{school}

\begin{production}
  \item{Student Name Surname, Advisor Name Surname}{An awesome publication}{Awesome journal (in review)}
\end{production}


\end{document}
```

produces:

![example](examples/example.png?raw=true)

#### With Biblatex

The code:

```latex
\documentclass[bib]{unitn-bimrep}

\addbibresource{ref.bib} % Define here the bibliography file to use

\author{Student Name Surname}
\title{An awesome thesis for a PhD student}
\advisor{Advisor Name Surname}
\cycle{XXX}

\begin{document}

\begin{research*}
  For my ctivities I usually prefer to write a small paragraph. Since I used the
  \texttt{research*} environment, I cannot use the \texttt{research} after.
\end{research*}

\begin{school}
  \item{Interesting course}{A. Einstein}{20h}
\end{school}

\begin{production*}
  \nocite{ref:1,ref:2} % Import the citations with \nocite
  \printbibliography  % and print the bibliography.
\end{production*}

\end{document}
```

produces:

![example](examples/example_bib.png?raw=true)
