# Overview

The purpose of the current LaTeX bundle, `gzt`, is to provide two classes and
`biblatex styles` for
the French journal
["La Gazette des Mathématiciens"](http://smf4.emath.fr/Publications/Gazette/):

- `gzt` for the complete issues of the journal, aimed for the Gazette's team,
- `gztarticle`, intended for the authors who wish to publish an article in the
  Gazette. This class goal is to:
    - faithfully reproduce the layout of the Gazette, thus enabling the authors
      to be able to work their document in actual conditions,
    - provide a number of tools (commands and environments) to facilitate the
      drafting of documents, in particular those containing mathematical
      formulas.

# Copyright and Licence

## Author

Denis Bitouzé

## Release

2017/02/15 v0.97

## Copyright

Copyright 2014-2017 Denis Bitouzé

## Licence

This work may be distributed and/or modified under the conditions of the LaTeX
Project Public License, either version 1.3 of this license or (at your option)
any later version.

The latest version of the license is in http://www.latex-project.org/lppl.txt
and version 1.3 or later is part of all distributions of LaTeX version
2003/06/01 or later.

This work has the LPPL maintenance status "maintained".

#Installation

- `gzt` is bundled with the main TeX distributions TeX Live (and its
  variants) and MiKTeX.
- `gzt` starts life on [Github](https://github.com/dbitouze/gzt) where
  you can always find development releases.
- The latest official release is put onto [CTAN](http://ctan.org/pkg/gzt)
  but users can get the latest stable version by updating their TeX
  distributions (upgrading if necessary for TeX Live).

#Help

## Documentation

`gzt` is provided with an extensive documentation (in French) in the
`doc/latex/gzt/french/` directory in the distribution, also
available
[on CTAN](http://mirrors.ctan.org/macros/latex/contrib/gzt/doc/gzt-fr.pdf).

## Templates and samples

`gzt` comes with a template attached to the the documentation above.

## Questions and answers

Users can ask questions about `gzt` e.g. on Q & A sites:

- [in French](http://texnique.fr/osqa/tags/gzt/)
- [in English](http://tex.stackexchange.com/questions/tagged/gzt)

# Debug and feature requests

Suggestions and bug reports are welcome.

- Go to the Github [issues page](https://github.com/dbitouze/gzt/issues/).
- If not already reported, [open an issue](https://github.com/dbitouze/gzt/issues/new/).
- Add
  a [minimal working example](http://www.tex.ac.uk/cgi-bin/texfaq2html?label=minxampl) if
  possible. This helps a great deal facilitate a swift response.
