;;; arabluatex.el --- AUCTeX style for `arabluatex.sty'
;; This file is part of the `arabluatex' package

;; ArabLuaTeX -- Processing ArabTeX notation under LuaLaTeX
;; Copyright (C) 2016--2018  Robert Alessi

;; Please send error reports and suggestions for improvements to Robert
;; Alessi <alessi@robertalessi.net>

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see
;; <http://www.gnu.org/licenses/>.

(defvar LaTeX-arabluatex-package-options
  '("voc" "fullvoc" "novoc" "trans")
  "Package options for the arabluatex package.")

(defvar LaTeX-arabluatex-mode-options
  '(;;
    ("voc")
    ("fullvoc")
    ("novoc")
    ("trans")
    )
  "Global or local options.")

(defvar LaTeX-arabluatex-key-val-options
  '(;;
    ("mode" ("voc" "fullvoc" "novoc" "trans"))
    ("width")
    ("gutter")
    ("metre")
    ("delim" ("true" "false"))
    ("utf" ("true" "false")))
  "Key=value options for arabverse environment.")

(TeX-add-style-hook
 "arabluatex"
 (lambda ()
   ;; This package relies on lualatex, so check for it:
   (TeX-check-engine-add-engines 'luatex)
   (TeX-add-symbols
    "aemph"
    "SetInputScheme"
    '("SetArbEasy" 0)
    '("SetArbDflt" 0)
    '("SetArbEasy*" 0)
    '("SetArbDflt*" 0)
    "SetTranslitFont"
    "SetTranslitStyle"
    "SetTranslitConvention"
    "arbup"
    '("ArbUpDflt" 0)
    '("NoArbUp" 0)
    "SetArbUp"
    "uc"
    "prname"
    "txarb"
    '("arb" [ (TeX-arg-eval completing-read "Mode: "
			    LaTeX-arabluatex-mode-options) ]
      t)
    "SetHemistichDelim"
    '("bayt" 2)
    "abjad"
    "arbnull"
    "abraces"
    "LR"
    "RL"
    "LRmarginpar"
    "LRfootnote"
    "RLfootnote"
    "FixArbFtnmk"
    "MkArbBreak"
    "arbmark"
    '("newarbmark" 3)
    '("setRL" 0)
    '("setLR" 0))
   (LaTeX-add-environments
    '("arab" LaTeX-env-args
      [ (TeX-arg-eval completing-read "Mode: "
		      LaTeX-arabluatex-mode-options) ]
      0)
    "txarab"
    '("arabverse" LaTeX-env-args
      [ TeX-arg-key-val LaTeX-arabluatex-key-val-options ] 0))
   )
 LaTeX-dialect)

;;; arabluatex.el ends here
