/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.model.RGBColorSpace;
import kotlin.Metadata;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/github/ajalt/colormath/model/ACEScctTransferFunctions;", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "()V", "a", "", "b", "eotfC2", "eotf", "", "x", "oetf", "colormath"})
final class ACEScctTransferFunctions
implements RGBColorSpace.TransferFunctions {
    @NotNull
    public static final ACEScctTransferFunctions INSTANCE = new ACEScctTransferFunctions();
    private static final double a = 10.5402377416545;
    private static final double b = 0.0729055341958355;
    private static final double eotfC2 = (MathKt.log2(65504.0) + 9.72) / 17.52;

    private ACEScctTransferFunctions() {
    }

    @Override
    public float eotf(float x) {
        double d;
        if ((double)x <= 0.155251141552511) {
            d = ((double)x - 0.0729055341958355) / 10.5402377416545;
        } else if ((double)x < eotfC2) {
            double d2 = 2.0;
            double d3 = (double)x * 17.52 - 9.72;
            boolean bl = false;
            d = Math.pow(d2, d3);
        } else {
            d = 65504.0;
        }
        return (float)d;
    }

    @Override
    public float oetf(float x) {
        return (float)((double)x < 0.0078125 ? 10.5402377416545 * (double)x + 0.0729055341958355 : ((double)MathKt.log2(x) + 9.72) / 17.52);
    }
}

