/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.markdown;

import com.github.ajalt.mordant.components.HorizontalRule;
import com.github.ajalt.mordant.components.OrderedList;
import com.github.ajalt.mordant.components.PaddingKt;
import com.github.ajalt.mordant.components.Panel;
import com.github.ajalt.mordant.components.Text;
import com.github.ajalt.mordant.components.UnorderedList;
import com.github.ajalt.mordant.internal.HyperlinkIdsKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.markdown.BlockQuote;
import com.github.ajalt.mordant.markdown.MarkdownDocument;
import com.github.ajalt.mordant.markdown.MarkdownRenderer;
import com.github.ajalt.mordant.markdown.MarkdownRendererKt;
import com.github.ajalt.mordant.rendering.BorderStyle;
import com.github.ajalt.mordant.rendering.EmptyRenderable;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.LinesKt;
import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.Renderable;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.table.ColumnBuilder;
import com.github.ajalt.mordant.table.RowBuilder;
import com.github.ajalt.mordant.table.SectionBuilder;
import com.github.ajalt.mordant.table.TableBuilder;
import com.github.ajalt.mordant.table.TableDslKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019H\u0002J \u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u00172\b\b\u0002\u0010\u001e\u001a\u00020\u0017H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010#\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010(\u001a\u00020 J \u0010)\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010*\u001a\u00020\u0003*\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u0017H\u0002J\u0014\u0010+\u001a\u00020,*\u00020-2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/github/ajalt/mordant/markdown/MarkdownRenderer;", "", "input", "", "theme", "Lcom/github/ajalt/mordant/rendering/Theme;", "showHtml", "", "hyperlinks", "(Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/Theme;ZZ)V", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "atxContent", "Lcom/github/ajalt/mordant/rendering/Lines;", "node", "Lorg/intellij/markdown/ast/ASTNode;", "atxHorizRule", "Lcom/github/ajalt/mordant/rendering/Renderable;", "bar", "style", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "dropWs", "Lkotlin/Pair;", "", "nodes", "", "headerHr", "content", "innerInlines", "drop", "dropLast", "parseFile", "Lcom/github/ajalt/mordant/markdown/MarkdownDocument;", "parseInlineLink", "parseInlines", "parseReferenceLink", "parseStructure", "parseTableAlignment", "Lkotlin/sequences/Sequence;", "Lcom/github/ajalt/mordant/rendering/TextAlign;", "render", "setext", "nodeText", "parseTableRow", "", "Lcom/github/ajalt/mordant/table/SectionBuilder;", "mordant"})
public final class MarkdownRenderer {
    private final String input;
    private LinkMap linkMap;
    private final Theme theme;
    private final boolean showHtml;
    private final boolean hyperlinks;

    @NotNull
    public final MarkdownDocument render() {
        MarkdownFlavourDescriptor flavour = new GFMFlavourDescriptor();
        ASTNode parsedTree = new MarkdownParser(flavour).buildMarkdownTreeFromString(this.input);
        return this.parseFile(parsedTree);
    }

    /*
     * WARNING - void declaration
     */
    private final MarkdownDocument parseFile(ASTNode node) {
        Collection<Renderable> collection;
        void $this$mapTo$iv$iv;
        boolean bl = Intrinsics.areEqual(node.getType(), MarkdownElementTypes.MARKDOWN_FILE);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.hyperlinks) {
            this.linkMap = LinkMap.Builder.buildLinkMap(node, this.input);
        }
        Iterable $this$map$iv = node.getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ASTNode aSTNode = (ASTNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            Renderable renderable = this.parseStructure((ASTNode)it);
            collection.add(renderable);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        return new MarkdownDocument(list);
    }

    /*
     * WARNING - void declaration
     */
    private final Renderable parseStructure(ASTNode node) {
        Renderable renderable;
        IElementType iElementType = node.getType();
        if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.UNORDERED_LIST)) {
            void $this$mapTo$iv$iv;
            ASTNode it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = node.getChildren();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ASTNode)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getType(), MarkdownElementTypes.LIST_ITEM)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<MarkdownDocument> collection = (List)destination$iv$iv;
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Collection<Renderable> collection2;
                void $this$mapTo$iv$iv2;
                it = (ASTNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv2 = CollectionsKt.drop((Iterable)it.getChildren(), 1);
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void c;
                    ASTNode aSTNode = (ASTNode)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    Renderable renderable2 = this.parseStructure((ASTNode)c);
                    collection2.add(renderable2);
                }
                collection2 = (List)destination$iv$iv2;
                List list = collection2;
                MarkdownDocument markdownDocument = new MarkdownDocument(list);
                collection.add(markdownDocument);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 6;
            TextStyle textStyle = null;
            String string = null;
            List list = collection;
            renderable = new UnorderedList(list, string, textStyle, n, defaultConstructorMarker);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.ORDERED_LIST)) {
            ASTNode it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = node.getChildren();
            boolean $i$f$filter = false;
            Iterable $this$mapTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ASTNode)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getType(), MarkdownElementTypes.LIST_ITEM)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<MarkdownDocument> collection = (List)destination$iv$iv;
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Collection<Renderable> collection3;
                it = (ASTNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv3 = CollectionsKt.drop((Iterable)it.getChildren(), 1);
                boolean $i$f$map3 = false;
                Iterable $this$mapTo$iv$iv2 = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                    ASTNode c = (ASTNode)item$iv$iv3;
                    collection3 = destination$iv$iv3;
                    boolean bl3 = false;
                    Renderable renderable3 = this.parseStructure(c);
                    collection3.add(renderable3);
                }
                collection3 = (List)destination$iv$iv3;
                List list = collection3;
                MarkdownDocument markdownDocument = new MarkdownDocument(list);
                collection.add(markdownDocument);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 6;
            String string = null;
            TextStyle textStyle = null;
            List list = collection;
            renderable = new OrderedList(list, textStyle, string, n, defaultConstructorMarker);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.BLOCK_QUOTE)) {
            ASTNode it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = CollectionsKt.drop((Iterable)node.getChildren(), 1);
            boolean $i$f$filter = false;
            Iterable $this$mapTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ASTNode)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getType(), MarkdownTokenTypes.WHITE_SPACE) ^ true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<Renderable> collection = (List)destination$iv$iv;
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ASTNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Renderable renderable4 = this.parseStructure(it);
                collection.add(renderable4);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            Renderable renderable5 = new MarkdownDocument(list);
            renderable = new BlockQuote(renderable5);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.CODE_FENCE)) {
            int n;
            int start;
            block54: {
                int n2;
                block53: {
                    List<ASTNode> $this$indexOfFirst$iv = node.getChildren();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<ASTNode> $i$f$mapTo = $this$indexOfFirst$iv.iterator();
                    while ($i$f$mapTo.hasNext()) {
                        ASTNode item$iv;
                        ASTNode it = item$iv = $i$f$mapTo.next();
                        boolean bl = false;
                        if (Intrinsics.areEqual(it.getType(), MarkdownTokenTypes.CODE_FENCE_CONTENT)) {
                            n2 = index$iv;
                            break block53;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                start = n2;
                List<ASTNode> $this$indexOfLast$iv = node.getChildren();
                boolean $i$f$indexOfLast = false;
                ListIterator<ASTNode> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    ASTNode it = iterator$iv.previous();
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getType(), MarkdownTokenTypes.CODE_FENCE_CONTENT)) continue;
                    n = iterator$iv.nextIndex();
                    break block54;
                }
                n = -1;
            }
            int end = n;
            Lines lines = this.innerInlines(node, start, end < 0 ? 0 : CollectionsKt.getLastIndex(node.getChildren()) - end);
            Integer n3 = null;
            Integer n4 = null;
            OverflowWrap overflowWrap2 = null;
            TextAlign textAlign2 = null;
            TextStyle textStyle = this.theme.getMarkdownCodeBlock();
            Whitespace whitespace = Whitespace.PRE_WRAP;
            Text content = new Text(lines, textStyle, whitespace, textAlign2, overflowWrap2, n4, n3, 120, null);
            renderable = this.theme.getMarkdownCodeBlockBorder() ? (Renderable)new Panel(content, null, false, null, null, 30, null) : (Renderable)content;
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.CODE_BLOCK)) {
            Integer end = null;
            Integer n = null;
            OverflowWrap overflowWrap3 = null;
            TextAlign textAlign3 = null;
            TextStyle textStyle = this.theme.getMarkdownCodeBlock();
            Whitespace whitespace = Whitespace.PRE_WRAP;
            Text content = new Text(MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null), textStyle, whitespace, textAlign3, overflowWrap3, n, end, 120, null);
            renderable = this.theme.getMarkdownCodeBlockBorder() ? (Renderable)new Panel(content, null, false, null, null, 30, null) : (Renderable)content;
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.HTML_BLOCK)) {
            renderable = this.showHtml ? new Text(MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null), null, Whitespace.PRE_WRAP, null, null, null, null, 122, null) : new Text(LinesKt.getEMPTY_LINES(), null, null, null, null, null, null, 126, null);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.PARAGRAPH)) {
            renderable = new Text(MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null), this.theme.getMarkdownText(), null, null, null, null, null, 124, null);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.LINK_DEFINITION)) {
            renderable = this.hyperlinks ? (Renderable)EmptyRenderable.INSTANCE : (Renderable)new Text(ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), this.theme.getMarkdownLinkDestination()), null, null, null, null, null, null, 126, null);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.SETEXT_1)) {
            renderable = this.setext(this.theme.getMarkdownH1Rule(), this.theme.getMarkdownH1(), node);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.SETEXT_2)) {
            renderable = this.setext(this.theme.getMarkdownH2Rule(), this.theme.getMarkdownH2(), node);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.ATX_1)) {
            renderable = this.atxHorizRule(this.theme.getMarkdownH1Rule(), this.theme.getMarkdownH1(), node);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.ATX_2)) {
            renderable = this.atxHorizRule(this.theme.getMarkdownH2Rule(), this.theme.getMarkdownH2(), node);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.ATX_3)) {
            renderable = this.atxHorizRule(this.theme.getMarkdownH3Rule(), this.theme.getMarkdownH3(), node);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.ATX_4)) {
            renderable = this.atxHorizRule(this.theme.getMarkdownH4Rule(), this.theme.getMarkdownH4(), node);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.ATX_5)) {
            renderable = this.atxHorizRule(this.theme.getMarkdownH5Rule(), this.theme.getMarkdownH5(), node);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.ATX_6)) {
            renderable = this.atxHorizRule(this.theme.getMarkdownH6Rule(), this.theme.getMarkdownH6(), node);
        } else if (Intrinsics.areEqual(iElementType, GFMTokenTypes.CHECK_BOX)) {
            MatchResult matchResult = Regex.find$default(MarkdownRendererKt.access$getCHECK_BOX_REGEX$p(), MarkdownRenderer.nodeText$default(this, node, 0, 1, null), 0, 2, null);
            Intrinsics.checkNotNull(matchResult);
            String content = StringsKt.removeSurrounding(matchResult.getValue(), (CharSequence)"[", (CharSequence)"]");
            String checkbox = StringsKt.isBlank(content) ? this.theme.getMarkdownTaskUnchecked() : this.theme.getMarkdownTaskChecked();
            renderable = new Text(ParsingKt.parseText(checkbox + ' ', TextStyleKt.getDEFAULT_STYLE()), null, Whitespace.PRE, null, null, null, null, 122, null);
        } else if (Intrinsics.areEqual(iElementType, GFMElementTypes.TABLE)) {
            renderable = TableDslKt.table((Function1<? super TableBuilder, Unit>)new Function1<TableBuilder, Unit>(this, node){
                final /* synthetic */ MarkdownRenderer this$0;
                final /* synthetic */ ASTNode $node;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull TableBuilder $this$table) {
                    Intrinsics.checkNotNullParameter($this$table, "$receiver");
                    $this$table.setBorderStyle(BorderStyle.Companion.getSQUARE_DOUBLE_SECTION_SEPARATOR());
                    Sequence $this$forEachIndexed$iv = MarkdownRenderer.access$parseTableAlignment(this.this$0, this.$node);
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    Iterator<T> iterator2 = $this$forEachIndexed$iv.iterator();
                    while (iterator2.hasNext()) {
                        void align;
                        T item$iv = iterator2.next();
                        int n = index$iv++;
                        boolean bl = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        TextAlign textAlign2 = (TextAlign)((Object)item$iv);
                        int i = n;
                        boolean bl2 = false;
                        $this$table.column(i, (Function1<? super ColumnBuilder, Unit>)new Function1<ColumnBuilder, Unit>((TextAlign)align){
                            final /* synthetic */ TextAlign $align;

                            public final void invoke(@NotNull ColumnBuilder $this$column) {
                                Intrinsics.checkNotNullParameter($this$column, "$receiver");
                                $this$column.setAlign(this.$align);
                            }
                            {
                                this.$align = textAlign2;
                                super(1);
                            }
                        });
                    }
                    $this$table.header((Function1<? super SectionBuilder, Unit>)new Function1<SectionBuilder, Unit>(this){
                        final /* synthetic */ parseStructure.7 this$0;

                        public final void invoke(@NotNull SectionBuilder $this$header) {
                            Intrinsics.checkNotNullParameter($this$header, "$receiver");
                            $this$header.setStyle(MarkdownRenderer.access$getTheme$p(this.this$0.this$0).getMarkdownTableHeader());
                            MarkdownRenderer.access$parseTableRow(this.this$0.this$0, $this$header, MarkdownRendererKt.access$firstChildOfType(this.this$0.$node, GFMElementTypes.HEADER));
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                    $this$table.body((Function1<? super SectionBuilder, Unit>)new Function1<SectionBuilder, Unit>(this){
                        final /* synthetic */ parseStructure.7 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull SectionBuilder $this$body) {
                            void $this$filterTo$iv$iv;
                            Intrinsics.checkNotNullParameter($this$body, "$receiver");
                            $this$body.setStyle(MarkdownRenderer.access$getTheme$p(this.this$0.this$0).getMarkdownTableBody());
                            Iterable $this$filter$iv = this.this$0.$node.getChildren();
                            boolean $i$f$filter = false;
                            Iterable iterable = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                ASTNode it = (ASTNode)element$iv$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual(it.getType(), GFMElementTypes.ROW)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            Iterable $this$forEach$iv = (List)destination$iv$iv;
                            boolean $i$f$forEach = false;
                            for (E element$iv : $this$forEach$iv) {
                                ASTNode it = (ASTNode)element$iv;
                                boolean bl = false;
                                MarkdownRenderer.access$parseTableRow(this.this$0.this$0, $this$body, it);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                }
                {
                    this.this$0 = markdownRenderer;
                    this.$node = aSTNode;
                    super(1);
                }
            });
        } else if (Intrinsics.areEqual(iElementType, MarkdownTokenTypes.HORIZONTAL_RULE)) {
            renderable = new HorizontalRule("", null, null, null, 14, null);
        } else if (Intrinsics.areEqual(iElementType, MarkdownTokenTypes.EOL)) {
            renderable = MarkdownRendererKt.access$getEOL_TEXT$p();
        } else if (Intrinsics.areEqual(iElementType, MarkdownTokenTypes.WHITE_SPACE)) {
            renderable = new Text(LinesKt.getEMPTY_LINES(), null, null, null, null, null, null, 126, null);
        } else {
            String string = "Unexpected token when parsing structure: " + node;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return renderable;
    }

    private final Lines parseInlines(ASTNode node) {
        Lines lines;
        IElementType iElementType = node.getType();
        if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.CODE_SPAN)) {
            String string = this.input;
            int n = node.getChildren().get(1).getStartOffset();
            int n2 = CollectionsKt.last(node.getChildren()).getStartOffset();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string3;
            n = 0;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            lines = ParsingKt.parseText(((Object)StringsKt.trim((CharSequence)string4)).toString(), this.theme.getMarkdownCodeSpan());
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.EMPH)) {
            lines = MarkdownRenderer.innerInlines$default(this, node, 1, 0, 4, null).withStyle$mordant(this.theme.getMarkdownEmph());
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.STRONG)) {
            lines = MarkdownRenderer.innerInlines$default(this, node, 2, 0, 4, null).withStyle$mordant(this.theme.getMarkdownStrong());
        } else if (Intrinsics.areEqual(iElementType, GFMElementTypes.STRIKETHROUGH)) {
            lines = MarkdownRenderer.innerInlines$default(this, node, 2, 0, 4, null).withStyle$mordant(this.theme.getMarkdownStikethrough());
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.LINK_TEXT)) {
            lines = ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, node.getChildren().get(1), 0, 1, null), this.theme.getMarkdownLinkText());
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.LINK_LABEL)) {
            lines = ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), this.theme.getMarkdownLinkDestination());
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.LINK_DESTINATION)) {
            ASTNode aSTNode = CollectionsKt.firstOrNull(node.getChildren());
            lines = MarkdownRenderer.innerInlines$default(this, node, Intrinsics.areEqual(aSTNode != null ? aSTNode.getType() : null, MarkdownTokenTypes.LT) ? 1 : 0, 0, 4, null).replaceStyle$mordant(this.theme.getMarkdownLinkDestination());
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.INLINE_LINK)) {
            lines = this.parseInlineLink(node);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.FULL_REFERENCE_LINK) || Intrinsics.areEqual(iElementType, MarkdownElementTypes.SHORT_REFERENCE_LINK)) {
            lines = this.parseReferenceLink(node, this.hyperlinks);
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.IMAGE)) {
            lines = this.parseInlines(node.getChildren().get(1));
        } else if (Intrinsics.areEqual(iElementType, MarkdownTokenTypes.EMAIL_AUTOLINK) || Intrinsics.areEqual(iElementType, GFMTokenTypes.GFM_AUTOLINK) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.AUTOLINK)) {
            lines = ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), this.theme.getMarkdownLinkText());
        } else if (Intrinsics.areEqual(iElementType, MarkdownElementTypes.AUTOLINK)) {
            lines = MarkdownRenderer.innerInlines$default(this, node, 1, 0, 4, null);
        } else if (Intrinsics.areEqual(iElementType, MarkdownTokenTypes.HTML_TAG)) {
            lines = this.showHtml ? ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), TextStyleKt.getDEFAULT_STYLE()) : LinesKt.getEMPTY_LINES();
        } else if (Intrinsics.areEqual(iElementType, MarkdownTokenTypes.BLOCK_QUOTE)) {
            lines = LinesKt.getEMPTY_LINES();
        } else if (Intrinsics.areEqual(iElementType, MarkdownTokenTypes.CODE_LINE)) {
            lines = ParsingKt.parseText(StringsKt.drop(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), 4), TextStyleKt.getDEFAULT_STYLE());
        } else if (Intrinsics.areEqual(iElementType, MarkdownTokenTypes.HARD_LINE_BREAK)) {
            lines = ParsingKt.parseText("\u0085", this.theme.getMarkdownText());
        } else if (Intrinsics.areEqual(iElementType, MarkdownTokenTypes.ESCAPED_BACKTICKS)) {
            lines = ParsingKt.parseText("`", this.theme.getMarkdownText());
        } else if (Intrinsics.areEqual(iElementType, MarkdownTokenTypes.BAD_CHARACTER)) {
            lines = ParsingKt.parseText("\ufffd", this.theme.getMarkdownText());
        } else if (Intrinsics.areEqual(iElementType, MarkdownTokenTypes.BACKTICK) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.CODE_FENCE_CONTENT) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.COLON) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.DOUBLE_QUOTE) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.EMPH) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.EXCLAMATION_MARK) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.GT) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.HTML_BLOCK_CONTENT) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.LBRACKET) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.LPAREN) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.LT) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.RBRACKET) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.RPAREN) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.SINGLE_QUOTE) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.TEXT) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.URL) || Intrinsics.areEqual(iElementType, MarkdownTokenTypes.WHITE_SPACE)) {
            lines = ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), TextStyleKt.getDEFAULT_STYLE());
        } else if (Intrinsics.areEqual(iElementType, MarkdownTokenTypes.EOL)) {
            lines = new Lines(CollectionsKt.plus((Collection)CollectionsKt.listOf(LinesKt.getEMPTY_LINE()), (Iterable)ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), TextStyleKt.getDEFAULT_STYLE()).getLines()));
        } else {
            String string = "Unexpected token when parsing inlines: " + node + "; [" + node.getType() + ":'" + StringsKt.take(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), 10) + "'}]";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return lines;
    }

    private final String nodeText(ASTNode $this$nodeText, int drop) {
        String string = this.input;
        int n = $this$nodeText.getStartOffset() + drop;
        int n2 = $this$nodeText.getEndOffset() - drop;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    static /* synthetic */ String nodeText$default(MarkdownRenderer markdownRenderer, ASTNode aSTNode, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return markdownRenderer.nodeText(aSTNode, n);
    }

    /*
     * WARNING - void declaration
     */
    private final Lines innerInlines(ASTNode node, int drop, int dropLast) {
        void $this$fold$iv$iv;
        List<ASTNode> $this$foldLines$iv = node.getChildren().subList(drop, node.getChildren().size() - dropLast);
        boolean $i$f$foldLines = false;
        Iterable iterable = $this$foldLines$iv;
        Lines initial$iv$iv = LinesKt.getEMPTY_LINES();
        boolean $i$f$fold = false;
        Lines accumulator$iv$iv = initial$iv$iv;
        Iterator iterator2 = $this$fold$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            void r$iv;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator2.next();
            Lines l$iv = accumulator$iv$iv;
            boolean bl = false;
            ASTNode aSTNode = (ASTNode)r$iv;
            Lines lines = l$iv;
            boolean bl2 = false;
            Lines lines2 = this.parseInlines((ASTNode)it);
            accumulator$iv$iv = lines.plus$mordant(lines2);
        }
        return accumulator$iv$iv;
    }

    static /* synthetic */ Lines innerInlines$default(MarkdownRenderer markdownRenderer, ASTNode aSTNode, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return markdownRenderer.innerInlines(aSTNode, n, n2);
    }

    private final Renderable atxHorizRule(String bar, TextStyle style, ASTNode node) {
        return node.getChildren().size() <= 1 ? (Renderable)MarkdownRendererKt.access$getEOL_TEXT$p() : this.headerHr(new Text(this.atxContent(node), null, null, null, null, null, null, 126, null), bar, style);
    }

    /*
     * WARNING - void declaration
     */
    private final Lines atxContent(ASTNode node) {
        void drop;
        Pair<Integer, Integer> pair2 = this.dropWs(node.getChildren().get(1).getChildren());
        int n = ((Number)pair2.component1()).intValue();
        int dropLast = ((Number)pair2.component2()).intValue();
        return this.innerInlines(node.getChildren().get(1), (int)drop, dropLast);
    }

    /*
     * WARNING - void declaration
     */
    private final Renderable setext(String bar, TextStyle style, ASTNode node) {
        void drop;
        Pair<Integer, Integer> pair2 = this.dropWs(node.getChildren().get(0).getChildren());
        int n = ((Number)pair2.component1()).intValue();
        int dropLast = ((Number)pair2.component2()).intValue();
        Lines content = this.innerInlines(node.getChildren().get(0), (int)drop, dropLast);
        return this.headerHr(new Text(content, null, null, null, null, null, null, 126, null), bar, style);
    }

    private final Renderable headerHr(Renderable content, String bar, TextStyle style) {
        TextStyle textStyle = TextStyleKt.TextStyle$default(style.getColor(), style.getBgColor(), false, false, false, false, false, false, null, 508, null);
        TextStyle textStyle2 = style;
        return PaddingKt.withVerticalPadding$default(new HorizontalRule(content, bar, textStyle, textStyle2), this.theme.getMarkdownHeaderPadding(), false, 2, null);
    }

    private final Pair<Integer, Integer> dropWs(List<? extends ASTNode> nodes) {
        ASTNode aSTNode = CollectionsKt.firstOrNull(nodes);
        int drop = Intrinsics.areEqual(aSTNode != null ? aSTNode.getType() : null, MarkdownTokenTypes.WHITE_SPACE) ? 1 : 0;
        ASTNode aSTNode2 = CollectionsKt.lastOrNull(nodes);
        int dropLast = Intrinsics.areEqual(aSTNode2 != null ? aSTNode2.getType() : null, MarkdownTokenTypes.WHITE_SPACE) ? 1 : 0;
        return TuplesKt.to(drop, dropLast);
    }

    private final void parseTableRow(SectionBuilder $this$parseTableRow, ASTNode node) {
        $this$parseTableRow.row((Function1<? super RowBuilder, Unit>)new Function1<RowBuilder, Unit>(this, node){
            final /* synthetic */ MarkdownRenderer this$0;
            final /* synthetic */ ASTNode $node;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull RowBuilder $this$row) {
                Intrinsics.checkNotNullParameter($this$row, "$receiver");
                for (ASTNode child : this.$node.getChildren()) {
                    void drop;
                    if (Intrinsics.areEqual(child.getType(), GFMTokenTypes.CELL) ^ true) continue;
                    Pair pair2 = MarkdownRenderer.access$dropWs(this.this$0, child.getChildren());
                    int n = ((Number)pair2.component1()).intValue();
                    int dropLast = ((Number)pair2.component2()).intValue();
                    RowBuilder.cell$default($this$row, new Text(MarkdownRenderer.access$innerInlines(this.this$0, child, (int)drop, dropLast), null, null, null, null, null, null, 126, null), null, 2, null);
                }
            }
            {
                this.this$0 = markdownRenderer;
                this.$node = aSTNode;
                super(1);
            }
        });
    }

    private final Sequence<TextAlign> parseTableAlignment(ASTNode node) {
        ASTNode headerSeparator = MarkdownRendererKt.access$firstChildOfType(node, GFMTokenTypes.TABLE_SEPARATOR);
        return SequencesKt.map(Regex.findAll$default(MarkdownRendererKt.access$getTABLE_DELIMITER_REGEX$p(), MarkdownRenderer.nodeText$default(this, headerSeparator, 0, 1, null), 0, 2, null), parseTableAlignment.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final Lines parseInlineLink(ASTNode node) {
        void $this$fold$iv$iv;
        Object dest;
        boolean bl;
        Object object;
        String text;
        block9: {
            Object object2;
            block8: {
                Object v1;
                block7: {
                    text = MarkdownRenderer.nodeText$default(this, MarkdownRendererKt.access$firstChildOfType(node, MarkdownElementTypes.LINK_TEXT).getChildren().get(1), 0, 1, null);
                    object2 = ASTUtilKt.findChildOfType(node, MarkdownElementTypes.LINK_DESTINATION);
                    if (object2 == null || (object2 = object2.getChildren()) == null) break block8;
                    object = (Iterable)object2;
                    bl = false;
                    Iterable iterable = object;
                    boolean bl2 = false;
                    for (Object t : iterable) {
                        ASTNode it = (ASTNode)t;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual(it.getType(), MarkdownTokenTypes.TEXT) || Intrinsics.areEqual(it.getType(), GFMTokenTypes.GFM_AUTOLINK))) continue;
                        v1 = t;
                        break block7;
                    }
                    v1 = null;
                }
                if ((object2 = (ASTNode)v1) != null && (object2 = MarkdownRenderer.nodeText$default(this, (ASTNode)object2, 0, 1, null)) != null) break block9;
            }
            object2 = dest = "";
        }
        if (this.hyperlinks) {
            object = (CharSequence)dest;
            bl = false;
            if (!StringsKt.isBlank((CharSequence)object)) {
                return ParsingKt.parseText(text, TextStyleKt.copy$default(this.theme.getMarkdownLinkText(), null, null, (String)dest, HyperlinkIdsKt.getGenerateHyperlinkId().invoke(), 3, null));
            }
        }
        Lines parsedText = ParsingKt.parseText(text, this.theme.getMarkdownLinkText());
        Lines parsedDest = ParsingKt.parseText('(' + (String)dest + ')', this.theme.getMarkdownLinkDestination());
        List<Lines> $this$foldLines$iv = CollectionsKt.listOf(parsedText, parsedDest);
        boolean $i$f$foldLines = false;
        Iterable iterable = $this$foldLines$iv;
        Lines initial$iv$iv = LinesKt.getEMPTY_LINES();
        boolean $i$f$fold = false;
        Lines accumulator$iv$iv = initial$iv$iv;
        Iterator iterator2 = $this$fold$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            void r$iv;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator2.next();
            Lines l$iv = accumulator$iv$iv;
            boolean bl4 = false;
            Lines lines = (Lines)r$iv;
            Lines lines2 = l$iv;
            boolean bl5 = false;
            void var20_23 = it;
            accumulator$iv$iv = lines2.plus$mordant((Lines)var20_23);
        }
        return accumulator$iv$iv;
    }

    private final Lines parseReferenceLink(ASTNode node, boolean hyperlinks) {
        Lines lines;
        String hyperlink;
        if (!hyperlinks) {
            return MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null);
        }
        Object object = ASTUtilKt.findChildOfType(node, MarkdownElementTypes.LINK_TEXT);
        String text = object != null && (object = object.getChildren()) != null && (object = (ASTNode)object.get(1)) != null ? MarkdownRenderer.nodeText$default(this, (ASTNode)object, 0, 1, null) : null;
        String label = MarkdownRenderer.nodeText$default(this, MarkdownRendererKt.access$firstChildOfType(node, MarkdownElementTypes.LINK_LABEL).getChildren().get(1), 0, 1, null);
        Object object2 = this.linkMap;
        String string = object2 != null && (object2 = ((LinkMap)object2).getLinkInfo('[' + label + ']')) != null && (object2 = ((LinkMap.LinkInfo)object2).getDestination()) != null ? object2.toString() : (hyperlink = null);
        if (hyperlink == null) {
            lines = MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null);
        } else {
            String string2 = text;
            if (string2 == null) {
                string2 = label;
            }
            lines = ParsingKt.parseText(string2, TextStyleKt.copy$default(this.theme.getMarkdownLinkText(), null, null, hyperlink, HyperlinkIdsKt.getGenerateHyperlinkId().invoke(), 3, null));
        }
        return lines;
    }

    public MarkdownRenderer(@NotNull String input, @NotNull Theme theme, boolean showHtml, boolean hyperlinks) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(theme, "theme");
        this.theme = theme;
        this.showHtml = showHtml;
        this.hyperlinks = hyperlinks;
        this.input = StringsKt.replace$default(input, "\r", "", false, 4, null);
    }

    public static final /* synthetic */ Sequence access$parseTableAlignment(MarkdownRenderer $this, ASTNode node) {
        return $this.parseTableAlignment(node);
    }

    public static final /* synthetic */ Theme access$getTheme$p(MarkdownRenderer $this) {
        return $this.theme;
    }

    public static final /* synthetic */ void access$parseTableRow(MarkdownRenderer $this, SectionBuilder $this$access_u24parseTableRow, ASTNode node) {
        $this.parseTableRow($this$access_u24parseTableRow, node);
    }

    public static final /* synthetic */ Pair access$dropWs(MarkdownRenderer $this, List nodes) {
        return $this.dropWs(nodes);
    }

    public static final /* synthetic */ Lines access$innerInlines(MarkdownRenderer $this, ASTNode node, int drop, int dropLast) {
        return $this.innerInlines(node, drop, dropLast);
    }
}

