#!/bin/bash
#
# This file is a part of the CM-LGC font package
# version 0.5 (May 07, 2005)
#
# Copyright (c) 2003--2005 Alexej Kryukov <basileia@yandex.ru>.
# 
# This package is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# As a special exception, permission is granted to include these font
# programs in a Postscript or PDF file that consists of a document that
# contains text to be displayed or printed using these fonts, regardless
# of the conditions or license applying to the document itself.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

CUR_DIR=$PWD
FONT_DIR=$CUR_DIR/output
SKEL_DIR=$CUR_DIR/texmf-skel
TEXMF_DIR=$CUR_DIR/texmf

PACK_NAME=cm-lgc

PFB_DIR=$TEXMF_DIR/fonts/type1/public/$PACK_NAME
AFM_DIR=$TEXMF_DIR/fonts/afm/public/$PACK_NAME
INF_DIR=$TEXMF_DIR/inf

rm -rf $TEXMF_DIR

if !([ -d $TEXMF_DIR ]); then
    cp -r $SKEL_DIR $TEXMF_DIR
fi

cd $TEXMF_DIR
if !([ -d 'inf' ]); then
    mkdir 'inf'
fi

if !([ -d 'fonts' ]); then
    mkdir 'fonts'
fi

cd fonts

for dir in 'afm' 'type1' 'tfm' 'vf' 'ofm' 'ovf'; do
    if !([ -d $dir ]); then
        mkdir $dir
    fi
    
    cd $dir

    if !([ -d 'public' ]); then
        mkdir 'public'
    fi
    
    cd 'public'

    if !([ -d $PACK_NAME ]); then
        mkdir $PACK_NAME
    fi
    
    cd $TEXMF_DIR/fonts
done

cp $FONT_DIR/*.pfb $PFB_DIR
cp $FONT_DIR/*.afm $AFM_DIR
cp $FONT_DIR/*.inf $INF_DIR

exit 0
