/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.mvel.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.AraraIOException;
import org.islandoftex.arara.api.SafeRunViolationException;
import org.islandoftex.arara.api.configuration.ExecutionMode;
import org.islandoftex.arara.api.files.MPPPath;
import org.islandoftex.arara.api.files.Project;
import org.islandoftex.arara.api.files.ProjectFile;
import org.islandoftex.arara.api.session.Command;
import org.islandoftex.arara.core.files.FileHandling;
import org.islandoftex.arara.core.files.FileSearching;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.Environment;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.islandoftex.arara.core.session.Session;
import org.islandoftex.arara.core.ui.GUIDialogs;
import org.islandoftex.arara.core.ui.InputHandling;
import org.islandoftex.arara.mvel.interpreter.AraraExceptionWithHeader;
import org.islandoftex.arara.mvel.utils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b)\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u000f\u001a\u00020\u00062\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0011\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0007J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000bH\u0007J%\u0010\u001b\u001a\u00020\u001c2\u0016\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0011\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fH\u0007J-\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00062\u0016\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0011\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\"J\u001e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fH\u0007J-\u0010 \u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000b2\u0016\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0011\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010#J\u001e\u0010 \u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fH\u0007J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0007J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000bH\u0007J\"\u0010%\u001a\u0004\u0018\u00010\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\b\b\u0002\u0010'\u001a\u00020(H\u0007J\b\u0010)\u001a\u00020*H\u0007J\u0012\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020(H\u0007J\u0012\u0010.\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0007J\b\u0010/\u001a\u00020\u0014H\u0007J\u001e\u0010/\u001a\u0004\u0018\u00010\u00012\b\u00100\u001a\u0004\u0018\u00010\u00012\b\u00101\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u0006H\u0007J(\u00102\u001a\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u00020\u00062\b\u00100\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u0001H\u0007J(\u00104\u001a\u0004\u0018\u00010\u00012\u0006\u00105\u001a\u00020\u00142\b\u00100\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u00104\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u0006H\u0007J(\u00104\u001a\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u00020\u00062\b\u00100\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u0001H\u0007J0\u00104\u001a\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u00020\u00062\b\u00100\u001a\u0004\u0018\u00010\u00012\b\u00101\u001a\u0004\u0018\u00010\u00012\b\u00106\u001a\u0004\u0018\u00010\u0001H\u0007J\b\u00107\u001a\u00020\u0014H\u0007J\u001e\u00107\u001a\u0004\u0018\u00010\u00012\b\u00100\u001a\u0004\u0018\u00010\u00012\b\u00101\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u00108\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0007J\b\u00109\u001a\u00020\u0014H\u0007J\u001e\u00109\u001a\u0004\u0018\u00010\u00012\b\u00100\u001a\u0004\u0018\u00010\u00012\b\u00101\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u0010:\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u0010;\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u0006H\u0007J(\u0010;\u001a\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u00020\u00062\b\u00100\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u0010<\u001a\u00020\u00142\u0006\u0010=\u001a\u00020\u0006H\u0007J\u0012\u0010>\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u0010?\u001a\u00020\u00142\u0006\u0010@\u001a\u00020\u000bH\u0007J(\u0010A\u001a\u0004\u0018\u00010\u00012\u0006\u00105\u001a\u00020\u00142\b\u00100\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u0010A\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u0006H\u0007J(\u0010A\u001a\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u00020\u00062\b\u00100\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u0001H\u0007J0\u0010A\u001a\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u00020\u00062\b\u00100\u001a\u0004\u0018\u00010\u00012\b\u00101\u001a\u0004\u0018\u00010\u00012\b\u00106\u001a\u0004\u0018\u00010\u0001H\u0007J\b\u0010B\u001a\u00020\u0014H\u0007J\u001e\u0010B\u001a\u0004\u0018\u00010\u00012\b\u00100\u001a\u0004\u0018\u00010\u00012\b\u00101\u001a\u0004\u0018\u00010\u0001H\u0007J\b\u0010C\u001a\u00020\u0014H\u0007J\b\u0010D\u001a\u00020\u0014H\u0007J\u001e\u0010D\u001a\u0004\u0018\u00010\u00012\b\u00100\u001a\u0004\u0018\u00010\u00012\b\u00101\u001a\u0004\u0018\u00010\u0001H\u0007J,\u0010E\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f2\u0006\u0010!\u001a\u00020\u00062\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010G\u001a\u00020\u0014H\u0007J,\u0010E\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f2\u0006\u0010@\u001a\u00020\u000b2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010G\u001a\u00020\u0014H\u0007J,\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f2\u0006\u0010!\u001a\u00020\u00062\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010G\u001a\u00020\u0014H\u0007J,\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f2\u0006\u0010@\u001a\u00020\u000b2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010G\u001a\u00020\u0014H\u0007J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010!\u001a\u00020\u0006H\u0007J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010\u001a\u001a\u00020\u000bH\u0007J$\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0006\u0010L\u001a\u00020\u00062\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00010\u001fH\u0007J*\u0010N\u001a\u00020,2\b\b\u0002\u0010O\u001a\u00020(2\u0006\u0010P\u001a\u00020(2\u0006\u0010Q\u001a\u00020\u00062\u0006\u0010R\u001a\u00020\u0006H\u0007J\u0010\u0010S\u001a\u00020,2\u0006\u0010R\u001a\u00020\u0006H\u0007J\u0010\u0010T\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u0006H\u0007J\u001c\u0010U\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00060V2\u0006\u0010=\u001a\u00020\u001cH\u0007J \u0010W\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00062\u0006\u0010R\u001a\u00020\u00062\u0006\u0010X\u001a\u00020\u0014H\u0007J&\u0010W\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00062\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010X\u001a\u00020\u0014H\u0007J \u0010W\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010R\u001a\u00020\u00062\u0006\u0010X\u001a\u00020\u0014H\u0007J&\u0010W\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000b2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010X\u001a\u00020\u0014H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000e\u00a8\u0006Z"}, d2={"Lorg/islandoftex/arara/mvel/utils/RuleMethods;", "", "()V", "dialogs", "Lorg/islandoftex/arara/core/ui/GUIDialogs;", "originalFile", "", "getOriginalFile$annotations", "getOriginalFile", "()Ljava/lang/String;", "originalReference", "Lorg/islandoftex/arara/api/files/MPPPath;", "getOriginalReference$annotations", "getOriginalReference", "()Lorg/islandoftex/arara/api/files/MPPPath;", "buildString", "objects", "", "([Ljava/lang/Object;)Ljava/lang/String;", "checkClass", "", "clazz", "Ljava/lang/Class;", "obj", "getBasename", "filename", "file", "getCommand", "Lorg/islandoftex/arara/api/session/Command;", "elements", "([Ljava/lang/Object;)Lorg/islandoftex/arara/api/session/Command;", "", "getCommandWithWorkingDirectory", "path", "(Ljava/lang/String;[Ljava/lang/Object;)Lorg/islandoftex/arara/api/session/Command;", "(Lorg/islandoftex/arara/api/files/MPPPath;[Ljava/lang/Object;)Lorg/islandoftex/arara/api/session/Command;", "getFiletype", "getOrNull", "list", "index", "", "getSession", "Lorg/islandoftex/arara/core/session/Session;", "halt", "", "status", "isBoolean", "isCygwin", "yes", "no", "isEmpty", "string", "isFalse", "value", "fallback", "isLinux", "isList", "isMac", "isMap", "isNotEmpty", "isOnPath", "command", "isString", "isSubdirectory", "directory", "isTrue", "isUnix", "isVerboseMode", "isWindows", "listFilesByExtensions", "extensions", "recursive", "listFilesByPatterns", "patterns", "readFromFile", "replicatePattern", "pattern", "values", "showMessage", "width", "type", "title", "text", "throwError", "trimSpaces", "unsafelyExecuteSystemCommand", "Lkotlin/Pair;", "writeToFile", "append", "lines", "mvel"})
public final class RuleMethods {
    @NotNull
    public static final RuleMethods INSTANCE = new RuleMethods();
    @NotNull
    private static final GUIDialogs dialogs = new GUIDialogs(Session.INSTANCE.getUserInterfaceOptions(), 0, 2, null);

    private RuleMethods() {
    }

    @JvmStatic
    @JvmOverloads
    public static final void halt(int status2) {
        Session.INSTANCE.put("arara:" + INSTANCE.getOriginalFile() + ":halt", status2);
    }

    public static /* synthetic */ void halt$default(int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        RuleMethods.halt(n);
    }

    @NotNull
    public static final String getOriginalFile() {
        return INSTANCE.getOriginalReference().getFileName();
    }

    @JvmStatic
    public static /* synthetic */ void getOriginalFile$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MPPPath getOriginalReference() {
        Object v1;
        Project project = LinearExecutor.INSTANCE.getCurrentProject();
        Intrinsics.checkNotNull(project);
        Iterable $this$minByOrNull$iv = project.getFiles();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                void var3_3;
                ProjectFile it = (ProjectFile)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getPriority();
                do {
                    Object e$iv = iterator$iv.next();
                    ProjectFile it2 = (ProjectFile)e$iv;
                    $i$a$-minByOrNull-RuleMethods$originalReference$1 = false;
                    int v$iv = it2.getPriority();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = var3_3;
            }
        }
        Intrinsics.checkNotNull(v1);
        return ((ProjectFile)v1).getPath();
    }

    @JvmStatic
    public static /* synthetic */ void getOriginalReference$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String trimSpaces(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @JvmStatic
    @NotNull
    public static final String getBasename(@NotNull MPPPath file) throws AraraException {
        Intrinsics.checkNotNullParameter(file, "file");
        if (!file.isRegularFile()) {
            String string = LanguageController.getMessages().getERROR_BASENAME_NOT_A_FILE();
            Object[] objectArray = new Object[]{file.getFileName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
            throw new AraraExceptionWithHeader(string2);
        }
        return StringsKt.substringBeforeLast$default(file.getFileName(), ".", null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final String getBasename(@NotNull String filename) {
        Intrinsics.checkNotNullParameter(filename, "filename");
        return RuleMethods.getBasename(new MPPPath(filename));
    }

    @JvmStatic
    @NotNull
    public static final String getFiletype(@NotNull MPPPath file) throws AraraException {
        Intrinsics.checkNotNullParameter(file, "file");
        if (!file.isRegularFile()) {
            String string = LanguageController.getMessages().getERROR_FILETYPE_NOT_A_FILE();
            Object[] objectArray = new Object[]{file.getFileName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
            throw new AraraExceptionWithHeader(string2);
        }
        return StringsKt.substringAfterLast$default(file.getFileName(), ".", null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final String getFiletype(@NotNull String filename) {
        Intrinsics.checkNotNullParameter(filename, "filename");
        return RuleMethods.getFiletype(new MPPPath(filename));
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String getOrNull(@NotNull List<String> list, int index) {
        Intrinsics.checkNotNullParameter(list, "list");
        return CollectionsKt.getOrNull(list, index);
    }

    public static /* synthetic */ String getOrNull$default(List list, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return RuleMethods.getOrNull(list, n);
    }

    @JvmStatic
    @NotNull
    public static final List<Object> replicatePattern(@NotNull String pattern, @NotNull List<? extends Object> values2) throws AraraException {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter(values2, "values");
        return MethodUtils.replicateList(pattern, values2);
    }

    @JvmStatic
    public static final void throwError(@NotNull String text2) throws AraraException {
        Intrinsics.checkNotNullParameter(text2, "text");
        throw new AraraExceptionWithHeader(text2);
    }

    @JvmStatic
    @NotNull
    public static final Session getSession() {
        return Session.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final String buildString(Object ... objects) {
        Intrinsics.checkNotNullParameter(objects, "objects");
        Object[] objectArray = new Object[1];
        Collection $this$toTypedArray$iv = ArraysKt.filterNotNull(objects);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        if (thisCollection$iv.toArray(new Object[0]) == null) {
            Object[] cfr_ignored_0 = objectArray[0];
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return MethodUtils.generateString(objectArray);
    }

    @JvmStatic
    @NotNull
    public static final Command getCommand(@NotNull List<String> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Project project = LinearExecutor.INSTANCE.getCurrentProject();
        Intrinsics.checkNotNull(project);
        return new org.islandoftex.arara.core.session.Command(elements, project.getWorkingDirectory());
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Command getCommand(Object ... elements) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(elements, "elements");
        Iterable $this$map$iv = InputHandling.INSTANCE.flatten(ArraysKt.filterNotNull(elements));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return RuleMethods.getCommand((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Command getCommandWithWorkingDirectory(@NotNull String path2, Object ... elements) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(elements, "elements");
        Iterable $this$map$iv = InputHandling.INSTANCE.flatten(ArraysKt.filterNotNull(elements));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        MPPPath mPPPath = new MPPPath(path2);
        List list = (List)destination$iv$iv;
        return new org.islandoftex.arara.core.session.Command(list, mPPPath);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Command getCommandWithWorkingDirectory(@NotNull MPPPath file, Object ... elements) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(elements, "elements");
        Iterable $this$map$iv = InputHandling.INSTANCE.flatten(ArraysKt.filterNotNull(elements));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        MPPPath mPPPath = file;
        List list = (List)destination$iv$iv;
        return new org.islandoftex.arara.core.session.Command(list, mPPPath);
    }

    @JvmStatic
    @NotNull
    public static final Command getCommandWithWorkingDirectory(@NotNull String path2, @NotNull List<String> elements) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(elements, "elements");
        return new org.islandoftex.arara.core.session.Command(elements, new MPPPath(path2));
    }

    @JvmStatic
    @NotNull
    public static final Command getCommandWithWorkingDirectory(@NotNull MPPPath file, @NotNull List<String> elements) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(elements, "elements");
        return new org.islandoftex.arara.core.session.Command(elements, file);
    }

    @JvmStatic
    public static final boolean isVerboseMode() {
        return LinearExecutor.INSTANCE.getExecutionOptions().getVerbose();
    }

    @JvmStatic
    @JvmOverloads
    public static final void showMessage(int width, int type2, @NotNull String title, @NotNull String text2) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(text2, "text");
        dialogs.showMessage(width, type2, title, text2);
    }

    public static /* synthetic */ void showMessage$default(int n, int n2, String string, String string2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = dialogs.getDefaultWidth();
        }
        RuleMethods.showMessage(n, n2, string, string2);
    }

    @JvmStatic
    @NotNull
    public static final Pair<Integer, String> unsafelyExecuteSystemCommand(@NotNull Command command2) {
        Intrinsics.checkNotNullParameter(command2, "command");
        if (LinearExecutor.INSTANCE.getExecutionOptions().getExecutionMode() == ExecutionMode.SAFE_RUN) {
            throw new SafeRunViolationException("In safe mode, rules are not allowed to execute arbitrary system commands within a step of execution.");
        }
        return Environment.executeSystemCommand-SxA4cEA$default(command2, false, 0L, 6, null);
    }

    @JvmStatic
    @NotNull
    public static final List<MPPPath> listFilesByExtensions(@NotNull MPPPath directory, @NotNull List<String> extensions, boolean recursive) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        return FileSearching.INSTANCE.listFilesByExtensions(directory, extensions, recursive);
    }

    @JvmStatic
    @NotNull
    public static final List<MPPPath> listFilesByExtensions(@NotNull String path2, @NotNull List<String> extensions, boolean recursive) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        return RuleMethods.listFilesByExtensions(new MPPPath(path2), extensions, recursive);
    }

    @JvmStatic
    @NotNull
    public static final List<MPPPath> listFilesByPatterns(@NotNull MPPPath directory, @NotNull List<String> patterns, boolean recursive) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(patterns, "patterns");
        return FileSearching.INSTANCE.listFilesByPatterns(directory, patterns, recursive);
    }

    @JvmStatic
    @NotNull
    public static final List<MPPPath> listFilesByPatterns(@NotNull String path2, @NotNull List<String> patterns, boolean recursive) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(patterns, "patterns");
        return RuleMethods.listFilesByPatterns(new MPPPath(path2), patterns, recursive);
    }

    @JvmStatic
    public static final boolean writeToFile(@NotNull MPPPath file, @NotNull String text2, boolean append) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(text2, "text");
        return MethodUtils.writeToFile(file, text2, append);
    }

    @JvmStatic
    public static final boolean writeToFile(@NotNull String path2, @NotNull String text2, boolean append) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(text2, "text");
        return MethodUtils.writeToFile(new MPPPath(path2), text2, append);
    }

    @JvmStatic
    public static final boolean writeToFile(@NotNull MPPPath file, @NotNull List<String> lines, boolean append) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(lines, "lines");
        Iterable iterable = lines;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue(string, "lineSeparator()");
        return MethodUtils.writeToFile(file, CollectionsKt.joinToString$default(iterable, string, null, null, 0, null, null, 62, null), append);
    }

    @JvmStatic
    public static final boolean writeToFile(@NotNull String path2, @NotNull List<String> lines, boolean append) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(lines, "lines");
        MPPPath mPPPath = new MPPPath(path2);
        Iterable iterable = lines;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue(string, "lineSeparator()");
        return MethodUtils.writeToFile(mPPPath, CollectionsKt.joinToString$default(iterable, string, null, null, 0, null, null, 62, null), append);
    }

    @JvmStatic
    @NotNull
    public static final List<String> readFromFile(@NotNull MPPPath file) {
        List<String> list;
        Intrinsics.checkNotNullParameter(file, "file");
        try {
            list = file.readLines();
        }
        catch (AraraIOException _) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final List<String> readFromFile(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        return RuleMethods.readFromFile(new MPPPath(path2));
    }

    @JvmStatic
    public static final boolean isSubdirectory(@NotNull MPPPath directory) throws AraraException {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Project project = LinearExecutor.INSTANCE.getCurrentProject();
        Intrinsics.checkNotNull(project);
        return FileHandling.INSTANCE.isSubDirectory(directory, project.getWorkingDirectory());
    }

    @JvmStatic
    public static final boolean isEmpty(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        return ((CharSequence)string).length() == 0;
    }

    @JvmStatic
    public static final boolean isNotEmpty(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        return !RuleMethods.isEmpty(string);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Object isEmpty(@NotNull String string, @Nullable Object yes, @Nullable Object no) {
        Intrinsics.checkNotNullParameter(string, "string");
        return RuleMethods.isEmpty(string) ? yes : no;
    }

    public static /* synthetic */ Object isEmpty$default(String string, Object object, Object object2, int n, Object object3) {
        if ((n & 4) != 0) {
            object2 = "";
        }
        return RuleMethods.isEmpty(string, object, object2);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Object isNotEmpty(@NotNull String string, @Nullable Object yes, @Nullable Object no) {
        Intrinsics.checkNotNullParameter(string, "string");
        return RuleMethods.isNotEmpty(string) ? yes : no;
    }

    public static /* synthetic */ Object isNotEmpty$default(String string, Object object, Object object2, int n, Object object3) {
        if ((n & 4) != 0) {
            object2 = "";
        }
        return RuleMethods.isNotEmpty(string, object, object2);
    }

    @JvmStatic
    public static final boolean isTrue(@NotNull String string) throws AraraException {
        Intrinsics.checkNotNullParameter(string, "string");
        return !RuleMethods.isEmpty(string) && InputHandling.INSTANCE.checkBoolean(string);
    }

    @JvmStatic
    public static final boolean isFalse(@NotNull String string) throws AraraException {
        Intrinsics.checkNotNullParameter(string, "string");
        return !RuleMethods.isEmpty(string) && !InputHandling.INSTANCE.checkBoolean(string);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Object isTrue(@NotNull String string, @Nullable Object yes, @Nullable Object no) throws AraraException {
        Intrinsics.checkNotNullParameter(string, "string");
        return RuleMethods.isTrue(string) ? yes : no;
    }

    public static /* synthetic */ Object isTrue$default(String string, Object object, Object object2, int n, Object object3) throws AraraException {
        if ((n & 4) != 0) {
            object2 = "";
        }
        return RuleMethods.isTrue(string, object, object2);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Object isFalse(@NotNull String string, @Nullable Object yes, @Nullable Object no) throws AraraException {
        Intrinsics.checkNotNullParameter(string, "string");
        return RuleMethods.isFalse(string) ? yes : no;
    }

    public static /* synthetic */ Object isFalse$default(String string, Object object, Object object2, int n, Object object3) throws AraraException {
        if ((n & 4) != 0) {
            object2 = "";
        }
        return RuleMethods.isFalse(string, object, object2);
    }

    @JvmStatic
    @Nullable
    public static final Object isTrue(@NotNull String string, @Nullable Object yes, @Nullable Object no, @Nullable Object fallback) throws AraraException {
        Intrinsics.checkNotNullParameter(string, "string");
        return RuleMethods.isEmpty(string) ? fallback : (RuleMethods.isTrue(string) ? yes : no);
    }

    @JvmStatic
    @Nullable
    public static final Object isFalse(@NotNull String string, @Nullable Object yes, @Nullable Object no, @Nullable Object fallback) throws AraraException {
        Intrinsics.checkNotNullParameter(string, "string");
        return RuleMethods.isEmpty(string) ? fallback : (RuleMethods.isFalse(string) ? yes : no);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Object isTrue(boolean value, @Nullable Object yes, @Nullable Object no) {
        return value ? yes : no;
    }

    public static /* synthetic */ Object isTrue$default(boolean bl, Object object, Object object2, int n, Object object3) {
        if ((n & 4) != 0) {
            object2 = "";
        }
        return RuleMethods.isTrue(bl, object, object2);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Object isFalse(boolean value, @Nullable Object yes, @Nullable Object no) {
        return !value ? yes : no;
    }

    public static /* synthetic */ Object isFalse$default(boolean bl, Object object, Object object2, int n, Object object3) {
        if ((n & 4) != 0) {
            object2 = "";
        }
        return RuleMethods.isFalse(bl, object, object2);
    }

    @JvmStatic
    public static final boolean checkClass(@NotNull Class<?> clazz, @Nullable Object obj) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return clazz.isInstance(obj);
    }

    @JvmStatic
    public static final boolean isString(@Nullable Object obj) {
        return RuleMethods.checkClass(String.class, obj);
    }

    @JvmStatic
    public static final boolean isList(@Nullable Object obj) {
        return RuleMethods.checkClass(List.class, obj);
    }

    @JvmStatic
    public static final boolean isMap(@Nullable Object obj) {
        return RuleMethods.checkClass(Map.class, obj);
    }

    @JvmStatic
    public static final boolean isBoolean(@Nullable Object obj) {
        return RuleMethods.checkClass(Boolean.class, obj);
    }

    @JvmStatic
    public static final boolean isOnPath(@NotNull String command2) {
        Intrinsics.checkNotNullParameter(command2, "command");
        return Environment.isOnPath(command2);
    }

    @JvmStatic
    public static final boolean isWindows() throws AraraException {
        return Environment.checkOS(Environment.SupportedOS.WINDOWS);
    }

    @JvmStatic
    public static final boolean isCygwin() throws AraraException {
        return Environment.checkOS(Environment.SupportedOS.CYGWIN);
    }

    @JvmStatic
    public static final boolean isLinux() throws AraraException {
        return Environment.checkOS(Environment.SupportedOS.LINUX);
    }

    @JvmStatic
    public static final boolean isMac() throws AraraException {
        return Environment.checkOS(Environment.SupportedOS.MACOS);
    }

    @JvmStatic
    public static final boolean isUnix() throws AraraException {
        return Environment.checkOS(Environment.SupportedOS.UNIX);
    }

    @JvmStatic
    @Nullable
    public static final Object isWindows(@Nullable Object yes, @Nullable Object no) throws AraraException {
        return Environment.checkOS(Environment.SupportedOS.WINDOWS) ? yes : no;
    }

    @JvmStatic
    @Nullable
    public static final Object isCygwin(@Nullable Object yes, @Nullable Object no) throws AraraException {
        return Environment.checkOS(Environment.SupportedOS.CYGWIN) ? yes : no;
    }

    @JvmStatic
    @Nullable
    public static final Object isLinux(@Nullable Object yes, @Nullable Object no) throws AraraException {
        return Environment.checkOS(Environment.SupportedOS.LINUX) ? yes : no;
    }

    @JvmStatic
    @Nullable
    public static final Object isMac(@Nullable Object yes, @Nullable Object no) throws AraraException {
        return Environment.checkOS(Environment.SupportedOS.MACOS) ? yes : no;
    }

    @JvmStatic
    @Nullable
    public static final Object isUnix(@Nullable Object yes, @Nullable Object no) throws AraraException {
        return Environment.checkOS(Environment.SupportedOS.UNIX) ? yes : no;
    }

    @JvmStatic
    @JvmOverloads
    public static final void halt() {
        RuleMethods.halt$default(0, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String getOrNull(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "list");
        return RuleMethods.getOrNull$default(list, 0, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void showMessage(int type2, @NotNull String title, @NotNull String text2) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(text2, "text");
        RuleMethods.showMessage$default(0, type2, title, text2, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Object isEmpty(@NotNull String string, @Nullable Object yes) {
        Intrinsics.checkNotNullParameter(string, "string");
        return RuleMethods.isEmpty$default(string, yes, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Object isNotEmpty(@NotNull String string, @Nullable Object yes) {
        Intrinsics.checkNotNullParameter(string, "string");
        return RuleMethods.isNotEmpty$default(string, yes, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Object isTrue(@NotNull String string, @Nullable Object yes) throws AraraException {
        Intrinsics.checkNotNullParameter(string, "string");
        return RuleMethods.isTrue$default(string, yes, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Object isFalse(@NotNull String string, @Nullable Object yes) throws AraraException {
        Intrinsics.checkNotNullParameter(string, "string");
        return RuleMethods.isFalse$default(string, yes, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Object isTrue(boolean value, @Nullable Object yes) {
        return RuleMethods.isTrue$default(value, yes, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Object isFalse(boolean value, @Nullable Object yes) {
        return RuleMethods.isFalse$default(value, yes, null, 4, null);
    }
}

