/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.texplate.model;

import com.moandjiezana.toml.Toml;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.islandoftex.texplate.exceptions.InvalidTemplateException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B'\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J+\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/islandoftex/texplate/model/Configuration;", "", "template", "", "map", "", "(Ljava/lang/String;Ljava/util/Map;)V", "isValid", "", "()Z", "getMap", "()Ljava/util/Map;", "getTemplate", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "texplate"})
public final class Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String template;
    @NotNull
    private final Map<String, Object> map;

    public Configuration(@Nullable String template, @NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, "map");
        this.template = template;
        this.map = map;
    }

    public /* synthetic */ Configuration(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            boolean bl = false;
            map = MapsKt.emptyMap();
        }
        this(string, map);
    }

    @Nullable
    public final String getTemplate() {
        return this.template;
    }

    @NotNull
    public final Map<String, Object> getMap() {
        return this.map;
    }

    private final boolean isValid() {
        return this.template != null;
    }

    @Nullable
    public final String component1() {
        return this.template;
    }

    @NotNull
    public final Map<String, Object> component2() {
        return this.map;
    }

    @NotNull
    public final Configuration copy(@Nullable String template, @NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, "map");
        return new Configuration(template, map);
    }

    public static /* synthetic */ Configuration copy$default(Configuration configuration, String string, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = configuration.template;
        }
        if ((n & 2) != 0) {
            map = configuration.map;
        }
        return configuration.copy(string, map);
    }

    @NotNull
    public String toString() {
        return "Configuration(template=" + this.template + ", map=" + this.map + ')';
    }

    public int hashCode() {
        int result = this.template == null ? 0 : this.template.hashCode();
        result = result * 31 + ((Object)this.map).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Configuration)) {
            return false;
        }
        Configuration configuration = (Configuration)other;
        if (!Intrinsics.areEqual(this.template, configuration.template)) {
            return false;
        }
        return Intrinsics.areEqual(this.map, configuration.map);
    }

    public Configuration() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/islandoftex/texplate/model/Configuration$Companion;", "", "()V", "fromPath", "Lorg/islandoftex/texplate/model/Configuration;", "path", "Ljava/nio/file/Path;", "texplate"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Configuration fromPath(@NotNull Path path) throws InvalidTemplateException {
            Configuration configuration;
            Intrinsics.checkNotNullParameter(path, "path");
            Configuration configuration2 = null;
            String message = "The provided configuration file looks invalid. Please make sure the configuration has a valid syntax and try again. ";
            try {
                configuration = new Toml().read(path.toFile()).to(Configuration.class);
                Intrinsics.checkNotNullExpressionValue(configuration, "{\n                // gets the configuration\n                Toml().read(path.toFile()).to(Configuration::class.java)\n            }");
            }
            catch (IllegalStateException exception) {
                throw new InvalidTemplateException(Intrinsics.stringPlus(message, "In this particular scenario, there is a possibility that the configuration file does not follow the TOML specification. Please refer to the user manual for further details and a possible fix. Also, the raised exception message can give us some hints on what happened."), exception);
            }
            configuration2 = configuration;
            if (!configuration2.isValid()) {
                throw new InvalidTemplateException(Intrinsics.stringPlus(message, "Specifically, some mandatory fields are either absent or empty in the configuration file. It is quite important to strictly follow the configuration specification, as detailed in the user manual, or the tool will not work at all."));
            }
            return configuration2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

