/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.files;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.configuration.ExecutionMode;
import org.islandoftex.arara.api.configuration.ExecutionOptions;
import org.islandoftex.arara.api.files.FileType;
import org.islandoftex.arara.core.files.FileHandling;
import org.islandoftex.arara.core.files.FileSearching;
import org.islandoftex.arara.core.files.FileTypeKt;
import org.islandoftex.arara.core.files.ProjectFile;
import org.islandoftex.arara.core.localization.LanguageController;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J,\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J'\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/islandoftex/arara/core/files/FileSearching;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "listFilesByExtensions", "", "Ljava/io/File;", "directory", "extensions", "", "recursive", "", "listFilesByPatterns", "patterns", "lookupFile", "Lorg/islandoftex/arara/api/files/ProjectFile;", "reference", "workingDirectory", "Ljava/nio/file/Path;", "executionOptions", "Lorg/islandoftex/arara/api/configuration/ExecutionOptions;", "lookupFile$core", "resolveFile", "core"})
public final class FileSearching {
    @NotNull
    public static final FileSearching INSTANCE = new FileSearching();
    private static final Logger logger = LoggerFactory.getLogger(FileSearching.class);

    private FileSearching() {
    }

    @JvmStatic
    @NotNull
    public static final List<File> listFilesByExtensions(@NotNull File directory, @NotNull List<String> extensions, boolean recursive) {
        List<File> list;
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        try {
            List<File> list2;
            if (recursive) {
                list2 = SequencesKt.toList(SequencesKt.filter(SequencesKt.filter(FilesKt.walkTopDown(directory), listFilesByExtensions.1.INSTANCE), (Function1)new Function1<File, Boolean>(extensions){
                    final /* synthetic */ List<String> $extensions;
                    {
                        this.$extensions = $extensions;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull File it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.$extensions.contains(FilesKt.getExtension(it));
                    }
                }));
            } else {
                File[] fileArray = directory.listFiles(arg_0 -> FileSearching.listFilesByExtensions$lambda-0(extensions, arg_0));
                Intrinsics.checkNotNull(fileArray);
                list2 = ArraysKt.toList(fileArray);
            }
            list = list2;
        }
        catch (Exception _) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<File> listFilesByPatterns(@NotNull File directory, @NotNull List<String> patterns, boolean recursive) {
        List<File> list;
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(patterns, "patterns");
        try {
            List<File> list2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = patterns;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FileSystems.getDefault().getPathMatcher(Intrinsics.stringPlus("glob:", it)));
            }
            List pathMatcher = (List)destination$iv$iv;
            if (recursive) {
                list2 = SequencesKt.toList(SequencesKt.filter(SequencesKt.filter(FilesKt.walkTopDown(directory), listFilesByPatterns.1.INSTANCE), (Function1)new Function1<File, Boolean>((List<? extends PathMatcher>)pathMatcher){
                    final /* synthetic */ List<PathMatcher> $pathMatcher;
                    {
                        this.$pathMatcher = $pathMatcher;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull File file2) {
                        boolean bl;
                        block3: {
                            Intrinsics.checkNotNullParameter(file2, "file");
                            Iterable $this$any$iv = this.$pathMatcher;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    PathMatcher it = (PathMatcher)element$iv;
                                    boolean bl2 = false;
                                    if (!it.matches(file2.toPath().getFileName())) continue;
                                    bl = true;
                                    break block3;
                                }
                                bl = false;
                            }
                        }
                        return bl;
                    }
                }));
            } else {
                File[] fileArray = directory.listFiles(arg_0 -> FileSearching.listFilesByPatterns$lambda-3(pathMatcher, arg_0));
                Intrinsics.checkNotNull(fileArray);
                list2 = ArraysKt.toList(fileArray);
            }
            list = list2;
        }
        catch (Exception _) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final org.islandoftex.arara.api.files.ProjectFile resolveFile(@NotNull String reference, @NotNull Path workingDirectory, @NotNull ExecutionOptions executionOptions) throws AraraException {
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(executionOptions, "executionOptions");
        org.islandoftex.arara.api.files.ProjectFile projectFile = INSTANCE.lookupFile$core(reference, workingDirectory, executionOptions);
        if (projectFile == null) {
            Object[] objectArray = new Object[]{reference, CollectionsKt.joinToString$default(executionOptions.getFileTypes(), " | ", "[ ", " ]", 0, null, null, 56, null)};
            String string = String.format(LanguageController.getMessages().getERROR_DISCOVERFILE_FILE_NOT_FOUND(), Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
            throw new AraraException(string);
        }
        return projectFile;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final org.islandoftex.arara.api.files.ProjectFile lookupFile$core(@NotNull String reference, @NotNull Path workingDirectory, @NotNull ExecutionOptions executionOptions) throws AraraException {
        block17: {
            block14: {
                block18: {
                    block16: {
                        block12: {
                            Intrinsics.checkNotNullParameter(reference, "reference");
                            Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
                            Intrinsics.checkNotNullParameter(executionOptions, "executionOptions");
                            types = executionOptions.getFileTypes();
                            var7_5 = workingDirectory.resolve(reference);
                            Intrinsics.checkNotNullExpressionValue(var7_5, "this.resolve(other)");
                            testFile = FileHandling.normalize((Path)var7_5);
                            var6_7 = testFile;
                            var7_5 = new LinkOption[]{};
                            if (!Files.exists((Path)var6_7, Arrays.copyOf(var7_5, ((LinkOption[])var7_5).length)) || !Files.isRegularFile((Path)(var6_7 = testFile), Arrays.copyOf(var7_5 = new LinkOption[0], ((LinkOption[])var7_5).length))) break block16;
                            $this$firstOrNull$iv = types;
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                it = (FileType)element$iv;
                                $i$a$-firstOrNull-FileSearching$lookupFile$1 = false;
                                if (!StringsKt.endsWith$default(reference, Intrinsics.stringPlus(".", it.getExtension()), false, 2, null)) continue;
                                v0 = element$iv;
                                break block12;
                            }
                            v0 = null;
                        }
                        var6_7 = v0;
                        if (var6_7 == null) {
                            v1 = null;
                        } else {
                            block13: {
                                it = var6_7;
                                $i$a$-let-FileSearching$lookupFile$2 = false;
                                extension = StringsKt.substringAfterLast$default(reference, '.', null, 2, null);
                                it = types;
                                $i$a$-firstOrNull-FileSearching$lookupFile$1 = testFile;
                                $i$f$firstOrNull = false;
                                for (T element$iv : $this$firstOrNull$iv) {
                                    it = (FileType)element$iv;
                                    $i$a$-firstOrNull-FileSearching$lookupFile$2$1 = false;
                                    if (!Intrinsics.areEqual(extension, it.getExtension())) continue;
                                    v2 = element$iv;
                                    break block13;
                                }
                                v2 = null;
                            }
                            var21_35 = v2;
                            var25_36 = null;
                            var26_37 = 4;
                            var27_38 = 0;
                            var28_39 = var21_35 == null ? FileTypeKt.getUNKNOWN_TYPE(FileType.Companion) : var21_35;
                            var29_40 = $i$a$-firstOrNull-FileSearching$lookupFile$1;
                            v1 = new ProjectFile(var29_40, var28_39, var27_38, var26_37, var25_36);
                        }
                        v3 = v1;
                        break block17;
                    }
                    if (executionOptions.getExecutionMode() != ExecutionMode.SAFE_RUN) break block18;
                    FileSearching.logger.info("Skipping indirect file search with extension completion due to safe mode restrictions.");
                    v3 = null;
                    break block17;
                }
                name = testFile.getFileName().toString();
                $this$map$iv = types;
                $i$f$map = false;
                extension = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                var13_41 = $this$mapTo$iv$iv.iterator();
                while (var13_41.hasNext()) {
                    item$iv$iv = var13_41.next();
                    $i$f$firstOrNull = (FileType)item$iv$iv;
                    var23_45 = destination$iv$iv;
                    $i$a$-map-FileSearching$lookupFile$3 = false;
                    var17_30 = testFile.getParent();
                    Intrinsics.checkNotNullExpressionValue(var17_30, "testFile.parent");
                    it = var17_30.resolve(name + '.' + it.getExtension());
                    Intrinsics.checkNotNullExpressionValue(it, "this.resolve(other)");
                    var23_45.add(it);
                }
                $this$map$iv = types;
                var23_45 = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                var13_41 = $this$mapTo$iv$iv.iterator();
                while (var13_41.hasNext()) {
                    item$iv$iv = var13_41.next();
                    it = (FileType)item$iv$iv;
                    var24_46 = destination$iv$iv;
                    $i$a$-map-FileSearching$lookupFile$4 = false;
                    var17_30 = testFile.getParent();
                    Intrinsics.checkNotNullExpressionValue(var17_30, "testFile.parent");
                    it = var17_30.resolve(StringsKt.trim((CharSequence)StringsKt.removeSuffix(name, (CharSequence)".")).toString() + '.' + it.getExtension());
                    Intrinsics.checkNotNullExpressionValue(it, "this.resolve(other)");
                    var24_46.add(it);
                }
                $this$map$iv = CollectionsKt.union(var23_45, (List)destination$iv$iv);
                $i$f$firstOrNull = false;
                for (E element$iv : $this$firstOrNull$iv) {
                    it = (Path)element$iv;
                    $i$a$-firstOrNull-FileSearching$lookupFile$5 = false;
                    v4 = new LinkOption[]{};
                    if (!Files.exists(it, Arrays.copyOf(v4, v4.length))) ** GOTO lbl-1000
                    v5 = new LinkOption[]{};
                    if (Files.isRegularFile(it, Arrays.copyOf(v5, v5.length))) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    if (!v6) continue;
                    v7 = element$iv;
                    break block14;
                }
                v7 = null;
            }
            var7_5 = v7;
            if (var7_5 == null) {
                v8 = null;
            } else {
                block15: {
                    found = var7_5;
                    $i$a$-let-FileSearching$lookupFile$6 = false;
                    extension = StringsKt.substringAfterLast$default(found.toString(), '.', null, 2, null);
                    it = types;
                    var13_43 = found;
                    $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        it = (FileType)element$iv;
                        $i$a$-firstOrNull-FileSearching$lookupFile$6$1 = false;
                        if (!Intrinsics.areEqual(extension, it.getExtension())) continue;
                        v9 = element$iv;
                        break block15;
                    }
                    v9 = null;
                }
                var22_48 = v9;
                var30_49 = null;
                var31_50 = 4;
                var32_51 = 0;
                var33_52 = var22_48 == null ? FileTypeKt.getUNKNOWN_TYPE(FileType.Companion) : var22_48;
                var34_53 = var13_43;
                v8 = new ProjectFile((Path)var34_53, var33_52, var32_51, var31_50, var30_49);
            }
            v3 = v8;
        }
        return v3;
    }

    private static final boolean listFilesByExtensions$lambda-0(List $extensions, File it) {
        Intrinsics.checkNotNullParameter($extensions, "$extensions");
        Intrinsics.checkNotNullExpressionValue(it, "it");
        return $extensions.contains(FilesKt.getExtension(it));
    }

    private static final boolean listFilesByPatterns$lambda-3(List $pathMatcher, File file2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($pathMatcher, "$pathMatcher");
            Intrinsics.checkNotNullParameter(file2, "file");
            Iterable $this$any$iv = $pathMatcher;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PathMatcher it = (PathMatcher)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(file2.toPath().getFileName())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

