/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli;

import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.ProgramResult;
import com.github.ajalt.clikt.parameters.arguments.ArgumentKt;
import com.github.ajalt.clikt.parameters.options.FlagOptionKt;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.IntKt;
import com.github.ajalt.clikt.parameters.types.PathKt;
import com.github.ajalt.clikt.parameters.types.RangeKt;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.configuration.ExecutionMode;
import org.islandoftex.arara.api.files.FileType;
import org.islandoftex.arara.api.files.ProjectFile;
import org.islandoftex.arara.api.rules.Directive;
import org.islandoftex.arara.api.session.ExecutionStatus;
import org.islandoftex.arara.cli.CLI;
import org.islandoftex.arara.cli.configuration.ConfigurationUtils;
import org.islandoftex.arara.cli.ruleset.DirectiveUtils;
import org.islandoftex.arara.cli.utils.DisplayUtils;
import org.islandoftex.arara.cli.utils.LoggingUtils;
import org.islandoftex.arara.core.configuration.ExecutionOptions;
import org.islandoftex.arara.core.configuration.LoggingOptions;
import org.islandoftex.arara.core.configuration.UserInterfaceOptions;
import org.islandoftex.arara.core.files.FileHandling;
import org.islandoftex.arara.core.files.FileSearching;
import org.islandoftex.arara.core.files.Project;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.rules.Directives;
import org.islandoftex.arara.core.session.ExecutorHooks;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.islandoftex.arara.core.session.Session;
import org.islandoftex.arara.mvel.utils.MvelState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u00104\u001a\b\u0012\u0004\u0012\u0002050\"2\u0006\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u0002050\"H\u0002J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020:H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000e\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\b\u001a\u0004\b\u000f\u0010\u0006R\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\b\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\b\u001a\u0004\b\u0017\u0010\u0006R'\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\b\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001e\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\b\u001a\u0004\b\u001f\u0010\fR!\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\b\u001a\u0004\b#\u0010$R\u001b\u0010&\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\b\u001a\u0004\b'\u0010\u0006R\u001d\u0010)\u001a\u0004\u0018\u00010\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\b\u001a\u0004\b*\u0010\u0014R\u001b\u0010,\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\b\u001a\u0004\b-\u0010\u0006R\u001d\u0010/\u001a\u0004\u0018\u0001008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\b\u001a\u0004\b1\u00102\u00a8\u0006<"}, d2={"Lorg/islandoftex/arara/cli/CLI;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "()V", "dryRun", "", "getDryRun", "()Z", "dryRun$delegate", "Lkotlin/properties/ReadOnlyProperty;", "language", "", "getLanguage", "()Ljava/lang/String;", "language$delegate", "log", "getLog", "log$delegate", "maxLoops", "", "getMaxLoops", "()Ljava/lang/Integer;", "maxLoops$delegate", "onlyHeader", "getOnlyHeader", "onlyHeader$delegate", "parameters", "", "getParameters", "()Ljava/util/Map;", "parameters$delegate", "preamble", "getPreamble", "preamble$delegate", "reference", "", "getReference", "()Ljava/util/List;", "reference$delegate", "safeRun", "getSafeRun", "safeRun$delegate", "timeout", "getTimeout", "timeout$delegate", "verbose", "getVerbose", "verbose$delegate", "workingDirectory", "Ljava/nio/file/Path;", "getWorkingDirectory", "()Ljava/nio/file/Path;", "workingDirectory$delegate", "prependPreambleDirectives", "Lorg/islandoftex/arara/api/rules/Directive;", "fileType", "Lorg/islandoftex/arara/api/files/FileType;", "directives", "run", "", "updateConfigurationFromCommandLine", "cli"})
public final class CLI
extends CliktCommand {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty log$delegate;
    @NotNull
    private final ReadOnlyProperty verbose$delegate;
    @NotNull
    private final ReadOnlyProperty dryRun$delegate;
    @NotNull
    private final ReadOnlyProperty safeRun$delegate;
    @NotNull
    private final ReadOnlyProperty onlyHeader$delegate;
    @NotNull
    private final ReadOnlyProperty preamble$delegate;
    @NotNull
    private final ReadOnlyProperty timeout$delegate;
    @NotNull
    private final ReadOnlyProperty language$delegate;
    @NotNull
    private final ReadOnlyProperty maxLoops$delegate;
    @NotNull
    private final ReadOnlyProperty workingDirectory$delegate;
    @NotNull
    private final ReadOnlyProperty parameters$delegate;
    @NotNull
    private final ReadOnlyProperty reference$delegate;

    public CLI() {
        super("\n    " + StringsKt.replace$default(StringsKt.replace$default(DisplayUtils.INSTANCE.getLogoString(), '\n', '\u0085', false, 4, null), ' ', '\u00a0', false, 4, null) + "\n\n    The cool TeX automation tool.\n\n    arara executes the TeX workflow you tell it to execute. Simply specify\n    your needs within your TeX file and let arara do the work. These directives\n    feature conditional execution and parameter expansion.\n    ", null, "arara", false, true, null, null, false, false, 490, null);
        String[] stringArray = new String[]{"-l", "--log"};
        this.log$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.option$default(this, stringArray, "Generate a log output", null, false, null, null, null, null, 252, null), new String[0], false, null, 6, null).provideDelegate(this, $$delegatedProperties[0]);
        stringArray = new String[]{"-v", "--verbose"};
        OptionWithValues optionWithValues = OptionWithValuesKt.option$default(this, stringArray, "Print the command output", null, false, null, null, null, null, 252, null);
        stringArray = new String[]{"-s", "--silent"};
        this.verbose$delegate = FlagOptionKt.flag$default(optionWithValues, stringArray, false, null, 6, null).provideDelegate(this, $$delegatedProperties[1]);
        stringArray = new String[]{"-n", "--dry-run"};
        this.dryRun$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.option$default(this, stringArray, "Go through all the motions of running a command, but with no actual calls", null, false, null, null, null, null, 252, null), new String[0], false, null, 6, null).provideDelegate(this, $$delegatedProperties[2]);
        stringArray = new String[]{"-S", "--safe-run"};
        this.safeRun$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.option$default(this, stringArray, "Run in safe mode and disable potentially harmful features. Make sure your projects uses only allowed features.", null, false, null, null, null, null, 252, null), new String[0], false, null, 6, null).provideDelegate(this, $$delegatedProperties[3]);
        stringArray = new String[]{"-H", "--header"};
        this.onlyHeader$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.option$default(this, stringArray, "Extract directives only in the file header", null, false, null, null, null, null, 252, null), new String[0], false, null, 6, null).provideDelegate(this, $$delegatedProperties[4]);
        stringArray = new String[]{"-p", "--preamble"};
        this.preamble$delegate = OptionWithValuesKt.option$default(this, stringArray, "Set the file preamble based on the configuration file", null, false, null, null, null, null, 252, null).provideDelegate(this, $$delegatedProperties[5]);
        stringArray = new String[]{"-t", "--timeout"};
        this.timeout$delegate = RangeKt.restrictTo$default(IntKt.int(OptionWithValuesKt.option$default(this, stringArray, "Set the execution timeout (in milliseconds)", null, false, null, null, null, null, 252, null)), (Comparable)Integer.valueOf(1), null, false, 6, null).provideDelegate(this, $$delegatedProperties[6]);
        stringArray = new String[]{"-L", "--language"};
        this.language$delegate = OptionWithValuesKt.option$default(this, stringArray, "Set the application language", null, false, null, null, null, null, 252, null).provideDelegate(this, $$delegatedProperties[7]);
        stringArray = new String[]{"-m", "--max-loops"};
        this.maxLoops$delegate = RangeKt.restrictTo$default(IntKt.int(OptionWithValuesKt.option$default(this, stringArray, "Set the maximum number of loops (> 0)", null, false, null, null, null, null, 252, null)), (Comparable)Integer.valueOf(1), null, false, 6, null).provideDelegate(this, $$delegatedProperties[8]);
        stringArray = new String[]{"-d", "--working-directory"};
        this.workingDirectory$delegate = PathKt.path$default(OptionWithValuesKt.option$default(this, stringArray, "Set the working directory for all tools", null, false, null, null, null, null, 252, null), true, false, false, false, true, false, null, 108, null).provideDelegate(this, $$delegatedProperties[9]);
        stringArray = new String[]{"-P", "--call-property"};
        this.parameters$delegate = OptionWithValuesKt.associate$default(OptionWithValuesKt.option$default(this, stringArray, "Pass parameters to the application to be used within the session.", null, false, null, null, null, null, 252, null), null, 1, null).provideDelegate(this, $$delegatedProperties[10]);
        this.reference$delegate = ArgumentKt.multiple$default(ArgumentKt.argument$default(this, "file", "The file(s) to evaluate and process", null, null, 12, null), true, null, 2, null).provideDelegate(this, $$delegatedProperties[11]);
    }

    private final boolean getLog() {
        return (Boolean)this.log$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final boolean getVerbose() {
        return (Boolean)this.verbose$delegate.getValue(this, $$delegatedProperties[1]);
    }

    private final boolean getDryRun() {
        return (Boolean)this.dryRun$delegate.getValue(this, $$delegatedProperties[2]);
    }

    private final boolean getSafeRun() {
        return (Boolean)this.safeRun$delegate.getValue(this, $$delegatedProperties[3]);
    }

    private final boolean getOnlyHeader() {
        return (Boolean)this.onlyHeader$delegate.getValue(this, $$delegatedProperties[4]);
    }

    private final String getPreamble() {
        return (String)this.preamble$delegate.getValue(this, $$delegatedProperties[5]);
    }

    private final Integer getTimeout() {
        return (Integer)this.timeout$delegate.getValue(this, $$delegatedProperties[6]);
    }

    private final String getLanguage() {
        return (String)this.language$delegate.getValue(this, $$delegatedProperties[7]);
    }

    private final Integer getMaxLoops() {
        return (Integer)this.maxLoops$delegate.getValue(this, $$delegatedProperties[8]);
    }

    private final Path getWorkingDirectory() {
        return (Path)this.workingDirectory$delegate.getValue(this, $$delegatedProperties[9]);
    }

    private final Map<String, String> getParameters() {
        return (Map)this.parameters$delegate.getValue(this, $$delegatedProperties[10]);
    }

    private final List<String> getReference() {
        return (List)this.reference$delegate.getValue(this, $$delegatedProperties[11]);
    }

    private final void updateConfigurationFromCommandLine() {
        Duration duration;
        Locale locale;
        String string = this.getLanguage();
        if (string == null) {
            locale = null;
        } else {
            String it = string;
            boolean bl = false;
            locale = Locale.forLanguageTag(it);
        }
        Serializable serializable = locale;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        int n2 = 0;
        String string2 = Session.getUserInterfaceOptions().getSwingLookAndFeel();
        Locale locale2 = serializable == null ? Session.getUserInterfaceOptions().getLocale() : serializable;
        Session.setUserInterfaceOptions(new UserInterfaceOptions(locale2, string2, n2, n, defaultConstructorMarker));
        LanguageController.setLocale(Session.getUserInterfaceOptions().getLocale());
        LinearExecutor linearExecutor = LinearExecutor.INSTANCE;
        ExecutionOptions executionOptions = ExecutionOptions.Companion.from(LinearExecutor.INSTANCE.getExecutionOptions());
        serializable = this.getMaxLoops();
        int n3 = serializable == null ? LinearExecutor.INSTANCE.getExecutionOptions().getMaxLoops() : ((Integer)serializable).intValue();
        Integer n4 = this.getTimeout();
        if (n4 == null) {
            duration = null;
        } else {
            int it = ((Number)n4).intValue();
            int n5 = n3;
            ExecutionOptions executionOptions2 = executionOptions;
            LinearExecutor linearExecutor2 = linearExecutor;
            boolean bl = false;
            Duration duration2 = Duration.box-impl(Duration.Companion.milliseconds-UwyO8pc(it));
            linearExecutor = linearExecutor2;
            executionOptions = executionOptions2;
            n3 = n5;
            duration = duration2;
        }
        serializable = duration;
        linearExecutor.setExecutionOptions(ExecutionOptions.copy-k5Tw5DY$default(executionOptions, n3, serializable == null ? LinearExecutor.INSTANCE.getExecutionOptions().getTimeoutValue-UwyO8pc() : ((Duration)((Object)serializable)).unbox-impl(), false, false, null, this.getVerbose() ? true : LinearExecutor.INSTANCE.getExecutionOptions().getVerbose(), this.getDryRun() ? ExecutionMode.DRY_RUN : (this.getSafeRun() ? ExecutionMode.SAFE_RUN : LinearExecutor.INSTANCE.getExecutionOptions().getExecutionMode()), null, null, this.getOnlyHeader() ? true : LinearExecutor.INSTANCE.getExecutionOptions().getParseOnlyHeader(), 412, null));
        Session.setLoggingOptions(new LoggingOptions(this.getLog() ? true : Session.getLoggingOptions().getEnableLogging(), Session.getLoggingOptions().getAppendLog(), Session.getLoggingOptions().getLogFile()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Directive> prependPreambleDirectives(FileType fileType, List<? extends Directive> directives) {
        List<Directive> allDirectives;
        List<Directive> list;
        String resolvedPreamble;
        String string = this.getPreamble();
        if (string == null) {
            string = MvelState.INSTANCE.getDefaultPreamble();
        }
        if ((resolvedPreamble = string) != null && !MvelState.INSTANCE.getPreambles().containsKey(resolvedPreamble)) {
            String string2 = LanguageController.getMessages().getERROR_PARSER_INVALID_PREAMBLE();
            Object[] objectArray = new Object[]{resolvedPreamble};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(this, *args)");
            throw new AraraException(string3);
        }
        String string4 = resolvedPreamble;
        if (string4 == null) {
            list = directives;
        } else {
            String string5;
            List list2 = string4;
            String it = list2;
            boolean bl = false;
            String string6 = string5 = MvelState.INSTANCE.getPreambles().containsKey(it) ? list2 : null;
            if (string5 == null) {
                list = directives;
            } else {
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                String preambleName = string5;
                boolean bl2 = false;
                Iterable iterable = StringsKt.lines(MapsKt.getValue(MvelState.INSTANCE.getPreambles(), preambleName));
                boolean $i$f$filterNot = false;
                void var13_17 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    String it2 = (String)element$iv$iv;
                    boolean bl3 = false;
                    if (((CharSequence)it2).length() == 0) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = CollectionsKt.plus((Collection)Directives.extractDirectives((List)destination$iv$iv, true, fileType), (Iterable)directives);
                list = allDirectives = list2 == null ? directives : list2;
            }
        }
        if (allDirectives.isEmpty()) {
            throw new AraraException(LanguageController.getMessages().getERROR_VALIDATE_NO_DIRECTIVES_FOUND());
        }
        return allDirectives;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        LoggingUtils.INSTANCE.init();
        System.out.println((Object)Intrinsics.stringPlus(DisplayUtils.INSTANCE.getLogoString(), "\n"));
        TimeMark executionStart = TimeSource.Monotonic.INSTANCE.markNow();
        this.updateConfigurationFromCommandLine();
        LoggingUtils.INSTANCE.setupLogging(Session.getLoggingOptions());
        Path path2 = this.getWorkingDirectory();
        if (path2 == null) {
            path2 = Paths.get("", new String[0]);
        }
        Object object = path2;
        Intrinsics.checkNotNullExpressionValue(object, "workingDirectory ?: Paths.get(\"\")");
        Path workingDir = FileHandling.normalize((Path)object);
        Map<String, String> $this$forEach$iv = this.getParameters();
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$key$value = element$iv = object2.next();
            boolean bl = false;
            String key = $dstr$key$value.getKey();
            String value = $dstr$key$value.getValue();
            Session.INSTANCE.put(Intrinsics.stringPlus("arg:", key), value);
        }
        try {
            Collection<ProjectFile> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string;
            Path path3 = workingDir.getFileName();
            if (path3 == null) {
                string = "Untitled";
            } else {
                string = ((Object)path3).toString();
                if (string == null) {
                    string = "Untitled";
                }
            }
            Project project = new Project(string, workingDir, SetsKt.emptySet(), null, 8, null);
            Path path4 = ConfigurationUtils.INSTANCE.configFileForProject(project);
            if (path4 != null) {
                Path it = path4;
                boolean bl = false;
                DisplayUtils.INSTANCE.setConfigurationFileName(((Object)it).toString());
                ConfigurationUtils.INSTANCE.load(it, project);
            }
            object2 = this.getReference();
            Path path5 = null;
            String string2 = null;
            Project project2 = project;
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void fileName;
                String string3 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(FileSearching.resolveFile((String)fileName, workingDir, LinearExecutor.INSTANCE.getExecutionOptions()));
            }
            collection = (List)destination$iv$iv;
            List<Project> projects = CollectionsKt.listOf(Project.copy$default(project2, string2, path5, CollectionsKt.toSet((Iterable)collection), null, 11, null));
            LinearExecutor.INSTANCE.setHooks(new ExecutorHooks(run.3.INSTANCE, null, run.4.INSTANCE, null, new Function1<ProjectFile, Unit>(this){
                final /* synthetic */ CLI this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ProjectFile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    CLI.access$updateConfigurationFromCommandLine(this.this$0);
                    DisplayUtils.INSTANCE.printFileInformation(it);
                }
            }, run.6.INSTANCE, new Function2<ProjectFile, List<? extends Directive>, List<? extends Directive>>(this){
                final /* synthetic */ CLI this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @NotNull
                public final List<Directive> invoke(@NotNull ProjectFile file2, @NotNull List<? extends Directive> list) {
                    List<E> list2;
                    Intrinsics.checkNotNullParameter(file2, "file");
                    Intrinsics.checkNotNullParameter(list, "list");
                    List<E> list3 = list2 = list;
                    ProjectFile projectFile = file2;
                    DirectiveUtils directiveUtils = DirectiveUtils.INSTANCE;
                    boolean bl = false;
                    boolean bl2 = !((Collection)list).isEmpty() && !MvelState.INSTANCE.getPrependPreambleIfDirectivesGiven();
                    List<E> list4 = bl2 ? list2 : null;
                    return directiveUtils.process(projectFile, list4 == null ? CLI.access$prependPreambleDirectives(this.this$0, file2.getFileType(), list) : list4);
                }
            }, 10, null));
            object = LinearExecutor.INSTANCE.execute(projects).getExitCode() != 0 ? (ExecutionStatus)new ExecutionStatus.ExternalCallFailed() : (ExecutionStatus)new ExecutionStatus.Processing();
        }
        catch (AraraException ex) {
            DisplayUtils.INSTANCE.printException(ex);
            object = new ExecutionStatus.CaughtException();
        }
        Object executionStatus = object;
        boolean bl = false;
        DisplayUtils.INSTANCE.printTime(Duration.toDouble-impl(executionStart.elapsedNow-UwyO8pc(), DurationUnit.SECONDS));
        throw new ProgramResult(((ExecutionStatus)executionStatus).getExitCode());
    }

    public static final /* synthetic */ void access$updateConfigurationFromCommandLine(CLI $this) {
        $this.updateConfigurationFromCommandLine();
    }

    public static final /* synthetic */ List access$prependPreambleDirectives(CLI $this, FileType fileType, List directives) {
        return $this.prependPreambleDirectives(fileType, directives);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(CLI.class, "log", "getLog()Z", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "verbose", "getVerbose()Z", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "dryRun", "getDryRun()Z", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "safeRun", "getSafeRun()Z", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "onlyHeader", "getOnlyHeader()Z", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "preamble", "getPreamble()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "timeout", "getTimeout()Ljava/lang/Integer;", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "language", "getLanguage()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "maxLoops", "getMaxLoops()Ljava/lang/Integer;", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "workingDirectory", "getWorkingDirectory()Ljava/nio/file/Path;", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "parameters", "getParameters()Ljava/util/Map;", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "reference", "getReference()Ljava/util/List;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

