/* Generated By:JavaCC: Do not edit this line. Latex.java */
package com.latex2nemeth.parser;
import java.io.*;
import java.util.regex.*;
import java.util.Vector;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

import com.latex2nemeth.ast.*;
import com.latex2nemeth.utils.*;
import com.latex2nemeth.symbols.*;
import com.latex2nemeth.parser.aux.*;
import com.latex2nemeth.io.*;

public class Latex implements LatexConstants {

        class Command {
                String name;
                int numOfParams;
                String body;
                String[] params;
                Command(String name,String body){
                        this.name = name;
                        this.body = body;
                }
                Command(String name, int numOfParams, String body){
                        this(name,body);
                        this.numOfParams=numOfParams;
                        if (numOfParams > 0)
                                params = new String[numOfParams];
                }
        }

        class MathCommand {
                String name;
                int numOfParams;
                String body;
                Expression[] params;
                MathCommand(String name, String body){
                        this.name = name;
                        this.body = body;
                }
                MathCommand(String name, int numOfParams, String body){
                        this(name,body);
                        this.numOfParams=numOfParams;
                        if (numOfParams > 0)
                                params = new Expression[numOfParams];
                }
        }

        Command currentMacro;
        MathCommand currentMathMacro;

        static final int MAX_WIDTH = 28;
        static int COLUMN = 0;
        static StringBuffer WORD = new StringBuffer();
        NemethTable table;
        HashMap<String, Command > commandTable = new HashMap<String, Command >();
        HashMap<String, MathCommand > commandMathTable = new HashMap<String, MathCommand >();
        static HashMap<String, Theorem> theorems = new HashMap<String,Theorem >();
        static Writer output;
        static String outputFileName;
        int enumeratedepth = 0;
        private static LabelTable labeltable;
        int lineNumber=0;
        static ParsedChapters parsedChapters;

        static int chapter = 0;
        static int section = 0;
        static int subsection = 0;
        private int picture = 0;
        private Preamble preamble;

        private int tabularcolumn = 0;
        private boolean verbose;

        private void printMessage(String msg) {
          if (verbose) {
            System.out.println(msg);
          }
        }


    private String getLetterCode(String symbol) {
        String code = table.getLetterCode(symbol);
        if (code == null) {
            printMessage("UNKNOWN TEXT SYMBOL: " + symbol + " at line: " + jj_input_stream.getEndLine());
            return "";
        }
        return code;
    }

    private String getTheoremCode(String symbol) {
        String code = table.getTheoremCode(symbol);
        if (code == null) {
            printMessage("UNKNOWN THEOREM SYMBOL: " + symbol + " at line: " + jj_input_stream.getEndLine());
            return "";
        }
        return code;
    }

    private String getMathCode(String symbol) {
        String code = table.getMathCode(symbol);
        if (code == null) {
            printMessage("UNKNOWN MATH SYMBOL: " + symbol + " at line: " + jj_input_stream.getEndLine());
            return "";
        }
        return code;
    }

    String string2Braille(String str) {
        StringBuffer buffer = new StringBuffer();

        for (int pos = 0; pos < str.length(); pos++) {
            String c = Character.toString(str.charAt(pos));
            buffer.append(getLetterCode(c));
        }

        return buffer.toString();
    }

    String string2BrailleTheorem(String str) {
        StringBuffer buffer = new StringBuffer();

        for (int pos = 0; pos < str.length(); pos++) {
            String c = Character.toString(str.charAt(pos));
            buffer.append(getTheoremCode(c));
        }

        return buffer.toString();
    }

    static String italic(String s) {
        return "\u2820\u2804\u2838" + s + "\u2838\u2820\u2804";
    }

    String bold(String s) {
        return getLetterCode("\u005c\u005ctextbf-open") + s + getLetterCode("\u005c\u005ctextbf-close");
    }

    static String sansserif(String s) {
        return s;
    }

    static String scriptenglish(String s) {
        return s;
    }

    static boolean checkforPreviousSpace(Token t) {
        boolean space = t.specialToken != null;
        return space;
    }

    public Latex(NemethTable table, InputStreamReader inputStreamReader, Preamble preamble, boolean verbose) {
        this(inputStreamReader);
        this.table = table;
        this.preamble = preamble;
        this.verbose = verbose;
    }


    public Latex(NemethTable table, InputStreamReader inputStreamReader,
        Command cmd, HashMap<String, Command> commandTable, boolean verbose)
    {
        this(inputStreamReader);
        this.table = table;
        this.currentMacro = cmd;
        this.commandTable = commandTable;
        this.verbose = verbose;
   }


  public Latex(NemethTable table, InputStreamReader inputStreamReader, MathCommand cmd, HashMap<String, MathCommand> mathCommandTable, boolean verbose)
    {
        this(inputStreamReader);
        this.table = table;
        this.currentMathMacro = cmd;
        this.commandMathTable = mathCommandTable;
        this.verbose = verbose;
   }


    public static ParsedChapters parse(String texFile, String auxFile, NemethTable table, Preamble preamble, boolean verbose) throws ParseException, TokenMgrError, IOException {

        parsedChapters = new ParsedChapters();

        FileInputStream fileInputStream = new FileInputStream(texFile);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, "UTF-8");
        System.out.println("Parsing file: " + texFile);

        labeltable = new LabelTable();
        labeltable.createlabels(auxFile);

        output = new StringWriter();

        WORD = new StringBuffer();
        Latex parser = new Latex(table, inputStreamReader, preamble, verbose);

        parser.latex();

        inputStreamReader.close();
        fileInputStream.close();

        output.flush(); //??
        output.close();
        parsedChapters.put(chapter, output.toString());
        return parsedChapters;
    }

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////// SYNTACTICAL //////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public Token mathDelimiter() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MATHTEXTSEPARATOR:
      t = jj_consume_token(MATHTEXTSEPARATOR);
      break;
    case MATHSEPARATOR:
      t = jj_consume_token(MATHSEPARATOR);
      break;
    case LBRA:
      t = jj_consume_token(LBRA);
      break;
    case RBRA:
      t = jj_consume_token(RBRA);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                                                                {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

// It sucks but it works...
  final public Token mathDelimiter_no_brackets() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MATHTEXTSEPARATOR:
      t = jj_consume_token(MATHTEXTSEPARATOR);
      break;
    case MATHSEPARATOR:
      t = jj_consume_token(MATHSEPARATOR);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                                      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token myDigit() throws ParseException {
        Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
      t = jj_consume_token(DIGIT0);
      break;
    case DIGIT1:
      t = jj_consume_token(DIGIT1);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                    {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token latincharacter() throws ParseException {
    Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENGLISHLETTER:
      t = jj_consume_token(ENGLISHLETTER);
      break;
    case TEXTSYMBOL:
      t = jj_consume_token(TEXTSYMBOL);
      break;
    case MATHTEXTSEPARATOR:
      t = jj_consume_token(MATHTEXTSEPARATOR);
      break;
    case DIGIT0:
    case DIGIT1:
      t = myDigit();
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public String brackets() throws ParseException {
    Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      t = jj_consume_token(LBRA);
      break;
    case RBRA:
      t = jj_consume_token(RBRA);
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                {if (true) return getLetterCode(t.image);}
    throw new Error("Missing return statement in function");
  }

  final public String character() throws ParseException {
        Token t = null;
        String s;
        boolean space;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANY:
      t = jj_consume_token(ANY);
      break;
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case MATHTEXTSEPARATOR:
      t = latincharacter();
      break;
    case GREEKLETTER:
      t = jj_consume_token(GREEKLETTER);
      break;
    case DIPHTHONG:
      t = jj_consume_token(DIPHTHONG);
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        String key = t.image;
        String code = getLetterCode(key);
        space = checkforPreviousSpace(t);
        // System.out.print(key);
        if (t.kind == DIGIT0) {
            code = getMathCode("#") + code;
        }
        if (space) {
            {if (true) return " " + code;}
        }
        {if (true) return code;}
    throw new Error("Missing return statement in function");
  }

  final public String character_no_braille() throws ParseException {
        Token t = null;
        String s;
        boolean space;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case MATHTEXTSEPARATOR:
      t = latincharacter();
      break;
    case GREEKLETTER:
      t = jj_consume_token(GREEKLETTER);
      break;
    case DIPHTHONG:
      t = jj_consume_token(DIPHTHONG);
      break;
    case SUB:
      t = jj_consume_token(SUB);
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        String key = t.image;
        space = checkforPreviousSpace(t);
        // System.out.print(key);
            if (space) {
                {if (true) return " " + key;}
        }
            {if (true) return key;}
    throw new Error("Missing return statement in function");
  }

  final public String bracketcontent() throws ParseException {
    Token t;
    String s = "", result;
    boolean space = false;
    t = jj_consume_token(LCB);
                space = checkforPreviousSpace(t);
    /*[LOOKAHEAD(1) <COMMAND>]*/
        // s = basic()
            s = content();
    jj_consume_token(RCB);
        if (space) {
            result = " " + s;
        } else {
            result = s;
        }
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public String textlatin() throws ParseException {
        Token t;
        String s = "", result;
        boolean space = false;
    t = jj_consume_token(TEXTLATIN);
                          space = checkforPreviousSpace(t);
    s = command_parameter();
            String en = getLetterCode("EN");
            s = s.replaceAll("^", en);
            s = s.replaceAll(" ", " " + en);
        // insert an english text symbol in the beginning and after every space...
        if (space) {
            result = " " + s;
        } else {
            result = s;
        }
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public String param() throws ParseException {
        Token t;
        int nParam;
    t = jj_consume_token(PARAM);
                nParam = Integer.parseInt(t.image.substring(1));
                String parameter = this.currentMacro.params[nParam-1];
                {if (true) return parameter;}
    throw new Error("Missing return statement in function");
  }

// This sucks! Every command actually MUST know its number of parameters.
  final public String textcommand() throws ParseException {
        Token t;
        String s = "", result;
        boolean space = false;
        Command cmd;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMAND:
      t = jj_consume_token(COMMAND);
                            space = checkforPreviousSpace(t);
                        cmd = commandTable.get(t.image); // TODO: Is this right;	
                        if (cmd != null) {
                                InputStream targetStream=null;
                                try{
                                        targetStream = new ByteArrayInputStream(cmd.body.getBytes("ISO-8859-7"));
                                }catch(Exception e){e.printStackTrace();}


                                for (int i=0; i< cmd.numOfParams;i++){
                                        cmd.params[i] = command_parameter();// This is the real	
                                }
                                Latex lparser = new Latex(table, new InputStreamReader(targetStream), cmd, commandTable, verbose);

                                s = lparser.content();

                //		String body = cmd.body;

                        }
                else {// Not a defined command. Check if it is just in the list of symbols. 
                                s = getLetterCode(t.image);
                        }
      break;
    case TEXTLATIN:
      s = textlatin();
      break;
    case INDEX:
      s = index();
      break;
    case LABEL:
      s = label();
      break;
    case REF:
      s = ref();
      break;
    case ACCENT:
      s = accent();
      break;
    case GRAVEACCENT:
      s = grave();
      break;
    case CHAPTER:
      s = chapter();
      break;
    case SECTION:
      s = section();
      break;
    case SUBSECTION:
      s = subsection();
      break;
    case TEXTBF:
      s = textbf();
      break;
    case TEXTIT:
    case EMPH:
      s = textit();
      break;
    case LTNALLCAPS:
      s = latextonemethallcaps();
      break;
    case VERB:
      s = verb();
      break;
    case INPUT:
    case INCLUDE:
      input();
      break;
    case NEWCOMMAND:
      newcommand();
      break;
    case TEXTCIRCLED:
      textcircled();
      break;
    case PARAM:
      s = param();
      break;
    case HUGE:
    case TEXTSC:
      ignore();
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (space) {
            result = " " + s;
        } else {
            result = s;
        }
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public void newcommand() throws ParseException {
    String newcommand, definition;
    Token commandToken;
        Token nParamToken=null;
        StringBuffer def = new StringBuffer();
        char c;
        int n=1;
        int nParams=0;
        Command cmd;
        MathCommand mcmd;
        String strNum;
    jj_consume_token(NEWCOMMAND);
    jj_consume_token(LCB);
    commandToken = jj_consume_token(COMMAND);
    jj_consume_token(RCB);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      nParamToken = myDigit();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    jj_consume_token(LCB);
                                                                                                                   // SOS: (Optional) parameters
                while(true){
                        try {c = jj_input_stream.readChar(); }
                        catch(java.io.IOException ioe)
                        {System.out.println("End of file while reading verb...");{if (true) return;}}
                        if (n==1 && c == '}') break;
                        else if (c=='}') n--;
                        else if (c=='{') n++;
                        def.append(c);
                }

                if (nParamToken!=null){
                        strNum = nParamToken.image;
                        nParams= Integer.parseInt(strNum);
                }
                definition=def.toString();
                if (nParams==0){
                        cmd = new Command(commandToken.image,definition);
                        mcmd = new MathCommand(commandToken.image,definition);

                }
                else {
                        cmd = new Command(commandToken.image,nParams,definition);
                        mcmd = new MathCommand(commandToken.image,nParams,definition);
                }
                commandTable.put(commandToken.image, cmd);
                commandMathTable.put(commandToken.image,mcmd); //SOS: This is wrong... We put the commands in both tables

  }

  final public void newtheorem() throws ParseException {
        StringBuffer name = new StringBuffer(),
                    label = new StringBuffer(),
                    opts = new StringBuffer(),
                    counterLabel = new StringBuffer();
        Token t;
        Theorem theorem = null, counterTheorem = null;
    jj_consume_token(NEWTHEOREM);
    jj_consume_token(LCB);
    label_1:
    while (true) {
      t = latincharacter();
                                                name.append(t.image);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case MATHTEXTSEPARATOR:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_1;
      }
    }
    jj_consume_token(RCB);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LCB:
      jj_consume_token(LCB);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case GREEKLETTER:
        case DIPHTHONG:
          ;
          break;
        default:
          jj_la1[10] = jj_gen;
          break label_2;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ENGLISHLETTER:
          t = jj_consume_token(ENGLISHLETTER);
          break;
        case GREEKLETTER:
          t = jj_consume_token(GREEKLETTER);
          break;
        case DIPHTHONG:
          t = jj_consume_token(DIPHTHONG);
          break;
        case DIGIT0:
        case DIGIT1:
          t = myDigit();
          break;
        default:
          jj_la1[11] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                     label.append(t.image);
      }
      jj_consume_token(RCB);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRA:
        jj_consume_token(LBRA);
        label_3:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ENGLISHLETTER:
            jj_consume_token(ENGLISHLETTER);
            break;
          case DIGIT0:
          case DIGIT1:
            myDigit();
            break;
          default:
            jj_la1[12] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DIGIT0:
          case DIGIT1:
          case ENGLISHLETTER:
            ;
            break;
          default:
            jj_la1[13] = jj_gen;
            break label_3;
          }
        }
        jj_consume_token(RBRA);
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
                theorem = new Theorem(name.toString(), label.toString());
      break;
    case LBRA:
      jj_consume_token(LBRA);
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ENGLISHLETTER:
          t = jj_consume_token(ENGLISHLETTER);
          break;
        case DIGIT0:
        case DIGIT1:
          t = myDigit();
          break;
        default:
          jj_la1[15] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                                        counterLabel.append(t.image);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
          ;
          break;
        default:
          jj_la1[16] = jj_gen;
          break label_4;
        }
      }
      jj_consume_token(RBRA);
      jj_consume_token(LCB);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ENGLISHLETTER:
          t = jj_consume_token(ENGLISHLETTER);
          break;
        case GREEKLETTER:
          t = jj_consume_token(GREEKLETTER);
          break;
        case DIPHTHONG:
          t = jj_consume_token(DIPHTHONG);
          break;
        case DIGIT0:
        case DIGIT1:
          t = myDigit();
          break;
        default:
          jj_la1[17] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                      label.append(t.image);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case GREEKLETTER:
        case DIPHTHONG:
          ;
          break;
        default:
          jj_la1[18] = jj_gen;
          break label_5;
        }
      }
      jj_consume_token(RCB);
              counterTheorem = theorems.get(counterLabel.toString());
              theorem = new Theorem(name.toString(), label.toString(), counterTheorem);
      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        // System.out.println("Registering theorem '" + name.toString() +"' " + label.toString());
                theorems.put(name.toString(),theorem);
  }

  final public String theoremenvironment() throws ParseException {
        String content = "";
        Token nameToken;
        Theorem theorem = null;
        String option = "", label = "";
    jj_consume_token(BEG);
    nameToken = jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      option = option();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label = label();
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
                theorem = theorems.get(nameToken.image);
            if (theorem == null) {
                System.out.println("Error in line " + jj_input_stream.getEndLine());
                System.out.println("Environment '" + nameToken.image + "' " + " not defined");
                // throw new ParseException();
            }
    content = content();
    jj_consume_token(END);
    jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
            String lpar = getLetterCode("(");
            String rpar = getLetterCode(")");
                String optionallabel = "";
                if (!option.equals("")) {
                        optionallabel = lpar  + option + rpar;
            }
        String theoremlabel = "";
        if (theorem != null) {
            theoremlabel = string2Braille(theorem.getLabel());

            if (label.equals("")) {
                StringBuffer theoremNumber = new StringBuffer();
                theoremNumber.append(getLetterCode("#"));

                if (chapter !=0) {
                    theoremNumber.append(string2Braille(Integer.toString(chapter)));
                    theoremNumber.append(getTheoremCode("."));
                }

                theoremNumber.append(string2BrailleTheorem(Integer.toString(section)));
                theoremNumber.append(getTheoremCode("."));
                theoremNumber.append(string2BrailleTheorem(Integer.toString(theorem.getNextCounter())));
                label = theoremNumber.toString();
            }
        }
        {if (true) return /*"   " + */ theoremlabel  + optionallabel + " " + label + " " + content;}
    throw new Error("Missing return statement in function");
  }

  final public String command_parameter() throws ParseException {
        String s = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();
      break;
    case LCB:
      s = bracketcontent();
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String optioncontent() throws ParseException {
        String s = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();
      break;
    case INLINEMATH:
      s = inlinemath();
      break;
    case PARAM:
    case ACCENT:
    case GRAVEACCENT:
    case LABEL:
    case REF:
    case INDEX:
    case TEXTBF:
    case TEXTIT:
    case EMPH:
    case TEXTCIRCLED:
    case INPUT:
    case INCLUDE:
    case NEWCOMMAND:
    case HUGE:
    case TEXTLATIN:
    case CHAPTER:
    case SECTION:
    case SUBSECTION:
    case VERB:
    case LTNALLCAPS:
    case TEXTSC:
    case COMMAND:
      s = textcommand();
      break;
    case LCB:
      s = bracketcontent();
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String option() throws ParseException {
        StringBuffer result = new StringBuffer();
        String s;
    s = optioncontent();
                              result.append(s);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case COMMAND:
      case ANY:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_6;
      }
      s = optioncontent();
                                            result.append(s);
    }
          {if (true) return result.toString();}
    throw new Error("Missing return statement in function");
  }

//Here, content means character or other basic staff.
  final public String basiccontent() throws ParseException {
        String s = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case PARAM:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case ACCENT:
    case GRAVEACCENT:
    case INLINEMATH:
    case LABEL:
    case REF:
    case INDEX:
    case TEXTBF:
    case TEXTIT:
    case EMPH:
    case TEXTCIRCLED:
    case INPUT:
    case INCLUDE:
    case NEWCOMMAND:
    case HUGE:
    case TEXTLATIN:
    case CHAPTER:
    case SECTION:
    case SUBSECTION:
    case VERB:
    case LTNALLCAPS:
    case TEXTSC:
    case MATHTEXTSEPARATOR:
    case LCB:
    case COMMAND:
    case ANY:
      s = optioncontent();
      break;
    case LBRA:
    case RBRA:
      s = brackets();
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String basic() throws ParseException {
        StringBuffer result = new StringBuffer();
        String s;
    s = basiccontent();
                             result.append(s);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case LBRA:
      case RBRA:
      case COMMAND:
      case ANY:
        ;
        break;
      default:
        jj_la1[26] = jj_gen;
        break label_7;
      }
      s = basiccontent();
                                           result.append(s);
    }
          {if (true) return result.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String content() throws ParseException {
    String s = null;
    StringBuffer buffer = new StringBuffer();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TWONEWLINES:
      case BEG:
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case HUGE:
      case MATHBEGIN:
      case MATHBEND:
      case BEGINQUOTE:
      case BEGINENUMERATE:
      case BEGINITEMIZE:
      case BEGINDESCRIPTION:
      case BEGINFIGURE:
      case BEGINCENTER:
      case BEGINVERBATIM:
      case BEGINTABULAR:
      case BEGINTABBING:
      case BEGINPROOF:
      case BEGINPSPICTURE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case LBRA:
      case RBRA:
      case NEWLINE:
      case COMMAND:
      case ANY:
      case 131:
      case 132:
      case 133:
      case 134:
        ;
        break;
      default:
        jj_la1[27] = jj_gen;
        break label_8;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case LBRA:
      case RBRA:
      case COMMAND:
      case ANY:
        s = basic();
                      buffer.append(s);
        break;
      case BEG:
      case MATHBEGIN:
      case MATHBEND:
      case BEGINQUOTE:
      case BEGINENUMERATE:
      case BEGINITEMIZE:
      case BEGINDESCRIPTION:
      case BEGINFIGURE:
      case BEGINCENTER:
      case BEGINVERBATIM:
      case BEGINTABULAR:
      case BEGINTABBING:
      case BEGINPROOF:
      case BEGINPSPICTURE:
      case 131:
      case 132:
      case 133:
      case 134:
        s = environment();
                              buffer.append(s);
        break;
      case TWONEWLINES:
      case NEWLINE:
        s = newline();
                          buffer.append(s);
        break;
      default:
        jj_la1[28] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

//Same as the above but with output.
  final public void topcontent() throws ParseException {
        String content = "";
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TWONEWLINES:
      case BEG:
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case HUGE:
      case MATHBEGIN:
      case MATHBEND:
      case BEGINQUOTE:
      case BEGINENUMERATE:
      case BEGINITEMIZE:
      case BEGINDESCRIPTION:
      case BEGINFIGURE:
      case BEGINCENTER:
      case BEGINVERBATIM:
      case BEGINTABULAR:
      case BEGINTABBING:
      case BEGINPROOF:
      case BEGINPSPICTURE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case LBRA:
      case RBRA:
      case NEWLINE:
      case COMMAND:
      case ANY:
      case 131:
      case 132:
      case 133:
      case 134:
        ;
        break;
      default:
        jj_la1[29] = jj_gen;
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case LBRA:
      case RBRA:
      case COMMAND:
      case ANY:
        content = basic();
                try {
                    output.append(content);
                } catch (Exception e) {
                        e.printStackTrace();
                }
        break;
      case BEG:
      case MATHBEGIN:
      case MATHBEND:
      case BEGINQUOTE:
      case BEGINENUMERATE:
      case BEGINITEMIZE:
      case BEGINDESCRIPTION:
      case BEGINFIGURE:
      case BEGINCENTER:
      case BEGINVERBATIM:
      case BEGINTABULAR:
      case BEGINTABBING:
      case BEGINPROOF:
      case BEGINPSPICTURE:
      case 131:
      case 132:
      case 133:
      case 134:
        content = environment();
                try {
                    output.append(content);
                } catch (Exception e) {
                        e.printStackTrace();
                }
        break;
      case TWONEWLINES:
      case NEWLINE:
        content = newline();
                try {
                    output.append(content);
                } catch (Exception e) {
                        e.printStackTrace();
                }
        break;
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public String newline() throws ParseException {
    String s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TWONEWLINES:
      jj_consume_token(TWONEWLINES);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TWONEWLINES:
          ;
          break;
        default:
          jj_la1[31] = jj_gen;
          break label_10;
        }
        jj_consume_token(TWONEWLINES);
      }
      break;
    case NEWLINE:
      jj_consume_token(NEWLINE);
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        // System.out.print("\\n");
            {if (true) return "   ";} // Instead of return "\\n   ";

    throw new Error("Missing return statement in function");
  }

  final public void preamble() throws ParseException {
    jj_consume_token(DOCUMENTCLASS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
          ;
          break;
        default:
          jj_la1[33] = jj_gen;
          break label_11;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ENGLISHLETTER:
          jj_consume_token(ENGLISHLETTER);
          break;
        case TEXTSYMBOL:
          jj_consume_token(TEXTSYMBOL);
          break;
        case DIGIT0:
        case DIGIT1:
          myDigit();
          break;
        default:
          jj_la1[34] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    jj_consume_token(LCB);
    label_12:
    while (true) {
      latincharacter();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case MATHTEXTSEPARATOR:
        ;
        break;
      default:
        jj_la1[36] = jj_gen;
        break label_12;
      }
    }
    jj_consume_token(RCB);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TWONEWLINES:
      case PARAM:
      case ACCENT:
      case GRAVEACCENT:
      case USEPACKAGE:
      case NEWTHEOREM:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case COMMAND:
        ;
        break;
      default:
        jj_la1[37] = jj_gen;
        break label_13;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USEPACKAGE:
        jj_consume_token(USEPACKAGE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRA:
          jj_consume_token(LBRA);
          label_14:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case DIGIT0:
            case DIGIT1:
            case ENGLISHLETTER:
            case TEXTSYMBOL:
              ;
              break;
            default:
              jj_la1[38] = jj_gen;
              break label_14;
            }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ENGLISHLETTER:
              jj_consume_token(ENGLISHLETTER);
              break;
            case TEXTSYMBOL:
              jj_consume_token(TEXTSYMBOL);
              break;
            case DIGIT0:
            case DIGIT1:
              myDigit();
              break;
            default:
              jj_la1[39] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          jj_consume_token(RBRA);
          break;
        default:
          jj_la1[40] = jj_gen;
          ;
        }
        jj_consume_token(LCB);
        label_15:
        while (true) {
          latincharacter();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DIGIT0:
          case DIGIT1:
          case ENGLISHLETTER:
          case TEXTSYMBOL:
          case MATHTEXTSEPARATOR:
            ;
            break;
          default:
            jj_la1[41] = jj_gen;
            break label_15;
          }
        }
        jj_consume_token(RCB);
        break;
      case NEWTHEOREM:
        newtheorem();
        break;
      case TWONEWLINES:
        jj_consume_token(TWONEWLINES);
        break;
      case PARAM:
      case ACCENT:
      case GRAVEACCENT:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case COMMAND:
        textcommand();
        break;
      default:
        jj_la1[42] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

// I don't think it is useful. Just consume this.
  final public void latex() throws ParseException {
    preamble();
    jj_consume_token(BEGINDOCUMENT);
    topcontent();
    jj_consume_token(ENDDOCUMENT);
  }

  final public String environment() throws ParseException {
    String result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEGINENUMERATE:
      result = enumerate();
      break;
    case BEGINITEMIZE:
      result = itemize();
      break;
    case BEGINDESCRIPTION:
      result = description();
      break;
    case MATHBEGIN:
    case MATHBEND:
    case 131:
    case 132:
    case 133:
    case 134:
      result = mathenvironment();
      break;
    case BEGINFIGURE:
      result = figure();
      break;
    case BEGINCENTER:
      result = center();
      break;
    case BEGINQUOTE:
      result = quote();
      break;
    case BEG:
      result = theoremenvironment();
      break;
    case BEGINPROOF:
      result = proof();
      break;
    case BEGINPSPICTURE:
      result = pspicture();
      break;
    case BEGINVERBATIM:
      result = verbatim();
      break;
    case BEGINTABULAR:
      result = tabular();
      break;
    case BEGINTABBING:
      result = tabbing();
      break;
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public String proof() throws ParseException {
    String content = "", optional = "", theorem = "";
    jj_consume_token(BEGINPROOF);
    // By convention, label is the first command!! It should be optional!!
        content = content();
    jj_consume_token(ENDPROOF);
        String q = getLetterCode("\u005c\u005ctextit-open") + string2Braille("\u0391\u03c0\u03bf\u03b4\u03b5\u03b9\u03be\u03b7") + getLetterCode("\u005c\u005ctextit-close");
            {if (true) return q + content + getMathCode("\u005c\u005cBox") + " ";}
    throw new Error("Missing return statement in function");
  }

  final public String pspicture() throws ParseException {
    Token t;
    String s = "";
    StringBuilder buf = new StringBuilder("");
    jj_consume_token(BEGINPSPICTURE);
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TWONEWLINES:
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case SUP:
      case SUB:
      case LCB:
      case RCB:
      case LBRA:
      case RBRA:
      case NEWLINE:
      case COMMAND:
        label_17:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DIGIT0:
          case DIGIT1:
          case ENGLISHLETTER:
          case TEXTSYMBOL:
          case GREEKLETTER:
          case DIPHTHONG:
          case MATHSYMBOL:
          case MATHTEXTSEPARATOR:
          case MATHSEPARATOR:
          case LBRA:
          case RBRA:
            t = mathcharacter();
                                  buf.append(t.image);
            break;
          case COMMAND:
            t = jj_consume_token(COMMAND);
                                  buf.append(t.image);
            break;
          case LCB:
            t = jj_consume_token(LCB);
                                  buf.append(t.image);
            break;
          case RCB:
            t = jj_consume_token(RCB);
                                  buf.append(t.image);
            break;
          case SUP:
            t = jj_consume_token(SUP);
                                  buf.append(t.image);
            break;
          case SUB:
            t = jj_consume_token(SUB);
                                  buf.append(t.image);
            break;
          case NEWLINE:
            t = jj_consume_token(NEWLINE);
                                  buf.append("\u005c\u005cn");
            break;
          case TWONEWLINES:
            t = jj_consume_token(TWONEWLINES);
                                  buf.append("\u005c\u005cn\u005c\u005cn");
            break;
          default:
            jj_la1[44] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TWONEWLINES:
          case DIGIT0:
          case DIGIT1:
          case ENGLISHLETTER:
          case TEXTSYMBOL:
          case GREEKLETTER:
          case DIPHTHONG:
          case MATHSYMBOL:
          case MATHTEXTSEPARATOR:
          case MATHSEPARATOR:
          case SUP:
          case SUB:
          case LCB:
          case RCB:
          case LBRA:
          case RBRA:
          case NEWLINE:
          case COMMAND:
            ;
            break;
          default:
            jj_la1[45] = jj_gen;
            break label_17;
          }
        }
        break;
      case INLINEMATH:
        s = inlinemath();
                             buf.append(s);
        break;
      default:
        jj_la1[46] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TWONEWLINES:
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case INLINEMATH:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case SUP:
      case SUB:
      case LCB:
      case RCB:
      case LBRA:
      case RBRA:
      case NEWLINE:
      case COMMAND:
        ;
        break;
      default:
        jj_la1[47] = jj_gen;
        break label_16;
      }
    }
         s = buf.toString();
    jj_consume_token(ENDPSPICTURE);
            String result = "\u005c\u005cbegin{pspicture}" + s + "\u005c\u005cend{pspicture}";
            picture++;
            DataDumper.writePicture(picture, preamble.getStart() + result + preamble.getEnd());
            {if (true) return "";}
    throw new Error("Missing return statement in function");
  }

  final public String quote() throws ParseException {
    String content = "", optional = "", theorem = "";
    jj_consume_token(BEGINQUOTE);
    /*[LOOKAHEAD(1) <LBRA>  optional = option() <RBRA>] */
        // By convention, label is the first command!! It should be optional!!
        content = content();
    jj_consume_token(ENDQUOTE);
        String q = getLetterCode("'");
        {if (true) return q + content + q;}
    throw new Error("Missing return statement in function");
  }

  final public String figure() throws ParseException {
    String label = null, caption = null, s="";
    jj_consume_token(BEGINFIGURE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      option();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CAPTION:
      caption = caption();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LABEL:
        label = label();
        break;
      default:
        jj_la1[49] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[50] = jj_gen;
      ;
    }
                if (null == label) {
                        System.out.println("CAPTION WITHOUT LABEL AT LINE " + jj_input_stream.getEndLine());
                }
                else {
                s = "\u005cn" + string2Braille("\u03a3\u03c7\u03ae\u03bc\u03b1 ") + label + string2Braille(":") + " " + caption +"\u005cn";
                }
    jj_consume_token(ENDFIGURE);
          {if (true) return  s;}
    throw new Error("Missing return statement in function");
  }

  final public String caption() throws ParseException {
        String caption;
    jj_consume_token(CAPTION);
    caption = command_parameter();
          {if (true) return caption;}
    throw new Error("Missing return statement in function");
  }

  final public String center() throws ParseException {
    String content = "", theorem = "";
    jj_consume_token(BEGINCENTER);
    // By convention, label is the first command!! It should be optional!!
        content = content();
    jj_consume_token(ENDCENTER);
      {if (true) return content;}
    throw new Error("Missing return statement in function");
  }

  final public String item() throws ParseException {
    String option = "";
    StringBuffer buffer = new StringBuffer();
    jj_consume_token(ITEM);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      option = option();
      jj_consume_token(RBRA);
                                                    buffer.append(option);
      break;
    default:
      jj_la1[51] = jj_gen;
      ;
    }
      {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String enumerate() throws ParseException {
    int counter = 1;
    StringBuffer buffer = new StringBuffer();
    String itemString, contentString;
    jj_consume_token(BEGINENUMERATE);
                       enumeratedepth++;
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ITEM:
        ;
        break;
      default:
        jj_la1[52] = jj_gen;
        break label_18;
      }
      itemString = item();
                    buffer.append("\u005cn");
                if (itemString.equals("")) {
                        if (enumeratedepth == 2) {
                                buffer.append(string2Braille(IntegerConversion.integerToGreek(counter++)));
                    buffer.append(getLetterCode("."));
                } else if (enumeratedepth == 3) {
                            buffer.append(string2Braille(IntegerConversion.integerToRomanNumeral(counter++)));
                                buffer.append(getLetterCode("."));
                        } else { // enumeratedepth = 1 or 4, 5, 6, ...
                                buffer.append(getLetterCode("#"));
                                buffer.append(string2Braille(Integer.toString(counter++)));
                                buffer.append(getLetterCode("."));
                        }
                } else {
                        buffer.append(itemString );
                }
                    buffer.append(getLetterCode(" "));
      contentString = content();
                    buffer.append(contentString);
                // System.out.print("\\n");

    }
    jj_consume_token(ENDENUMERATE);
                          enumeratedepth--;
          {if (true) return buffer.toString()+ "\u005cn   ";}
    throw new Error("Missing return statement in function");
  }

  final public String itemize() throws ParseException {
    StringBuffer buffer = new StringBuffer();
    String itemString, contentString;
    jj_consume_token(BEGINITEMIZE);
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ITEM:
        ;
        break;
      default:
        jj_la1[53] = jj_gen;
        break label_19;
      }
      itemString = item();
            buffer.append("\u005cn");
            if (itemString.equals("")) {
                buffer.append(getMathCode("\u005c\u005cbullet"));
            }
                buffer.append(itemString );
      contentString = content();
            buffer.append(contentString);
            // System.out.print("\\n");

    }
    jj_consume_token(ENDITEMIZE);
      {if (true) return buffer.toString() + "\u005cn   ";}
    throw new Error("Missing return statement in function");
  }

  final public String verb() throws ParseException {
        StringBuffer buf = new StringBuffer();
        char ch, beg;
        boolean isNumber = false;
    jj_consume_token(VERB);
                try {beg = jj_input_stream.readChar();}
                catch(java.io.IOException ioe)
                    {System.out.println("End of file while reading verb..."); {if (true) return "";}}

                if (beg!='|' && beg!='+') {
                        System.out.println("Parse Error in verb:");

                        {if (true) return "";}
                }

                try {ch = jj_input_stream.readChar();}
                                catch(java.io.IOException ioe)
                                {System.out.println("End of file while reading verb..."); {if (true) return "";}}
                buf.append(" ");
                while (ch !=beg) {

                        String op = null;

                        if (Character.isDigit(ch) && !isNumber){
                                buf.append("\u283c");
                              isNumber = true;
                        }
                        else if (isNumber && !Character.isDigit(ch) && ch !=',' && ch !='.'){
                             isNumber = false;
                        }

                        if (ch == '+')
                           op = "\u282c";
                        else if (ch == '@')
                           op = "\u2808\u2801\u281e";
                        else op = getLetterCode(Character.toString(ch));
                        buf.append(op);

// Tests for end of line not included...
                        try {ch = jj_input_stream.readChar();}
                                catch(java.io.IOException ioe)
                                {System.out.println("End of file while reading verb..."); {if (true) return "";}}
                }

                buf.append(" ");

         //   jj_input_stream.backup(1);
                {if (true) return buf.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String verbatim() throws ParseException {
    char ch;
    int pos;
    char[] beg1 = {'\u005c\u005c','e','n','d','{','v','e','r','b','a','t','i','m','}'};
    StringBuffer buf = new StringBuffer();
    boolean isNumber=false;
    jj_consume_token(BEGINVERBATIM);
        pos = 0;


        /*
   int error_line = input_stream.getEndLine();
     int error_column = input_stream.getEndColumn();
     String error_after = null;
     boolean EOFSeen = false;
     try { input_stream.readChar(); input_stream.backup(1); }
     catch (java.io.IOException e1) {
        EOFSeen = true;
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
        if (curChar == '\n' || curChar == '\r') {
           error_line++;
           error_column = 0;
        }
        else
           error_column++;
     }
     if (!EOFSeen) {
        input_stream.backup(1);
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
     }
     throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
	*/
        pos = 0;
        ch = 'a';//
        buf.append("\u005cn");
        outer: while(true) {
                try {ch = jj_input_stream.readChar();}
                catch(java.io.IOException ioe)
                    {System.out.println("End of file while reading verbatim..."); {if (true) return "";}}
                if (beg1.length == pos){ //    we found it
                        break outer;
                }
                else if (ch == beg1[pos]){
                        pos++;
                }
                else {
                        //jj_input_stream.backup(pos); //
                        for (int i=0; i < pos; i++) {
                                // translate character

                                buf.append(getLetterCode(Character.toString(beg1[i])));
//				System.out.print(Character.toString(beg1[i]));
                        }
//			System.out.print(ch);

                        String op = null;

                        if (Character.isDigit(ch) && !isNumber){
                                buf.append("\u283c");
                              isNumber = true;
                        }
                        else if (isNumber && !Character.isDigit(ch) && ch !=',' && ch !='.'){
                             isNumber = false;
                        }

                        if (ch == '+')
                           op = "\u282c";
                        else if (ch == '@')
                           op = "\u2808\u2801\u281e";
                        else op = getLetterCode(Character.toString(ch));
                        buf.append(op);
                        pos = 0; // There is a more efficient algorithm, KMP but ... whatever...
                }

        }
        buf.append("\u005cn");
    jj_input_stream.backup(1);
    {if (true) return buf.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String tabular() throws ParseException {
    StringBuffer buf = new StringBuffer();
    String row;
        tabularcolumn = 1;
    jj_consume_token(BEGINTABULAR);
    jj_consume_token(LCB);
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENGLISHLETTER:
      case MATHTEXTSEPARATOR:
        ;
        break;
      default:
        jj_la1[54] = jj_gen;
        break label_20;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENGLISHLETTER:
        jj_consume_token(ENGLISHLETTER);
        break;
      case MATHTEXTSEPARATOR:
        jj_consume_token(MATHTEXTSEPARATOR);
        break;
      default:
        jj_la1[55] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RCB);
       buf.append("\u005cn\u005cn");
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HLINE:
        ;
        break;
      default:
        jj_la1[56] = jj_gen;
        break label_21;
      }
      jj_consume_token(HLINE);
    }
    row = tabularrow();
                           buf.append(row);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[57] = jj_gen;
        break label_22;
      }
      jj_consume_token(NEWLINE);
                 buf.append("\u005cn\u005cn");
      label_23:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HLINE:
          ;
          break;
        default:
          jj_la1[58] = jj_gen;
          break label_23;
        }
        jj_consume_token(HLINE);
      }
      row = tabularrow();
                                                                       buf.append(row);
    }
    jj_consume_token(ENDTABULAR);
      {if (true) return buf.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String tabularrow() throws ParseException {
        StringBuffer buf = new StringBuffer();
        tabularcolumn = 1;
        String cell="";
    if (jj_2_1(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case LBRA:
      case RBRA:
      case COMMAND:
      case ANY:
        cell = basic();
        buf.append("\u283f\u283c" + string2Braille(Integer.toString(tabularcolumn))+"\u283b");buf.append(cell);
        break;
      case MULTICOLUMN:
        cell = multicol();
                                    buf.append(cell);
        break;
      default:
        jj_la1[59] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTICOLUMN:
      case AMPERSAND:
        ;
        break;
      default:
        jj_la1[60] = jj_gen;
        break label_24;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AMPERSAND:
        jj_consume_token(AMPERSAND);
                     tabularcolumn++;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case PARAM:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case ACCENT:
        case GRAVEACCENT:
        case INLINEMATH:
        case LABEL:
        case REF:
        case INDEX:
        case TEXTBF:
        case TEXTIT:
        case EMPH:
        case TEXTCIRCLED:
        case INPUT:
        case INCLUDE:
        case NEWCOMMAND:
        case HUGE:
        case TEXTLATIN:
        case CHAPTER:
        case SECTION:
        case SUBSECTION:
        case VERB:
        case LTNALLCAPS:
        case TEXTSC:
        case MATHTEXTSEPARATOR:
        case LCB:
        case LBRA:
        case RBRA:
        case COMMAND:
        case ANY:
          cell = basic();
                                 buf.append("\u283f\u283c" + string2Braille(Integer.toString(tabularcolumn))+"\u283b");buf.append(cell);
          break;
        default:
          jj_la1[61] = jj_gen;
          ;
        }
        break;
      case MULTICOLUMN:
        cell = multicol();
                             buf.append(cell);
        break;
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
          {if (true) return buf.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String multicol() throws ParseException {
        StringBuffer buf = new StringBuffer();
        int cols = 0;
        String cell;
        String num;
    jj_consume_token(MULTICOLUMN);
    jj_consume_token(LCB);
    num = character_no_braille();
                                                        cols = Integer.parseInt(num);
    jj_consume_token(RCB);
    command_parameter();
    cell = command_parameter();
                buf.append("\u283f\u283c" +
                        string2Braille(Integer.toString(tabularcolumn) +
                                "-"+
                                Integer.toString(tabularcolumn+cols-1)));
                buf.append("\u283b");
                tabularcolumn += cols-1;
                buf.append(cell);
                {if (true) return buf.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String tabbing() throws ParseException {
    StringBuffer buf = new StringBuffer();
    String line;
    jj_consume_token(BEGINTABBING);
                       buf.append("\u005cn\u005cn");
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEWLINE:
      jj_consume_token(NEWLINE);
                    buf.append("\u005cn");
      break;
    default:
      jj_la1[63] = jj_gen;
      ;
    }
    line = basic();
                        buf.append(line);
    label_25:
    while (true) {
      if (jj_2_2(2)) {
        ;
      } else {
        break label_25;
      }
      jj_consume_token(NEWLINE);
                       buf.append("\u005cn");
      line = basic();
                                                          buf.append(line);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEWLINE:
      jj_consume_token(NEWLINE);
                       buf.append("\u005cn");
      break;
    default:
      jj_la1[64] = jj_gen;
      ;
    }
    jj_consume_token(ENDTABBING);
                     buf.append("\u005cn\u005cn");
      {if (true) return buf.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String description() throws ParseException {
    StringBuffer buffer = new StringBuffer();
    String itemString, contentString;
    jj_consume_token(BEGINDESCRIPTION);
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ITEM:
        ;
        break;
      default:
        jj_la1[65] = jj_gen;
        break label_26;
      }
      itemString = item();
                    buffer.append("\u005cn");
            buffer.append(itemString );
            buffer.append(getLetterCode("."));
            buffer.append(" ");
      contentString = content();
            buffer.append(contentString);
    }
    jj_consume_token(ENDDESCRIPTION);
      {if (true) return buffer.toString()+ "\u005cn   ";}
    throw new Error("Missing return statement in function");
  }

  final public String mathenvironment() throws ParseException {
    String result = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MATHBEGIN:
    case MATHBEND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATHBEGIN:
        jj_consume_token(MATHBEGIN);
        break;
      case MATHBEND:
        jj_consume_token(MATHBEND);
        break;
      default:
        jj_la1[66] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      result = math();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATHEND:
        jj_consume_token(MATHEND);
        break;
      case MATHBEND:
        jj_consume_token(MATHBEND);
        break;
      default:
        jj_la1[67] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case 131:
    case 132:
    case 133:
    case 134:
      result = eqnarray_align();
      break;
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return "\u005cn" + result + "\u005cn";}
    throw new Error("Missing return statement in function");
  }

  final public String inlinemath() throws ParseException {
    Token t;
    String s = "";
    boolean space;
    t = jj_consume_token(INLINEMATH);
                       space = checkforPreviousSpace(t);
    s = math();
    jj_consume_token(INLINEMATH);
        if (space) {
            {if (true) return " " + s;}
        }
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String index() throws ParseException {
    Token t;
    String s = "";
    boolean space;
    t = jj_consume_token(INDEX);
                  space = checkforPreviousSpace(t);
    command_parameter();
    command_parameter();
        if (space) {
            {if (true) return " " + s;}
        }
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

 // Are you sure that label does this??
  final public String label() throws ParseException {
    Token t;
    String s = "";
    boolean space;
    StringBuffer buffer = new StringBuffer();
    t = jj_consume_token(LABEL);
                  space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case SUB:
      s = character_no_braille();
      break;
    case LCB:
      jj_consume_token(LCB);
      label_27:
      while (true) {
        s = character_no_braille();
                                            buffer.append(s);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case MATHTEXTSEPARATOR:
        case SUB:
          ;
          break;
        default:
          jj_la1[69] = jj_gen;
          break label_27;
        }
      }
                                                                    s = buffer.toString();
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        // System.out.println("\nLABEL: " + s);
        String label = labeltable.get(s);
        // System.out.print( " " + label + " ");
        if (label != null) {
                    label = getMathCode("#")+string2BrailleTheorem(label);
        } else {
                    System.out.println("LABEL: " + s + " NOT FOUND");
                label = getLetterCode("?");
                } // In case code is not found...
            if (space) {
            {if (true) return " " + label;}
        }
        {if (true) return label;}
    throw new Error("Missing return statement in function");
  }

  final public String ref() throws ParseException {
    Token t;
    String s = "";
    boolean space;
    StringBuffer buffer = new StringBuffer();
    t = jj_consume_token(REF);
                space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case SUB:
      s = character_no_braille();
      break;
    case LCB:
      jj_consume_token(LCB);
      label_28:
      while (true) {
        s = character_no_braille();
                                                buffer.append(s);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case MATHTEXTSEPARATOR:
        case SUB:
          ;
          break;
        default:
          jj_la1[71] = jj_gen;
          break label_28;
        }
      }
                                                                        s = buffer.toString();
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[72] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            // System.out.println("\nLABEL: " + s);
            String label = labeltable.get(s);
            if (label != null) {
                    label = string2BrailleTheorem(label);
        } else {
                    label = getLetterCode("?");
        }
            if (space) {
            {if (true) return " " + getMathCode("#") + label;}
        }

            if (t.image.equals("\u005c\u005ceqref")) {
                    label = getLetterCode("(") + label + getLetterCode(")");
        }
            {if (true) return label;}
    throw new Error("Missing return statement in function");
  }

  final public String textbf() throws ParseException {
    Token t;
    boolean space;
    String s = null;
    t = jj_consume_token(TEXTBF);
                   space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();
                          s = getLetterCode("\u005c\u005ctextbf") + s;
      break;
    case LCB:
      s = bracketcontent();
                                   s = bold(s);
      break;
    default:
      jj_la1[73] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (space) {
            {if (true) return " " + s;}
        }
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String ignore() throws ParseException {
    Token t;
    boolean space;
    String s = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXTSC:
      t = jj_consume_token(TEXTSC);
      break;
    case HUGE:
      t = jj_consume_token(HUGE);
      break;
    default:
      jj_la1[74] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                  space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();

      break;
    case LCB:
      s = bracketcontent();

      break;
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (space) {
            {if (true) return " " + s;}
        }
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String textit() throws ParseException {
  Token t;
  boolean space;
  String s = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXTIT:
      t = jj_consume_token(TEXTIT);
      break;
    case EMPH:
      t = jj_consume_token(EMPH);
      break;
    default:
      jj_la1[76] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                  space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();
                          s = getLetterCode("\u005c\u005ctextit") + s;
      break;
    case LCB:
      s = bracketcontent();
                // TODO: Fix the following...
                s = getLetterCode("\u005c\u005ctextit-open")+ s + getLetterCode("\u005c\u005ctextit-close");
      break;
    default:
      jj_la1[77] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            if (space) {
            {if (true) return " " + s;}
        }
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String textcircled() throws ParseException {
  Token t;
  boolean space;
  String s = null;
    t = jj_consume_token(TEXTCIRCLED);
                        space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();
      break;
    case LCB:
      s = bracketcontent();
      break;
    default:
      jj_la1[78] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                // TODO: Fix the following...
                s = getLetterCode("\u005c\u005ctextcircled-open")+ s + getLetterCode("\u005c\u005ctextcircled-close");
            if (space) {
            {if (true) return " " + s;}
        }
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String latextonemethallcaps() throws ParseException {
        Token t;
        String s = null;
        boolean space;
    t = jj_consume_token(LTNALLCAPS);
                           space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();
      break;
    case LCB:
      s = bracketcontent();
      break;
    default:
      jj_la1[79] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                s = getLetterCode("b-allcaps") + s + getLetterCode("e-allcaps");
        if (space) {
            {if (true) return " " + s;}
        }
                {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public void input() throws ParseException {
    String s, filepath = "";
    StringBuffer buffer = new StringBuffer();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INPUT:
      jj_consume_token(INPUT);
      jj_consume_token(LCB);
      label_29:
      while (true) {
        s = character_no_braille();
                                                        buffer.append(s);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case MATHTEXTSEPARATOR:
        case SUB:
          ;
          break;
        default:
          jj_la1[80] = jj_gen;
          break label_29;
        }
      }
      jj_consume_token(RCB);
              filepath = buffer.toString();
      break;
    case INCLUDE:
      jj_consume_token(INCLUDE);
      jj_consume_token(LCB);
      label_30:
      while (true) {
        s = character_no_braille();
                                                              buffer.append(s);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case MATHTEXTSEPARATOR:
        case SUB:
          ;
          break;
        default:
          jj_la1[81] = jj_gen;
          break label_30;
        }
      }
      jj_consume_token(RCB);
                  filepath = buffer.toString() + ".tex";
      break;
    default:
      jj_la1[82] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        try {
                System.out.println("PARSING FILE: " + filepath);
                FileInputStream is = new FileInputStream(filepath);
            InputStreamReader fis = new InputStreamReader(is, "ISO-8859-7");
                Latex parser = new Latex (fis);
            parser.topcontent();
            System.out.println("EXITING PARSING: " + filepath);
            fis.close();
            is.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
  }

  final public String accent() throws ParseException {
    String s = "", c = "";
    jj_consume_token(ACCENT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case SUB:
      c = character_no_braille();
      break;
    case LCB:
      jj_consume_token(LCB);
      c = character();
      label_31:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case MATHTEXTSEPARATOR:
        case SUB:
          ;
          break;
        default:
          jj_la1[83] = jj_gen;
          break label_31;
        }
        character_no_braille();
      }
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (c.equals("e")) {
            s = getLetterCode("e-grave");
        }
                // ...
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String grave() throws ParseException {
    String s = "", c = "";
    jj_consume_token(GRAVEACCENT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case SUB:
      c = character_no_braille();
      break;
    case LCB:
      jj_consume_token(LCB);
      c = character();
      label_32:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case MATHTEXTSEPARATOR:
        case SUB:
          ;
          break;
        default:
          jj_la1[85] = jj_gen;
          break label_32;
        }
        character_no_braille();
      }
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[86] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (c.equals("e")) {
                         s = getLetterCode("e-accent");
         }
                // ...
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String chapter() throws ParseException {
    String s = "", label = "";
    jj_consume_token(CHAPTER);
    s = command_parameter();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label = label();
      break;
    default:
      jj_la1[87] = jj_gen;
      ;
    }
        try {
            output.flush(); // We are always sure that the existing output stream is not closed...
            output.close();
            parsedChapters.put(chapter, output.toString());
            output = new StringWriter();
            } catch(IOException ioe) {
                    ioe.printStackTrace();
        }
        chapter++;
        section = 0;
        subsection = 0;
        if (label.equals("")) {
                    label = getLetterCode("#") + string2Braille(Integer.toString(chapter));
        }
            {if (true) return "\u005cn" + string2Braille("\u039a\u03b5\u03c6\u03ac\u03bb") + getLetterCode("\u03b1\u03b9") + string2Braille("\u03bf ") + label + s + "\u005cn";}
    throw new Error("Missing return statement in function");
  }

  final public String section() throws ParseException {
    String s = "", label = "", option = "";
    jj_consume_token(SECTION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      option = option();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[88] = jj_gen;
      ;
    }
    s = command_parameter();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label = label();
      break;
    default:
      jj_la1[89] = jj_gen;
      ;
    }
        section++;
        subsection = 0;
        for (Theorem theorem: theorems.values()) {
            theorem.resetCounter();
        }
        if (label.equals("")) {
                    label = getLetterCode("#") +        string2Braille(Integer.toString(section));
        }
        {if (true) return option + " " + label + s + "\u005cn   ";}
    throw new Error("Missing return statement in function");
  }

  final public String subsection() throws ParseException {
    String s = "", label = "", option = "";
    jj_consume_token(SUBSECTION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      option = option();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[90] = jj_gen;
      ;
    }
    s = command_parameter();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label = label();
      break;
    default:
      jj_la1[91] = jj_gen;
      ;
    }
        subsection++;
        {if (true) return option + " " + label + s + "\u005cn";}
    throw new Error("Missing return statement in function");
  }

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////// MATHEMATICS /////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////



// put the stuff here...
  final public String math() throws ParseException {
    Expression e;
    String s = "", label = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label = label();
      break;
    default:
      jj_la1[92] = jj_gen;
      ;
    }
    e = mathexpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label = label();
      break;
    default:
      jj_la1[93] = jj_gen;
      ;
    }
        e.assignFractionLevel();
        e.assignOtherLevels();
        s = e.getBraille();
                if (!label.equals("")) {
                        s = s + getMathCode("(") + label + getMathCode(")");
        }
        {if (true) return  s ;}
    throw new Error("Missing return statement in function");
  }

  final public Token mathcharacter() throws ParseException {
        Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENGLISHLETTER:
      t = jj_consume_token(ENGLISHLETTER);
      break;
    case TEXTSYMBOL:
      t = jj_consume_token(TEXTSYMBOL);
      break;
    case DIGIT0:
    case DIGIT1:
      t = myDigit();
      break;
    case GREEKLETTER:
      t = jj_consume_token(GREEKLETTER);
      break;
    case DIPHTHONG:
      t = jj_consume_token(DIPHTHONG);
      break;
    case MATHSYMBOL:
      t = jj_consume_token(MATHSYMBOL);
      break;
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case LBRA:
    case RBRA:
      t = mathDelimiter();
      break;
    default:
      jj_la1[94] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token mathcharacter_no_brackets() throws ParseException {
        Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENGLISHLETTER:
      t = jj_consume_token(ENGLISHLETTER);
      break;
    case TEXTSYMBOL:
      t = jj_consume_token(TEXTSYMBOL);
      break;
    case DIGIT0:
    case DIGIT1:
      t = myDigit();
      break;
    case GREEKLETTER:
      t = jj_consume_token(GREEKLETTER);
      break;
    case DIPHTHONG:
      t = jj_consume_token(DIPHTHONG);
      break;
    case MATHSYMBOL:
      t = jj_consume_token(MATHSYMBOL);
      break;
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
      t = mathDelimiter_no_brackets();
      break;
    default:
      jj_la1[95] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

// A math expression should not be empty...
  final public Expression mathexpression() throws ParseException {
    Expression exp;
    MathExpression mex = new MathExpression(table);
        Expression exp1, exp2;
    label_33:
    while (true) {
      exp = simpleexpression();
                                                                    mex.addChild(exp);
      if (jj_2_3(2147483647)) {
        ;
      } else {
        break label_33;
      }
    }
          {if (true) return mex;}
    throw new Error("Missing return statement in function");
  }

  final public Expression mathexpression_no_brackets() throws ParseException {
    Expression exp;
    MathExpression mex = new MathExpression(table);
    label_34:
    while (true) {
      exp = simpleexpression_no_brackets();
                                                                                           mex.addChild(exp);
      if (jj_2_4(2147483647)) {
        ;
      } else {
        break label_34;
      }
    }
          {if (true) return mex;}
    throw new Error("Missing return statement in function");
  }

  final public Expression atomicmath() throws ParseException {
    Token t;
    Expression exp = null;
    MathCommand cmd;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case LBRA:
    case RBRA:
    case COMMAND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMAND:
        t = jj_consume_token(COMMAND);
        break;
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case LBRA:
      case RBRA:
        t = mathcharacter();
        break;
      default:
        jj_la1[96] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          String s = t.image.toString();

/////////////////////////////////////////////////here/////////////////////////////////////////////////////////////
                cmd = commandMathTable.get(t.image); // TODO: Is this right;	
                if (cmd != null) {

                        InputStream targetStream=null;
                        try{
                                targetStream = new ByteArrayInputStream(cmd.body.getBytes("ISO-8859-7"));
                        }catch(Exception e){e.printStackTrace();}
                        for (int i=0; i< cmd.numOfParams;i++){
                                cmd.params[i] =parameterexpression();// This is the real	
                        }
                        Latex lparser = new Latex(table, new InputStreamReader(targetStream), cmd, commandMathTable, verbose);
                        exp = lparser.mathexpression();
                }

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
                else {

                if (t.kind == DIGIT0) {
                        s =  "#" + s; // see NemethTable (hack...)
            }
            exp = new SimpleExpression(s, table);
        }
      break;
    case LCB:
      jj_consume_token(LCB);
      exp = mathexpression();
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[97] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression mathparam() throws ParseException {
        Token t;
        int nParam;
    t = jj_consume_token(PARAM);
                nParam = Integer.parseInt(t.image.substring(1));
                Expression parameter = this.currentMathMacro.params[nParam-1];
                {if (true) return parameter;}
    throw new Error("Missing return statement in function");
  }

  final public Expression parameterexpression() throws ParseException {
    Token t;
    Expression exp = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case LBRA:
    case RBRA:
    case COMMAND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMAND:
        t = jj_consume_token(COMMAND);
        break;
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case LBRA:
      case RBRA:
        t = mathcharacter();
        break;
      default:
        jj_la1[98] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            String s = t.image.toString();
                if (t.kind == DIGIT0) {
                        s = "#" + s; // see NemethTable (hack...)
            }
            exp = new SimpleExpression(s, table);

            if (DEFAULT != token_source.curLexState) {
                Token root = new Token(), last = root;
                root.next = null;

                // First, we build a list of tokens to push back, in backwards order
                while (token.next != null) {
                    Token to = token;
                    // Find the token whose token.next is the last in the chain
                    while (to.next != null && to.next.next != null) {
                        to = to.next;
                    }

                    // put it at the end of the new chain
                    last.next = to.next;
                    last = to.next;

                    // If there are special tokens, these go before the regular tokens,
                    // so we want to push them back onto the input stream in the order
                    // we find them along the specialToken chain.
                    if (to.next.specialToken != null) {
                        Token tt = to.next.specialToken;
                        while (tt != null) {
                            last.next = tt;
                            last = tt;
                            tt.next = null;
                            tt = tt.specialToken;
                        }
                    }
                    to.next = null;
                };

                while (root.next != null) {
                    jj_input_stream.backup(root.next.image.length());
                    root.next = root.next.next;
                }
                jj_ntk = -1;
                token_source.SwitchTo(DEFAULT);
            }
      break;
    case LCB:
      jj_consume_token(LCB);
      exp = mathexpression();
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[99] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression atomicmath_no_brackets() throws ParseException {
    Token t;
    Expression exp = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case COMMAND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMAND:
        t = jj_consume_token(COMMAND);
        break;
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
        t = mathcharacter_no_brackets();
        break;
      default:
        jj_la1[100] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            String s = t.image.toString();
            if (t.kind == DIGIT0) {
                s = "#" + s; // see NemethTable (hack...)
            }
            exp = new SimpleExpression(s, table);
      break;
    case LCB:
      jj_consume_token(LCB);
      exp = mathexpression_no_brackets();
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[101] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression parameterexpression_no_brackets() throws ParseException {
    Token t;
    Expression exp = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case COMMAND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMAND:
        t = jj_consume_token(COMMAND);
        break;
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
        t = mathcharacter_no_brackets();
        break;
      default:
        jj_la1[102] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            String s = t.image.toString();
                if (t.kind == DIGIT0) {
                        s = "#" + s; // see NemethTable (hack...)
            }
            exp = new SimpleExpression(s, table);

            if (DEFAULT != token_source.curLexState) {
                Token root = new Token(), last = root;
                root.next = null;

                // First, we build a list of tokens to push back, in backwards order
                while (token.next != null) {
                    Token to = token;
                    // Find the token whose token.next is the last in the chain
                    while (to.next != null && to.next.next != null) {
                        to = to.next;
                    }

                    // put it at the end of the new chain
                    last.next = to.next;
                    last = to.next;

                    // If there are special tokens, these go before the regular tokens,
                    // so we want to push them back onto the input stream in the order
                    // we find them along the specialToken chain.

                    if (to.next.specialToken != null) {
                        Token tt = to.next.specialToken;
                        while (tt != null) {
                            last.next = tt;
                            last = tt;
                            tt.next = null;
                            tt = tt.specialToken;
                        }
                    }
                    to.next = null;
                };

                while (root.next != null) {
                    jj_input_stream.backup(root.next.image.length());
                    root.next = root.next.next;
                }
                jj_ntk = -1;
                token_source.SwitchTo(DEFAULT);
            }
      break;
    case LCB:
      jj_consume_token(LCB);
      exp = mathexpression_no_brackets();
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[103] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression basicexpression() throws ParseException {
    Expression exp=null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case TEXTRM:
    case INTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case WIDETILDE:
    case OVERRIGHTARROW:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
      exp = mathcommand();
      break;
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case LCB:
    case LBRA:
    case RBRA:
    case COMMAND:
      exp = atomicmath();
      break;
    case 129:
      exp = array();
      break;
    case BEGINCASES:
      exp = cases();
      break;
    case BEGINPMATRIX:
      exp = pmatrix();
      break;
    case CASES:
      exp = cases_command();
      break;
    case BEGINSPLIT:
      exp = split();
      break;
    case LEFT:
      exp = leftright();
      break;
    case DELIMITERSIZEMODIFIER:
      /* This could possibly be in atomic math non-terminal. Check. */
              exp = modifiedMathDelimiter();
      break;
    case PARAM:
      /* This could possibly be in atomic math non-terminal. Check. */
              exp = mathparam();
      break;
    default:
      jj_la1[104] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression basicexpression_no_brackets() throws ParseException {
    Expression exp=null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case TEXTRM:
    case INTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case WIDETILDE:
    case OVERRIGHTARROW:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
      exp = mathcommand();
      break;
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case LCB:
    case COMMAND:
      exp = atomicmath_no_brackets();
      break;
    case 129:
      exp = array();
      break;
    case LEFT:
      exp = leftright();
      break;
    case DELIMITERSIZEMODIFIER:
      exp = modifiedMathDelimiter();
      break;
    default:
      jj_la1[105] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression simpleexpression() throws ParseException {
    Token t;
    Expression exp = null, exp1 = null, exp2, exp3;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case PARAM:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case BEGINCASES:
    case BEGINPMATRIX:
    case BEGINSPLIT:
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case LEFT:
    case TEXTRM:
    case INTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case WIDETILDE:
    case OVERRIGHTARROW:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case CASES:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case DELIMITERSIZEMODIFIER:
    case LCB:
    case LBRA:
    case RBRA:
    case COMMAND:
    case 129:
      exp = basicexpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SUP:
      case SUB:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SUP:
          jj_consume_token(SUP);
          exp2 = basicexpression();
                                                     exp1 = exp; exp = new Sup(exp1, exp2, table);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SUB:
            jj_consume_token(SUB);
            exp3 = basicexpression();
                                                                   exp = new SubSup(exp1, exp3, exp2, table);
            break;
          default:
            jj_la1[106] = jj_gen;
            ;
          }
          break;
        case SUB:
          jj_consume_token(SUB);
          exp2 = basicexpression();
                                                     exp1 = exp; exp = new Sub(exp1, exp2, table);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SUP:
            jj_consume_token(SUP);
            exp3 = basicexpression();
                                                                   exp = new SubSup(exp1, exp2, exp3, table);
            break;
          default:
            jj_la1[107] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[108] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[109] = jj_gen;
        ;
      }
      break;
    case SUP:
    case SUB:
              exp = new EmptyExpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SUP:
        jj_consume_token(SUP);
        exp2 = basicexpression();
                                                             exp1 = exp; exp = new Sup(exp1, exp2, table);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SUB:
          jj_consume_token(SUB);
          exp3 = basicexpression();
                                                                           exp = new SubSup(exp1, exp3, exp2, table);
          break;
        default:
          jj_la1[110] = jj_gen;
          ;
        }
        break;
      case SUB:
        jj_consume_token(SUB);
        exp2 = basicexpression();
                                                                 exp1 = exp; exp = new Sub(exp1, exp2, table);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SUP:
          jj_consume_token(SUP);
          exp3 = basicexpression();
                                                                           exp = new SubSup(exp1, exp2, exp3, table);
          break;
        default:
          jj_la1[111] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[112] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[113] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression simpleexpression_no_brackets() throws ParseException {
    Token t;
    Expression exp = null, exp1 = null, exp2, exp3;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case LEFT:
    case TEXTRM:
    case INTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case WIDETILDE:
    case OVERRIGHTARROW:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case DELIMITERSIZEMODIFIER:
    case LCB:
    case COMMAND:
    case 129:
      exp = basicexpression_no_brackets();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SUP:
      case SUB:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SUP:
          jj_consume_token(SUP);
          exp2 = basicexpression_no_brackets();
                              exp1 = exp; exp = new Sup(exp1, exp2, table);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SUB:
            jj_consume_token(SUB);
            exp3 = basicexpression_no_brackets();
                                                                                       exp = new SubSup(exp1, exp3, exp2, table);
            break;
          default:
            jj_la1[114] = jj_gen;
            ;
          }
          break;
        case SUB:
          jj_consume_token(SUB);
          exp2 = basicexpression_no_brackets();
                                  exp1 = exp; exp = new Sub(exp1, exp2, table);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SUP:
            jj_consume_token(SUP);
            exp3 = basicexpression_no_brackets();
                                                                                     exp = new SubSup(exp1, exp2, exp3, table);
            break;
          default:
            jj_la1[115] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[116] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[117] = jj_gen;
        ;
      }
      break;
    case SUP:
    case SUB:
              exp = new EmptyExpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SUP:
        jj_consume_token(SUP);
        exp2 = basicexpression_no_brackets();
                              exp1 = exp; exp = new Sup(exp1, exp2, table);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SUB:
          jj_consume_token(SUB);
          exp3 = basicexpression_no_brackets();
                                                                               exp = new SubSup(exp1, exp3, exp2, table);
          break;
        default:
          jj_la1[118] = jj_gen;
          ;
        }
        break;
      case SUB:
        jj_consume_token(SUB);
        exp2 = basicexpression_no_brackets();
                                  exp1 = exp; exp = new Sub(exp1, exp2, table);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SUP:
          jj_consume_token(SUP);
          exp3 = basicexpression_no_brackets();
                                                                                     exp = new SubSup(exp1, exp2, exp3, table);
          break;
        default:
          jj_la1[119] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[120] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[121] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression mathcommand() throws ParseException {
    Expression exp = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQRT:
      exp = sqrt();
      break;
    case FRAC:
      exp = frac();
      break;
    case TEXTRM:
    case INTERTEXT:
    case HBOX:
    case MBOX:
      exp = textinmath();
      break;
    case TEXTLATIN:
      exp = latinmath();
      break;
    case MATHBB:
      exp = mathbb();
      break;
    case MATHCAL:
      exp = mathcal();
      break;
    case UNDERBRACE:
      exp = underbrace();
      break;
    case OVERBRACE:
      exp = overbrace();
      break;
    case DOT:
      exp = dot();
      break;
    case OVERLINE:
      exp = overline();
      break;
    case UNDERLINE:
      exp = underline();
      break;
    case TILDE:
      exp = tilde();
      break;
    case OVERRIGHTARROW:
    case VEC:
      exp = vec();
      break;
    case WIDETILDE:
      exp = widetilde();
      break;
    case LENQNO:
      exp = lenqno();
      break;
    case BINOM:
      exp = binom();
      break;
    case HAT:
      exp = hat();
      break;
    case BAR:
      exp = bar();
      break;
    case STACKREL:
      exp = stackrel();
      break;
    case CHECK:
      exp = check();
      break;
    case ACUTE:
      exp = acute();
      break;
    case GRAVE:
      exp = gravemath();
      break;
    case BREVE:
      exp = breve();
      break;
    case DDOT:
      exp = ddot();
      break;
    case MATHRING:
      exp = mathring();
      break;
    case TEXTSC:
      exp = ignorecommand();
      break;
    default:
      jj_la1[122] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Vector<Expression> row() throws ParseException {
    Expression exp;
    Vector<Expression> expressions =  new Vector<Expression>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case PARAM:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case BEGINCASES:
    case BEGINPMATRIX:
    case BEGINSPLIT:
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case LEFT:
    case TEXTRM:
    case INTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case WIDETILDE:
    case OVERRIGHTARROW:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case CASES:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case DELIMITERSIZEMODIFIER:
    case SUP:
    case SUB:
    case LCB:
    case LBRA:
    case RBRA:
    case COMMAND:
    case 129:
      exp = mathexpression();
                            expressions.add(exp);
      break;
    default:
      jj_la1[123] = jj_gen;
      ;
    }
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AMPERSAND:
        ;
        break;
      default:
        jj_la1[124] = jj_gen;
        break label_35;
      }
      jj_consume_token(AMPERSAND);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case BEGINCASES:
      case BEGINPMATRIX:
      case BEGINSPLIT:
      case TEXTLATIN:
      case FRAC:
      case SQRT:
      case LEFT:
      case TEXTRM:
      case INTERTEXT:
      case HBOX:
      case MBOX:
      case TILDE:
      case WIDETILDE:
      case OVERRIGHTARROW:
      case TEXTSC:
      case OVERLINE:
      case UNDERLINE:
      case DOT:
      case LENQNO:
      case HAT:
      case VEC:
      case BAR:
      case STACKREL:
      case CHECK:
      case ACUTE:
      case GRAVE:
      case CASES:
      case BREVE:
      case DDOT:
      case MATHRING:
      case BINOM:
      case MATHBB:
      case MATHCAL:
      case UNDERBRACE:
      case OVERBRACE:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case DELIMITERSIZEMODIFIER:
      case SUP:
      case SUB:
      case LCB:
      case LBRA:
      case RBRA:
      case COMMAND:
      case 129:
        exp = mathexpression();
                                           expressions.add(exp);
        break;
      default:
        jj_la1[125] = jj_gen;
        ;
      }
    }
          {if (true) return expressions;}
    throw new Error("Missing return statement in function");
  }

  final public Expression[] arrayrow(int cols) throws ParseException {
        Expression exp;
        Expression [] expressions =  new Expression[cols];
        int col = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case PARAM:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case BEGINCASES:
    case BEGINPMATRIX:
    case BEGINSPLIT:
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case LEFT:
    case TEXTRM:
    case INTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case WIDETILDE:
    case OVERRIGHTARROW:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case CASES:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case DELIMITERSIZEMODIFIER:
    case SUP:
    case SUB:
    case LCB:
    case LBRA:
    case RBRA:
    case COMMAND:
    case 129:
      exp = mathexpression();
                            expressions[col] = exp;
      break;
    default:
      jj_la1[126] = jj_gen;
      ;
    }
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AMPERSAND:
        ;
        break;
      default:
        jj_la1[127] = jj_gen;
        break label_36;
      }
      jj_consume_token(AMPERSAND);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case BEGINCASES:
      case BEGINPMATRIX:
      case BEGINSPLIT:
      case TEXTLATIN:
      case FRAC:
      case SQRT:
      case LEFT:
      case TEXTRM:
      case INTERTEXT:
      case HBOX:
      case MBOX:
      case TILDE:
      case WIDETILDE:
      case OVERRIGHTARROW:
      case TEXTSC:
      case OVERLINE:
      case UNDERLINE:
      case DOT:
      case LENQNO:
      case HAT:
      case VEC:
      case BAR:
      case STACKREL:
      case CHECK:
      case ACUTE:
      case GRAVE:
      case CASES:
      case BREVE:
      case DDOT:
      case MATHRING:
      case BINOM:
      case MATHBB:
      case MATHCAL:
      case UNDERBRACE:
      case OVERBRACE:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case DELIMITERSIZEMODIFIER:
      case SUP:
      case SUB:
      case LCB:
      case LBRA:
      case RBRA:
      case COMMAND:
      case 129:
        exp = mathexpression();
                                           expressions[++col]=exp;
        break;
      default:
        jj_la1[128] = jj_gen;
        ;
      }
    }
          {if (true) return expressions;}
    throw new Error("Missing return statement in function");
  }

  final public Expression cases() throws ParseException {
    Expression[] row = null;
    Vector<Expression[]> rows = new Vector<Expression[]>();
    int cols = 0;
    jj_consume_token(BEGINCASES);
    row = arrayrow(2);
                                     rows.add(row);
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[129] = jj_gen;
        break label_37;
      }
      jj_consume_token(NEWLINE);
      row = arrayrow(2);
                                   rows.add(row);
    }
    jj_consume_token(ENDCASES);
        Array array  = new Array(rows, table);
        DelimiterExpression dexp = new DelimiterExpression("\u005c\u005c{",".", array, table);
        {if (true) return dexp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression pmatrix() throws ParseException {
    Expression[] row = null;
    Vector<Expression[]> rows = new Vector<Expression[]>();
    int cols = 0;
    jj_consume_token(BEGINPMATRIX);
    row = arrayrow(2);
                                       rows.add(row);
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[130] = jj_gen;
        break label_38;
      }
      jj_consume_token(NEWLINE);
      row = arrayrow(2);
                                   rows.add(row);
    }
    jj_consume_token(ENDPMATRIX);
        Array array  = new Array(rows, table);
        DelimiterExpression dexp = new DelimiterExpression("(",")", array, table);
        {if (true) return dexp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression bmatrix() throws ParseException {
    Expression[] row = null;
    Vector<Expression[]> rows = new Vector<Expression[]>();
    int cols = 0;
    jj_consume_token(BEGINPMATRIX);
    row = arrayrow(2);
                                       rows.add(row);
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[131] = jj_gen;
        break label_39;
      }
      jj_consume_token(NEWLINE);
      row = arrayrow(2);
                                   rows.add(row);
    }
    jj_consume_token(ENDPMATRIX);
        Array array  = new Array(rows, table);
        DelimiterExpression dexp = new DelimiterExpression("\u005c\u005c[","\u005c\u005c]", array, table);
        {if (true) return dexp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression cases_command() throws ParseException {
    Expression[] row = null;
    Vector<Expression[]> rows = new Vector<Expression[]>();
    int cols = 0;
    jj_consume_token(CASES);
    jj_consume_token(LCB);
    row = cases_row();
                                     rows.add(row);
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CR:
        ;
        break;
      default:
        jj_la1[132] = jj_gen;
        break label_40;
      }
      jj_consume_token(CR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case BEGINCASES:
      case BEGINPMATRIX:
      case BEGINSPLIT:
      case TEXTLATIN:
      case FRAC:
      case SQRT:
      case LEFT:
      case TEXTRM:
      case INTERTEXT:
      case HBOX:
      case MBOX:
      case TILDE:
      case WIDETILDE:
      case OVERRIGHTARROW:
      case TEXTSC:
      case OVERLINE:
      case UNDERLINE:
      case DOT:
      case LENQNO:
      case HAT:
      case VEC:
      case BAR:
      case STACKREL:
      case CHECK:
      case ACUTE:
      case GRAVE:
      case CASES:
      case BREVE:
      case DDOT:
      case MATHRING:
      case BINOM:
      case MATHBB:
      case MATHCAL:
      case UNDERBRACE:
      case OVERBRACE:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case DELIMITERSIZEMODIFIER:
      case SUP:
      case SUB:
      case LCB:
      case LBRA:
      case RBRA:
      case COMMAND:
      case 129:
        row = cases_row();
                               rows.add(row);
        break;
      default:
        jj_la1[133] = jj_gen;
        ;
      }
    }
    jj_consume_token(RCB);
        Array array  = new Array(rows, table);
        DelimiterExpression dexp = new DelimiterExpression("\u005c\u005c{",".", array, table);
        {if (true) return dexp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression[] cases_row() throws ParseException {
        Expression exp;
        String s;
        Expression [] expressions =  new Expression[2];
    exp = mathexpression();
                           expressions[0] = exp;
    jj_consume_token(AMPERSAND);
    s = content();
                                expressions[1] = new TextMathExpression(s,table);
          {if (true) return expressions;}
    throw new Error("Missing return statement in function");
  }

  final public Array array() throws ParseException {
    Expression[] row = null;
    Vector<Expression[]> rows = new Vector<Expression[]>();
    int cols = 0;
    jj_consume_token(129);
    jj_consume_token(LCB);
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENGLISHLETTER:
        ;
        break;
      default:
        jj_la1[134] = jj_gen;
        break label_41;
      }
      jj_consume_token(ENGLISHLETTER);
                                              cols++;
    }
    jj_consume_token(RCB);
    row = arrayrow(cols);
                           rows.add(row);
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[135] = jj_gen;
        break label_42;
      }
      jj_consume_token(NEWLINE);
      row = arrayrow(cols);
                                      rows.add(row);
    }
    jj_consume_token(130);
      {if (true) return new Array(rows, table);}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression split() throws ParseException {
    Vector<Expression> r;
    MathExpression math = new MathExpression(table);
    jj_consume_token(BEGINSPLIT);
    r = row();
        for (Expression exp : r) {
                    math.addChild(exp);
        }
        math.addChild(new SimpleExpression(" ", table));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label();

      break;
    default:
      jj_la1[136] = jj_gen;
      ;
    }
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[137] = jj_gen;
        break label_43;
      }
      jj_consume_token(NEWLINE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRA:
        jj_consume_token(LBRA);
        mathexpression_no_brackets();
        jj_consume_token(RBRA);
        break;
      default:
        jj_la1[138] = jj_gen;
        ;
      }

      r = row();
            for (Expression exp : r) {
                        // buffer.append(exp.getBraille());
                        math.addChild(exp);
            }
            math.addChild(new SimpleExpression(" ", table));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LABEL:
        label();

        break;
      default:
        jj_la1[139] = jj_gen;
        ;
      }
    }
    jj_consume_token(ENDSPLIT);
        {if (true) return math;}
        // buffer.toString();

    throw new Error("Missing return statement in function");
  }

  final public String eqnarray_align() throws ParseException {
    Vector<Expression> r;
    StringBuffer buffer = new StringBuffer();
    String label;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 131:
      jj_consume_token(131);
      break;
    case 132:
      jj_consume_token(132);
      break;
    case 133:
      jj_consume_token(133);
      break;
    case 134:
      jj_consume_token(134);
      break;
    default:
      jj_la1[140] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label = label();
      break;
    default:
      jj_la1[141] = jj_gen;
      ;
    }
    //TODO: this label is ignored!!
        r = row();
        for (Expression exp : r) {
                buffer.append(exp.getBraille());
        }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label = label();
                       buffer.append(" " + getMathCode("(") + label+ getMathCode(")"));
      break;
    default:
      jj_la1[142] = jj_gen;
      ;
    }
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[143] = jj_gen;
        break label_44;
      }
      jj_consume_token(NEWLINE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRA:
        jj_consume_token(LBRA);
        mathexpression_no_brackets();
        jj_consume_token(RBRA);
        break;
      default:
        jj_la1[144] = jj_gen;
        ;
      }
          buffer.append(" ");
      r = row();
            for (Expression exp : r) {
                        buffer.append(exp.getBraille());
            }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LABEL:
        label = label();
                           buffer.append(" " + getMathCode("(") + label+ getMathCode(")"));
        break;
      default:
        jj_la1[145] = jj_gen;
        ;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 135:
      jj_consume_token(135);
      break;
    case 136:
      jj_consume_token(136);
      break;
    case 137:
      jj_consume_token(137);
      break;
    case 138:
      jj_consume_token(138);
      break;
    default:
      jj_la1[146] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

  final public Fraction frac() throws ParseException {
    Expression nom, denom;
    jj_consume_token(FRAC);
    nom = parameterexpression();
    denom = parameterexpression();
      {if (true) return new Fraction(nom, denom, table);}
    throw new Error("Missing return statement in function");
  }

  final public Sqrt sqrt() throws ParseException {
    Expression root;
    Expression rank = null;
    Token t;
    jj_consume_token(SQRT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      rank = mathexpression_no_brackets();
      jj_consume_token(RBRA);

      break;
    default:
      jj_la1[147] = jj_gen;
      ;
    }
    root = parameterexpression();
            if (rank != null) {
                {if (true) return new Sqrt(root, rank, table);}
        }
            {if (true) return new Sqrt(root, table);}
    throw new Error("Missing return statement in function");
  }

// This is a special kind of array...
  final public Expression leftright() throws ParseException {
  Token t1, t2;
  Expression exp;
    jj_consume_token(LEFT);
    t1 = mathDelimiter();
    exp = mathexpression();
    jj_consume_token(RIGHT);
    t2 = mathDelimiter();
          {if (true) return new DelimiterExpression(t1.image, t2.image, exp, table);}
    throw new Error("Missing return statement in function");
  }

  final public Expression latinmath() throws ParseException {
    Expression exp;
    String s;
    jj_consume_token(TEXTLATIN);
    s = command_parameter();
        String en = getLetterCode("EN");
        s = en + s;
        {if (true) return new TextMathExpression(s, table);}
    throw new Error("Missing return statement in function");
  }

  final public Expression textinmath() throws ParseException {
    Expression exp;
    String s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXTRM:
      jj_consume_token(TEXTRM);
      break;
    case INTERTEXT:
      jj_consume_token(INTERTEXT);
      break;
    case HBOX:
      jj_consume_token(HBOX);
      break;
    case MBOX:
      jj_consume_token(MBOX);
      break;
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    s = command_parameter();
          {if (true) return new TextMathExpression(s, table);}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression mathbb() throws ParseException {
    Expression exp;
    MathExpression newexp;
    jj_consume_token(MATHBB);
    exp = parameterexpression();
        newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cmathbb", table));
                newexp.addChild(exp);
                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression mathcal() throws ParseException {
    Expression exp;
    MathExpression newexp;
    jj_consume_token(MATHCAL);
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cmathcal", table));
                newexp.addChild(exp);
                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression breve() throws ParseException {
    Expression exp;
    MathExpression newexp;
    jj_consume_token(BREVE);
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression("\u005c\u005cbreve", table));

                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression ddot() throws ParseException {
    Expression exp;
    MathExpression newexp;
    jj_consume_token(DDOT);
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression("\u005c\u005cddot", table));

                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression mathring() throws ParseException {
    Expression exp;
    MathExpression newexp;
    jj_consume_token(MATHRING);
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression("\u005c\u005cmathring", table));

                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression vec() throws ParseException {
  Expression exp; MathExpression newexp;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VEC:
      jj_consume_token(VEC);
      break;
    case OVERRIGHTARROW:
      jj_consume_token(OVERRIGHTARROW);
      break;
    default:
      jj_la1[149] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    exp = parameterexpression();
                newexp = new MathExpression(table);

                newexp.addChild(new SimpleExpression("\u005c\u005cvec-begin",table));
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression("\u005c\u005cvec-end",table));

                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression hat() throws ParseException {
    Expression exp;
    MathExpression newexp;
    jj_consume_token(HAT);
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression("\u005c\u005chat", table));
                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression overline() throws ParseException {
    Expression under, sub = null;
    MathExpression newexp;
    jj_consume_token(OVERLINE);
    under = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005coverline-begin", table));
                newexp.addChild(under);
                newexp.addChild(new SimpleExpression("\u005c\u005coverline-end", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression underline() throws ParseException {
    Expression under, sub = null;
    MathExpression newexp;
    jj_consume_token(UNDERLINE);
    under = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cunderline-begin", table));
                newexp.addChild(under);
                newexp.addChild(new SimpleExpression("\u005c\u005cunderline-end", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression dot() throws ParseException {
    Expression under, sub = null;
    MathExpression newexp;
    jj_consume_token(DOT);
    under = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cdot-begin", table));
                newexp.addChild(under);
                newexp.addChild(new SimpleExpression("\u005c\u005cdot-end", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression binom() throws ParseException {
    Expression under, sub = null;
    MathExpression newexp;
    jj_consume_token(BINOM);
    under = parameterexpression();
    sub = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("(", table));
                newexp.addChild(under);
                newexp.addChild(new SimpleExpression("\u005c\u005cbinom", table));
                newexp.addChild(sub);
                newexp.addChild(new SimpleExpression(")", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression ignorecommand() throws ParseException {
    Expression exp = null;
    jj_consume_token(TEXTSC);
    exp = parameterexpression();
          {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression underbrace() throws ParseException {
    Expression under, sub = null;
    MathExpression newexp;
    jj_consume_token(UNDERBRACE);
    under = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cunderbrace-begin", table));
                newexp.addChild(under);
                newexp.addChild(new SimpleExpression("\u005c\u005cunderbrace-middle", table));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUB:
      jj_consume_token(SUB);
      sub = parameterexpression();
                newexp.addChild(sub);
                newexp.addChild(new SimpleExpression("\u005c\u005cunderbrace-end", table));
                newexp.addChild(new SimpleExpression(" ", table));
      break;
    default:
      jj_la1[150] = jj_gen;
      ;
    }
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression overbrace() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(OVERBRACE);
    over = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005coverbrace-begin", table));
                newexp.addChild(over);
                newexp.addChild(new SimpleExpression("\u005c\u005coverbrace-middle", table));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUP:
      jj_consume_token(SUP);
      sup = parameterexpression();
                newexp.addChild(sup);
                newexp.addChild(new SimpleExpression("\u005c\u005coverbrace-end", table));
                newexp.addChild(new SimpleExpression(" ", table));
      break;
    default:
      jj_la1[151] = jj_gen;
      ;
    }
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression tilde() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(TILDE);
    over = parameterexpression();
        newexp = new MathExpression(table);
                newexp.addChild(over);
                newexp.addChild(new SimpleExpression("\u005c\u005ctilde", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression lenqno() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(LENQNO);
    over = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005clenqno", table));
                newexp.addChild(over);
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression widetilde() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(WIDETILDE);
    over = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cwidetilde-begin", table));
                newexp.addChild(over);
                newexp.addChild(new SimpleExpression("\u005c\u005cwidetilde-begin", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression bar() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(BAR);
    over = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(over);
                newexp.addChild(new SimpleExpression("\u005c\u005cbar", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression check() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(CHECK);
    over = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(over);
                newexp.addChild(new SimpleExpression("\u005c\u005ccheck", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression acute() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(ACUTE);
    over = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(over);
                newexp.addChild(new SimpleExpression("\u005c\u005cacute", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression gravemath() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(GRAVE);
    over = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(over);
                newexp.addChild(new SimpleExpression("\u005c\u005cgrave", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression stackrel() throws ParseException {
    Expression exp1, exp2;
    MathExpression newexp;
    jj_consume_token(STACKREL);
    exp1 = parameterexpression();
    exp2 = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cstackrel-begin", table));
                newexp.addChild(exp1);
                newexp.addChild(new SimpleExpression("\u005c\u005cstackrel-middle", table));
                newexp.addChild(exp2);
                newexp.addChild(new SimpleExpression("\u005c\u005cstackrel-end", table));
                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public SimpleExpression modifiedMathDelimiter() throws ParseException {
    Token mod, del;
    SimpleExpression se;
    mod = jj_consume_token(DELIMITERSIZEMODIFIER);
    del = mathDelimiter();
        String str = mod.image + del.image;
        {if (true) return new SimpleExpression(str, table);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_3R_339() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_333()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_184() {
    if (jj_scan_token(OVERBRACE)) return true;
    if (jj_3R_236()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_239()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_331() {
    if (jj_scan_token(ITEM)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_339()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_263() {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3R_141() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_3R_203()) return true;
    }
    return false;
  }

  private boolean jj_3R_308() {
    if (jj_scan_token(BEGINCENTER)) return true;
    if (jj_3R_206()) return true;
    if (jj_scan_token(ENDCENTER)) return true;
    return false;
  }

  private boolean jj_3R_335() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_238() {
    if (jj_scan_token(SUB)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_97() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    if (jj_3R_142()) return true;
    }
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_scan_token(UNDERBRACE)) return true;
    if (jj_3R_236()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_238()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_334() {
    if (jj_scan_token(CAPTION)) return true;
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_247() {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_256() {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3R_321() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_333()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_215() {
    Token xsp;
    if (jj_3R_247()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_247()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_257() {
    if (jj_3R_153()) return true;
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_scan_token(TEXTSC)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_322() {
    if (jj_3R_334()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_335()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_213() {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_307() {
    if (jj_scan_token(BEGINFIGURE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_321()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_322()) jj_scanpos = xsp;
    if (jj_scan_token(ENDFIGURE)) return true;
    return false;
  }

  private boolean jj_3R_154() {
    Token xsp;
    if (jj_3R_213()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_213()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_361() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_192() {
    if (jj_scan_token(BINOM)) return true;
    if (jj_3R_236()) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_309() {
    if (jj_scan_token(BEGINQUOTE)) return true;
    if (jj_3R_206()) return true;
    if (jj_scan_token(ENDQUOTE)) return true;
    return false;
  }

  private boolean jj_3R_246() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_3R_264()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_185() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_357() {
    if (jj_scan_token(TWONEWLINES)) return true;
    return false;
  }

  private boolean jj_3R_356() {
    if (jj_scan_token(NEWLINE)) return true;
    return false;
  }

  private boolean jj_3R_360() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_355() {
    if (jj_scan_token(SUB)) return true;
    return false;
  }

  private boolean jj_3R_337() {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_354() {
    if (jj_scan_token(SUP)) return true;
    return false;
  }

  private boolean jj_3R_353() {
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_352() {
    if (jj_scan_token(LCB)) return true;
    return false;
  }

  private boolean jj_3R_351() {
    if (jj_scan_token(COMMAND)) return true;
    return false;
  }

  private boolean jj_3R_240() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_3R_257()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_350() {
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3R_345() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_350()) {
    jj_scanpos = xsp;
    if (jj_3R_351()) {
    jj_scanpos = xsp;
    if (jj_3R_352()) {
    jj_scanpos = xsp;
    if (jj_3R_353()) {
    jj_scanpos = xsp;
    if (jj_3R_354()) {
    jj_scanpos = xsp;
    if (jj_3R_355()) {
    jj_scanpos = xsp;
    if (jj_3R_356()) {
    jj_scanpos = xsp;
    if (jj_3R_357()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_336() {
    Token xsp;
    if (jj_3R_345()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_345()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_325() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_336()) {
    jj_scanpos = xsp;
    if (jj_3R_337()) return true;
    }
    return false;
  }

  private boolean jj_3R_187() {
    if (jj_scan_token(UNDERLINE)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_312() {
    if (jj_scan_token(BEGINPSPICTURE)) return true;
    Token xsp;
    if (jj_3R_325()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_325()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDPSPICTURE)) return true;
    return false;
  }

  private boolean jj_3R_340() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_248() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_216() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_248()) jj_scanpos = xsp;
    if (jj_3R_154()) return true;
    xsp = jj_scanpos;
    if (jj_3R_340()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_186() {
    if (jj_scan_token(OVERLINE)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_311() {
    if (jj_scan_token(BEGINPROOF)) return true;
    if (jj_3R_206()) return true;
    if (jj_scan_token(ENDPROOF)) return true;
    return false;
  }

  private boolean jj_3R_272() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_333()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_301() {
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3R_300() {
    if (jj_3R_314()) return true;
    return false;
  }

  private boolean jj_3R_299() {
    if (jj_3R_313()) return true;
    return false;
  }

  private boolean jj_3R_298() {
    if (jj_3R_312()) return true;
    return false;
  }

  private boolean jj_3R_297() {
    if (jj_3R_311()) return true;
    return false;
  }

  private boolean jj_3R_365() {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_296() {
    if (jj_3R_310()) return true;
    return false;
  }

  private boolean jj_3R_295() {
    if (jj_3R_309()) return true;
    return false;
  }

  private boolean jj_3R_294() {
    if (jj_3R_308()) return true;
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_292() {
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_scan_token(HAT)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_225() {
    if (jj_scan_token(SUBSECTION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_272()) jj_scanpos = xsp;
    if (jj_3R_237()) return true;
    xsp = jj_scanpos;
    if (jj_3R_361()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_3R_305()) return true;
    return false;
  }

  private boolean jj_3R_290() {
    if (jj_3R_304()) return true;
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_3R_303()) return true;
    return false;
  }

  private boolean jj_3R_285() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) {
    jj_scanpos = xsp;
    if (jj_3R_291()) {
    jj_scanpos = xsp;
    if (jj_3R_292()) {
    jj_scanpos = xsp;
    if (jj_3R_293()) {
    jj_scanpos = xsp;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) {
    jj_scanpos = xsp;
    if (jj_3R_297()) {
    jj_scanpos = xsp;
    if (jj_3R_298()) {
    jj_scanpos = xsp;
    if (jj_3R_299()) {
    jj_scanpos = xsp;
    if (jj_3R_300()) {
    jj_scanpos = xsp;
    if (jj_3R_301()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_271() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_333()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_359() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_189() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) return true;
    }
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_364() {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_270() {
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_111()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_365()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_scan_token(SECTION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_271()) jj_scanpos = xsp;
    if (jj_3R_237()) return true;
    xsp = jj_scanpos;
    if (jj_3R_360()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_scan_token(MATHRING)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_268() {
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_111()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_364()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_302() {
    if (jj_scan_token(TWONEWLINES)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(7)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_286() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_302()) {
    jj_scanpos = xsp;
    if (jj_scan_token(126)) return true;
    }
    return false;
  }

  private boolean jj_3R_223() {
    if (jj_scan_token(CHAPTER)) return true;
    if (jj_3R_237()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_359()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_200() {
    if (jj_scan_token(DDOT)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_222() {
    if (jj_scan_token(GRAVEACCENT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_269()) {
    jj_scanpos = xsp;
    if (jj_3R_270()) return true;
    }
    return false;
  }

  private boolean jj_3R_199() {
    if (jj_scan_token(BREVE)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_267() {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_367() {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_221() {
    if (jj_scan_token(ACCENT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) return true;
    }
    return false;
  }

  private boolean jj_3R_182() {
    if (jj_scan_token(MATHCAL)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_366() {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_260() {
    if (jj_3R_286()) return true;
    return false;
  }

  private boolean jj_3R_259() {
    if (jj_3R_285()) return true;
    return false;
  }

  private boolean jj_3R_242() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_258()) {
    jj_scanpos = xsp;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3R_260()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_258() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_181() {
    if (jj_scan_token(MATHBB)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_206() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_242()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_251() {
    if (jj_scan_token(INCLUDE)) return true;
    if (jj_scan_token(LCB)) return true;
    Token xsp;
    if (jj_3R_367()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_367()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_250() {
    if (jj_scan_token(INPUT)) return true;
    if (jj_scan_token(LCB)) return true;
    Token xsp;
    if (jj_3R_366()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_366()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_3R_51()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_56()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_179() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) return true;
    }
    }
    }
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_230() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_250()) {
    jj_scanpos = xsp;
    if (jj_3R_251()) return true;
    }
    return false;
  }

  private boolean jj_3R_278() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_180() {
    if (jj_scan_token(TEXTLATIN)) return true;
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    }
    return false;
  }

  private boolean jj_3R_277() {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_344() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_228() {
    if (jj_scan_token(LTNALLCAPS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_277()) {
    jj_scanpos = xsp;
    if (jj_3R_278()) return true;
    }
    return false;
  }

  private boolean jj_3R_333() {
    if (jj_3R_67()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_344()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_255() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_scan_token(LEFT)) return true;
    if (jj_3R_153()) return true;
    if (jj_3R_154()) return true;
    if (jj_scan_token(RIGHT)) return true;
    if (jj_3R_153()) return true;
    return false;
  }

  private boolean jj_3R_280() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_235() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_215()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_67() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_324() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_254() {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_237() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_254()) {
    jj_scanpos = xsp;
    if (jj_3R_255()) return true;
    }
    return false;
  }

  private boolean jj_3R_279() {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_177() {
    if (jj_scan_token(SQRT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_235()) jj_scanpos = xsp;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_232() {
    if (jj_scan_token(TEXTCIRCLED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_279()) {
    jj_scanpos = xsp;
    if (jj_3R_280()) return true;
    }
    return false;
  }

  private boolean jj_3R_178() {
    if (jj_scan_token(FRAC)) return true;
    if (jj_3R_236()) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_348() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_215()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_349() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_276() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_275() {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_343() {
    if (jj_scan_token(NEWLINE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_348()) jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    xsp = jj_scanpos;
    if (jj_3R_349()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_227() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) return true;
    }
    return false;
  }

  private boolean jj_3R_342() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_341() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_332() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_341()) jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    xsp = jj_scanpos;
    if (jj_3R_342()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_343()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_310() {
    if (jj_scan_token(BEG)) return true;
    if (jj_scan_token(ENVNAME)) return true;
    if (jj_scan_token(ENVEND)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_323()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_324()) jj_scanpos = xsp;
    if (jj_3R_206()) return true;
    if (jj_scan_token(END)) return true;
    if (jj_scan_token(ENVNAME)) return true;
    if (jj_scan_token(ENVEND)) return true;
    return false;
  }

  private boolean jj_3R_282() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_323() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_333()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_281() {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_211() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_215()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_212() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_234() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3R_282()) return true;
    }
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_scan_token(NEWLINE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_211()) jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    xsp = jj_scanpos;
    if (jj_3R_212()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_165() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_274() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_143() {
    if (jj_scan_token(ENGLISHLETTER)) return true;
    return false;
  }

  private boolean jj_3R_151() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_226() {
    if (jj_scan_token(TEXTBF)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_273()) {
    jj_scanpos = xsp;
    if (jj_3R_274()) return true;
    }
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_scan_token(BEGINSPLIT)) return true;
    if (jj_3R_150()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_152()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDSPLIT)) return true;
    return false;
  }

  private boolean jj_3R_164() {
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_362() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_283()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_170() {
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3R_145() {
    if (jj_scan_token(NEWLINE)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_176() {
    if (jj_3R_234()) return true;
    return false;
  }

  private boolean jj_3R_363() {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_scan_token(129)) return true;
    if (jj_scan_token(LCB)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_143()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    if (jj_3R_144()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_145()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(130)) return true;
    return false;
  }

  private boolean jj_3R_163() {
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_266() {
    if (jj_scan_token(LCB)) return true;
    Token xsp;
    if (jj_3R_363()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_363()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_175() {
    if (jj_3R_233()) return true;
    return false;
  }

  private boolean jj_3R_169() {
    if (jj_3R_227()) return true;
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_148() {
    if (jj_3R_154()) return true;
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_3R_206()) return true;
    return false;
  }

  private boolean jj_3R_162() {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_220() {
    if (jj_scan_token(REF)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_3R_266()) return true;
    }
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_174() {
    if (jj_3R_232()) return true;
    return false;
  }

  private boolean jj_3R_149() {
    if (jj_scan_token(CR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_207()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_168() {
    if (jj_3R_226()) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_scan_token(CASES)) return true;
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_148()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_149()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_161() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_262() {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_173() {
    if (jj_3R_231()) return true;
    return false;
  }

  private boolean jj_3R_231() {
    if (jj_scan_token(NEWCOMMAND)) return true;
    if (jj_scan_token(LCB)) return true;
    if (jj_scan_token(COMMAND)) return true;
    if (jj_scan_token(RCB)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_362()) jj_scanpos = xsp;
    if (jj_scan_token(LCB)) return true;
    return false;
  }

  private boolean jj_3R_245() {
    if (jj_scan_token(LCB)) return true;
    Token xsp;
    if (jj_3R_262()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_262()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_244() {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3R_160() {
    if (jj_3R_219()) return true;
    return false;
  }

  private boolean jj_3R_167() {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_136() {
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3R_210() {
    if (jj_scan_token(LABEL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) return true;
    }
    return false;
  }

  private boolean jj_3R_172() {
    if (jj_3R_230()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_scan_token(NEWLINE)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_131() {
    if (jj_3R_193()) return true;
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_3R_229()) return true;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_scan_token(BEGINPMATRIX)) return true;
    if (jj_3R_144()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_147()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDPMATRIX)) return true;
    return false;
  }

  private boolean jj_3R_166() {
    if (jj_3R_224()) return true;
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_3R_197()) return true;
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_3R_218()) return true;
    return false;
  }

  private boolean jj_3R_219() {
    if (jj_scan_token(INDEX)) return true;
    if (jj_3R_237()) return true;
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_3R_185()) return true;
    return false;
  }

  private boolean jj_3R_126() {
    if (jj_3R_188()) return true;
    return false;
  }

  private boolean jj_3R_241() {
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_3R_192()) return true;
    return false;
  }

  private boolean jj_3R_146() {
    if (jj_scan_token(NEWLINE)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_scan_token(BEGINCASES)) return true;
    if (jj_3R_144()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_146()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDCASES)) return true;
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_3R_201()) return true;
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_scan_token(INLINEMATH)) return true;
    if (jj_3R_216()) return true;
    if (jj_scan_token(INLINEMATH)) return true;
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_243() {
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_205() {
    if (jj_scan_token(AMPERSAND)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_241()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_144() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_204()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_205()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_3R_191()) return true;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_320() {
    if (jj_3R_332()) return true;
    return false;
  }

  private boolean jj_3R_138() {
    if (jj_3R_200()) return true;
    return false;
  }

  private boolean jj_3R_125() {
    if (jj_3R_187()) return true;
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_3R_181()) return true;
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_209() {
    if (jj_scan_token(AMPERSAND)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_243()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_319() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) return true;
    }
    if (jj_3R_216()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) return true;
    }
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_3R_178()) return true;
    return false;
  }

  private boolean jj_3R_208() {
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_150() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_208()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_209()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_306() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_319()) {
    jj_scanpos = xsp;
    if (jj_3R_320()) return true;
    }
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_scan_token(COMMAND)) return true;
    return false;
  }

  private boolean jj_3R_140() {
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3R_137() {
    if (jj_3R_199()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_scan_token(SUP)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_113() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) {
    jj_scanpos = xsp;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_3R_194()) return true;
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_3R_190()) return true;
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_3R_186()) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_scan_token(SUB)) return true;
    if (jj_3R_63()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_91()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_3R_177()) return true;
    return false;
  }

  private boolean jj_3R_318() {
    if (jj_3R_331()) return true;
    if (jj_3R_206()) return true;
    return false;
  }

  private boolean jj_3R_96() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) {
    jj_scanpos = xsp;
    if (jj_3R_118()) {
    jj_scanpos = xsp;
    if (jj_3R_119()) {
    jj_scanpos = xsp;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) {
    jj_scanpos = xsp;
    if (jj_3R_126()) {
    jj_scanpos = xsp;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) {
    jj_scanpos = xsp;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) {
    jj_scanpos = xsp;
    if (jj_3R_138()) {
    jj_scanpos = xsp;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_233() {
    if (jj_scan_token(PARAM)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(SUP)) return true;
    if (jj_3R_63()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_90()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_scan_token(SUB)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_scan_token(SUP)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_305() {
    if (jj_scan_token(BEGINDESCRIPTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_318()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDDESCRIPTION)) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_scan_token(SUB)) return true;
    if (jj_3R_63()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_110()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_scan_token(SUB)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_330() {
    if (jj_scan_token(NEWLINE)) return true;
    return false;
  }

  private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) return true;
    }
    return false;
  }

  private boolean jj_3_2() {
    if (jj_scan_token(NEWLINE)) return true;
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_scan_token(SUP)) return true;
    if (jj_3R_63()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_109()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_329() {
    if (jj_scan_token(NEWLINE)) return true;
    return false;
  }

  private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) return true;
    }
    return false;
  }

  private boolean jj_3R_315() {
    if (jj_scan_token(BEGINTABBING)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_329()) jj_scanpos = xsp;
    if (jj_3R_47()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_2()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_330()) jj_scanpos = xsp;
    if (jj_scan_token(ENDTABBING)) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_scan_token(SUP)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_scan_token(SUB)) return true;
    if (jj_3R_59()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_82()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_218() {
    if (jj_scan_token(TEXTLATIN)) return true;
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_scan_token(SUB)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_3R_63()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_64()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) return true;
    }
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_scan_token(MULTICOLUMN)) return true;
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_261()) return true;
    if (jj_scan_token(RCB)) return true;
    if (jj_3R_237()) return true;
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_scan_token(SUP)) return true;
    if (jj_3R_59()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_81()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_347() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_358() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_249() {
    if (jj_3R_283()) return true;
    return false;
  }

  private boolean jj_3R_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    }
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_scan_token(SUP)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_346() {
    if (jj_scan_token(AMPERSAND)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_358()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_338() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_346()) {
    jj_scanpos = xsp;
    if (jj_3R_347()) return true;
    }
    return false;
  }

  private boolean jj_3R_326() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) return true;
    }
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_scan_token(SUB)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3_1() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) return true;
    }
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_scan_token(SUB)) return true;
    if (jj_3R_59()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_107()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_327() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_1()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_338()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_206()) return true;
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_60() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) return true;
    }
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_scan_token(SUP)) return true;
    if (jj_3R_59()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_106()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_328() {
    if (jj_scan_token(NEWLINE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(77)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_327()) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_3R_59()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_60()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_314() {
    if (jj_scan_token(BEGINTABULAR)) return true;
    if (jj_scan_token(LCB)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_326()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(77)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_327()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_328()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDTABULAR)) return true;
    return false;
  }

  private boolean jj_3R_287() {
    if (jj_3R_217()) return true;
    return false;
  }

  private boolean jj_3R_261() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_287()) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_48() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    }
    return false;
  }

  private boolean jj_3R_157() {
    if (jj_3R_217()) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_111() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_68() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) return true;
    }
    return false;
  }

  private boolean jj_3R_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_217() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_3R_249()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_283() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) return true;
    }
    return false;
  }

  private boolean jj_3R_288() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) return true;
    }
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_scan_token(DELIMITERSIZEMODIFIER)) return true;
    if (jj_3R_153()) return true;
    return false;
  }

  private boolean jj_3R_153() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_313() {
    if (jj_scan_token(BEGINVERBATIM)) return true;
    return false;
  }

  private boolean jj_3R_195() {
    if (jj_scan_token(STACKREL)) return true;
    if (jj_3R_236()) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_214() {
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_156() {
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_215()) return true;
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_198() {
    if (jj_scan_token(GRAVE)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_155() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_3R_214()) return true;
    }
    return false;
  }

  private boolean jj_3R_197() {
    if (jj_scan_token(ACUTE)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_108() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_155()) {
    jj_scanpos = xsp;
    if (jj_3R_156()) return true;
    }
    return false;
  }

  private boolean jj_3R_253() {
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_154()) return true;
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_196() {
    if (jj_scan_token(CHECK)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_229() {
    if (jj_scan_token(VERB)) return true;
    return false;
  }

  private boolean jj_3R_194() {
    if (jj_scan_token(BAR)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_284() {
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3R_317() {
    if (jj_3R_331()) return true;
    if (jj_3R_206()) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_scan_token(WIDETILDE)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_304() {
    if (jj_scan_token(BEGINITEMIZE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_317()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDITEMIZE)) return true;
    return false;
  }

  private boolean jj_3R_252() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_3R_284()) return true;
    }
    return false;
  }

  private boolean jj_3R_191() {
    if (jj_scan_token(LENQNO)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_236() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_252()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) return true;
    }
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_scan_token(PARAM)) return true;
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_142() {
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_154()) return true;
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_316() {
    if (jj_3R_331()) return true;
    if (jj_3R_206()) return true;
    return false;
  }

  private boolean jj_3R_303() {
    if (jj_scan_token(BEGINENUMERATE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_316()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDENUMERATE)) return true;
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_scan_token(SUP)) return true;
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_3R_288()) return true;
    return false;
  }

  private boolean jj_3R_203() {
    if (jj_3R_240()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public LatexTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[152];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x3000,0x33000,0x0,0xf3000,0xf3000,0xfc308000,0x0,0x33000,0xd3000,0xd3000,0x13000,0x13000,0x0,0x13000,0x13000,0xd3000,0xd3000,0x0,0x0,0x4000000,0xf3000,0xfc7fb000,0xfc7fb000,0xfc7fb000,0xfc7fb000,0xfc7fb180,0xfc7fb180,0xfc7fb180,0xfc7fb180,0x80,0x80,0x33000,0x33000,0x0,0x33000,0xfeb08080,0x33000,0x33000,0x0,0x33000,0xfeb08080,0x100,0xf3080,0xf3080,0x4f3080,0x4f3080,0x0,0x4000000,0x0,0x0,0x0,0x0,0x10000,0x10000,0x0,0x0,0x0,0xfc7fb000,0x0,0xfc7fb000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf3000,0xf3000,0xf3000,0xf3000,0xf3000,0x0,0xf3000,0xc0000000,0xf3000,0xf3000,0xf3000,0xf3000,0xf3000,0x0,0xf3000,0xf3000,0xf3000,0xf3000,0x4000000,0x0,0x4000000,0x0,0x4000000,0x4000000,0x4000000,0xf3000,0xf3000,0xf3000,0xf3000,0xf3000,0xf3000,0xf3000,0xf3000,0xf3000,0xf3000,0xfb000,0xf3000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfb000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf3000,0x0,0xfb000,0x0,0xfb000,0xfb000,0x0,0xfb000,0x0,0x0,0x0,0x0,0xfb000,0x10000,0x0,0x4000000,0x0,0x0,0x4000000,0x0,0x4000000,0x4000000,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f,0x1f,0x1f,0x1f,0xb01551bf,0xb01551bf,0xb01551bf,0xb01551bf,0x0,0x0,0x0,0x0,0x0,0x0,0x1f,0x0,0x0,0x0,0x0,0x1f,0xb01551a0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f,0x0,0x1f,0x0,0x0,0x0,0x0,0xa0,0xc0,0xa0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1400000,0x0,0x1400000,0x1400000,0x0,0x1400000,0x0,0x0,0x0,0x0,0x1400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18001e80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18001e80,0x18001e80,0x18001e80,0x18001e80,0x18001ea8,0x18001ea8,0x18001ea8,0x18001ea8,0x0,0x0,0x0,0x0,0x0,0x0,0x18001e80,0x0,0x0,0x0,0x0,0x18001e80,0x28,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x2000,0x0,0x2000,0x18005e80,0x4000,0x18001e80,0x4000,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf7f70082,0xf7f70080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf7f70082,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf7f70080,0xf7f30080,0xf7f70082,0x0,0xf7f70082,0xf7f70082,0x0,0xf7f70082,0x0,0x0,0x0,0x0,0xf7f70082,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf00000,0x4000000,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x18300000,0x300000,0x0,0x100000,0x18000000,0x100000,0x1100000,0x80000000,0x8000000,0x100000,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0xa000000,0x8000000,0x0,0x2100000,0x82100000,0x82100000,0x9a100000,0x9a100000,0xda100000,0xda100000,0xda100000,0xda100000,0x0,0x40000000,0x0,0x0,0x8000000,0x100000,0x80000000,0x0,0x0,0x8000000,0x100000,0x80000000,0x0,0xdfb80000,0xdfb80000,0xdfb80000,0xdfb80000,0x8000000,0x0,0x400,0x8000000,0x0,0x0,0x100000,0x100000,0x0,0x40000000,0x0,0x9a100000,0x20000000,0x9a100000,0x20000000,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x1100000,0x3100000,0x1100000,0x3100000,0x2100000,0x0,0x2100000,0x0,0x2100000,0x2100000,0x2100000,0x1100000,0x1100000,0x0,0x1100000,0x3100000,0x1100000,0x3100000,0x0,0x8000000,0x0,0x8000000,0x0,0x0,0x0,0x18380000,0x380000,0x98380000,0x9a380000,0x98380000,0x9a380000,0x80380000,0x82380000,0x80380000,0x82380000,0x9a7ff9ff,0x827ff8ff,0x1000000,0x800000,0x1800000,0x1800000,0x1000000,0x800000,0x1800000,0x9bfff9ff,0x1000000,0x800000,0x1800000,0x1800000,0x1000000,0x800000,0x1800000,0x83fff8ff,0x7f8ff,0x9bfff9ff,0x20000000,0x9bfff9ff,0x9bfff9ff,0x20000000,0x9bfff9ff,0x40000000,0x40000000,0x40000000,0x200,0x9bfff9ff,0x0,0x40000000,0x0,0x40000000,0x8000000,0x0,0x0,0x0,0x0,0x40000000,0x8000000,0x0,0x0,0x8000000,0x0,0x4,0x1000000,0x800000,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x1,0x1,0x1,0x79,0x79,0x79,0x79,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x78,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x78,0x0,0x0,0x0,0x0,0x1,0x0,0x1,0x0,0x1,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x2,0x0,0x2,0x2,0x0,0x2,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x78,0x0,0x0,0x0,0x0,0x0,0x780,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[4];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public Latex(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public Latex(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new LatexTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 152; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 152; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public Latex(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new LatexTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 152; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 152; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public Latex(LatexTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 152; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(LatexTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 152; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[139];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 152; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 139; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 4; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
