/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.texplate.util;

import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/islandoftex/texplate/util/MessageUtils;", "", "()V", "VERSION", "", "WIDTH", "", "drawLogo", "", "error", "throwable", "", "line", "message", "status", "result", "", "texplate"})
public final class MessageUtils {
    private static final int WIDTH = 60;
    private static final String VERSION;
    public static final MessageUtils INSTANCE;

    @JvmStatic
    public static final void line(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        String string = StringsKt.padEnd(message + ' ', 51, '.') + " ";
        boolean bl = false;
        System.out.print((Object)string);
    }

    @JvmStatic
    public static final void status(boolean result) {
        String string = result ? "[ DONE ]" : "[FAILED]";
        boolean bl = false;
        System.out.println((Object)string);
    }

    @JvmStatic
    public static final void error(@NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull(throwable, "throwable");
        String string = "\n" + StringsKt.padEnd("HOUSTON, WE'VE GOT A PROBLEM ", 60, '-') + "\n" + throwable.getMessage() + "\n" + StringsKt.padStart("", 60, '-') + "\n";
        boolean bl = false;
        System.out.println((Object)string);
    }

    public final void drawLogo() {
        String string = " ______         __   __          ___             __             \n/\\__  _\\       /\\ \\ /\\ \\        /\\_ \\           /\\ \\__          \n\\/_/\\ \\/    __ \\ `\\`\\/'/'  _____\\//\\ \\      __  \\ \\ ,_\\    __   \n   \\ \\ \\  /'__`\\`\\/ > <   /\\ '__`\\\\ \\ \\   /'__`\\ \\ \\ \\/  /'__`\\ \n    \\ \\ \\/\\  __/   \\/'/\\`\\\\ \\ \\L\\ \\\\_\\ \\_/\\ \\L\\.\\_\\ \\ \\_/\\  __/ \n     \\ \\_\\ \\____\\  /\\_\\\\ \\_\\ \\ ,__//\\____\\ \\__/.\\_\\\\ \\__\\ \\____\\\n      \\/_/\\/____/  \\/_/ \\/_/\\ \\ \\/ \\/____/\\/__/\\/_/ \\/__/\\/____/\n                             \\ \\_\\                              \n                              \\/_/                              \n";
        boolean bl = false;
        System.out.println((Object)string);
        StringBuilder stringBuilder = new StringBuilder().append("TeXplate ").append(VERSION).append(", a document structure creation tool\n").append("Copyright (c) ");
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkExpressionValueIsNotNull(localDate, "LocalDate.now()");
        string = stringBuilder.append(localDate.getYear()).append(", Island of TeX\n").append("All rights reserved.\n").toString();
        bl = false;
        System.out.println((Object)string);
    }

    private MessageUtils() {
    }

    static {
        MessageUtils messageUtils;
        INSTANCE = messageUtils = new MessageUtils();
        Package package_ = MessageUtils.class.getPackage();
        Intrinsics.checkExpressionValueIsNotNull(package_, "MessageUtils::class.java.`package`");
        String string = package_.getImplementationVersion();
        if (string == null) {
            string = "DEVELOPMENT BUILD";
        }
        VERSION = string;
    }
}

