/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicKind;
import kotlinx.serialization.PrimitiveKind;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.UnionKind;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementsKt;
import kotlinx.serialization.json.JsonInput;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonOutput;
import kotlinx.serialization.json.internal.TreeJsonInputKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a%\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\bH\u0000\u00a2\u0006\u0002\u0010\t\u001a<\u0010\n\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0005*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00050\r2\u0006\u0010\u000e\u001a\u0002H\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010H\u0080\b\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"checkKind", "", "kind", "Lkotlinx/serialization/SerialKind;", "decodeSerializableValuePolymorphic", "T", "Lkotlinx/serialization/json/JsonInput;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/json/JsonInput;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "encodePolymorphically", "Lkotlinx/serialization/json/JsonOutput;", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "ifPolymorphic", "Lkotlin/Function0;", "(Lkotlinx/serialization/json/JsonOutput;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "kotlinx-serialization-runtime"})
public final class PolymorphicKt {
    public static final <T> void encodePolymorphically(@NotNull JsonOutput $this$encodePolymorphically, @NotNull SerializationStrategy<? super T> serializer2, T value2, @NotNull Function0<Unit> ifPolymorphic) {
        int $i$f$encodePolymorphically = 0;
        Intrinsics.checkParameterIsNotNull($this$encodePolymorphically, "$this$encodePolymorphically");
        Intrinsics.checkParameterIsNotNull(serializer2, "serializer");
        Intrinsics.checkParameterIsNotNull(ifPolymorphic, "ifPolymorphic");
        if (!(serializer2 instanceof AbstractPolymorphicSerializer) || $this$encodePolymorphically.getJson().configuration.useArrayPolymorphism) {
            serializer2.serialize($this$encodePolymorphically, value2);
            return;
        }
        AbstractPolymorphicSerializer cfr_ignored_0 = (AbstractPolymorphicSerializer)serializer2;
        T t = value2;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
        }
        KSerializer<T> kSerializer = ((AbstractPolymorphicSerializer)serializer2).findPolymorphicSerializer($this$encodePolymorphically, t);
        if (kSerializer == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
        }
        KSerializer<T> actualSerializer = kSerializer;
        SerialKind kind = actualSerializer.getDescriptor().getKind();
        PolymorphicKt.checkKind(kind);
        ifPolymorphic.invoke();
        actualSerializer.serialize($this$encodePolymorphically, value2);
    }

    public static final void checkKind(@NotNull SerialKind kind) {
        Intrinsics.checkParameterIsNotNull(kind, "kind");
        if (kind instanceof UnionKind.ENUM_KIND) {
            String string = "Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonConfiguration.useArrayPolymorphism' instead";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (kind instanceof PrimitiveKind) {
            String string = "Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonConfiguration.useArrayPolymorphism' instead";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (kind instanceof PolymorphicKind) {
            String string = "Actual serializer for polymorphic cannot be polymorphic itself";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public static final <T> T decodeSerializableValuePolymorphic(@NotNull JsonInput $this$decodeSerializableValuePolymorphic, @NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkParameterIsNotNull($this$decodeSerializableValuePolymorphic, "$this$decodeSerializableValuePolymorphic");
        Intrinsics.checkParameterIsNotNull(deserializer, "deserializer");
        if (!(deserializer instanceof AbstractPolymorphicSerializer) || $this$decodeSerializableValuePolymorphic.getJson().configuration.useArrayPolymorphism) {
            return deserializer.deserialize($this$decodeSerializableValuePolymorphic);
        }
        JsonElement obj$iv = $this$decodeSerializableValuePolymorphic.decodeJson();
        boolean $i$f$cast = false;
        boolean bl = obj$iv instanceof JsonObject;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " but found " + Reflection.getOrCreateKotlinClass(obj$iv.getClass());
            throw (Throwable)new IllegalStateException(string.toString());
        }
        JsonElement jsonElement = obj$iv;
        if (jsonElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
        }
        JsonObject jsonTree = (JsonObject)jsonElement;
        String type2 = JsonElementsKt.getContent((JsonElement)MapsKt.getValue(jsonTree, $this$decodeSerializableValuePolymorphic.getJson().configuration.classDiscriminator));
        Map<String, JsonElement> map2 = jsonTree.getContent();
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlinx.serialization.json.JsonElement>");
        }
        TypeIntrinsics.asMutableMap(map2).remove($this$decodeSerializableValuePolymorphic.getJson().configuration.classDiscriminator);
        KSerializer kSerializer = ((AbstractPolymorphicSerializer)deserializer).findPolymorphicSerializer($this$decodeSerializableValuePolymorphic, type2);
        if (kSerializer == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
        }
        KSerializer actualSerializer = kSerializer;
        return TreeJsonInputKt.readJson($this$decodeSerializableValuePolymorphic.getJson(), jsonTree, actualSerializer);
    }
}

