/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.io.ByteBuffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkotlinx/serialization/internal/HexConverter;", "", "()V", "hexCode", "", "hexToInt", "", "ch", "", "parseHexBinary", "", "s", "printHexBinary", "data", "lowerCase", "", "toHexString", "n", "kotlinx-serialization-runtime"})
public final class HexConverter {
    private static final String hexCode = "0123456789ABCDEF";
    public static final HexConverter INSTANCE;

    @NotNull
    public final byte[] parseHexBinary(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        int len = s.length();
        boolean bl = len % 2 == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "HexBinary string must be even length";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = this.hexToInt(s.charAt(i));
            int l = this.hexToInt(s.charAt(i + 1));
            boolean bl5 = h != -1 && l != -1;
            boolean bl6 = false;
            boolean bl7 = false;
            if (!bl5) {
                boolean bl8 = false;
                String string = "Invalid hex chars: " + s.charAt(i) + s.charAt(i + 1);
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bytes[i / 2] = (byte)((h << 4) + l);
        }
        return bytes;
    }

    private final int hexToInt(char ch) {
        char c = ch;
        char c2 = c;
        return '0' <= c2 && '9' >= c2 ? ch - 48 : ('A' <= (c2 = c) && 'F' >= c2 ? ch - 65 + 10 : ('a' <= (c2 = c) && 'f' >= c2 ? ch - 97 + 10 : -1));
    }

    @NotNull
    public final String printHexBinary(@NotNull byte[] data2, boolean lowerCase) {
        String string;
        Intrinsics.checkParameterIsNotNull(data2, "data");
        StringBuilder r = new StringBuilder(data2.length * 2);
        for (byte b : data2) {
            r.append(hexCode.charAt(b >> 4 & 0xF));
            r.append(hexCode.charAt(b & 0xF));
        }
        if (lowerCase) {
            String string2 = r.toString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "r.toString()");
            String string3 = string2;
            int n = 0;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.String).toLowerCase()");
        } else {
            String string6 = r.toString();
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull(string6, "r.toString()");
        }
        return string;
    }

    public static /* synthetic */ String printHexBinary$default(HexConverter hexConverter, byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return hexConverter.printHexBinary(byArray, bl);
    }

    @NotNull
    public final String toHexString(int n) {
        String string = StringsKt.trimStart(this.printHexBinary(ByteBuffer.Companion.allocate(4).putInt(n).flip().array(), true), '0');
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        String string2 = charSequence.length() > 0 ? string : null;
        if (string2 == null) {
            string2 = "0";
        }
        return string2;
    }

    private HexConverter() {
    }

    static {
        HexConverter hexConverter;
        INSTANCE = hexConverter = new HexConverter();
    }
}

