/*
 * Decompiled with CFR 0.152.
 */
package com.uchuhimo.konf.source.base;

import com.uchuhimo.konf.Feature;
import com.uchuhimo.konf.TreeNode;
import com.uchuhimo.konf.UtilsKt;
import com.uchuhimo.konf.source.Source;
import com.uchuhimo.konf.source.SourceInfo;
import com.uchuhimo.konf.source.SourceKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/uchuhimo/konf/source/base/ValueSource;", "Lcom/uchuhimo/konf/source/Source;", "value", "", "type", "", "info", "Lcom/uchuhimo/konf/source/SourceInfo;", "(Ljava/lang/Object;Ljava/lang/String;Lcom/uchuhimo/konf/source/SourceInfo;)V", "getInfo", "()Lcom/uchuhimo/konf/source/SourceInfo;", "tree", "Lcom/uchuhimo/konf/TreeNode;", "getTree", "()Lcom/uchuhimo/konf/TreeNode;", "getValue", "()Ljava/lang/Object;", "konf-core"})
public class ValueSource
implements Source {
    @NotNull
    private final TreeNode tree;
    @NotNull
    private final Object value;
    @NotNull
    private final SourceInfo info;

    @Override
    @NotNull
    public TreeNode getTree() {
        return this.tree;
    }

    @NotNull
    public final Object getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public final SourceInfo getInfo() {
        return this.info;
    }

    public ValueSource(@NotNull Object value2, @NotNull String type2, @NotNull SourceInfo info) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(info, "info");
        this.value = value2;
        this.info = info;
        ((Map)this.info).put("type", UtilsKt.notEmptyOr(type2, "value"));
        this.tree = SourceKt.asTree(this.value);
    }

    public /* synthetic */ ValueSource(Object object, String string, SourceInfo sourceInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            sourceInfo = new SourceInfo(null, 1, null);
        }
        this(object, string, sourceInfo);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Source.DefaultImpls.getDescription(this);
    }

    @Override
    @NotNull
    public Map<Feature, Boolean> getFeatures() {
        return Source.DefaultImpls.getFeatures(this);
    }

    @Override
    public boolean contains(@NotNull List<String> path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return Source.DefaultImpls.contains((Source)this, path);
    }

    @Override
    public boolean contains(@NotNull String prefix2) {
        Intrinsics.checkParameterIsNotNull(prefix2, "prefix");
        return Source.DefaultImpls.contains((Source)this, prefix2);
    }

    @Override
    @Nullable
    public Source getOrNull(@NotNull List<String> path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return Source.DefaultImpls.getOrNull((Source)this, path);
    }

    @Override
    @Nullable
    public Source getOrNull(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return Source.DefaultImpls.getOrNull((Source)this, path);
    }

    @Override
    @NotNull
    public Source get(@NotNull List<String> path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return Source.DefaultImpls.get((Source)this, path);
    }

    @Override
    @NotNull
    public Source get(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return Source.DefaultImpls.get((Source)this, path);
    }

    @Override
    @NotNull
    public Source withPrefix(@NotNull List<String> prefix2) {
        Intrinsics.checkParameterIsNotNull(prefix2, "prefix");
        return Source.DefaultImpls.withPrefix((Source)this, prefix2);
    }

    @Override
    @NotNull
    public Source withPrefix(@NotNull String prefix2) {
        Intrinsics.checkParameterIsNotNull(prefix2, "prefix");
        return Source.DefaultImpls.withPrefix((Source)this, prefix2);
    }

    @Override
    @NotNull
    public Source withFallback(@NotNull Source fallback) {
        Intrinsics.checkParameterIsNotNull(fallback, "fallback");
        return Source.DefaultImpls.withFallback(this, fallback);
    }

    @Override
    @NotNull
    public Source plus(@NotNull Source facade) {
        Intrinsics.checkParameterIsNotNull(facade, "facade");
        return Source.DefaultImpls.plus(this, facade);
    }

    @Override
    @NotNull
    public Source substituted(boolean errorWhenUndefined) {
        return Source.DefaultImpls.substituted(this, errorWhenUndefined);
    }

    @Override
    @NotNull
    public Source enabled(@NotNull Feature feature) {
        Intrinsics.checkParameterIsNotNull((Object)feature, "feature");
        return Source.DefaultImpls.enabled(this, feature);
    }

    @Override
    @NotNull
    public Source disabled(@NotNull Feature feature) {
        Intrinsics.checkParameterIsNotNull((Object)feature, "feature");
        return Source.DefaultImpls.disabled(this, feature);
    }

    @Override
    public boolean isEnabled(@NotNull Feature feature) {
        Intrinsics.checkParameterIsNotNull((Object)feature, "feature");
        return Source.DefaultImpls.isEnabled(this, feature);
    }
}

