/*
 * TEMPO - Topographic Eeg Mapping PrOgram.
 * 
 * Copyright (C) 1995, 1996, 2003, 2004 Aleksandar B. Samardzic
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef signal_h
#define signal_h

#include <stdio.h>

/* Signal object data type. */
typedef struct {
	FILE           *file;	/* Input file. */
	char           *label;	/* Signal name. */
	char           *transducer;	/* Signal transducer type. */
	float           unit;	/* Physical dimension. */
	float           physical_lo, physical_hi;	/* Physical minimum and
							 * maximum. */
	int             digital_lo, digital_hi;	/* Digital minimum and
						 * maximum. */
	char           *prefiltering;	/* Prefiltering indicator. */
	int             count;	/* Number of samples in each data record. */
	float           c0, c1;	/* Coefficients for conversion from digital
				 * to physical signal value. */
	int             offset;	/* Offset of first signal sample in input
				 * file. */
	int             skip;	/* Number of bytes to skip between two
				 * successive signal data records. */
}               Signal;

/* Create signal object. */
Signal         *signal_create();

/* Destroy signal object. */
void            signal_destroy(Signal * signal);

/*
 * Read signal description from input file.  First arugment is signal object,
 * second argument is filename of input file and third argument is signal
 * number in this file.
 */
void            signal_load_edf(Signal * signal, char *name, int number);

/*
 * Read set of signal values.  First argument is signal object, second
 * argument is position to read data from, third argument is number of values
 * to be read and fourth argument is vector to store read values to.
 */
void            signal_values(Signal * signal, int from, int count, float *values);

#endif
