/*
 * TEMPO - Topographic Eeg Mapping PrOgram.
 * 
 * Copyright (C) 1995, 1996, 2003, 2004 Aleksandar B. Samardzic
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef interpolation_h
#define interpolation_h

#include "input.h"
#include "object.h"
#include "sensors.h"

/* Interpolation object data type. */
typedef struct {
	int             count;	/* Count of vertices to interpolate values
				 * over. */
	int            *indices;/* Indices of nearest sensors to each vertex. */
	float          *coefficients;	/* Interpolation coefficients for
					 * nearest sensors for each vertex. */
}               Interpolation;

/*
 * Create interpolation object.  First argument is model of object to be
 * interpolated values on, second argument is input object and thirs argument
 * is array with information about sensors.
 */
Interpolation  *interpolation_create(Object * object, Input * input, Sensors * sensors);

/* Destroy interpolation object. */
void            interpolation_destroy(Interpolation * interpolation);

/*
 * Map given value to color.  First argument is interpolation object, second
 * argument is value to be mapped, third and fourth arguments are mapping
 * interval boundaries and fifth argument is resulting color.
 */
void            interpolation_interpolate(Interpolation * interpolation, float value, float lo, float hi, Color color);

/*
 * For given set of score values, perform interpolation across all vertices
 * of given object.  First argument is interpolation object, second argument
 * is model of object, third argument is count of values, fourth argument is
 * array with values and fifth and sixth arguments are interpolation interval
 * boundaries.
 */
void            interpolation_process(Interpolation * interpolation, Object * object, int count, float *values, float lo, float hi);

#endif
