
#ifndef _PROCINFO_INCLUDED
#define	_PROCINFO_INCLUDED


#include <stdarg.h>




typedef struct _procinfo {
    int		mainpid;
    char	pidfile[200];

    char	statfile[200];
    FILE	*statfp;

    char	sessionfile[200];
    FILE	*sessionfp;
    int		havemessages;

    int		errorcode, errormode;
    char	errorhandler[200];
    unsigned long errortypes;
    } procinfo_t;


extern char statdir[200];
extern char sessiondir[200];

extern procinfo_t pi;


extern int init_procinfo(char *vp);
extern FILE *getstatfp(void);

extern int geterrcode(char *name);
extern int set_sessionmode(char *word, char *filename, int lineno);

char *set_exithandler(char *handler);
extern int set_exitcodes(int mask);
extern int run_errorhandler(int error);

extern int printerror(int rc, char *type, char *format, ...);

char *setpidfile(char *pidfile);

extern int cleanenv(char **envp);
extern int setvar(char *prefix, char *var, char *value);
extern int setnumvar(char *prefix, char *var, unsigned long value);

void exithandler(void);

#endif

