
/*

    File: acp.c

    Copyright (C) 2005  Wolfgang Zekoll  <wzk@quietsche-entchen.de>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <ctype.h>
#include <signal.h>
#include <wait.h>
#include <errno.h>
#include <time.h>



#include "lib.h"
#include "ip-lib.h"
#include "tcpproxy.h"




int cleanenv(char **envp)
{
	int	k, n;
	char	*p, **env;
	
	env = envp;
	n = 0;
	while (env[n] != NULL)
		n++;


	env = envp;
	k = 0;
	while (k < n  &&  *env != NULL) {
		char	var[800];

		p = *env;
		get_quoted(&p, '=', var, sizeof(var));
		unsetenv(var);
		k++;
		}
	
	if (*env != NULL  ||  k != n)
		printerror(1, "-ERR", "cleanenv error");

	return (0);
}

int setvar(char *prefix, char *var, char *value)
{
	char	varname[200];

	snprintf (varname, sizeof(varname) - 2, "%s%s", prefix, var);
	setenv(varname, value != NULL? value: "", 1);

	return (0);
}

int setnumvar(char *prefix, char *var, unsigned long val)
{
	char	strval[40];

	snprintf (strval, sizeof(strval) - 2, "%lu", val);
	setvar(prefix, var, strval);

	return (0);
}

int __xx_set_variables(proxy_t *x)
{

	return (0);
}


int run_acp(proxy_t *x)
{
	int	rc, pid, pfd[2];
	char	line[300];
	
	if (*x->acp == 0)
		return (0);

	rc = 0;
	if (pipe(pfd) != 0)
		printerror(1, "-ERR", "can't pipe, error= %s", strerror(errno));
	else if ((pid = fork()) < 0)
		printerror(1, "-ERR", "can't fork, error= %s", strerror(errno));
	else if (pid == 0) {
		int	argc;
		char	*argv[32];

		close(0);		/* Das acp kann nicht vom client lesen. */
		dup2(pfd[1], 2);	/* stderr wird vom parent gelesen. */
		close(pfd[0]);
/*		set_variables(x); */
		
		copy_string(line, x->acp, sizeof(line));
		argc = split(line, argv, ' ', 30);
		argv[argc] = NULL;
		execvp(argv[0], argv);

		printerror(1, "-ERR", "can't exec acp %s, error= %s", argv[0], strerror(errno));
		exit (1);
		}
	else {
		int	len;
		char	message[300];

		close(pfd[1]);
		*message = 0;
		if ((len = read(pfd[0], message, sizeof(message) - 2)) < 0)
			len = 0;

		message[len] = 0;
		noctrl(message);
		

		if (waitpid(pid, &rc, 0) < 0)
			printerror(1, "-ERR", "error while waiting for acp, error= %s", strerror(errno));

		rc = WIFEXITED(rc) != 0? WEXITSTATUS(rc): 1;
		if (*message == 0)
			copy_string(message, rc == 0? "access granted": "access denied", sizeof(message));

		if (rc == 0  &&  debug == 0)
			/* do nothing */ ;
		else if (*message != 0)
			printerror(0, "+INFO", "%s, rc= %d", message, rc);
		}
		
	return (rc);
}


	/*
	 * Connection translation taken from ftp.proxy -- 15SEP05wzk
	 */

static char *getvarname(char **here, char *var, int size)
{
	int	c, k;

	size = size - 2;
	k = 0;
	while ((c = **here) != 0) {
		*here += 1;
		if (c == ' '  ||  c == '\t'  ||  c == '=')
			break;

		if (k < size)
			var[k++] = c;
		}

	var[k] = 0;
	strupr(var);
	*here = skip_ws(*here);

	return (var);
}

int run_ctp(proxy_t *x)
{
	int	rc, pid, pfd[2];
	char	line[300];
	FILE	*fp;
	
	if (*x->ctp == 0)
		return (0);

	rc = 0;
	if (pipe(pfd) != 0)
		printerror(1, "-ERR", "can't pipe: %s", strerror(errno));
	else if ((pid = fork()) < 0)
		printerror(1, "-ERR", "can't fork: %s", strerror(errno));
	else if (pid == 0) {
		int	argc;
		char	*argv[32];

		close(0);		/* No stdin, ...
		dup2(pfd[1], 1);	 * ... stdout ...
		dup2(pfd[1], 2);	 * ... and stderr go to tcpproxy. */
		close(pfd[0]);
/*		set_variables(x); */
			
		copy_string(line, x->ctp, sizeof(line));
		argc = split(line, argv, ' ', 30);
		argv[argc] = NULL;
		execvp(argv[0], argv);

		printerror(1, "-ERR", "can't exec ctp %s: %s",
			argv[0], strerror(errno));
		}
	else {
		char	*p, var[80], line[300];

		close(pfd[1]);
		fp = fdopen(pfd[0], "r");
		while (fgets(line, sizeof(line), fp)) {
			p = skip_ws(noctrl(line));
			getvarname(&p, var, sizeof(var));

			if (strcmp(var, "SERVER") == 0)
				copy_string(x->server, p, sizeof(x->server));

			/*
			 * Enable the trp to send error messages.
			 */

			else if (strcmp(var, "-ERR") == 0  ||  strcmp(var, "-ERR:") == 0)
				printerror(1, "-ERR", "%s", skip_ws(p));
			else
				printerror(1, "-ERR", "unknown ctp response: %s", line);
			}

		fclose(fp);

		if (waitpid(pid, &rc, 0) < 0)
			printerror(1, "-ERR", "error while waiting for ctp: %s", strerror(errno));

		rc = WIFEXITED(rc) != 0? WEXITSTATUS(rc): 1;
		if (rc != 0)
			printerror(1, "-ERR", "ctp error code: %d", rc);
		}

	return (rc);
}

