/*
 * Copyright (C) 1998
 *	Sony Computer Science Laboratories Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY SONY CSL AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL SONY CSL OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: tcpdstat.h,v 1.6 2001/03/26 07:23:03 kjc Exp kjc $
 */

struct pkt_cnt {
	int	packets;
	long long bytes;
};

enum protos {
	TOTAL,
	  IP, 
	    TCP_IP,
	      FTPDATA_TCP,
	      FTP_TCP,
	      SSH_TCP,
	      TELNET_TCP,
	      SMTP_TCP,
	      NAME_TCP,
	      DNS_TCP,
	      HTTP_S_TCP,
	      HTTP_C_TCP,
	      KERB5_TCP,
	      POP3_TCP,
	      SUNRPC_TCP,
	      IDENT_TCP,
	      NNTP_TCP,
	      NTP_TCP,
	      EPMAP_TCP,
	      NETBIOS_NS_TCP,
	      NETBIOS_SSN_TCP,
	      IMAP_TCP,
	      BGP_TCP,
	      LDAP_TCP,
	      HTTPS_TCP,
	      MS_DS_TCP,
	      RLOGIN_TCP,
	      RTSP_TCP,
	      LDAPS_TCP,
	      SOCKS_TCP,
	      KAZAA_TCP,
	      MS_SQL_S_TCP,
	      SQUID_TCP,
	      MS_GC_TCP,
	      MS_GCS_TCP,
	      HOTLINE_TCP,
	      REALAUDIO_TCP,
	      SHOUTCAST_TCP,
	      GNU6346_TCP,
	      GNU6347_TCP,
	      GNU6348_TCP,
	      GNU6349_TCP,
	      GNU6350_TCP,
	      GNU6355_TCP,
	      IRC6666_TCP,
	      IRC6667_TCP,
	      IRC6668_TCP,
	      IRC6669_TCP,
	      NAPSTER_TCP,
	      IRC7000_TCP,
	      HTTP_A_TCP,
	      OTHER_TCP,
	    UDP_IP,
	      NAME_UDP,
	      DNS_UDP,
	      KERB5_UDP,
	      SUNRPC_UDP,
	      NTP_UDP,
	      EPMAP_UDP,
	      NETBIOS_NS_UDP,
	      NETBIOS_SSN_UDP,
	      MS_DS_UDP,
	      RIP_UDP,
	      KAZAA_UDP,
	      MS_SQL_S_UDP,
	      MCAST_UDP,
	      REALAUDIO_UDP,
	      HALFLIFE_UDP,
	      STARCRAFT_UDP,
	      EVERQUEST_UDP,
	      UNREAL_UDP,
	      QUAKE_UDP,
	      CUSEEME_UDP,
	      OTHER_UDP,
	    ICMP_IP,
	    IGMP_IP,
	    GGP_IP,
	    IP_IP,
	    ST_IP,
	    CBT_IP,
	    EGP_IP,
	    IGP_IP,
	    BBN_RCC_MON_IP,
	    NVP_IP,
	    PUP_IP,
	    ARGUS_IP,
	    EMCON_IP,
	    XNET_IP,
	    CHAOS_IP,
	    MUX_IP,
	    DCN_MEAS_IP,
	    HMP_IP,
	    PRM_IP,
	    XNS_IDP_IP,
	    TRUNK1_IP,
	    TRUNK2_IP,
	    LEAF1_IP,
	    LEAF2_IP,
	    RDP_IP,
	    IRTP_IP,
	    ISO_TP4_IP,
	    NETBLT_IP,
	    MFE_NSP_IP,
	    MERIT_INP_IP,
	    SEP_IP,
	    THREE_PC_IP,
	    IDPR_IP,
	    XTP_IP,
	    DDP_IP,
	    IDPR_CMTP_IP,
	    TPTP_IP,
	    IL_IP,
	    IP6_IP,
	    SDRP_IP,
	    IP6_RH_IP,
	    IP6_FH_IP,
	    IDRP_IP,
	    RSVP_IP,
	    GRE_IP,
	    MHRP_IP,
	    BNA_IP,
	    ESP_IP,
	    AH_IP,
	    I_NLSP_IP,
	    SWIPE_IP,
	    NARP_IP,
	    MOBILE_IP,
	    TLSP_IP,
	    SKIP_IP,
	    IP6_ICMP_IP,
	    IP6_NNH_IP,
	    IP6_OPTS_IP,
	    AHI_IP,
	    CFTP_IP,
	    ANY_LOCAL_IP,
	    SAT_EXPAK_IP,
	    KRYPTOLAN_IP,
	    RVD_IP,
	    IPPC_IP,
	    ANY_DIST_IP,
	    SAT_MON_IP,
	    VISA_IP,
	    IPCV_IP,
	    CPNX_IP,
	    CPHB_IP,
	    WSN_IP,
	    PVP_IP,
	    BR_SAT_MON_IP,
	    SUN_ND_IP,
	    WB_MON_IP,
	    WB_EXPAK_IP,
	    ISO_IP_IP,
	    VMTP_IP,
	    SECURE_VMTP_IP,
	    VINES_IP,
	    TTP_IP,
	    NSFNET_IGP_IP,
	    DGP_IP,
	    TCF_IP,
	    EIRGP_IP,
	    OSPFIGP_IP,
	    SPRITE_RPC_IP,
	    LARP_IP,
	    MTP_IP,
	    AX25_IP,
	    IPIP_IP,
	    MICP_IP,
	    SCC_SP_IP,
	    ETHERIP_IP,
	    ENCAP_IP,
	    ANY_ENCRYPT_IP,
	    GMTP_IP,
	    IFMP_IP,
	    PNMI_IP,
	    PIM_IP,
	    ARIS_IP,
	    SCPS_IP,
	    QNX_IP,
	    ACTIVE_NETWORKS_IP,
	    IPCOMP_IP,
	    SNP_IP,
	    COMPAQP_IP,
	    IPX_IP_IP,
	    VRRP_IP,
	    PGM_IP,
	    ANY_ZERO_IP,
	    L2TP_IP,
	    DDX_IP,
	    IATP_IP,
	    STP_IP,
	    SRP_IP,
	    UTI_IP,
	    SMP_IP,
	    SM_IP,
	    PTP_IP,
	    ISIS_IP_IP,
	    FIRE_IP,
	    CRTP_IP,
	    CRUDP_IP,
	    SSCOPMCE_IP,
	    IPLT_IP,
	    SPS_IP,
	    PIPE_IP,
	    SCTP_IP,
	    FC_IP,
	    UNASSIGNED_PROTO_134_IP,
	    UNASSIGNED_PROTO_135_IP,
	    UNASSIGNED_PROTO_136_IP,
	    UNASSIGNED_PROTO_137_IP,
	    UNASSIGNED_PROTO_138_IP,
	    UNASSIGNED_PROTO_139_IP,
	    UNASSIGNED_PROTO_140_IP,
	    UNASSIGNED_PROTO_141_IP,
	    UNASSIGNED_PROTO_142_IP,
	    UNASSIGNED_PROTO_143_IP,
	    UNASSIGNED_PROTO_144_IP,
	    UNASSIGNED_PROTO_145_IP,
	    UNASSIGNED_PROTO_146_IP,
	    UNASSIGNED_PROTO_147_IP,
	    UNASSIGNED_PROTO_148_IP,
	    UNASSIGNED_PROTO_149_IP,
	    UNASSIGNED_PROTO_150_IP,
	    UNASSIGNED_PROTO_151_IP,
	    UNASSIGNED_PROTO_152_IP,
	    UNASSIGNED_PROTO_153_IP,
	    UNASSIGNED_PROTO_154_IP,
	    UNASSIGNED_PROTO_155_IP,
	    UNASSIGNED_PROTO_156_IP,
	    UNASSIGNED_PROTO_157_IP,
	    UNASSIGNED_PROTO_158_IP,
	    UNASSIGNED_PROTO_159_IP,
	    UNASSIGNED_PROTO_160_IP,
	    UNASSIGNED_PROTO_161_IP,
	    UNASSIGNED_PROTO_162_IP,
	    UNASSIGNED_PROTO_163_IP,
	    UNASSIGNED_PROTO_164_IP,
	    UNASSIGNED_PROTO_165_IP,
	    UNASSIGNED_PROTO_166_IP,
	    UNASSIGNED_PROTO_167_IP,
	    UNASSIGNED_PROTO_168_IP,
	    UNASSIGNED_PROTO_169_IP,
	    UNASSIGNED_PROTO_170_IP,
	    UNASSIGNED_PROTO_171_IP,
	    UNASSIGNED_PROTO_172_IP,
	    UNASSIGNED_PROTO_173_IP,
	    UNASSIGNED_PROTO_174_IP,
	    UNASSIGNED_PROTO_175_IP,
	    UNASSIGNED_PROTO_176_IP,
	    UNASSIGNED_PROTO_177_IP,
	    UNASSIGNED_PROTO_178_IP,
	    UNASSIGNED_PROTO_179_IP,
	    UNASSIGNED_PROTO_180_IP,
	    UNASSIGNED_PROTO_181_IP,
	    UNASSIGNED_PROTO_182_IP,
	    UNASSIGNED_PROTO_183_IP,
	    UNASSIGNED_PROTO_184_IP,
	    UNASSIGNED_PROTO_185_IP,
	    UNASSIGNED_PROTO_186_IP,
	    UNASSIGNED_PROTO_187_IP,
	    UNASSIGNED_PROTO_188_IP,
	    UNASSIGNED_PROTO_189_IP,
	    UNASSIGNED_PROTO_190_IP,
	    UNASSIGNED_PROTO_191_IP,
	    UNASSIGNED_PROTO_192_IP,
	    UNASSIGNED_PROTO_193_IP,
	    UNASSIGNED_PROTO_194_IP,
	    UNASSIGNED_PROTO_195_IP,
	    UNASSIGNED_PROTO_196_IP,
	    UNASSIGNED_PROTO_197_IP,
	    UNASSIGNED_PROTO_198_IP,
	    UNASSIGNED_PROTO_199_IP,
	    UNASSIGNED_PROTO_200_IP,
	    UNASSIGNED_PROTO_201_IP,
	    UNASSIGNED_PROTO_202_IP,
	    UNASSIGNED_PROTO_203_IP,
	    UNASSIGNED_PROTO_204_IP,
	    UNASSIGNED_PROTO_205_IP,
	    UNASSIGNED_PROTO_206_IP,
	    UNASSIGNED_PROTO_207_IP,
	    UNASSIGNED_PROTO_208_IP,
	    UNASSIGNED_PROTO_209_IP,
	    UNASSIGNED_PROTO_210_IP,
	    UNASSIGNED_PROTO_211_IP,
	    UNASSIGNED_PROTO_212_IP,
	    UNASSIGNED_PROTO_213_IP,
	    UNASSIGNED_PROTO_214_IP,
	    UNASSIGNED_PROTO_215_IP,
	    UNASSIGNED_PROTO_216_IP,
	    UNASSIGNED_PROTO_217_IP,
	    UNASSIGNED_PROTO_218_IP,
	    UNASSIGNED_PROTO_219_IP,
	    UNASSIGNED_PROTO_220_IP,
	    UNASSIGNED_PROTO_221_IP,
	    UNASSIGNED_PROTO_222_IP,
	    UNASSIGNED_PROTO_223_IP,
	    UNASSIGNED_PROTO_224_IP,
	    UNASSIGNED_PROTO_225_IP,
	    UNASSIGNED_PROTO_226_IP,
	    UNASSIGNED_PROTO_227_IP,
	    UNASSIGNED_PROTO_228_IP,
	    UNASSIGNED_PROTO_229_IP,
	    UNASSIGNED_PROTO_230_IP,
	    UNASSIGNED_PROTO_231_IP,
	    UNASSIGNED_PROTO_232_IP,
	    UNASSIGNED_PROTO_233_IP,
	    UNASSIGNED_PROTO_234_IP,
	    UNASSIGNED_PROTO_235_IP,
	    UNASSIGNED_PROTO_236_IP,
	    UNASSIGNED_PROTO_237_IP,
	    UNASSIGNED_PROTO_238_IP,
	    UNASSIGNED_PROTO_239_IP,
	    UNASSIGNED_PROTO_240_IP,
	    UNASSIGNED_PROTO_241_IP,
	    UNASSIGNED_PROTO_242_IP,
	    UNASSIGNED_PROTO_243_IP,
	    UNASSIGNED_PROTO_244_IP,
	    UNASSIGNED_PROTO_245_IP,
	    UNASSIGNED_PROTO_246_IP,
	    UNASSIGNED_PROTO_247_IP,
	    UNASSIGNED_PROTO_248_IP,
	    UNASSIGNED_PROTO_249_IP,
	    UNASSIGNED_PROTO_250_IP,
	    UNASSIGNED_PROTO_251_IP,
	    UNASSIGNED_PROTO_252_IP,
	    UNASSIGNED_PROTO_253_IP,
	    UNASSIGNED_PROTO_254_IP,
	    RESERVED_255_IP,
	    OTHER_IP,
	    FRAG_IP,
	IP6,
	    TCP_IP6,
	      HTTP_S_TCP6,
	      HTTP_C_TCP6,
	      SQUID_TCP6,
	      SMTP_TCP6,
	      NNTP_TCP6,
	      FTP_TCP6,
	      POP3_TCP6,
	      IMAP_TCP6,
	      TELNET_TCP6,
	      SSH_TCP6,
	      DNS_TCP6,
	      BGP_TCP6,
	      NAPSTER_TCP6,
	      REALAUDIO_TCP6,
	      RTSP_TCP6,
	      SHOUTCAST_TCP6,
	      HOTLINE_TCP6,
	      OTHER_TCP6,
	    UDP_IP6,
	      DNS_UDP6,
	      RIP_UDP6,
	      MCAST_UDP6,
	      REALAUDIO_UDP6,
	      HALFLIFE_UDP6,
	      STARCRAFT_UDP6,
	      EVERQUEST_UDP6,
	      UNREAL_UDP6,
	      QUAKE_UDP6,
	      CUSEEME_UDP6,
	      OTHER_UDP6,
	    ICMP_IP6,
	    OSPF_IP6,
	    IP_IP6,
	    IP6_IP6,
	    IPSEC_IP6,
	    HBHOPT_IP6,
	    RTOPT_IP6,
	    DSTOPT_IP6,
	    PIM_IP6,
	    SCTP_IP6,
	    OTHER_IP6,
	    FRAG_IP6, 
	OTHER,
	PROTOTYPE_MAX
};

extern long long int read_count;
extern struct timeval start_time, end_time;
extern struct pkt_cnt tcpdstat[PROTOTYPE_MAX];
extern int packet_length;
extern long long int caplen_total;
extern long int caplen_max;
extern int use_ipflow;
extern double rate_max;
extern double rate_mean;
extern double rate_var;
extern long int rate_count;
extern int debug;

int open_dump(char *);
void close_dump(void);
int read_dump(void);

void pktsize_add(int size);

void ipflow_destroy(void);
void ipflow_show(void);
int ipflow_count(int, struct ip *, int);



