[manpage_begin uevent n 0.2]
[copyright {2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {User events}]
[titledesc {User events}]
[category  {Programming tools}]
[require Tcl 8.4]
[require uevent [opt 0.2]]
[require logger]
[keywords event bind unbind {generate event} hook]
[see_also hook(n)]
[description]

This package provides a general facility for the handling of user
events. Allows the binding of arbitrary commands to arbitrary events
on arbitrary tags, removal of bindings, and event generation.

[para]

The main difference to the event system built into the Tcl/Tk core is
that the latter can generate only virtual events, and only for
widgets. It is not possible to use the builtin facilities to bind to
events on arbitrary (pseudo-)objects, nor is it able to generate
events for such.

[para]

Here we can, by assuming that each object in question is represented
by its own tag. Which is possible as we allow arbitrary tags.

[para]

More differences:

[list_begin enumerated]
[enum]

The package uses only a two-level hierarchy, tags and events, to
handle everything, whereas the Tcl/Tk system uses three levels, i.e.
objects, tags, and events, with a n:m relationship between objects and
tags.

[enum]
This package triggers all bound commands for a tag/event combination,
and they are independent of each other. A bound command cannot force
the event processing core to abort the processing of command coming
after it.

[list_end]

[section API]

The package exports three commands, as specified below:

[list_begin definitions]

[call [cmd ::uevent::bind] [arg tag] [arg event] [arg command]]

Using this command registers the [arg command] prefix to be triggered
when the [arg event] occurs for the [arg tag]. The result of the
command is an opaque token representing the binding. Note that if the
same combination of <[arg tag],[arg event],[arg command]> is used
multiple times the same token is returned by every call.

[para]

The signature of the [arg command] prefix is

[list_begin definitions]
[call [cmd command] [arg tag] [arg event] [arg details]]
[list_end]
[para]

where [arg details] contains the argument(s) of the event. Its
contents are event specific and have to be agreed upon between actual
event generator and consumer. This package simply transfers the
information and does not perform any processing beyond that.


[call [cmd ::uevent::unbind] [arg token]]

This command releases the event binding represented by the
[arg token]. The token has to be the result of a call to
[cmd ::uevent::bind]. The result of the command is the empty string.


[call [cmd ::uevent::generate] [arg tag] [arg event] [opt [arg details]]]

This command generates an [arg event] for the [arg tag], triggering
all commands bound to that combination. The [arg details] argument is
simply passed unchanged to all event handlers. It is the
responsibility of the code generating and consuming the event to have
an agreement about the format and contents of the information carried
therein. The result of the command is the empty string.

[para]

Note that all bound commands are triggered, independently of each
other. The event handlers cannot assume a specific order. They are
also [emph not] called synchronously with the invokation of this
command, but simply put into the event queue for processing when the
system returns to the event loop.

[para]

Generating an event for an unknown tag, or for a
<[arg tag],[arg event]> combination which has no commands bound to it
is allowed, such calls will be ignored.


[call [cmd ::uevent::list]]

In this form the command returns a list containing the names of all
tags which have events with commands bound to them.


[call [cmd ::uevent::list] [arg tag]]

In this format the command returns a list containing the names of all
events for the [arg tag] with commands bound to them. Specifying an
unknown tag, i.e. a tag without event and commands, will cause the
command to throw an error.


[call [cmd ::uevent::list] [arg tag] [arg event]]

In this format the command returns a list containing all commands
bound to the [arg event] for the [arg tag]. Specifying an unknown tag
or unknown event, will cause the command to throw an error.

[list_end]

[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph uevent] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.

[manpage_end]
