
# test that top-level stuff is ignored as C/C++ has no no (well, very
# little) notion of code outside of a function.
package require Itcl
namespace import -force itcl::*

##
# document a global variable
set x 4


##
# @file
# 
#
# @brief Testing various parts of tcl-dox

##
# Tcl-dox can handle object oriented code.
class EvalData {

    # check that extra "stuff" is excluded
    bind foo bar

    # This should be turned into a variable.
    array set Name list

    ##
    # a private member
    private common delay

    ##
    # Initializes the object.
    #
    proc init {} {
        set objMBVParams [MBVParams]
        initializeML
    }

    ##
    # A member function
    #
    # @return 0, always
    proc evalData {} {
        return 0
    }


    ##
    # Sets the delay (in milliseconds) between each iteration
    #
    # @param delay the new delay
    #
    proc setDelay { delay } {
        set lfLSFreq $delay
    }
}
